/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.service;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import java.net.InetAddress;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.cassandra.concurrent.JMXEnabledThreadPoolExecutor;
import org.apache.cassandra.concurrent.NamedThreadFactory;
import org.apache.cassandra.config.Schema;
import org.apache.cassandra.db.Keyspace;
import org.apache.cassandra.dht.Range;
import org.apache.cassandra.dht.Token;
import org.apache.cassandra.locator.AbstractReplicationStrategy;
import org.apache.cassandra.locator.TokenMetadata;
import org.apache.cassandra.service.StorageService;
import org.apache.cassandra.utils.BiMultiValMap;
import org.apache.cassandra.utils.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PendingRangeCalculatorService {
    public static final PendingRangeCalculatorService instance = new PendingRangeCalculatorService();
    private static Logger logger = LoggerFactory.getLogger(PendingRangeCalculatorService.class);
    private final JMXEnabledThreadPoolExecutor executor = new JMXEnabledThreadPoolExecutor(1, Integer.MAX_VALUE, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(1), new NamedThreadFactory("PendingRangeCalculator"), "internal");

    public PendingRangeCalculatorService() {
        this.executor.setRejectedExecutionHandler(new ThreadPoolExecutor.DiscardPolicy());
    }

    public Future<?> update() {
        return this.executor.submit(new PendingRangeTask());
    }

    public void blockUntilFinished() {
        while ((long)this.executor.getActiveCount() + this.executor.getPendingTasks() != 0L) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public static void calculatePendingRanges(AbstractReplicationStrategy strategy, String keyspaceName) {
        TokenMetadata tm = StorageService.instance.getTokenMetadata();
        HashMultimap pendingRanges = HashMultimap.create();
        BiMultiValMap<Token, InetAddress> bootstrapTokens = tm.getBootstrapTokens();
        Set<InetAddress> leavingEndpoints = tm.getLeavingEndpoints();
        if (bootstrapTokens.isEmpty() && leavingEndpoints.isEmpty() && tm.getMovingEndpoints().isEmpty()) {
            if (logger.isDebugEnabled()) {
                logger.debug("No bootstrapping, leaving or moving nodes, and no relocating tokens -> empty pending ranges for {}", (Object)keyspaceName);
            }
            tm.setPendingRanges(keyspaceName, (Multimap<Range<Token>, InetAddress>)pendingRanges);
            return;
        }
        Multimap<InetAddress, Range<Token>> addressRanges = strategy.getAddressRanges();
        TokenMetadata allLeftMetadata = tm.cloneAfterAllLeft();
        HashSet affectedRanges = new HashSet();
        for (InetAddress endpoint : leavingEndpoints) {
            affectedRanges.addAll(addressRanges.get((Object)endpoint));
        }
        TokenMetadata metadata = tm.cloneOnlyTokenMap();
        for (Range range : affectedRanges) {
            ImmutableSet immutableSet = ImmutableSet.copyOf(strategy.calculateNaturalEndpoints((Token)range.right, metadata));
            ImmutableSet newEndpoints = ImmutableSet.copyOf(strategy.calculateNaturalEndpoints((Token)range.right, allLeftMetadata));
            pendingRanges.putAll((Object)range, (Iterable)Sets.difference((Set)newEndpoints, (Set)immutableSet));
        }
        Multimap<InetAddress, Token> bootstrapAddresses = bootstrapTokens.inverse();
        for (InetAddress inetAddress : bootstrapAddresses.keySet()) {
            Collection tokens = bootstrapAddresses.get((Object)inetAddress);
            allLeftMetadata.updateNormalTokens(tokens, inetAddress);
            for (Range range : strategy.getAddressRanges(allLeftMetadata).get((Object)inetAddress)) {
                pendingRanges.put((Object)range, (Object)inetAddress);
            }
            allLeftMetadata.removeEndpoint(inetAddress);
        }
        for (Pair pair : tm.getMovingEndpoints()) {
            InetAddress endpoint = (InetAddress)pair.right;
            allLeftMetadata.updateNormalToken((Token)pair.left, endpoint);
            for (Range range : strategy.getAddressRanges(allLeftMetadata).get((Object)endpoint)) {
                pendingRanges.put((Object)range, (Object)endpoint);
            }
            allLeftMetadata.removeEndpoint(endpoint);
        }
        tm.setPendingRanges(keyspaceName, (Multimap<Range<Token>, InetAddress>)pendingRanges);
        if (logger.isDebugEnabled()) {
            logger.debug("Pending ranges:\n" + (pendingRanges.isEmpty() ? "<empty>" : tm.printPendingRanges()));
        }
    }

    private static class PendingRangeTask
    implements Runnable {
        private PendingRangeTask() {
        }

        @Override
        public void run() {
            long start = System.currentTimeMillis();
            for (String keyspaceName : Schema.instance.getNonSystemKeyspaces()) {
                PendingRangeCalculatorService.calculatePendingRanges(Keyspace.open(keyspaceName).getReplicationStrategy(), keyspaceName);
            }
            logger.debug("finished calculation for {} keyspaces in {}ms", (Object)Schema.instance.getNonSystemKeyspaces().size(), (Object)(System.currentTimeMillis() - start));
        }
    }
}

