/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.repair;

import java.util.HashSet;
import java.util.LinkedList;
import java.util.Queue;
import java.util.Set;

public abstract class RequestCoordinator<R> {
    private final Order<R> orderer;

    public RequestCoordinator(boolean isSequential) {
        this.orderer = isSequential ? new SequentialOrder(this) : new ParallelOrder(this);
    }

    public abstract void send(R var1);

    public void add(R request) {
        this.orderer.add(request);
    }

    public void start() {
        this.orderer.start();
    }

    public int completed(R request) {
        return this.orderer.completed(request);
    }

    private static class ParallelOrder<R>
    extends Order<R> {
        private final Set<R> requests = new HashSet<R>();

        ParallelOrder(RequestCoordinator<R> coordinator) {
            super(coordinator);
        }

        @Override
        public void add(R request) {
            this.requests.add(request);
        }

        @Override
        public void start() {
            for (R request : this.requests) {
                this.coordinator.send(request);
            }
        }

        @Override
        public int completed(R request) {
            this.requests.remove(request);
            return this.requests.size();
        }
    }

    private static class SequentialOrder<R>
    extends Order<R> {
        private final Queue<R> requests = new LinkedList<R>();

        SequentialOrder(RequestCoordinator<R> coordinator) {
            super(coordinator);
        }

        @Override
        public void add(R request) {
            this.requests.add(request);
        }

        @Override
        public void start() {
            if (this.requests.isEmpty()) {
                return;
            }
            this.coordinator.send(this.requests.peek());
        }

        @Override
        public int completed(R request) {
            assert (request.equals(this.requests.peek()));
            this.requests.poll();
            int remaining = this.requests.size();
            if (remaining != 0) {
                this.coordinator.send(this.requests.peek());
            }
            return remaining;
        }
    }

    private static abstract class Order<R> {
        protected final RequestCoordinator<R> coordinator;

        Order(RequestCoordinator<R> coordinator) {
            this.coordinator = coordinator;
        }

        public abstract void add(R var1);

        public abstract void start();

        public abstract int completed(R var1);
    }
}

