// $ANTLR 3.5.2 /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g 2014-11-05 20:53:20

    package org.apache.cassandra.cql3;

    import java.util.ArrayList;
    import java.util.Arrays;
    import java.util.Collections;
    import java.util.EnumSet;
    import java.util.HashSet;
    import java.util.HashMap;
    import java.util.LinkedHashMap;
    import java.util.List;
    import java.util.Map;
    import java.util.Set;

    import org.apache.cassandra.auth.Permission;
    import org.apache.cassandra.auth.DataResource;
    import org.apache.cassandra.auth.IResource;
    import org.apache.cassandra.cql3.*;
    import org.apache.cassandra.cql3.statements.*;
    import org.apache.cassandra.cql3.functions.FunctionCall;
    import org.apache.cassandra.db.marshal.CollectionType;
    import org.apache.cassandra.exceptions.ConfigurationException;
    import org.apache.cassandra.exceptions.InvalidRequestException;
    import org.apache.cassandra.exceptions.SyntaxException;
    import org.apache.cassandra.utils.Pair;


import org.antlr.runtime.*;
import java.util.Stack;
import java.util.List;
import java.util.ArrayList;

@SuppressWarnings("all")
public class CqlParser extends Parser {
	public static final String[] tokenNames = new String[] {
		"<invalid>", "<EOR>", "<DOWN>", "<UP>", "A", "B", "BOOLEAN", "C", "COMMENT", 
		"D", "DIGIT", "E", "EXPONENT", "F", "FLOAT", "G", "H", "HEX", "HEXNUMBER", 
		"I", "IDENT", "INTEGER", "J", "K", "K_ADD", "K_ALL", "K_ALLOW", "K_ALTER", 
		"K_AND", "K_APPLY", "K_AS", "K_ASC", "K_ASCII", "K_AUTHORIZE", "K_BATCH", 
		"K_BEGIN", "K_BIGINT", "K_BLOB", "K_BOOLEAN", "K_BY", "K_CLUSTERING", 
		"K_COLUMNFAMILY", "K_COMPACT", "K_CONTAINS", "K_COUNT", "K_COUNTER", "K_CREATE", 
		"K_CUSTOM", "K_DECIMAL", "K_DELETE", "K_DESC", "K_DISTINCT", "K_DOUBLE", 
		"K_DROP", "K_EXISTS", "K_FILTERING", "K_FLOAT", "K_FROM", "K_FROZEN", 
		"K_GRANT", "K_IF", "K_IN", "K_INDEX", "K_INET", "K_INFINITY", "K_INSERT", 
		"K_INT", "K_INTO", "K_KEY", "K_KEYS", "K_KEYSPACE", "K_KEYSPACES", "K_LIMIT", 
		"K_LIST", "K_MAP", "K_MODIFY", "K_NAN", "K_NORECURSIVE", "K_NOSUPERUSER", 
		"K_NOT", "K_NULL", "K_OF", "K_ON", "K_ORDER", "K_PASSWORD", "K_PERMISSION", 
		"K_PERMISSIONS", "K_PRIMARY", "K_RENAME", "K_REVOKE", "K_SELECT", "K_SET", 
		"K_STATIC", "K_STORAGE", "K_SUPERUSER", "K_TEXT", "K_TIMESTAMP", "K_TIMEUUID", 
		"K_TO", "K_TOKEN", "K_TRIGGER", "K_TRUNCATE", "K_TTL", "K_TUPLE", "K_TYPE", 
		"K_UNLOGGED", "K_UPDATE", "K_USE", "K_USER", "K_USERS", "K_USING", "K_UUID", 
		"K_VALUES", "K_VARCHAR", "K_VARINT", "K_WHERE", "K_WITH", "K_WRITETIME", 
		"L", "LETTER", "M", "MULTILINE_COMMENT", "N", "O", "P", "Q", "QMARK", 
		"QUOTED_NAME", "R", "S", "STRING_LITERAL", "T", "U", "UUID", "V", "W", 
		"WS", "X", "Y", "Z", "'!='", "'('", "')'", "'+'", "','", "'-'", "'.'", 
		"':'", "';'", "'<'", "'<='", "'='", "'>'", "'>='", "'['", "'\\*'", "']'", 
		"'{'", "'}'"
	};
	public static final int EOF=-1;
	public static final int T__140=140;
	public static final int T__141=141;
	public static final int T__142=142;
	public static final int T__143=143;
	public static final int T__144=144;
	public static final int T__145=145;
	public static final int T__146=146;
	public static final int T__147=147;
	public static final int T__148=148;
	public static final int T__149=149;
	public static final int T__150=150;
	public static final int T__151=151;
	public static final int T__152=152;
	public static final int T__153=153;
	public static final int T__154=154;
	public static final int T__155=155;
	public static final int T__156=156;
	public static final int T__157=157;
	public static final int T__158=158;
	public static final int A=4;
	public static final int B=5;
	public static final int BOOLEAN=6;
	public static final int C=7;
	public static final int COMMENT=8;
	public static final int D=9;
	public static final int DIGIT=10;
	public static final int E=11;
	public static final int EXPONENT=12;
	public static final int F=13;
	public static final int FLOAT=14;
	public static final int G=15;
	public static final int H=16;
	public static final int HEX=17;
	public static final int HEXNUMBER=18;
	public static final int I=19;
	public static final int IDENT=20;
	public static final int INTEGER=21;
	public static final int J=22;
	public static final int K=23;
	public static final int K_ADD=24;
	public static final int K_ALL=25;
	public static final int K_ALLOW=26;
	public static final int K_ALTER=27;
	public static final int K_AND=28;
	public static final int K_APPLY=29;
	public static final int K_AS=30;
	public static final int K_ASC=31;
	public static final int K_ASCII=32;
	public static final int K_AUTHORIZE=33;
	public static final int K_BATCH=34;
	public static final int K_BEGIN=35;
	public static final int K_BIGINT=36;
	public static final int K_BLOB=37;
	public static final int K_BOOLEAN=38;
	public static final int K_BY=39;
	public static final int K_CLUSTERING=40;
	public static final int K_COLUMNFAMILY=41;
	public static final int K_COMPACT=42;
	public static final int K_CONTAINS=43;
	public static final int K_COUNT=44;
	public static final int K_COUNTER=45;
	public static final int K_CREATE=46;
	public static final int K_CUSTOM=47;
	public static final int K_DECIMAL=48;
	public static final int K_DELETE=49;
	public static final int K_DESC=50;
	public static final int K_DISTINCT=51;
	public static final int K_DOUBLE=52;
	public static final int K_DROP=53;
	public static final int K_EXISTS=54;
	public static final int K_FILTERING=55;
	public static final int K_FLOAT=56;
	public static final int K_FROM=57;
	public static final int K_FROZEN=58;
	public static final int K_GRANT=59;
	public static final int K_IF=60;
	public static final int K_IN=61;
	public static final int K_INDEX=62;
	public static final int K_INET=63;
	public static final int K_INFINITY=64;
	public static final int K_INSERT=65;
	public static final int K_INT=66;
	public static final int K_INTO=67;
	public static final int K_KEY=68;
	public static final int K_KEYS=69;
	public static final int K_KEYSPACE=70;
	public static final int K_KEYSPACES=71;
	public static final int K_LIMIT=72;
	public static final int K_LIST=73;
	public static final int K_MAP=74;
	public static final int K_MODIFY=75;
	public static final int K_NAN=76;
	public static final int K_NORECURSIVE=77;
	public static final int K_NOSUPERUSER=78;
	public static final int K_NOT=79;
	public static final int K_NULL=80;
	public static final int K_OF=81;
	public static final int K_ON=82;
	public static final int K_ORDER=83;
	public static final int K_PASSWORD=84;
	public static final int K_PERMISSION=85;
	public static final int K_PERMISSIONS=86;
	public static final int K_PRIMARY=87;
	public static final int K_RENAME=88;
	public static final int K_REVOKE=89;
	public static final int K_SELECT=90;
	public static final int K_SET=91;
	public static final int K_STATIC=92;
	public static final int K_STORAGE=93;
	public static final int K_SUPERUSER=94;
	public static final int K_TEXT=95;
	public static final int K_TIMESTAMP=96;
	public static final int K_TIMEUUID=97;
	public static final int K_TO=98;
	public static final int K_TOKEN=99;
	public static final int K_TRIGGER=100;
	public static final int K_TRUNCATE=101;
	public static final int K_TTL=102;
	public static final int K_TUPLE=103;
	public static final int K_TYPE=104;
	public static final int K_UNLOGGED=105;
	public static final int K_UPDATE=106;
	public static final int K_USE=107;
	public static final int K_USER=108;
	public static final int K_USERS=109;
	public static final int K_USING=110;
	public static final int K_UUID=111;
	public static final int K_VALUES=112;
	public static final int K_VARCHAR=113;
	public static final int K_VARINT=114;
	public static final int K_WHERE=115;
	public static final int K_WITH=116;
	public static final int K_WRITETIME=117;
	public static final int L=118;
	public static final int LETTER=119;
	public static final int M=120;
	public static final int MULTILINE_COMMENT=121;
	public static final int N=122;
	public static final int O=123;
	public static final int P=124;
	public static final int Q=125;
	public static final int QMARK=126;
	public static final int QUOTED_NAME=127;
	public static final int R=128;
	public static final int S=129;
	public static final int STRING_LITERAL=130;
	public static final int T=131;
	public static final int U=132;
	public static final int UUID=133;
	public static final int V=134;
	public static final int W=135;
	public static final int WS=136;
	public static final int X=137;
	public static final int Y=138;
	public static final int Z=139;

	// delegates
	public Parser[] getDelegates() {
		return new Parser[] {};
	}

	// delegators


	public CqlParser(TokenStream input) {
		this(input, new RecognizerSharedState());
	}
	public CqlParser(TokenStream input, RecognizerSharedState state) {
		super(input, state);
	}

	@Override public String[] getTokenNames() { return CqlParser.tokenNames; }
	@Override public String getGrammarFileName() { return "/tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g"; }


	    private final List<ErrorListener> listeners = new ArrayList<ErrorListener>();
	    private final List<ColumnIdentifier> bindVariables = new ArrayList<ColumnIdentifier>();

	    public static final Set<String> reservedTypeNames = new HashSet<String>()
	    {{
	        add("byte");
	        add("smallint");
	        add("complex");
	        add("enum");
	        add("date");
	        add("interval");
	        add("macaddr");
	        add("bitstring");
	    }};

	    public AbstractMarker.Raw newBindVariables(ColumnIdentifier name)
	    {
	        AbstractMarker.Raw marker = new AbstractMarker.Raw(bindVariables.size());
	        bindVariables.add(name);
	        return marker;
	    }

	    public AbstractMarker.INRaw newINBindVariables(ColumnIdentifier name)
	    {
	        AbstractMarker.INRaw marker = new AbstractMarker.INRaw(bindVariables.size());
	        bindVariables.add(name);
	        return marker;
	    }

	    public Tuples.Raw newTupleBindVariables(ColumnIdentifier name)
	    {
	        Tuples.Raw marker = new Tuples.Raw(bindVariables.size());
	        bindVariables.add(name);
	        return marker;
	    }

	    public Tuples.INRaw newTupleINBindVariables(ColumnIdentifier name)
	    {
	        Tuples.INRaw marker = new Tuples.INRaw(bindVariables.size());
	        bindVariables.add(name);
	        return marker;
	    }

	    public void addErrorListener(ErrorListener listener)
	    {
	        this.listeners.add(listener);
	    }

	    public void removeErrorListener(ErrorListener listener)
	    {
	        this.listeners.remove(listener);
	    }

	    public void displayRecognitionError(String[] tokenNames, RecognitionException e)
	    {
	        for (int i = 0, m = listeners.size(); i < m; i++)
	            listeners.get(i).syntaxError(this, tokenNames, e);
	    }

	    private void addRecognitionError(String msg)
	    {
	        for (int i = 0, m = listeners.size(); i < m; i++)
	            listeners.get(i).syntaxError(this, msg);
	    }

	    public Map<String, String> convertPropertyMap(Maps.Literal map)
	    {
	        if (map == null || map.entries == null || map.entries.isEmpty())
	            return Collections.<String, String>emptyMap();

	        Map<String, String> res = new HashMap<String, String>(map.entries.size());

	        for (Pair<Term.Raw, Term.Raw> entry : map.entries)
	        {
	            // Because the parser tries to be smart and recover on error (to
	            // allow displaying more than one error I suppose), we have null
	            // entries in there. Just skip those, a proper error will be thrown in the end.
	            if (entry.left == null || entry.right == null)
	                break;

	            if (!(entry.left instanceof Constants.Literal))
	            {
	                String msg = "Invalid property name: " + entry.left;
	                if (entry.left instanceof AbstractMarker.Raw)
	                    msg += " (bind variables are not supported in DDL queries)";
	                addRecognitionError(msg);
	                break;
	            }
	            if (!(entry.right instanceof Constants.Literal))
	            {
	                String msg = "Invalid property value: " + entry.right + " for property: " + entry.left;
	                if (entry.right instanceof AbstractMarker.Raw)
	                    msg += " (bind variables are not supported in DDL queries)";
	                addRecognitionError(msg);
	                break;
	            }

	            res.put(((Constants.Literal)entry.left).getRawText(), ((Constants.Literal)entry.right).getRawText());
	        }

	        return res;
	    }

	    public void addRawUpdate(List<Pair<ColumnIdentifier.Raw, Operation.RawUpdate>> operations, ColumnIdentifier.Raw key, Operation.RawUpdate update)
	    {
	        for (Pair<ColumnIdentifier.Raw, Operation.RawUpdate> p : operations)
	        {
	            if (p.left.equals(key) && !p.right.isCompatibleWith(update))
	                addRecognitionError("Multiple incompatible setting of column " + key);
	        }
	        operations.add(Pair.create(key, update));
	    }



	// $ANTLR start "query"
	// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:212:1: query returns [ParsedStatement stmnt] : st= cqlStatement ( ';' )* EOF ;
	public final ParsedStatement query() throws RecognitionException {
		ParsedStatement stmnt = null;


		ParsedStatement st =null;

		try {
			// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:213:5: (st= cqlStatement ( ';' )* EOF )
			// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:213:7: st= cqlStatement ( ';' )* EOF
			{
			pushFollow(FOLLOW_cqlStatement_in_query72);
			st=cqlStatement();
			state._fsp--;

			// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:213:23: ( ';' )*
			loop1:
			while (true) {
				int alt1=2;
				int LA1_0 = input.LA(1);
				if ( (LA1_0==148) ) {
					alt1=1;
				}

				switch (alt1) {
				case 1 :
					// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:213:24: ';'
					{
					match(input,148,FOLLOW_148_in_query75); 
					}
					break;

				default :
					break loop1;
				}
			}

			match(input,EOF,FOLLOW_EOF_in_query79); 
			 stmnt = st; 
			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return stmnt;
	}
	// $ANTLR end "query"



	// $ANTLR start "cqlStatement"
	// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:216:1: cqlStatement returns [ParsedStatement stmt] : (st1= selectStatement |st2= insertStatement |st3= updateStatement |st4= batchStatement |st5= deleteStatement |st6= useStatement |st7= truncateStatement |st8= createKeyspaceStatement |st9= createTableStatement |st10= createIndexStatement |st11= dropKeyspaceStatement |st12= dropTableStatement |st13= dropIndexStatement |st14= alterTableStatement |st15= alterKeyspaceStatement |st16= grantStatement |st17= revokeStatement |st18= listPermissionsStatement |st19= createUserStatement |st20= alterUserStatement |st21= dropUserStatement |st22= listUsersStatement |st23= createTriggerStatement |st24= dropTriggerStatement |st25= createTypeStatement |st26= alterTypeStatement |st27= dropTypeStatement );
	public final ParsedStatement cqlStatement() throws RecognitionException {
		ParsedStatement stmt = null;


		SelectStatement.RawStatement st1 =null;
		UpdateStatement.ParsedInsert st2 =null;
		UpdateStatement.ParsedUpdate st3 =null;
		BatchStatement.Parsed st4 =null;
		DeleteStatement.Parsed st5 =null;
		UseStatement st6 =null;
		TruncateStatement st7 =null;
		CreateKeyspaceStatement st8 =null;
		CreateTableStatement.RawStatement st9 =null;
		CreateIndexStatement st10 =null;
		DropKeyspaceStatement st11 =null;
		DropTableStatement st12 =null;
		DropIndexStatement st13 =null;
		AlterTableStatement st14 =null;
		AlterKeyspaceStatement st15 =null;
		GrantStatement st16 =null;
		RevokeStatement st17 =null;
		ListPermissionsStatement st18 =null;
		CreateUserStatement st19 =null;
		AlterUserStatement st20 =null;
		DropUserStatement st21 =null;
		ListUsersStatement st22 =null;
		CreateTriggerStatement st23 =null;
		DropTriggerStatement st24 =null;
		CreateTypeStatement st25 =null;
		AlterTypeStatement st26 =null;
		DropTypeStatement st27 =null;

		try {
			// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:218:5: (st1= selectStatement |st2= insertStatement |st3= updateStatement |st4= batchStatement |st5= deleteStatement |st6= useStatement |st7= truncateStatement |st8= createKeyspaceStatement |st9= createTableStatement |st10= createIndexStatement |st11= dropKeyspaceStatement |st12= dropTableStatement |st13= dropIndexStatement |st14= alterTableStatement |st15= alterKeyspaceStatement |st16= grantStatement |st17= revokeStatement |st18= listPermissionsStatement |st19= createUserStatement |st20= alterUserStatement |st21= dropUserStatement |st22= listUsersStatement |st23= createTriggerStatement |st24= dropTriggerStatement |st25= createTypeStatement |st26= alterTypeStatement |st27= dropTypeStatement )
			int alt2=27;
			switch ( input.LA(1) ) {
			case K_SELECT:
				{
				alt2=1;
				}
				break;
			case K_INSERT:
				{
				alt2=2;
				}
				break;
			case K_UPDATE:
				{
				alt2=3;
				}
				break;
			case K_BEGIN:
				{
				alt2=4;
				}
				break;
			case K_DELETE:
				{
				alt2=5;
				}
				break;
			case K_USE:
				{
				alt2=6;
				}
				break;
			case K_TRUNCATE:
				{
				alt2=7;
				}
				break;
			case K_CREATE:
				{
				switch ( input.LA(2) ) {
				case K_KEYSPACE:
					{
					alt2=8;
					}
					break;
				case K_COLUMNFAMILY:
					{
					alt2=9;
					}
					break;
				case K_USER:
					{
					alt2=19;
					}
					break;
				case K_TRIGGER:
					{
					alt2=23;
					}
					break;
				case K_TYPE:
					{
					alt2=25;
					}
					break;
				case K_CUSTOM:
				case K_INDEX:
					{
					alt2=10;
					}
					break;
				default:
					int nvaeMark = input.mark();
					try {
						input.consume();
						NoViableAltException nvae =
							new NoViableAltException("", 2, 8, input);
						throw nvae;
					} finally {
						input.rewind(nvaeMark);
					}
				}
				}
				break;
			case K_DROP:
				{
				switch ( input.LA(2) ) {
				case K_KEYSPACE:
					{
					alt2=11;
					}
					break;
				case K_COLUMNFAMILY:
					{
					alt2=12;
					}
					break;
				case K_INDEX:
					{
					alt2=13;
					}
					break;
				case K_USER:
					{
					alt2=21;
					}
					break;
				case K_TRIGGER:
					{
					alt2=24;
					}
					break;
				case K_TYPE:
					{
					alt2=27;
					}
					break;
				default:
					int nvaeMark = input.mark();
					try {
						input.consume();
						NoViableAltException nvae =
							new NoViableAltException("", 2, 9, input);
						throw nvae;
					} finally {
						input.rewind(nvaeMark);
					}
				}
				}
				break;
			case K_ALTER:
				{
				switch ( input.LA(2) ) {
				case K_COLUMNFAMILY:
					{
					alt2=14;
					}
					break;
				case K_KEYSPACE:
					{
					alt2=15;
					}
					break;
				case K_USER:
					{
					alt2=20;
					}
					break;
				case K_TYPE:
					{
					alt2=26;
					}
					break;
				default:
					int nvaeMark = input.mark();
					try {
						input.consume();
						NoViableAltException nvae =
							new NoViableAltException("", 2, 10, input);
						throw nvae;
					} finally {
						input.rewind(nvaeMark);
					}
				}
				}
				break;
			case K_GRANT:
				{
				alt2=16;
				}
				break;
			case K_REVOKE:
				{
				alt2=17;
				}
				break;
			case K_LIST:
				{
				int LA2_13 = input.LA(2);
				if ( (LA2_13==K_USERS) ) {
					alt2=22;
				}
				else if ( (LA2_13==K_ALL||LA2_13==K_ALTER||LA2_13==K_AUTHORIZE||LA2_13==K_CREATE||LA2_13==K_DROP||LA2_13==K_MODIFY||LA2_13==K_SELECT) ) {
					alt2=18;
				}

				else {
					int nvaeMark = input.mark();
					try {
						input.consume();
						NoViableAltException nvae =
							new NoViableAltException("", 2, 13, input);
						throw nvae;
					} finally {
						input.rewind(nvaeMark);
					}
				}

				}
				break;
			default:
				NoViableAltException nvae =
					new NoViableAltException("", 2, 0, input);
				throw nvae;
			}
			switch (alt2) {
				case 1 :
					// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:218:7: st1= selectStatement
					{
					pushFollow(FOLLOW_selectStatement_in_cqlStatement113);
					st1=selectStatement();
					state._fsp--;

					 stmt = st1; 
					}
					break;
				case 2 :
					// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:219:7: st2= insertStatement
					{
					pushFollow(FOLLOW_insertStatement_in_cqlStatement138);
					st2=insertStatement();
					state._fsp--;

					 stmt = st2; 
					}
					break;
				case 3 :
					// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:220:7: st3= updateStatement
					{
					pushFollow(FOLLOW_updateStatement_in_cqlStatement163);
					st3=updateStatement();
					state._fsp--;

					 stmt = st3; 
					}
					break;
				case 4 :
					// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:221:7: st4= batchStatement
					{
					pushFollow(FOLLOW_batchStatement_in_cqlStatement188);
					st4=batchStatement();
					state._fsp--;

					 stmt = st4; 
					}
					break;
				case 5 :
					// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:222:7: st5= deleteStatement
					{
					pushFollow(FOLLOW_deleteStatement_in_cqlStatement214);
					st5=deleteStatement();
					state._fsp--;

					 stmt = st5; 
					}
					break;
				case 6 :
					// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:223:7: st6= useStatement
					{
					pushFollow(FOLLOW_useStatement_in_cqlStatement239);
					st6=useStatement();
					state._fsp--;

					 stmt = st6; 
					}
					break;
				case 7 :
					// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:224:7: st7= truncateStatement
					{
					pushFollow(FOLLOW_truncateStatement_in_cqlStatement267);
					st7=truncateStatement();
					state._fsp--;

					 stmt = st7; 
					}
					break;
				case 8 :
					// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:225:7: st8= createKeyspaceStatement
					{
					pushFollow(FOLLOW_createKeyspaceStatement_in_cqlStatement290);
					st8=createKeyspaceStatement();
					state._fsp--;

					 stmt = st8; 
					}
					break;
				case 9 :
					// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:226:7: st9= createTableStatement
					{
					pushFollow(FOLLOW_createTableStatement_in_cqlStatement307);
					st9=createTableStatement();
					state._fsp--;

					 stmt = st9; 
					}
					break;
				case 10 :
					// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:227:7: st10= createIndexStatement
					{
					pushFollow(FOLLOW_createIndexStatement_in_cqlStatement326);
					st10=createIndexStatement();
					state._fsp--;

					 stmt = st10; 
					}
					break;
				case 11 :
					// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:228:7: st11= dropKeyspaceStatement
					{
					pushFollow(FOLLOW_dropKeyspaceStatement_in_cqlStatement345);
					st11=dropKeyspaceStatement();
					state._fsp--;

					 stmt = st11; 
					}
					break;
				case 12 :
					// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:229:7: st12= dropTableStatement
					{
					pushFollow(FOLLOW_dropTableStatement_in_cqlStatement363);
					st12=dropTableStatement();
					state._fsp--;

					 stmt = st12; 
					}
					break;
				case 13 :
					// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:230:7: st13= dropIndexStatement
					{
					pushFollow(FOLLOW_dropIndexStatement_in_cqlStatement384);
					st13=dropIndexStatement();
					state._fsp--;

					 stmt = st13; 
					}
					break;
				case 14 :
					// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:231:7: st14= alterTableStatement
					{
					pushFollow(FOLLOW_alterTableStatement_in_cqlStatement405);
					st14=alterTableStatement();
					state._fsp--;

					 stmt = st14; 
					}
					break;
				case 15 :
					// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:232:7: st15= alterKeyspaceStatement
					{
					pushFollow(FOLLOW_alterKeyspaceStatement_in_cqlStatement425);
					st15=alterKeyspaceStatement();
					state._fsp--;

					 stmt = st15; 
					}
					break;
				case 16 :
					// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:233:7: st16= grantStatement
					{
					pushFollow(FOLLOW_grantStatement_in_cqlStatement442);
					st16=grantStatement();
					state._fsp--;

					 stmt = st16; 
					}
					break;
				case 17 :
					// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:234:7: st17= revokeStatement
					{
					pushFollow(FOLLOW_revokeStatement_in_cqlStatement467);
					st17=revokeStatement();
					state._fsp--;

					 stmt = st17; 
					}
					break;
				case 18 :
					// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:235:7: st18= listPermissionsStatement
					{
					pushFollow(FOLLOW_listPermissionsStatement_in_cqlStatement491);
					st18=listPermissionsStatement();
					state._fsp--;

					 stmt = st18; 
					}
					break;
				case 19 :
					// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:236:7: st19= createUserStatement
					{
					pushFollow(FOLLOW_createUserStatement_in_cqlStatement506);
					st19=createUserStatement();
					state._fsp--;

					 stmt = st19; 
					}
					break;
				case 20 :
					// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:237:7: st20= alterUserStatement
					{
					pushFollow(FOLLOW_alterUserStatement_in_cqlStatement526);
					st20=alterUserStatement();
					state._fsp--;

					 stmt = st20; 
					}
					break;
				case 21 :
					// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:238:7: st21= dropUserStatement
					{
					pushFollow(FOLLOW_dropUserStatement_in_cqlStatement547);
					st21=dropUserStatement();
					state._fsp--;

					 stmt = st21; 
					}
					break;
				case 22 :
					// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:239:7: st22= listUsersStatement
					{
					pushFollow(FOLLOW_listUsersStatement_in_cqlStatement569);
					st22=listUsersStatement();
					state._fsp--;

					 stmt = st22; 
					}
					break;
				case 23 :
					// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:240:7: st23= createTriggerStatement
					{
					pushFollow(FOLLOW_createTriggerStatement_in_cqlStatement590);
					st23=createTriggerStatement();
					state._fsp--;

					 stmt = st23; 
					}
					break;
				case 24 :
					// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:241:7: st24= dropTriggerStatement
					{
					pushFollow(FOLLOW_dropTriggerStatement_in_cqlStatement607);
					st24=dropTriggerStatement();
					state._fsp--;

					 stmt = st24; 
					}
					break;
				case 25 :
					// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:242:7: st25= createTypeStatement
					{
					pushFollow(FOLLOW_createTypeStatement_in_cqlStatement626);
					st25=createTypeStatement();
					state._fsp--;

					 stmt = st25; 
					}
					break;
				case 26 :
					// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:243:7: st26= alterTypeStatement
					{
					pushFollow(FOLLOW_alterTypeStatement_in_cqlStatement646);
					st26=alterTypeStatement();
					state._fsp--;

					 stmt = st26; 
					}
					break;
				case 27 :
					// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:244:7: st27= dropTypeStatement
					{
					pushFollow(FOLLOW_dropTypeStatement_in_cqlStatement667);
					st27=dropTypeStatement();
					state._fsp--;

					 stmt = st27; 
					}
					break;

			}
			 if (stmt != null) stmt.setBoundVariables(bindVariables); 
		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return stmt;
	}
	// $ANTLR end "cqlStatement"



	// $ANTLR start "useStatement"
	// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:250:1: useStatement returns [UseStatement stmt] : K_USE ks= keyspaceName ;
	public final UseStatement useStatement() throws RecognitionException {
		UseStatement stmt = null;


		String ks =null;

		try {
			// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:251:5: ( K_USE ks= keyspaceName )
			// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:251:7: K_USE ks= keyspaceName
			{
			match(input,K_USE,FOLLOW_K_USE_in_useStatement702); 
			pushFollow(FOLLOW_keyspaceName_in_useStatement706);
			ks=keyspaceName();
			state._fsp--;

			 stmt = new UseStatement(ks); 
			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return stmt;
	}
	// $ANTLR end "useStatement"



	// $ANTLR start "selectStatement"
	// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:260:1: selectStatement returns [SelectStatement.RawStatement expr] : K_SELECT ( ( K_DISTINCT )? sclause= selectClause | ( K_COUNT '(' sclause= selectCountClause ')' ( K_AS c= ident )? ) ) K_FROM cf= columnFamilyName ( K_WHERE wclause= whereClause )? ( K_ORDER K_BY orderByClause[orderings] ( ',' orderByClause[orderings] )* )? ( K_LIMIT rows= intValue )? ( K_ALLOW K_FILTERING )? ;
	public final SelectStatement.RawStatement selectStatement() throws RecognitionException {
		SelectStatement.RawStatement expr = null;


		List<RawSelector> sclause =null;
		ColumnIdentifier c =null;
		CFName cf =null;
		List<Relation> wclause =null;
		Term.Raw rows =null;


		        boolean isDistinct = false;
		        boolean isCount = false;
		        ColumnIdentifier countAlias = null;
		        Term.Raw limit = null;
		        Map<ColumnIdentifier.Raw, Boolean> orderings = new LinkedHashMap<ColumnIdentifier.Raw, Boolean>();
		        boolean allowFiltering = false;
		    
		try {
			// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:269:5: ( K_SELECT ( ( K_DISTINCT )? sclause= selectClause | ( K_COUNT '(' sclause= selectCountClause ')' ( K_AS c= ident )? ) ) K_FROM cf= columnFamilyName ( K_WHERE wclause= whereClause )? ( K_ORDER K_BY orderByClause[orderings] ( ',' orderByClause[orderings] )* )? ( K_LIMIT rows= intValue )? ( K_ALLOW K_FILTERING )? )
			// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:269:7: K_SELECT ( ( K_DISTINCT )? sclause= selectClause | ( K_COUNT '(' sclause= selectCountClause ')' ( K_AS c= ident )? ) ) K_FROM cf= columnFamilyName ( K_WHERE wclause= whereClause )? ( K_ORDER K_BY orderByClause[orderings] ( ',' orderByClause[orderings] )* )? ( K_LIMIT rows= intValue )? ( K_ALLOW K_FILTERING )?
			{
			match(input,K_SELECT,FOLLOW_K_SELECT_in_selectStatement740); 
			// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:269:16: ( ( K_DISTINCT )? sclause= selectClause | ( K_COUNT '(' sclause= selectCountClause ')' ( K_AS c= ident )? ) )
			int alt5=2;
			int LA5_0 = input.LA(1);
			if ( (LA5_0==IDENT||LA5_0==K_ALL||LA5_0==K_AS||LA5_0==K_ASCII||(LA5_0 >= K_BIGINT && LA5_0 <= K_BOOLEAN)||LA5_0==K_CLUSTERING||(LA5_0 >= K_COMPACT && LA5_0 <= K_CONTAINS)||LA5_0==K_COUNTER||(LA5_0 >= K_CUSTOM && LA5_0 <= K_DECIMAL)||(LA5_0 >= K_DISTINCT && LA5_0 <= K_DOUBLE)||(LA5_0 >= K_EXISTS && LA5_0 <= K_FLOAT)||LA5_0==K_INET||LA5_0==K_INT||(LA5_0 >= K_KEY && LA5_0 <= K_KEYS)||LA5_0==K_KEYSPACES||(LA5_0 >= K_LIST && LA5_0 <= K_MAP)||LA5_0==K_NOSUPERUSER||(LA5_0 >= K_PASSWORD && LA5_0 <= K_PERMISSIONS)||(LA5_0 >= K_STATIC && LA5_0 <= K_TIMEUUID)||(LA5_0 >= K_TOKEN && LA5_0 <= K_TRIGGER)||LA5_0==K_TTL||LA5_0==K_TYPE||(LA5_0 >= K_USER && LA5_0 <= K_USERS)||(LA5_0 >= K_UUID && LA5_0 <= K_VARINT)||LA5_0==K_WRITETIME||LA5_0==QUOTED_NAME||LA5_0==155) ) {
				alt5=1;
			}
			else if ( (LA5_0==K_COUNT) ) {
				int LA5_2 = input.LA(2);
				if ( (LA5_2==141) ) {
					alt5=2;
				}
				else if ( (LA5_2==K_AS||LA5_2==K_FROM||LA5_2==144||LA5_2==146) ) {
					alt5=1;
				}

				else {
					int nvaeMark = input.mark();
					try {
						input.consume();
						NoViableAltException nvae =
							new NoViableAltException("", 5, 2, input);
						throw nvae;
					} finally {
						input.rewind(nvaeMark);
					}
				}

			}

			else {
				NoViableAltException nvae =
					new NoViableAltException("", 5, 0, input);
				throw nvae;
			}

			switch (alt5) {
				case 1 :
					// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:269:18: ( K_DISTINCT )? sclause= selectClause
					{
					// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:269:18: ( K_DISTINCT )?
					int alt3=2;
					int LA3_0 = input.LA(1);
					if ( (LA3_0==K_DISTINCT) ) {
						int LA3_1 = input.LA(2);
						if ( (LA3_1==IDENT||LA3_1==K_ALL||LA3_1==K_ASCII||(LA3_1 >= K_BIGINT && LA3_1 <= K_BOOLEAN)||LA3_1==K_CLUSTERING||(LA3_1 >= K_COMPACT && LA3_1 <= K_COUNTER)||(LA3_1 >= K_CUSTOM && LA3_1 <= K_DECIMAL)||(LA3_1 >= K_DISTINCT && LA3_1 <= K_DOUBLE)||(LA3_1 >= K_EXISTS && LA3_1 <= K_FLOAT)||LA3_1==K_INET||LA3_1==K_INT||(LA3_1 >= K_KEY && LA3_1 <= K_KEYS)||LA3_1==K_KEYSPACES||(LA3_1 >= K_LIST && LA3_1 <= K_MAP)||LA3_1==K_NOSUPERUSER||(LA3_1 >= K_PASSWORD && LA3_1 <= K_PERMISSIONS)||(LA3_1 >= K_STATIC && LA3_1 <= K_TIMEUUID)||(LA3_1 >= K_TOKEN && LA3_1 <= K_TRIGGER)||LA3_1==K_TTL||LA3_1==K_TYPE||(LA3_1 >= K_USER && LA3_1 <= K_USERS)||(LA3_1 >= K_UUID && LA3_1 <= K_VARINT)||LA3_1==K_WRITETIME||LA3_1==QUOTED_NAME||LA3_1==155) ) {
							alt3=1;
						}
						else if ( (LA3_1==K_AS) ) {
							int LA3_4 = input.LA(3);
							if ( (LA3_4==K_FROM||LA3_4==141||LA3_4==144||LA3_4==146) ) {
								alt3=1;
							}
							else if ( (LA3_4==K_AS) ) {
								int LA3_5 = input.LA(4);
								if ( (LA3_5==IDENT||LA3_5==K_ALL||LA3_5==K_AS||LA3_5==K_ASCII||(LA3_5 >= K_BIGINT && LA3_5 <= K_BOOLEAN)||LA3_5==K_CLUSTERING||(LA3_5 >= K_COMPACT && LA3_5 <= K_COUNTER)||(LA3_5 >= K_CUSTOM && LA3_5 <= K_DECIMAL)||(LA3_5 >= K_DISTINCT && LA3_5 <= K_DOUBLE)||(LA3_5 >= K_EXISTS && LA3_5 <= K_FLOAT)||LA3_5==K_INET||LA3_5==K_INT||(LA3_5 >= K_KEY && LA3_5 <= K_KEYS)||LA3_5==K_KEYSPACES||(LA3_5 >= K_LIST && LA3_5 <= K_MAP)||LA3_5==K_NOSUPERUSER||(LA3_5 >= K_PASSWORD && LA3_5 <= K_PERMISSIONS)||(LA3_5 >= K_STATIC && LA3_5 <= K_TIMEUUID)||LA3_5==K_TRIGGER||LA3_5==K_TTL||LA3_5==K_TYPE||(LA3_5 >= K_USER && LA3_5 <= K_USERS)||(LA3_5 >= K_UUID && LA3_5 <= K_VARINT)||LA3_5==K_WRITETIME||LA3_5==QUOTED_NAME) ) {
									alt3=1;
								}
							}
						}
					}
					switch (alt3) {
						case 1 :
							// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:269:20: K_DISTINCT
							{
							match(input,K_DISTINCT,FOLLOW_K_DISTINCT_in_selectStatement746); 
							 isDistinct = true; 
							}
							break;

					}

					pushFollow(FOLLOW_selectClause_in_selectStatement755);
					sclause=selectClause();
					state._fsp--;

					}
					break;
				case 2 :
					// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:270:18: ( K_COUNT '(' sclause= selectCountClause ')' ( K_AS c= ident )? )
					{
					// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:270:18: ( K_COUNT '(' sclause= selectCountClause ')' ( K_AS c= ident )? )
					// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:270:19: K_COUNT '(' sclause= selectCountClause ')' ( K_AS c= ident )?
					{
					match(input,K_COUNT,FOLLOW_K_COUNT_in_selectStatement775); 
					match(input,141,FOLLOW_141_in_selectStatement777); 
					pushFollow(FOLLOW_selectCountClause_in_selectStatement781);
					sclause=selectCountClause();
					state._fsp--;

					match(input,142,FOLLOW_142_in_selectStatement783); 
					 isCount = true; 
					// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:270:81: ( K_AS c= ident )?
					int alt4=2;
					int LA4_0 = input.LA(1);
					if ( (LA4_0==K_AS) ) {
						alt4=1;
					}
					switch (alt4) {
						case 1 :
							// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:270:82: K_AS c= ident
							{
							match(input,K_AS,FOLLOW_K_AS_in_selectStatement788); 
							pushFollow(FOLLOW_ident_in_selectStatement792);
							c=ident();
							state._fsp--;

							 countAlias = c; 
							}
							break;

					}

					}

					}
					break;

			}

			match(input,K_FROM,FOLLOW_K_FROM_in_selectStatement807); 
			pushFollow(FOLLOW_columnFamilyName_in_selectStatement811);
			cf=columnFamilyName();
			state._fsp--;

			// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:272:7: ( K_WHERE wclause= whereClause )?
			int alt6=2;
			int LA6_0 = input.LA(1);
			if ( (LA6_0==K_WHERE) ) {
				alt6=1;
			}
			switch (alt6) {
				case 1 :
					// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:272:9: K_WHERE wclause= whereClause
					{
					match(input,K_WHERE,FOLLOW_K_WHERE_in_selectStatement821); 
					pushFollow(FOLLOW_whereClause_in_selectStatement825);
					wclause=whereClause();
					state._fsp--;

					}
					break;

			}

			// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:273:7: ( K_ORDER K_BY orderByClause[orderings] ( ',' orderByClause[orderings] )* )?
			int alt8=2;
			int LA8_0 = input.LA(1);
			if ( (LA8_0==K_ORDER) ) {
				alt8=1;
			}
			switch (alt8) {
				case 1 :
					// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:273:9: K_ORDER K_BY orderByClause[orderings] ( ',' orderByClause[orderings] )*
					{
					match(input,K_ORDER,FOLLOW_K_ORDER_in_selectStatement838); 
					match(input,K_BY,FOLLOW_K_BY_in_selectStatement840); 
					pushFollow(FOLLOW_orderByClause_in_selectStatement842);
					orderByClause(orderings);
					state._fsp--;

					// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:273:47: ( ',' orderByClause[orderings] )*
					loop7:
					while (true) {
						int alt7=2;
						int LA7_0 = input.LA(1);
						if ( (LA7_0==144) ) {
							alt7=1;
						}

						switch (alt7) {
						case 1 :
							// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:273:49: ',' orderByClause[orderings]
							{
							match(input,144,FOLLOW_144_in_selectStatement847); 
							pushFollow(FOLLOW_orderByClause_in_selectStatement849);
							orderByClause(orderings);
							state._fsp--;

							}
							break;

						default :
							break loop7;
						}
					}

					}
					break;

			}

			// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:274:7: ( K_LIMIT rows= intValue )?
			int alt9=2;
			int LA9_0 = input.LA(1);
			if ( (LA9_0==K_LIMIT) ) {
				alt9=1;
			}
			switch (alt9) {
				case 1 :
					// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:274:9: K_LIMIT rows= intValue
					{
					match(input,K_LIMIT,FOLLOW_K_LIMIT_in_selectStatement866); 
					pushFollow(FOLLOW_intValue_in_selectStatement870);
					rows=intValue();
					state._fsp--;

					 limit = rows; 
					}
					break;

			}

			// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:275:7: ( K_ALLOW K_FILTERING )?
			int alt10=2;
			int LA10_0 = input.LA(1);
			if ( (LA10_0==K_ALLOW) ) {
				alt10=1;
			}
			switch (alt10) {
				case 1 :
					// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:275:9: K_ALLOW K_FILTERING
					{
					match(input,K_ALLOW,FOLLOW_K_ALLOW_in_selectStatement885); 
					match(input,K_FILTERING,FOLLOW_K_FILTERING_in_selectStatement887); 
					 allowFiltering = true; 
					}
					break;

			}


			          SelectStatement.Parameters params = new SelectStatement.Parameters(orderings,
			                                                                             isDistinct,
			                                                                             isCount,
			                                                                             countAlias,
			                                                                             allowFiltering);
			          expr = new SelectStatement.RawStatement(cf, params, sclause, wclause, limit);
			      
			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return expr;
	}
	// $ANTLR end "selectStatement"



	// $ANTLR start "selectClause"
	// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:286:1: selectClause returns [List<RawSelector> expr] : (t1= selector ( ',' tN= selector )* | '\\*' );
	public final List<RawSelector> selectClause() throws RecognitionException {
		List<RawSelector> expr = null;


		RawSelector t1 =null;
		RawSelector tN =null;

		try {
			// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:287:5: (t1= selector ( ',' tN= selector )* | '\\*' )
			int alt12=2;
			int LA12_0 = input.LA(1);
			if ( (LA12_0==IDENT||LA12_0==K_ALL||LA12_0==K_AS||LA12_0==K_ASCII||(LA12_0 >= K_BIGINT && LA12_0 <= K_BOOLEAN)||LA12_0==K_CLUSTERING||(LA12_0 >= K_COMPACT && LA12_0 <= K_COUNTER)||(LA12_0 >= K_CUSTOM && LA12_0 <= K_DECIMAL)||(LA12_0 >= K_DISTINCT && LA12_0 <= K_DOUBLE)||(LA12_0 >= K_EXISTS && LA12_0 <= K_FLOAT)||LA12_0==K_INET||LA12_0==K_INT||(LA12_0 >= K_KEY && LA12_0 <= K_KEYS)||LA12_0==K_KEYSPACES||(LA12_0 >= K_LIST && LA12_0 <= K_MAP)||LA12_0==K_NOSUPERUSER||(LA12_0 >= K_PASSWORD && LA12_0 <= K_PERMISSIONS)||(LA12_0 >= K_STATIC && LA12_0 <= K_TIMEUUID)||(LA12_0 >= K_TOKEN && LA12_0 <= K_TRIGGER)||LA12_0==K_TTL||LA12_0==K_TYPE||(LA12_0 >= K_USER && LA12_0 <= K_USERS)||(LA12_0 >= K_UUID && LA12_0 <= K_VARINT)||LA12_0==K_WRITETIME||LA12_0==QUOTED_NAME) ) {
				alt12=1;
			}
			else if ( (LA12_0==155) ) {
				alt12=2;
			}

			else {
				NoViableAltException nvae =
					new NoViableAltException("", 12, 0, input);
				throw nvae;
			}

			switch (alt12) {
				case 1 :
					// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:287:7: t1= selector ( ',' tN= selector )*
					{
					pushFollow(FOLLOW_selector_in_selectClause924);
					t1=selector();
					state._fsp--;

					 expr = new ArrayList<RawSelector>(); expr.add(t1); 
					// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:287:76: ( ',' tN= selector )*
					loop11:
					while (true) {
						int alt11=2;
						int LA11_0 = input.LA(1);
						if ( (LA11_0==144) ) {
							alt11=1;
						}

						switch (alt11) {
						case 1 :
							// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:287:77: ',' tN= selector
							{
							match(input,144,FOLLOW_144_in_selectClause929); 
							pushFollow(FOLLOW_selector_in_selectClause933);
							tN=selector();
							state._fsp--;

							 expr.add(tN); 
							}
							break;

						default :
							break loop11;
						}
					}

					}
					break;
				case 2 :
					// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:288:7: '\\*'
					{
					match(input,155,FOLLOW_155_in_selectClause945); 
					 expr = Collections.<RawSelector>emptyList();
					}
					break;

			}
		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return expr;
	}
	// $ANTLR end "selectClause"



	// $ANTLR start "selector"
	// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:291:1: selector returns [RawSelector s] : us= unaliasedSelector ( K_AS c= ident )? ;
	public final RawSelector selector() throws RecognitionException {
		RawSelector s = null;


		Selectable.Raw us =null;
		ColumnIdentifier c =null;

		 ColumnIdentifier alias = null; 
		try {
			// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:293:5: (us= unaliasedSelector ( K_AS c= ident )? )
			// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:293:7: us= unaliasedSelector ( K_AS c= ident )?
			{
			pushFollow(FOLLOW_unaliasedSelector_in_selector978);
			us=unaliasedSelector();
			state._fsp--;

			// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:293:28: ( K_AS c= ident )?
			int alt13=2;
			int LA13_0 = input.LA(1);
			if ( (LA13_0==K_AS) ) {
				alt13=1;
			}
			switch (alt13) {
				case 1 :
					// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:293:29: K_AS c= ident
					{
					match(input,K_AS,FOLLOW_K_AS_in_selector981); 
					pushFollow(FOLLOW_ident_in_selector985);
					c=ident();
					state._fsp--;

					 alias = c; 
					}
					break;

			}

			 s = new RawSelector(us, alias); 
			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return s;
	}
	// $ANTLR end "selector"



	// $ANTLR start "unaliasedSelector"
	// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:296:1: unaliasedSelector returns [Selectable.Raw s] : (c= cident | K_WRITETIME '(' c= cident ')' | K_TTL '(' c= cident ')' |f= functionName args= selectionFunctionArgs ) ( '.' fi= cident )* ;
	public final Selectable.Raw unaliasedSelector() throws RecognitionException {
		Selectable.Raw s = null;


		ColumnIdentifier.Raw c =null;
		String f =null;
		List<Selectable.Raw> args =null;
		ColumnIdentifier.Raw fi =null;

		 Selectable.Raw tmp = null; 
		try {
			// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:298:5: ( (c= cident | K_WRITETIME '(' c= cident ')' | K_TTL '(' c= cident ')' |f= functionName args= selectionFunctionArgs ) ( '.' fi= cident )* )
			// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:298:8: (c= cident | K_WRITETIME '(' c= cident ')' | K_TTL '(' c= cident ')' |f= functionName args= selectionFunctionArgs ) ( '.' fi= cident )*
			{
			// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:298:8: (c= cident | K_WRITETIME '(' c= cident ')' | K_TTL '(' c= cident ')' |f= functionName args= selectionFunctionArgs )
			int alt14=4;
			switch ( input.LA(1) ) {
			case IDENT:
				{
				int LA14_1 = input.LA(2);
				if ( (LA14_1==K_AS||LA14_1==K_FROM||LA14_1==142||LA14_1==144||LA14_1==146) ) {
					alt14=1;
				}
				else if ( (LA14_1==141) ) {
					alt14=4;
				}

				else {
					int nvaeMark = input.mark();
					try {
						input.consume();
						NoViableAltException nvae =
							new NoViableAltException("", 14, 1, input);
						throw nvae;
					} finally {
						input.rewind(nvaeMark);
					}
				}

				}
				break;
			case K_COUNT:
			case K_KEY:
			case QUOTED_NAME:
				{
				alt14=1;
				}
				break;
			case K_ALL:
			case K_AS:
			case K_CLUSTERING:
			case K_COMPACT:
			case K_CONTAINS:
			case K_CUSTOM:
			case K_DISTINCT:
			case K_EXISTS:
			case K_FILTERING:
			case K_KEYS:
			case K_KEYSPACES:
			case K_LIST:
			case K_MAP:
			case K_NOSUPERUSER:
			case K_PASSWORD:
			case K_PERMISSION:
			case K_PERMISSIONS:
			case K_STATIC:
			case K_STORAGE:
			case K_SUPERUSER:
			case K_TRIGGER:
			case K_TYPE:
			case K_USER:
			case K_USERS:
			case K_VALUES:
				{
				int LA14_3 = input.LA(2);
				if ( (LA14_3==K_AS||LA14_3==K_FROM||LA14_3==142||LA14_3==144||LA14_3==146) ) {
					alt14=1;
				}
				else if ( (LA14_3==141) ) {
					alt14=4;
				}

				else {
					int nvaeMark = input.mark();
					try {
						input.consume();
						NoViableAltException nvae =
							new NoViableAltException("", 14, 3, input);
						throw nvae;
					} finally {
						input.rewind(nvaeMark);
					}
				}

				}
				break;
			case K_ASCII:
				{
				int LA14_4 = input.LA(2);
				if ( (LA14_4==K_AS||LA14_4==K_FROM||LA14_4==142||LA14_4==144||LA14_4==146) ) {
					alt14=1;
				}
				else if ( (LA14_4==141) ) {
					alt14=4;
				}

				else {
					int nvaeMark = input.mark();
					try {
						input.consume();
						NoViableAltException nvae =
							new NoViableAltException("", 14, 4, input);
						throw nvae;
					} finally {
						input.rewind(nvaeMark);
					}
				}

				}
				break;
			case K_BIGINT:
				{
				int LA14_5 = input.LA(2);
				if ( (LA14_5==K_AS||LA14_5==K_FROM||LA14_5==142||LA14_5==144||LA14_5==146) ) {
					alt14=1;
				}
				else if ( (LA14_5==141) ) {
					alt14=4;
				}

				else {
					int nvaeMark = input.mark();
					try {
						input.consume();
						NoViableAltException nvae =
							new NoViableAltException("", 14, 5, input);
						throw nvae;
					} finally {
						input.rewind(nvaeMark);
					}
				}

				}
				break;
			case K_BLOB:
				{
				int LA14_6 = input.LA(2);
				if ( (LA14_6==K_AS||LA14_6==K_FROM||LA14_6==142||LA14_6==144||LA14_6==146) ) {
					alt14=1;
				}
				else if ( (LA14_6==141) ) {
					alt14=4;
				}

				else {
					int nvaeMark = input.mark();
					try {
						input.consume();
						NoViableAltException nvae =
							new NoViableAltException("", 14, 6, input);
						throw nvae;
					} finally {
						input.rewind(nvaeMark);
					}
				}

				}
				break;
			case K_BOOLEAN:
				{
				int LA14_7 = input.LA(2);
				if ( (LA14_7==K_AS||LA14_7==K_FROM||LA14_7==142||LA14_7==144||LA14_7==146) ) {
					alt14=1;
				}
				else if ( (LA14_7==141) ) {
					alt14=4;
				}

				else {
					int nvaeMark = input.mark();
					try {
						input.consume();
						NoViableAltException nvae =
							new NoViableAltException("", 14, 7, input);
						throw nvae;
					} finally {
						input.rewind(nvaeMark);
					}
				}

				}
				break;
			case K_COUNTER:
				{
				int LA14_8 = input.LA(2);
				if ( (LA14_8==K_AS||LA14_8==K_FROM||LA14_8==142||LA14_8==144||LA14_8==146) ) {
					alt14=1;
				}
				else if ( (LA14_8==141) ) {
					alt14=4;
				}

				else {
					int nvaeMark = input.mark();
					try {
						input.consume();
						NoViableAltException nvae =
							new NoViableAltException("", 14, 8, input);
						throw nvae;
					} finally {
						input.rewind(nvaeMark);
					}
				}

				}
				break;
			case K_DECIMAL:
				{
				int LA14_9 = input.LA(2);
				if ( (LA14_9==K_AS||LA14_9==K_FROM||LA14_9==142||LA14_9==144||LA14_9==146) ) {
					alt14=1;
				}
				else if ( (LA14_9==141) ) {
					alt14=4;
				}

				else {
					int nvaeMark = input.mark();
					try {
						input.consume();
						NoViableAltException nvae =
							new NoViableAltException("", 14, 9, input);
						throw nvae;
					} finally {
						input.rewind(nvaeMark);
					}
				}

				}
				break;
			case K_DOUBLE:
				{
				int LA14_10 = input.LA(2);
				if ( (LA14_10==K_AS||LA14_10==K_FROM||LA14_10==142||LA14_10==144||LA14_10==146) ) {
					alt14=1;
				}
				else if ( (LA14_10==141) ) {
					alt14=4;
				}

				else {
					int nvaeMark = input.mark();
					try {
						input.consume();
						NoViableAltException nvae =
							new NoViableAltException("", 14, 10, input);
						throw nvae;
					} finally {
						input.rewind(nvaeMark);
					}
				}

				}
				break;
			case K_FLOAT:
				{
				int LA14_11 = input.LA(2);
				if ( (LA14_11==K_AS||LA14_11==K_FROM||LA14_11==142||LA14_11==144||LA14_11==146) ) {
					alt14=1;
				}
				else if ( (LA14_11==141) ) {
					alt14=4;
				}

				else {
					int nvaeMark = input.mark();
					try {
						input.consume();
						NoViableAltException nvae =
							new NoViableAltException("", 14, 11, input);
						throw nvae;
					} finally {
						input.rewind(nvaeMark);
					}
				}

				}
				break;
			case K_INET:
				{
				int LA14_12 = input.LA(2);
				if ( (LA14_12==K_AS||LA14_12==K_FROM||LA14_12==142||LA14_12==144||LA14_12==146) ) {
					alt14=1;
				}
				else if ( (LA14_12==141) ) {
					alt14=4;
				}

				else {
					int nvaeMark = input.mark();
					try {
						input.consume();
						NoViableAltException nvae =
							new NoViableAltException("", 14, 12, input);
						throw nvae;
					} finally {
						input.rewind(nvaeMark);
					}
				}

				}
				break;
			case K_INT:
				{
				int LA14_13 = input.LA(2);
				if ( (LA14_13==K_AS||LA14_13==K_FROM||LA14_13==142||LA14_13==144||LA14_13==146) ) {
					alt14=1;
				}
				else if ( (LA14_13==141) ) {
					alt14=4;
				}

				else {
					int nvaeMark = input.mark();
					try {
						input.consume();
						NoViableAltException nvae =
							new NoViableAltException("", 14, 13, input);
						throw nvae;
					} finally {
						input.rewind(nvaeMark);
					}
				}

				}
				break;
			case K_TEXT:
				{
				int LA14_14 = input.LA(2);
				if ( (LA14_14==K_AS||LA14_14==K_FROM||LA14_14==142||LA14_14==144||LA14_14==146) ) {
					alt14=1;
				}
				else if ( (LA14_14==141) ) {
					alt14=4;
				}

				else {
					int nvaeMark = input.mark();
					try {
						input.consume();
						NoViableAltException nvae =
							new NoViableAltException("", 14, 14, input);
						throw nvae;
					} finally {
						input.rewind(nvaeMark);
					}
				}

				}
				break;
			case K_TIMESTAMP:
				{
				int LA14_15 = input.LA(2);
				if ( (LA14_15==K_AS||LA14_15==K_FROM||LA14_15==142||LA14_15==144||LA14_15==146) ) {
					alt14=1;
				}
				else if ( (LA14_15==141) ) {
					alt14=4;
				}

				else {
					int nvaeMark = input.mark();
					try {
						input.consume();
						NoViableAltException nvae =
							new NoViableAltException("", 14, 15, input);
						throw nvae;
					} finally {
						input.rewind(nvaeMark);
					}
				}

				}
				break;
			case K_UUID:
				{
				int LA14_16 = input.LA(2);
				if ( (LA14_16==K_AS||LA14_16==K_FROM||LA14_16==142||LA14_16==144||LA14_16==146) ) {
					alt14=1;
				}
				else if ( (LA14_16==141) ) {
					alt14=4;
				}

				else {
					int nvaeMark = input.mark();
					try {
						input.consume();
						NoViableAltException nvae =
							new NoViableAltException("", 14, 16, input);
						throw nvae;
					} finally {
						input.rewind(nvaeMark);
					}
				}

				}
				break;
			case K_VARCHAR:
				{
				int LA14_17 = input.LA(2);
				if ( (LA14_17==K_AS||LA14_17==K_FROM||LA14_17==142||LA14_17==144||LA14_17==146) ) {
					alt14=1;
				}
				else if ( (LA14_17==141) ) {
					alt14=4;
				}

				else {
					int nvaeMark = input.mark();
					try {
						input.consume();
						NoViableAltException nvae =
							new NoViableAltException("", 14, 17, input);
						throw nvae;
					} finally {
						input.rewind(nvaeMark);
					}
				}

				}
				break;
			case K_VARINT:
				{
				int LA14_18 = input.LA(2);
				if ( (LA14_18==K_AS||LA14_18==K_FROM||LA14_18==142||LA14_18==144||LA14_18==146) ) {
					alt14=1;
				}
				else if ( (LA14_18==141) ) {
					alt14=4;
				}

				else {
					int nvaeMark = input.mark();
					try {
						input.consume();
						NoViableAltException nvae =
							new NoViableAltException("", 14, 18, input);
						throw nvae;
					} finally {
						input.rewind(nvaeMark);
					}
				}

				}
				break;
			case K_TIMEUUID:
				{
				int LA14_19 = input.LA(2);
				if ( (LA14_19==K_AS||LA14_19==K_FROM||LA14_19==142||LA14_19==144||LA14_19==146) ) {
					alt14=1;
				}
				else if ( (LA14_19==141) ) {
					alt14=4;
				}

				else {
					int nvaeMark = input.mark();
					try {
						input.consume();
						NoViableAltException nvae =
							new NoViableAltException("", 14, 19, input);
						throw nvae;
					} finally {
						input.rewind(nvaeMark);
					}
				}

				}
				break;
			case K_WRITETIME:
				{
				int LA14_20 = input.LA(2);
				if ( (LA14_20==141) ) {
					alt14=2;
				}
				else if ( (LA14_20==K_AS||LA14_20==K_FROM||LA14_20==142||LA14_20==144||LA14_20==146) ) {
					alt14=1;
				}

				else {
					int nvaeMark = input.mark();
					try {
						input.consume();
						NoViableAltException nvae =
							new NoViableAltException("", 14, 20, input);
						throw nvae;
					} finally {
						input.rewind(nvaeMark);
					}
				}

				}
				break;
			case K_TTL:
				{
				int LA14_21 = input.LA(2);
				if ( (LA14_21==141) ) {
					alt14=3;
				}
				else if ( (LA14_21==K_AS||LA14_21==K_FROM||LA14_21==142||LA14_21==144||LA14_21==146) ) {
					alt14=1;
				}

				else {
					int nvaeMark = input.mark();
					try {
						input.consume();
						NoViableAltException nvae =
							new NoViableAltException("", 14, 21, input);
						throw nvae;
					} finally {
						input.rewind(nvaeMark);
					}
				}

				}
				break;
			case K_TOKEN:
				{
				alt14=4;
				}
				break;
			default:
				NoViableAltException nvae =
					new NoViableAltException("", 14, 0, input);
				throw nvae;
			}
			switch (alt14) {
				case 1 :
					// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:298:10: c= cident
					{
					pushFollow(FOLLOW_cident_in_unaliasedSelector1026);
					c=cident();
					state._fsp--;

					 tmp = c; 
					}
					break;
				case 2 :
					// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:299:10: K_WRITETIME '(' c= cident ')'
					{
					match(input,K_WRITETIME,FOLLOW_K_WRITETIME_in_unaliasedSelector1072); 
					match(input,141,FOLLOW_141_in_unaliasedSelector1074); 
					pushFollow(FOLLOW_cident_in_unaliasedSelector1078);
					c=cident();
					state._fsp--;

					match(input,142,FOLLOW_142_in_unaliasedSelector1080); 
					 tmp = new Selectable.WritetimeOrTTL.Raw(c, true); 
					}
					break;
				case 3 :
					// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:300:10: K_TTL '(' c= cident ')'
					{
					match(input,K_TTL,FOLLOW_K_TTL_in_unaliasedSelector1106); 
					match(input,141,FOLLOW_141_in_unaliasedSelector1114); 
					pushFollow(FOLLOW_cident_in_unaliasedSelector1118);
					c=cident();
					state._fsp--;

					match(input,142,FOLLOW_142_in_unaliasedSelector1120); 
					 tmp = new Selectable.WritetimeOrTTL.Raw(c, false); 
					}
					break;
				case 4 :
					// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:301:10: f= functionName args= selectionFunctionArgs
					{
					pushFollow(FOLLOW_functionName_in_unaliasedSelector1148);
					f=functionName();
					state._fsp--;

					pushFollow(FOLLOW_selectionFunctionArgs_in_unaliasedSelector1152);
					args=selectionFunctionArgs();
					state._fsp--;

					 tmp = new Selectable.WithFunction.Raw(f, args); 
					}
					break;

			}

			// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:302:10: ( '.' fi= cident )*
			loop15:
			while (true) {
				int alt15=2;
				int LA15_0 = input.LA(1);
				if ( (LA15_0==146) ) {
					alt15=1;
				}

				switch (alt15) {
				case 1 :
					// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:302:12: '.' fi= cident
					{
					match(input,146,FOLLOW_146_in_unaliasedSelector1167); 
					pushFollow(FOLLOW_cident_in_unaliasedSelector1171);
					fi=cident();
					state._fsp--;

					 tmp = new Selectable.WithFieldSelection.Raw(tmp, fi); 
					}
					break;

				default :
					break loop15;
				}
			}

			 s = tmp; 
			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return s;
	}
	// $ANTLR end "unaliasedSelector"



	// $ANTLR start "selectionFunctionArgs"
	// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:305:1: selectionFunctionArgs returns [List<Selectable.Raw> a] : ( '(' ')' | '(' s1= unaliasedSelector ( ',' sn= unaliasedSelector )* ')' );
	public final List<Selectable.Raw> selectionFunctionArgs() throws RecognitionException {
		List<Selectable.Raw> a = null;


		Selectable.Raw s1 =null;
		Selectable.Raw sn =null;

		try {
			// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:306:5: ( '(' ')' | '(' s1= unaliasedSelector ( ',' sn= unaliasedSelector )* ')' )
			int alt17=2;
			int LA17_0 = input.LA(1);
			if ( (LA17_0==141) ) {
				int LA17_1 = input.LA(2);
				if ( (LA17_1==142) ) {
					alt17=1;
				}
				else if ( (LA17_1==IDENT||LA17_1==K_ALL||LA17_1==K_AS||LA17_1==K_ASCII||(LA17_1 >= K_BIGINT && LA17_1 <= K_BOOLEAN)||LA17_1==K_CLUSTERING||(LA17_1 >= K_COMPACT && LA17_1 <= K_COUNTER)||(LA17_1 >= K_CUSTOM && LA17_1 <= K_DECIMAL)||(LA17_1 >= K_DISTINCT && LA17_1 <= K_DOUBLE)||(LA17_1 >= K_EXISTS && LA17_1 <= K_FLOAT)||LA17_1==K_INET||LA17_1==K_INT||(LA17_1 >= K_KEY && LA17_1 <= K_KEYS)||LA17_1==K_KEYSPACES||(LA17_1 >= K_LIST && LA17_1 <= K_MAP)||LA17_1==K_NOSUPERUSER||(LA17_1 >= K_PASSWORD && LA17_1 <= K_PERMISSIONS)||(LA17_1 >= K_STATIC && LA17_1 <= K_TIMEUUID)||(LA17_1 >= K_TOKEN && LA17_1 <= K_TRIGGER)||LA17_1==K_TTL||LA17_1==K_TYPE||(LA17_1 >= K_USER && LA17_1 <= K_USERS)||(LA17_1 >= K_UUID && LA17_1 <= K_VARINT)||LA17_1==K_WRITETIME||LA17_1==QUOTED_NAME) ) {
					alt17=2;
				}

				else {
					int nvaeMark = input.mark();
					try {
						input.consume();
						NoViableAltException nvae =
							new NoViableAltException("", 17, 1, input);
						throw nvae;
					} finally {
						input.rewind(nvaeMark);
					}
				}

			}

			else {
				NoViableAltException nvae =
					new NoViableAltException("", 17, 0, input);
				throw nvae;
			}

			switch (alt17) {
				case 1 :
					// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:306:7: '(' ')'
					{
					match(input,141,FOLLOW_141_in_selectionFunctionArgs1199); 
					match(input,142,FOLLOW_142_in_selectionFunctionArgs1201); 
					 a = Collections.emptyList(); 
					}
					break;
				case 2 :
					// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:307:7: '(' s1= unaliasedSelector ( ',' sn= unaliasedSelector )* ')'
					{
					match(input,141,FOLLOW_141_in_selectionFunctionArgs1211); 
					pushFollow(FOLLOW_unaliasedSelector_in_selectionFunctionArgs1215);
					s1=unaliasedSelector();
					state._fsp--;

					 List<Selectable.Raw> args = new ArrayList<Selectable.Raw>(); args.add(s1); 
					// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:308:11: ( ',' sn= unaliasedSelector )*
					loop16:
					while (true) {
						int alt16=2;
						int LA16_0 = input.LA(1);
						if ( (LA16_0==144) ) {
							alt16=1;
						}

						switch (alt16) {
						case 1 :
							// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:308:13: ',' sn= unaliasedSelector
							{
							match(input,144,FOLLOW_144_in_selectionFunctionArgs1231); 
							pushFollow(FOLLOW_unaliasedSelector_in_selectionFunctionArgs1235);
							sn=unaliasedSelector();
							state._fsp--;

							 args.add(sn); 
							}
							break;

						default :
							break loop16;
						}
					}

					match(input,142,FOLLOW_142_in_selectionFunctionArgs1248); 
					 a = args; 
					}
					break;

			}
		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return a;
	}
	// $ANTLR end "selectionFunctionArgs"



	// $ANTLR start "selectCountClause"
	// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:312:1: selectCountClause returns [List<RawSelector> expr] : ( '\\*' |i= INTEGER );
	public final List<RawSelector> selectCountClause() throws RecognitionException {
		List<RawSelector> expr = null;


		Token i=null;

		try {
			// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:313:5: ( '\\*' |i= INTEGER )
			int alt18=2;
			int LA18_0 = input.LA(1);
			if ( (LA18_0==155) ) {
				alt18=1;
			}
			else if ( (LA18_0==INTEGER) ) {
				alt18=2;
			}

			else {
				NoViableAltException nvae =
					new NoViableAltException("", 18, 0, input);
				throw nvae;
			}

			switch (alt18) {
				case 1 :
					// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:313:7: '\\*'
					{
					match(input,155,FOLLOW_155_in_selectCountClause1271); 
					 expr = Collections.<RawSelector>emptyList();
					}
					break;
				case 2 :
					// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:314:7: i= INTEGER
					{
					i=(Token)match(input,INTEGER,FOLLOW_INTEGER_in_selectCountClause1293); 
					 if (!i.getText().equals("1")) addRecognitionError("Only COUNT(1) is supported, got COUNT(" + i.getText() + ")"); expr = Collections.<RawSelector>emptyList();
					}
					break;

			}
		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return expr;
	}
	// $ANTLR end "selectCountClause"



	// $ANTLR start "whereClause"
	// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:317:1: whereClause returns [List<Relation> clause] : relation[$clause] ( K_AND relation[$clause] )* ;
	public final List<Relation> whereClause() throws RecognitionException {
		List<Relation> clause = null;


		 clause = new ArrayList<Relation>(); 
		try {
			// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:319:5: ( relation[$clause] ( K_AND relation[$clause] )* )
			// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:319:7: relation[$clause] ( K_AND relation[$clause] )*
			{
			pushFollow(FOLLOW_relation_in_whereClause1329);
			relation(clause);
			state._fsp--;

			// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:319:25: ( K_AND relation[$clause] )*
			loop19:
			while (true) {
				int alt19=2;
				int LA19_0 = input.LA(1);
				if ( (LA19_0==K_AND) ) {
					alt19=1;
				}

				switch (alt19) {
				case 1 :
					// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:319:26: K_AND relation[$clause]
					{
					match(input,K_AND,FOLLOW_K_AND_in_whereClause1333); 
					pushFollow(FOLLOW_relation_in_whereClause1335);
					relation(clause);
					state._fsp--;

					}
					break;

				default :
					break loop19;
				}
			}

			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return clause;
	}
	// $ANTLR end "whereClause"



	// $ANTLR start "orderByClause"
	// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:322:1: orderByClause[Map<ColumnIdentifier.Raw, Boolean> orderings] : c= cident ( K_ASC | K_DESC )? ;
	public final void orderByClause(Map<ColumnIdentifier.Raw, Boolean> orderings) throws RecognitionException {
		ColumnIdentifier.Raw c =null;


		        ColumnIdentifier.Raw orderBy = null;
		        boolean reversed = false;
		    
		try {
			// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:327:5: (c= cident ( K_ASC | K_DESC )? )
			// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:327:7: c= cident ( K_ASC | K_DESC )?
			{
			pushFollow(FOLLOW_cident_in_orderByClause1366);
			c=cident();
			state._fsp--;

			 orderBy = c; 
			// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:327:33: ( K_ASC | K_DESC )?
			int alt20=3;
			int LA20_0 = input.LA(1);
			if ( (LA20_0==K_ASC) ) {
				alt20=1;
			}
			else if ( (LA20_0==K_DESC) ) {
				alt20=2;
			}
			switch (alt20) {
				case 1 :
					// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:327:34: K_ASC
					{
					match(input,K_ASC,FOLLOW_K_ASC_in_orderByClause1371); 
					}
					break;
				case 2 :
					// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:327:42: K_DESC
					{
					match(input,K_DESC,FOLLOW_K_DESC_in_orderByClause1375); 
					 reversed = true; 
					}
					break;

			}

			 orderings.put(c, reversed); 
			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "orderByClause"



	// $ANTLR start "insertStatement"
	// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:336:1: insertStatement returns [UpdateStatement.ParsedInsert expr] : K_INSERT K_INTO cf= columnFamilyName '(' c1= cident ( ',' cn= cident )* ')' K_VALUES '(' v1= term ( ',' vn= term )* ')' ( K_IF K_NOT K_EXISTS )? ( usingClause[attrs] )? ;
	public final UpdateStatement.ParsedInsert insertStatement() throws RecognitionException {
		UpdateStatement.ParsedInsert expr = null;


		CFName cf =null;
		ColumnIdentifier.Raw c1 =null;
		ColumnIdentifier.Raw cn =null;
		Term.Raw v1 =null;
		Term.Raw vn =null;


		        Attributes.Raw attrs = new Attributes.Raw();
		        List<ColumnIdentifier.Raw> columnNames  = new ArrayList<ColumnIdentifier.Raw>();
		        List<Term.Raw> values = new ArrayList<Term.Raw>();
		        boolean ifNotExists = false;
		    
		try {
			// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:343:5: ( K_INSERT K_INTO cf= columnFamilyName '(' c1= cident ( ',' cn= cident )* ')' K_VALUES '(' v1= term ( ',' vn= term )* ')' ( K_IF K_NOT K_EXISTS )? ( usingClause[attrs] )? )
			// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:343:7: K_INSERT K_INTO cf= columnFamilyName '(' c1= cident ( ',' cn= cident )* ')' K_VALUES '(' v1= term ( ',' vn= term )* ')' ( K_IF K_NOT K_EXISTS )? ( usingClause[attrs] )?
			{
			match(input,K_INSERT,FOLLOW_K_INSERT_in_insertStatement1413); 
			match(input,K_INTO,FOLLOW_K_INTO_in_insertStatement1415); 
			pushFollow(FOLLOW_columnFamilyName_in_insertStatement1419);
			cf=columnFamilyName();
			state._fsp--;

			match(input,141,FOLLOW_141_in_insertStatement1431); 
			pushFollow(FOLLOW_cident_in_insertStatement1435);
			c1=cident();
			state._fsp--;

			 columnNames.add(c1); 
			// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:344:51: ( ',' cn= cident )*
			loop21:
			while (true) {
				int alt21=2;
				int LA21_0 = input.LA(1);
				if ( (LA21_0==144) ) {
					alt21=1;
				}

				switch (alt21) {
				case 1 :
					// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:344:53: ',' cn= cident
					{
					match(input,144,FOLLOW_144_in_insertStatement1442); 
					pushFollow(FOLLOW_cident_in_insertStatement1446);
					cn=cident();
					state._fsp--;

					 columnNames.add(cn); 
					}
					break;

				default :
					break loop21;
				}
			}

			match(input,142,FOLLOW_142_in_insertStatement1453); 
			match(input,K_VALUES,FOLLOW_K_VALUES_in_insertStatement1463); 
			match(input,141,FOLLOW_141_in_insertStatement1475); 
			pushFollow(FOLLOW_term_in_insertStatement1479);
			v1=term();
			state._fsp--;

			 values.add(v1); 
			// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:346:43: ( ',' vn= term )*
			loop22:
			while (true) {
				int alt22=2;
				int LA22_0 = input.LA(1);
				if ( (LA22_0==144) ) {
					alt22=1;
				}

				switch (alt22) {
				case 1 :
					// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:346:45: ',' vn= term
					{
					match(input,144,FOLLOW_144_in_insertStatement1485); 
					pushFollow(FOLLOW_term_in_insertStatement1489);
					vn=term();
					state._fsp--;

					 values.add(vn); 
					}
					break;

				default :
					break loop22;
				}
			}

			match(input,142,FOLLOW_142_in_insertStatement1496); 
			// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:348:9: ( K_IF K_NOT K_EXISTS )?
			int alt23=2;
			int LA23_0 = input.LA(1);
			if ( (LA23_0==K_IF) ) {
				alt23=1;
			}
			switch (alt23) {
				case 1 :
					// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:348:11: K_IF K_NOT K_EXISTS
					{
					match(input,K_IF,FOLLOW_K_IF_in_insertStatement1509); 
					match(input,K_NOT,FOLLOW_K_NOT_in_insertStatement1511); 
					match(input,K_EXISTS,FOLLOW_K_EXISTS_in_insertStatement1513); 
					 ifNotExists = true; 
					}
					break;

			}

			// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:349:9: ( usingClause[attrs] )?
			int alt24=2;
			int LA24_0 = input.LA(1);
			if ( (LA24_0==K_USING) ) {
				alt24=1;
			}
			switch (alt24) {
				case 1 :
					// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:349:11: usingClause[attrs]
					{
					pushFollow(FOLLOW_usingClause_in_insertStatement1530);
					usingClause(attrs);
					state._fsp--;

					}
					break;

			}


			          expr = new UpdateStatement.ParsedInsert(cf,
			                                                   attrs,
			                                                   columnNames,
			                                                   values,
			                                                   ifNotExists);
			      
			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return expr;
	}
	// $ANTLR end "insertStatement"



	// $ANTLR start "usingClause"
	// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:359:1: usingClause[Attributes.Raw attrs] : K_USING usingClauseObjective[attrs] ( K_AND usingClauseObjective[attrs] )* ;
	public final void usingClause(Attributes.Raw attrs) throws RecognitionException {
		try {
			// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:360:5: ( K_USING usingClauseObjective[attrs] ( K_AND usingClauseObjective[attrs] )* )
			// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:360:7: K_USING usingClauseObjective[attrs] ( K_AND usingClauseObjective[attrs] )*
			{
			match(input,K_USING,FOLLOW_K_USING_in_usingClause1560); 
			pushFollow(FOLLOW_usingClauseObjective_in_usingClause1562);
			usingClauseObjective(attrs);
			state._fsp--;

			// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:360:43: ( K_AND usingClauseObjective[attrs] )*
			loop25:
			while (true) {
				int alt25=2;
				int LA25_0 = input.LA(1);
				if ( (LA25_0==K_AND) ) {
					alt25=1;
				}

				switch (alt25) {
				case 1 :
					// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:360:45: K_AND usingClauseObjective[attrs]
					{
					match(input,K_AND,FOLLOW_K_AND_in_usingClause1567); 
					pushFollow(FOLLOW_usingClauseObjective_in_usingClause1569);
					usingClauseObjective(attrs);
					state._fsp--;

					}
					break;

				default :
					break loop25;
				}
			}

			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "usingClause"



	// $ANTLR start "usingClauseObjective"
	// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:363:1: usingClauseObjective[Attributes.Raw attrs] : ( K_TIMESTAMP ts= intValue | K_TTL t= intValue );
	public final void usingClauseObjective(Attributes.Raw attrs) throws RecognitionException {
		Term.Raw ts =null;
		Term.Raw t =null;

		try {
			// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:364:5: ( K_TIMESTAMP ts= intValue | K_TTL t= intValue )
			int alt26=2;
			int LA26_0 = input.LA(1);
			if ( (LA26_0==K_TIMESTAMP) ) {
				alt26=1;
			}
			else if ( (LA26_0==K_TTL) ) {
				alt26=2;
			}

			else {
				NoViableAltException nvae =
					new NoViableAltException("", 26, 0, input);
				throw nvae;
			}

			switch (alt26) {
				case 1 :
					// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:364:7: K_TIMESTAMP ts= intValue
					{
					match(input,K_TIMESTAMP,FOLLOW_K_TIMESTAMP_in_usingClauseObjective1591); 
					pushFollow(FOLLOW_intValue_in_usingClauseObjective1595);
					ts=intValue();
					state._fsp--;

					 attrs.timestamp = ts; 
					}
					break;
				case 2 :
					// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:365:7: K_TTL t= intValue
					{
					match(input,K_TTL,FOLLOW_K_TTL_in_usingClauseObjective1605); 
					pushFollow(FOLLOW_intValue_in_usingClauseObjective1609);
					t=intValue();
					state._fsp--;

					 attrs.timeToLive = t; 
					}
					break;

			}
		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "usingClauseObjective"



	// $ANTLR start "updateStatement"
	// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:374:1: updateStatement returns [UpdateStatement.ParsedUpdate expr] : K_UPDATE cf= columnFamilyName ( usingClause[attrs] )? K_SET columnOperation[operations] ( ',' columnOperation[operations] )* K_WHERE wclause= whereClause ( K_IF conditions= updateConditions )? ;
	public final UpdateStatement.ParsedUpdate updateStatement() throws RecognitionException {
		UpdateStatement.ParsedUpdate expr = null;


		CFName cf =null;
		List<Relation> wclause =null;
		List<Pair<ColumnIdentifier.Raw, ColumnCondition.Raw>> conditions =null;


		        Attributes.Raw attrs = new Attributes.Raw();
		        List<Pair<ColumnIdentifier.Raw, Operation.RawUpdate>> operations = new ArrayList<Pair<ColumnIdentifier.Raw, Operation.RawUpdate>>();
		    
		try {
			// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:379:5: ( K_UPDATE cf= columnFamilyName ( usingClause[attrs] )? K_SET columnOperation[operations] ( ',' columnOperation[operations] )* K_WHERE wclause= whereClause ( K_IF conditions= updateConditions )? )
			// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:379:7: K_UPDATE cf= columnFamilyName ( usingClause[attrs] )? K_SET columnOperation[operations] ( ',' columnOperation[operations] )* K_WHERE wclause= whereClause ( K_IF conditions= updateConditions )?
			{
			match(input,K_UPDATE,FOLLOW_K_UPDATE_in_updateStatement1643); 
			pushFollow(FOLLOW_columnFamilyName_in_updateStatement1647);
			cf=columnFamilyName();
			state._fsp--;

			// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:380:7: ( usingClause[attrs] )?
			int alt27=2;
			int LA27_0 = input.LA(1);
			if ( (LA27_0==K_USING) ) {
				alt27=1;
			}
			switch (alt27) {
				case 1 :
					// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:380:9: usingClause[attrs]
					{
					pushFollow(FOLLOW_usingClause_in_updateStatement1657);
					usingClause(attrs);
					state._fsp--;

					}
					break;

			}

			match(input,K_SET,FOLLOW_K_SET_in_updateStatement1669); 
			pushFollow(FOLLOW_columnOperation_in_updateStatement1671);
			columnOperation(operations);
			state._fsp--;

			// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:381:41: ( ',' columnOperation[operations] )*
			loop28:
			while (true) {
				int alt28=2;
				int LA28_0 = input.LA(1);
				if ( (LA28_0==144) ) {
					alt28=1;
				}

				switch (alt28) {
				case 1 :
					// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:381:42: ',' columnOperation[operations]
					{
					match(input,144,FOLLOW_144_in_updateStatement1675); 
					pushFollow(FOLLOW_columnOperation_in_updateStatement1677);
					columnOperation(operations);
					state._fsp--;

					}
					break;

				default :
					break loop28;
				}
			}

			match(input,K_WHERE,FOLLOW_K_WHERE_in_updateStatement1688); 
			pushFollow(FOLLOW_whereClause_in_updateStatement1692);
			wclause=whereClause();
			state._fsp--;

			// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:383:7: ( K_IF conditions= updateConditions )?
			int alt29=2;
			int LA29_0 = input.LA(1);
			if ( (LA29_0==K_IF) ) {
				alt29=1;
			}
			switch (alt29) {
				case 1 :
					// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:383:9: K_IF conditions= updateConditions
					{
					match(input,K_IF,FOLLOW_K_IF_in_updateStatement1702); 
					pushFollow(FOLLOW_updateConditions_in_updateStatement1706);
					conditions=updateConditions();
					state._fsp--;

					}
					break;

			}


			          return new UpdateStatement.ParsedUpdate(cf,
			                                                  attrs,
			                                                  operations,
			                                                  wclause,
			                                                  conditions == null ? Collections.<Pair<ColumnIdentifier.Raw, ColumnCondition.Raw>>emptyList() : conditions);
			     
			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return expr;
	}
	// $ANTLR end "updateStatement"



	// $ANTLR start "updateConditions"
	// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:393:1: updateConditions returns [List<Pair<ColumnIdentifier.Raw, ColumnCondition.Raw>> conditions] : columnCondition[conditions] ( K_AND columnCondition[conditions] )* ;
	public final List<Pair<ColumnIdentifier.Raw, ColumnCondition.Raw>> updateConditions() throws RecognitionException {
		List<Pair<ColumnIdentifier.Raw, ColumnCondition.Raw>> conditions = null;


		 conditions = new ArrayList<Pair<ColumnIdentifier.Raw, ColumnCondition.Raw>>(); 
		try {
			// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:395:5: ( columnCondition[conditions] ( K_AND columnCondition[conditions] )* )
			// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:395:7: columnCondition[conditions] ( K_AND columnCondition[conditions] )*
			{
			pushFollow(FOLLOW_columnCondition_in_updateConditions1747);
			columnCondition(conditions);
			state._fsp--;

			// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:395:35: ( K_AND columnCondition[conditions] )*
			loop30:
			while (true) {
				int alt30=2;
				int LA30_0 = input.LA(1);
				if ( (LA30_0==K_AND) ) {
					alt30=1;
				}

				switch (alt30) {
				case 1 :
					// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:395:37: K_AND columnCondition[conditions]
					{
					match(input,K_AND,FOLLOW_K_AND_in_updateConditions1752); 
					pushFollow(FOLLOW_columnCondition_in_updateConditions1754);
					columnCondition(conditions);
					state._fsp--;

					}
					break;

				default :
					break loop30;
				}
			}

			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return conditions;
	}
	// $ANTLR end "updateConditions"



	// $ANTLR start "deleteStatement"
	// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:406:1: deleteStatement returns [DeleteStatement.Parsed expr] : K_DELETE (dels= deleteSelection )? K_FROM cf= columnFamilyName ( usingClauseDelete[attrs] )? K_WHERE wclause= whereClause ( K_IF ( K_EXISTS |conditions= updateConditions ) )? ;
	public final DeleteStatement.Parsed deleteStatement() throws RecognitionException {
		DeleteStatement.Parsed expr = null;


		List<Operation.RawDeletion> dels =null;
		CFName cf =null;
		List<Relation> wclause =null;
		List<Pair<ColumnIdentifier.Raw, ColumnCondition.Raw>> conditions =null;


		        Attributes.Raw attrs = new Attributes.Raw();
		        List<Operation.RawDeletion> columnDeletions = Collections.emptyList();
		        boolean ifExists = false;
		    
		try {
			// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:412:5: ( K_DELETE (dels= deleteSelection )? K_FROM cf= columnFamilyName ( usingClauseDelete[attrs] )? K_WHERE wclause= whereClause ( K_IF ( K_EXISTS |conditions= updateConditions ) )? )
			// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:412:7: K_DELETE (dels= deleteSelection )? K_FROM cf= columnFamilyName ( usingClauseDelete[attrs] )? K_WHERE wclause= whereClause ( K_IF ( K_EXISTS |conditions= updateConditions ) )?
			{
			match(input,K_DELETE,FOLLOW_K_DELETE_in_deleteStatement1791); 
			// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:412:16: (dels= deleteSelection )?
			int alt31=2;
			int LA31_0 = input.LA(1);
			if ( (LA31_0==IDENT||LA31_0==K_ALL||LA31_0==K_AS||LA31_0==K_ASCII||(LA31_0 >= K_BIGINT && LA31_0 <= K_BOOLEAN)||LA31_0==K_CLUSTERING||(LA31_0 >= K_COMPACT && LA31_0 <= K_COUNTER)||(LA31_0 >= K_CUSTOM && LA31_0 <= K_DECIMAL)||(LA31_0 >= K_DISTINCT && LA31_0 <= K_DOUBLE)||(LA31_0 >= K_EXISTS && LA31_0 <= K_FLOAT)||LA31_0==K_INET||LA31_0==K_INT||(LA31_0 >= K_KEY && LA31_0 <= K_KEYS)||LA31_0==K_KEYSPACES||(LA31_0 >= K_LIST && LA31_0 <= K_MAP)||LA31_0==K_NOSUPERUSER||(LA31_0 >= K_PASSWORD && LA31_0 <= K_PERMISSIONS)||(LA31_0 >= K_STATIC && LA31_0 <= K_TIMEUUID)||LA31_0==K_TRIGGER||LA31_0==K_TTL||LA31_0==K_TYPE||(LA31_0 >= K_USER && LA31_0 <= K_USERS)||(LA31_0 >= K_UUID && LA31_0 <= K_VARINT)||LA31_0==K_WRITETIME||LA31_0==QUOTED_NAME) ) {
				alt31=1;
			}
			switch (alt31) {
				case 1 :
					// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:412:18: dels= deleteSelection
					{
					pushFollow(FOLLOW_deleteSelection_in_deleteStatement1797);
					dels=deleteSelection();
					state._fsp--;

					 columnDeletions = dels; 
					}
					break;

			}

			match(input,K_FROM,FOLLOW_K_FROM_in_deleteStatement1810); 
			pushFollow(FOLLOW_columnFamilyName_in_deleteStatement1814);
			cf=columnFamilyName();
			state._fsp--;

			// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:414:7: ( usingClauseDelete[attrs] )?
			int alt32=2;
			int LA32_0 = input.LA(1);
			if ( (LA32_0==K_USING) ) {
				alt32=1;
			}
			switch (alt32) {
				case 1 :
					// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:414:9: usingClauseDelete[attrs]
					{
					pushFollow(FOLLOW_usingClauseDelete_in_deleteStatement1824);
					usingClauseDelete(attrs);
					state._fsp--;

					}
					break;

			}

			match(input,K_WHERE,FOLLOW_K_WHERE_in_deleteStatement1836); 
			pushFollow(FOLLOW_whereClause_in_deleteStatement1840);
			wclause=whereClause();
			state._fsp--;

			// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:416:7: ( K_IF ( K_EXISTS |conditions= updateConditions ) )?
			int alt34=2;
			int LA34_0 = input.LA(1);
			if ( (LA34_0==K_IF) ) {
				alt34=1;
			}
			switch (alt34) {
				case 1 :
					// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:416:9: K_IF ( K_EXISTS |conditions= updateConditions )
					{
					match(input,K_IF,FOLLOW_K_IF_in_deleteStatement1850); 
					// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:416:14: ( K_EXISTS |conditions= updateConditions )
					int alt33=2;
					int LA33_0 = input.LA(1);
					if ( (LA33_0==K_EXISTS) ) {
						int LA33_1 = input.LA(2);
						if ( (LA33_1==EOF||LA33_1==K_APPLY||LA33_1==K_DELETE||LA33_1==K_INSERT||LA33_1==K_UPDATE||LA33_1==148) ) {
							alt33=1;
						}
						else if ( (LA33_1==K_IN||LA33_1==140||(LA33_1 >= 149 && LA33_1 <= 154)) ) {
							alt33=2;
						}

						else {
							int nvaeMark = input.mark();
							try {
								input.consume();
								NoViableAltException nvae =
									new NoViableAltException("", 33, 1, input);
								throw nvae;
							} finally {
								input.rewind(nvaeMark);
							}
						}

					}
					else if ( (LA33_0==IDENT||LA33_0==K_ALL||LA33_0==K_AS||LA33_0==K_ASCII||(LA33_0 >= K_BIGINT && LA33_0 <= K_BOOLEAN)||LA33_0==K_CLUSTERING||(LA33_0 >= K_COMPACT && LA33_0 <= K_COUNTER)||(LA33_0 >= K_CUSTOM && LA33_0 <= K_DECIMAL)||(LA33_0 >= K_DISTINCT && LA33_0 <= K_DOUBLE)||(LA33_0 >= K_FILTERING && LA33_0 <= K_FLOAT)||LA33_0==K_INET||LA33_0==K_INT||(LA33_0 >= K_KEY && LA33_0 <= K_KEYS)||LA33_0==K_KEYSPACES||(LA33_0 >= K_LIST && LA33_0 <= K_MAP)||LA33_0==K_NOSUPERUSER||(LA33_0 >= K_PASSWORD && LA33_0 <= K_PERMISSIONS)||(LA33_0 >= K_STATIC && LA33_0 <= K_TIMEUUID)||LA33_0==K_TRIGGER||LA33_0==K_TTL||LA33_0==K_TYPE||(LA33_0 >= K_USER && LA33_0 <= K_USERS)||(LA33_0 >= K_UUID && LA33_0 <= K_VARINT)||LA33_0==K_WRITETIME||LA33_0==QUOTED_NAME) ) {
						alt33=2;
					}

					else {
						NoViableAltException nvae =
							new NoViableAltException("", 33, 0, input);
						throw nvae;
					}

					switch (alt33) {
						case 1 :
							// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:416:16: K_EXISTS
							{
							match(input,K_EXISTS,FOLLOW_K_EXISTS_in_deleteStatement1854); 
							 ifExists = true; 
							}
							break;
						case 2 :
							// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:416:48: conditions= updateConditions
							{
							pushFollow(FOLLOW_updateConditions_in_deleteStatement1862);
							conditions=updateConditions();
							state._fsp--;

							}
							break;

					}

					}
					break;

			}


			          return new DeleteStatement.Parsed(cf,
			                                            attrs,
			                                            columnDeletions,
			                                            wclause,
			                                            conditions == null ? Collections.<Pair<ColumnIdentifier.Raw, ColumnCondition.Raw>>emptyList() : conditions,
			                                            ifExists);
			      
			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return expr;
	}
	// $ANTLR end "deleteStatement"



	// $ANTLR start "deleteSelection"
	// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:427:1: deleteSelection returns [List<Operation.RawDeletion> operations] :t1= deleteOp ( ',' tN= deleteOp )* ;
	public final List<Operation.RawDeletion> deleteSelection() throws RecognitionException {
		List<Operation.RawDeletion> operations = null;


		Operation.RawDeletion t1 =null;
		Operation.RawDeletion tN =null;

		try {
			// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:428:5: (t1= deleteOp ( ',' tN= deleteOp )* )
			// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:428:7: t1= deleteOp ( ',' tN= deleteOp )*
			{
			 operations = new ArrayList<Operation.RawDeletion>(); 
			pushFollow(FOLLOW_deleteOp_in_deleteSelection1909);
			t1=deleteOp();
			state._fsp--;

			 operations.add(t1); 
			// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:430:11: ( ',' tN= deleteOp )*
			loop35:
			while (true) {
				int alt35=2;
				int LA35_0 = input.LA(1);
				if ( (LA35_0==144) ) {
					alt35=1;
				}

				switch (alt35) {
				case 1 :
					// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:430:12: ',' tN= deleteOp
					{
					match(input,144,FOLLOW_144_in_deleteSelection1924); 
					pushFollow(FOLLOW_deleteOp_in_deleteSelection1928);
					tN=deleteOp();
					state._fsp--;

					 operations.add(tN); 
					}
					break;

				default :
					break loop35;
				}
			}

			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return operations;
	}
	// $ANTLR end "deleteSelection"



	// $ANTLR start "deleteOp"
	// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:433:1: deleteOp returns [Operation.RawDeletion op] : (c= cident |c= cident '[' t= term ']' );
	public final Operation.RawDeletion deleteOp() throws RecognitionException {
		Operation.RawDeletion op = null;


		ColumnIdentifier.Raw c =null;
		Term.Raw t =null;

		try {
			// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:434:5: (c= cident |c= cident '[' t= term ']' )
			int alt36=2;
			switch ( input.LA(1) ) {
			case IDENT:
				{
				int LA36_1 = input.LA(2);
				if ( (LA36_1==K_FROM||LA36_1==144) ) {
					alt36=1;
				}
				else if ( (LA36_1==154) ) {
					alt36=2;
				}

				else {
					int nvaeMark = input.mark();
					try {
						input.consume();
						NoViableAltException nvae =
							new NoViableAltException("", 36, 1, input);
						throw nvae;
					} finally {
						input.rewind(nvaeMark);
					}
				}

				}
				break;
			case QUOTED_NAME:
				{
				int LA36_2 = input.LA(2);
				if ( (LA36_2==K_FROM||LA36_2==144) ) {
					alt36=1;
				}
				else if ( (LA36_2==154) ) {
					alt36=2;
				}

				else {
					int nvaeMark = input.mark();
					try {
						input.consume();
						NoViableAltException nvae =
							new NoViableAltException("", 36, 2, input);
						throw nvae;
					} finally {
						input.rewind(nvaeMark);
					}
				}

				}
				break;
			case K_ALL:
			case K_AS:
			case K_CLUSTERING:
			case K_COMPACT:
			case K_CONTAINS:
			case K_CUSTOM:
			case K_DISTINCT:
			case K_EXISTS:
			case K_FILTERING:
			case K_KEYS:
			case K_KEYSPACES:
			case K_LIST:
			case K_MAP:
			case K_NOSUPERUSER:
			case K_PASSWORD:
			case K_PERMISSION:
			case K_PERMISSIONS:
			case K_STATIC:
			case K_STORAGE:
			case K_SUPERUSER:
			case K_TRIGGER:
			case K_TYPE:
			case K_USER:
			case K_USERS:
			case K_VALUES:
				{
				int LA36_3 = input.LA(2);
				if ( (LA36_3==K_FROM||LA36_3==144) ) {
					alt36=1;
				}
				else if ( (LA36_3==154) ) {
					alt36=2;
				}

				else {
					int nvaeMark = input.mark();
					try {
						input.consume();
						NoViableAltException nvae =
							new NoViableAltException("", 36, 3, input);
						throw nvae;
					} finally {
						input.rewind(nvaeMark);
					}
				}

				}
				break;
			case K_ASCII:
				{
				int LA36_4 = input.LA(2);
				if ( (LA36_4==K_FROM||LA36_4==144) ) {
					alt36=1;
				}
				else if ( (LA36_4==154) ) {
					alt36=2;
				}

				else {
					int nvaeMark = input.mark();
					try {
						input.consume();
						NoViableAltException nvae =
							new NoViableAltException("", 36, 4, input);
						throw nvae;
					} finally {
						input.rewind(nvaeMark);
					}
				}

				}
				break;
			case K_BIGINT:
				{
				int LA36_5 = input.LA(2);
				if ( (LA36_5==K_FROM||LA36_5==144) ) {
					alt36=1;
				}
				else if ( (LA36_5==154) ) {
					alt36=2;
				}

				else {
					int nvaeMark = input.mark();
					try {
						input.consume();
						NoViableAltException nvae =
							new NoViableAltException("", 36, 5, input);
						throw nvae;
					} finally {
						input.rewind(nvaeMark);
					}
				}

				}
				break;
			case K_BLOB:
				{
				int LA36_6 = input.LA(2);
				if ( (LA36_6==K_FROM||LA36_6==144) ) {
					alt36=1;
				}
				else if ( (LA36_6==154) ) {
					alt36=2;
				}

				else {
					int nvaeMark = input.mark();
					try {
						input.consume();
						NoViableAltException nvae =
							new NoViableAltException("", 36, 6, input);
						throw nvae;
					} finally {
						input.rewind(nvaeMark);
					}
				}

				}
				break;
			case K_BOOLEAN:
				{
				int LA36_7 = input.LA(2);
				if ( (LA36_7==K_FROM||LA36_7==144) ) {
					alt36=1;
				}
				else if ( (LA36_7==154) ) {
					alt36=2;
				}

				else {
					int nvaeMark = input.mark();
					try {
						input.consume();
						NoViableAltException nvae =
							new NoViableAltException("", 36, 7, input);
						throw nvae;
					} finally {
						input.rewind(nvaeMark);
					}
				}

				}
				break;
			case K_COUNTER:
				{
				int LA36_8 = input.LA(2);
				if ( (LA36_8==K_FROM||LA36_8==144) ) {
					alt36=1;
				}
				else if ( (LA36_8==154) ) {
					alt36=2;
				}

				else {
					int nvaeMark = input.mark();
					try {
						input.consume();
						NoViableAltException nvae =
							new NoViableAltException("", 36, 8, input);
						throw nvae;
					} finally {
						input.rewind(nvaeMark);
					}
				}

				}
				break;
			case K_DECIMAL:
				{
				int LA36_9 = input.LA(2);
				if ( (LA36_9==K_FROM||LA36_9==144) ) {
					alt36=1;
				}
				else if ( (LA36_9==154) ) {
					alt36=2;
				}

				else {
					int nvaeMark = input.mark();
					try {
						input.consume();
						NoViableAltException nvae =
							new NoViableAltException("", 36, 9, input);
						throw nvae;
					} finally {
						input.rewind(nvaeMark);
					}
				}

				}
				break;
			case K_DOUBLE:
				{
				int LA36_10 = input.LA(2);
				if ( (LA36_10==K_FROM||LA36_10==144) ) {
					alt36=1;
				}
				else if ( (LA36_10==154) ) {
					alt36=2;
				}

				else {
					int nvaeMark = input.mark();
					try {
						input.consume();
						NoViableAltException nvae =
							new NoViableAltException("", 36, 10, input);
						throw nvae;
					} finally {
						input.rewind(nvaeMark);
					}
				}

				}
				break;
			case K_FLOAT:
				{
				int LA36_11 = input.LA(2);
				if ( (LA36_11==K_FROM||LA36_11==144) ) {
					alt36=1;
				}
				else if ( (LA36_11==154) ) {
					alt36=2;
				}

				else {
					int nvaeMark = input.mark();
					try {
						input.consume();
						NoViableAltException nvae =
							new NoViableAltException("", 36, 11, input);
						throw nvae;
					} finally {
						input.rewind(nvaeMark);
					}
				}

				}
				break;
			case K_INET:
				{
				int LA36_12 = input.LA(2);
				if ( (LA36_12==K_FROM||LA36_12==144) ) {
					alt36=1;
				}
				else if ( (LA36_12==154) ) {
					alt36=2;
				}

				else {
					int nvaeMark = input.mark();
					try {
						input.consume();
						NoViableAltException nvae =
							new NoViableAltException("", 36, 12, input);
						throw nvae;
					} finally {
						input.rewind(nvaeMark);
					}
				}

				}
				break;
			case K_INT:
				{
				int LA36_13 = input.LA(2);
				if ( (LA36_13==K_FROM||LA36_13==144) ) {
					alt36=1;
				}
				else if ( (LA36_13==154) ) {
					alt36=2;
				}

				else {
					int nvaeMark = input.mark();
					try {
						input.consume();
						NoViableAltException nvae =
							new NoViableAltException("", 36, 13, input);
						throw nvae;
					} finally {
						input.rewind(nvaeMark);
					}
				}

				}
				break;
			case K_TEXT:
				{
				int LA36_14 = input.LA(2);
				if ( (LA36_14==K_FROM||LA36_14==144) ) {
					alt36=1;
				}
				else if ( (LA36_14==154) ) {
					alt36=2;
				}

				else {
					int nvaeMark = input.mark();
					try {
						input.consume();
						NoViableAltException nvae =
							new NoViableAltException("", 36, 14, input);
						throw nvae;
					} finally {
						input.rewind(nvaeMark);
					}
				}

				}
				break;
			case K_TIMESTAMP:
				{
				int LA36_15 = input.LA(2);
				if ( (LA36_15==K_FROM||LA36_15==144) ) {
					alt36=1;
				}
				else if ( (LA36_15==154) ) {
					alt36=2;
				}

				else {
					int nvaeMark = input.mark();
					try {
						input.consume();
						NoViableAltException nvae =
							new NoViableAltException("", 36, 15, input);
						throw nvae;
					} finally {
						input.rewind(nvaeMark);
					}
				}

				}
				break;
			case K_UUID:
				{
				int LA36_16 = input.LA(2);
				if ( (LA36_16==K_FROM||LA36_16==144) ) {
					alt36=1;
				}
				else if ( (LA36_16==154) ) {
					alt36=2;
				}

				else {
					int nvaeMark = input.mark();
					try {
						input.consume();
						NoViableAltException nvae =
							new NoViableAltException("", 36, 16, input);
						throw nvae;
					} finally {
						input.rewind(nvaeMark);
					}
				}

				}
				break;
			case K_VARCHAR:
				{
				int LA36_17 = input.LA(2);
				if ( (LA36_17==K_FROM||LA36_17==144) ) {
					alt36=1;
				}
				else if ( (LA36_17==154) ) {
					alt36=2;
				}

				else {
					int nvaeMark = input.mark();
					try {
						input.consume();
						NoViableAltException nvae =
							new NoViableAltException("", 36, 17, input);
						throw nvae;
					} finally {
						input.rewind(nvaeMark);
					}
				}

				}
				break;
			case K_VARINT:
				{
				int LA36_18 = input.LA(2);
				if ( (LA36_18==K_FROM||LA36_18==144) ) {
					alt36=1;
				}
				else if ( (LA36_18==154) ) {
					alt36=2;
				}

				else {
					int nvaeMark = input.mark();
					try {
						input.consume();
						NoViableAltException nvae =
							new NoViableAltException("", 36, 18, input);
						throw nvae;
					} finally {
						input.rewind(nvaeMark);
					}
				}

				}
				break;
			case K_TIMEUUID:
				{
				int LA36_19 = input.LA(2);
				if ( (LA36_19==K_FROM||LA36_19==144) ) {
					alt36=1;
				}
				else if ( (LA36_19==154) ) {
					alt36=2;
				}

				else {
					int nvaeMark = input.mark();
					try {
						input.consume();
						NoViableAltException nvae =
							new NoViableAltException("", 36, 19, input);
						throw nvae;
					} finally {
						input.rewind(nvaeMark);
					}
				}

				}
				break;
			case K_COUNT:
			case K_KEY:
			case K_TTL:
			case K_WRITETIME:
				{
				int LA36_20 = input.LA(2);
				if ( (LA36_20==K_FROM||LA36_20==144) ) {
					alt36=1;
				}
				else if ( (LA36_20==154) ) {
					alt36=2;
				}

				else {
					int nvaeMark = input.mark();
					try {
						input.consume();
						NoViableAltException nvae =
							new NoViableAltException("", 36, 20, input);
						throw nvae;
					} finally {
						input.rewind(nvaeMark);
					}
				}

				}
				break;
			default:
				NoViableAltException nvae =
					new NoViableAltException("", 36, 0, input);
				throw nvae;
			}
			switch (alt36) {
				case 1 :
					// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:434:7: c= cident
					{
					pushFollow(FOLLOW_cident_in_deleteOp1955);
					c=cident();
					state._fsp--;

					 op = new Operation.ColumnDeletion(c); 
					}
					break;
				case 2 :
					// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:435:7: c= cident '[' t= term ']'
					{
					pushFollow(FOLLOW_cident_in_deleteOp1982);
					c=cident();
					state._fsp--;

					match(input,154,FOLLOW_154_in_deleteOp1984); 
					pushFollow(FOLLOW_term_in_deleteOp1988);
					t=term();
					state._fsp--;

					match(input,156,FOLLOW_156_in_deleteOp1990); 
					 op = new Operation.ElementDeletion(c, t); 
					}
					break;

			}
		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return op;
	}
	// $ANTLR end "deleteOp"



	// $ANTLR start "usingClauseDelete"
	// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:438:1: usingClauseDelete[Attributes.Raw attrs] : K_USING K_TIMESTAMP ts= intValue ;
	public final void usingClauseDelete(Attributes.Raw attrs) throws RecognitionException {
		Term.Raw ts =null;

		try {
			// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:439:5: ( K_USING K_TIMESTAMP ts= intValue )
			// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:439:7: K_USING K_TIMESTAMP ts= intValue
			{
			match(input,K_USING,FOLLOW_K_USING_in_usingClauseDelete2010); 
			match(input,K_TIMESTAMP,FOLLOW_K_TIMESTAMP_in_usingClauseDelete2012); 
			pushFollow(FOLLOW_intValue_in_usingClauseDelete2016);
			ts=intValue();
			state._fsp--;

			 attrs.timestamp = ts; 
			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "usingClauseDelete"



	// $ANTLR start "batchStatement"
	// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:466:1: batchStatement returns [BatchStatement.Parsed expr] : K_BEGIN ( K_UNLOGGED | K_COUNTER )? K_BATCH ( usingClause[attrs] )? (s= batchStatementObjective ( ';' )? )* K_APPLY K_BATCH ;
	public final BatchStatement.Parsed batchStatement() throws RecognitionException {
		BatchStatement.Parsed expr = null;


		ModificationStatement.Parsed s =null;


		        BatchStatement.Type type = BatchStatement.Type.LOGGED;
		        List<ModificationStatement.Parsed> statements = new ArrayList<ModificationStatement.Parsed>();
		        Attributes.Raw attrs = new Attributes.Raw();
		    
		try {
			// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:472:5: ( K_BEGIN ( K_UNLOGGED | K_COUNTER )? K_BATCH ( usingClause[attrs] )? (s= batchStatementObjective ( ';' )? )* K_APPLY K_BATCH )
			// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:472:7: K_BEGIN ( K_UNLOGGED | K_COUNTER )? K_BATCH ( usingClause[attrs] )? (s= batchStatementObjective ( ';' )? )* K_APPLY K_BATCH
			{
			match(input,K_BEGIN,FOLLOW_K_BEGIN_in_batchStatement2050); 
			// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:473:7: ( K_UNLOGGED | K_COUNTER )?
			int alt37=3;
			int LA37_0 = input.LA(1);
			if ( (LA37_0==K_UNLOGGED) ) {
				alt37=1;
			}
			else if ( (LA37_0==K_COUNTER) ) {
				alt37=2;
			}
			switch (alt37) {
				case 1 :
					// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:473:9: K_UNLOGGED
					{
					match(input,K_UNLOGGED,FOLLOW_K_UNLOGGED_in_batchStatement2060); 
					 type = BatchStatement.Type.UNLOGGED; 
					}
					break;
				case 2 :
					// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:473:63: K_COUNTER
					{
					match(input,K_COUNTER,FOLLOW_K_COUNTER_in_batchStatement2066); 
					 type = BatchStatement.Type.COUNTER; 
					}
					break;

			}

			match(input,K_BATCH,FOLLOW_K_BATCH_in_batchStatement2079); 
			// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:474:15: ( usingClause[attrs] )?
			int alt38=2;
			int LA38_0 = input.LA(1);
			if ( (LA38_0==K_USING) ) {
				alt38=1;
			}
			switch (alt38) {
				case 1 :
					// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:474:17: usingClause[attrs]
					{
					pushFollow(FOLLOW_usingClause_in_batchStatement2083);
					usingClause(attrs);
					state._fsp--;

					}
					break;

			}

			// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:475:11: (s= batchStatementObjective ( ';' )? )*
			loop40:
			while (true) {
				int alt40=2;
				int LA40_0 = input.LA(1);
				if ( (LA40_0==K_DELETE||LA40_0==K_INSERT||LA40_0==K_UPDATE) ) {
					alt40=1;
				}

				switch (alt40) {
				case 1 :
					// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:475:13: s= batchStatementObjective ( ';' )?
					{
					pushFollow(FOLLOW_batchStatementObjective_in_batchStatement2103);
					s=batchStatementObjective();
					state._fsp--;

					// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:475:39: ( ';' )?
					int alt39=2;
					int LA39_0 = input.LA(1);
					if ( (LA39_0==148) ) {
						alt39=1;
					}
					switch (alt39) {
						case 1 :
							// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:475:39: ';'
							{
							match(input,148,FOLLOW_148_in_batchStatement2105); 
							}
							break;

					}

					 statements.add(s); 
					}
					break;

				default :
					break loop40;
				}
			}

			match(input,K_APPLY,FOLLOW_K_APPLY_in_batchStatement2119); 
			match(input,K_BATCH,FOLLOW_K_BATCH_in_batchStatement2121); 

			          return new BatchStatement.Parsed(type, attrs, statements);
			      
			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return expr;
	}
	// $ANTLR end "batchStatement"



	// $ANTLR start "batchStatementObjective"
	// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:482:1: batchStatementObjective returns [ModificationStatement.Parsed statement] : (i= insertStatement |u= updateStatement |d= deleteStatement );
	public final ModificationStatement.Parsed batchStatementObjective() throws RecognitionException {
		ModificationStatement.Parsed statement = null;


		UpdateStatement.ParsedInsert i =null;
		UpdateStatement.ParsedUpdate u =null;
		DeleteStatement.Parsed d =null;

		try {
			// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:483:5: (i= insertStatement |u= updateStatement |d= deleteStatement )
			int alt41=3;
			switch ( input.LA(1) ) {
			case K_INSERT:
				{
				alt41=1;
				}
				break;
			case K_UPDATE:
				{
				alt41=2;
				}
				break;
			case K_DELETE:
				{
				alt41=3;
				}
				break;
			default:
				NoViableAltException nvae =
					new NoViableAltException("", 41, 0, input);
				throw nvae;
			}
			switch (alt41) {
				case 1 :
					// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:483:7: i= insertStatement
					{
					pushFollow(FOLLOW_insertStatement_in_batchStatementObjective2152);
					i=insertStatement();
					state._fsp--;

					 statement = i; 
					}
					break;
				case 2 :
					// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:484:7: u= updateStatement
					{
					pushFollow(FOLLOW_updateStatement_in_batchStatementObjective2165);
					u=updateStatement();
					state._fsp--;

					 statement = u; 
					}
					break;
				case 3 :
					// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:485:7: d= deleteStatement
					{
					pushFollow(FOLLOW_deleteStatement_in_batchStatementObjective2178);
					d=deleteStatement();
					state._fsp--;

					 statement = d; 
					}
					break;

			}
		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return statement;
	}
	// $ANTLR end "batchStatementObjective"



	// $ANTLR start "createKeyspaceStatement"
	// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:491:1: createKeyspaceStatement returns [CreateKeyspaceStatement expr] : K_CREATE K_KEYSPACE ( K_IF K_NOT K_EXISTS )? ks= keyspaceName K_WITH properties[attrs] ;
	public final CreateKeyspaceStatement createKeyspaceStatement() throws RecognitionException {
		CreateKeyspaceStatement expr = null;


		String ks =null;


		        KSPropDefs attrs = new KSPropDefs();
		        boolean ifNotExists = false;
		    
		try {
			// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:496:5: ( K_CREATE K_KEYSPACE ( K_IF K_NOT K_EXISTS )? ks= keyspaceName K_WITH properties[attrs] )
			// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:496:7: K_CREATE K_KEYSPACE ( K_IF K_NOT K_EXISTS )? ks= keyspaceName K_WITH properties[attrs]
			{
			match(input,K_CREATE,FOLLOW_K_CREATE_in_createKeyspaceStatement2213); 
			match(input,K_KEYSPACE,FOLLOW_K_KEYSPACE_in_createKeyspaceStatement2215); 
			// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:496:27: ( K_IF K_NOT K_EXISTS )?
			int alt42=2;
			int LA42_0 = input.LA(1);
			if ( (LA42_0==K_IF) ) {
				alt42=1;
			}
			switch (alt42) {
				case 1 :
					// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:496:28: K_IF K_NOT K_EXISTS
					{
					match(input,K_IF,FOLLOW_K_IF_in_createKeyspaceStatement2218); 
					match(input,K_NOT,FOLLOW_K_NOT_in_createKeyspaceStatement2220); 
					match(input,K_EXISTS,FOLLOW_K_EXISTS_in_createKeyspaceStatement2222); 
					 ifNotExists = true; 
					}
					break;

			}

			pushFollow(FOLLOW_keyspaceName_in_createKeyspaceStatement2231);
			ks=keyspaceName();
			state._fsp--;

			match(input,K_WITH,FOLLOW_K_WITH_in_createKeyspaceStatement2239); 
			pushFollow(FOLLOW_properties_in_createKeyspaceStatement2241);
			properties(attrs);
			state._fsp--;

			 expr = new CreateKeyspaceStatement(ks, attrs, ifNotExists); 
			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return expr;
	}
	// $ANTLR end "createKeyspaceStatement"



	// $ANTLR start "createTableStatement"
	// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:507:1: createTableStatement returns [CreateTableStatement.RawStatement expr] : K_CREATE K_COLUMNFAMILY ( K_IF K_NOT K_EXISTS )? cf= columnFamilyName cfamDefinition[expr] ;
	public final CreateTableStatement.RawStatement createTableStatement() throws RecognitionException {
		CreateTableStatement.RawStatement expr = null;


		CFName cf =null;

		 boolean ifNotExists = false; 
		try {
			// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:509:5: ( K_CREATE K_COLUMNFAMILY ( K_IF K_NOT K_EXISTS )? cf= columnFamilyName cfamDefinition[expr] )
			// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:509:7: K_CREATE K_COLUMNFAMILY ( K_IF K_NOT K_EXISTS )? cf= columnFamilyName cfamDefinition[expr]
			{
			match(input,K_CREATE,FOLLOW_K_CREATE_in_createTableStatement2276); 
			match(input,K_COLUMNFAMILY,FOLLOW_K_COLUMNFAMILY_in_createTableStatement2278); 
			// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:509:31: ( K_IF K_NOT K_EXISTS )?
			int alt43=2;
			int LA43_0 = input.LA(1);
			if ( (LA43_0==K_IF) ) {
				alt43=1;
			}
			switch (alt43) {
				case 1 :
					// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:509:32: K_IF K_NOT K_EXISTS
					{
					match(input,K_IF,FOLLOW_K_IF_in_createTableStatement2281); 
					match(input,K_NOT,FOLLOW_K_NOT_in_createTableStatement2283); 
					match(input,K_EXISTS,FOLLOW_K_EXISTS_in_createTableStatement2285); 
					 ifNotExists = true; 
					}
					break;

			}

			pushFollow(FOLLOW_columnFamilyName_in_createTableStatement2300);
			cf=columnFamilyName();
			state._fsp--;

			 expr = new CreateTableStatement.RawStatement(cf, ifNotExists); 
			pushFollow(FOLLOW_cfamDefinition_in_createTableStatement2310);
			cfamDefinition(expr);
			state._fsp--;

			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return expr;
	}
	// $ANTLR end "createTableStatement"



	// $ANTLR start "cfamDefinition"
	// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:514:1: cfamDefinition[CreateTableStatement.RawStatement expr] : '(' cfamColumns[expr] ( ',' ( cfamColumns[expr] )? )* ')' ( K_WITH cfamProperty[expr] ( K_AND cfamProperty[expr] )* )? ;
	public final void cfamDefinition(CreateTableStatement.RawStatement expr) throws RecognitionException {
		try {
			// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:515:5: ( '(' cfamColumns[expr] ( ',' ( cfamColumns[expr] )? )* ')' ( K_WITH cfamProperty[expr] ( K_AND cfamProperty[expr] )* )? )
			// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:515:7: '(' cfamColumns[expr] ( ',' ( cfamColumns[expr] )? )* ')' ( K_WITH cfamProperty[expr] ( K_AND cfamProperty[expr] )* )?
			{
			match(input,141,FOLLOW_141_in_cfamDefinition2329); 
			pushFollow(FOLLOW_cfamColumns_in_cfamDefinition2331);
			cfamColumns(expr);
			state._fsp--;

			// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:515:29: ( ',' ( cfamColumns[expr] )? )*
			loop45:
			while (true) {
				int alt45=2;
				int LA45_0 = input.LA(1);
				if ( (LA45_0==144) ) {
					alt45=1;
				}

				switch (alt45) {
				case 1 :
					// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:515:31: ',' ( cfamColumns[expr] )?
					{
					match(input,144,FOLLOW_144_in_cfamDefinition2336); 
					// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:515:35: ( cfamColumns[expr] )?
					int alt44=2;
					int LA44_0 = input.LA(1);
					if ( (LA44_0==IDENT||LA44_0==K_ALL||LA44_0==K_AS||LA44_0==K_ASCII||(LA44_0 >= K_BIGINT && LA44_0 <= K_BOOLEAN)||LA44_0==K_CLUSTERING||(LA44_0 >= K_COMPACT && LA44_0 <= K_COUNTER)||(LA44_0 >= K_CUSTOM && LA44_0 <= K_DECIMAL)||(LA44_0 >= K_DISTINCT && LA44_0 <= K_DOUBLE)||(LA44_0 >= K_EXISTS && LA44_0 <= K_FLOAT)||LA44_0==K_INET||LA44_0==K_INT||(LA44_0 >= K_KEY && LA44_0 <= K_KEYS)||LA44_0==K_KEYSPACES||(LA44_0 >= K_LIST && LA44_0 <= K_MAP)||LA44_0==K_NOSUPERUSER||(LA44_0 >= K_PASSWORD && LA44_0 <= K_PRIMARY)||(LA44_0 >= K_STATIC && LA44_0 <= K_TIMEUUID)||LA44_0==K_TRIGGER||LA44_0==K_TTL||LA44_0==K_TYPE||(LA44_0 >= K_USER && LA44_0 <= K_USERS)||(LA44_0 >= K_UUID && LA44_0 <= K_VARINT)||LA44_0==K_WRITETIME||LA44_0==QUOTED_NAME) ) {
						alt44=1;
					}
					switch (alt44) {
						case 1 :
							// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:515:35: cfamColumns[expr]
							{
							pushFollow(FOLLOW_cfamColumns_in_cfamDefinition2338);
							cfamColumns(expr);
							state._fsp--;

							}
							break;

					}

					}
					break;

				default :
					break loop45;
				}
			}

			match(input,142,FOLLOW_142_in_cfamDefinition2345); 
			// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:516:7: ( K_WITH cfamProperty[expr] ( K_AND cfamProperty[expr] )* )?
			int alt47=2;
			int LA47_0 = input.LA(1);
			if ( (LA47_0==K_WITH) ) {
				alt47=1;
			}
			switch (alt47) {
				case 1 :
					// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:516:9: K_WITH cfamProperty[expr] ( K_AND cfamProperty[expr] )*
					{
					match(input,K_WITH,FOLLOW_K_WITH_in_cfamDefinition2355); 
					pushFollow(FOLLOW_cfamProperty_in_cfamDefinition2357);
					cfamProperty(expr);
					state._fsp--;

					// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:516:35: ( K_AND cfamProperty[expr] )*
					loop46:
					while (true) {
						int alt46=2;
						int LA46_0 = input.LA(1);
						if ( (LA46_0==K_AND) ) {
							alt46=1;
						}

						switch (alt46) {
						case 1 :
							// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:516:37: K_AND cfamProperty[expr]
							{
							match(input,K_AND,FOLLOW_K_AND_in_cfamDefinition2362); 
							pushFollow(FOLLOW_cfamProperty_in_cfamDefinition2364);
							cfamProperty(expr);
							state._fsp--;

							}
							break;

						default :
							break loop46;
						}
					}

					}
					break;

			}

			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "cfamDefinition"



	// $ANTLR start "cfamColumns"
	// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:519:1: cfamColumns[CreateTableStatement.RawStatement expr] : (k= ident v= comparatorType ( K_STATIC )? ( K_PRIMARY K_KEY )? | K_PRIMARY K_KEY '(' pkDef[expr] ( ',' c= ident )* ')' );
	public final void cfamColumns(CreateTableStatement.RawStatement expr) throws RecognitionException {
		ColumnIdentifier k =null;
		CQL3Type.Raw v =null;
		ColumnIdentifier c =null;

		try {
			// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:520:5: (k= ident v= comparatorType ( K_STATIC )? ( K_PRIMARY K_KEY )? | K_PRIMARY K_KEY '(' pkDef[expr] ( ',' c= ident )* ')' )
			int alt51=2;
			int LA51_0 = input.LA(1);
			if ( (LA51_0==IDENT||LA51_0==K_ALL||LA51_0==K_AS||LA51_0==K_ASCII||(LA51_0 >= K_BIGINT && LA51_0 <= K_BOOLEAN)||LA51_0==K_CLUSTERING||(LA51_0 >= K_COMPACT && LA51_0 <= K_COUNTER)||(LA51_0 >= K_CUSTOM && LA51_0 <= K_DECIMAL)||(LA51_0 >= K_DISTINCT && LA51_0 <= K_DOUBLE)||(LA51_0 >= K_EXISTS && LA51_0 <= K_FLOAT)||LA51_0==K_INET||LA51_0==K_INT||(LA51_0 >= K_KEY && LA51_0 <= K_KEYS)||LA51_0==K_KEYSPACES||(LA51_0 >= K_LIST && LA51_0 <= K_MAP)||LA51_0==K_NOSUPERUSER||(LA51_0 >= K_PASSWORD && LA51_0 <= K_PERMISSIONS)||(LA51_0 >= K_STATIC && LA51_0 <= K_TIMEUUID)||LA51_0==K_TRIGGER||LA51_0==K_TTL||LA51_0==K_TYPE||(LA51_0 >= K_USER && LA51_0 <= K_USERS)||(LA51_0 >= K_UUID && LA51_0 <= K_VARINT)||LA51_0==K_WRITETIME||LA51_0==QUOTED_NAME) ) {
				alt51=1;
			}
			else if ( (LA51_0==K_PRIMARY) ) {
				alt51=2;
			}

			else {
				NoViableAltException nvae =
					new NoViableAltException("", 51, 0, input);
				throw nvae;
			}

			switch (alt51) {
				case 1 :
					// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:520:7: k= ident v= comparatorType ( K_STATIC )? ( K_PRIMARY K_KEY )?
					{
					pushFollow(FOLLOW_ident_in_cfamColumns2390);
					k=ident();
					state._fsp--;

					pushFollow(FOLLOW_comparatorType_in_cfamColumns2394);
					v=comparatorType();
					state._fsp--;

					 boolean isStatic=false; 
					// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:520:60: ( K_STATIC )?
					int alt48=2;
					int LA48_0 = input.LA(1);
					if ( (LA48_0==K_STATIC) ) {
						alt48=1;
					}
					switch (alt48) {
						case 1 :
							// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:520:61: K_STATIC
							{
							match(input,K_STATIC,FOLLOW_K_STATIC_in_cfamColumns2399); 
							isStatic = true;
							}
							break;

					}

					 expr.addDefinition(k, v, isStatic); 
					// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:521:9: ( K_PRIMARY K_KEY )?
					int alt49=2;
					int LA49_0 = input.LA(1);
					if ( (LA49_0==K_PRIMARY) ) {
						alt49=1;
					}
					switch (alt49) {
						case 1 :
							// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:521:10: K_PRIMARY K_KEY
							{
							match(input,K_PRIMARY,FOLLOW_K_PRIMARY_in_cfamColumns2416); 
							match(input,K_KEY,FOLLOW_K_KEY_in_cfamColumns2418); 
							 expr.addKeyAliases(Collections.singletonList(k)); 
							}
							break;

					}

					}
					break;
				case 2 :
					// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:522:7: K_PRIMARY K_KEY '(' pkDef[expr] ( ',' c= ident )* ')'
					{
					match(input,K_PRIMARY,FOLLOW_K_PRIMARY_in_cfamColumns2430); 
					match(input,K_KEY,FOLLOW_K_KEY_in_cfamColumns2432); 
					match(input,141,FOLLOW_141_in_cfamColumns2434); 
					pushFollow(FOLLOW_pkDef_in_cfamColumns2436);
					pkDef(expr);
					state._fsp--;

					// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:522:39: ( ',' c= ident )*
					loop50:
					while (true) {
						int alt50=2;
						int LA50_0 = input.LA(1);
						if ( (LA50_0==144) ) {
							alt50=1;
						}

						switch (alt50) {
						case 1 :
							// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:522:40: ',' c= ident
							{
							match(input,144,FOLLOW_144_in_cfamColumns2440); 
							pushFollow(FOLLOW_ident_in_cfamColumns2444);
							c=ident();
							state._fsp--;

							 expr.addColumnAlias(c); 
							}
							break;

						default :
							break loop50;
						}
					}

					match(input,142,FOLLOW_142_in_cfamColumns2451); 
					}
					break;

			}
		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "cfamColumns"



	// $ANTLR start "pkDef"
	// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:525:1: pkDef[CreateTableStatement.RawStatement expr] : (k= ident | '(' k1= ident ( ',' kn= ident )* ')' );
	public final void pkDef(CreateTableStatement.RawStatement expr) throws RecognitionException {
		ColumnIdentifier k =null;
		ColumnIdentifier k1 =null;
		ColumnIdentifier kn =null;

		try {
			// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:526:5: (k= ident | '(' k1= ident ( ',' kn= ident )* ')' )
			int alt53=2;
			int LA53_0 = input.LA(1);
			if ( (LA53_0==IDENT||LA53_0==K_ALL||LA53_0==K_AS||LA53_0==K_ASCII||(LA53_0 >= K_BIGINT && LA53_0 <= K_BOOLEAN)||LA53_0==K_CLUSTERING||(LA53_0 >= K_COMPACT && LA53_0 <= K_COUNTER)||(LA53_0 >= K_CUSTOM && LA53_0 <= K_DECIMAL)||(LA53_0 >= K_DISTINCT && LA53_0 <= K_DOUBLE)||(LA53_0 >= K_EXISTS && LA53_0 <= K_FLOAT)||LA53_0==K_INET||LA53_0==K_INT||(LA53_0 >= K_KEY && LA53_0 <= K_KEYS)||LA53_0==K_KEYSPACES||(LA53_0 >= K_LIST && LA53_0 <= K_MAP)||LA53_0==K_NOSUPERUSER||(LA53_0 >= K_PASSWORD && LA53_0 <= K_PERMISSIONS)||(LA53_0 >= K_STATIC && LA53_0 <= K_TIMEUUID)||LA53_0==K_TRIGGER||LA53_0==K_TTL||LA53_0==K_TYPE||(LA53_0 >= K_USER && LA53_0 <= K_USERS)||(LA53_0 >= K_UUID && LA53_0 <= K_VARINT)||LA53_0==K_WRITETIME||LA53_0==QUOTED_NAME) ) {
				alt53=1;
			}
			else if ( (LA53_0==141) ) {
				alt53=2;
			}

			else {
				NoViableAltException nvae =
					new NoViableAltException("", 53, 0, input);
				throw nvae;
			}

			switch (alt53) {
				case 1 :
					// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:526:7: k= ident
					{
					pushFollow(FOLLOW_ident_in_pkDef2471);
					k=ident();
					state._fsp--;

					 expr.addKeyAliases(Collections.singletonList(k)); 
					}
					break;
				case 2 :
					// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:527:7: '(' k1= ident ( ',' kn= ident )* ')'
					{
					match(input,141,FOLLOW_141_in_pkDef2481); 
					 List<ColumnIdentifier> l = new ArrayList<ColumnIdentifier>(); 
					pushFollow(FOLLOW_ident_in_pkDef2487);
					k1=ident();
					state._fsp--;

					 l.add(k1); 
					// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:527:101: ( ',' kn= ident )*
					loop52:
					while (true) {
						int alt52=2;
						int LA52_0 = input.LA(1);
						if ( (LA52_0==144) ) {
							alt52=1;
						}

						switch (alt52) {
						case 1 :
							// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:527:103: ',' kn= ident
							{
							match(input,144,FOLLOW_144_in_pkDef2493); 
							pushFollow(FOLLOW_ident_in_pkDef2497);
							kn=ident();
							state._fsp--;

							 l.add(kn); 
							}
							break;

						default :
							break loop52;
						}
					}

					match(input,142,FOLLOW_142_in_pkDef2504); 
					 expr.addKeyAliases(l); 
					}
					break;

			}
		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "pkDef"



	// $ANTLR start "cfamProperty"
	// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:530:1: cfamProperty[CreateTableStatement.RawStatement expr] : ( property[expr.properties] | K_COMPACT K_STORAGE | K_CLUSTERING K_ORDER K_BY '(' cfamOrdering[expr] ( ',' cfamOrdering[expr] )* ')' );
	public final void cfamProperty(CreateTableStatement.RawStatement expr) throws RecognitionException {
		try {
			// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:531:5: ( property[expr.properties] | K_COMPACT K_STORAGE | K_CLUSTERING K_ORDER K_BY '(' cfamOrdering[expr] ( ',' cfamOrdering[expr] )* ')' )
			int alt55=3;
			switch ( input.LA(1) ) {
			case IDENT:
			case K_ALL:
			case K_AS:
			case K_ASCII:
			case K_BIGINT:
			case K_BLOB:
			case K_BOOLEAN:
			case K_CONTAINS:
			case K_COUNT:
			case K_COUNTER:
			case K_CUSTOM:
			case K_DECIMAL:
			case K_DISTINCT:
			case K_DOUBLE:
			case K_EXISTS:
			case K_FILTERING:
			case K_FLOAT:
			case K_INET:
			case K_INT:
			case K_KEY:
			case K_KEYS:
			case K_KEYSPACES:
			case K_LIST:
			case K_MAP:
			case K_NOSUPERUSER:
			case K_PASSWORD:
			case K_PERMISSION:
			case K_PERMISSIONS:
			case K_STATIC:
			case K_STORAGE:
			case K_SUPERUSER:
			case K_TEXT:
			case K_TIMESTAMP:
			case K_TIMEUUID:
			case K_TRIGGER:
			case K_TTL:
			case K_TYPE:
			case K_USER:
			case K_USERS:
			case K_UUID:
			case K_VALUES:
			case K_VARCHAR:
			case K_VARINT:
			case K_WRITETIME:
			case QUOTED_NAME:
				{
				alt55=1;
				}
				break;
			case K_COMPACT:
				{
				int LA55_2 = input.LA(2);
				if ( (LA55_2==K_STORAGE) ) {
					alt55=2;
				}
				else if ( (LA55_2==151) ) {
					alt55=1;
				}

				else {
					int nvaeMark = input.mark();
					try {
						input.consume();
						NoViableAltException nvae =
							new NoViableAltException("", 55, 2, input);
						throw nvae;
					} finally {
						input.rewind(nvaeMark);
					}
				}

				}
				break;
			case K_CLUSTERING:
				{
				int LA55_3 = input.LA(2);
				if ( (LA55_3==K_ORDER) ) {
					alt55=3;
				}
				else if ( (LA55_3==151) ) {
					alt55=1;
				}

				else {
					int nvaeMark = input.mark();
					try {
						input.consume();
						NoViableAltException nvae =
							new NoViableAltException("", 55, 3, input);
						throw nvae;
					} finally {
						input.rewind(nvaeMark);
					}
				}

				}
				break;
			default:
				NoViableAltException nvae =
					new NoViableAltException("", 55, 0, input);
				throw nvae;
			}
			switch (alt55) {
				case 1 :
					// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:531:7: property[expr.properties]
					{
					pushFollow(FOLLOW_property_in_cfamProperty2524);
					property(expr.properties);
					state._fsp--;

					}
					break;
				case 2 :
					// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:532:7: K_COMPACT K_STORAGE
					{
					match(input,K_COMPACT,FOLLOW_K_COMPACT_in_cfamProperty2533); 
					match(input,K_STORAGE,FOLLOW_K_STORAGE_in_cfamProperty2535); 
					 expr.setCompactStorage(); 
					}
					break;
				case 3 :
					// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:533:7: K_CLUSTERING K_ORDER K_BY '(' cfamOrdering[expr] ( ',' cfamOrdering[expr] )* ')'
					{
					match(input,K_CLUSTERING,FOLLOW_K_CLUSTERING_in_cfamProperty2545); 
					match(input,K_ORDER,FOLLOW_K_ORDER_in_cfamProperty2547); 
					match(input,K_BY,FOLLOW_K_BY_in_cfamProperty2549); 
					match(input,141,FOLLOW_141_in_cfamProperty2551); 
					pushFollow(FOLLOW_cfamOrdering_in_cfamProperty2553);
					cfamOrdering(expr);
					state._fsp--;

					// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:533:56: ( ',' cfamOrdering[expr] )*
					loop54:
					while (true) {
						int alt54=2;
						int LA54_0 = input.LA(1);
						if ( (LA54_0==144) ) {
							alt54=1;
						}

						switch (alt54) {
						case 1 :
							// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:533:57: ',' cfamOrdering[expr]
							{
							match(input,144,FOLLOW_144_in_cfamProperty2557); 
							pushFollow(FOLLOW_cfamOrdering_in_cfamProperty2559);
							cfamOrdering(expr);
							state._fsp--;

							}
							break;

						default :
							break loop54;
						}
					}

					match(input,142,FOLLOW_142_in_cfamProperty2564); 
					}
					break;

			}
		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "cfamProperty"



	// $ANTLR start "cfamOrdering"
	// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:536:1: cfamOrdering[CreateTableStatement.RawStatement expr] : k= ident ( K_ASC | K_DESC ) ;
	public final void cfamOrdering(CreateTableStatement.RawStatement expr) throws RecognitionException {
		ColumnIdentifier k =null;

		 boolean reversed=false; 
		try {
			// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:538:5: (k= ident ( K_ASC | K_DESC ) )
			// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:538:7: k= ident ( K_ASC | K_DESC )
			{
			pushFollow(FOLLOW_ident_in_cfamOrdering2592);
			k=ident();
			state._fsp--;

			// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:538:15: ( K_ASC | K_DESC )
			int alt56=2;
			int LA56_0 = input.LA(1);
			if ( (LA56_0==K_ASC) ) {
				alt56=1;
			}
			else if ( (LA56_0==K_DESC) ) {
				alt56=2;
			}

			else {
				NoViableAltException nvae =
					new NoViableAltException("", 56, 0, input);
				throw nvae;
			}

			switch (alt56) {
				case 1 :
					// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:538:16: K_ASC
					{
					match(input,K_ASC,FOLLOW_K_ASC_in_cfamOrdering2595); 
					}
					break;
				case 2 :
					// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:538:24: K_DESC
					{
					match(input,K_DESC,FOLLOW_K_DESC_in_cfamOrdering2599); 
					 reversed=true;
					}
					break;

			}

			 expr.setOrdering(k, reversed); 
			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "cfamOrdering"



	// $ANTLR start "createTypeStatement"
	// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:549:1: createTypeStatement returns [CreateTypeStatement expr] : K_CREATE K_TYPE ( K_IF K_NOT K_EXISTS )? tn= userTypeName '(' typeColumns[expr] ( ',' ( typeColumns[expr] )? )* ')' ;
	public final CreateTypeStatement createTypeStatement() throws RecognitionException {
		CreateTypeStatement expr = null;


		UTName tn =null;

		 boolean ifNotExists = false; 
		try {
			// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:551:5: ( K_CREATE K_TYPE ( K_IF K_NOT K_EXISTS )? tn= userTypeName '(' typeColumns[expr] ( ',' ( typeColumns[expr] )? )* ')' )
			// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:551:7: K_CREATE K_TYPE ( K_IF K_NOT K_EXISTS )? tn= userTypeName '(' typeColumns[expr] ( ',' ( typeColumns[expr] )? )* ')'
			{
			match(input,K_CREATE,FOLLOW_K_CREATE_in_createTypeStatement2638); 
			match(input,K_TYPE,FOLLOW_K_TYPE_in_createTypeStatement2640); 
			// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:551:23: ( K_IF K_NOT K_EXISTS )?
			int alt57=2;
			int LA57_0 = input.LA(1);
			if ( (LA57_0==K_IF) ) {
				alt57=1;
			}
			switch (alt57) {
				case 1 :
					// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:551:24: K_IF K_NOT K_EXISTS
					{
					match(input,K_IF,FOLLOW_K_IF_in_createTypeStatement2643); 
					match(input,K_NOT,FOLLOW_K_NOT_in_createTypeStatement2645); 
					match(input,K_EXISTS,FOLLOW_K_EXISTS_in_createTypeStatement2647); 
					 ifNotExists = true; 
					}
					break;

			}

			pushFollow(FOLLOW_userTypeName_in_createTypeStatement2665);
			tn=userTypeName();
			state._fsp--;

			 expr = new CreateTypeStatement(tn, ifNotExists); 
			match(input,141,FOLLOW_141_in_createTypeStatement2678); 
			pushFollow(FOLLOW_typeColumns_in_createTypeStatement2680);
			typeColumns(expr);
			state._fsp--;

			// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:553:32: ( ',' ( typeColumns[expr] )? )*
			loop59:
			while (true) {
				int alt59=2;
				int LA59_0 = input.LA(1);
				if ( (LA59_0==144) ) {
					alt59=1;
				}

				switch (alt59) {
				case 1 :
					// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:553:34: ',' ( typeColumns[expr] )?
					{
					match(input,144,FOLLOW_144_in_createTypeStatement2685); 
					// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:553:38: ( typeColumns[expr] )?
					int alt58=2;
					int LA58_0 = input.LA(1);
					if ( (LA58_0==IDENT||LA58_0==K_ALL||LA58_0==K_AS||LA58_0==K_ASCII||(LA58_0 >= K_BIGINT && LA58_0 <= K_BOOLEAN)||LA58_0==K_CLUSTERING||(LA58_0 >= K_COMPACT && LA58_0 <= K_COUNTER)||(LA58_0 >= K_CUSTOM && LA58_0 <= K_DECIMAL)||(LA58_0 >= K_DISTINCT && LA58_0 <= K_DOUBLE)||(LA58_0 >= K_EXISTS && LA58_0 <= K_FLOAT)||LA58_0==K_INET||LA58_0==K_INT||(LA58_0 >= K_KEY && LA58_0 <= K_KEYS)||LA58_0==K_KEYSPACES||(LA58_0 >= K_LIST && LA58_0 <= K_MAP)||LA58_0==K_NOSUPERUSER||(LA58_0 >= K_PASSWORD && LA58_0 <= K_PERMISSIONS)||(LA58_0 >= K_STATIC && LA58_0 <= K_TIMEUUID)||LA58_0==K_TRIGGER||LA58_0==K_TTL||LA58_0==K_TYPE||(LA58_0 >= K_USER && LA58_0 <= K_USERS)||(LA58_0 >= K_UUID && LA58_0 <= K_VARINT)||LA58_0==K_WRITETIME||LA58_0==QUOTED_NAME) ) {
						alt58=1;
					}
					switch (alt58) {
						case 1 :
							// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:553:38: typeColumns[expr]
							{
							pushFollow(FOLLOW_typeColumns_in_createTypeStatement2687);
							typeColumns(expr);
							state._fsp--;

							}
							break;

					}

					}
					break;

				default :
					break loop59;
				}
			}

			match(input,142,FOLLOW_142_in_createTypeStatement2694); 
			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return expr;
	}
	// $ANTLR end "createTypeStatement"



	// $ANTLR start "typeColumns"
	// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:556:1: typeColumns[CreateTypeStatement expr] : k= ident v= comparatorType ;
	public final void typeColumns(CreateTypeStatement expr) throws RecognitionException {
		ColumnIdentifier k =null;
		CQL3Type.Raw v =null;

		try {
			// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:557:5: (k= ident v= comparatorType )
			// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:557:7: k= ident v= comparatorType
			{
			pushFollow(FOLLOW_ident_in_typeColumns2714);
			k=ident();
			state._fsp--;

			pushFollow(FOLLOW_comparatorType_in_typeColumns2718);
			v=comparatorType();
			state._fsp--;

			 expr.addDefinition(k, v); 
			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "typeColumns"



	// $ANTLR start "createIndexStatement"
	// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:565:1: createIndexStatement returns [CreateIndexStatement expr] : K_CREATE ( K_CUSTOM )? K_INDEX ( K_IF K_NOT K_EXISTS )? (idxName= IDENT )? K_ON cf= columnFamilyName '(' id= indexIdent ')' ( K_USING cls= STRING_LITERAL )? ( K_WITH properties[props] )? ;
	public final CreateIndexStatement createIndexStatement() throws RecognitionException {
		CreateIndexStatement expr = null;


		Token idxName=null;
		Token cls=null;
		CFName cf =null;
		IndexTarget.Raw id =null;


		        IndexPropDefs props = new IndexPropDefs();
		        boolean ifNotExists = false;
		    
		try {
			// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:570:5: ( K_CREATE ( K_CUSTOM )? K_INDEX ( K_IF K_NOT K_EXISTS )? (idxName= IDENT )? K_ON cf= columnFamilyName '(' id= indexIdent ')' ( K_USING cls= STRING_LITERAL )? ( K_WITH properties[props] )? )
			// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:570:7: K_CREATE ( K_CUSTOM )? K_INDEX ( K_IF K_NOT K_EXISTS )? (idxName= IDENT )? K_ON cf= columnFamilyName '(' id= indexIdent ')' ( K_USING cls= STRING_LITERAL )? ( K_WITH properties[props] )?
			{
			match(input,K_CREATE,FOLLOW_K_CREATE_in_createIndexStatement2753); 
			// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:570:16: ( K_CUSTOM )?
			int alt60=2;
			int LA60_0 = input.LA(1);
			if ( (LA60_0==K_CUSTOM) ) {
				alt60=1;
			}
			switch (alt60) {
				case 1 :
					// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:570:17: K_CUSTOM
					{
					match(input,K_CUSTOM,FOLLOW_K_CUSTOM_in_createIndexStatement2756); 
					 props.isCustom = true; 
					}
					break;

			}

			match(input,K_INDEX,FOLLOW_K_INDEX_in_createIndexStatement2762); 
			// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:570:63: ( K_IF K_NOT K_EXISTS )?
			int alt61=2;
			int LA61_0 = input.LA(1);
			if ( (LA61_0==K_IF) ) {
				alt61=1;
			}
			switch (alt61) {
				case 1 :
					// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:570:64: K_IF K_NOT K_EXISTS
					{
					match(input,K_IF,FOLLOW_K_IF_in_createIndexStatement2765); 
					match(input,K_NOT,FOLLOW_K_NOT_in_createIndexStatement2767); 
					match(input,K_EXISTS,FOLLOW_K_EXISTS_in_createIndexStatement2769); 
					 ifNotExists = true; 
					}
					break;

			}

			// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:571:9: (idxName= IDENT )?
			int alt62=2;
			int LA62_0 = input.LA(1);
			if ( (LA62_0==IDENT) ) {
				alt62=1;
			}
			switch (alt62) {
				case 1 :
					// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:571:10: idxName= IDENT
					{
					idxName=(Token)match(input,IDENT,FOLLOW_IDENT_in_createIndexStatement2787); 
					}
					break;

			}

			match(input,K_ON,FOLLOW_K_ON_in_createIndexStatement2791); 
			pushFollow(FOLLOW_columnFamilyName_in_createIndexStatement2795);
			cf=columnFamilyName();
			state._fsp--;

			match(input,141,FOLLOW_141_in_createIndexStatement2797); 
			pushFollow(FOLLOW_indexIdent_in_createIndexStatement2801);
			id=indexIdent();
			state._fsp--;

			match(input,142,FOLLOW_142_in_createIndexStatement2803); 
			// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:572:9: ( K_USING cls= STRING_LITERAL )?
			int alt63=2;
			int LA63_0 = input.LA(1);
			if ( (LA63_0==K_USING) ) {
				alt63=1;
			}
			switch (alt63) {
				case 1 :
					// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:572:10: K_USING cls= STRING_LITERAL
					{
					match(input,K_USING,FOLLOW_K_USING_in_createIndexStatement2814); 
					cls=(Token)match(input,STRING_LITERAL,FOLLOW_STRING_LITERAL_in_createIndexStatement2818); 
					 props.customClass = (cls!=null?cls.getText():null); 
					}
					break;

			}

			// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:573:9: ( K_WITH properties[props] )?
			int alt64=2;
			int LA64_0 = input.LA(1);
			if ( (LA64_0==K_WITH) ) {
				alt64=1;
			}
			switch (alt64) {
				case 1 :
					// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:573:10: K_WITH properties[props]
					{
					match(input,K_WITH,FOLLOW_K_WITH_in_createIndexStatement2833); 
					pushFollow(FOLLOW_properties_in_createIndexStatement2835);
					properties(props);
					state._fsp--;

					}
					break;

			}

			 expr = new CreateIndexStatement(cf, (idxName!=null?idxName.getText():null), id, props, ifNotExists); 
			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return expr;
	}
	// $ANTLR end "createIndexStatement"



	// $ANTLR start "indexIdent"
	// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:577:1: indexIdent returns [IndexTarget.Raw id] : (c= cident | K_KEYS '(' c= cident ')' );
	public final IndexTarget.Raw indexIdent() throws RecognitionException {
		IndexTarget.Raw id = null;


		ColumnIdentifier.Raw c =null;

		try {
			// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:578:5: (c= cident | K_KEYS '(' c= cident ')' )
			int alt65=2;
			int LA65_0 = input.LA(1);
			if ( (LA65_0==IDENT||LA65_0==K_ALL||LA65_0==K_AS||LA65_0==K_ASCII||(LA65_0 >= K_BIGINT && LA65_0 <= K_BOOLEAN)||LA65_0==K_CLUSTERING||(LA65_0 >= K_COMPACT && LA65_0 <= K_COUNTER)||(LA65_0 >= K_CUSTOM && LA65_0 <= K_DECIMAL)||(LA65_0 >= K_DISTINCT && LA65_0 <= K_DOUBLE)||(LA65_0 >= K_EXISTS && LA65_0 <= K_FLOAT)||LA65_0==K_INET||LA65_0==K_INT||LA65_0==K_KEY||LA65_0==K_KEYSPACES||(LA65_0 >= K_LIST && LA65_0 <= K_MAP)||LA65_0==K_NOSUPERUSER||(LA65_0 >= K_PASSWORD && LA65_0 <= K_PERMISSIONS)||(LA65_0 >= K_STATIC && LA65_0 <= K_TIMEUUID)||LA65_0==K_TRIGGER||LA65_0==K_TTL||LA65_0==K_TYPE||(LA65_0 >= K_USER && LA65_0 <= K_USERS)||(LA65_0 >= K_UUID && LA65_0 <= K_VARINT)||LA65_0==K_WRITETIME||LA65_0==QUOTED_NAME) ) {
				alt65=1;
			}
			else if ( (LA65_0==K_KEYS) ) {
				int LA65_2 = input.LA(2);
				if ( (LA65_2==141) ) {
					alt65=2;
				}
				else if ( (LA65_2==142) ) {
					alt65=1;
				}

				else {
					int nvaeMark = input.mark();
					try {
						input.consume();
						NoViableAltException nvae =
							new NoViableAltException("", 65, 2, input);
						throw nvae;
					} finally {
						input.rewind(nvaeMark);
					}
				}

			}

			else {
				NoViableAltException nvae =
					new NoViableAltException("", 65, 0, input);
				throw nvae;
			}

			switch (alt65) {
				case 1 :
					// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:578:7: c= cident
					{
					pushFollow(FOLLOW_cident_in_indexIdent2869);
					c=cident();
					state._fsp--;

					 id = IndexTarget.Raw.of(c); 
					}
					break;
				case 2 :
					// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:579:7: K_KEYS '(' c= cident ')'
					{
					match(input,K_KEYS,FOLLOW_K_KEYS_in_indexIdent2894); 
					match(input,141,FOLLOW_141_in_indexIdent2896); 
					pushFollow(FOLLOW_cident_in_indexIdent2900);
					c=cident();
					state._fsp--;

					match(input,142,FOLLOW_142_in_indexIdent2902); 
					 id = IndexTarget.Raw.keysOf(c); 
					}
					break;

			}
		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return id;
	}
	// $ANTLR end "indexIdent"



	// $ANTLR start "createTriggerStatement"
	// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:586:1: createTriggerStatement returns [CreateTriggerStatement expr] : K_CREATE K_TRIGGER ( K_IF K_NOT K_EXISTS )? (name= cident ) K_ON cf= columnFamilyName K_USING cls= STRING_LITERAL ;
	public final CreateTriggerStatement createTriggerStatement() throws RecognitionException {
		CreateTriggerStatement expr = null;


		Token cls=null;
		ColumnIdentifier.Raw name =null;
		CFName cf =null;


		        boolean ifNotExists = false;
		    
		try {
			// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:590:5: ( K_CREATE K_TRIGGER ( K_IF K_NOT K_EXISTS )? (name= cident ) K_ON cf= columnFamilyName K_USING cls= STRING_LITERAL )
			// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:590:7: K_CREATE K_TRIGGER ( K_IF K_NOT K_EXISTS )? (name= cident ) K_ON cf= columnFamilyName K_USING cls= STRING_LITERAL
			{
			match(input,K_CREATE,FOLLOW_K_CREATE_in_createTriggerStatement2937); 
			match(input,K_TRIGGER,FOLLOW_K_TRIGGER_in_createTriggerStatement2939); 
			// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:590:26: ( K_IF K_NOT K_EXISTS )?
			int alt66=2;
			int LA66_0 = input.LA(1);
			if ( (LA66_0==K_IF) ) {
				alt66=1;
			}
			switch (alt66) {
				case 1 :
					// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:590:27: K_IF K_NOT K_EXISTS
					{
					match(input,K_IF,FOLLOW_K_IF_in_createTriggerStatement2942); 
					match(input,K_NOT,FOLLOW_K_NOT_in_createTriggerStatement2944); 
					match(input,K_EXISTS,FOLLOW_K_EXISTS_in_createTriggerStatement2946); 
					 ifNotExists = true; 
					}
					break;

			}

			// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:590:74: (name= cident )
			// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:590:75: name= cident
			{
			pushFollow(FOLLOW_cident_in_createTriggerStatement2956);
			name=cident();
			state._fsp--;

			}

			match(input,K_ON,FOLLOW_K_ON_in_createTriggerStatement2967); 
			pushFollow(FOLLOW_columnFamilyName_in_createTriggerStatement2971);
			cf=columnFamilyName();
			state._fsp--;

			match(input,K_USING,FOLLOW_K_USING_in_createTriggerStatement2973); 
			cls=(Token)match(input,STRING_LITERAL,FOLLOW_STRING_LITERAL_in_createTriggerStatement2977); 
			 expr = new CreateTriggerStatement(cf, name.toString(), (cls!=null?cls.getText():null), ifNotExists); 
			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return expr;
	}
	// $ANTLR end "createTriggerStatement"



	// $ANTLR start "dropTriggerStatement"
	// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:598:1: dropTriggerStatement returns [DropTriggerStatement expr] : K_DROP K_TRIGGER ( K_IF K_EXISTS )? (name= cident ) K_ON cf= columnFamilyName ;
	public final DropTriggerStatement dropTriggerStatement() throws RecognitionException {
		DropTriggerStatement expr = null;


		ColumnIdentifier.Raw name =null;
		CFName cf =null;

		 boolean ifExists = false; 
		try {
			// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:600:5: ( K_DROP K_TRIGGER ( K_IF K_EXISTS )? (name= cident ) K_ON cf= columnFamilyName )
			// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:600:7: K_DROP K_TRIGGER ( K_IF K_EXISTS )? (name= cident ) K_ON cf= columnFamilyName
			{
			match(input,K_DROP,FOLLOW_K_DROP_in_dropTriggerStatement3018); 
			match(input,K_TRIGGER,FOLLOW_K_TRIGGER_in_dropTriggerStatement3020); 
			// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:600:24: ( K_IF K_EXISTS )?
			int alt67=2;
			int LA67_0 = input.LA(1);
			if ( (LA67_0==K_IF) ) {
				alt67=1;
			}
			switch (alt67) {
				case 1 :
					// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:600:25: K_IF K_EXISTS
					{
					match(input,K_IF,FOLLOW_K_IF_in_dropTriggerStatement3023); 
					match(input,K_EXISTS,FOLLOW_K_EXISTS_in_dropTriggerStatement3025); 
					 ifExists = true; 
					}
					break;

			}

			// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:600:63: (name= cident )
			// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:600:64: name= cident
			{
			pushFollow(FOLLOW_cident_in_dropTriggerStatement3035);
			name=cident();
			state._fsp--;

			}

			match(input,K_ON,FOLLOW_K_ON_in_dropTriggerStatement3038); 
			pushFollow(FOLLOW_columnFamilyName_in_dropTriggerStatement3042);
			cf=columnFamilyName();
			state._fsp--;

			 expr = new DropTriggerStatement(cf, name.toString(), ifExists); 
			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return expr;
	}
	// $ANTLR end "dropTriggerStatement"



	// $ANTLR start "alterKeyspaceStatement"
	// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:607:1: alterKeyspaceStatement returns [AlterKeyspaceStatement expr] : K_ALTER K_KEYSPACE ks= keyspaceName K_WITH properties[attrs] ;
	public final AlterKeyspaceStatement alterKeyspaceStatement() throws RecognitionException {
		AlterKeyspaceStatement expr = null;


		String ks =null;

		 KSPropDefs attrs = new KSPropDefs(); 
		try {
			// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:609:5: ( K_ALTER K_KEYSPACE ks= keyspaceName K_WITH properties[attrs] )
			// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:609:7: K_ALTER K_KEYSPACE ks= keyspaceName K_WITH properties[attrs]
			{
			match(input,K_ALTER,FOLLOW_K_ALTER_in_alterKeyspaceStatement3082); 
			match(input,K_KEYSPACE,FOLLOW_K_KEYSPACE_in_alterKeyspaceStatement3084); 
			pushFollow(FOLLOW_keyspaceName_in_alterKeyspaceStatement3088);
			ks=keyspaceName();
			state._fsp--;

			match(input,K_WITH,FOLLOW_K_WITH_in_alterKeyspaceStatement3098); 
			pushFollow(FOLLOW_properties_in_alterKeyspaceStatement3100);
			properties(attrs);
			state._fsp--;

			 expr = new AlterKeyspaceStatement(ks, attrs); 
			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return expr;
	}
	// $ANTLR end "alterKeyspaceStatement"



	// $ANTLR start "alterTableStatement"
	// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:621:1: alterTableStatement returns [AlterTableStatement expr] : K_ALTER K_COLUMNFAMILY cf= columnFamilyName ( K_ALTER id= cident K_TYPE v= comparatorType | K_ADD id= cident v= comparatorType ( K_STATIC )? | K_DROP id= cident | K_WITH properties[props] | K_RENAME id1= cident K_TO toId1= cident ( K_AND idn= cident K_TO toIdn= cident )* ) ;
	public final AlterTableStatement alterTableStatement() throws RecognitionException {
		AlterTableStatement expr = null;


		CFName cf =null;
		ColumnIdentifier.Raw id =null;
		CQL3Type.Raw v =null;
		ColumnIdentifier.Raw id1 =null;
		ColumnIdentifier.Raw toId1 =null;
		ColumnIdentifier.Raw idn =null;
		ColumnIdentifier.Raw toIdn =null;


		        AlterTableStatement.Type type = null;
		        CFPropDefs props = new CFPropDefs();
		        Map<ColumnIdentifier.Raw, ColumnIdentifier.Raw> renames = new HashMap<ColumnIdentifier.Raw, ColumnIdentifier.Raw>();
		        boolean isStatic = false;
		    
		try {
			// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:628:5: ( K_ALTER K_COLUMNFAMILY cf= columnFamilyName ( K_ALTER id= cident K_TYPE v= comparatorType | K_ADD id= cident v= comparatorType ( K_STATIC )? | K_DROP id= cident | K_WITH properties[props] | K_RENAME id1= cident K_TO toId1= cident ( K_AND idn= cident K_TO toIdn= cident )* ) )
			// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:628:7: K_ALTER K_COLUMNFAMILY cf= columnFamilyName ( K_ALTER id= cident K_TYPE v= comparatorType | K_ADD id= cident v= comparatorType ( K_STATIC )? | K_DROP id= cident | K_WITH properties[props] | K_RENAME id1= cident K_TO toId1= cident ( K_AND idn= cident K_TO toIdn= cident )* )
			{
			match(input,K_ALTER,FOLLOW_K_ALTER_in_alterTableStatement3136); 
			match(input,K_COLUMNFAMILY,FOLLOW_K_COLUMNFAMILY_in_alterTableStatement3138); 
			pushFollow(FOLLOW_columnFamilyName_in_alterTableStatement3142);
			cf=columnFamilyName();
			state._fsp--;

			// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:629:11: ( K_ALTER id= cident K_TYPE v= comparatorType | K_ADD id= cident v= comparatorType ( K_STATIC )? | K_DROP id= cident | K_WITH properties[props] | K_RENAME id1= cident K_TO toId1= cident ( K_AND idn= cident K_TO toIdn= cident )* )
			int alt70=5;
			switch ( input.LA(1) ) {
			case K_ALTER:
				{
				alt70=1;
				}
				break;
			case K_ADD:
				{
				alt70=2;
				}
				break;
			case K_DROP:
				{
				alt70=3;
				}
				break;
			case K_WITH:
				{
				alt70=4;
				}
				break;
			case K_RENAME:
				{
				alt70=5;
				}
				break;
			default:
				NoViableAltException nvae =
					new NoViableAltException("", 70, 0, input);
				throw nvae;
			}
			switch (alt70) {
				case 1 :
					// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:629:13: K_ALTER id= cident K_TYPE v= comparatorType
					{
					match(input,K_ALTER,FOLLOW_K_ALTER_in_alterTableStatement3156); 
					pushFollow(FOLLOW_cident_in_alterTableStatement3160);
					id=cident();
					state._fsp--;

					match(input,K_TYPE,FOLLOW_K_TYPE_in_alterTableStatement3162); 
					pushFollow(FOLLOW_comparatorType_in_alterTableStatement3166);
					v=comparatorType();
					state._fsp--;

					 type = AlterTableStatement.Type.ALTER; 
					}
					break;
				case 2 :
					// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:630:13: K_ADD id= cident v= comparatorType ( K_STATIC )?
					{
					match(input,K_ADD,FOLLOW_K_ADD_in_alterTableStatement3182); 
					pushFollow(FOLLOW_cident_in_alterTableStatement3188);
					id=cident();
					state._fsp--;

					pushFollow(FOLLOW_comparatorType_in_alterTableStatement3192);
					v=comparatorType();
					state._fsp--;

					// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:630:48: ( K_STATIC )?
					int alt68=2;
					int LA68_0 = input.LA(1);
					if ( (LA68_0==K_STATIC) ) {
						alt68=1;
					}
					switch (alt68) {
						case 1 :
							// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:630:49: K_STATIC
							{
							 isStatic=true; 
							match(input,K_STATIC,FOLLOW_K_STATIC_in_alterTableStatement3197); 
							}
							break;

					}

					 type = AlterTableStatement.Type.ADD; 
					}
					break;
				case 3 :
					// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:631:13: K_DROP id= cident
					{
					match(input,K_DROP,FOLLOW_K_DROP_in_alterTableStatement3215); 
					pushFollow(FOLLOW_cident_in_alterTableStatement3220);
					id=cident();
					state._fsp--;

					 type = AlterTableStatement.Type.DROP; 
					}
					break;
				case 4 :
					// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:632:13: K_WITH properties[props]
					{
					match(input,K_WITH,FOLLOW_K_WITH_in_alterTableStatement3260); 
					pushFollow(FOLLOW_properties_in_alterTableStatement3263);
					properties(props);
					state._fsp--;

					 type = AlterTableStatement.Type.OPTS; 
					}
					break;
				case 5 :
					// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:633:13: K_RENAME id1= cident K_TO toId1= cident ( K_AND idn= cident K_TO toIdn= cident )*
					{
					match(input,K_RENAME,FOLLOW_K_RENAME_in_alterTableStatement3296); 
					 type = AlterTableStatement.Type.RENAME; 
					pushFollow(FOLLOW_cident_in_alterTableStatement3350);
					id1=cident();
					state._fsp--;

					match(input,K_TO,FOLLOW_K_TO_in_alterTableStatement3352); 
					pushFollow(FOLLOW_cident_in_alterTableStatement3356);
					toId1=cident();
					state._fsp--;

					 renames.put(id1, toId1); 
					// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:635:16: ( K_AND idn= cident K_TO toIdn= cident )*
					loop69:
					while (true) {
						int alt69=2;
						int LA69_0 = input.LA(1);
						if ( (LA69_0==K_AND) ) {
							alt69=1;
						}

						switch (alt69) {
						case 1 :
							// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:635:18: K_AND idn= cident K_TO toIdn= cident
							{
							match(input,K_AND,FOLLOW_K_AND_in_alterTableStatement3377); 
							pushFollow(FOLLOW_cident_in_alterTableStatement3381);
							idn=cident();
							state._fsp--;

							match(input,K_TO,FOLLOW_K_TO_in_alterTableStatement3383); 
							pushFollow(FOLLOW_cident_in_alterTableStatement3387);
							toIdn=cident();
							state._fsp--;

							 renames.put(idn, toIdn); 
							}
							break;

						default :
							break loop69;
						}
					}

					}
					break;

			}


			        expr = new AlterTableStatement(cf, type, id, v, props, renames, isStatic);
			    
			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return expr;
	}
	// $ANTLR end "alterTableStatement"



	// $ANTLR start "alterTypeStatement"
	// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:647:1: alterTypeStatement returns [AlterTypeStatement expr] : K_ALTER K_TYPE name= userTypeName ( K_ALTER f= ident K_TYPE v= comparatorType | K_ADD f= ident v= comparatorType | K_RENAME id1= ident K_TO toId1= ident ( K_AND idn= ident K_TO toIdn= ident )* ) ;
	public final AlterTypeStatement alterTypeStatement() throws RecognitionException {
		AlterTypeStatement expr = null;


		UTName name =null;
		ColumnIdentifier f =null;
		CQL3Type.Raw v =null;
		ColumnIdentifier id1 =null;
		ColumnIdentifier toId1 =null;
		ColumnIdentifier idn =null;
		ColumnIdentifier toIdn =null;

		try {
			// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:648:5: ( K_ALTER K_TYPE name= userTypeName ( K_ALTER f= ident K_TYPE v= comparatorType | K_ADD f= ident v= comparatorType | K_RENAME id1= ident K_TO toId1= ident ( K_AND idn= ident K_TO toIdn= ident )* ) )
			// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:648:7: K_ALTER K_TYPE name= userTypeName ( K_ALTER f= ident K_TYPE v= comparatorType | K_ADD f= ident v= comparatorType | K_RENAME id1= ident K_TO toId1= ident ( K_AND idn= ident K_TO toIdn= ident )* )
			{
			match(input,K_ALTER,FOLLOW_K_ALTER_in_alterTypeStatement3433); 
			match(input,K_TYPE,FOLLOW_K_TYPE_in_alterTypeStatement3435); 
			pushFollow(FOLLOW_userTypeName_in_alterTypeStatement3439);
			name=userTypeName();
			state._fsp--;

			// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:649:11: ( K_ALTER f= ident K_TYPE v= comparatorType | K_ADD f= ident v= comparatorType | K_RENAME id1= ident K_TO toId1= ident ( K_AND idn= ident K_TO toIdn= ident )* )
			int alt72=3;
			switch ( input.LA(1) ) {
			case K_ALTER:
				{
				alt72=1;
				}
				break;
			case K_ADD:
				{
				alt72=2;
				}
				break;
			case K_RENAME:
				{
				alt72=3;
				}
				break;
			default:
				NoViableAltException nvae =
					new NoViableAltException("", 72, 0, input);
				throw nvae;
			}
			switch (alt72) {
				case 1 :
					// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:649:13: K_ALTER f= ident K_TYPE v= comparatorType
					{
					match(input,K_ALTER,FOLLOW_K_ALTER_in_alterTypeStatement3453); 
					pushFollow(FOLLOW_ident_in_alterTypeStatement3457);
					f=ident();
					state._fsp--;

					match(input,K_TYPE,FOLLOW_K_TYPE_in_alterTypeStatement3459); 
					pushFollow(FOLLOW_comparatorType_in_alterTypeStatement3463);
					v=comparatorType();
					state._fsp--;

					 expr = AlterTypeStatement.alter(name, f, v); 
					}
					break;
				case 2 :
					// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:650:13: K_ADD f= ident v= comparatorType
					{
					match(input,K_ADD,FOLLOW_K_ADD_in_alterTypeStatement3479); 
					pushFollow(FOLLOW_ident_in_alterTypeStatement3485);
					f=ident();
					state._fsp--;

					pushFollow(FOLLOW_comparatorType_in_alterTypeStatement3489);
					v=comparatorType();
					state._fsp--;

					 expr = AlterTypeStatement.addition(name, f, v); 
					}
					break;
				case 3 :
					// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:651:13: K_RENAME id1= ident K_TO toId1= ident ( K_AND idn= ident K_TO toIdn= ident )*
					{
					match(input,K_RENAME,FOLLOW_K_RENAME_in_alterTypeStatement3512); 
					 Map<ColumnIdentifier, ColumnIdentifier> renames = new HashMap<ColumnIdentifier, ColumnIdentifier>(); 
					pushFollow(FOLLOW_ident_in_alterTypeStatement3550);
					id1=ident();
					state._fsp--;

					match(input,K_TO,FOLLOW_K_TO_in_alterTypeStatement3552); 
					pushFollow(FOLLOW_ident_in_alterTypeStatement3556);
					toId1=ident();
					state._fsp--;

					 renames.put(id1, toId1); 
					// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:654:18: ( K_AND idn= ident K_TO toIdn= ident )*
					loop71:
					while (true) {
						int alt71=2;
						int LA71_0 = input.LA(1);
						if ( (LA71_0==K_AND) ) {
							alt71=1;
						}

						switch (alt71) {
						case 1 :
							// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:654:20: K_AND idn= ident K_TO toIdn= ident
							{
							match(input,K_AND,FOLLOW_K_AND_in_alterTypeStatement3579); 
							pushFollow(FOLLOW_ident_in_alterTypeStatement3583);
							idn=ident();
							state._fsp--;

							match(input,K_TO,FOLLOW_K_TO_in_alterTypeStatement3585); 
							pushFollow(FOLLOW_ident_in_alterTypeStatement3589);
							toIdn=ident();
							state._fsp--;

							 renames.put(idn, toIdn); 
							}
							break;

						default :
							break loop71;
						}
					}

					 expr = AlterTypeStatement.renames(name, renames); 
					}
					break;

			}

			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return expr;
	}
	// $ANTLR end "alterTypeStatement"



	// $ANTLR start "dropKeyspaceStatement"
	// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:663:1: dropKeyspaceStatement returns [DropKeyspaceStatement ksp] : K_DROP K_KEYSPACE ( K_IF K_EXISTS )? ks= keyspaceName ;
	public final DropKeyspaceStatement dropKeyspaceStatement() throws RecognitionException {
		DropKeyspaceStatement ksp = null;


		String ks =null;

		 boolean ifExists = false; 
		try {
			// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:665:5: ( K_DROP K_KEYSPACE ( K_IF K_EXISTS )? ks= keyspaceName )
			// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:665:7: K_DROP K_KEYSPACE ( K_IF K_EXISTS )? ks= keyspaceName
			{
			match(input,K_DROP,FOLLOW_K_DROP_in_dropKeyspaceStatement3656); 
			match(input,K_KEYSPACE,FOLLOW_K_KEYSPACE_in_dropKeyspaceStatement3658); 
			// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:665:25: ( K_IF K_EXISTS )?
			int alt73=2;
			int LA73_0 = input.LA(1);
			if ( (LA73_0==K_IF) ) {
				alt73=1;
			}
			switch (alt73) {
				case 1 :
					// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:665:26: K_IF K_EXISTS
					{
					match(input,K_IF,FOLLOW_K_IF_in_dropKeyspaceStatement3661); 
					match(input,K_EXISTS,FOLLOW_K_EXISTS_in_dropKeyspaceStatement3663); 
					 ifExists = true; 
					}
					break;

			}

			pushFollow(FOLLOW_keyspaceName_in_dropKeyspaceStatement3672);
			ks=keyspaceName();
			state._fsp--;

			 ksp = new DropKeyspaceStatement(ks, ifExists); 
			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return ksp;
	}
	// $ANTLR end "dropKeyspaceStatement"



	// $ANTLR start "dropTableStatement"
	// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:671:1: dropTableStatement returns [DropTableStatement stmt] : K_DROP K_COLUMNFAMILY ( K_IF K_EXISTS )? cf= columnFamilyName ;
	public final DropTableStatement dropTableStatement() throws RecognitionException {
		DropTableStatement stmt = null;


		CFName cf =null;

		 boolean ifExists = false; 
		try {
			// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:673:5: ( K_DROP K_COLUMNFAMILY ( K_IF K_EXISTS )? cf= columnFamilyName )
			// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:673:7: K_DROP K_COLUMNFAMILY ( K_IF K_EXISTS )? cf= columnFamilyName
			{
			match(input,K_DROP,FOLLOW_K_DROP_in_dropTableStatement3706); 
			match(input,K_COLUMNFAMILY,FOLLOW_K_COLUMNFAMILY_in_dropTableStatement3708); 
			// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:673:29: ( K_IF K_EXISTS )?
			int alt74=2;
			int LA74_0 = input.LA(1);
			if ( (LA74_0==K_IF) ) {
				alt74=1;
			}
			switch (alt74) {
				case 1 :
					// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:673:30: K_IF K_EXISTS
					{
					match(input,K_IF,FOLLOW_K_IF_in_dropTableStatement3711); 
					match(input,K_EXISTS,FOLLOW_K_EXISTS_in_dropTableStatement3713); 
					 ifExists = true; 
					}
					break;

			}

			pushFollow(FOLLOW_columnFamilyName_in_dropTableStatement3722);
			cf=columnFamilyName();
			state._fsp--;

			 stmt = new DropTableStatement(cf, ifExists); 
			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return stmt;
	}
	// $ANTLR end "dropTableStatement"



	// $ANTLR start "dropTypeStatement"
	// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:679:1: dropTypeStatement returns [DropTypeStatement stmt] : K_DROP K_TYPE ( K_IF K_EXISTS )? name= userTypeName ;
	public final DropTypeStatement dropTypeStatement() throws RecognitionException {
		DropTypeStatement stmt = null;


		UTName name =null;

		 boolean ifExists = false; 
		try {
			// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:681:5: ( K_DROP K_TYPE ( K_IF K_EXISTS )? name= userTypeName )
			// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:681:7: K_DROP K_TYPE ( K_IF K_EXISTS )? name= userTypeName
			{
			match(input,K_DROP,FOLLOW_K_DROP_in_dropTypeStatement3756); 
			match(input,K_TYPE,FOLLOW_K_TYPE_in_dropTypeStatement3758); 
			// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:681:21: ( K_IF K_EXISTS )?
			int alt75=2;
			int LA75_0 = input.LA(1);
			if ( (LA75_0==K_IF) ) {
				alt75=1;
			}
			switch (alt75) {
				case 1 :
					// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:681:22: K_IF K_EXISTS
					{
					match(input,K_IF,FOLLOW_K_IF_in_dropTypeStatement3761); 
					match(input,K_EXISTS,FOLLOW_K_EXISTS_in_dropTypeStatement3763); 
					 ifExists = true; 
					}
					break;

			}

			pushFollow(FOLLOW_userTypeName_in_dropTypeStatement3772);
			name=userTypeName();
			state._fsp--;

			 stmt = new DropTypeStatement(name, ifExists); 
			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return stmt;
	}
	// $ANTLR end "dropTypeStatement"



	// $ANTLR start "dropIndexStatement"
	// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:687:1: dropIndexStatement returns [DropIndexStatement expr] : K_DROP K_INDEX ( K_IF K_EXISTS )? index= indexName ;
	public final DropIndexStatement dropIndexStatement() throws RecognitionException {
		DropIndexStatement expr = null;


		IndexName index =null;

		 boolean ifExists = false; 
		try {
			// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:689:5: ( K_DROP K_INDEX ( K_IF K_EXISTS )? index= indexName )
			// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:689:7: K_DROP K_INDEX ( K_IF K_EXISTS )? index= indexName
			{
			match(input,K_DROP,FOLLOW_K_DROP_in_dropIndexStatement3806); 
			match(input,K_INDEX,FOLLOW_K_INDEX_in_dropIndexStatement3808); 
			// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:689:22: ( K_IF K_EXISTS )?
			int alt76=2;
			int LA76_0 = input.LA(1);
			if ( (LA76_0==K_IF) ) {
				alt76=1;
			}
			switch (alt76) {
				case 1 :
					// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:689:23: K_IF K_EXISTS
					{
					match(input,K_IF,FOLLOW_K_IF_in_dropIndexStatement3811); 
					match(input,K_EXISTS,FOLLOW_K_EXISTS_in_dropIndexStatement3813); 
					 ifExists = true; 
					}
					break;

			}

			pushFollow(FOLLOW_indexName_in_dropIndexStatement3822);
			index=indexName();
			state._fsp--;

			 expr = new DropIndexStatement(index, ifExists); 
			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return expr;
	}
	// $ANTLR end "dropIndexStatement"



	// $ANTLR start "truncateStatement"
	// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:696:1: truncateStatement returns [TruncateStatement stmt] : K_TRUNCATE cf= columnFamilyName ;
	public final TruncateStatement truncateStatement() throws RecognitionException {
		TruncateStatement stmt = null;


		CFName cf =null;

		try {
			// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:697:5: ( K_TRUNCATE cf= columnFamilyName )
			// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:697:7: K_TRUNCATE cf= columnFamilyName
			{
			match(input,K_TRUNCATE,FOLLOW_K_TRUNCATE_in_truncateStatement3853); 
			pushFollow(FOLLOW_columnFamilyName_in_truncateStatement3857);
			cf=columnFamilyName();
			state._fsp--;

			 stmt = new TruncateStatement(cf); 
			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return stmt;
	}
	// $ANTLR end "truncateStatement"



	// $ANTLR start "grantStatement"
	// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:703:1: grantStatement returns [GrantStatement stmt] : K_GRANT permissionOrAll K_ON resource K_TO username ;
	public final GrantStatement grantStatement() throws RecognitionException {
		GrantStatement stmt = null;


		Set<Permission> permissionOrAll1 =null;
		IResource resource2 =null;
		ParserRuleReturnScope username3 =null;

		try {
			// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:704:5: ( K_GRANT permissionOrAll K_ON resource K_TO username )
			// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:704:7: K_GRANT permissionOrAll K_ON resource K_TO username
			{
			match(input,K_GRANT,FOLLOW_K_GRANT_in_grantStatement3882); 
			pushFollow(FOLLOW_permissionOrAll_in_grantStatement3894);
			permissionOrAll1=permissionOrAll();
			state._fsp--;

			match(input,K_ON,FOLLOW_K_ON_in_grantStatement3902); 
			pushFollow(FOLLOW_resource_in_grantStatement3914);
			resource2=resource();
			state._fsp--;

			match(input,K_TO,FOLLOW_K_TO_in_grantStatement3922); 
			pushFollow(FOLLOW_username_in_grantStatement3934);
			username3=username();
			state._fsp--;

			 stmt = new GrantStatement(permissionOrAll1, resource2, (username3!=null?input.toString(username3.start,username3.stop):null)); 
			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return stmt;
	}
	// $ANTLR end "grantStatement"



	// $ANTLR start "revokeStatement"
	// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:716:1: revokeStatement returns [RevokeStatement stmt] : K_REVOKE permissionOrAll K_ON resource K_FROM username ;
	public final RevokeStatement revokeStatement() throws RecognitionException {
		RevokeStatement stmt = null;


		Set<Permission> permissionOrAll4 =null;
		IResource resource5 =null;
		ParserRuleReturnScope username6 =null;

		try {
			// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:717:5: ( K_REVOKE permissionOrAll K_ON resource K_FROM username )
			// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:717:7: K_REVOKE permissionOrAll K_ON resource K_FROM username
			{
			match(input,K_REVOKE,FOLLOW_K_REVOKE_in_revokeStatement3965); 
			pushFollow(FOLLOW_permissionOrAll_in_revokeStatement3977);
			permissionOrAll4=permissionOrAll();
			state._fsp--;

			match(input,K_ON,FOLLOW_K_ON_in_revokeStatement3985); 
			pushFollow(FOLLOW_resource_in_revokeStatement3997);
			resource5=resource();
			state._fsp--;

			match(input,K_FROM,FOLLOW_K_FROM_in_revokeStatement4005); 
			pushFollow(FOLLOW_username_in_revokeStatement4017);
			username6=username();
			state._fsp--;

			 stmt = new RevokeStatement(permissionOrAll4, resource5, (username6!=null?input.toString(username6.start,username6.stop):null)); 
			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return stmt;
	}
	// $ANTLR end "revokeStatement"



	// $ANTLR start "listPermissionsStatement"
	// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:726:1: listPermissionsStatement returns [ListPermissionsStatement stmt] : K_LIST permissionOrAll ( K_ON resource )? ( K_OF username )? ( K_NORECURSIVE )? ;
	public final ListPermissionsStatement listPermissionsStatement() throws RecognitionException {
		ListPermissionsStatement stmt = null;


		IResource resource7 =null;
		ParserRuleReturnScope username8 =null;
		Set<Permission> permissionOrAll9 =null;


		        IResource resource = null;
		        String username = null;
		        boolean recursive = true;
		    
		try {
			// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:732:5: ( K_LIST permissionOrAll ( K_ON resource )? ( K_OF username )? ( K_NORECURSIVE )? )
			// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:732:7: K_LIST permissionOrAll ( K_ON resource )? ( K_OF username )? ( K_NORECURSIVE )?
			{
			match(input,K_LIST,FOLLOW_K_LIST_in_listPermissionsStatement4055); 
			pushFollow(FOLLOW_permissionOrAll_in_listPermissionsStatement4067);
			permissionOrAll9=permissionOrAll();
			state._fsp--;

			// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:734:7: ( K_ON resource )?
			int alt77=2;
			int LA77_0 = input.LA(1);
			if ( (LA77_0==K_ON) ) {
				alt77=1;
			}
			switch (alt77) {
				case 1 :
					// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:734:9: K_ON resource
					{
					match(input,K_ON,FOLLOW_K_ON_in_listPermissionsStatement4077); 
					pushFollow(FOLLOW_resource_in_listPermissionsStatement4079);
					resource7=resource();
					state._fsp--;

					 resource = resource7; 
					}
					break;

			}

			// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:735:7: ( K_OF username )?
			int alt78=2;
			int LA78_0 = input.LA(1);
			if ( (LA78_0==K_OF) ) {
				alt78=1;
			}
			switch (alt78) {
				case 1 :
					// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:735:9: K_OF username
					{
					match(input,K_OF,FOLLOW_K_OF_in_listPermissionsStatement4094); 
					pushFollow(FOLLOW_username_in_listPermissionsStatement4096);
					username8=username();
					state._fsp--;

					 username = (username8!=null?input.toString(username8.start,username8.stop):null); 
					}
					break;

			}

			// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:736:7: ( K_NORECURSIVE )?
			int alt79=2;
			int LA79_0 = input.LA(1);
			if ( (LA79_0==K_NORECURSIVE) ) {
				alt79=1;
			}
			switch (alt79) {
				case 1 :
					// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:736:9: K_NORECURSIVE
					{
					match(input,K_NORECURSIVE,FOLLOW_K_NORECURSIVE_in_listPermissionsStatement4111); 
					 recursive = false; 
					}
					break;

			}

			 stmt = new ListPermissionsStatement(permissionOrAll9, resource, username, recursive); 
			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return stmt;
	}
	// $ANTLR end "listPermissionsStatement"



	// $ANTLR start "permission"
	// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:740:1: permission returns [Permission perm] : p= ( K_CREATE | K_ALTER | K_DROP | K_SELECT | K_MODIFY | K_AUTHORIZE ) ;
	public final Permission permission() throws RecognitionException {
		Permission perm = null;


		Token p=null;

		try {
			// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:741:5: (p= ( K_CREATE | K_ALTER | K_DROP | K_SELECT | K_MODIFY | K_AUTHORIZE ) )
			// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:741:7: p= ( K_CREATE | K_ALTER | K_DROP | K_SELECT | K_MODIFY | K_AUTHORIZE )
			{
			p=input.LT(1);
			if ( input.LA(1)==K_ALTER||input.LA(1)==K_AUTHORIZE||input.LA(1)==K_CREATE||input.LA(1)==K_DROP||input.LA(1)==K_MODIFY||input.LA(1)==K_SELECT ) {
				input.consume();
				state.errorRecovery=false;
			}
			else {
				MismatchedSetException mse = new MismatchedSetException(null,input);
				throw mse;
			}
			 perm = Permission.valueOf((p!=null?p.getText():null).toUpperCase()); 
			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return perm;
	}
	// $ANTLR end "permission"



	// $ANTLR start "permissionOrAll"
	// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:745:1: permissionOrAll returns [Set<Permission> perms] : ( K_ALL ( K_PERMISSIONS )? |p= permission ( K_PERMISSION )? );
	public final Set<Permission> permissionOrAll() throws RecognitionException {
		Set<Permission> perms = null;


		Permission p =null;

		try {
			// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:746:5: ( K_ALL ( K_PERMISSIONS )? |p= permission ( K_PERMISSION )? )
			int alt82=2;
			int LA82_0 = input.LA(1);
			if ( (LA82_0==K_ALL) ) {
				alt82=1;
			}
			else if ( (LA82_0==K_ALTER||LA82_0==K_AUTHORIZE||LA82_0==K_CREATE||LA82_0==K_DROP||LA82_0==K_MODIFY||LA82_0==K_SELECT) ) {
				alt82=2;
			}

			else {
				NoViableAltException nvae =
					new NoViableAltException("", 82, 0, input);
				throw nvae;
			}

			switch (alt82) {
				case 1 :
					// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:746:7: K_ALL ( K_PERMISSIONS )?
					{
					match(input,K_ALL,FOLLOW_K_ALL_in_permissionOrAll4196); 
					// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:746:13: ( K_PERMISSIONS )?
					int alt80=2;
					int LA80_0 = input.LA(1);
					if ( (LA80_0==K_PERMISSIONS) ) {
						alt80=1;
					}
					switch (alt80) {
						case 1 :
							// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:746:15: K_PERMISSIONS
							{
							match(input,K_PERMISSIONS,FOLLOW_K_PERMISSIONS_in_permissionOrAll4200); 
							}
							break;

					}

					 perms = Permission.ALL_DATA; 
					}
					break;
				case 2 :
					// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:747:7: p= permission ( K_PERMISSION )?
					{
					pushFollow(FOLLOW_permission_in_permissionOrAll4221);
					p=permission();
					state._fsp--;

					// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:747:20: ( K_PERMISSION )?
					int alt81=2;
					int LA81_0 = input.LA(1);
					if ( (LA81_0==K_PERMISSION) ) {
						alt81=1;
					}
					switch (alt81) {
						case 1 :
							// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:747:22: K_PERMISSION
							{
							match(input,K_PERMISSION,FOLLOW_K_PERMISSION_in_permissionOrAll4225); 
							}
							break;

					}

					 perms = EnumSet.of(p); 
					}
					break;

			}
		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return perms;
	}
	// $ANTLR end "permissionOrAll"



	// $ANTLR start "resource"
	// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:750:1: resource returns [IResource res] : r= dataResource ;
	public final IResource resource() throws RecognitionException {
		IResource res = null;


		DataResource r =null;

		try {
			// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:751:5: (r= dataResource )
			// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:751:7: r= dataResource
			{
			pushFollow(FOLLOW_dataResource_in_resource4253);
			r=dataResource();
			state._fsp--;

			 res = r; 
			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return res;
	}
	// $ANTLR end "resource"



	// $ANTLR start "dataResource"
	// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:754:1: dataResource returns [DataResource res] : ( K_ALL K_KEYSPACES | K_KEYSPACE ks= keyspaceName | ( K_COLUMNFAMILY )? cf= columnFamilyName );
	public final DataResource dataResource() throws RecognitionException {
		DataResource res = null;


		String ks =null;
		CFName cf =null;

		try {
			// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:755:5: ( K_ALL K_KEYSPACES | K_KEYSPACE ks= keyspaceName | ( K_COLUMNFAMILY )? cf= columnFamilyName )
			int alt84=3;
			switch ( input.LA(1) ) {
			case K_ALL:
				{
				int LA84_1 = input.LA(2);
				if ( (LA84_1==K_KEYSPACES) ) {
					alt84=1;
				}
				else if ( (LA84_1==EOF||LA84_1==K_FROM||LA84_1==K_NORECURSIVE||LA84_1==K_OF||LA84_1==K_TO||LA84_1==146||LA84_1==148) ) {
					alt84=3;
				}

				else {
					int nvaeMark = input.mark();
					try {
						input.consume();
						NoViableAltException nvae =
							new NoViableAltException("", 84, 1, input);
						throw nvae;
					} finally {
						input.rewind(nvaeMark);
					}
				}

				}
				break;
			case K_KEYSPACE:
				{
				alt84=2;
				}
				break;
			case IDENT:
			case K_AS:
			case K_ASCII:
			case K_BIGINT:
			case K_BLOB:
			case K_BOOLEAN:
			case K_CLUSTERING:
			case K_COLUMNFAMILY:
			case K_COMPACT:
			case K_CONTAINS:
			case K_COUNT:
			case K_COUNTER:
			case K_CUSTOM:
			case K_DECIMAL:
			case K_DISTINCT:
			case K_DOUBLE:
			case K_EXISTS:
			case K_FILTERING:
			case K_FLOAT:
			case K_INET:
			case K_INT:
			case K_KEY:
			case K_KEYS:
			case K_KEYSPACES:
			case K_LIST:
			case K_MAP:
			case K_NOSUPERUSER:
			case K_PASSWORD:
			case K_PERMISSION:
			case K_PERMISSIONS:
			case K_STATIC:
			case K_STORAGE:
			case K_SUPERUSER:
			case K_TEXT:
			case K_TIMESTAMP:
			case K_TIMEUUID:
			case K_TRIGGER:
			case K_TTL:
			case K_TYPE:
			case K_USER:
			case K_USERS:
			case K_UUID:
			case K_VALUES:
			case K_VARCHAR:
			case K_VARINT:
			case K_WRITETIME:
			case QUOTED_NAME:
				{
				alt84=3;
				}
				break;
			default:
				NoViableAltException nvae =
					new NoViableAltException("", 84, 0, input);
				throw nvae;
			}
			switch (alt84) {
				case 1 :
					// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:755:7: K_ALL K_KEYSPACES
					{
					match(input,K_ALL,FOLLOW_K_ALL_in_dataResource4276); 
					match(input,K_KEYSPACES,FOLLOW_K_KEYSPACES_in_dataResource4278); 
					 res = DataResource.root(); 
					}
					break;
				case 2 :
					// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:756:7: K_KEYSPACE ks= keyspaceName
					{
					match(input,K_KEYSPACE,FOLLOW_K_KEYSPACE_in_dataResource4288); 
					pushFollow(FOLLOW_keyspaceName_in_dataResource4294);
					ks=keyspaceName();
					state._fsp--;

					 res = DataResource.keyspace(ks); 
					}
					break;
				case 3 :
					// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:757:7: ( K_COLUMNFAMILY )? cf= columnFamilyName
					{
					// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:757:7: ( K_COLUMNFAMILY )?
					int alt83=2;
					int LA83_0 = input.LA(1);
					if ( (LA83_0==K_COLUMNFAMILY) ) {
						alt83=1;
					}
					switch (alt83) {
						case 1 :
							// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:757:9: K_COLUMNFAMILY
							{
							match(input,K_COLUMNFAMILY,FOLLOW_K_COLUMNFAMILY_in_dataResource4306); 
							}
							break;

					}

					pushFollow(FOLLOW_columnFamilyName_in_dataResource4315);
					cf=columnFamilyName();
					state._fsp--;

					 res = DataResource.columnFamily(cf.getKeyspace(), cf.getColumnFamily()); 
					}
					break;

			}
		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return res;
	}
	// $ANTLR end "dataResource"



	// $ANTLR start "createUserStatement"
	// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:764:1: createUserStatement returns [CreateUserStatement stmt] : K_CREATE K_USER ( K_IF K_NOT K_EXISTS )? username ( K_WITH userOptions[opts] )? ( K_SUPERUSER | K_NOSUPERUSER )? ;
	public final CreateUserStatement createUserStatement() throws RecognitionException {
		CreateUserStatement stmt = null;


		ParserRuleReturnScope username10 =null;


		        UserOptions opts = new UserOptions();
		        boolean superuser = false;
		        boolean ifNotExists = false;
		    
		try {
			// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:770:5: ( K_CREATE K_USER ( K_IF K_NOT K_EXISTS )? username ( K_WITH userOptions[opts] )? ( K_SUPERUSER | K_NOSUPERUSER )? )
			// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:770:7: K_CREATE K_USER ( K_IF K_NOT K_EXISTS )? username ( K_WITH userOptions[opts] )? ( K_SUPERUSER | K_NOSUPERUSER )?
			{
			match(input,K_CREATE,FOLLOW_K_CREATE_in_createUserStatement4355); 
			match(input,K_USER,FOLLOW_K_USER_in_createUserStatement4357); 
			// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:770:23: ( K_IF K_NOT K_EXISTS )?
			int alt85=2;
			int LA85_0 = input.LA(1);
			if ( (LA85_0==K_IF) ) {
				alt85=1;
			}
			switch (alt85) {
				case 1 :
					// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:770:24: K_IF K_NOT K_EXISTS
					{
					match(input,K_IF,FOLLOW_K_IF_in_createUserStatement4360); 
					match(input,K_NOT,FOLLOW_K_NOT_in_createUserStatement4362); 
					match(input,K_EXISTS,FOLLOW_K_EXISTS_in_createUserStatement4364); 
					 ifNotExists = true; 
					}
					break;

			}

			pushFollow(FOLLOW_username_in_createUserStatement4370);
			username10=username();
			state._fsp--;

			// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:771:7: ( K_WITH userOptions[opts] )?
			int alt86=2;
			int LA86_0 = input.LA(1);
			if ( (LA86_0==K_WITH) ) {
				alt86=1;
			}
			switch (alt86) {
				case 1 :
					// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:771:9: K_WITH userOptions[opts]
					{
					match(input,K_WITH,FOLLOW_K_WITH_in_createUserStatement4380); 
					pushFollow(FOLLOW_userOptions_in_createUserStatement4382);
					userOptions(opts);
					state._fsp--;

					}
					break;

			}

			// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:772:7: ( K_SUPERUSER | K_NOSUPERUSER )?
			int alt87=3;
			int LA87_0 = input.LA(1);
			if ( (LA87_0==K_SUPERUSER) ) {
				alt87=1;
			}
			else if ( (LA87_0==K_NOSUPERUSER) ) {
				alt87=2;
			}
			switch (alt87) {
				case 1 :
					// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:772:9: K_SUPERUSER
					{
					match(input,K_SUPERUSER,FOLLOW_K_SUPERUSER_in_createUserStatement4396); 
					 superuser = true; 
					}
					break;
				case 2 :
					// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:772:45: K_NOSUPERUSER
					{
					match(input,K_NOSUPERUSER,FOLLOW_K_NOSUPERUSER_in_createUserStatement4402); 
					 superuser = false; 
					}
					break;

			}

			 stmt = new CreateUserStatement((username10!=null?input.toString(username10.start,username10.stop):null), opts, superuser, ifNotExists); 
			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return stmt;
	}
	// $ANTLR end "createUserStatement"



	// $ANTLR start "alterUserStatement"
	// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:779:1: alterUserStatement returns [AlterUserStatement stmt] : K_ALTER K_USER username ( K_WITH userOptions[opts] )? ( K_SUPERUSER | K_NOSUPERUSER )? ;
	public final AlterUserStatement alterUserStatement() throws RecognitionException {
		AlterUserStatement stmt = null;


		ParserRuleReturnScope username11 =null;


		        UserOptions opts = new UserOptions();
		        Boolean superuser = null;
		    
		try {
			// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:784:5: ( K_ALTER K_USER username ( K_WITH userOptions[opts] )? ( K_SUPERUSER | K_NOSUPERUSER )? )
			// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:784:7: K_ALTER K_USER username ( K_WITH userOptions[opts] )? ( K_SUPERUSER | K_NOSUPERUSER )?
			{
			match(input,K_ALTER,FOLLOW_K_ALTER_in_alterUserStatement4447); 
			match(input,K_USER,FOLLOW_K_USER_in_alterUserStatement4449); 
			pushFollow(FOLLOW_username_in_alterUserStatement4451);
			username11=username();
			state._fsp--;

			// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:785:7: ( K_WITH userOptions[opts] )?
			int alt88=2;
			int LA88_0 = input.LA(1);
			if ( (LA88_0==K_WITH) ) {
				alt88=1;
			}
			switch (alt88) {
				case 1 :
					// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:785:9: K_WITH userOptions[opts]
					{
					match(input,K_WITH,FOLLOW_K_WITH_in_alterUserStatement4461); 
					pushFollow(FOLLOW_userOptions_in_alterUserStatement4463);
					userOptions(opts);
					state._fsp--;

					}
					break;

			}

			// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:786:7: ( K_SUPERUSER | K_NOSUPERUSER )?
			int alt89=3;
			int LA89_0 = input.LA(1);
			if ( (LA89_0==K_SUPERUSER) ) {
				alt89=1;
			}
			else if ( (LA89_0==K_NOSUPERUSER) ) {
				alt89=2;
			}
			switch (alt89) {
				case 1 :
					// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:786:9: K_SUPERUSER
					{
					match(input,K_SUPERUSER,FOLLOW_K_SUPERUSER_in_alterUserStatement4477); 
					 superuser = true; 
					}
					break;
				case 2 :
					// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:786:45: K_NOSUPERUSER
					{
					match(input,K_NOSUPERUSER,FOLLOW_K_NOSUPERUSER_in_alterUserStatement4483); 
					 superuser = false; 
					}
					break;

			}

			 stmt = new AlterUserStatement((username11!=null?input.toString(username11.start,username11.stop):null), opts, superuser); 
			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return stmt;
	}
	// $ANTLR end "alterUserStatement"



	// $ANTLR start "dropUserStatement"
	// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:793:1: dropUserStatement returns [DropUserStatement stmt] : K_DROP K_USER ( K_IF K_EXISTS )? username ;
	public final DropUserStatement dropUserStatement() throws RecognitionException {
		DropUserStatement stmt = null;


		ParserRuleReturnScope username12 =null;

		 boolean ifExists = false; 
		try {
			// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:795:5: ( K_DROP K_USER ( K_IF K_EXISTS )? username )
			// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:795:7: K_DROP K_USER ( K_IF K_EXISTS )? username
			{
			match(input,K_DROP,FOLLOW_K_DROP_in_dropUserStatement4528); 
			match(input,K_USER,FOLLOW_K_USER_in_dropUserStatement4530); 
			// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:795:21: ( K_IF K_EXISTS )?
			int alt90=2;
			int LA90_0 = input.LA(1);
			if ( (LA90_0==K_IF) ) {
				alt90=1;
			}
			switch (alt90) {
				case 1 :
					// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:795:22: K_IF K_EXISTS
					{
					match(input,K_IF,FOLLOW_K_IF_in_dropUserStatement4533); 
					match(input,K_EXISTS,FOLLOW_K_EXISTS_in_dropUserStatement4535); 
					 ifExists = true; 
					}
					break;

			}

			pushFollow(FOLLOW_username_in_dropUserStatement4541);
			username12=username();
			state._fsp--;

			 stmt = new DropUserStatement((username12!=null?input.toString(username12.start,username12.stop):null), ifExists); 
			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return stmt;
	}
	// $ANTLR end "dropUserStatement"



	// $ANTLR start "listUsersStatement"
	// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:801:1: listUsersStatement returns [ListUsersStatement stmt] : K_LIST K_USERS ;
	public final ListUsersStatement listUsersStatement() throws RecognitionException {
		ListUsersStatement stmt = null;


		try {
			// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:802:5: ( K_LIST K_USERS )
			// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:802:7: K_LIST K_USERS
			{
			match(input,K_LIST,FOLLOW_K_LIST_in_listUsersStatement4566); 
			match(input,K_USERS,FOLLOW_K_USERS_in_listUsersStatement4568); 
			 stmt = new ListUsersStatement(); 
			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return stmt;
	}
	// $ANTLR end "listUsersStatement"



	// $ANTLR start "userOptions"
	// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:805:1: userOptions[UserOptions opts] : userOption[opts] ;
	public final void userOptions(UserOptions opts) throws RecognitionException {
		try {
			// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:806:5: ( userOption[opts] )
			// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:806:7: userOption[opts]
			{
			pushFollow(FOLLOW_userOption_in_userOptions4588);
			userOption(opts);
			state._fsp--;

			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "userOptions"



	// $ANTLR start "userOption"
	// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:809:1: userOption[UserOptions opts] : k= K_PASSWORD v= STRING_LITERAL ;
	public final void userOption(UserOptions opts) throws RecognitionException {
		Token k=null;
		Token v=null;

		try {
			// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:810:5: (k= K_PASSWORD v= STRING_LITERAL )
			// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:810:7: k= K_PASSWORD v= STRING_LITERAL
			{
			k=(Token)match(input,K_PASSWORD,FOLLOW_K_PASSWORD_in_userOption4609); 
			v=(Token)match(input,STRING_LITERAL,FOLLOW_STRING_LITERAL_in_userOption4613); 
			 opts.put((k!=null?k.getText():null), (v!=null?v.getText():null)); 
			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "userOption"



	// $ANTLR start "cident"
	// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:818:1: cident returns [ColumnIdentifier.Raw id] : (t= IDENT |t= QUOTED_NAME |k= unreserved_keyword );
	public final ColumnIdentifier.Raw cident() throws RecognitionException {
		ColumnIdentifier.Raw id = null;


		Token t=null;
		String k =null;

		try {
			// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:819:5: (t= IDENT |t= QUOTED_NAME |k= unreserved_keyword )
			int alt91=3;
			switch ( input.LA(1) ) {
			case IDENT:
				{
				alt91=1;
				}
				break;
			case QUOTED_NAME:
				{
				alt91=2;
				}
				break;
			case K_ALL:
			case K_AS:
			case K_ASCII:
			case K_BIGINT:
			case K_BLOB:
			case K_BOOLEAN:
			case K_CLUSTERING:
			case K_COMPACT:
			case K_CONTAINS:
			case K_COUNT:
			case K_COUNTER:
			case K_CUSTOM:
			case K_DECIMAL:
			case K_DISTINCT:
			case K_DOUBLE:
			case K_EXISTS:
			case K_FILTERING:
			case K_FLOAT:
			case K_INET:
			case K_INT:
			case K_KEY:
			case K_KEYS:
			case K_KEYSPACES:
			case K_LIST:
			case K_MAP:
			case K_NOSUPERUSER:
			case K_PASSWORD:
			case K_PERMISSION:
			case K_PERMISSIONS:
			case K_STATIC:
			case K_STORAGE:
			case K_SUPERUSER:
			case K_TEXT:
			case K_TIMESTAMP:
			case K_TIMEUUID:
			case K_TRIGGER:
			case K_TTL:
			case K_TYPE:
			case K_USER:
			case K_USERS:
			case K_UUID:
			case K_VALUES:
			case K_VARCHAR:
			case K_VARINT:
			case K_WRITETIME:
				{
				alt91=3;
				}
				break;
			default:
				NoViableAltException nvae =
					new NoViableAltException("", 91, 0, input);
				throw nvae;
			}
			switch (alt91) {
				case 1 :
					// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:819:7: t= IDENT
					{
					t=(Token)match(input,IDENT,FOLLOW_IDENT_in_cident4644); 
					 id = new ColumnIdentifier.Raw((t!=null?t.getText():null), false); 
					}
					break;
				case 2 :
					// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:820:7: t= QUOTED_NAME
					{
					t=(Token)match(input,QUOTED_NAME,FOLLOW_QUOTED_NAME_in_cident4669); 
					 id = new ColumnIdentifier.Raw((t!=null?t.getText():null), true); 
					}
					break;
				case 3 :
					// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:821:7: k= unreserved_keyword
					{
					pushFollow(FOLLOW_unreserved_keyword_in_cident4688);
					k=unreserved_keyword();
					state._fsp--;

					 id = new ColumnIdentifier.Raw(k, false); 
					}
					break;

			}
		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return id;
	}
	// $ANTLR end "cident"



	// $ANTLR start "ident"
	// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:825:1: ident returns [ColumnIdentifier id] : (t= IDENT |t= QUOTED_NAME |k= unreserved_keyword );
	public final ColumnIdentifier ident() throws RecognitionException {
		ColumnIdentifier id = null;


		Token t=null;
		String k =null;

		try {
			// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:826:5: (t= IDENT |t= QUOTED_NAME |k= unreserved_keyword )
			int alt92=3;
			switch ( input.LA(1) ) {
			case IDENT:
				{
				alt92=1;
				}
				break;
			case QUOTED_NAME:
				{
				alt92=2;
				}
				break;
			case K_ALL:
			case K_AS:
			case K_ASCII:
			case K_BIGINT:
			case K_BLOB:
			case K_BOOLEAN:
			case K_CLUSTERING:
			case K_COMPACT:
			case K_CONTAINS:
			case K_COUNT:
			case K_COUNTER:
			case K_CUSTOM:
			case K_DECIMAL:
			case K_DISTINCT:
			case K_DOUBLE:
			case K_EXISTS:
			case K_FILTERING:
			case K_FLOAT:
			case K_INET:
			case K_INT:
			case K_KEY:
			case K_KEYS:
			case K_KEYSPACES:
			case K_LIST:
			case K_MAP:
			case K_NOSUPERUSER:
			case K_PASSWORD:
			case K_PERMISSION:
			case K_PERMISSIONS:
			case K_STATIC:
			case K_STORAGE:
			case K_SUPERUSER:
			case K_TEXT:
			case K_TIMESTAMP:
			case K_TIMEUUID:
			case K_TRIGGER:
			case K_TTL:
			case K_TYPE:
			case K_USER:
			case K_USERS:
			case K_UUID:
			case K_VALUES:
			case K_VARCHAR:
			case K_VARINT:
			case K_WRITETIME:
				{
				alt92=3;
				}
				break;
			default:
				NoViableAltException nvae =
					new NoViableAltException("", 92, 0, input);
				throw nvae;
			}
			switch (alt92) {
				case 1 :
					// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:826:7: t= IDENT
					{
					t=(Token)match(input,IDENT,FOLLOW_IDENT_in_ident4714); 
					 id = new ColumnIdentifier((t!=null?t.getText():null), false); 
					}
					break;
				case 2 :
					// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:827:7: t= QUOTED_NAME
					{
					t=(Token)match(input,QUOTED_NAME,FOLLOW_QUOTED_NAME_in_ident4739); 
					 id = new ColumnIdentifier((t!=null?t.getText():null), true); 
					}
					break;
				case 3 :
					// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:828:7: k= unreserved_keyword
					{
					pushFollow(FOLLOW_unreserved_keyword_in_ident4758);
					k=unreserved_keyword();
					state._fsp--;

					 id = new ColumnIdentifier(k, false); 
					}
					break;

			}
		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return id;
	}
	// $ANTLR end "ident"



	// $ANTLR start "keyspaceName"
	// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:832:1: keyspaceName returns [String id] : cfOrKsName[name, true] ;
	public final String keyspaceName() throws RecognitionException {
		String id = null;


		 CFName name = new CFName(); 
		try {
			// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:834:5: ( cfOrKsName[name, true] )
			// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:834:7: cfOrKsName[name, true]
			{
			pushFollow(FOLLOW_cfOrKsName_in_keyspaceName4791);
			cfOrKsName(name, true);
			state._fsp--;

			 id = name.getKeyspace(); 
			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return id;
	}
	// $ANTLR end "keyspaceName"



	// $ANTLR start "indexName"
	// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:837:1: indexName returns [IndexName name] : ( idxOrKsName[name, true] '.' )? idxOrKsName[name, false] ;
	public final IndexName indexName() throws RecognitionException {
		IndexName name = null;


		 name = new IndexName(); 
		try {
			// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:839:5: ( ( idxOrKsName[name, true] '.' )? idxOrKsName[name, false] )
			// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:839:7: ( idxOrKsName[name, true] '.' )? idxOrKsName[name, false]
			{
			// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:839:7: ( idxOrKsName[name, true] '.' )?
			int alt93=2;
			switch ( input.LA(1) ) {
				case IDENT:
					{
					int LA93_1 = input.LA(2);
					if ( (LA93_1==146) ) {
						alt93=1;
					}
					}
					break;
				case QUOTED_NAME:
					{
					int LA93_2 = input.LA(2);
					if ( (LA93_2==146) ) {
						alt93=1;
					}
					}
					break;
				case K_ALL:
				case K_AS:
				case K_CLUSTERING:
				case K_COMPACT:
				case K_CONTAINS:
				case K_CUSTOM:
				case K_DISTINCT:
				case K_EXISTS:
				case K_FILTERING:
				case K_KEYS:
				case K_KEYSPACES:
				case K_LIST:
				case K_MAP:
				case K_NOSUPERUSER:
				case K_PASSWORD:
				case K_PERMISSION:
				case K_PERMISSIONS:
				case K_STATIC:
				case K_STORAGE:
				case K_SUPERUSER:
				case K_TRIGGER:
				case K_TYPE:
				case K_USER:
				case K_USERS:
				case K_VALUES:
					{
					int LA93_3 = input.LA(2);
					if ( (LA93_3==146) ) {
						alt93=1;
					}
					}
					break;
				case K_ASCII:
					{
					int LA93_4 = input.LA(2);
					if ( (LA93_4==146) ) {
						alt93=1;
					}
					}
					break;
				case K_BIGINT:
					{
					int LA93_5 = input.LA(2);
					if ( (LA93_5==146) ) {
						alt93=1;
					}
					}
					break;
				case K_BLOB:
					{
					int LA93_6 = input.LA(2);
					if ( (LA93_6==146) ) {
						alt93=1;
					}
					}
					break;
				case K_BOOLEAN:
					{
					int LA93_7 = input.LA(2);
					if ( (LA93_7==146) ) {
						alt93=1;
					}
					}
					break;
				case K_COUNTER:
					{
					int LA93_8 = input.LA(2);
					if ( (LA93_8==146) ) {
						alt93=1;
					}
					}
					break;
				case K_DECIMAL:
					{
					int LA93_9 = input.LA(2);
					if ( (LA93_9==146) ) {
						alt93=1;
					}
					}
					break;
				case K_DOUBLE:
					{
					int LA93_10 = input.LA(2);
					if ( (LA93_10==146) ) {
						alt93=1;
					}
					}
					break;
				case K_FLOAT:
					{
					int LA93_11 = input.LA(2);
					if ( (LA93_11==146) ) {
						alt93=1;
					}
					}
					break;
				case K_INET:
					{
					int LA93_12 = input.LA(2);
					if ( (LA93_12==146) ) {
						alt93=1;
					}
					}
					break;
				case K_INT:
					{
					int LA93_13 = input.LA(2);
					if ( (LA93_13==146) ) {
						alt93=1;
					}
					}
					break;
				case K_TEXT:
					{
					int LA93_14 = input.LA(2);
					if ( (LA93_14==146) ) {
						alt93=1;
					}
					}
					break;
				case K_TIMESTAMP:
					{
					int LA93_15 = input.LA(2);
					if ( (LA93_15==146) ) {
						alt93=1;
					}
					}
					break;
				case K_UUID:
					{
					int LA93_16 = input.LA(2);
					if ( (LA93_16==146) ) {
						alt93=1;
					}
					}
					break;
				case K_VARCHAR:
					{
					int LA93_17 = input.LA(2);
					if ( (LA93_17==146) ) {
						alt93=1;
					}
					}
					break;
				case K_VARINT:
					{
					int LA93_18 = input.LA(2);
					if ( (LA93_18==146) ) {
						alt93=1;
					}
					}
					break;
				case K_TIMEUUID:
					{
					int LA93_19 = input.LA(2);
					if ( (LA93_19==146) ) {
						alt93=1;
					}
					}
					break;
				case K_COUNT:
				case K_KEY:
				case K_TTL:
				case K_WRITETIME:
					{
					int LA93_20 = input.LA(2);
					if ( (LA93_20==146) ) {
						alt93=1;
					}
					}
					break;
			}
			switch (alt93) {
				case 1 :
					// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:839:8: idxOrKsName[name, true] '.'
					{
					pushFollow(FOLLOW_idxOrKsName_in_indexName4825);
					idxOrKsName(name, true);
					state._fsp--;

					match(input,146,FOLLOW_146_in_indexName4828); 
					}
					break;

			}

			pushFollow(FOLLOW_idxOrKsName_in_indexName4832);
			idxOrKsName(name, false);
			state._fsp--;

			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return name;
	}
	// $ANTLR end "indexName"



	// $ANTLR start "idxOrKsName"
	// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:842:1: idxOrKsName[IndexName name, boolean isKs] : (t= IDENT |t= QUOTED_NAME |k= unreserved_keyword );
	public final void idxOrKsName(IndexName name, boolean isKs) throws RecognitionException {
		Token t=null;
		String k =null;

		try {
			// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:843:5: (t= IDENT |t= QUOTED_NAME |k= unreserved_keyword )
			int alt94=3;
			switch ( input.LA(1) ) {
			case IDENT:
				{
				alt94=1;
				}
				break;
			case QUOTED_NAME:
				{
				alt94=2;
				}
				break;
			case K_ALL:
			case K_AS:
			case K_ASCII:
			case K_BIGINT:
			case K_BLOB:
			case K_BOOLEAN:
			case K_CLUSTERING:
			case K_COMPACT:
			case K_CONTAINS:
			case K_COUNT:
			case K_COUNTER:
			case K_CUSTOM:
			case K_DECIMAL:
			case K_DISTINCT:
			case K_DOUBLE:
			case K_EXISTS:
			case K_FILTERING:
			case K_FLOAT:
			case K_INET:
			case K_INT:
			case K_KEY:
			case K_KEYS:
			case K_KEYSPACES:
			case K_LIST:
			case K_MAP:
			case K_NOSUPERUSER:
			case K_PASSWORD:
			case K_PERMISSION:
			case K_PERMISSIONS:
			case K_STATIC:
			case K_STORAGE:
			case K_SUPERUSER:
			case K_TEXT:
			case K_TIMESTAMP:
			case K_TIMEUUID:
			case K_TRIGGER:
			case K_TTL:
			case K_TYPE:
			case K_USER:
			case K_USERS:
			case K_UUID:
			case K_VALUES:
			case K_VARCHAR:
			case K_VARINT:
			case K_WRITETIME:
				{
				alt94=3;
				}
				break;
			default:
				NoViableAltException nvae =
					new NoViableAltException("", 94, 0, input);
				throw nvae;
			}
			switch (alt94) {
				case 1 :
					// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:843:7: t= IDENT
					{
					t=(Token)match(input,IDENT,FOLLOW_IDENT_in_idxOrKsName4853); 
					 if (isKs) name.setKeyspace((t!=null?t.getText():null), false); else name.setIndex((t!=null?t.getText():null), false); 
					}
					break;
				case 2 :
					// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:844:7: t= QUOTED_NAME
					{
					t=(Token)match(input,QUOTED_NAME,FOLLOW_QUOTED_NAME_in_idxOrKsName4878); 
					 if (isKs) name.setKeyspace((t!=null?t.getText():null), true); else name.setIndex((t!=null?t.getText():null), true); 
					}
					break;
				case 3 :
					// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:845:7: k= unreserved_keyword
					{
					pushFollow(FOLLOW_unreserved_keyword_in_idxOrKsName4897);
					k=unreserved_keyword();
					state._fsp--;

					 if (isKs) name.setKeyspace(k, false); else name.setIndex(k, false); 
					}
					break;

			}
		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "idxOrKsName"



	// $ANTLR start "columnFamilyName"
	// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:848:1: columnFamilyName returns [CFName name] : ( cfOrKsName[name, true] '.' )? cfOrKsName[name, false] ;
	public final CFName columnFamilyName() throws RecognitionException {
		CFName name = null;


		 name = new CFName(); 
		try {
			// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:850:5: ( ( cfOrKsName[name, true] '.' )? cfOrKsName[name, false] )
			// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:850:7: ( cfOrKsName[name, true] '.' )? cfOrKsName[name, false]
			{
			// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:850:7: ( cfOrKsName[name, true] '.' )?
			int alt95=2;
			switch ( input.LA(1) ) {
				case IDENT:
					{
					int LA95_1 = input.LA(2);
					if ( (LA95_1==146) ) {
						alt95=1;
					}
					}
					break;
				case QUOTED_NAME:
					{
					int LA95_2 = input.LA(2);
					if ( (LA95_2==146) ) {
						alt95=1;
					}
					}
					break;
				case K_ALL:
				case K_AS:
				case K_CLUSTERING:
				case K_COMPACT:
				case K_CONTAINS:
				case K_CUSTOM:
				case K_DISTINCT:
				case K_EXISTS:
				case K_FILTERING:
				case K_KEYS:
				case K_KEYSPACES:
				case K_LIST:
				case K_MAP:
				case K_NOSUPERUSER:
				case K_PASSWORD:
				case K_PERMISSION:
				case K_PERMISSIONS:
				case K_STATIC:
				case K_STORAGE:
				case K_SUPERUSER:
				case K_TRIGGER:
				case K_TYPE:
				case K_USER:
				case K_USERS:
				case K_VALUES:
					{
					int LA95_3 = input.LA(2);
					if ( (LA95_3==146) ) {
						alt95=1;
					}
					}
					break;
				case K_ASCII:
					{
					int LA95_4 = input.LA(2);
					if ( (LA95_4==146) ) {
						alt95=1;
					}
					}
					break;
				case K_BIGINT:
					{
					int LA95_5 = input.LA(2);
					if ( (LA95_5==146) ) {
						alt95=1;
					}
					}
					break;
				case K_BLOB:
					{
					int LA95_6 = input.LA(2);
					if ( (LA95_6==146) ) {
						alt95=1;
					}
					}
					break;
				case K_BOOLEAN:
					{
					int LA95_7 = input.LA(2);
					if ( (LA95_7==146) ) {
						alt95=1;
					}
					}
					break;
				case K_COUNTER:
					{
					int LA95_8 = input.LA(2);
					if ( (LA95_8==146) ) {
						alt95=1;
					}
					}
					break;
				case K_DECIMAL:
					{
					int LA95_9 = input.LA(2);
					if ( (LA95_9==146) ) {
						alt95=1;
					}
					}
					break;
				case K_DOUBLE:
					{
					int LA95_10 = input.LA(2);
					if ( (LA95_10==146) ) {
						alt95=1;
					}
					}
					break;
				case K_FLOAT:
					{
					int LA95_11 = input.LA(2);
					if ( (LA95_11==146) ) {
						alt95=1;
					}
					}
					break;
				case K_INET:
					{
					int LA95_12 = input.LA(2);
					if ( (LA95_12==146) ) {
						alt95=1;
					}
					}
					break;
				case K_INT:
					{
					int LA95_13 = input.LA(2);
					if ( (LA95_13==146) ) {
						alt95=1;
					}
					}
					break;
				case K_TEXT:
					{
					int LA95_14 = input.LA(2);
					if ( (LA95_14==146) ) {
						alt95=1;
					}
					}
					break;
				case K_TIMESTAMP:
					{
					int LA95_15 = input.LA(2);
					if ( (LA95_15==146) ) {
						alt95=1;
					}
					}
					break;
				case K_UUID:
					{
					int LA95_16 = input.LA(2);
					if ( (LA95_16==146) ) {
						alt95=1;
					}
					}
					break;
				case K_VARCHAR:
					{
					int LA95_17 = input.LA(2);
					if ( (LA95_17==146) ) {
						alt95=1;
					}
					}
					break;
				case K_VARINT:
					{
					int LA95_18 = input.LA(2);
					if ( (LA95_18==146) ) {
						alt95=1;
					}
					}
					break;
				case K_TIMEUUID:
					{
					int LA95_19 = input.LA(2);
					if ( (LA95_19==146) ) {
						alt95=1;
					}
					}
					break;
				case K_COUNT:
				case K_KEY:
				case K_TTL:
				case K_WRITETIME:
					{
					int LA95_20 = input.LA(2);
					if ( (LA95_20==146) ) {
						alt95=1;
					}
					}
					break;
			}
			switch (alt95) {
				case 1 :
					// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:850:8: cfOrKsName[name, true] '.'
					{
					pushFollow(FOLLOW_cfOrKsName_in_columnFamilyName4930);
					cfOrKsName(name, true);
					state._fsp--;

					match(input,146,FOLLOW_146_in_columnFamilyName4933); 
					}
					break;

			}

			pushFollow(FOLLOW_cfOrKsName_in_columnFamilyName4937);
			cfOrKsName(name, false);
			state._fsp--;

			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return name;
	}
	// $ANTLR end "columnFamilyName"



	// $ANTLR start "userTypeName"
	// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:853:1: userTypeName returns [UTName name] : (ks= ident '.' )? ut= non_type_ident ;
	public final UTName userTypeName() throws RecognitionException {
		UTName name = null;


		ColumnIdentifier ks =null;
		ColumnIdentifier ut =null;

		try {
			// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:854:5: ( (ks= ident '.' )? ut= non_type_ident )
			// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:854:7: (ks= ident '.' )? ut= non_type_ident
			{
			// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:854:7: (ks= ident '.' )?
			int alt96=2;
			switch ( input.LA(1) ) {
				case IDENT:
					{
					int LA96_1 = input.LA(2);
					if ( (LA96_1==146) ) {
						alt96=1;
					}
					}
					break;
				case QUOTED_NAME:
					{
					int LA96_2 = input.LA(2);
					if ( (LA96_2==146) ) {
						alt96=1;
					}
					}
					break;
				case K_ALL:
				case K_AS:
				case K_CLUSTERING:
				case K_COMPACT:
				case K_CONTAINS:
				case K_CUSTOM:
				case K_DISTINCT:
				case K_EXISTS:
				case K_FILTERING:
				case K_KEYS:
				case K_KEYSPACES:
				case K_LIST:
				case K_MAP:
				case K_NOSUPERUSER:
				case K_PASSWORD:
				case K_PERMISSION:
				case K_PERMISSIONS:
				case K_STATIC:
				case K_STORAGE:
				case K_SUPERUSER:
				case K_TRIGGER:
				case K_TYPE:
				case K_USER:
				case K_USERS:
				case K_VALUES:
					{
					int LA96_3 = input.LA(2);
					if ( (LA96_3==146) ) {
						alt96=1;
					}
					}
					break;
				case K_ASCII:
				case K_BIGINT:
				case K_BLOB:
				case K_BOOLEAN:
				case K_COUNT:
				case K_COUNTER:
				case K_DECIMAL:
				case K_DOUBLE:
				case K_FLOAT:
				case K_INET:
				case K_INT:
				case K_TEXT:
				case K_TIMESTAMP:
				case K_TIMEUUID:
				case K_TTL:
				case K_UUID:
				case K_VARCHAR:
				case K_VARINT:
				case K_WRITETIME:
					{
					alt96=1;
					}
					break;
				case K_KEY:
					{
					int LA96_5 = input.LA(2);
					if ( (LA96_5==146) ) {
						alt96=1;
					}
					}
					break;
			}
			switch (alt96) {
				case 1 :
					// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:854:8: ks= ident '.'
					{
					pushFollow(FOLLOW_ident_in_userTypeName4962);
					ks=ident();
					state._fsp--;

					match(input,146,FOLLOW_146_in_userTypeName4964); 
					}
					break;

			}

			pushFollow(FOLLOW_non_type_ident_in_userTypeName4970);
			ut=non_type_ident();
			state._fsp--;

			 return new UTName(ks, ut); 
			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return name;
	}
	// $ANTLR end "userTypeName"



	// $ANTLR start "cfOrKsName"
	// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:857:1: cfOrKsName[CFName name, boolean isKs] : (t= IDENT |t= QUOTED_NAME |k= unreserved_keyword );
	public final void cfOrKsName(CFName name, boolean isKs) throws RecognitionException {
		Token t=null;
		String k =null;

		try {
			// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:858:5: (t= IDENT |t= QUOTED_NAME |k= unreserved_keyword )
			int alt97=3;
			switch ( input.LA(1) ) {
			case IDENT:
				{
				alt97=1;
				}
				break;
			case QUOTED_NAME:
				{
				alt97=2;
				}
				break;
			case K_ALL:
			case K_AS:
			case K_ASCII:
			case K_BIGINT:
			case K_BLOB:
			case K_BOOLEAN:
			case K_CLUSTERING:
			case K_COMPACT:
			case K_CONTAINS:
			case K_COUNT:
			case K_COUNTER:
			case K_CUSTOM:
			case K_DECIMAL:
			case K_DISTINCT:
			case K_DOUBLE:
			case K_EXISTS:
			case K_FILTERING:
			case K_FLOAT:
			case K_INET:
			case K_INT:
			case K_KEY:
			case K_KEYS:
			case K_KEYSPACES:
			case K_LIST:
			case K_MAP:
			case K_NOSUPERUSER:
			case K_PASSWORD:
			case K_PERMISSION:
			case K_PERMISSIONS:
			case K_STATIC:
			case K_STORAGE:
			case K_SUPERUSER:
			case K_TEXT:
			case K_TIMESTAMP:
			case K_TIMEUUID:
			case K_TRIGGER:
			case K_TTL:
			case K_TYPE:
			case K_USER:
			case K_USERS:
			case K_UUID:
			case K_VALUES:
			case K_VARCHAR:
			case K_VARINT:
			case K_WRITETIME:
				{
				alt97=3;
				}
				break;
			default:
				NoViableAltException nvae =
					new NoViableAltException("", 97, 0, input);
				throw nvae;
			}
			switch (alt97) {
				case 1 :
					// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:858:7: t= IDENT
					{
					t=(Token)match(input,IDENT,FOLLOW_IDENT_in_cfOrKsName4992); 
					 if (isKs) name.setKeyspace((t!=null?t.getText():null), false); else name.setColumnFamily((t!=null?t.getText():null), false); 
					}
					break;
				case 2 :
					// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:859:7: t= QUOTED_NAME
					{
					t=(Token)match(input,QUOTED_NAME,FOLLOW_QUOTED_NAME_in_cfOrKsName5017); 
					 if (isKs) name.setKeyspace((t!=null?t.getText():null), true); else name.setColumnFamily((t!=null?t.getText():null), true); 
					}
					break;
				case 3 :
					// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:860:7: k= unreserved_keyword
					{
					pushFollow(FOLLOW_unreserved_keyword_in_cfOrKsName5036);
					k=unreserved_keyword();
					state._fsp--;

					 if (isKs) name.setKeyspace(k, false); else name.setColumnFamily(k, false); 
					}
					break;

			}
		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "cfOrKsName"



	// $ANTLR start "constant"
	// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:863:1: constant returns [Constants.Literal constant] : (t= STRING_LITERAL |t= INTEGER |t= FLOAT |t= BOOLEAN |t= UUID |t= HEXNUMBER | ( '-' )? t= ( K_NAN | K_INFINITY ) );
	public final Constants.Literal constant() throws RecognitionException {
		Constants.Literal constant = null;


		Token t=null;

		try {
			// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:864:5: (t= STRING_LITERAL |t= INTEGER |t= FLOAT |t= BOOLEAN |t= UUID |t= HEXNUMBER | ( '-' )? t= ( K_NAN | K_INFINITY ) )
			int alt99=7;
			switch ( input.LA(1) ) {
			case STRING_LITERAL:
				{
				alt99=1;
				}
				break;
			case INTEGER:
				{
				alt99=2;
				}
				break;
			case FLOAT:
				{
				alt99=3;
				}
				break;
			case BOOLEAN:
				{
				alt99=4;
				}
				break;
			case UUID:
				{
				alt99=5;
				}
				break;
			case HEXNUMBER:
				{
				alt99=6;
				}
				break;
			case K_INFINITY:
			case K_NAN:
			case 145:
				{
				alt99=7;
				}
				break;
			default:
				NoViableAltException nvae =
					new NoViableAltException("", 99, 0, input);
				throw nvae;
			}
			switch (alt99) {
				case 1 :
					// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:864:7: t= STRING_LITERAL
					{
					t=(Token)match(input,STRING_LITERAL,FOLLOW_STRING_LITERAL_in_constant5061); 
					 constant = Constants.Literal.string((t!=null?t.getText():null)); 
					}
					break;
				case 2 :
					// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:865:7: t= INTEGER
					{
					t=(Token)match(input,INTEGER,FOLLOW_INTEGER_in_constant5073); 
					 constant = Constants.Literal.integer((t!=null?t.getText():null)); 
					}
					break;
				case 3 :
					// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:866:7: t= FLOAT
					{
					t=(Token)match(input,FLOAT,FOLLOW_FLOAT_in_constant5092); 
					 constant = Constants.Literal.floatingPoint((t!=null?t.getText():null)); 
					}
					break;
				case 4 :
					// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:867:7: t= BOOLEAN
					{
					t=(Token)match(input,BOOLEAN,FOLLOW_BOOLEAN_in_constant5113); 
					 constant = Constants.Literal.bool((t!=null?t.getText():null)); 
					}
					break;
				case 5 :
					// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:868:7: t= UUID
					{
					t=(Token)match(input,UUID,FOLLOW_UUID_in_constant5132); 
					 constant = Constants.Literal.uuid((t!=null?t.getText():null)); 
					}
					break;
				case 6 :
					// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:869:7: t= HEXNUMBER
					{
					t=(Token)match(input,HEXNUMBER,FOLLOW_HEXNUMBER_in_constant5154); 
					 constant = Constants.Literal.hex((t!=null?t.getText():null)); 
					}
					break;
				case 7 :
					// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:870:7: ( '-' )? t= ( K_NAN | K_INFINITY )
					{
					 String sign=""; 
					// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:870:27: ( '-' )?
					int alt98=2;
					int LA98_0 = input.LA(1);
					if ( (LA98_0==145) ) {
						alt98=1;
					}
					switch (alt98) {
						case 1 :
							// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:870:28: '-'
							{
							match(input,145,FOLLOW_145_in_constant5172); 
							sign = "-"; 
							}
							break;

					}

					t=input.LT(1);
					if ( input.LA(1)==K_INFINITY||input.LA(1)==K_NAN ) {
						input.consume();
						state.errorRecovery=false;
					}
					else {
						MismatchedSetException mse = new MismatchedSetException(null,input);
						throw mse;
					}
					 constant = Constants.Literal.floatingPoint(sign + (t!=null?t.getText():null)); 
					}
					break;

			}
		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return constant;
	}
	// $ANTLR end "constant"



	// $ANTLR start "mapLiteral"
	// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:873:1: mapLiteral returns [Maps.Literal map] : '{' (k1= term ':' v1= term ( ',' kn= term ':' vn= term )* )? '}' ;
	public final Maps.Literal mapLiteral() throws RecognitionException {
		Maps.Literal map = null;


		Term.Raw k1 =null;
		Term.Raw v1 =null;
		Term.Raw kn =null;
		Term.Raw vn =null;

		try {
			// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:874:5: ( '{' (k1= term ':' v1= term ( ',' kn= term ':' vn= term )* )? '}' )
			// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:874:7: '{' (k1= term ':' v1= term ( ',' kn= term ':' vn= term )* )? '}'
			{
			match(input,157,FOLLOW_157_in_mapLiteral5210); 
			 List<Pair<Term.Raw, Term.Raw>> m = new ArrayList<Pair<Term.Raw, Term.Raw>>(); 
			// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:875:11: (k1= term ':' v1= term ( ',' kn= term ':' vn= term )* )?
			int alt101=2;
			int LA101_0 = input.LA(1);
			if ( (LA101_0==BOOLEAN||LA101_0==FLOAT||LA101_0==HEXNUMBER||(LA101_0 >= IDENT && LA101_0 <= INTEGER)||LA101_0==K_ALL||LA101_0==K_AS||LA101_0==K_ASCII||(LA101_0 >= K_BIGINT && LA101_0 <= K_BOOLEAN)||LA101_0==K_CLUSTERING||(LA101_0 >= K_COMPACT && LA101_0 <= K_CONTAINS)||LA101_0==K_COUNTER||(LA101_0 >= K_CUSTOM && LA101_0 <= K_DECIMAL)||(LA101_0 >= K_DISTINCT && LA101_0 <= K_DOUBLE)||(LA101_0 >= K_EXISTS && LA101_0 <= K_FLOAT)||(LA101_0 >= K_INET && LA101_0 <= K_INFINITY)||LA101_0==K_INT||LA101_0==K_KEYS||LA101_0==K_KEYSPACES||(LA101_0 >= K_LIST && LA101_0 <= K_MAP)||LA101_0==K_NAN||LA101_0==K_NOSUPERUSER||LA101_0==K_NULL||(LA101_0 >= K_PASSWORD && LA101_0 <= K_PERMISSIONS)||(LA101_0 >= K_STATIC && LA101_0 <= K_TIMEUUID)||(LA101_0 >= K_TOKEN && LA101_0 <= K_TRIGGER)||LA101_0==K_TYPE||(LA101_0 >= K_USER && LA101_0 <= K_USERS)||(LA101_0 >= K_UUID && LA101_0 <= K_VARINT)||LA101_0==QMARK||LA101_0==STRING_LITERAL||LA101_0==UUID||LA101_0==141||LA101_0==145||LA101_0==147||LA101_0==154||LA101_0==157) ) {
				alt101=1;
			}
			switch (alt101) {
				case 1 :
					// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:875:13: k1= term ':' v1= term ( ',' kn= term ':' vn= term )*
					{
					pushFollow(FOLLOW_term_in_mapLiteral5228);
					k1=term();
					state._fsp--;

					match(input,147,FOLLOW_147_in_mapLiteral5230); 
					pushFollow(FOLLOW_term_in_mapLiteral5234);
					v1=term();
					state._fsp--;

					 m.add(Pair.create(k1, v1)); 
					// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:875:65: ( ',' kn= term ':' vn= term )*
					loop100:
					while (true) {
						int alt100=2;
						int LA100_0 = input.LA(1);
						if ( (LA100_0==144) ) {
							alt100=1;
						}

						switch (alt100) {
						case 1 :
							// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:875:67: ',' kn= term ':' vn= term
							{
							match(input,144,FOLLOW_144_in_mapLiteral5240); 
							pushFollow(FOLLOW_term_in_mapLiteral5244);
							kn=term();
							state._fsp--;

							match(input,147,FOLLOW_147_in_mapLiteral5246); 
							pushFollow(FOLLOW_term_in_mapLiteral5250);
							vn=term();
							state._fsp--;

							 m.add(Pair.create(kn, vn)); 
							}
							break;

						default :
							break loop100;
						}
					}

					}
					break;

			}

			match(input,158,FOLLOW_158_in_mapLiteral5266); 
			 map = new Maps.Literal(m); 
			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return map;
	}
	// $ANTLR end "mapLiteral"



	// $ANTLR start "setOrMapLiteral"
	// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:879:1: setOrMapLiteral[Term.Raw t] returns [Term.Raw value] : ( ':' v= term ( ',' kn= term ':' vn= term )* | ( ',' tn= term )* );
	public final Term.Raw setOrMapLiteral(Term.Raw t) throws RecognitionException {
		Term.Raw value = null;


		Term.Raw v =null;
		Term.Raw kn =null;
		Term.Raw vn =null;
		Term.Raw tn =null;

		try {
			// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:880:5: ( ':' v= term ( ',' kn= term ':' vn= term )* | ( ',' tn= term )* )
			int alt104=2;
			int LA104_0 = input.LA(1);
			if ( (LA104_0==147) ) {
				alt104=1;
			}
			else if ( (LA104_0==144||LA104_0==158) ) {
				alt104=2;
			}

			else {
				NoViableAltException nvae =
					new NoViableAltException("", 104, 0, input);
				throw nvae;
			}

			switch (alt104) {
				case 1 :
					// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:880:7: ':' v= term ( ',' kn= term ':' vn= term )*
					{
					match(input,147,FOLLOW_147_in_setOrMapLiteral5290); 
					pushFollow(FOLLOW_term_in_setOrMapLiteral5294);
					v=term();
					state._fsp--;

					 List<Pair<Term.Raw, Term.Raw>> m = new ArrayList<Pair<Term.Raw, Term.Raw>>(); m.add(Pair.create(t, v)); 
					// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:881:11: ( ',' kn= term ':' vn= term )*
					loop102:
					while (true) {
						int alt102=2;
						int LA102_0 = input.LA(1);
						if ( (LA102_0==144) ) {
							alt102=1;
						}

						switch (alt102) {
						case 1 :
							// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:881:13: ',' kn= term ':' vn= term
							{
							match(input,144,FOLLOW_144_in_setOrMapLiteral5310); 
							pushFollow(FOLLOW_term_in_setOrMapLiteral5314);
							kn=term();
							state._fsp--;

							match(input,147,FOLLOW_147_in_setOrMapLiteral5316); 
							pushFollow(FOLLOW_term_in_setOrMapLiteral5320);
							vn=term();
							state._fsp--;

							 m.add(Pair.create(kn, vn)); 
							}
							break;

						default :
							break loop102;
						}
					}

					 value = new Maps.Literal(m); 
					}
					break;
				case 2 :
					// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:883:7: ( ',' tn= term )*
					{
					 List<Term.Raw> s = new ArrayList<Term.Raw>(); s.add(t); 
					// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:884:11: ( ',' tn= term )*
					loop103:
					while (true) {
						int alt103=2;
						int LA103_0 = input.LA(1);
						if ( (LA103_0==144) ) {
							alt103=1;
						}

						switch (alt103) {
						case 1 :
							// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:884:13: ',' tn= term
							{
							match(input,144,FOLLOW_144_in_setOrMapLiteral5355); 
							pushFollow(FOLLOW_term_in_setOrMapLiteral5359);
							tn=term();
							state._fsp--;

							 s.add(tn); 
							}
							break;

						default :
							break loop103;
						}
					}

					 value = new Sets.Literal(s); 
					}
					break;

			}
		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return value;
	}
	// $ANTLR end "setOrMapLiteral"



	// $ANTLR start "collectionLiteral"
	// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:888:1: collectionLiteral returns [Term.Raw value] : ( '[' (t1= term ( ',' tn= term )* )? ']' | '{' t= term v= setOrMapLiteral[t] '}' | '{' '}' );
	public final Term.Raw collectionLiteral() throws RecognitionException {
		Term.Raw value = null;


		Term.Raw t1 =null;
		Term.Raw tn =null;
		Term.Raw t =null;
		Term.Raw v =null;

		try {
			// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:889:5: ( '[' (t1= term ( ',' tn= term )* )? ']' | '{' t= term v= setOrMapLiteral[t] '}' | '{' '}' )
			int alt107=3;
			int LA107_0 = input.LA(1);
			if ( (LA107_0==154) ) {
				alt107=1;
			}
			else if ( (LA107_0==157) ) {
				int LA107_2 = input.LA(2);
				if ( (LA107_2==158) ) {
					alt107=3;
				}
				else if ( (LA107_2==BOOLEAN||LA107_2==FLOAT||LA107_2==HEXNUMBER||(LA107_2 >= IDENT && LA107_2 <= INTEGER)||LA107_2==K_ALL||LA107_2==K_AS||LA107_2==K_ASCII||(LA107_2 >= K_BIGINT && LA107_2 <= K_BOOLEAN)||LA107_2==K_CLUSTERING||(LA107_2 >= K_COMPACT && LA107_2 <= K_CONTAINS)||LA107_2==K_COUNTER||(LA107_2 >= K_CUSTOM && LA107_2 <= K_DECIMAL)||(LA107_2 >= K_DISTINCT && LA107_2 <= K_DOUBLE)||(LA107_2 >= K_EXISTS && LA107_2 <= K_FLOAT)||(LA107_2 >= K_INET && LA107_2 <= K_INFINITY)||LA107_2==K_INT||LA107_2==K_KEYS||LA107_2==K_KEYSPACES||(LA107_2 >= K_LIST && LA107_2 <= K_MAP)||LA107_2==K_NAN||LA107_2==K_NOSUPERUSER||LA107_2==K_NULL||(LA107_2 >= K_PASSWORD && LA107_2 <= K_PERMISSIONS)||(LA107_2 >= K_STATIC && LA107_2 <= K_TIMEUUID)||(LA107_2 >= K_TOKEN && LA107_2 <= K_TRIGGER)||LA107_2==K_TYPE||(LA107_2 >= K_USER && LA107_2 <= K_USERS)||(LA107_2 >= K_UUID && LA107_2 <= K_VARINT)||LA107_2==QMARK||LA107_2==STRING_LITERAL||LA107_2==UUID||LA107_2==141||LA107_2==145||LA107_2==147||LA107_2==154||LA107_2==157) ) {
					alt107=2;
				}

				else {
					int nvaeMark = input.mark();
					try {
						input.consume();
						NoViableAltException nvae =
							new NoViableAltException("", 107, 2, input);
						throw nvae;
					} finally {
						input.rewind(nvaeMark);
					}
				}

			}

			else {
				NoViableAltException nvae =
					new NoViableAltException("", 107, 0, input);
				throw nvae;
			}

			switch (alt107) {
				case 1 :
					// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:889:7: '[' (t1= term ( ',' tn= term )* )? ']'
					{
					match(input,154,FOLLOW_154_in_collectionLiteral5393); 
					 List<Term.Raw> l = new ArrayList<Term.Raw>(); 
					// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:890:11: (t1= term ( ',' tn= term )* )?
					int alt106=2;
					int LA106_0 = input.LA(1);
					if ( (LA106_0==BOOLEAN||LA106_0==FLOAT||LA106_0==HEXNUMBER||(LA106_0 >= IDENT && LA106_0 <= INTEGER)||LA106_0==K_ALL||LA106_0==K_AS||LA106_0==K_ASCII||(LA106_0 >= K_BIGINT && LA106_0 <= K_BOOLEAN)||LA106_0==K_CLUSTERING||(LA106_0 >= K_COMPACT && LA106_0 <= K_CONTAINS)||LA106_0==K_COUNTER||(LA106_0 >= K_CUSTOM && LA106_0 <= K_DECIMAL)||(LA106_0 >= K_DISTINCT && LA106_0 <= K_DOUBLE)||(LA106_0 >= K_EXISTS && LA106_0 <= K_FLOAT)||(LA106_0 >= K_INET && LA106_0 <= K_INFINITY)||LA106_0==K_INT||LA106_0==K_KEYS||LA106_0==K_KEYSPACES||(LA106_0 >= K_LIST && LA106_0 <= K_MAP)||LA106_0==K_NAN||LA106_0==K_NOSUPERUSER||LA106_0==K_NULL||(LA106_0 >= K_PASSWORD && LA106_0 <= K_PERMISSIONS)||(LA106_0 >= K_STATIC && LA106_0 <= K_TIMEUUID)||(LA106_0 >= K_TOKEN && LA106_0 <= K_TRIGGER)||LA106_0==K_TYPE||(LA106_0 >= K_USER && LA106_0 <= K_USERS)||(LA106_0 >= K_UUID && LA106_0 <= K_VARINT)||LA106_0==QMARK||LA106_0==STRING_LITERAL||LA106_0==UUID||LA106_0==141||LA106_0==145||LA106_0==147||LA106_0==154||LA106_0==157) ) {
						alt106=1;
					}
					switch (alt106) {
						case 1 :
							// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:890:13: t1= term ( ',' tn= term )*
							{
							pushFollow(FOLLOW_term_in_collectionLiteral5411);
							t1=term();
							state._fsp--;

							 l.add(t1); 
							// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:890:36: ( ',' tn= term )*
							loop105:
							while (true) {
								int alt105=2;
								int LA105_0 = input.LA(1);
								if ( (LA105_0==144) ) {
									alt105=1;
								}

								switch (alt105) {
								case 1 :
									// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:890:38: ',' tn= term
									{
									match(input,144,FOLLOW_144_in_collectionLiteral5417); 
									pushFollow(FOLLOW_term_in_collectionLiteral5421);
									tn=term();
									state._fsp--;

									 l.add(tn); 
									}
									break;

								default :
									break loop105;
								}
							}

							}
							break;

					}

					match(input,156,FOLLOW_156_in_collectionLiteral5437); 
					 value = new Lists.Literal(l); 
					}
					break;
				case 2 :
					// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:892:7: '{' t= term v= setOrMapLiteral[t] '}'
					{
					match(input,157,FOLLOW_157_in_collectionLiteral5447); 
					pushFollow(FOLLOW_term_in_collectionLiteral5451);
					t=term();
					state._fsp--;

					pushFollow(FOLLOW_setOrMapLiteral_in_collectionLiteral5455);
					v=setOrMapLiteral(t);
					state._fsp--;

					 value = v; 
					match(input,158,FOLLOW_158_in_collectionLiteral5460); 
					}
					break;
				case 3 :
					// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:895:7: '{' '}'
					{
					match(input,157,FOLLOW_157_in_collectionLiteral5478); 
					match(input,158,FOLLOW_158_in_collectionLiteral5480); 
					 value = new Sets.Literal(Collections.<Term.Raw>emptyList()); 
					}
					break;

			}
		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return value;
	}
	// $ANTLR end "collectionLiteral"



	// $ANTLR start "usertypeLiteral"
	// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:898:1: usertypeLiteral returns [UserTypes.Literal ut] : '{' k1= ident ':' v1= term ( ',' kn= ident ':' vn= term )* '}' ;
	public final UserTypes.Literal usertypeLiteral() throws RecognitionException {
		UserTypes.Literal ut = null;


		ColumnIdentifier k1 =null;
		Term.Raw v1 =null;
		ColumnIdentifier kn =null;
		Term.Raw vn =null;

		 Map<ColumnIdentifier, Term.Raw> m = new HashMap<ColumnIdentifier, Term.Raw>(); 
		try {
			// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:902:5: ( '{' k1= ident ':' v1= term ( ',' kn= ident ':' vn= term )* '}' )
			// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:902:7: '{' k1= ident ':' v1= term ( ',' kn= ident ':' vn= term )* '}'
			{
			match(input,157,FOLLOW_157_in_usertypeLiteral5524); 
			pushFollow(FOLLOW_ident_in_usertypeLiteral5528);
			k1=ident();
			state._fsp--;

			match(input,147,FOLLOW_147_in_usertypeLiteral5530); 
			pushFollow(FOLLOW_term_in_usertypeLiteral5534);
			v1=term();
			state._fsp--;

			 m.put(k1, v1); 
			// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:902:51: ( ',' kn= ident ':' vn= term )*
			loop108:
			while (true) {
				int alt108=2;
				int LA108_0 = input.LA(1);
				if ( (LA108_0==144) ) {
					alt108=1;
				}

				switch (alt108) {
				case 1 :
					// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:902:53: ',' kn= ident ':' vn= term
					{
					match(input,144,FOLLOW_144_in_usertypeLiteral5540); 
					pushFollow(FOLLOW_ident_in_usertypeLiteral5544);
					kn=ident();
					state._fsp--;

					match(input,147,FOLLOW_147_in_usertypeLiteral5546); 
					pushFollow(FOLLOW_term_in_usertypeLiteral5550);
					vn=term();
					state._fsp--;

					 m.put(kn, vn); 
					}
					break;

				default :
					break loop108;
				}
			}

			match(input,158,FOLLOW_158_in_usertypeLiteral5557); 
			}

			 ut = new UserTypes.Literal(m); 
		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return ut;
	}
	// $ANTLR end "usertypeLiteral"



	// $ANTLR start "tupleLiteral"
	// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:905:1: tupleLiteral returns [Tuples.Literal tt] : '(' t1= term ( ',' tn= term )* ')' ;
	public final Tuples.Literal tupleLiteral() throws RecognitionException {
		Tuples.Literal tt = null;


		Term.Raw t1 =null;
		Term.Raw tn =null;

		 List<Term.Raw> l = new ArrayList<Term.Raw>(); 
		try {
			// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:908:5: ( '(' t1= term ( ',' tn= term )* ')' )
			// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:908:7: '(' t1= term ( ',' tn= term )* ')'
			{
			match(input,141,FOLLOW_141_in_tupleLiteral5594); 
			pushFollow(FOLLOW_term_in_tupleLiteral5598);
			t1=term();
			state._fsp--;

			 l.add(t1); 
			// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:908:34: ( ',' tn= term )*
			loop109:
			while (true) {
				int alt109=2;
				int LA109_0 = input.LA(1);
				if ( (LA109_0==144) ) {
					alt109=1;
				}

				switch (alt109) {
				case 1 :
					// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:908:36: ',' tn= term
					{
					match(input,144,FOLLOW_144_in_tupleLiteral5604); 
					pushFollow(FOLLOW_term_in_tupleLiteral5608);
					tn=term();
					state._fsp--;

					 l.add(tn); 
					}
					break;

				default :
					break loop109;
				}
			}

			match(input,142,FOLLOW_142_in_tupleLiteral5615); 
			}

			 tt = new Tuples.Literal(l); 
		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return tt;
	}
	// $ANTLR end "tupleLiteral"



	// $ANTLR start "value"
	// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:911:1: value returns [Term.Raw value] : (c= constant |l= collectionLiteral |u= usertypeLiteral |t= tupleLiteral | K_NULL | ':' id= ident | QMARK );
	public final Term.Raw value() throws RecognitionException {
		Term.Raw value = null;


		Constants.Literal c =null;
		Term.Raw l =null;
		UserTypes.Literal u =null;
		Tuples.Literal t =null;
		ColumnIdentifier id =null;

		try {
			// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:912:5: (c= constant |l= collectionLiteral |u= usertypeLiteral |t= tupleLiteral | K_NULL | ':' id= ident | QMARK )
			int alt110=7;
			switch ( input.LA(1) ) {
			case BOOLEAN:
			case FLOAT:
			case HEXNUMBER:
			case INTEGER:
			case K_INFINITY:
			case K_NAN:
			case STRING_LITERAL:
			case UUID:
			case 145:
				{
				alt110=1;
				}
				break;
			case 154:
				{
				alt110=2;
				}
				break;
			case 157:
				{
				switch ( input.LA(2) ) {
				case BOOLEAN:
				case FLOAT:
				case HEXNUMBER:
				case INTEGER:
				case K_INFINITY:
				case K_NAN:
				case K_NULL:
				case K_TOKEN:
				case QMARK:
				case STRING_LITERAL:
				case UUID:
				case 141:
				case 145:
				case 147:
				case 154:
				case 157:
				case 158:
					{
					alt110=2;
					}
					break;
				case IDENT:
					{
					int LA110_8 = input.LA(3);
					if ( (LA110_8==141) ) {
						alt110=2;
					}
					else if ( (LA110_8==147) ) {
						alt110=3;
					}

					else {
						int nvaeMark = input.mark();
						try {
							for (int nvaeConsume = 0; nvaeConsume < 3 - 1; nvaeConsume++) {
								input.consume();
							}
							NoViableAltException nvae =
								new NoViableAltException("", 110, 8, input);
							throw nvae;
						} finally {
							input.rewind(nvaeMark);
						}
					}

					}
					break;
				case K_ALL:
				case K_AS:
				case K_CLUSTERING:
				case K_COMPACT:
				case K_CONTAINS:
				case K_CUSTOM:
				case K_DISTINCT:
				case K_EXISTS:
				case K_FILTERING:
				case K_KEYS:
				case K_KEYSPACES:
				case K_LIST:
				case K_MAP:
				case K_NOSUPERUSER:
				case K_PASSWORD:
				case K_PERMISSION:
				case K_PERMISSIONS:
				case K_STATIC:
				case K_STORAGE:
				case K_SUPERUSER:
				case K_TRIGGER:
				case K_TYPE:
				case K_USER:
				case K_USERS:
				case K_VALUES:
					{
					int LA110_9 = input.LA(3);
					if ( (LA110_9==141) ) {
						alt110=2;
					}
					else if ( (LA110_9==147) ) {
						alt110=3;
					}

					else {
						int nvaeMark = input.mark();
						try {
							for (int nvaeConsume = 0; nvaeConsume < 3 - 1; nvaeConsume++) {
								input.consume();
							}
							NoViableAltException nvae =
								new NoViableAltException("", 110, 9, input);
							throw nvae;
						} finally {
							input.rewind(nvaeMark);
						}
					}

					}
					break;
				case K_ASCII:
					{
					int LA110_10 = input.LA(3);
					if ( (LA110_10==141) ) {
						alt110=2;
					}
					else if ( (LA110_10==147) ) {
						alt110=3;
					}

					else {
						int nvaeMark = input.mark();
						try {
							for (int nvaeConsume = 0; nvaeConsume < 3 - 1; nvaeConsume++) {
								input.consume();
							}
							NoViableAltException nvae =
								new NoViableAltException("", 110, 10, input);
							throw nvae;
						} finally {
							input.rewind(nvaeMark);
						}
					}

					}
					break;
				case K_BIGINT:
					{
					int LA110_11 = input.LA(3);
					if ( (LA110_11==141) ) {
						alt110=2;
					}
					else if ( (LA110_11==147) ) {
						alt110=3;
					}

					else {
						int nvaeMark = input.mark();
						try {
							for (int nvaeConsume = 0; nvaeConsume < 3 - 1; nvaeConsume++) {
								input.consume();
							}
							NoViableAltException nvae =
								new NoViableAltException("", 110, 11, input);
							throw nvae;
						} finally {
							input.rewind(nvaeMark);
						}
					}

					}
					break;
				case K_BLOB:
					{
					int LA110_12 = input.LA(3);
					if ( (LA110_12==141) ) {
						alt110=2;
					}
					else if ( (LA110_12==147) ) {
						alt110=3;
					}

					else {
						int nvaeMark = input.mark();
						try {
							for (int nvaeConsume = 0; nvaeConsume < 3 - 1; nvaeConsume++) {
								input.consume();
							}
							NoViableAltException nvae =
								new NoViableAltException("", 110, 12, input);
							throw nvae;
						} finally {
							input.rewind(nvaeMark);
						}
					}

					}
					break;
				case K_BOOLEAN:
					{
					int LA110_13 = input.LA(3);
					if ( (LA110_13==141) ) {
						alt110=2;
					}
					else if ( (LA110_13==147) ) {
						alt110=3;
					}

					else {
						int nvaeMark = input.mark();
						try {
							for (int nvaeConsume = 0; nvaeConsume < 3 - 1; nvaeConsume++) {
								input.consume();
							}
							NoViableAltException nvae =
								new NoViableAltException("", 110, 13, input);
							throw nvae;
						} finally {
							input.rewind(nvaeMark);
						}
					}

					}
					break;
				case K_COUNTER:
					{
					int LA110_14 = input.LA(3);
					if ( (LA110_14==141) ) {
						alt110=2;
					}
					else if ( (LA110_14==147) ) {
						alt110=3;
					}

					else {
						int nvaeMark = input.mark();
						try {
							for (int nvaeConsume = 0; nvaeConsume < 3 - 1; nvaeConsume++) {
								input.consume();
							}
							NoViableAltException nvae =
								new NoViableAltException("", 110, 14, input);
							throw nvae;
						} finally {
							input.rewind(nvaeMark);
						}
					}

					}
					break;
				case K_DECIMAL:
					{
					int LA110_15 = input.LA(3);
					if ( (LA110_15==141) ) {
						alt110=2;
					}
					else if ( (LA110_15==147) ) {
						alt110=3;
					}

					else {
						int nvaeMark = input.mark();
						try {
							for (int nvaeConsume = 0; nvaeConsume < 3 - 1; nvaeConsume++) {
								input.consume();
							}
							NoViableAltException nvae =
								new NoViableAltException("", 110, 15, input);
							throw nvae;
						} finally {
							input.rewind(nvaeMark);
						}
					}

					}
					break;
				case K_DOUBLE:
					{
					int LA110_16 = input.LA(3);
					if ( (LA110_16==141) ) {
						alt110=2;
					}
					else if ( (LA110_16==147) ) {
						alt110=3;
					}

					else {
						int nvaeMark = input.mark();
						try {
							for (int nvaeConsume = 0; nvaeConsume < 3 - 1; nvaeConsume++) {
								input.consume();
							}
							NoViableAltException nvae =
								new NoViableAltException("", 110, 16, input);
							throw nvae;
						} finally {
							input.rewind(nvaeMark);
						}
					}

					}
					break;
				case K_FLOAT:
					{
					int LA110_17 = input.LA(3);
					if ( (LA110_17==141) ) {
						alt110=2;
					}
					else if ( (LA110_17==147) ) {
						alt110=3;
					}

					else {
						int nvaeMark = input.mark();
						try {
							for (int nvaeConsume = 0; nvaeConsume < 3 - 1; nvaeConsume++) {
								input.consume();
							}
							NoViableAltException nvae =
								new NoViableAltException("", 110, 17, input);
							throw nvae;
						} finally {
							input.rewind(nvaeMark);
						}
					}

					}
					break;
				case K_INET:
					{
					int LA110_18 = input.LA(3);
					if ( (LA110_18==141) ) {
						alt110=2;
					}
					else if ( (LA110_18==147) ) {
						alt110=3;
					}

					else {
						int nvaeMark = input.mark();
						try {
							for (int nvaeConsume = 0; nvaeConsume < 3 - 1; nvaeConsume++) {
								input.consume();
							}
							NoViableAltException nvae =
								new NoViableAltException("", 110, 18, input);
							throw nvae;
						} finally {
							input.rewind(nvaeMark);
						}
					}

					}
					break;
				case K_INT:
					{
					int LA110_19 = input.LA(3);
					if ( (LA110_19==141) ) {
						alt110=2;
					}
					else if ( (LA110_19==147) ) {
						alt110=3;
					}

					else {
						int nvaeMark = input.mark();
						try {
							for (int nvaeConsume = 0; nvaeConsume < 3 - 1; nvaeConsume++) {
								input.consume();
							}
							NoViableAltException nvae =
								new NoViableAltException("", 110, 19, input);
							throw nvae;
						} finally {
							input.rewind(nvaeMark);
						}
					}

					}
					break;
				case K_TEXT:
					{
					int LA110_20 = input.LA(3);
					if ( (LA110_20==141) ) {
						alt110=2;
					}
					else if ( (LA110_20==147) ) {
						alt110=3;
					}

					else {
						int nvaeMark = input.mark();
						try {
							for (int nvaeConsume = 0; nvaeConsume < 3 - 1; nvaeConsume++) {
								input.consume();
							}
							NoViableAltException nvae =
								new NoViableAltException("", 110, 20, input);
							throw nvae;
						} finally {
							input.rewind(nvaeMark);
						}
					}

					}
					break;
				case K_TIMESTAMP:
					{
					int LA110_21 = input.LA(3);
					if ( (LA110_21==141) ) {
						alt110=2;
					}
					else if ( (LA110_21==147) ) {
						alt110=3;
					}

					else {
						int nvaeMark = input.mark();
						try {
							for (int nvaeConsume = 0; nvaeConsume < 3 - 1; nvaeConsume++) {
								input.consume();
							}
							NoViableAltException nvae =
								new NoViableAltException("", 110, 21, input);
							throw nvae;
						} finally {
							input.rewind(nvaeMark);
						}
					}

					}
					break;
				case K_UUID:
					{
					int LA110_22 = input.LA(3);
					if ( (LA110_22==141) ) {
						alt110=2;
					}
					else if ( (LA110_22==147) ) {
						alt110=3;
					}

					else {
						int nvaeMark = input.mark();
						try {
							for (int nvaeConsume = 0; nvaeConsume < 3 - 1; nvaeConsume++) {
								input.consume();
							}
							NoViableAltException nvae =
								new NoViableAltException("", 110, 22, input);
							throw nvae;
						} finally {
							input.rewind(nvaeMark);
						}
					}

					}
					break;
				case K_VARCHAR:
					{
					int LA110_23 = input.LA(3);
					if ( (LA110_23==141) ) {
						alt110=2;
					}
					else if ( (LA110_23==147) ) {
						alt110=3;
					}

					else {
						int nvaeMark = input.mark();
						try {
							for (int nvaeConsume = 0; nvaeConsume < 3 - 1; nvaeConsume++) {
								input.consume();
							}
							NoViableAltException nvae =
								new NoViableAltException("", 110, 23, input);
							throw nvae;
						} finally {
							input.rewind(nvaeMark);
						}
					}

					}
					break;
				case K_VARINT:
					{
					int LA110_24 = input.LA(3);
					if ( (LA110_24==141) ) {
						alt110=2;
					}
					else if ( (LA110_24==147) ) {
						alt110=3;
					}

					else {
						int nvaeMark = input.mark();
						try {
							for (int nvaeConsume = 0; nvaeConsume < 3 - 1; nvaeConsume++) {
								input.consume();
							}
							NoViableAltException nvae =
								new NoViableAltException("", 110, 24, input);
							throw nvae;
						} finally {
							input.rewind(nvaeMark);
						}
					}

					}
					break;
				case K_TIMEUUID:
					{
					int LA110_25 = input.LA(3);
					if ( (LA110_25==141) ) {
						alt110=2;
					}
					else if ( (LA110_25==147) ) {
						alt110=3;
					}

					else {
						int nvaeMark = input.mark();
						try {
							for (int nvaeConsume = 0; nvaeConsume < 3 - 1; nvaeConsume++) {
								input.consume();
							}
							NoViableAltException nvae =
								new NoViableAltException("", 110, 25, input);
							throw nvae;
						} finally {
							input.rewind(nvaeMark);
						}
					}

					}
					break;
				case K_COUNT:
				case K_KEY:
				case K_TTL:
				case K_WRITETIME:
				case QUOTED_NAME:
					{
					alt110=3;
					}
					break;
				default:
					int nvaeMark = input.mark();
					try {
						input.consume();
						NoViableAltException nvae =
							new NoViableAltException("", 110, 3, input);
						throw nvae;
					} finally {
						input.rewind(nvaeMark);
					}
				}
				}
				break;
			case 141:
				{
				alt110=4;
				}
				break;
			case K_NULL:
				{
				alt110=5;
				}
				break;
			case 147:
				{
				alt110=6;
				}
				break;
			case QMARK:
				{
				alt110=7;
				}
				break;
			default:
				NoViableAltException nvae =
					new NoViableAltException("", 110, 0, input);
				throw nvae;
			}
			switch (alt110) {
				case 1 :
					// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:912:7: c= constant
					{
					pushFollow(FOLLOW_constant_in_value5638);
					c=constant();
					state._fsp--;

					 value = c; 
					}
					break;
				case 2 :
					// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:913:7: l= collectionLiteral
					{
					pushFollow(FOLLOW_collectionLiteral_in_value5660);
					l=collectionLiteral();
					state._fsp--;

					 value = l; 
					}
					break;
				case 3 :
					// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:914:7: u= usertypeLiteral
					{
					pushFollow(FOLLOW_usertypeLiteral_in_value5673);
					u=usertypeLiteral();
					state._fsp--;

					 value = u; 
					}
					break;
				case 4 :
					// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:915:7: t= tupleLiteral
					{
					pushFollow(FOLLOW_tupleLiteral_in_value5688);
					t=tupleLiteral();
					state._fsp--;

					 value = t; 
					}
					break;
				case 5 :
					// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:916:7: K_NULL
					{
					match(input,K_NULL,FOLLOW_K_NULL_in_value5704); 
					 value = Constants.NULL_LITERAL; 
					}
					break;
				case 6 :
					// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:917:7: ':' id= ident
					{
					match(input,147,FOLLOW_147_in_value5728); 
					pushFollow(FOLLOW_ident_in_value5732);
					id=ident();
					state._fsp--;

					 value = newBindVariables(id); 
					}
					break;
				case 7 :
					// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:918:7: QMARK
					{
					match(input,QMARK,FOLLOW_QMARK_in_value5750); 
					 value = newBindVariables(null); 
					}
					break;

			}
		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return value;
	}
	// $ANTLR end "value"



	// $ANTLR start "intValue"
	// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:921:1: intValue returns [Term.Raw value] : (|t= INTEGER | ':' id= ident | QMARK );
	public final Term.Raw intValue() throws RecognitionException {
		Term.Raw value = null;


		Token t=null;
		ColumnIdentifier id =null;

		try {
			// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:922:5: (|t= INTEGER | ':' id= ident | QMARK )
			int alt111=4;
			switch ( input.LA(1) ) {
			case EOF:
			case K_ALLOW:
			case K_AND:
			case K_APPLY:
			case K_DELETE:
			case K_INSERT:
			case K_SET:
			case K_UPDATE:
			case K_WHERE:
			case 148:
				{
				alt111=1;
				}
				break;
			case INTEGER:
				{
				alt111=2;
				}
				break;
			case 147:
				{
				alt111=3;
				}
				break;
			case QMARK:
				{
				alt111=4;
				}
				break;
			default:
				NoViableAltException nvae =
					new NoViableAltException("", 111, 0, input);
				throw nvae;
			}
			switch (alt111) {
				case 1 :
					// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:923:5: 
					{
					}
					break;
				case 2 :
					// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:923:7: t= INTEGER
					{
					t=(Token)match(input,INTEGER,FOLLOW_INTEGER_in_intValue5796); 
					 value = Constants.Literal.integer((t!=null?t.getText():null)); 
					}
					break;
				case 3 :
					// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:924:7: ':' id= ident
					{
					match(input,147,FOLLOW_147_in_intValue5810); 
					pushFollow(FOLLOW_ident_in_intValue5814);
					id=ident();
					state._fsp--;

					 value = newBindVariables(id); 
					}
					break;
				case 4 :
					// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:925:7: QMARK
					{
					match(input,QMARK,FOLLOW_QMARK_in_intValue5825); 
					 value = newBindVariables(null); 
					}
					break;

			}
		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return value;
	}
	// $ANTLR end "intValue"



	// $ANTLR start "functionName"
	// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:928:1: functionName returns [String s] : (f= IDENT |u= unreserved_function_keyword | K_TOKEN );
	public final String functionName() throws RecognitionException {
		String s = null;


		Token f=null;
		String u =null;

		try {
			// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:929:5: (f= IDENT |u= unreserved_function_keyword | K_TOKEN )
			int alt112=3;
			switch ( input.LA(1) ) {
			case IDENT:
				{
				alt112=1;
				}
				break;
			case K_ALL:
			case K_AS:
			case K_ASCII:
			case K_BIGINT:
			case K_BLOB:
			case K_BOOLEAN:
			case K_CLUSTERING:
			case K_COMPACT:
			case K_CONTAINS:
			case K_COUNTER:
			case K_CUSTOM:
			case K_DECIMAL:
			case K_DISTINCT:
			case K_DOUBLE:
			case K_EXISTS:
			case K_FILTERING:
			case K_FLOAT:
			case K_INET:
			case K_INT:
			case K_KEYS:
			case K_KEYSPACES:
			case K_LIST:
			case K_MAP:
			case K_NOSUPERUSER:
			case K_PASSWORD:
			case K_PERMISSION:
			case K_PERMISSIONS:
			case K_STATIC:
			case K_STORAGE:
			case K_SUPERUSER:
			case K_TEXT:
			case K_TIMESTAMP:
			case K_TIMEUUID:
			case K_TRIGGER:
			case K_TYPE:
			case K_USER:
			case K_USERS:
			case K_UUID:
			case K_VALUES:
			case K_VARCHAR:
			case K_VARINT:
				{
				alt112=2;
				}
				break;
			case K_TOKEN:
				{
				alt112=3;
				}
				break;
			default:
				NoViableAltException nvae =
					new NoViableAltException("", 112, 0, input);
				throw nvae;
			}
			switch (alt112) {
				case 1 :
					// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:929:7: f= IDENT
					{
					f=(Token)match(input,IDENT,FOLLOW_IDENT_in_functionName5858); 
					 s = (f!=null?f.getText():null); 
					}
					break;
				case 2 :
					// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:930:7: u= unreserved_function_keyword
					{
					pushFollow(FOLLOW_unreserved_function_keyword_in_functionName5892);
					u=unreserved_function_keyword();
					state._fsp--;

					 s = u; 
					}
					break;
				case 3 :
					// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:931:7: K_TOKEN
					{
					match(input,K_TOKEN,FOLLOW_K_TOKEN_in_functionName5902); 
					 s = "token"; 
					}
					break;

			}
		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return s;
	}
	// $ANTLR end "functionName"



	// $ANTLR start "functionArgs"
	// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:934:1: functionArgs returns [List<Term.Raw> a] : ( '(' ')' | '(' t1= term ( ',' tn= term )* ')' );
	public final List<Term.Raw> functionArgs() throws RecognitionException {
		List<Term.Raw> a = null;


		Term.Raw t1 =null;
		Term.Raw tn =null;

		try {
			// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:935:5: ( '(' ')' | '(' t1= term ( ',' tn= term )* ')' )
			int alt114=2;
			int LA114_0 = input.LA(1);
			if ( (LA114_0==141) ) {
				int LA114_1 = input.LA(2);
				if ( (LA114_1==142) ) {
					alt114=1;
				}
				else if ( (LA114_1==BOOLEAN||LA114_1==FLOAT||LA114_1==HEXNUMBER||(LA114_1 >= IDENT && LA114_1 <= INTEGER)||LA114_1==K_ALL||LA114_1==K_AS||LA114_1==K_ASCII||(LA114_1 >= K_BIGINT && LA114_1 <= K_BOOLEAN)||LA114_1==K_CLUSTERING||(LA114_1 >= K_COMPACT && LA114_1 <= K_CONTAINS)||LA114_1==K_COUNTER||(LA114_1 >= K_CUSTOM && LA114_1 <= K_DECIMAL)||(LA114_1 >= K_DISTINCT && LA114_1 <= K_DOUBLE)||(LA114_1 >= K_EXISTS && LA114_1 <= K_FLOAT)||(LA114_1 >= K_INET && LA114_1 <= K_INFINITY)||LA114_1==K_INT||LA114_1==K_KEYS||LA114_1==K_KEYSPACES||(LA114_1 >= K_LIST && LA114_1 <= K_MAP)||LA114_1==K_NAN||LA114_1==K_NOSUPERUSER||LA114_1==K_NULL||(LA114_1 >= K_PASSWORD && LA114_1 <= K_PERMISSIONS)||(LA114_1 >= K_STATIC && LA114_1 <= K_TIMEUUID)||(LA114_1 >= K_TOKEN && LA114_1 <= K_TRIGGER)||LA114_1==K_TYPE||(LA114_1 >= K_USER && LA114_1 <= K_USERS)||(LA114_1 >= K_UUID && LA114_1 <= K_VARINT)||LA114_1==QMARK||LA114_1==STRING_LITERAL||LA114_1==UUID||LA114_1==141||LA114_1==145||LA114_1==147||LA114_1==154||LA114_1==157) ) {
					alt114=2;
				}

				else {
					int nvaeMark = input.mark();
					try {
						input.consume();
						NoViableAltException nvae =
							new NoViableAltException("", 114, 1, input);
						throw nvae;
					} finally {
						input.rewind(nvaeMark);
					}
				}

			}

			else {
				NoViableAltException nvae =
					new NoViableAltException("", 114, 0, input);
				throw nvae;
			}

			switch (alt114) {
				case 1 :
					// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:935:7: '(' ')'
					{
					match(input,141,FOLLOW_141_in_functionArgs5947); 
					match(input,142,FOLLOW_142_in_functionArgs5949); 
					 a = Collections.emptyList(); 
					}
					break;
				case 2 :
					// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:936:7: '(' t1= term ( ',' tn= term )* ')'
					{
					match(input,141,FOLLOW_141_in_functionArgs5959); 
					pushFollow(FOLLOW_term_in_functionArgs5963);
					t1=term();
					state._fsp--;

					 List<Term.Raw> args = new ArrayList<Term.Raw>(); args.add(t1); 
					// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:937:11: ( ',' tn= term )*
					loop113:
					while (true) {
						int alt113=2;
						int LA113_0 = input.LA(1);
						if ( (LA113_0==144) ) {
							alt113=1;
						}

						switch (alt113) {
						case 1 :
							// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:937:13: ',' tn= term
							{
							match(input,144,FOLLOW_144_in_functionArgs5979); 
							pushFollow(FOLLOW_term_in_functionArgs5983);
							tn=term();
							state._fsp--;

							 args.add(tn); 
							}
							break;

						default :
							break loop113;
						}
					}

					match(input,142,FOLLOW_142_in_functionArgs5997); 
					 a = args; 
					}
					break;

			}
		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return a;
	}
	// $ANTLR end "functionArgs"



	// $ANTLR start "term"
	// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:941:1: term returns [Term.Raw term] : (v= value |f= functionName args= functionArgs | '(' c= comparatorType ')' t= term );
	public final Term.Raw term() throws RecognitionException {
		Term.Raw term = null;


		Term.Raw v =null;
		String f =null;
		List<Term.Raw> args =null;
		CQL3Type.Raw c =null;
		Term.Raw t =null;

		try {
			// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:942:5: (v= value |f= functionName args= functionArgs | '(' c= comparatorType ')' t= term )
			int alt115=3;
			switch ( input.LA(1) ) {
			case BOOLEAN:
			case FLOAT:
			case HEXNUMBER:
			case INTEGER:
			case K_INFINITY:
			case K_NAN:
			case K_NULL:
			case QMARK:
			case STRING_LITERAL:
			case UUID:
			case 145:
			case 147:
			case 154:
			case 157:
				{
				alt115=1;
				}
				break;
			case 141:
				{
				switch ( input.LA(2) ) {
				case STRING_LITERAL:
					{
					int LA115_4 = input.LA(3);
					if ( (LA115_4==144) ) {
						alt115=1;
					}
					else if ( (LA115_4==142) ) {
						switch ( input.LA(4) ) {
						case EOF:
						case K_ALLOW:
						case K_AND:
						case K_APPLY:
						case K_DELETE:
						case K_IF:
						case K_INSERT:
						case K_LIMIT:
						case K_ORDER:
						case K_UPDATE:
						case K_WHERE:
						case 142:
						case 143:
						case 144:
						case 148:
						case 156:
						case 158:
							{
							alt115=1;
							}
							break;
						case 147:
							{
							switch ( input.LA(5) ) {
							case BOOLEAN:
							case FLOAT:
							case HEXNUMBER:
							case INTEGER:
							case K_INFINITY:
							case K_NAN:
							case K_NULL:
							case K_TOKEN:
							case QMARK:
							case STRING_LITERAL:
							case UUID:
							case 141:
							case 145:
							case 147:
							case 154:
							case 157:
								{
								alt115=1;
								}
								break;
							case IDENT:
								{
								int LA115_28 = input.LA(6);
								if ( (LA115_28==141) ) {
									alt115=1;
								}
								else if ( (LA115_28==EOF||LA115_28==K_ALLOW||(LA115_28 >= K_AND && LA115_28 <= K_APPLY)||LA115_28==K_DELETE||LA115_28==K_IF||LA115_28==K_INSERT||LA115_28==K_LIMIT||LA115_28==K_ORDER||LA115_28==K_UPDATE||LA115_28==K_WHERE||(LA115_28 >= 142 && LA115_28 <= 144)||(LA115_28 >= 147 && LA115_28 <= 148)||LA115_28==156||LA115_28==158) ) {
									alt115=3;
								}

								else {
									int nvaeMark = input.mark();
									try {
										for (int nvaeConsume = 0; nvaeConsume < 6 - 1; nvaeConsume++) {
											input.consume();
										}
										NoViableAltException nvae =
											new NoViableAltException("", 115, 28, input);
										throw nvae;
									} finally {
										input.rewind(nvaeMark);
									}
								}

								}
								break;
							case K_ALL:
							case K_AS:
							case K_CLUSTERING:
							case K_COMPACT:
							case K_CONTAINS:
							case K_CUSTOM:
							case K_DISTINCT:
							case K_EXISTS:
							case K_FILTERING:
							case K_KEYS:
							case K_KEYSPACES:
							case K_LIST:
							case K_MAP:
							case K_NOSUPERUSER:
							case K_PASSWORD:
							case K_PERMISSION:
							case K_PERMISSIONS:
							case K_STATIC:
							case K_STORAGE:
							case K_SUPERUSER:
							case K_TRIGGER:
							case K_TYPE:
							case K_USER:
							case K_USERS:
							case K_VALUES:
								{
								int LA115_29 = input.LA(6);
								if ( (LA115_29==141) ) {
									alt115=1;
								}
								else if ( (LA115_29==EOF||LA115_29==K_ALLOW||(LA115_29 >= K_AND && LA115_29 <= K_APPLY)||LA115_29==K_DELETE||LA115_29==K_IF||LA115_29==K_INSERT||LA115_29==K_LIMIT||LA115_29==K_ORDER||LA115_29==K_UPDATE||LA115_29==K_WHERE||(LA115_29 >= 142 && LA115_29 <= 144)||(LA115_29 >= 147 && LA115_29 <= 148)||LA115_29==156||LA115_29==158) ) {
									alt115=3;
								}

								else {
									int nvaeMark = input.mark();
									try {
										for (int nvaeConsume = 0; nvaeConsume < 6 - 1; nvaeConsume++) {
											input.consume();
										}
										NoViableAltException nvae =
											new NoViableAltException("", 115, 29, input);
										throw nvae;
									} finally {
										input.rewind(nvaeMark);
									}
								}

								}
								break;
							case K_ASCII:
								{
								int LA115_30 = input.LA(6);
								if ( (LA115_30==141) ) {
									alt115=1;
								}
								else if ( (LA115_30==EOF||LA115_30==K_ALLOW||(LA115_30 >= K_AND && LA115_30 <= K_APPLY)||LA115_30==K_DELETE||LA115_30==K_IF||LA115_30==K_INSERT||LA115_30==K_LIMIT||LA115_30==K_ORDER||LA115_30==K_UPDATE||LA115_30==K_WHERE||(LA115_30 >= 142 && LA115_30 <= 144)||(LA115_30 >= 147 && LA115_30 <= 148)||LA115_30==156||LA115_30==158) ) {
									alt115=3;
								}

								else {
									int nvaeMark = input.mark();
									try {
										for (int nvaeConsume = 0; nvaeConsume < 6 - 1; nvaeConsume++) {
											input.consume();
										}
										NoViableAltException nvae =
											new NoViableAltException("", 115, 30, input);
										throw nvae;
									} finally {
										input.rewind(nvaeMark);
									}
								}

								}
								break;
							case K_BIGINT:
								{
								int LA115_31 = input.LA(6);
								if ( (LA115_31==141) ) {
									alt115=1;
								}
								else if ( (LA115_31==EOF||LA115_31==K_ALLOW||(LA115_31 >= K_AND && LA115_31 <= K_APPLY)||LA115_31==K_DELETE||LA115_31==K_IF||LA115_31==K_INSERT||LA115_31==K_LIMIT||LA115_31==K_ORDER||LA115_31==K_UPDATE||LA115_31==K_WHERE||(LA115_31 >= 142 && LA115_31 <= 144)||(LA115_31 >= 147 && LA115_31 <= 148)||LA115_31==156||LA115_31==158) ) {
									alt115=3;
								}

								else {
									int nvaeMark = input.mark();
									try {
										for (int nvaeConsume = 0; nvaeConsume < 6 - 1; nvaeConsume++) {
											input.consume();
										}
										NoViableAltException nvae =
											new NoViableAltException("", 115, 31, input);
										throw nvae;
									} finally {
										input.rewind(nvaeMark);
									}
								}

								}
								break;
							case K_BLOB:
								{
								int LA115_32 = input.LA(6);
								if ( (LA115_32==141) ) {
									alt115=1;
								}
								else if ( (LA115_32==EOF||LA115_32==K_ALLOW||(LA115_32 >= K_AND && LA115_32 <= K_APPLY)||LA115_32==K_DELETE||LA115_32==K_IF||LA115_32==K_INSERT||LA115_32==K_LIMIT||LA115_32==K_ORDER||LA115_32==K_UPDATE||LA115_32==K_WHERE||(LA115_32 >= 142 && LA115_32 <= 144)||(LA115_32 >= 147 && LA115_32 <= 148)||LA115_32==156||LA115_32==158) ) {
									alt115=3;
								}

								else {
									int nvaeMark = input.mark();
									try {
										for (int nvaeConsume = 0; nvaeConsume < 6 - 1; nvaeConsume++) {
											input.consume();
										}
										NoViableAltException nvae =
											new NoViableAltException("", 115, 32, input);
										throw nvae;
									} finally {
										input.rewind(nvaeMark);
									}
								}

								}
								break;
							case K_BOOLEAN:
								{
								int LA115_33 = input.LA(6);
								if ( (LA115_33==141) ) {
									alt115=1;
								}
								else if ( (LA115_33==EOF||LA115_33==K_ALLOW||(LA115_33 >= K_AND && LA115_33 <= K_APPLY)||LA115_33==K_DELETE||LA115_33==K_IF||LA115_33==K_INSERT||LA115_33==K_LIMIT||LA115_33==K_ORDER||LA115_33==K_UPDATE||LA115_33==K_WHERE||(LA115_33 >= 142 && LA115_33 <= 144)||(LA115_33 >= 147 && LA115_33 <= 148)||LA115_33==156||LA115_33==158) ) {
									alt115=3;
								}

								else {
									int nvaeMark = input.mark();
									try {
										for (int nvaeConsume = 0; nvaeConsume < 6 - 1; nvaeConsume++) {
											input.consume();
										}
										NoViableAltException nvae =
											new NoViableAltException("", 115, 33, input);
										throw nvae;
									} finally {
										input.rewind(nvaeMark);
									}
								}

								}
								break;
							case K_COUNTER:
								{
								int LA115_34 = input.LA(6);
								if ( (LA115_34==141) ) {
									alt115=1;
								}
								else if ( (LA115_34==EOF||LA115_34==K_ALLOW||(LA115_34 >= K_AND && LA115_34 <= K_APPLY)||LA115_34==K_DELETE||LA115_34==K_IF||LA115_34==K_INSERT||LA115_34==K_LIMIT||LA115_34==K_ORDER||LA115_34==K_UPDATE||LA115_34==K_WHERE||(LA115_34 >= 142 && LA115_34 <= 144)||(LA115_34 >= 147 && LA115_34 <= 148)||LA115_34==156||LA115_34==158) ) {
									alt115=3;
								}

								else {
									int nvaeMark = input.mark();
									try {
										for (int nvaeConsume = 0; nvaeConsume < 6 - 1; nvaeConsume++) {
											input.consume();
										}
										NoViableAltException nvae =
											new NoViableAltException("", 115, 34, input);
										throw nvae;
									} finally {
										input.rewind(nvaeMark);
									}
								}

								}
								break;
							case K_DECIMAL:
								{
								int LA115_35 = input.LA(6);
								if ( (LA115_35==141) ) {
									alt115=1;
								}
								else if ( (LA115_35==EOF||LA115_35==K_ALLOW||(LA115_35 >= K_AND && LA115_35 <= K_APPLY)||LA115_35==K_DELETE||LA115_35==K_IF||LA115_35==K_INSERT||LA115_35==K_LIMIT||LA115_35==K_ORDER||LA115_35==K_UPDATE||LA115_35==K_WHERE||(LA115_35 >= 142 && LA115_35 <= 144)||(LA115_35 >= 147 && LA115_35 <= 148)||LA115_35==156||LA115_35==158) ) {
									alt115=3;
								}

								else {
									int nvaeMark = input.mark();
									try {
										for (int nvaeConsume = 0; nvaeConsume < 6 - 1; nvaeConsume++) {
											input.consume();
										}
										NoViableAltException nvae =
											new NoViableAltException("", 115, 35, input);
										throw nvae;
									} finally {
										input.rewind(nvaeMark);
									}
								}

								}
								break;
							case K_DOUBLE:
								{
								int LA115_36 = input.LA(6);
								if ( (LA115_36==141) ) {
									alt115=1;
								}
								else if ( (LA115_36==EOF||LA115_36==K_ALLOW||(LA115_36 >= K_AND && LA115_36 <= K_APPLY)||LA115_36==K_DELETE||LA115_36==K_IF||LA115_36==K_INSERT||LA115_36==K_LIMIT||LA115_36==K_ORDER||LA115_36==K_UPDATE||LA115_36==K_WHERE||(LA115_36 >= 142 && LA115_36 <= 144)||(LA115_36 >= 147 && LA115_36 <= 148)||LA115_36==156||LA115_36==158) ) {
									alt115=3;
								}

								else {
									int nvaeMark = input.mark();
									try {
										for (int nvaeConsume = 0; nvaeConsume < 6 - 1; nvaeConsume++) {
											input.consume();
										}
										NoViableAltException nvae =
											new NoViableAltException("", 115, 36, input);
										throw nvae;
									} finally {
										input.rewind(nvaeMark);
									}
								}

								}
								break;
							case K_FLOAT:
								{
								int LA115_37 = input.LA(6);
								if ( (LA115_37==141) ) {
									alt115=1;
								}
								else if ( (LA115_37==EOF||LA115_37==K_ALLOW||(LA115_37 >= K_AND && LA115_37 <= K_APPLY)||LA115_37==K_DELETE||LA115_37==K_IF||LA115_37==K_INSERT||LA115_37==K_LIMIT||LA115_37==K_ORDER||LA115_37==K_UPDATE||LA115_37==K_WHERE||(LA115_37 >= 142 && LA115_37 <= 144)||(LA115_37 >= 147 && LA115_37 <= 148)||LA115_37==156||LA115_37==158) ) {
									alt115=3;
								}

								else {
									int nvaeMark = input.mark();
									try {
										for (int nvaeConsume = 0; nvaeConsume < 6 - 1; nvaeConsume++) {
											input.consume();
										}
										NoViableAltException nvae =
											new NoViableAltException("", 115, 37, input);
										throw nvae;
									} finally {
										input.rewind(nvaeMark);
									}
								}

								}
								break;
							case K_INET:
								{
								int LA115_38 = input.LA(6);
								if ( (LA115_38==141) ) {
									alt115=1;
								}
								else if ( (LA115_38==EOF||LA115_38==K_ALLOW||(LA115_38 >= K_AND && LA115_38 <= K_APPLY)||LA115_38==K_DELETE||LA115_38==K_IF||LA115_38==K_INSERT||LA115_38==K_LIMIT||LA115_38==K_ORDER||LA115_38==K_UPDATE||LA115_38==K_WHERE||(LA115_38 >= 142 && LA115_38 <= 144)||(LA115_38 >= 147 && LA115_38 <= 148)||LA115_38==156||LA115_38==158) ) {
									alt115=3;
								}

								else {
									int nvaeMark = input.mark();
									try {
										for (int nvaeConsume = 0; nvaeConsume < 6 - 1; nvaeConsume++) {
											input.consume();
										}
										NoViableAltException nvae =
											new NoViableAltException("", 115, 38, input);
										throw nvae;
									} finally {
										input.rewind(nvaeMark);
									}
								}

								}
								break;
							case K_INT:
								{
								int LA115_39 = input.LA(6);
								if ( (LA115_39==141) ) {
									alt115=1;
								}
								else if ( (LA115_39==EOF||LA115_39==K_ALLOW||(LA115_39 >= K_AND && LA115_39 <= K_APPLY)||LA115_39==K_DELETE||LA115_39==K_IF||LA115_39==K_INSERT||LA115_39==K_LIMIT||LA115_39==K_ORDER||LA115_39==K_UPDATE||LA115_39==K_WHERE||(LA115_39 >= 142 && LA115_39 <= 144)||(LA115_39 >= 147 && LA115_39 <= 148)||LA115_39==156||LA115_39==158) ) {
									alt115=3;
								}

								else {
									int nvaeMark = input.mark();
									try {
										for (int nvaeConsume = 0; nvaeConsume < 6 - 1; nvaeConsume++) {
											input.consume();
										}
										NoViableAltException nvae =
											new NoViableAltException("", 115, 39, input);
										throw nvae;
									} finally {
										input.rewind(nvaeMark);
									}
								}

								}
								break;
							case K_TEXT:
								{
								int LA115_40 = input.LA(6);
								if ( (LA115_40==141) ) {
									alt115=1;
								}
								else if ( (LA115_40==EOF||LA115_40==K_ALLOW||(LA115_40 >= K_AND && LA115_40 <= K_APPLY)||LA115_40==K_DELETE||LA115_40==K_IF||LA115_40==K_INSERT||LA115_40==K_LIMIT||LA115_40==K_ORDER||LA115_40==K_UPDATE||LA115_40==K_WHERE||(LA115_40 >= 142 && LA115_40 <= 144)||(LA115_40 >= 147 && LA115_40 <= 148)||LA115_40==156||LA115_40==158) ) {
									alt115=3;
								}

								else {
									int nvaeMark = input.mark();
									try {
										for (int nvaeConsume = 0; nvaeConsume < 6 - 1; nvaeConsume++) {
											input.consume();
										}
										NoViableAltException nvae =
											new NoViableAltException("", 115, 40, input);
										throw nvae;
									} finally {
										input.rewind(nvaeMark);
									}
								}

								}
								break;
							case K_TIMESTAMP:
								{
								int LA115_41 = input.LA(6);
								if ( (LA115_41==141) ) {
									alt115=1;
								}
								else if ( (LA115_41==EOF||LA115_41==K_ALLOW||(LA115_41 >= K_AND && LA115_41 <= K_APPLY)||LA115_41==K_DELETE||LA115_41==K_IF||LA115_41==K_INSERT||LA115_41==K_LIMIT||LA115_41==K_ORDER||LA115_41==K_UPDATE||LA115_41==K_WHERE||(LA115_41 >= 142 && LA115_41 <= 144)||(LA115_41 >= 147 && LA115_41 <= 148)||LA115_41==156||LA115_41==158) ) {
									alt115=3;
								}

								else {
									int nvaeMark = input.mark();
									try {
										for (int nvaeConsume = 0; nvaeConsume < 6 - 1; nvaeConsume++) {
											input.consume();
										}
										NoViableAltException nvae =
											new NoViableAltException("", 115, 41, input);
										throw nvae;
									} finally {
										input.rewind(nvaeMark);
									}
								}

								}
								break;
							case K_UUID:
								{
								int LA115_42 = input.LA(6);
								if ( (LA115_42==141) ) {
									alt115=1;
								}
								else if ( (LA115_42==EOF||LA115_42==K_ALLOW||(LA115_42 >= K_AND && LA115_42 <= K_APPLY)||LA115_42==K_DELETE||LA115_42==K_IF||LA115_42==K_INSERT||LA115_42==K_LIMIT||LA115_42==K_ORDER||LA115_42==K_UPDATE||LA115_42==K_WHERE||(LA115_42 >= 142 && LA115_42 <= 144)||(LA115_42 >= 147 && LA115_42 <= 148)||LA115_42==156||LA115_42==158) ) {
									alt115=3;
								}

								else {
									int nvaeMark = input.mark();
									try {
										for (int nvaeConsume = 0; nvaeConsume < 6 - 1; nvaeConsume++) {
											input.consume();
										}
										NoViableAltException nvae =
											new NoViableAltException("", 115, 42, input);
										throw nvae;
									} finally {
										input.rewind(nvaeMark);
									}
								}

								}
								break;
							case K_VARCHAR:
								{
								int LA115_43 = input.LA(6);
								if ( (LA115_43==141) ) {
									alt115=1;
								}
								else if ( (LA115_43==EOF||LA115_43==K_ALLOW||(LA115_43 >= K_AND && LA115_43 <= K_APPLY)||LA115_43==K_DELETE||LA115_43==K_IF||LA115_43==K_INSERT||LA115_43==K_LIMIT||LA115_43==K_ORDER||LA115_43==K_UPDATE||LA115_43==K_WHERE||(LA115_43 >= 142 && LA115_43 <= 144)||(LA115_43 >= 147 && LA115_43 <= 148)||LA115_43==156||LA115_43==158) ) {
									alt115=3;
								}

								else {
									int nvaeMark = input.mark();
									try {
										for (int nvaeConsume = 0; nvaeConsume < 6 - 1; nvaeConsume++) {
											input.consume();
										}
										NoViableAltException nvae =
											new NoViableAltException("", 115, 43, input);
										throw nvae;
									} finally {
										input.rewind(nvaeMark);
									}
								}

								}
								break;
							case K_VARINT:
								{
								int LA115_44 = input.LA(6);
								if ( (LA115_44==141) ) {
									alt115=1;
								}
								else if ( (LA115_44==EOF||LA115_44==K_ALLOW||(LA115_44 >= K_AND && LA115_44 <= K_APPLY)||LA115_44==K_DELETE||LA115_44==K_IF||LA115_44==K_INSERT||LA115_44==K_LIMIT||LA115_44==K_ORDER||LA115_44==K_UPDATE||LA115_44==K_WHERE||(LA115_44 >= 142 && LA115_44 <= 144)||(LA115_44 >= 147 && LA115_44 <= 148)||LA115_44==156||LA115_44==158) ) {
									alt115=3;
								}

								else {
									int nvaeMark = input.mark();
									try {
										for (int nvaeConsume = 0; nvaeConsume < 6 - 1; nvaeConsume++) {
											input.consume();
										}
										NoViableAltException nvae =
											new NoViableAltException("", 115, 44, input);
										throw nvae;
									} finally {
										input.rewind(nvaeMark);
									}
								}

								}
								break;
							case K_TIMEUUID:
								{
								int LA115_45 = input.LA(6);
								if ( (LA115_45==141) ) {
									alt115=1;
								}
								else if ( (LA115_45==EOF||LA115_45==K_ALLOW||(LA115_45 >= K_AND && LA115_45 <= K_APPLY)||LA115_45==K_DELETE||LA115_45==K_IF||LA115_45==K_INSERT||LA115_45==K_LIMIT||LA115_45==K_ORDER||LA115_45==K_UPDATE||LA115_45==K_WHERE||(LA115_45 >= 142 && LA115_45 <= 144)||(LA115_45 >= 147 && LA115_45 <= 148)||LA115_45==156||LA115_45==158) ) {
									alt115=3;
								}

								else {
									int nvaeMark = input.mark();
									try {
										for (int nvaeConsume = 0; nvaeConsume < 6 - 1; nvaeConsume++) {
											input.consume();
										}
										NoViableAltException nvae =
											new NoViableAltException("", 115, 45, input);
										throw nvae;
									} finally {
										input.rewind(nvaeMark);
									}
								}

								}
								break;
							case K_COUNT:
							case K_KEY:
							case K_TTL:
							case K_WRITETIME:
							case QUOTED_NAME:
								{
								alt115=3;
								}
								break;
							default:
								int nvaeMark = input.mark();
								try {
									for (int nvaeConsume = 0; nvaeConsume < 5 - 1; nvaeConsume++) {
										input.consume();
									}
									NoViableAltException nvae =
										new NoViableAltException("", 115, 27, input);
									throw nvae;
								} finally {
									input.rewind(nvaeMark);
								}
							}
							}
							break;
						case BOOLEAN:
						case FLOAT:
						case HEXNUMBER:
						case IDENT:
						case INTEGER:
						case K_ALL:
						case K_AS:
						case K_ASCII:
						case K_BIGINT:
						case K_BLOB:
						case K_BOOLEAN:
						case K_CLUSTERING:
						case K_COMPACT:
						case K_CONTAINS:
						case K_COUNTER:
						case K_CUSTOM:
						case K_DECIMAL:
						case K_DISTINCT:
						case K_DOUBLE:
						case K_EXISTS:
						case K_FILTERING:
						case K_FLOAT:
						case K_INET:
						case K_INFINITY:
						case K_INT:
						case K_KEYS:
						case K_KEYSPACES:
						case K_LIST:
						case K_MAP:
						case K_NAN:
						case K_NOSUPERUSER:
						case K_NULL:
						case K_PASSWORD:
						case K_PERMISSION:
						case K_PERMISSIONS:
						case K_STATIC:
						case K_STORAGE:
						case K_SUPERUSER:
						case K_TEXT:
						case K_TIMESTAMP:
						case K_TIMEUUID:
						case K_TOKEN:
						case K_TRIGGER:
						case K_TYPE:
						case K_USER:
						case K_USERS:
						case K_UUID:
						case K_VALUES:
						case K_VARCHAR:
						case K_VARINT:
						case QMARK:
						case STRING_LITERAL:
						case UUID:
						case 141:
						case 145:
						case 154:
						case 157:
							{
							alt115=3;
							}
							break;
						default:
							int nvaeMark = input.mark();
							try {
								for (int nvaeConsume = 0; nvaeConsume < 4 - 1; nvaeConsume++) {
									input.consume();
								}
								NoViableAltException nvae =
									new NoViableAltException("", 115, 26, input);
								throw nvae;
							} finally {
								input.rewind(nvaeMark);
							}
						}
					}

					else {
						int nvaeMark = input.mark();
						try {
							for (int nvaeConsume = 0; nvaeConsume < 3 - 1; nvaeConsume++) {
								input.consume();
							}
							NoViableAltException nvae =
								new NoViableAltException("", 115, 4, input);
							throw nvae;
						} finally {
							input.rewind(nvaeMark);
						}
					}

					}
					break;
				case BOOLEAN:
				case FLOAT:
				case HEXNUMBER:
				case INTEGER:
				case K_INFINITY:
				case K_NAN:
				case K_NULL:
				case K_TOKEN:
				case QMARK:
				case UUID:
				case 141:
				case 145:
				case 147:
				case 154:
				case 157:
					{
					alt115=1;
					}
					break;
				case IDENT:
					{
					int LA115_5 = input.LA(3);
					if ( (LA115_5==141) ) {
						alt115=1;
					}
					else if ( (LA115_5==142||LA115_5==146) ) {
						alt115=3;
					}

					else {
						int nvaeMark = input.mark();
						try {
							for (int nvaeConsume = 0; nvaeConsume < 3 - 1; nvaeConsume++) {
								input.consume();
							}
							NoViableAltException nvae =
								new NoViableAltException("", 115, 5, input);
							throw nvae;
						} finally {
							input.rewind(nvaeMark);
						}
					}

					}
					break;
				case K_MAP:
					{
					int LA115_6 = input.LA(3);
					if ( (LA115_6==142||LA115_6==146||LA115_6==149) ) {
						alt115=3;
					}
					else if ( (LA115_6==141) ) {
						alt115=1;
					}

					else {
						int nvaeMark = input.mark();
						try {
							for (int nvaeConsume = 0; nvaeConsume < 3 - 1; nvaeConsume++) {
								input.consume();
							}
							NoViableAltException nvae =
								new NoViableAltException("", 115, 6, input);
							throw nvae;
						} finally {
							input.rewind(nvaeMark);
						}
					}

					}
					break;
				case K_ASCII:
					{
					int LA115_7 = input.LA(3);
					if ( (LA115_7==141) ) {
						alt115=1;
					}
					else if ( (LA115_7==142||LA115_7==146) ) {
						alt115=3;
					}

					else {
						int nvaeMark = input.mark();
						try {
							for (int nvaeConsume = 0; nvaeConsume < 3 - 1; nvaeConsume++) {
								input.consume();
							}
							NoViableAltException nvae =
								new NoViableAltException("", 115, 7, input);
							throw nvae;
						} finally {
							input.rewind(nvaeMark);
						}
					}

					}
					break;
				case K_BIGINT:
					{
					int LA115_8 = input.LA(3);
					if ( (LA115_8==141) ) {
						alt115=1;
					}
					else if ( (LA115_8==142||LA115_8==146) ) {
						alt115=3;
					}

					else {
						int nvaeMark = input.mark();
						try {
							for (int nvaeConsume = 0; nvaeConsume < 3 - 1; nvaeConsume++) {
								input.consume();
							}
							NoViableAltException nvae =
								new NoViableAltException("", 115, 8, input);
							throw nvae;
						} finally {
							input.rewind(nvaeMark);
						}
					}

					}
					break;
				case K_BLOB:
					{
					int LA115_9 = input.LA(3);
					if ( (LA115_9==141) ) {
						alt115=1;
					}
					else if ( (LA115_9==142||LA115_9==146) ) {
						alt115=3;
					}

					else {
						int nvaeMark = input.mark();
						try {
							for (int nvaeConsume = 0; nvaeConsume < 3 - 1; nvaeConsume++) {
								input.consume();
							}
							NoViableAltException nvae =
								new NoViableAltException("", 115, 9, input);
							throw nvae;
						} finally {
							input.rewind(nvaeMark);
						}
					}

					}
					break;
				case K_BOOLEAN:
					{
					int LA115_10 = input.LA(3);
					if ( (LA115_10==141) ) {
						alt115=1;
					}
					else if ( (LA115_10==142||LA115_10==146) ) {
						alt115=3;
					}

					else {
						int nvaeMark = input.mark();
						try {
							for (int nvaeConsume = 0; nvaeConsume < 3 - 1; nvaeConsume++) {
								input.consume();
							}
							NoViableAltException nvae =
								new NoViableAltException("", 115, 10, input);
							throw nvae;
						} finally {
							input.rewind(nvaeMark);
						}
					}

					}
					break;
				case K_COUNTER:
					{
					int LA115_11 = input.LA(3);
					if ( (LA115_11==141) ) {
						alt115=1;
					}
					else if ( (LA115_11==142||LA115_11==146) ) {
						alt115=3;
					}

					else {
						int nvaeMark = input.mark();
						try {
							for (int nvaeConsume = 0; nvaeConsume < 3 - 1; nvaeConsume++) {
								input.consume();
							}
							NoViableAltException nvae =
								new NoViableAltException("", 115, 11, input);
							throw nvae;
						} finally {
							input.rewind(nvaeMark);
						}
					}

					}
					break;
				case K_DECIMAL:
					{
					int LA115_12 = input.LA(3);
					if ( (LA115_12==141) ) {
						alt115=1;
					}
					else if ( (LA115_12==142||LA115_12==146) ) {
						alt115=3;
					}

					else {
						int nvaeMark = input.mark();
						try {
							for (int nvaeConsume = 0; nvaeConsume < 3 - 1; nvaeConsume++) {
								input.consume();
							}
							NoViableAltException nvae =
								new NoViableAltException("", 115, 12, input);
							throw nvae;
						} finally {
							input.rewind(nvaeMark);
						}
					}

					}
					break;
				case K_DOUBLE:
					{
					int LA115_13 = input.LA(3);
					if ( (LA115_13==141) ) {
						alt115=1;
					}
					else if ( (LA115_13==142||LA115_13==146) ) {
						alt115=3;
					}

					else {
						int nvaeMark = input.mark();
						try {
							for (int nvaeConsume = 0; nvaeConsume < 3 - 1; nvaeConsume++) {
								input.consume();
							}
							NoViableAltException nvae =
								new NoViableAltException("", 115, 13, input);
							throw nvae;
						} finally {
							input.rewind(nvaeMark);
						}
					}

					}
					break;
				case K_FLOAT:
					{
					int LA115_14 = input.LA(3);
					if ( (LA115_14==141) ) {
						alt115=1;
					}
					else if ( (LA115_14==142||LA115_14==146) ) {
						alt115=3;
					}

					else {
						int nvaeMark = input.mark();
						try {
							for (int nvaeConsume = 0; nvaeConsume < 3 - 1; nvaeConsume++) {
								input.consume();
							}
							NoViableAltException nvae =
								new NoViableAltException("", 115, 14, input);
							throw nvae;
						} finally {
							input.rewind(nvaeMark);
						}
					}

					}
					break;
				case K_INET:
					{
					int LA115_15 = input.LA(3);
					if ( (LA115_15==141) ) {
						alt115=1;
					}
					else if ( (LA115_15==142||LA115_15==146) ) {
						alt115=3;
					}

					else {
						int nvaeMark = input.mark();
						try {
							for (int nvaeConsume = 0; nvaeConsume < 3 - 1; nvaeConsume++) {
								input.consume();
							}
							NoViableAltException nvae =
								new NoViableAltException("", 115, 15, input);
							throw nvae;
						} finally {
							input.rewind(nvaeMark);
						}
					}

					}
					break;
				case K_INT:
					{
					int LA115_16 = input.LA(3);
					if ( (LA115_16==141) ) {
						alt115=1;
					}
					else if ( (LA115_16==142||LA115_16==146) ) {
						alt115=3;
					}

					else {
						int nvaeMark = input.mark();
						try {
							for (int nvaeConsume = 0; nvaeConsume < 3 - 1; nvaeConsume++) {
								input.consume();
							}
							NoViableAltException nvae =
								new NoViableAltException("", 115, 16, input);
							throw nvae;
						} finally {
							input.rewind(nvaeMark);
						}
					}

					}
					break;
				case K_TEXT:
					{
					int LA115_17 = input.LA(3);
					if ( (LA115_17==141) ) {
						alt115=1;
					}
					else if ( (LA115_17==142||LA115_17==146) ) {
						alt115=3;
					}

					else {
						int nvaeMark = input.mark();
						try {
							for (int nvaeConsume = 0; nvaeConsume < 3 - 1; nvaeConsume++) {
								input.consume();
							}
							NoViableAltException nvae =
								new NoViableAltException("", 115, 17, input);
							throw nvae;
						} finally {
							input.rewind(nvaeMark);
						}
					}

					}
					break;
				case K_TIMESTAMP:
					{
					int LA115_18 = input.LA(3);
					if ( (LA115_18==141) ) {
						alt115=1;
					}
					else if ( (LA115_18==142||LA115_18==146) ) {
						alt115=3;
					}

					else {
						int nvaeMark = input.mark();
						try {
							for (int nvaeConsume = 0; nvaeConsume < 3 - 1; nvaeConsume++) {
								input.consume();
							}
							NoViableAltException nvae =
								new NoViableAltException("", 115, 18, input);
							throw nvae;
						} finally {
							input.rewind(nvaeMark);
						}
					}

					}
					break;
				case K_UUID:
					{
					int LA115_19 = input.LA(3);
					if ( (LA115_19==141) ) {
						alt115=1;
					}
					else if ( (LA115_19==142||LA115_19==146) ) {
						alt115=3;
					}

					else {
						int nvaeMark = input.mark();
						try {
							for (int nvaeConsume = 0; nvaeConsume < 3 - 1; nvaeConsume++) {
								input.consume();
							}
							NoViableAltException nvae =
								new NoViableAltException("", 115, 19, input);
							throw nvae;
						} finally {
							input.rewind(nvaeMark);
						}
					}

					}
					break;
				case K_VARCHAR:
					{
					int LA115_20 = input.LA(3);
					if ( (LA115_20==141) ) {
						alt115=1;
					}
					else if ( (LA115_20==142||LA115_20==146) ) {
						alt115=3;
					}

					else {
						int nvaeMark = input.mark();
						try {
							for (int nvaeConsume = 0; nvaeConsume < 3 - 1; nvaeConsume++) {
								input.consume();
							}
							NoViableAltException nvae =
								new NoViableAltException("", 115, 20, input);
							throw nvae;
						} finally {
							input.rewind(nvaeMark);
						}
					}

					}
					break;
				case K_VARINT:
					{
					int LA115_21 = input.LA(3);
					if ( (LA115_21==141) ) {
						alt115=1;
					}
					else if ( (LA115_21==142||LA115_21==146) ) {
						alt115=3;
					}

					else {
						int nvaeMark = input.mark();
						try {
							for (int nvaeConsume = 0; nvaeConsume < 3 - 1; nvaeConsume++) {
								input.consume();
							}
							NoViableAltException nvae =
								new NoViableAltException("", 115, 21, input);
							throw nvae;
						} finally {
							input.rewind(nvaeMark);
						}
					}

					}
					break;
				case K_TIMEUUID:
					{
					int LA115_22 = input.LA(3);
					if ( (LA115_22==141) ) {
						alt115=1;
					}
					else if ( (LA115_22==142||LA115_22==146) ) {
						alt115=3;
					}

					else {
						int nvaeMark = input.mark();
						try {
							for (int nvaeConsume = 0; nvaeConsume < 3 - 1; nvaeConsume++) {
								input.consume();
							}
							NoViableAltException nvae =
								new NoViableAltException("", 115, 22, input);
							throw nvae;
						} finally {
							input.rewind(nvaeMark);
						}
					}

					}
					break;
				case K_LIST:
					{
					int LA115_23 = input.LA(3);
					if ( (LA115_23==142||LA115_23==146||LA115_23==149) ) {
						alt115=3;
					}
					else if ( (LA115_23==141) ) {
						alt115=1;
					}

					else {
						int nvaeMark = input.mark();
						try {
							for (int nvaeConsume = 0; nvaeConsume < 3 - 1; nvaeConsume++) {
								input.consume();
							}
							NoViableAltException nvae =
								new NoViableAltException("", 115, 23, input);
							throw nvae;
						} finally {
							input.rewind(nvaeMark);
						}
					}

					}
					break;
				case K_ALL:
				case K_AS:
				case K_CLUSTERING:
				case K_COMPACT:
				case K_CONTAINS:
				case K_CUSTOM:
				case K_DISTINCT:
				case K_EXISTS:
				case K_FILTERING:
				case K_KEYS:
				case K_KEYSPACES:
				case K_NOSUPERUSER:
				case K_PASSWORD:
				case K_PERMISSION:
				case K_PERMISSIONS:
				case K_STATIC:
				case K_STORAGE:
				case K_SUPERUSER:
				case K_TRIGGER:
				case K_TYPE:
				case K_USER:
				case K_USERS:
				case K_VALUES:
					{
					int LA115_24 = input.LA(3);
					if ( (LA115_24==141) ) {
						alt115=1;
					}
					else if ( (LA115_24==142||LA115_24==146) ) {
						alt115=3;
					}

					else {
						int nvaeMark = input.mark();
						try {
							for (int nvaeConsume = 0; nvaeConsume < 3 - 1; nvaeConsume++) {
								input.consume();
							}
							NoViableAltException nvae =
								new NoViableAltException("", 115, 24, input);
							throw nvae;
						} finally {
							input.rewind(nvaeMark);
						}
					}

					}
					break;
				case K_COUNT:
				case K_FROZEN:
				case K_KEY:
				case K_SET:
				case K_TTL:
				case K_TUPLE:
				case K_WRITETIME:
				case QUOTED_NAME:
					{
					alt115=3;
					}
					break;
				default:
					int nvaeMark = input.mark();
					try {
						input.consume();
						NoViableAltException nvae =
							new NoViableAltException("", 115, 2, input);
						throw nvae;
					} finally {
						input.rewind(nvaeMark);
					}
				}
				}
				break;
			case IDENT:
			case K_ALL:
			case K_AS:
			case K_ASCII:
			case K_BIGINT:
			case K_BLOB:
			case K_BOOLEAN:
			case K_CLUSTERING:
			case K_COMPACT:
			case K_CONTAINS:
			case K_COUNTER:
			case K_CUSTOM:
			case K_DECIMAL:
			case K_DISTINCT:
			case K_DOUBLE:
			case K_EXISTS:
			case K_FILTERING:
			case K_FLOAT:
			case K_INET:
			case K_INT:
			case K_KEYS:
			case K_KEYSPACES:
			case K_LIST:
			case K_MAP:
			case K_NOSUPERUSER:
			case K_PASSWORD:
			case K_PERMISSION:
			case K_PERMISSIONS:
			case K_STATIC:
			case K_STORAGE:
			case K_SUPERUSER:
			case K_TEXT:
			case K_TIMESTAMP:
			case K_TIMEUUID:
			case K_TOKEN:
			case K_TRIGGER:
			case K_TYPE:
			case K_USER:
			case K_USERS:
			case K_UUID:
			case K_VALUES:
			case K_VARCHAR:
			case K_VARINT:
				{
				alt115=2;
				}
				break;
			default:
				NoViableAltException nvae =
					new NoViableAltException("", 115, 0, input);
				throw nvae;
			}
			switch (alt115) {
				case 1 :
					// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:942:7: v= value
					{
					pushFollow(FOLLOW_value_in_term6022);
					v=value();
					state._fsp--;

					 term = v; 
					}
					break;
				case 2 :
					// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:943:7: f= functionName args= functionArgs
					{
					pushFollow(FOLLOW_functionName_in_term6059);
					f=functionName();
					state._fsp--;

					pushFollow(FOLLOW_functionArgs_in_term6063);
					args=functionArgs();
					state._fsp--;

					 term = new FunctionCall.Raw(f, args); 
					}
					break;
				case 3 :
					// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:944:7: '(' c= comparatorType ')' t= term
					{
					match(input,141,FOLLOW_141_in_term6073); 
					pushFollow(FOLLOW_comparatorType_in_term6077);
					c=comparatorType();
					state._fsp--;

					match(input,142,FOLLOW_142_in_term6079); 
					pushFollow(FOLLOW_term_in_term6083);
					t=term();
					state._fsp--;

					 term = new TypeCast(c, t); 
					}
					break;

			}
		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return term;
	}
	// $ANTLR end "term"



	// $ANTLR start "columnOperation"
	// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:947:1: columnOperation[List<Pair<ColumnIdentifier.Raw, Operation.RawUpdate>> operations] : key= cident columnOperationDifferentiator[operations, key] ;
	public final void columnOperation(List<Pair<ColumnIdentifier.Raw, Operation.RawUpdate>> operations) throws RecognitionException {
		ColumnIdentifier.Raw key =null;

		try {
			// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:948:5: (key= cident columnOperationDifferentiator[operations, key] )
			// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:948:7: key= cident columnOperationDifferentiator[operations, key]
			{
			pushFollow(FOLLOW_cident_in_columnOperation6106);
			key=cident();
			state._fsp--;

			pushFollow(FOLLOW_columnOperationDifferentiator_in_columnOperation6108);
			columnOperationDifferentiator(operations, key);
			state._fsp--;

			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "columnOperation"



	// $ANTLR start "columnOperationDifferentiator"
	// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:951:1: columnOperationDifferentiator[List<Pair<ColumnIdentifier.Raw, Operation.RawUpdate>> operations, ColumnIdentifier.Raw key] : ( '=' normalColumnOperation[operations, key] | '[' k= term ']' specializedColumnOperation[operations, key, k] );
	public final void columnOperationDifferentiator(List<Pair<ColumnIdentifier.Raw, Operation.RawUpdate>> operations, ColumnIdentifier.Raw key) throws RecognitionException {
		Term.Raw k =null;

		try {
			// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:952:5: ( '=' normalColumnOperation[operations, key] | '[' k= term ']' specializedColumnOperation[operations, key, k] )
			int alt116=2;
			int LA116_0 = input.LA(1);
			if ( (LA116_0==151) ) {
				alt116=1;
			}
			else if ( (LA116_0==154) ) {
				alt116=2;
			}

			else {
				NoViableAltException nvae =
					new NoViableAltException("", 116, 0, input);
				throw nvae;
			}

			switch (alt116) {
				case 1 :
					// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:952:7: '=' normalColumnOperation[operations, key]
					{
					match(input,151,FOLLOW_151_in_columnOperationDifferentiator6127); 
					pushFollow(FOLLOW_normalColumnOperation_in_columnOperationDifferentiator6129);
					normalColumnOperation(operations, key);
					state._fsp--;

					}
					break;
				case 2 :
					// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:953:7: '[' k= term ']' specializedColumnOperation[operations, key, k]
					{
					match(input,154,FOLLOW_154_in_columnOperationDifferentiator6138); 
					pushFollow(FOLLOW_term_in_columnOperationDifferentiator6142);
					k=term();
					state._fsp--;

					match(input,156,FOLLOW_156_in_columnOperationDifferentiator6144); 
					pushFollow(FOLLOW_specializedColumnOperation_in_columnOperationDifferentiator6146);
					specializedColumnOperation(operations, key, k);
					state._fsp--;

					}
					break;

			}
		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "columnOperationDifferentiator"



	// $ANTLR start "normalColumnOperation"
	// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:956:1: normalColumnOperation[List<Pair<ColumnIdentifier.Raw, Operation.RawUpdate>> operations, ColumnIdentifier.Raw key] : (t= term ( '+' c= cident )? |c= cident sig= ( '+' | '-' ) t= term |c= cident i= INTEGER );
	public final void normalColumnOperation(List<Pair<ColumnIdentifier.Raw, Operation.RawUpdate>> operations, ColumnIdentifier.Raw key) throws RecognitionException {
		Token sig=null;
		Token i=null;
		Term.Raw t =null;
		ColumnIdentifier.Raw c =null;

		try {
			// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:957:5: (t= term ( '+' c= cident )? |c= cident sig= ( '+' | '-' ) t= term |c= cident i= INTEGER )
			int alt118=3;
			switch ( input.LA(1) ) {
			case BOOLEAN:
			case FLOAT:
			case HEXNUMBER:
			case INTEGER:
			case K_INFINITY:
			case K_NAN:
			case K_NULL:
			case K_TOKEN:
			case QMARK:
			case STRING_LITERAL:
			case UUID:
			case 141:
			case 145:
			case 147:
			case 154:
			case 157:
				{
				alt118=1;
				}
				break;
			case IDENT:
				{
				switch ( input.LA(2) ) {
				case 141:
					{
					alt118=1;
					}
					break;
				case 143:
				case 145:
					{
					alt118=2;
					}
					break;
				case INTEGER:
					{
					alt118=3;
					}
					break;
				default:
					int nvaeMark = input.mark();
					try {
						input.consume();
						NoViableAltException nvae =
							new NoViableAltException("", 118, 2, input);
						throw nvae;
					} finally {
						input.rewind(nvaeMark);
					}
				}
				}
				break;
			case K_ALL:
			case K_AS:
			case K_CLUSTERING:
			case K_COMPACT:
			case K_CONTAINS:
			case K_CUSTOM:
			case K_DISTINCT:
			case K_EXISTS:
			case K_FILTERING:
			case K_KEYS:
			case K_KEYSPACES:
			case K_LIST:
			case K_MAP:
			case K_NOSUPERUSER:
			case K_PASSWORD:
			case K_PERMISSION:
			case K_PERMISSIONS:
			case K_STATIC:
			case K_STORAGE:
			case K_SUPERUSER:
			case K_TRIGGER:
			case K_TYPE:
			case K_USER:
			case K_USERS:
			case K_VALUES:
				{
				switch ( input.LA(2) ) {
				case 141:
					{
					alt118=1;
					}
					break;
				case 143:
				case 145:
					{
					alt118=2;
					}
					break;
				case INTEGER:
					{
					alt118=3;
					}
					break;
				default:
					int nvaeMark = input.mark();
					try {
						input.consume();
						NoViableAltException nvae =
							new NoViableAltException("", 118, 3, input);
						throw nvae;
					} finally {
						input.rewind(nvaeMark);
					}
				}
				}
				break;
			case K_ASCII:
				{
				switch ( input.LA(2) ) {
				case 141:
					{
					alt118=1;
					}
					break;
				case 143:
				case 145:
					{
					alt118=2;
					}
					break;
				case INTEGER:
					{
					alt118=3;
					}
					break;
				default:
					int nvaeMark = input.mark();
					try {
						input.consume();
						NoViableAltException nvae =
							new NoViableAltException("", 118, 4, input);
						throw nvae;
					} finally {
						input.rewind(nvaeMark);
					}
				}
				}
				break;
			case K_BIGINT:
				{
				switch ( input.LA(2) ) {
				case 141:
					{
					alt118=1;
					}
					break;
				case 143:
				case 145:
					{
					alt118=2;
					}
					break;
				case INTEGER:
					{
					alt118=3;
					}
					break;
				default:
					int nvaeMark = input.mark();
					try {
						input.consume();
						NoViableAltException nvae =
							new NoViableAltException("", 118, 5, input);
						throw nvae;
					} finally {
						input.rewind(nvaeMark);
					}
				}
				}
				break;
			case K_BLOB:
				{
				switch ( input.LA(2) ) {
				case 141:
					{
					alt118=1;
					}
					break;
				case 143:
				case 145:
					{
					alt118=2;
					}
					break;
				case INTEGER:
					{
					alt118=3;
					}
					break;
				default:
					int nvaeMark = input.mark();
					try {
						input.consume();
						NoViableAltException nvae =
							new NoViableAltException("", 118, 6, input);
						throw nvae;
					} finally {
						input.rewind(nvaeMark);
					}
				}
				}
				break;
			case K_BOOLEAN:
				{
				switch ( input.LA(2) ) {
				case 141:
					{
					alt118=1;
					}
					break;
				case 143:
				case 145:
					{
					alt118=2;
					}
					break;
				case INTEGER:
					{
					alt118=3;
					}
					break;
				default:
					int nvaeMark = input.mark();
					try {
						input.consume();
						NoViableAltException nvae =
							new NoViableAltException("", 118, 7, input);
						throw nvae;
					} finally {
						input.rewind(nvaeMark);
					}
				}
				}
				break;
			case K_COUNTER:
				{
				switch ( input.LA(2) ) {
				case 141:
					{
					alt118=1;
					}
					break;
				case 143:
				case 145:
					{
					alt118=2;
					}
					break;
				case INTEGER:
					{
					alt118=3;
					}
					break;
				default:
					int nvaeMark = input.mark();
					try {
						input.consume();
						NoViableAltException nvae =
							new NoViableAltException("", 118, 8, input);
						throw nvae;
					} finally {
						input.rewind(nvaeMark);
					}
				}
				}
				break;
			case K_DECIMAL:
				{
				switch ( input.LA(2) ) {
				case 141:
					{
					alt118=1;
					}
					break;
				case 143:
				case 145:
					{
					alt118=2;
					}
					break;
				case INTEGER:
					{
					alt118=3;
					}
					break;
				default:
					int nvaeMark = input.mark();
					try {
						input.consume();
						NoViableAltException nvae =
							new NoViableAltException("", 118, 9, input);
						throw nvae;
					} finally {
						input.rewind(nvaeMark);
					}
				}
				}
				break;
			case K_DOUBLE:
				{
				switch ( input.LA(2) ) {
				case 141:
					{
					alt118=1;
					}
					break;
				case 143:
				case 145:
					{
					alt118=2;
					}
					break;
				case INTEGER:
					{
					alt118=3;
					}
					break;
				default:
					int nvaeMark = input.mark();
					try {
						input.consume();
						NoViableAltException nvae =
							new NoViableAltException("", 118, 10, input);
						throw nvae;
					} finally {
						input.rewind(nvaeMark);
					}
				}
				}
				break;
			case K_FLOAT:
				{
				switch ( input.LA(2) ) {
				case 141:
					{
					alt118=1;
					}
					break;
				case 143:
				case 145:
					{
					alt118=2;
					}
					break;
				case INTEGER:
					{
					alt118=3;
					}
					break;
				default:
					int nvaeMark = input.mark();
					try {
						input.consume();
						NoViableAltException nvae =
							new NoViableAltException("", 118, 11, input);
						throw nvae;
					} finally {
						input.rewind(nvaeMark);
					}
				}
				}
				break;
			case K_INET:
				{
				switch ( input.LA(2) ) {
				case 141:
					{
					alt118=1;
					}
					break;
				case 143:
				case 145:
					{
					alt118=2;
					}
					break;
				case INTEGER:
					{
					alt118=3;
					}
					break;
				default:
					int nvaeMark = input.mark();
					try {
						input.consume();
						NoViableAltException nvae =
							new NoViableAltException("", 118, 12, input);
						throw nvae;
					} finally {
						input.rewind(nvaeMark);
					}
				}
				}
				break;
			case K_INT:
				{
				switch ( input.LA(2) ) {
				case 141:
					{
					alt118=1;
					}
					break;
				case 143:
				case 145:
					{
					alt118=2;
					}
					break;
				case INTEGER:
					{
					alt118=3;
					}
					break;
				default:
					int nvaeMark = input.mark();
					try {
						input.consume();
						NoViableAltException nvae =
							new NoViableAltException("", 118, 13, input);
						throw nvae;
					} finally {
						input.rewind(nvaeMark);
					}
				}
				}
				break;
			case K_TEXT:
				{
				switch ( input.LA(2) ) {
				case 141:
					{
					alt118=1;
					}
					break;
				case 143:
				case 145:
					{
					alt118=2;
					}
					break;
				case INTEGER:
					{
					alt118=3;
					}
					break;
				default:
					int nvaeMark = input.mark();
					try {
						input.consume();
						NoViableAltException nvae =
							new NoViableAltException("", 118, 14, input);
						throw nvae;
					} finally {
						input.rewind(nvaeMark);
					}
				}
				}
				break;
			case K_TIMESTAMP:
				{
				switch ( input.LA(2) ) {
				case 141:
					{
					alt118=1;
					}
					break;
				case 143:
				case 145:
					{
					alt118=2;
					}
					break;
				case INTEGER:
					{
					alt118=3;
					}
					break;
				default:
					int nvaeMark = input.mark();
					try {
						input.consume();
						NoViableAltException nvae =
							new NoViableAltException("", 118, 15, input);
						throw nvae;
					} finally {
						input.rewind(nvaeMark);
					}
				}
				}
				break;
			case K_UUID:
				{
				switch ( input.LA(2) ) {
				case 141:
					{
					alt118=1;
					}
					break;
				case 143:
				case 145:
					{
					alt118=2;
					}
					break;
				case INTEGER:
					{
					alt118=3;
					}
					break;
				default:
					int nvaeMark = input.mark();
					try {
						input.consume();
						NoViableAltException nvae =
							new NoViableAltException("", 118, 16, input);
						throw nvae;
					} finally {
						input.rewind(nvaeMark);
					}
				}
				}
				break;
			case K_VARCHAR:
				{
				switch ( input.LA(2) ) {
				case 141:
					{
					alt118=1;
					}
					break;
				case 143:
				case 145:
					{
					alt118=2;
					}
					break;
				case INTEGER:
					{
					alt118=3;
					}
					break;
				default:
					int nvaeMark = input.mark();
					try {
						input.consume();
						NoViableAltException nvae =
							new NoViableAltException("", 118, 17, input);
						throw nvae;
					} finally {
						input.rewind(nvaeMark);
					}
				}
				}
				break;
			case K_VARINT:
				{
				switch ( input.LA(2) ) {
				case 141:
					{
					alt118=1;
					}
					break;
				case 143:
				case 145:
					{
					alt118=2;
					}
					break;
				case INTEGER:
					{
					alt118=3;
					}
					break;
				default:
					int nvaeMark = input.mark();
					try {
						input.consume();
						NoViableAltException nvae =
							new NoViableAltException("", 118, 18, input);
						throw nvae;
					} finally {
						input.rewind(nvaeMark);
					}
				}
				}
				break;
			case K_TIMEUUID:
				{
				switch ( input.LA(2) ) {
				case 141:
					{
					alt118=1;
					}
					break;
				case 143:
				case 145:
					{
					alt118=2;
					}
					break;
				case INTEGER:
					{
					alt118=3;
					}
					break;
				default:
					int nvaeMark = input.mark();
					try {
						input.consume();
						NoViableAltException nvae =
							new NoViableAltException("", 118, 19, input);
						throw nvae;
					} finally {
						input.rewind(nvaeMark);
					}
				}
				}
				break;
			case QUOTED_NAME:
				{
				int LA118_20 = input.LA(2);
				if ( (LA118_20==143||LA118_20==145) ) {
					alt118=2;
				}
				else if ( (LA118_20==INTEGER) ) {
					alt118=3;
				}

				else {
					int nvaeMark = input.mark();
					try {
						input.consume();
						NoViableAltException nvae =
							new NoViableAltException("", 118, 20, input);
						throw nvae;
					} finally {
						input.rewind(nvaeMark);
					}
				}

				}
				break;
			case K_COUNT:
			case K_KEY:
			case K_TTL:
			case K_WRITETIME:
				{
				int LA118_21 = input.LA(2);
				if ( (LA118_21==143||LA118_21==145) ) {
					alt118=2;
				}
				else if ( (LA118_21==INTEGER) ) {
					alt118=3;
				}

				else {
					int nvaeMark = input.mark();
					try {
						input.consume();
						NoViableAltException nvae =
							new NoViableAltException("", 118, 21, input);
						throw nvae;
					} finally {
						input.rewind(nvaeMark);
					}
				}

				}
				break;
			default:
				NoViableAltException nvae =
					new NoViableAltException("", 118, 0, input);
				throw nvae;
			}
			switch (alt118) {
				case 1 :
					// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:957:7: t= term ( '+' c= cident )?
					{
					pushFollow(FOLLOW_term_in_normalColumnOperation6167);
					t=term();
					state._fsp--;

					// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:957:14: ( '+' c= cident )?
					int alt117=2;
					int LA117_0 = input.LA(1);
					if ( (LA117_0==143) ) {
						alt117=1;
					}
					switch (alt117) {
						case 1 :
							// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:957:15: '+' c= cident
							{
							match(input,143,FOLLOW_143_in_normalColumnOperation6170); 
							pushFollow(FOLLOW_cident_in_normalColumnOperation6174);
							c=cident();
							state._fsp--;

							}
							break;

					}


					          if (c == null)
					          {
					              addRawUpdate(operations, key, new Operation.SetValue(t));
					          }
					          else
					          {
					              if (!key.equals(c))
					                  addRecognitionError("Only expressions of the form X = <value> + X are supported.");
					              addRawUpdate(operations, key, new Operation.Prepend(t));
					          }
					      
					}
					break;
				case 2 :
					// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:970:7: c= cident sig= ( '+' | '-' ) t= term
					{
					pushFollow(FOLLOW_cident_in_normalColumnOperation6195);
					c=cident();
					state._fsp--;

					sig=input.LT(1);
					if ( input.LA(1)==143||input.LA(1)==145 ) {
						input.consume();
						state.errorRecovery=false;
					}
					else {
						MismatchedSetException mse = new MismatchedSetException(null,input);
						throw mse;
					}
					pushFollow(FOLLOW_term_in_normalColumnOperation6209);
					t=term();
					state._fsp--;


					          if (!key.equals(c))
					              addRecognitionError("Only expressions of the form X = X " + (sig!=null?sig.getText():null) + "<value> are supported.");
					          addRawUpdate(operations, key, (sig!=null?sig.getText():null).equals("+") ? new Operation.Addition(t) : new Operation.Substraction(t));
					      
					}
					break;
				case 3 :
					// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:976:7: c= cident i= INTEGER
					{
					pushFollow(FOLLOW_cident_in_normalColumnOperation6227);
					c=cident();
					state._fsp--;

					i=(Token)match(input,INTEGER,FOLLOW_INTEGER_in_normalColumnOperation6231); 

					          // Note that this production *is* necessary because X = X - 3 will in fact be lexed as [ X, '=', X, INTEGER].
					          if (!key.equals(c))
					              // We don't yet allow a '+' in front of an integer, but we could in the future really, so let's be future-proof in our error message
					              addRecognitionError("Only expressions of the form X = X " + ((i!=null?i.getText():null).charAt(0) == '-' ? '-' : '+') + " <value> are supported.");
					          addRawUpdate(operations, key, new Operation.Addition(Constants.Literal.integer((i!=null?i.getText():null))));
					      
					}
					break;

			}
		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "normalColumnOperation"



	// $ANTLR start "specializedColumnOperation"
	// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:986:1: specializedColumnOperation[List<Pair<ColumnIdentifier.Raw, Operation.RawUpdate>> operations, ColumnIdentifier.Raw key, Term.Raw k] : '=' t= term ;
	public final void specializedColumnOperation(List<Pair<ColumnIdentifier.Raw, Operation.RawUpdate>> operations, ColumnIdentifier.Raw key, Term.Raw k) throws RecognitionException {
		Term.Raw t =null;

		try {
			// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:987:5: ( '=' t= term )
			// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:987:7: '=' t= term
			{
			match(input,151,FOLLOW_151_in_specializedColumnOperation6257); 
			pushFollow(FOLLOW_term_in_specializedColumnOperation6261);
			t=term();
			state._fsp--;


			          addRawUpdate(operations, key, new Operation.SetElement(k, t));
			      
			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "specializedColumnOperation"



	// $ANTLR start "columnCondition"
	// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:993:1: columnCondition[List<Pair<ColumnIdentifier.Raw, ColumnCondition.Raw>> conditions] : key= cident (op= relationType t= term | K_IN (values= singleColumnInValues |marker= inMarker ) | '[' element= term ']' (op= relationType t= term | K_IN (values= singleColumnInValues |marker= inMarker ) ) ) ;
	public final void columnCondition(List<Pair<ColumnIdentifier.Raw, ColumnCondition.Raw>> conditions) throws RecognitionException {
		ColumnIdentifier.Raw key =null;
		Operator op =null;
		Term.Raw t =null;
		List<Term.Raw> values =null;
		AbstractMarker.INRaw marker =null;
		Term.Raw element =null;

		try {
			// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:995:5: (key= cident (op= relationType t= term | K_IN (values= singleColumnInValues |marker= inMarker ) | '[' element= term ']' (op= relationType t= term | K_IN (values= singleColumnInValues |marker= inMarker ) ) ) )
			// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:995:7: key= cident (op= relationType t= term | K_IN (values= singleColumnInValues |marker= inMarker ) | '[' element= term ']' (op= relationType t= term | K_IN (values= singleColumnInValues |marker= inMarker ) ) )
			{
			pushFollow(FOLLOW_cident_in_columnCondition6294);
			key=cident();
			state._fsp--;

			// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:996:9: (op= relationType t= term | K_IN (values= singleColumnInValues |marker= inMarker ) | '[' element= term ']' (op= relationType t= term | K_IN (values= singleColumnInValues |marker= inMarker ) ) )
			int alt122=3;
			switch ( input.LA(1) ) {
			case 140:
			case 149:
			case 150:
			case 151:
			case 152:
			case 153:
				{
				alt122=1;
				}
				break;
			case K_IN:
				{
				alt122=2;
				}
				break;
			case 154:
				{
				alt122=3;
				}
				break;
			default:
				NoViableAltException nvae =
					new NoViableAltException("", 122, 0, input);
				throw nvae;
			}
			switch (alt122) {
				case 1 :
					// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:996:11: op= relationType t= term
					{
					pushFollow(FOLLOW_relationType_in_columnCondition6308);
					op=relationType();
					state._fsp--;

					pushFollow(FOLLOW_term_in_columnCondition6312);
					t=term();
					state._fsp--;

					 conditions.add(Pair.create(key, ColumnCondition.Raw.simpleCondition(t, op))); 
					}
					break;
				case 2 :
					// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:997:11: K_IN (values= singleColumnInValues |marker= inMarker )
					{
					match(input,K_IN,FOLLOW_K_IN_in_columnCondition6326); 
					// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:998:13: (values= singleColumnInValues |marker= inMarker )
					int alt119=2;
					int LA119_0 = input.LA(1);
					if ( (LA119_0==141) ) {
						alt119=1;
					}
					else if ( (LA119_0==QMARK||LA119_0==147) ) {
						alt119=2;
					}

					else {
						NoViableAltException nvae =
							new NoViableAltException("", 119, 0, input);
						throw nvae;
					}

					switch (alt119) {
						case 1 :
							// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:998:15: values= singleColumnInValues
							{
							pushFollow(FOLLOW_singleColumnInValues_in_columnCondition6344);
							values=singleColumnInValues();
							state._fsp--;

							 conditions.add(Pair.create(key, ColumnCondition.Raw.simpleInCondition(values))); 
							}
							break;
						case 2 :
							// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:999:15: marker= inMarker
							{
							pushFollow(FOLLOW_inMarker_in_columnCondition6364);
							marker=inMarker();
							state._fsp--;

							 conditions.add(Pair.create(key, ColumnCondition.Raw.simpleInCondition(marker))); 
							}
							break;

					}

					}
					break;
				case 3 :
					// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1001:11: '[' element= term ']' (op= relationType t= term | K_IN (values= singleColumnInValues |marker= inMarker ) )
					{
					match(input,154,FOLLOW_154_in_columnCondition6392); 
					pushFollow(FOLLOW_term_in_columnCondition6396);
					element=term();
					state._fsp--;

					match(input,156,FOLLOW_156_in_columnCondition6398); 
					// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1002:13: (op= relationType t= term | K_IN (values= singleColumnInValues |marker= inMarker ) )
					int alt121=2;
					int LA121_0 = input.LA(1);
					if ( (LA121_0==140||(LA121_0 >= 149 && LA121_0 <= 153)) ) {
						alt121=1;
					}
					else if ( (LA121_0==K_IN) ) {
						alt121=2;
					}

					else {
						NoViableAltException nvae =
							new NoViableAltException("", 121, 0, input);
						throw nvae;
					}

					switch (alt121) {
						case 1 :
							// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1002:15: op= relationType t= term
							{
							pushFollow(FOLLOW_relationType_in_columnCondition6416);
							op=relationType();
							state._fsp--;

							pushFollow(FOLLOW_term_in_columnCondition6420);
							t=term();
							state._fsp--;

							 conditions.add(Pair.create(key, ColumnCondition.Raw.collectionCondition(t, element, op))); 
							}
							break;
						case 2 :
							// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1003:15: K_IN (values= singleColumnInValues |marker= inMarker )
							{
							match(input,K_IN,FOLLOW_K_IN_in_columnCondition6438); 
							// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1004:17: (values= singleColumnInValues |marker= inMarker )
							int alt120=2;
							int LA120_0 = input.LA(1);
							if ( (LA120_0==141) ) {
								alt120=1;
							}
							else if ( (LA120_0==QMARK||LA120_0==147) ) {
								alt120=2;
							}

							else {
								NoViableAltException nvae =
									new NoViableAltException("", 120, 0, input);
								throw nvae;
							}

							switch (alt120) {
								case 1 :
									// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1004:19: values= singleColumnInValues
									{
									pushFollow(FOLLOW_singleColumnInValues_in_columnCondition6460);
									values=singleColumnInValues();
									state._fsp--;

									 conditions.add(Pair.create(key, ColumnCondition.Raw.collectionInCondition(element, values))); 
									}
									break;
								case 2 :
									// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1005:19: marker= inMarker
									{
									pushFollow(FOLLOW_inMarker_in_columnCondition6484);
									marker=inMarker();
									state._fsp--;

									 conditions.add(Pair.create(key, ColumnCondition.Raw.collectionInCondition(element, marker))); 
									}
									break;

							}

							}
							break;

					}

					}
					break;

			}

			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "columnCondition"



	// $ANTLR start "properties"
	// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1011:1: properties[PropertyDefinitions props] : property[props] ( K_AND property[props] )* ;
	public final void properties(PropertyDefinitions props) throws RecognitionException {
		try {
			// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1012:5: ( property[props] ( K_AND property[props] )* )
			// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1012:7: property[props] ( K_AND property[props] )*
			{
			pushFollow(FOLLOW_property_in_properties6546);
			property(props);
			state._fsp--;

			// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1012:23: ( K_AND property[props] )*
			loop123:
			while (true) {
				int alt123=2;
				int LA123_0 = input.LA(1);
				if ( (LA123_0==K_AND) ) {
					alt123=1;
				}

				switch (alt123) {
				case 1 :
					// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1012:24: K_AND property[props]
					{
					match(input,K_AND,FOLLOW_K_AND_in_properties6550); 
					pushFollow(FOLLOW_property_in_properties6552);
					property(props);
					state._fsp--;

					}
					break;

				default :
					break loop123;
				}
			}

			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "properties"



	// $ANTLR start "property"
	// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1015:1: property[PropertyDefinitions props] : k= ident '=' (simple= propertyValue |map= mapLiteral ) ;
	public final void property(PropertyDefinitions props) throws RecognitionException {
		ColumnIdentifier k =null;
		String simple =null;
		Maps.Literal map =null;

		try {
			// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1016:5: (k= ident '=' (simple= propertyValue |map= mapLiteral ) )
			// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1016:7: k= ident '=' (simple= propertyValue |map= mapLiteral )
			{
			pushFollow(FOLLOW_ident_in_property6575);
			k=ident();
			state._fsp--;

			match(input,151,FOLLOW_151_in_property6577); 
			// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1016:19: (simple= propertyValue |map= mapLiteral )
			int alt124=2;
			int LA124_0 = input.LA(1);
			if ( (LA124_0==BOOLEAN||LA124_0==FLOAT||LA124_0==HEXNUMBER||LA124_0==INTEGER||LA124_0==K_ALL||LA124_0==K_AS||LA124_0==K_ASCII||(LA124_0 >= K_BIGINT && LA124_0 <= K_BOOLEAN)||LA124_0==K_CLUSTERING||(LA124_0 >= K_COMPACT && LA124_0 <= K_COUNTER)||(LA124_0 >= K_CUSTOM && LA124_0 <= K_DECIMAL)||(LA124_0 >= K_DISTINCT && LA124_0 <= K_DOUBLE)||(LA124_0 >= K_EXISTS && LA124_0 <= K_FLOAT)||(LA124_0 >= K_INET && LA124_0 <= K_INFINITY)||LA124_0==K_INT||(LA124_0 >= K_KEY && LA124_0 <= K_KEYS)||LA124_0==K_KEYSPACES||(LA124_0 >= K_LIST && LA124_0 <= K_MAP)||LA124_0==K_NAN||LA124_0==K_NOSUPERUSER||(LA124_0 >= K_PASSWORD && LA124_0 <= K_PERMISSIONS)||(LA124_0 >= K_STATIC && LA124_0 <= K_TIMEUUID)||LA124_0==K_TRIGGER||LA124_0==K_TTL||LA124_0==K_TYPE||(LA124_0 >= K_USER && LA124_0 <= K_USERS)||(LA124_0 >= K_UUID && LA124_0 <= K_VARINT)||LA124_0==K_WRITETIME||LA124_0==STRING_LITERAL||LA124_0==UUID||LA124_0==145) ) {
				alt124=1;
			}
			else if ( (LA124_0==157) ) {
				alt124=2;
			}

			else {
				NoViableAltException nvae =
					new NoViableAltException("", 124, 0, input);
				throw nvae;
			}

			switch (alt124) {
				case 1 :
					// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1016:20: simple= propertyValue
					{
					pushFollow(FOLLOW_propertyValue_in_property6582);
					simple=propertyValue();
					state._fsp--;

					 try { props.addProperty(k.toString(), simple); } catch (SyntaxException e) { addRecognitionError(e.getMessage()); } 
					}
					break;
				case 2 :
					// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1017:23: map= mapLiteral
					{
					pushFollow(FOLLOW_mapLiteral_in_property6610);
					map=mapLiteral();
					state._fsp--;

					 try { props.addProperty(k.toString(), convertPropertyMap(map)); } catch (SyntaxException e) { addRecognitionError(e.getMessage()); } 
					}
					break;

			}

			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "property"



	// $ANTLR start "propertyValue"
	// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1020:1: propertyValue returns [String str] : (c= constant |u= unreserved_keyword );
	public final String propertyValue() throws RecognitionException {
		String str = null;


		Constants.Literal c =null;
		String u =null;

		try {
			// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1021:5: (c= constant |u= unreserved_keyword )
			int alt125=2;
			int LA125_0 = input.LA(1);
			if ( (LA125_0==BOOLEAN||LA125_0==FLOAT||LA125_0==HEXNUMBER||LA125_0==INTEGER||LA125_0==K_INFINITY||LA125_0==K_NAN||LA125_0==STRING_LITERAL||LA125_0==UUID||LA125_0==145) ) {
				alt125=1;
			}
			else if ( (LA125_0==K_ALL||LA125_0==K_AS||LA125_0==K_ASCII||(LA125_0 >= K_BIGINT && LA125_0 <= K_BOOLEAN)||LA125_0==K_CLUSTERING||(LA125_0 >= K_COMPACT && LA125_0 <= K_COUNTER)||(LA125_0 >= K_CUSTOM && LA125_0 <= K_DECIMAL)||(LA125_0 >= K_DISTINCT && LA125_0 <= K_DOUBLE)||(LA125_0 >= K_EXISTS && LA125_0 <= K_FLOAT)||LA125_0==K_INET||LA125_0==K_INT||(LA125_0 >= K_KEY && LA125_0 <= K_KEYS)||LA125_0==K_KEYSPACES||(LA125_0 >= K_LIST && LA125_0 <= K_MAP)||LA125_0==K_NOSUPERUSER||(LA125_0 >= K_PASSWORD && LA125_0 <= K_PERMISSIONS)||(LA125_0 >= K_STATIC && LA125_0 <= K_TIMEUUID)||LA125_0==K_TRIGGER||LA125_0==K_TTL||LA125_0==K_TYPE||(LA125_0 >= K_USER && LA125_0 <= K_USERS)||(LA125_0 >= K_UUID && LA125_0 <= K_VARINT)||LA125_0==K_WRITETIME) ) {
				alt125=2;
			}

			else {
				NoViableAltException nvae =
					new NoViableAltException("", 125, 0, input);
				throw nvae;
			}

			switch (alt125) {
				case 1 :
					// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1021:7: c= constant
					{
					pushFollow(FOLLOW_constant_in_propertyValue6639);
					c=constant();
					state._fsp--;

					 str = c.getRawText(); 
					}
					break;
				case 2 :
					// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1022:7: u= unreserved_keyword
					{
					pushFollow(FOLLOW_unreserved_keyword_in_propertyValue6661);
					u=unreserved_keyword();
					state._fsp--;

					 str = u; 
					}
					break;

			}
		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return str;
	}
	// $ANTLR end "propertyValue"



	// $ANTLR start "relationType"
	// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1025:1: relationType returns [Operator op] : ( '=' | '<' | '<=' | '>' | '>=' | '!=' );
	public final Operator relationType() throws RecognitionException {
		Operator op = null;


		try {
			// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1026:5: ( '=' | '<' | '<=' | '>' | '>=' | '!=' )
			int alt126=6;
			switch ( input.LA(1) ) {
			case 151:
				{
				alt126=1;
				}
				break;
			case 149:
				{
				alt126=2;
				}
				break;
			case 150:
				{
				alt126=3;
				}
				break;
			case 152:
				{
				alt126=4;
				}
				break;
			case 153:
				{
				alt126=5;
				}
				break;
			case 140:
				{
				alt126=6;
				}
				break;
			default:
				NoViableAltException nvae =
					new NoViableAltException("", 126, 0, input);
				throw nvae;
			}
			switch (alt126) {
				case 1 :
					// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1026:7: '='
					{
					match(input,151,FOLLOW_151_in_relationType6684); 
					 op = Operator.EQ; 
					}
					break;
				case 2 :
					// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1027:7: '<'
					{
					match(input,149,FOLLOW_149_in_relationType6695); 
					 op = Operator.LT; 
					}
					break;
				case 3 :
					// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1028:7: '<='
					{
					match(input,150,FOLLOW_150_in_relationType6706); 
					 op = Operator.LTE; 
					}
					break;
				case 4 :
					// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1029:7: '>'
					{
					match(input,152,FOLLOW_152_in_relationType6716); 
					 op = Operator.GT; 
					}
					break;
				case 5 :
					// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1030:7: '>='
					{
					match(input,153,FOLLOW_153_in_relationType6727); 
					 op = Operator.GTE; 
					}
					break;
				case 6 :
					// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1031:7: '!='
					{
					match(input,140,FOLLOW_140_in_relationType6737); 
					 op = Operator.NEQ; 
					}
					break;

			}
		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return op;
	}
	// $ANTLR end "relationType"



	// $ANTLR start "relation"
	// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1034:1: relation[List<Relation> clauses] : (name= cident type= relationType t= term | K_TOKEN l= tupleOfIdentifiers type= relationType t= term |name= cident K_IN marker= inMarker |name= cident K_IN inValues= singleColumnInValues |name= cident K_CONTAINS ( K_KEY )? t= term |ids= tupleOfIdentifiers ( K_IN ( '(' ')' |tupleInMarker= inMarkerForTuple |literals= tupleOfTupleLiterals |markers= tupleOfMarkersForTuples ) |type= relationType literal= tupleLiteral |type= relationType tupleMarker= markerForTuple ) | '(' relation[$clauses] ')' );
	public final void relation(List<Relation> clauses) throws RecognitionException {
		ColumnIdentifier.Raw name =null;
		Operator type =null;
		Term.Raw t =null;
		List<ColumnIdentifier.Raw> l =null;
		AbstractMarker.INRaw marker =null;
		List<Term.Raw> inValues =null;
		List<ColumnIdentifier.Raw> ids =null;
		Tuples.INRaw tupleInMarker =null;
		List<Tuples.Literal> literals =null;
		List<Tuples.Raw> markers =null;
		Tuples.Literal literal =null;
		Tuples.Raw tupleMarker =null;

		try {
			// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1035:5: (name= cident type= relationType t= term | K_TOKEN l= tupleOfIdentifiers type= relationType t= term |name= cident K_IN marker= inMarker |name= cident K_IN inValues= singleColumnInValues |name= cident K_CONTAINS ( K_KEY )? t= term |ids= tupleOfIdentifiers ( K_IN ( '(' ')' |tupleInMarker= inMarkerForTuple |literals= tupleOfTupleLiterals |markers= tupleOfMarkersForTuples ) |type= relationType literal= tupleLiteral |type= relationType tupleMarker= markerForTuple ) | '(' relation[$clauses] ')' )
			int alt130=7;
			switch ( input.LA(1) ) {
			case IDENT:
				{
				switch ( input.LA(2) ) {
				case 140:
				case 149:
				case 150:
				case 151:
				case 152:
				case 153:
					{
					alt130=1;
					}
					break;
				case K_IN:
					{
					int LA130_24 = input.LA(3);
					if ( (LA130_24==QMARK||LA130_24==147) ) {
						alt130=3;
					}
					else if ( (LA130_24==141) ) {
						alt130=4;
					}

					else {
						int nvaeMark = input.mark();
						try {
							for (int nvaeConsume = 0; nvaeConsume < 3 - 1; nvaeConsume++) {
								input.consume();
							}
							NoViableAltException nvae =
								new NoViableAltException("", 130, 24, input);
							throw nvae;
						} finally {
							input.rewind(nvaeMark);
						}
					}

					}
					break;
				case K_CONTAINS:
					{
					alt130=5;
					}
					break;
				default:
					int nvaeMark = input.mark();
					try {
						input.consume();
						NoViableAltException nvae =
							new NoViableAltException("", 130, 1, input);
						throw nvae;
					} finally {
						input.rewind(nvaeMark);
					}
				}
				}
				break;
			case QUOTED_NAME:
				{
				switch ( input.LA(2) ) {
				case 140:
				case 149:
				case 150:
				case 151:
				case 152:
				case 153:
					{
					alt130=1;
					}
					break;
				case K_IN:
					{
					int LA130_24 = input.LA(3);
					if ( (LA130_24==QMARK||LA130_24==147) ) {
						alt130=3;
					}
					else if ( (LA130_24==141) ) {
						alt130=4;
					}

					else {
						int nvaeMark = input.mark();
						try {
							for (int nvaeConsume = 0; nvaeConsume < 3 - 1; nvaeConsume++) {
								input.consume();
							}
							NoViableAltException nvae =
								new NoViableAltException("", 130, 24, input);
							throw nvae;
						} finally {
							input.rewind(nvaeMark);
						}
					}

					}
					break;
				case K_CONTAINS:
					{
					alt130=5;
					}
					break;
				default:
					int nvaeMark = input.mark();
					try {
						input.consume();
						NoViableAltException nvae =
							new NoViableAltException("", 130, 2, input);
						throw nvae;
					} finally {
						input.rewind(nvaeMark);
					}
				}
				}
				break;
			case K_ALL:
			case K_AS:
			case K_CLUSTERING:
			case K_COMPACT:
			case K_CONTAINS:
			case K_CUSTOM:
			case K_DISTINCT:
			case K_EXISTS:
			case K_FILTERING:
			case K_KEYS:
			case K_KEYSPACES:
			case K_LIST:
			case K_MAP:
			case K_NOSUPERUSER:
			case K_PASSWORD:
			case K_PERMISSION:
			case K_PERMISSIONS:
			case K_STATIC:
			case K_STORAGE:
			case K_SUPERUSER:
			case K_TRIGGER:
			case K_TYPE:
			case K_USER:
			case K_USERS:
			case K_VALUES:
				{
				switch ( input.LA(2) ) {
				case 140:
				case 149:
				case 150:
				case 151:
				case 152:
				case 153:
					{
					alt130=1;
					}
					break;
				case K_IN:
					{
					int LA130_24 = input.LA(3);
					if ( (LA130_24==QMARK||LA130_24==147) ) {
						alt130=3;
					}
					else if ( (LA130_24==141) ) {
						alt130=4;
					}

					else {
						int nvaeMark = input.mark();
						try {
							for (int nvaeConsume = 0; nvaeConsume < 3 - 1; nvaeConsume++) {
								input.consume();
							}
							NoViableAltException nvae =
								new NoViableAltException("", 130, 24, input);
							throw nvae;
						} finally {
							input.rewind(nvaeMark);
						}
					}

					}
					break;
				case K_CONTAINS:
					{
					alt130=5;
					}
					break;
				default:
					int nvaeMark = input.mark();
					try {
						input.consume();
						NoViableAltException nvae =
							new NoViableAltException("", 130, 3, input);
						throw nvae;
					} finally {
						input.rewind(nvaeMark);
					}
				}
				}
				break;
			case K_ASCII:
				{
				switch ( input.LA(2) ) {
				case 140:
				case 149:
				case 150:
				case 151:
				case 152:
				case 153:
					{
					alt130=1;
					}
					break;
				case K_IN:
					{
					int LA130_24 = input.LA(3);
					if ( (LA130_24==QMARK||LA130_24==147) ) {
						alt130=3;
					}
					else if ( (LA130_24==141) ) {
						alt130=4;
					}

					else {
						int nvaeMark = input.mark();
						try {
							for (int nvaeConsume = 0; nvaeConsume < 3 - 1; nvaeConsume++) {
								input.consume();
							}
							NoViableAltException nvae =
								new NoViableAltException("", 130, 24, input);
							throw nvae;
						} finally {
							input.rewind(nvaeMark);
						}
					}

					}
					break;
				case K_CONTAINS:
					{
					alt130=5;
					}
					break;
				default:
					int nvaeMark = input.mark();
					try {
						input.consume();
						NoViableAltException nvae =
							new NoViableAltException("", 130, 4, input);
						throw nvae;
					} finally {
						input.rewind(nvaeMark);
					}
				}
				}
				break;
			case K_BIGINT:
				{
				switch ( input.LA(2) ) {
				case 140:
				case 149:
				case 150:
				case 151:
				case 152:
				case 153:
					{
					alt130=1;
					}
					break;
				case K_IN:
					{
					int LA130_24 = input.LA(3);
					if ( (LA130_24==QMARK||LA130_24==147) ) {
						alt130=3;
					}
					else if ( (LA130_24==141) ) {
						alt130=4;
					}

					else {
						int nvaeMark = input.mark();
						try {
							for (int nvaeConsume = 0; nvaeConsume < 3 - 1; nvaeConsume++) {
								input.consume();
							}
							NoViableAltException nvae =
								new NoViableAltException("", 130, 24, input);
							throw nvae;
						} finally {
							input.rewind(nvaeMark);
						}
					}

					}
					break;
				case K_CONTAINS:
					{
					alt130=5;
					}
					break;
				default:
					int nvaeMark = input.mark();
					try {
						input.consume();
						NoViableAltException nvae =
							new NoViableAltException("", 130, 5, input);
						throw nvae;
					} finally {
						input.rewind(nvaeMark);
					}
				}
				}
				break;
			case K_BLOB:
				{
				switch ( input.LA(2) ) {
				case 140:
				case 149:
				case 150:
				case 151:
				case 152:
				case 153:
					{
					alt130=1;
					}
					break;
				case K_IN:
					{
					int LA130_24 = input.LA(3);
					if ( (LA130_24==QMARK||LA130_24==147) ) {
						alt130=3;
					}
					else if ( (LA130_24==141) ) {
						alt130=4;
					}

					else {
						int nvaeMark = input.mark();
						try {
							for (int nvaeConsume = 0; nvaeConsume < 3 - 1; nvaeConsume++) {
								input.consume();
							}
							NoViableAltException nvae =
								new NoViableAltException("", 130, 24, input);
							throw nvae;
						} finally {
							input.rewind(nvaeMark);
						}
					}

					}
					break;
				case K_CONTAINS:
					{
					alt130=5;
					}
					break;
				default:
					int nvaeMark = input.mark();
					try {
						input.consume();
						NoViableAltException nvae =
							new NoViableAltException("", 130, 6, input);
						throw nvae;
					} finally {
						input.rewind(nvaeMark);
					}
				}
				}
				break;
			case K_BOOLEAN:
				{
				switch ( input.LA(2) ) {
				case 140:
				case 149:
				case 150:
				case 151:
				case 152:
				case 153:
					{
					alt130=1;
					}
					break;
				case K_IN:
					{
					int LA130_24 = input.LA(3);
					if ( (LA130_24==QMARK||LA130_24==147) ) {
						alt130=3;
					}
					else if ( (LA130_24==141) ) {
						alt130=4;
					}

					else {
						int nvaeMark = input.mark();
						try {
							for (int nvaeConsume = 0; nvaeConsume < 3 - 1; nvaeConsume++) {
								input.consume();
							}
							NoViableAltException nvae =
								new NoViableAltException("", 130, 24, input);
							throw nvae;
						} finally {
							input.rewind(nvaeMark);
						}
					}

					}
					break;
				case K_CONTAINS:
					{
					alt130=5;
					}
					break;
				default:
					int nvaeMark = input.mark();
					try {
						input.consume();
						NoViableAltException nvae =
							new NoViableAltException("", 130, 7, input);
						throw nvae;
					} finally {
						input.rewind(nvaeMark);
					}
				}
				}
				break;
			case K_COUNTER:
				{
				switch ( input.LA(2) ) {
				case 140:
				case 149:
				case 150:
				case 151:
				case 152:
				case 153:
					{
					alt130=1;
					}
					break;
				case K_IN:
					{
					int LA130_24 = input.LA(3);
					if ( (LA130_24==QMARK||LA130_24==147) ) {
						alt130=3;
					}
					else if ( (LA130_24==141) ) {
						alt130=4;
					}

					else {
						int nvaeMark = input.mark();
						try {
							for (int nvaeConsume = 0; nvaeConsume < 3 - 1; nvaeConsume++) {
								input.consume();
							}
							NoViableAltException nvae =
								new NoViableAltException("", 130, 24, input);
							throw nvae;
						} finally {
							input.rewind(nvaeMark);
						}
					}

					}
					break;
				case K_CONTAINS:
					{
					alt130=5;
					}
					break;
				default:
					int nvaeMark = input.mark();
					try {
						input.consume();
						NoViableAltException nvae =
							new NoViableAltException("", 130, 8, input);
						throw nvae;
					} finally {
						input.rewind(nvaeMark);
					}
				}
				}
				break;
			case K_DECIMAL:
				{
				switch ( input.LA(2) ) {
				case 140:
				case 149:
				case 150:
				case 151:
				case 152:
				case 153:
					{
					alt130=1;
					}
					break;
				case K_IN:
					{
					int LA130_24 = input.LA(3);
					if ( (LA130_24==QMARK||LA130_24==147) ) {
						alt130=3;
					}
					else if ( (LA130_24==141) ) {
						alt130=4;
					}

					else {
						int nvaeMark = input.mark();
						try {
							for (int nvaeConsume = 0; nvaeConsume < 3 - 1; nvaeConsume++) {
								input.consume();
							}
							NoViableAltException nvae =
								new NoViableAltException("", 130, 24, input);
							throw nvae;
						} finally {
							input.rewind(nvaeMark);
						}
					}

					}
					break;
				case K_CONTAINS:
					{
					alt130=5;
					}
					break;
				default:
					int nvaeMark = input.mark();
					try {
						input.consume();
						NoViableAltException nvae =
							new NoViableAltException("", 130, 9, input);
						throw nvae;
					} finally {
						input.rewind(nvaeMark);
					}
				}
				}
				break;
			case K_DOUBLE:
				{
				switch ( input.LA(2) ) {
				case 140:
				case 149:
				case 150:
				case 151:
				case 152:
				case 153:
					{
					alt130=1;
					}
					break;
				case K_IN:
					{
					int LA130_24 = input.LA(3);
					if ( (LA130_24==QMARK||LA130_24==147) ) {
						alt130=3;
					}
					else if ( (LA130_24==141) ) {
						alt130=4;
					}

					else {
						int nvaeMark = input.mark();
						try {
							for (int nvaeConsume = 0; nvaeConsume < 3 - 1; nvaeConsume++) {
								input.consume();
							}
							NoViableAltException nvae =
								new NoViableAltException("", 130, 24, input);
							throw nvae;
						} finally {
							input.rewind(nvaeMark);
						}
					}

					}
					break;
				case K_CONTAINS:
					{
					alt130=5;
					}
					break;
				default:
					int nvaeMark = input.mark();
					try {
						input.consume();
						NoViableAltException nvae =
							new NoViableAltException("", 130, 10, input);
						throw nvae;
					} finally {
						input.rewind(nvaeMark);
					}
				}
				}
				break;
			case K_FLOAT:
				{
				switch ( input.LA(2) ) {
				case 140:
				case 149:
				case 150:
				case 151:
				case 152:
				case 153:
					{
					alt130=1;
					}
					break;
				case K_IN:
					{
					int LA130_24 = input.LA(3);
					if ( (LA130_24==QMARK||LA130_24==147) ) {
						alt130=3;
					}
					else if ( (LA130_24==141) ) {
						alt130=4;
					}

					else {
						int nvaeMark = input.mark();
						try {
							for (int nvaeConsume = 0; nvaeConsume < 3 - 1; nvaeConsume++) {
								input.consume();
							}
							NoViableAltException nvae =
								new NoViableAltException("", 130, 24, input);
							throw nvae;
						} finally {
							input.rewind(nvaeMark);
						}
					}

					}
					break;
				case K_CONTAINS:
					{
					alt130=5;
					}
					break;
				default:
					int nvaeMark = input.mark();
					try {
						input.consume();
						NoViableAltException nvae =
							new NoViableAltException("", 130, 11, input);
						throw nvae;
					} finally {
						input.rewind(nvaeMark);
					}
				}
				}
				break;
			case K_INET:
				{
				switch ( input.LA(2) ) {
				case 140:
				case 149:
				case 150:
				case 151:
				case 152:
				case 153:
					{
					alt130=1;
					}
					break;
				case K_IN:
					{
					int LA130_24 = input.LA(3);
					if ( (LA130_24==QMARK||LA130_24==147) ) {
						alt130=3;
					}
					else if ( (LA130_24==141) ) {
						alt130=4;
					}

					else {
						int nvaeMark = input.mark();
						try {
							for (int nvaeConsume = 0; nvaeConsume < 3 - 1; nvaeConsume++) {
								input.consume();
							}
							NoViableAltException nvae =
								new NoViableAltException("", 130, 24, input);
							throw nvae;
						} finally {
							input.rewind(nvaeMark);
						}
					}

					}
					break;
				case K_CONTAINS:
					{
					alt130=5;
					}
					break;
				default:
					int nvaeMark = input.mark();
					try {
						input.consume();
						NoViableAltException nvae =
							new NoViableAltException("", 130, 12, input);
						throw nvae;
					} finally {
						input.rewind(nvaeMark);
					}
				}
				}
				break;
			case K_INT:
				{
				switch ( input.LA(2) ) {
				case 140:
				case 149:
				case 150:
				case 151:
				case 152:
				case 153:
					{
					alt130=1;
					}
					break;
				case K_IN:
					{
					int LA130_24 = input.LA(3);
					if ( (LA130_24==QMARK||LA130_24==147) ) {
						alt130=3;
					}
					else if ( (LA130_24==141) ) {
						alt130=4;
					}

					else {
						int nvaeMark = input.mark();
						try {
							for (int nvaeConsume = 0; nvaeConsume < 3 - 1; nvaeConsume++) {
								input.consume();
							}
							NoViableAltException nvae =
								new NoViableAltException("", 130, 24, input);
							throw nvae;
						} finally {
							input.rewind(nvaeMark);
						}
					}

					}
					break;
				case K_CONTAINS:
					{
					alt130=5;
					}
					break;
				default:
					int nvaeMark = input.mark();
					try {
						input.consume();
						NoViableAltException nvae =
							new NoViableAltException("", 130, 13, input);
						throw nvae;
					} finally {
						input.rewind(nvaeMark);
					}
				}
				}
				break;
			case K_TEXT:
				{
				switch ( input.LA(2) ) {
				case 140:
				case 149:
				case 150:
				case 151:
				case 152:
				case 153:
					{
					alt130=1;
					}
					break;
				case K_IN:
					{
					int LA130_24 = input.LA(3);
					if ( (LA130_24==QMARK||LA130_24==147) ) {
						alt130=3;
					}
					else if ( (LA130_24==141) ) {
						alt130=4;
					}

					else {
						int nvaeMark = input.mark();
						try {
							for (int nvaeConsume = 0; nvaeConsume < 3 - 1; nvaeConsume++) {
								input.consume();
							}
							NoViableAltException nvae =
								new NoViableAltException("", 130, 24, input);
							throw nvae;
						} finally {
							input.rewind(nvaeMark);
						}
					}

					}
					break;
				case K_CONTAINS:
					{
					alt130=5;
					}
					break;
				default:
					int nvaeMark = input.mark();
					try {
						input.consume();
						NoViableAltException nvae =
							new NoViableAltException("", 130, 14, input);
						throw nvae;
					} finally {
						input.rewind(nvaeMark);
					}
				}
				}
				break;
			case K_TIMESTAMP:
				{
				switch ( input.LA(2) ) {
				case 140:
				case 149:
				case 150:
				case 151:
				case 152:
				case 153:
					{
					alt130=1;
					}
					break;
				case K_IN:
					{
					int LA130_24 = input.LA(3);
					if ( (LA130_24==QMARK||LA130_24==147) ) {
						alt130=3;
					}
					else if ( (LA130_24==141) ) {
						alt130=4;
					}

					else {
						int nvaeMark = input.mark();
						try {
							for (int nvaeConsume = 0; nvaeConsume < 3 - 1; nvaeConsume++) {
								input.consume();
							}
							NoViableAltException nvae =
								new NoViableAltException("", 130, 24, input);
							throw nvae;
						} finally {
							input.rewind(nvaeMark);
						}
					}

					}
					break;
				case K_CONTAINS:
					{
					alt130=5;
					}
					break;
				default:
					int nvaeMark = input.mark();
					try {
						input.consume();
						NoViableAltException nvae =
							new NoViableAltException("", 130, 15, input);
						throw nvae;
					} finally {
						input.rewind(nvaeMark);
					}
				}
				}
				break;
			case K_UUID:
				{
				switch ( input.LA(2) ) {
				case 140:
				case 149:
				case 150:
				case 151:
				case 152:
				case 153:
					{
					alt130=1;
					}
					break;
				case K_IN:
					{
					int LA130_24 = input.LA(3);
					if ( (LA130_24==QMARK||LA130_24==147) ) {
						alt130=3;
					}
					else if ( (LA130_24==141) ) {
						alt130=4;
					}

					else {
						int nvaeMark = input.mark();
						try {
							for (int nvaeConsume = 0; nvaeConsume < 3 - 1; nvaeConsume++) {
								input.consume();
							}
							NoViableAltException nvae =
								new NoViableAltException("", 130, 24, input);
							throw nvae;
						} finally {
							input.rewind(nvaeMark);
						}
					}

					}
					break;
				case K_CONTAINS:
					{
					alt130=5;
					}
					break;
				default:
					int nvaeMark = input.mark();
					try {
						input.consume();
						NoViableAltException nvae =
							new NoViableAltException("", 130, 16, input);
						throw nvae;
					} finally {
						input.rewind(nvaeMark);
					}
				}
				}
				break;
			case K_VARCHAR:
				{
				switch ( input.LA(2) ) {
				case 140:
				case 149:
				case 150:
				case 151:
				case 152:
				case 153:
					{
					alt130=1;
					}
					break;
				case K_IN:
					{
					int LA130_24 = input.LA(3);
					if ( (LA130_24==QMARK||LA130_24==147) ) {
						alt130=3;
					}
					else if ( (LA130_24==141) ) {
						alt130=4;
					}

					else {
						int nvaeMark = input.mark();
						try {
							for (int nvaeConsume = 0; nvaeConsume < 3 - 1; nvaeConsume++) {
								input.consume();
							}
							NoViableAltException nvae =
								new NoViableAltException("", 130, 24, input);
							throw nvae;
						} finally {
							input.rewind(nvaeMark);
						}
					}

					}
					break;
				case K_CONTAINS:
					{
					alt130=5;
					}
					break;
				default:
					int nvaeMark = input.mark();
					try {
						input.consume();
						NoViableAltException nvae =
							new NoViableAltException("", 130, 17, input);
						throw nvae;
					} finally {
						input.rewind(nvaeMark);
					}
				}
				}
				break;
			case K_VARINT:
				{
				switch ( input.LA(2) ) {
				case 140:
				case 149:
				case 150:
				case 151:
				case 152:
				case 153:
					{
					alt130=1;
					}
					break;
				case K_IN:
					{
					int LA130_24 = input.LA(3);
					if ( (LA130_24==QMARK||LA130_24==147) ) {
						alt130=3;
					}
					else if ( (LA130_24==141) ) {
						alt130=4;
					}

					else {
						int nvaeMark = input.mark();
						try {
							for (int nvaeConsume = 0; nvaeConsume < 3 - 1; nvaeConsume++) {
								input.consume();
							}
							NoViableAltException nvae =
								new NoViableAltException("", 130, 24, input);
							throw nvae;
						} finally {
							input.rewind(nvaeMark);
						}
					}

					}
					break;
				case K_CONTAINS:
					{
					alt130=5;
					}
					break;
				default:
					int nvaeMark = input.mark();
					try {
						input.consume();
						NoViableAltException nvae =
							new NoViableAltException("", 130, 18, input);
						throw nvae;
					} finally {
						input.rewind(nvaeMark);
					}
				}
				}
				break;
			case K_TIMEUUID:
				{
				switch ( input.LA(2) ) {
				case 140:
				case 149:
				case 150:
				case 151:
				case 152:
				case 153:
					{
					alt130=1;
					}
					break;
				case K_IN:
					{
					int LA130_24 = input.LA(3);
					if ( (LA130_24==QMARK||LA130_24==147) ) {
						alt130=3;
					}
					else if ( (LA130_24==141) ) {
						alt130=4;
					}

					else {
						int nvaeMark = input.mark();
						try {
							for (int nvaeConsume = 0; nvaeConsume < 3 - 1; nvaeConsume++) {
								input.consume();
							}
							NoViableAltException nvae =
								new NoViableAltException("", 130, 24, input);
							throw nvae;
						} finally {
							input.rewind(nvaeMark);
						}
					}

					}
					break;
				case K_CONTAINS:
					{
					alt130=5;
					}
					break;
				default:
					int nvaeMark = input.mark();
					try {
						input.consume();
						NoViableAltException nvae =
							new NoViableAltException("", 130, 19, input);
						throw nvae;
					} finally {
						input.rewind(nvaeMark);
					}
				}
				}
				break;
			case K_COUNT:
			case K_KEY:
			case K_TTL:
			case K_WRITETIME:
				{
				switch ( input.LA(2) ) {
				case 140:
				case 149:
				case 150:
				case 151:
				case 152:
				case 153:
					{
					alt130=1;
					}
					break;
				case K_IN:
					{
					int LA130_24 = input.LA(3);
					if ( (LA130_24==QMARK||LA130_24==147) ) {
						alt130=3;
					}
					else if ( (LA130_24==141) ) {
						alt130=4;
					}

					else {
						int nvaeMark = input.mark();
						try {
							for (int nvaeConsume = 0; nvaeConsume < 3 - 1; nvaeConsume++) {
								input.consume();
							}
							NoViableAltException nvae =
								new NoViableAltException("", 130, 24, input);
							throw nvae;
						} finally {
							input.rewind(nvaeMark);
						}
					}

					}
					break;
				case K_CONTAINS:
					{
					alt130=5;
					}
					break;
				default:
					int nvaeMark = input.mark();
					try {
						input.consume();
						NoViableAltException nvae =
							new NoViableAltException("", 130, 20, input);
						throw nvae;
					} finally {
						input.rewind(nvaeMark);
					}
				}
				}
				break;
			case K_TOKEN:
				{
				alt130=2;
				}
				break;
			case 141:
				{
				switch ( input.LA(2) ) {
				case IDENT:
					{
					int LA130_26 = input.LA(3);
					if ( (LA130_26==142||LA130_26==144) ) {
						alt130=6;
					}
					else if ( (LA130_26==K_CONTAINS||LA130_26==K_IN||LA130_26==140||(LA130_26 >= 149 && LA130_26 <= 153)) ) {
						alt130=7;
					}

					else {
						int nvaeMark = input.mark();
						try {
							for (int nvaeConsume = 0; nvaeConsume < 3 - 1; nvaeConsume++) {
								input.consume();
							}
							NoViableAltException nvae =
								new NoViableAltException("", 130, 26, input);
							throw nvae;
						} finally {
							input.rewind(nvaeMark);
						}
					}

					}
					break;
				case QUOTED_NAME:
					{
					int LA130_27 = input.LA(3);
					if ( (LA130_27==142||LA130_27==144) ) {
						alt130=6;
					}
					else if ( (LA130_27==K_CONTAINS||LA130_27==K_IN||LA130_27==140||(LA130_27 >= 149 && LA130_27 <= 153)) ) {
						alt130=7;
					}

					else {
						int nvaeMark = input.mark();
						try {
							for (int nvaeConsume = 0; nvaeConsume < 3 - 1; nvaeConsume++) {
								input.consume();
							}
							NoViableAltException nvae =
								new NoViableAltException("", 130, 27, input);
							throw nvae;
						} finally {
							input.rewind(nvaeMark);
						}
					}

					}
					break;
				case K_ALL:
				case K_AS:
				case K_CLUSTERING:
				case K_COMPACT:
				case K_CONTAINS:
				case K_CUSTOM:
				case K_DISTINCT:
				case K_EXISTS:
				case K_FILTERING:
				case K_KEYS:
				case K_KEYSPACES:
				case K_LIST:
				case K_MAP:
				case K_NOSUPERUSER:
				case K_PASSWORD:
				case K_PERMISSION:
				case K_PERMISSIONS:
				case K_STATIC:
				case K_STORAGE:
				case K_SUPERUSER:
				case K_TRIGGER:
				case K_TYPE:
				case K_USER:
				case K_USERS:
				case K_VALUES:
					{
					int LA130_28 = input.LA(3);
					if ( (LA130_28==142||LA130_28==144) ) {
						alt130=6;
					}
					else if ( (LA130_28==K_CONTAINS||LA130_28==K_IN||LA130_28==140||(LA130_28 >= 149 && LA130_28 <= 153)) ) {
						alt130=7;
					}

					else {
						int nvaeMark = input.mark();
						try {
							for (int nvaeConsume = 0; nvaeConsume < 3 - 1; nvaeConsume++) {
								input.consume();
							}
							NoViableAltException nvae =
								new NoViableAltException("", 130, 28, input);
							throw nvae;
						} finally {
							input.rewind(nvaeMark);
						}
					}

					}
					break;
				case K_ASCII:
					{
					int LA130_29 = input.LA(3);
					if ( (LA130_29==142||LA130_29==144) ) {
						alt130=6;
					}
					else if ( (LA130_29==K_CONTAINS||LA130_29==K_IN||LA130_29==140||(LA130_29 >= 149 && LA130_29 <= 153)) ) {
						alt130=7;
					}

					else {
						int nvaeMark = input.mark();
						try {
							for (int nvaeConsume = 0; nvaeConsume < 3 - 1; nvaeConsume++) {
								input.consume();
							}
							NoViableAltException nvae =
								new NoViableAltException("", 130, 29, input);
							throw nvae;
						} finally {
							input.rewind(nvaeMark);
						}
					}

					}
					break;
				case K_BIGINT:
					{
					int LA130_30 = input.LA(3);
					if ( (LA130_30==142||LA130_30==144) ) {
						alt130=6;
					}
					else if ( (LA130_30==K_CONTAINS||LA130_30==K_IN||LA130_30==140||(LA130_30 >= 149 && LA130_30 <= 153)) ) {
						alt130=7;
					}

					else {
						int nvaeMark = input.mark();
						try {
							for (int nvaeConsume = 0; nvaeConsume < 3 - 1; nvaeConsume++) {
								input.consume();
							}
							NoViableAltException nvae =
								new NoViableAltException("", 130, 30, input);
							throw nvae;
						} finally {
							input.rewind(nvaeMark);
						}
					}

					}
					break;
				case K_BLOB:
					{
					int LA130_31 = input.LA(3);
					if ( (LA130_31==142||LA130_31==144) ) {
						alt130=6;
					}
					else if ( (LA130_31==K_CONTAINS||LA130_31==K_IN||LA130_31==140||(LA130_31 >= 149 && LA130_31 <= 153)) ) {
						alt130=7;
					}

					else {
						int nvaeMark = input.mark();
						try {
							for (int nvaeConsume = 0; nvaeConsume < 3 - 1; nvaeConsume++) {
								input.consume();
							}
							NoViableAltException nvae =
								new NoViableAltException("", 130, 31, input);
							throw nvae;
						} finally {
							input.rewind(nvaeMark);
						}
					}

					}
					break;
				case K_BOOLEAN:
					{
					int LA130_32 = input.LA(3);
					if ( (LA130_32==142||LA130_32==144) ) {
						alt130=6;
					}
					else if ( (LA130_32==K_CONTAINS||LA130_32==K_IN||LA130_32==140||(LA130_32 >= 149 && LA130_32 <= 153)) ) {
						alt130=7;
					}

					else {
						int nvaeMark = input.mark();
						try {
							for (int nvaeConsume = 0; nvaeConsume < 3 - 1; nvaeConsume++) {
								input.consume();
							}
							NoViableAltException nvae =
								new NoViableAltException("", 130, 32, input);
							throw nvae;
						} finally {
							input.rewind(nvaeMark);
						}
					}

					}
					break;
				case K_COUNTER:
					{
					int LA130_33 = input.LA(3);
					if ( (LA130_33==142||LA130_33==144) ) {
						alt130=6;
					}
					else if ( (LA130_33==K_CONTAINS||LA130_33==K_IN||LA130_33==140||(LA130_33 >= 149 && LA130_33 <= 153)) ) {
						alt130=7;
					}

					else {
						int nvaeMark = input.mark();
						try {
							for (int nvaeConsume = 0; nvaeConsume < 3 - 1; nvaeConsume++) {
								input.consume();
							}
							NoViableAltException nvae =
								new NoViableAltException("", 130, 33, input);
							throw nvae;
						} finally {
							input.rewind(nvaeMark);
						}
					}

					}
					break;
				case K_DECIMAL:
					{
					int LA130_34 = input.LA(3);
					if ( (LA130_34==142||LA130_34==144) ) {
						alt130=6;
					}
					else if ( (LA130_34==K_CONTAINS||LA130_34==K_IN||LA130_34==140||(LA130_34 >= 149 && LA130_34 <= 153)) ) {
						alt130=7;
					}

					else {
						int nvaeMark = input.mark();
						try {
							for (int nvaeConsume = 0; nvaeConsume < 3 - 1; nvaeConsume++) {
								input.consume();
							}
							NoViableAltException nvae =
								new NoViableAltException("", 130, 34, input);
							throw nvae;
						} finally {
							input.rewind(nvaeMark);
						}
					}

					}
					break;
				case K_DOUBLE:
					{
					int LA130_35 = input.LA(3);
					if ( (LA130_35==142||LA130_35==144) ) {
						alt130=6;
					}
					else if ( (LA130_35==K_CONTAINS||LA130_35==K_IN||LA130_35==140||(LA130_35 >= 149 && LA130_35 <= 153)) ) {
						alt130=7;
					}

					else {
						int nvaeMark = input.mark();
						try {
							for (int nvaeConsume = 0; nvaeConsume < 3 - 1; nvaeConsume++) {
								input.consume();
							}
							NoViableAltException nvae =
								new NoViableAltException("", 130, 35, input);
							throw nvae;
						} finally {
							input.rewind(nvaeMark);
						}
					}

					}
					break;
				case K_FLOAT:
					{
					int LA130_36 = input.LA(3);
					if ( (LA130_36==142||LA130_36==144) ) {
						alt130=6;
					}
					else if ( (LA130_36==K_CONTAINS||LA130_36==K_IN||LA130_36==140||(LA130_36 >= 149 && LA130_36 <= 153)) ) {
						alt130=7;
					}

					else {
						int nvaeMark = input.mark();
						try {
							for (int nvaeConsume = 0; nvaeConsume < 3 - 1; nvaeConsume++) {
								input.consume();
							}
							NoViableAltException nvae =
								new NoViableAltException("", 130, 36, input);
							throw nvae;
						} finally {
							input.rewind(nvaeMark);
						}
					}

					}
					break;
				case K_INET:
					{
					int LA130_37 = input.LA(3);
					if ( (LA130_37==142||LA130_37==144) ) {
						alt130=6;
					}
					else if ( (LA130_37==K_CONTAINS||LA130_37==K_IN||LA130_37==140||(LA130_37 >= 149 && LA130_37 <= 153)) ) {
						alt130=7;
					}

					else {
						int nvaeMark = input.mark();
						try {
							for (int nvaeConsume = 0; nvaeConsume < 3 - 1; nvaeConsume++) {
								input.consume();
							}
							NoViableAltException nvae =
								new NoViableAltException("", 130, 37, input);
							throw nvae;
						} finally {
							input.rewind(nvaeMark);
						}
					}

					}
					break;
				case K_INT:
					{
					int LA130_38 = input.LA(3);
					if ( (LA130_38==142||LA130_38==144) ) {
						alt130=6;
					}
					else if ( (LA130_38==K_CONTAINS||LA130_38==K_IN||LA130_38==140||(LA130_38 >= 149 && LA130_38 <= 153)) ) {
						alt130=7;
					}

					else {
						int nvaeMark = input.mark();
						try {
							for (int nvaeConsume = 0; nvaeConsume < 3 - 1; nvaeConsume++) {
								input.consume();
							}
							NoViableAltException nvae =
								new NoViableAltException("", 130, 38, input);
							throw nvae;
						} finally {
							input.rewind(nvaeMark);
						}
					}

					}
					break;
				case K_TEXT:
					{
					int LA130_39 = input.LA(3);
					if ( (LA130_39==142||LA130_39==144) ) {
						alt130=6;
					}
					else if ( (LA130_39==K_CONTAINS||LA130_39==K_IN||LA130_39==140||(LA130_39 >= 149 && LA130_39 <= 153)) ) {
						alt130=7;
					}

					else {
						int nvaeMark = input.mark();
						try {
							for (int nvaeConsume = 0; nvaeConsume < 3 - 1; nvaeConsume++) {
								input.consume();
							}
							NoViableAltException nvae =
								new NoViableAltException("", 130, 39, input);
							throw nvae;
						} finally {
							input.rewind(nvaeMark);
						}
					}

					}
					break;
				case K_TIMESTAMP:
					{
					int LA130_40 = input.LA(3);
					if ( (LA130_40==142||LA130_40==144) ) {
						alt130=6;
					}
					else if ( (LA130_40==K_CONTAINS||LA130_40==K_IN||LA130_40==140||(LA130_40 >= 149 && LA130_40 <= 153)) ) {
						alt130=7;
					}

					else {
						int nvaeMark = input.mark();
						try {
							for (int nvaeConsume = 0; nvaeConsume < 3 - 1; nvaeConsume++) {
								input.consume();
							}
							NoViableAltException nvae =
								new NoViableAltException("", 130, 40, input);
							throw nvae;
						} finally {
							input.rewind(nvaeMark);
						}
					}

					}
					break;
				case K_UUID:
					{
					int LA130_41 = input.LA(3);
					if ( (LA130_41==142||LA130_41==144) ) {
						alt130=6;
					}
					else if ( (LA130_41==K_CONTAINS||LA130_41==K_IN||LA130_41==140||(LA130_41 >= 149 && LA130_41 <= 153)) ) {
						alt130=7;
					}

					else {
						int nvaeMark = input.mark();
						try {
							for (int nvaeConsume = 0; nvaeConsume < 3 - 1; nvaeConsume++) {
								input.consume();
							}
							NoViableAltException nvae =
								new NoViableAltException("", 130, 41, input);
							throw nvae;
						} finally {
							input.rewind(nvaeMark);
						}
					}

					}
					break;
				case K_VARCHAR:
					{
					int LA130_42 = input.LA(3);
					if ( (LA130_42==142||LA130_42==144) ) {
						alt130=6;
					}
					else if ( (LA130_42==K_CONTAINS||LA130_42==K_IN||LA130_42==140||(LA130_42 >= 149 && LA130_42 <= 153)) ) {
						alt130=7;
					}

					else {
						int nvaeMark = input.mark();
						try {
							for (int nvaeConsume = 0; nvaeConsume < 3 - 1; nvaeConsume++) {
								input.consume();
							}
							NoViableAltException nvae =
								new NoViableAltException("", 130, 42, input);
							throw nvae;
						} finally {
							input.rewind(nvaeMark);
						}
					}

					}
					break;
				case K_VARINT:
					{
					int LA130_43 = input.LA(3);
					if ( (LA130_43==142||LA130_43==144) ) {
						alt130=6;
					}
					else if ( (LA130_43==K_CONTAINS||LA130_43==K_IN||LA130_43==140||(LA130_43 >= 149 && LA130_43 <= 153)) ) {
						alt130=7;
					}

					else {
						int nvaeMark = input.mark();
						try {
							for (int nvaeConsume = 0; nvaeConsume < 3 - 1; nvaeConsume++) {
								input.consume();
							}
							NoViableAltException nvae =
								new NoViableAltException("", 130, 43, input);
							throw nvae;
						} finally {
							input.rewind(nvaeMark);
						}
					}

					}
					break;
				case K_TIMEUUID:
					{
					int LA130_44 = input.LA(3);
					if ( (LA130_44==142||LA130_44==144) ) {
						alt130=6;
					}
					else if ( (LA130_44==K_CONTAINS||LA130_44==K_IN||LA130_44==140||(LA130_44 >= 149 && LA130_44 <= 153)) ) {
						alt130=7;
					}

					else {
						int nvaeMark = input.mark();
						try {
							for (int nvaeConsume = 0; nvaeConsume < 3 - 1; nvaeConsume++) {
								input.consume();
							}
							NoViableAltException nvae =
								new NoViableAltException("", 130, 44, input);
							throw nvae;
						} finally {
							input.rewind(nvaeMark);
						}
					}

					}
					break;
				case K_COUNT:
				case K_KEY:
				case K_TTL:
				case K_WRITETIME:
					{
					int LA130_45 = input.LA(3);
					if ( (LA130_45==142||LA130_45==144) ) {
						alt130=6;
					}
					else if ( (LA130_45==K_CONTAINS||LA130_45==K_IN||LA130_45==140||(LA130_45 >= 149 && LA130_45 <= 153)) ) {
						alt130=7;
					}

					else {
						int nvaeMark = input.mark();
						try {
							for (int nvaeConsume = 0; nvaeConsume < 3 - 1; nvaeConsume++) {
								input.consume();
							}
							NoViableAltException nvae =
								new NoViableAltException("", 130, 45, input);
							throw nvae;
						} finally {
							input.rewind(nvaeMark);
						}
					}

					}
					break;
				case K_TOKEN:
				case 141:
					{
					alt130=7;
					}
					break;
				default:
					int nvaeMark = input.mark();
					try {
						input.consume();
						NoViableAltException nvae =
							new NoViableAltException("", 130, 22, input);
						throw nvae;
					} finally {
						input.rewind(nvaeMark);
					}
				}
				}
				break;
			default:
				NoViableAltException nvae =
					new NoViableAltException("", 130, 0, input);
				throw nvae;
			}
			switch (alt130) {
				case 1 :
					// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1035:7: name= cident type= relationType t= term
					{
					pushFollow(FOLLOW_cident_in_relation6759);
					name=cident();
					state._fsp--;

					pushFollow(FOLLOW_relationType_in_relation6763);
					type=relationType();
					state._fsp--;

					pushFollow(FOLLOW_term_in_relation6767);
					t=term();
					state._fsp--;

					 clauses.add(new SingleColumnRelation(name, type, t)); 
					}
					break;
				case 2 :
					// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1036:7: K_TOKEN l= tupleOfIdentifiers type= relationType t= term
					{
					match(input,K_TOKEN,FOLLOW_K_TOKEN_in_relation6777); 
					pushFollow(FOLLOW_tupleOfIdentifiers_in_relation6781);
					l=tupleOfIdentifiers();
					state._fsp--;

					pushFollow(FOLLOW_relationType_in_relation6785);
					type=relationType();
					state._fsp--;

					pushFollow(FOLLOW_term_in_relation6789);
					t=term();
					state._fsp--;


					            for (ColumnIdentifier.Raw id : l)
					                clauses.add(new SingleColumnRelation(id, type, t, true));
					        
					}
					break;
				case 3 :
					// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1041:7: name= cident K_IN marker= inMarker
					{
					pushFollow(FOLLOW_cident_in_relation6809);
					name=cident();
					state._fsp--;

					match(input,K_IN,FOLLOW_K_IN_in_relation6811); 
					pushFollow(FOLLOW_inMarker_in_relation6815);
					marker=inMarker();
					state._fsp--;

					 clauses.add(new SingleColumnRelation(name, Operator.IN, marker)); 
					}
					break;
				case 4 :
					// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1043:7: name= cident K_IN inValues= singleColumnInValues
					{
					pushFollow(FOLLOW_cident_in_relation6835);
					name=cident();
					state._fsp--;

					match(input,K_IN,FOLLOW_K_IN_in_relation6837); 
					pushFollow(FOLLOW_singleColumnInValues_in_relation6841);
					inValues=singleColumnInValues();
					state._fsp--;

					 clauses.add(SingleColumnRelation.createInRelation(name, inValues)); 
					}
					break;
				case 5 :
					// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1045:7: name= cident K_CONTAINS ( K_KEY )? t= term
					{
					pushFollow(FOLLOW_cident_in_relation6861);
					name=cident();
					state._fsp--;

					match(input,K_CONTAINS,FOLLOW_K_CONTAINS_in_relation6863); 
					 Operator rt = Operator.CONTAINS; 
					// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1045:67: ( K_KEY )?
					int alt127=2;
					int LA127_0 = input.LA(1);
					if ( (LA127_0==K_KEY) ) {
						alt127=1;
					}
					switch (alt127) {
						case 1 :
							// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1045:68: K_KEY
							{
							match(input,K_KEY,FOLLOW_K_KEY_in_relation6868); 
							 rt = Operator.CONTAINS_KEY; 
							}
							break;

					}

					pushFollow(FOLLOW_term_in_relation6884);
					t=term();
					state._fsp--;

					 clauses.add(new SingleColumnRelation(name, rt, t)); 
					}
					break;
				case 6 :
					// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1047:7: ids= tupleOfIdentifiers ( K_IN ( '(' ')' |tupleInMarker= inMarkerForTuple |literals= tupleOfTupleLiterals |markers= tupleOfMarkersForTuples ) |type= relationType literal= tupleLiteral |type= relationType tupleMarker= markerForTuple )
					{
					pushFollow(FOLLOW_tupleOfIdentifiers_in_relation6896);
					ids=tupleOfIdentifiers();
					state._fsp--;

					// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1048:7: ( K_IN ( '(' ')' |tupleInMarker= inMarkerForTuple |literals= tupleOfTupleLiterals |markers= tupleOfMarkersForTuples ) |type= relationType literal= tupleLiteral |type= relationType tupleMarker= markerForTuple )
					int alt129=3;
					switch ( input.LA(1) ) {
					case K_IN:
						{
						alt129=1;
						}
						break;
					case 151:
						{
						int LA129_2 = input.LA(2);
						if ( (LA129_2==141) ) {
							alt129=2;
						}
						else if ( (LA129_2==QMARK||LA129_2==147) ) {
							alt129=3;
						}

						else {
							int nvaeMark = input.mark();
							try {
								input.consume();
								NoViableAltException nvae =
									new NoViableAltException("", 129, 2, input);
								throw nvae;
							} finally {
								input.rewind(nvaeMark);
							}
						}

						}
						break;
					case 149:
						{
						int LA129_3 = input.LA(2);
						if ( (LA129_3==141) ) {
							alt129=2;
						}
						else if ( (LA129_3==QMARK||LA129_3==147) ) {
							alt129=3;
						}

						else {
							int nvaeMark = input.mark();
							try {
								input.consume();
								NoViableAltException nvae =
									new NoViableAltException("", 129, 3, input);
								throw nvae;
							} finally {
								input.rewind(nvaeMark);
							}
						}

						}
						break;
					case 150:
						{
						int LA129_4 = input.LA(2);
						if ( (LA129_4==141) ) {
							alt129=2;
						}
						else if ( (LA129_4==QMARK||LA129_4==147) ) {
							alt129=3;
						}

						else {
							int nvaeMark = input.mark();
							try {
								input.consume();
								NoViableAltException nvae =
									new NoViableAltException("", 129, 4, input);
								throw nvae;
							} finally {
								input.rewind(nvaeMark);
							}
						}

						}
						break;
					case 152:
						{
						int LA129_5 = input.LA(2);
						if ( (LA129_5==141) ) {
							alt129=2;
						}
						else if ( (LA129_5==QMARK||LA129_5==147) ) {
							alt129=3;
						}

						else {
							int nvaeMark = input.mark();
							try {
								input.consume();
								NoViableAltException nvae =
									new NoViableAltException("", 129, 5, input);
								throw nvae;
							} finally {
								input.rewind(nvaeMark);
							}
						}

						}
						break;
					case 153:
						{
						int LA129_6 = input.LA(2);
						if ( (LA129_6==141) ) {
							alt129=2;
						}
						else if ( (LA129_6==QMARK||LA129_6==147) ) {
							alt129=3;
						}

						else {
							int nvaeMark = input.mark();
							try {
								input.consume();
								NoViableAltException nvae =
									new NoViableAltException("", 129, 6, input);
								throw nvae;
							} finally {
								input.rewind(nvaeMark);
							}
						}

						}
						break;
					case 140:
						{
						int LA129_7 = input.LA(2);
						if ( (LA129_7==141) ) {
							alt129=2;
						}
						else if ( (LA129_7==QMARK||LA129_7==147) ) {
							alt129=3;
						}

						else {
							int nvaeMark = input.mark();
							try {
								input.consume();
								NoViableAltException nvae =
									new NoViableAltException("", 129, 7, input);
								throw nvae;
							} finally {
								input.rewind(nvaeMark);
							}
						}

						}
						break;
					default:
						NoViableAltException nvae =
							new NoViableAltException("", 129, 0, input);
						throw nvae;
					}
					switch (alt129) {
						case 1 :
							// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1048:9: K_IN ( '(' ')' |tupleInMarker= inMarkerForTuple |literals= tupleOfTupleLiterals |markers= tupleOfMarkersForTuples )
							{
							match(input,K_IN,FOLLOW_K_IN_in_relation6906); 
							// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1049:11: ( '(' ')' |tupleInMarker= inMarkerForTuple |literals= tupleOfTupleLiterals |markers= tupleOfMarkersForTuples )
							int alt128=4;
							int LA128_0 = input.LA(1);
							if ( (LA128_0==141) ) {
								switch ( input.LA(2) ) {
								case 142:
									{
									alt128=1;
									}
									break;
								case 141:
									{
									alt128=3;
									}
									break;
								case QMARK:
								case 147:
									{
									alt128=4;
									}
									break;
								default:
									int nvaeMark = input.mark();
									try {
										input.consume();
										NoViableAltException nvae =
											new NoViableAltException("", 128, 1, input);
										throw nvae;
									} finally {
										input.rewind(nvaeMark);
									}
								}
							}
							else if ( (LA128_0==QMARK||LA128_0==147) ) {
								alt128=2;
							}

							else {
								NoViableAltException nvae =
									new NoViableAltException("", 128, 0, input);
								throw nvae;
							}

							switch (alt128) {
								case 1 :
									// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1049:13: '(' ')'
									{
									match(input,141,FOLLOW_141_in_relation6920); 
									match(input,142,FOLLOW_142_in_relation6922); 
									 clauses.add(MultiColumnRelation.createInRelation(ids, new ArrayList<Tuples.Literal>())); 
									}
									break;
								case 2 :
									// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1051:13: tupleInMarker= inMarkerForTuple
									{
									pushFollow(FOLLOW_inMarkerForTuple_in_relation6954);
									tupleInMarker=inMarkerForTuple();
									state._fsp--;

									 clauses.add(MultiColumnRelation.createSingleMarkerInRelation(ids, tupleInMarker)); 
									}
									break;
								case 3 :
									// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1053:13: literals= tupleOfTupleLiterals
									{
									pushFollow(FOLLOW_tupleOfTupleLiterals_in_relation6988);
									literals=tupleOfTupleLiterals();
									state._fsp--;


									                  clauses.add(MultiColumnRelation.createInRelation(ids, literals));
									              
									}
									break;
								case 4 :
									// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1057:13: markers= tupleOfMarkersForTuples
									{
									pushFollow(FOLLOW_tupleOfMarkersForTuples_in_relation7022);
									markers=tupleOfMarkersForTuples();
									state._fsp--;

									 clauses.add(MultiColumnRelation.createInRelation(ids, markers)); 
									}
									break;

							}

							}
							break;
						case 2 :
							// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1060:9: type= relationType literal= tupleLiteral
							{
							pushFollow(FOLLOW_relationType_in_relation7064);
							type=relationType();
							state._fsp--;

							pushFollow(FOLLOW_tupleLiteral_in_relation7068);
							literal=tupleLiteral();
							state._fsp--;


							              clauses.add(MultiColumnRelation.createNonInRelation(ids, type, literal));
							          
							}
							break;
						case 3 :
							// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1064:9: type= relationType tupleMarker= markerForTuple
							{
							pushFollow(FOLLOW_relationType_in_relation7094);
							type=relationType();
							state._fsp--;

							pushFollow(FOLLOW_markerForTuple_in_relation7098);
							tupleMarker=markerForTuple();
							state._fsp--;

							 clauses.add(MultiColumnRelation.createNonInRelation(ids, type, tupleMarker)); 
							}
							break;

					}

					}
					break;
				case 7 :
					// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1067:7: '(' relation[$clauses] ')'
					{
					match(input,141,FOLLOW_141_in_relation7128); 
					pushFollow(FOLLOW_relation_in_relation7130);
					relation(clauses);
					state._fsp--;

					match(input,142,FOLLOW_142_in_relation7133); 
					}
					break;

			}
		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "relation"



	// $ANTLR start "inMarker"
	// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1070:1: inMarker returns [AbstractMarker.INRaw marker] : ( QMARK | ':' name= ident );
	public final AbstractMarker.INRaw inMarker() throws RecognitionException {
		AbstractMarker.INRaw marker = null;


		ColumnIdentifier name =null;

		try {
			// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1071:5: ( QMARK | ':' name= ident )
			int alt131=2;
			int LA131_0 = input.LA(1);
			if ( (LA131_0==QMARK) ) {
				alt131=1;
			}
			else if ( (LA131_0==147) ) {
				alt131=2;
			}

			else {
				NoViableAltException nvae =
					new NoViableAltException("", 131, 0, input);
				throw nvae;
			}

			switch (alt131) {
				case 1 :
					// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1071:7: QMARK
					{
					match(input,QMARK,FOLLOW_QMARK_in_inMarker7154); 
					 marker = newINBindVariables(null); 
					}
					break;
				case 2 :
					// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1072:7: ':' name= ident
					{
					match(input,147,FOLLOW_147_in_inMarker7164); 
					pushFollow(FOLLOW_ident_in_inMarker7168);
					name=ident();
					state._fsp--;

					 marker = newINBindVariables(name); 
					}
					break;

			}
		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return marker;
	}
	// $ANTLR end "inMarker"



	// $ANTLR start "tupleOfIdentifiers"
	// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1075:1: tupleOfIdentifiers returns [List<ColumnIdentifier.Raw> ids] : '(' n1= cident ( ',' ni= cident )* ')' ;
	public final List<ColumnIdentifier.Raw> tupleOfIdentifiers() throws RecognitionException {
		List<ColumnIdentifier.Raw> ids = null;


		ColumnIdentifier.Raw n1 =null;
		ColumnIdentifier.Raw ni =null;

		 ids = new ArrayList<ColumnIdentifier.Raw>(); 
		try {
			// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1077:5: ( '(' n1= cident ( ',' ni= cident )* ')' )
			// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1077:7: '(' n1= cident ( ',' ni= cident )* ')'
			{
			match(input,141,FOLLOW_141_in_tupleOfIdentifiers7200); 
			pushFollow(FOLLOW_cident_in_tupleOfIdentifiers7204);
			n1=cident();
			state._fsp--;

			 ids.add(n1); 
			// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1077:39: ( ',' ni= cident )*
			loop132:
			while (true) {
				int alt132=2;
				int LA132_0 = input.LA(1);
				if ( (LA132_0==144) ) {
					alt132=1;
				}

				switch (alt132) {
				case 1 :
					// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1077:40: ',' ni= cident
					{
					match(input,144,FOLLOW_144_in_tupleOfIdentifiers7209); 
					pushFollow(FOLLOW_cident_in_tupleOfIdentifiers7213);
					ni=cident();
					state._fsp--;

					 ids.add(ni); 
					}
					break;

				default :
					break loop132;
				}
			}

			match(input,142,FOLLOW_142_in_tupleOfIdentifiers7219); 
			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return ids;
	}
	// $ANTLR end "tupleOfIdentifiers"



	// $ANTLR start "singleColumnInValues"
	// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1080:1: singleColumnInValues returns [List<Term.Raw> terms] : '(' (t1= term ( ',' ti= term )* )? ')' ;
	public final List<Term.Raw> singleColumnInValues() throws RecognitionException {
		List<Term.Raw> terms = null;


		Term.Raw t1 =null;
		Term.Raw ti =null;

		 terms = new ArrayList<Term.Raw>(); 
		try {
			// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1082:5: ( '(' (t1= term ( ',' ti= term )* )? ')' )
			// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1082:7: '(' (t1= term ( ',' ti= term )* )? ')'
			{
			match(input,141,FOLLOW_141_in_singleColumnInValues7249); 
			// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1082:11: (t1= term ( ',' ti= term )* )?
			int alt134=2;
			int LA134_0 = input.LA(1);
			if ( (LA134_0==BOOLEAN||LA134_0==FLOAT||LA134_0==HEXNUMBER||(LA134_0 >= IDENT && LA134_0 <= INTEGER)||LA134_0==K_ALL||LA134_0==K_AS||LA134_0==K_ASCII||(LA134_0 >= K_BIGINT && LA134_0 <= K_BOOLEAN)||LA134_0==K_CLUSTERING||(LA134_0 >= K_COMPACT && LA134_0 <= K_CONTAINS)||LA134_0==K_COUNTER||(LA134_0 >= K_CUSTOM && LA134_0 <= K_DECIMAL)||(LA134_0 >= K_DISTINCT && LA134_0 <= K_DOUBLE)||(LA134_0 >= K_EXISTS && LA134_0 <= K_FLOAT)||(LA134_0 >= K_INET && LA134_0 <= K_INFINITY)||LA134_0==K_INT||LA134_0==K_KEYS||LA134_0==K_KEYSPACES||(LA134_0 >= K_LIST && LA134_0 <= K_MAP)||LA134_0==K_NAN||LA134_0==K_NOSUPERUSER||LA134_0==K_NULL||(LA134_0 >= K_PASSWORD && LA134_0 <= K_PERMISSIONS)||(LA134_0 >= K_STATIC && LA134_0 <= K_TIMEUUID)||(LA134_0 >= K_TOKEN && LA134_0 <= K_TRIGGER)||LA134_0==K_TYPE||(LA134_0 >= K_USER && LA134_0 <= K_USERS)||(LA134_0 >= K_UUID && LA134_0 <= K_VARINT)||LA134_0==QMARK||LA134_0==STRING_LITERAL||LA134_0==UUID||LA134_0==141||LA134_0==145||LA134_0==147||LA134_0==154||LA134_0==157) ) {
				alt134=1;
			}
			switch (alt134) {
				case 1 :
					// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1082:13: t1= term ( ',' ti= term )*
					{
					pushFollow(FOLLOW_term_in_singleColumnInValues7257);
					t1=term();
					state._fsp--;

					 terms.add(t1); 
					// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1082:43: ( ',' ti= term )*
					loop133:
					while (true) {
						int alt133=2;
						int LA133_0 = input.LA(1);
						if ( (LA133_0==144) ) {
							alt133=1;
						}

						switch (alt133) {
						case 1 :
							// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1082:44: ',' ti= term
							{
							match(input,144,FOLLOW_144_in_singleColumnInValues7262); 
							pushFollow(FOLLOW_term_in_singleColumnInValues7266);
							ti=term();
							state._fsp--;

							 terms.add(ti); 
							}
							break;

						default :
							break loop133;
						}
					}

					}
					break;

			}

			match(input,142,FOLLOW_142_in_singleColumnInValues7275); 
			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return terms;
	}
	// $ANTLR end "singleColumnInValues"



	// $ANTLR start "tupleOfTupleLiterals"
	// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1085:1: tupleOfTupleLiterals returns [List<Tuples.Literal> literals] : '(' t1= tupleLiteral ( ',' ti= tupleLiteral )* ')' ;
	public final List<Tuples.Literal> tupleOfTupleLiterals() throws RecognitionException {
		List<Tuples.Literal> literals = null;


		Tuples.Literal t1 =null;
		Tuples.Literal ti =null;

		 literals = new ArrayList<>(); 
		try {
			// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1087:5: ( '(' t1= tupleLiteral ( ',' ti= tupleLiteral )* ')' )
			// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1087:7: '(' t1= tupleLiteral ( ',' ti= tupleLiteral )* ')'
			{
			match(input,141,FOLLOW_141_in_tupleOfTupleLiterals7305); 
			pushFollow(FOLLOW_tupleLiteral_in_tupleOfTupleLiterals7309);
			t1=tupleLiteral();
			state._fsp--;

			 literals.add(t1); 
			// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1087:50: ( ',' ti= tupleLiteral )*
			loop135:
			while (true) {
				int alt135=2;
				int LA135_0 = input.LA(1);
				if ( (LA135_0==144) ) {
					alt135=1;
				}

				switch (alt135) {
				case 1 :
					// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1087:51: ',' ti= tupleLiteral
					{
					match(input,144,FOLLOW_144_in_tupleOfTupleLiterals7314); 
					pushFollow(FOLLOW_tupleLiteral_in_tupleOfTupleLiterals7318);
					ti=tupleLiteral();
					state._fsp--;

					 literals.add(ti); 
					}
					break;

				default :
					break loop135;
				}
			}

			match(input,142,FOLLOW_142_in_tupleOfTupleLiterals7324); 
			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return literals;
	}
	// $ANTLR end "tupleOfTupleLiterals"



	// $ANTLR start "markerForTuple"
	// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1090:1: markerForTuple returns [Tuples.Raw marker] : ( QMARK | ':' name= ident );
	public final Tuples.Raw markerForTuple() throws RecognitionException {
		Tuples.Raw marker = null;


		ColumnIdentifier name =null;

		try {
			// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1091:5: ( QMARK | ':' name= ident )
			int alt136=2;
			int LA136_0 = input.LA(1);
			if ( (LA136_0==QMARK) ) {
				alt136=1;
			}
			else if ( (LA136_0==147) ) {
				alt136=2;
			}

			else {
				NoViableAltException nvae =
					new NoViableAltException("", 136, 0, input);
				throw nvae;
			}

			switch (alt136) {
				case 1 :
					// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1091:7: QMARK
					{
					match(input,QMARK,FOLLOW_QMARK_in_markerForTuple7345); 
					 marker = newTupleBindVariables(null); 
					}
					break;
				case 2 :
					// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1092:7: ':' name= ident
					{
					match(input,147,FOLLOW_147_in_markerForTuple7355); 
					pushFollow(FOLLOW_ident_in_markerForTuple7359);
					name=ident();
					state._fsp--;

					 marker = newTupleBindVariables(name); 
					}
					break;

			}
		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return marker;
	}
	// $ANTLR end "markerForTuple"



	// $ANTLR start "tupleOfMarkersForTuples"
	// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1095:1: tupleOfMarkersForTuples returns [List<Tuples.Raw> markers] : '(' m1= markerForTuple ( ',' mi= markerForTuple )* ')' ;
	public final List<Tuples.Raw> tupleOfMarkersForTuples() throws RecognitionException {
		List<Tuples.Raw> markers = null;


		Tuples.Raw m1 =null;
		Tuples.Raw mi =null;

		 markers = new ArrayList<Tuples.Raw>(); 
		try {
			// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1097:5: ( '(' m1= markerForTuple ( ',' mi= markerForTuple )* ')' )
			// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1097:7: '(' m1= markerForTuple ( ',' mi= markerForTuple )* ')'
			{
			match(input,141,FOLLOW_141_in_tupleOfMarkersForTuples7391); 
			pushFollow(FOLLOW_markerForTuple_in_tupleOfMarkersForTuples7395);
			m1=markerForTuple();
			state._fsp--;

			 markers.add(m1); 
			// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1097:51: ( ',' mi= markerForTuple )*
			loop137:
			while (true) {
				int alt137=2;
				int LA137_0 = input.LA(1);
				if ( (LA137_0==144) ) {
					alt137=1;
				}

				switch (alt137) {
				case 1 :
					// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1097:52: ',' mi= markerForTuple
					{
					match(input,144,FOLLOW_144_in_tupleOfMarkersForTuples7400); 
					pushFollow(FOLLOW_markerForTuple_in_tupleOfMarkersForTuples7404);
					mi=markerForTuple();
					state._fsp--;

					 markers.add(mi); 
					}
					break;

				default :
					break loop137;
				}
			}

			match(input,142,FOLLOW_142_in_tupleOfMarkersForTuples7410); 
			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return markers;
	}
	// $ANTLR end "tupleOfMarkersForTuples"



	// $ANTLR start "inMarkerForTuple"
	// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1100:1: inMarkerForTuple returns [Tuples.INRaw marker] : ( QMARK | ':' name= ident );
	public final Tuples.INRaw inMarkerForTuple() throws RecognitionException {
		Tuples.INRaw marker = null;


		ColumnIdentifier name =null;

		try {
			// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1101:5: ( QMARK | ':' name= ident )
			int alt138=2;
			int LA138_0 = input.LA(1);
			if ( (LA138_0==QMARK) ) {
				alt138=1;
			}
			else if ( (LA138_0==147) ) {
				alt138=2;
			}

			else {
				NoViableAltException nvae =
					new NoViableAltException("", 138, 0, input);
				throw nvae;
			}

			switch (alt138) {
				case 1 :
					// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1101:7: QMARK
					{
					match(input,QMARK,FOLLOW_QMARK_in_inMarkerForTuple7431); 
					 marker = newTupleINBindVariables(null); 
					}
					break;
				case 2 :
					// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1102:7: ':' name= ident
					{
					match(input,147,FOLLOW_147_in_inMarkerForTuple7441); 
					pushFollow(FOLLOW_ident_in_inMarkerForTuple7445);
					name=ident();
					state._fsp--;

					 marker = newTupleINBindVariables(name); 
					}
					break;

			}
		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return marker;
	}
	// $ANTLR end "inMarkerForTuple"



	// $ANTLR start "comparatorType"
	// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1105:1: comparatorType returns [CQL3Type.Raw t] : (n= native_type |c= collection_type |tt= tuple_type |id= userTypeName | K_FROZEN '<' f= comparatorType '>' |s= STRING_LITERAL );
	public final CQL3Type.Raw comparatorType() throws RecognitionException {
		CQL3Type.Raw t = null;


		Token s=null;
		CQL3Type n =null;
		CQL3Type.Raw c =null;
		CQL3Type.Raw tt =null;
		UTName id =null;
		CQL3Type.Raw f =null;

		try {
			// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1106:5: (n= native_type |c= collection_type |tt= tuple_type |id= userTypeName | K_FROZEN '<' f= comparatorType '>' |s= STRING_LITERAL )
			int alt139=6;
			switch ( input.LA(1) ) {
			case K_ASCII:
				{
				int LA139_1 = input.LA(2);
				if ( (LA139_1==EOF||LA139_1==K_PRIMARY||LA139_1==K_STATIC||LA139_1==142||LA139_1==144||LA139_1==148||LA139_1==152) ) {
					alt139=1;
				}
				else if ( (LA139_1==146) ) {
					alt139=4;
				}

				else {
					int nvaeMark = input.mark();
					try {
						input.consume();
						NoViableAltException nvae =
							new NoViableAltException("", 139, 1, input);
						throw nvae;
					} finally {
						input.rewind(nvaeMark);
					}
				}

				}
				break;
			case K_BIGINT:
				{
				int LA139_2 = input.LA(2);
				if ( (LA139_2==EOF||LA139_2==K_PRIMARY||LA139_2==K_STATIC||LA139_2==142||LA139_2==144||LA139_2==148||LA139_2==152) ) {
					alt139=1;
				}
				else if ( (LA139_2==146) ) {
					alt139=4;
				}

				else {
					int nvaeMark = input.mark();
					try {
						input.consume();
						NoViableAltException nvae =
							new NoViableAltException("", 139, 2, input);
						throw nvae;
					} finally {
						input.rewind(nvaeMark);
					}
				}

				}
				break;
			case K_BLOB:
				{
				int LA139_3 = input.LA(2);
				if ( (LA139_3==EOF||LA139_3==K_PRIMARY||LA139_3==K_STATIC||LA139_3==142||LA139_3==144||LA139_3==148||LA139_3==152) ) {
					alt139=1;
				}
				else if ( (LA139_3==146) ) {
					alt139=4;
				}

				else {
					int nvaeMark = input.mark();
					try {
						input.consume();
						NoViableAltException nvae =
							new NoViableAltException("", 139, 3, input);
						throw nvae;
					} finally {
						input.rewind(nvaeMark);
					}
				}

				}
				break;
			case K_BOOLEAN:
				{
				int LA139_4 = input.LA(2);
				if ( (LA139_4==EOF||LA139_4==K_PRIMARY||LA139_4==K_STATIC||LA139_4==142||LA139_4==144||LA139_4==148||LA139_4==152) ) {
					alt139=1;
				}
				else if ( (LA139_4==146) ) {
					alt139=4;
				}

				else {
					int nvaeMark = input.mark();
					try {
						input.consume();
						NoViableAltException nvae =
							new NoViableAltException("", 139, 4, input);
						throw nvae;
					} finally {
						input.rewind(nvaeMark);
					}
				}

				}
				break;
			case K_COUNTER:
				{
				int LA139_5 = input.LA(2);
				if ( (LA139_5==EOF||LA139_5==K_PRIMARY||LA139_5==K_STATIC||LA139_5==142||LA139_5==144||LA139_5==148||LA139_5==152) ) {
					alt139=1;
				}
				else if ( (LA139_5==146) ) {
					alt139=4;
				}

				else {
					int nvaeMark = input.mark();
					try {
						input.consume();
						NoViableAltException nvae =
							new NoViableAltException("", 139, 5, input);
						throw nvae;
					} finally {
						input.rewind(nvaeMark);
					}
				}

				}
				break;
			case K_DECIMAL:
				{
				int LA139_6 = input.LA(2);
				if ( (LA139_6==EOF||LA139_6==K_PRIMARY||LA139_6==K_STATIC||LA139_6==142||LA139_6==144||LA139_6==148||LA139_6==152) ) {
					alt139=1;
				}
				else if ( (LA139_6==146) ) {
					alt139=4;
				}

				else {
					int nvaeMark = input.mark();
					try {
						input.consume();
						NoViableAltException nvae =
							new NoViableAltException("", 139, 6, input);
						throw nvae;
					} finally {
						input.rewind(nvaeMark);
					}
				}

				}
				break;
			case K_DOUBLE:
				{
				int LA139_7 = input.LA(2);
				if ( (LA139_7==EOF||LA139_7==K_PRIMARY||LA139_7==K_STATIC||LA139_7==142||LA139_7==144||LA139_7==148||LA139_7==152) ) {
					alt139=1;
				}
				else if ( (LA139_7==146) ) {
					alt139=4;
				}

				else {
					int nvaeMark = input.mark();
					try {
						input.consume();
						NoViableAltException nvae =
							new NoViableAltException("", 139, 7, input);
						throw nvae;
					} finally {
						input.rewind(nvaeMark);
					}
				}

				}
				break;
			case K_FLOAT:
				{
				int LA139_8 = input.LA(2);
				if ( (LA139_8==EOF||LA139_8==K_PRIMARY||LA139_8==K_STATIC||LA139_8==142||LA139_8==144||LA139_8==148||LA139_8==152) ) {
					alt139=1;
				}
				else if ( (LA139_8==146) ) {
					alt139=4;
				}

				else {
					int nvaeMark = input.mark();
					try {
						input.consume();
						NoViableAltException nvae =
							new NoViableAltException("", 139, 8, input);
						throw nvae;
					} finally {
						input.rewind(nvaeMark);
					}
				}

				}
				break;
			case K_INET:
				{
				int LA139_9 = input.LA(2);
				if ( (LA139_9==EOF||LA139_9==K_PRIMARY||LA139_9==K_STATIC||LA139_9==142||LA139_9==144||LA139_9==148||LA139_9==152) ) {
					alt139=1;
				}
				else if ( (LA139_9==146) ) {
					alt139=4;
				}

				else {
					int nvaeMark = input.mark();
					try {
						input.consume();
						NoViableAltException nvae =
							new NoViableAltException("", 139, 9, input);
						throw nvae;
					} finally {
						input.rewind(nvaeMark);
					}
				}

				}
				break;
			case K_INT:
				{
				int LA139_10 = input.LA(2);
				if ( (LA139_10==EOF||LA139_10==K_PRIMARY||LA139_10==K_STATIC||LA139_10==142||LA139_10==144||LA139_10==148||LA139_10==152) ) {
					alt139=1;
				}
				else if ( (LA139_10==146) ) {
					alt139=4;
				}

				else {
					int nvaeMark = input.mark();
					try {
						input.consume();
						NoViableAltException nvae =
							new NoViableAltException("", 139, 10, input);
						throw nvae;
					} finally {
						input.rewind(nvaeMark);
					}
				}

				}
				break;
			case K_TEXT:
				{
				int LA139_11 = input.LA(2);
				if ( (LA139_11==EOF||LA139_11==K_PRIMARY||LA139_11==K_STATIC||LA139_11==142||LA139_11==144||LA139_11==148||LA139_11==152) ) {
					alt139=1;
				}
				else if ( (LA139_11==146) ) {
					alt139=4;
				}

				else {
					int nvaeMark = input.mark();
					try {
						input.consume();
						NoViableAltException nvae =
							new NoViableAltException("", 139, 11, input);
						throw nvae;
					} finally {
						input.rewind(nvaeMark);
					}
				}

				}
				break;
			case K_TIMESTAMP:
				{
				int LA139_12 = input.LA(2);
				if ( (LA139_12==EOF||LA139_12==K_PRIMARY||LA139_12==K_STATIC||LA139_12==142||LA139_12==144||LA139_12==148||LA139_12==152) ) {
					alt139=1;
				}
				else if ( (LA139_12==146) ) {
					alt139=4;
				}

				else {
					int nvaeMark = input.mark();
					try {
						input.consume();
						NoViableAltException nvae =
							new NoViableAltException("", 139, 12, input);
						throw nvae;
					} finally {
						input.rewind(nvaeMark);
					}
				}

				}
				break;
			case K_UUID:
				{
				int LA139_13 = input.LA(2);
				if ( (LA139_13==EOF||LA139_13==K_PRIMARY||LA139_13==K_STATIC||LA139_13==142||LA139_13==144||LA139_13==148||LA139_13==152) ) {
					alt139=1;
				}
				else if ( (LA139_13==146) ) {
					alt139=4;
				}

				else {
					int nvaeMark = input.mark();
					try {
						input.consume();
						NoViableAltException nvae =
							new NoViableAltException("", 139, 13, input);
						throw nvae;
					} finally {
						input.rewind(nvaeMark);
					}
				}

				}
				break;
			case K_VARCHAR:
				{
				int LA139_14 = input.LA(2);
				if ( (LA139_14==EOF||LA139_14==K_PRIMARY||LA139_14==K_STATIC||LA139_14==142||LA139_14==144||LA139_14==148||LA139_14==152) ) {
					alt139=1;
				}
				else if ( (LA139_14==146) ) {
					alt139=4;
				}

				else {
					int nvaeMark = input.mark();
					try {
						input.consume();
						NoViableAltException nvae =
							new NoViableAltException("", 139, 14, input);
						throw nvae;
					} finally {
						input.rewind(nvaeMark);
					}
				}

				}
				break;
			case K_VARINT:
				{
				int LA139_15 = input.LA(2);
				if ( (LA139_15==EOF||LA139_15==K_PRIMARY||LA139_15==K_STATIC||LA139_15==142||LA139_15==144||LA139_15==148||LA139_15==152) ) {
					alt139=1;
				}
				else if ( (LA139_15==146) ) {
					alt139=4;
				}

				else {
					int nvaeMark = input.mark();
					try {
						input.consume();
						NoViableAltException nvae =
							new NoViableAltException("", 139, 15, input);
						throw nvae;
					} finally {
						input.rewind(nvaeMark);
					}
				}

				}
				break;
			case K_TIMEUUID:
				{
				int LA139_16 = input.LA(2);
				if ( (LA139_16==EOF||LA139_16==K_PRIMARY||LA139_16==K_STATIC||LA139_16==142||LA139_16==144||LA139_16==148||LA139_16==152) ) {
					alt139=1;
				}
				else if ( (LA139_16==146) ) {
					alt139=4;
				}

				else {
					int nvaeMark = input.mark();
					try {
						input.consume();
						NoViableAltException nvae =
							new NoViableAltException("", 139, 16, input);
						throw nvae;
					} finally {
						input.rewind(nvaeMark);
					}
				}

				}
				break;
			case K_MAP:
				{
				int LA139_17 = input.LA(2);
				if ( (LA139_17==149) ) {
					alt139=2;
				}
				else if ( (LA139_17==EOF||LA139_17==K_PRIMARY||LA139_17==K_STATIC||LA139_17==142||LA139_17==144||LA139_17==146||LA139_17==148||LA139_17==152) ) {
					alt139=4;
				}

				else {
					int nvaeMark = input.mark();
					try {
						input.consume();
						NoViableAltException nvae =
							new NoViableAltException("", 139, 17, input);
						throw nvae;
					} finally {
						input.rewind(nvaeMark);
					}
				}

				}
				break;
			case K_LIST:
				{
				int LA139_18 = input.LA(2);
				if ( (LA139_18==149) ) {
					alt139=2;
				}
				else if ( (LA139_18==EOF||LA139_18==K_PRIMARY||LA139_18==K_STATIC||LA139_18==142||LA139_18==144||LA139_18==146||LA139_18==148||LA139_18==152) ) {
					alt139=4;
				}

				else {
					int nvaeMark = input.mark();
					try {
						input.consume();
						NoViableAltException nvae =
							new NoViableAltException("", 139, 18, input);
						throw nvae;
					} finally {
						input.rewind(nvaeMark);
					}
				}

				}
				break;
			case K_SET:
				{
				alt139=2;
				}
				break;
			case K_TUPLE:
				{
				alt139=3;
				}
				break;
			case IDENT:
			case K_ALL:
			case K_AS:
			case K_CLUSTERING:
			case K_COMPACT:
			case K_CONTAINS:
			case K_COUNT:
			case K_CUSTOM:
			case K_DISTINCT:
			case K_EXISTS:
			case K_FILTERING:
			case K_KEY:
			case K_KEYS:
			case K_KEYSPACES:
			case K_NOSUPERUSER:
			case K_PASSWORD:
			case K_PERMISSION:
			case K_PERMISSIONS:
			case K_STATIC:
			case K_STORAGE:
			case K_SUPERUSER:
			case K_TRIGGER:
			case K_TTL:
			case K_TYPE:
			case K_USER:
			case K_USERS:
			case K_VALUES:
			case K_WRITETIME:
			case QUOTED_NAME:
				{
				alt139=4;
				}
				break;
			case K_FROZEN:
				{
				alt139=5;
				}
				break;
			case STRING_LITERAL:
				{
				alt139=6;
				}
				break;
			default:
				NoViableAltException nvae =
					new NoViableAltException("", 139, 0, input);
				throw nvae;
			}
			switch (alt139) {
				case 1 :
					// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1106:7: n= native_type
					{
					pushFollow(FOLLOW_native_type_in_comparatorType7470);
					n=native_type();
					state._fsp--;

					 t = CQL3Type.Raw.from(n); 
					}
					break;
				case 2 :
					// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1107:7: c= collection_type
					{
					pushFollow(FOLLOW_collection_type_in_comparatorType7486);
					c=collection_type();
					state._fsp--;

					 t = c; 
					}
					break;
				case 3 :
					// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1108:7: tt= tuple_type
					{
					pushFollow(FOLLOW_tuple_type_in_comparatorType7498);
					tt=tuple_type();
					state._fsp--;

					 t = tt; 
					}
					break;
				case 4 :
					// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1109:7: id= userTypeName
					{
					pushFollow(FOLLOW_userTypeName_in_comparatorType7514);
					id=userTypeName();
					state._fsp--;

					 t = CQL3Type.Raw.userType(id); 
					}
					break;
				case 5 :
					// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1110:7: K_FROZEN '<' f= comparatorType '>'
					{
					match(input,K_FROZEN,FOLLOW_K_FROZEN_in_comparatorType7526); 
					match(input,149,FOLLOW_149_in_comparatorType7528); 
					pushFollow(FOLLOW_comparatorType_in_comparatorType7532);
					f=comparatorType();
					state._fsp--;

					match(input,152,FOLLOW_152_in_comparatorType7534); 

					        try {
					            t = CQL3Type.Raw.frozen(f);
					        } catch (InvalidRequestException e) {
					            addRecognitionError(e.getMessage());
					        }
					      
					}
					break;
				case 6 :
					// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1118:7: s= STRING_LITERAL
					{
					s=(Token)match(input,STRING_LITERAL,FOLLOW_STRING_LITERAL_in_comparatorType7552); 

					        try {
					            t = CQL3Type.Raw.from(new CQL3Type.Custom((s!=null?s.getText():null)));
					        } catch (SyntaxException e) {
					            addRecognitionError("Cannot parse type " + (s!=null?s.getText():null) + ": " + e.getMessage());
					        } catch (ConfigurationException e) {
					            addRecognitionError("Error setting type " + (s!=null?s.getText():null) + ": " + e.getMessage());
					        }
					      
					}
					break;

			}
		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return t;
	}
	// $ANTLR end "comparatorType"



	// $ANTLR start "native_type"
	// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1130:1: native_type returns [CQL3Type t] : ( K_ASCII | K_BIGINT | K_BLOB | K_BOOLEAN | K_COUNTER | K_DECIMAL | K_DOUBLE | K_FLOAT | K_INET | K_INT | K_TEXT | K_TIMESTAMP | K_UUID | K_VARCHAR | K_VARINT | K_TIMEUUID );
	public final CQL3Type native_type() throws RecognitionException {
		CQL3Type t = null;


		try {
			// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1131:5: ( K_ASCII | K_BIGINT | K_BLOB | K_BOOLEAN | K_COUNTER | K_DECIMAL | K_DOUBLE | K_FLOAT | K_INET | K_INT | K_TEXT | K_TIMESTAMP | K_UUID | K_VARCHAR | K_VARINT | K_TIMEUUID )
			int alt140=16;
			switch ( input.LA(1) ) {
			case K_ASCII:
				{
				alt140=1;
				}
				break;
			case K_BIGINT:
				{
				alt140=2;
				}
				break;
			case K_BLOB:
				{
				alt140=3;
				}
				break;
			case K_BOOLEAN:
				{
				alt140=4;
				}
				break;
			case K_COUNTER:
				{
				alt140=5;
				}
				break;
			case K_DECIMAL:
				{
				alt140=6;
				}
				break;
			case K_DOUBLE:
				{
				alt140=7;
				}
				break;
			case K_FLOAT:
				{
				alt140=8;
				}
				break;
			case K_INET:
				{
				alt140=9;
				}
				break;
			case K_INT:
				{
				alt140=10;
				}
				break;
			case K_TEXT:
				{
				alt140=11;
				}
				break;
			case K_TIMESTAMP:
				{
				alt140=12;
				}
				break;
			case K_UUID:
				{
				alt140=13;
				}
				break;
			case K_VARCHAR:
				{
				alt140=14;
				}
				break;
			case K_VARINT:
				{
				alt140=15;
				}
				break;
			case K_TIMEUUID:
				{
				alt140=16;
				}
				break;
			default:
				NoViableAltException nvae =
					new NoViableAltException("", 140, 0, input);
				throw nvae;
			}
			switch (alt140) {
				case 1 :
					// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1131:7: K_ASCII
					{
					match(input,K_ASCII,FOLLOW_K_ASCII_in_native_type7581); 
					 t = CQL3Type.Native.ASCII; 
					}
					break;
				case 2 :
					// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1132:7: K_BIGINT
					{
					match(input,K_BIGINT,FOLLOW_K_BIGINT_in_native_type7595); 
					 t = CQL3Type.Native.BIGINT; 
					}
					break;
				case 3 :
					// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1133:7: K_BLOB
					{
					match(input,K_BLOB,FOLLOW_K_BLOB_in_native_type7608); 
					 t = CQL3Type.Native.BLOB; 
					}
					break;
				case 4 :
					// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1134:7: K_BOOLEAN
					{
					match(input,K_BOOLEAN,FOLLOW_K_BOOLEAN_in_native_type7623); 
					 t = CQL3Type.Native.BOOLEAN; 
					}
					break;
				case 5 :
					// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1135:7: K_COUNTER
					{
					match(input,K_COUNTER,FOLLOW_K_COUNTER_in_native_type7635); 
					 t = CQL3Type.Native.COUNTER; 
					}
					break;
				case 6 :
					// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1136:7: K_DECIMAL
					{
					match(input,K_DECIMAL,FOLLOW_K_DECIMAL_in_native_type7647); 
					 t = CQL3Type.Native.DECIMAL; 
					}
					break;
				case 7 :
					// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1137:7: K_DOUBLE
					{
					match(input,K_DOUBLE,FOLLOW_K_DOUBLE_in_native_type7659); 
					 t = CQL3Type.Native.DOUBLE; 
					}
					break;
				case 8 :
					// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1138:7: K_FLOAT
					{
					match(input,K_FLOAT,FOLLOW_K_FLOAT_in_native_type7672); 
					 t = CQL3Type.Native.FLOAT; 
					}
					break;
				case 9 :
					// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1139:7: K_INET
					{
					match(input,K_INET,FOLLOW_K_INET_in_native_type7686); 
					 t = CQL3Type.Native.INET;
					}
					break;
				case 10 :
					// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1140:7: K_INT
					{
					match(input,K_INT,FOLLOW_K_INT_in_native_type7701); 
					 t = CQL3Type.Native.INT; 
					}
					break;
				case 11 :
					// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1141:7: K_TEXT
					{
					match(input,K_TEXT,FOLLOW_K_TEXT_in_native_type7717); 
					 t = CQL3Type.Native.TEXT; 
					}
					break;
				case 12 :
					// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1142:7: K_TIMESTAMP
					{
					match(input,K_TIMESTAMP,FOLLOW_K_TIMESTAMP_in_native_type7732); 
					 t = CQL3Type.Native.TIMESTAMP; 
					}
					break;
				case 13 :
					// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1143:7: K_UUID
					{
					match(input,K_UUID,FOLLOW_K_UUID_in_native_type7742); 
					 t = CQL3Type.Native.UUID; 
					}
					break;
				case 14 :
					// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1144:7: K_VARCHAR
					{
					match(input,K_VARCHAR,FOLLOW_K_VARCHAR_in_native_type7757); 
					 t = CQL3Type.Native.VARCHAR; 
					}
					break;
				case 15 :
					// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1145:7: K_VARINT
					{
					match(input,K_VARINT,FOLLOW_K_VARINT_in_native_type7769); 
					 t = CQL3Type.Native.VARINT; 
					}
					break;
				case 16 :
					// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1146:7: K_TIMEUUID
					{
					match(input,K_TIMEUUID,FOLLOW_K_TIMEUUID_in_native_type7782); 
					 t = CQL3Type.Native.TIMEUUID; 
					}
					break;

			}
		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return t;
	}
	// $ANTLR end "native_type"



	// $ANTLR start "collection_type"
	// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1149:1: collection_type returns [CQL3Type.Raw pt] : ( K_MAP '<' t1= comparatorType ',' t2= comparatorType '>' | K_LIST '<' t= comparatorType '>' | K_SET '<' t= comparatorType '>' );
	public final CQL3Type.Raw collection_type() throws RecognitionException {
		CQL3Type.Raw pt = null;


		CQL3Type.Raw t1 =null;
		CQL3Type.Raw t2 =null;
		CQL3Type.Raw t =null;

		try {
			// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1150:5: ( K_MAP '<' t1= comparatorType ',' t2= comparatorType '>' | K_LIST '<' t= comparatorType '>' | K_SET '<' t= comparatorType '>' )
			int alt141=3;
			switch ( input.LA(1) ) {
			case K_MAP:
				{
				alt141=1;
				}
				break;
			case K_LIST:
				{
				alt141=2;
				}
				break;
			case K_SET:
				{
				alt141=3;
				}
				break;
			default:
				NoViableAltException nvae =
					new NoViableAltException("", 141, 0, input);
				throw nvae;
			}
			switch (alt141) {
				case 1 :
					// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1150:7: K_MAP '<' t1= comparatorType ',' t2= comparatorType '>'
					{
					match(input,K_MAP,FOLLOW_K_MAP_in_collection_type7806); 
					match(input,149,FOLLOW_149_in_collection_type7809); 
					pushFollow(FOLLOW_comparatorType_in_collection_type7813);
					t1=comparatorType();
					state._fsp--;

					match(input,144,FOLLOW_144_in_collection_type7815); 
					pushFollow(FOLLOW_comparatorType_in_collection_type7819);
					t2=comparatorType();
					state._fsp--;

					match(input,152,FOLLOW_152_in_collection_type7821); 
					 try {
					            // if we can't parse either t1 or t2, antlr will "recover" and we may have t1 or t2 null.
					            if (t1 != null && t2 != null)
					                pt = CQL3Type.Raw.map(t1, t2);
					          } catch (InvalidRequestException e) { addRecognitionError(e.getMessage()); } 
					}
					break;
				case 2 :
					// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1156:7: K_LIST '<' t= comparatorType '>'
					{
					match(input,K_LIST,FOLLOW_K_LIST_in_collection_type7839); 
					match(input,149,FOLLOW_149_in_collection_type7841); 
					pushFollow(FOLLOW_comparatorType_in_collection_type7845);
					t=comparatorType();
					state._fsp--;

					match(input,152,FOLLOW_152_in_collection_type7847); 
					 try { if (t != null) pt = CQL3Type.Raw.list(t); } catch (InvalidRequestException e) { addRecognitionError(e.getMessage()); } 
					}
					break;
				case 3 :
					// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1158:7: K_SET '<' t= comparatorType '>'
					{
					match(input,K_SET,FOLLOW_K_SET_in_collection_type7865); 
					match(input,149,FOLLOW_149_in_collection_type7868); 
					pushFollow(FOLLOW_comparatorType_in_collection_type7872);
					t=comparatorType();
					state._fsp--;

					match(input,152,FOLLOW_152_in_collection_type7874); 
					 try { if (t != null) pt = CQL3Type.Raw.set(t); } catch (InvalidRequestException e) { addRecognitionError(e.getMessage()); } 
					}
					break;

			}
		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return pt;
	}
	// $ANTLR end "collection_type"



	// $ANTLR start "tuple_type"
	// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1162:1: tuple_type returns [CQL3Type.Raw t] : K_TUPLE '<' t1= comparatorType ( ',' tn= comparatorType )* '>' ;
	public final CQL3Type.Raw tuple_type() throws RecognitionException {
		CQL3Type.Raw t = null;


		CQL3Type.Raw t1 =null;
		CQL3Type.Raw tn =null;

		try {
			// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1163:5: ( K_TUPLE '<' t1= comparatorType ( ',' tn= comparatorType )* '>' )
			// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1163:7: K_TUPLE '<' t1= comparatorType ( ',' tn= comparatorType )* '>'
			{
			match(input,K_TUPLE,FOLLOW_K_TUPLE_in_tuple_type7905); 
			match(input,149,FOLLOW_149_in_tuple_type7907); 
			 List<CQL3Type.Raw> types = new ArrayList<>(); 
			pushFollow(FOLLOW_comparatorType_in_tuple_type7922);
			t1=comparatorType();
			state._fsp--;

			 types.add(t1); 
			// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1164:47: ( ',' tn= comparatorType )*
			loop142:
			while (true) {
				int alt142=2;
				int LA142_0 = input.LA(1);
				if ( (LA142_0==144) ) {
					alt142=1;
				}

				switch (alt142) {
				case 1 :
					// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1164:48: ',' tn= comparatorType
					{
					match(input,144,FOLLOW_144_in_tuple_type7927); 
					pushFollow(FOLLOW_comparatorType_in_tuple_type7931);
					tn=comparatorType();
					state._fsp--;

					 types.add(tn); 
					}
					break;

				default :
					break loop142;
				}
			}

			match(input,152,FOLLOW_152_in_tuple_type7943); 
			 try { t = CQL3Type.Raw.tuple(types); } catch (InvalidRequestException e) { addRecognitionError(e.getMessage()); }
			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return t;
	}
	// $ANTLR end "tuple_type"


	public static class username_return extends ParserRuleReturnScope {
	};


	// $ANTLR start "username"
	// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1168:1: username : ( IDENT | STRING_LITERAL );
	public final CqlParser.username_return username() throws RecognitionException {
		CqlParser.username_return retval = new CqlParser.username_return();
		retval.start = input.LT(1);

		try {
			// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1169:5: ( IDENT | STRING_LITERAL )
			// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:
			{
			if ( input.LA(1)==IDENT||input.LA(1)==STRING_LITERAL ) {
				input.consume();
				state.errorRecovery=false;
			}
			else {
				MismatchedSetException mse = new MismatchedSetException(null,input);
				throw mse;
			}
			}

			retval.stop = input.LT(-1);

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "username"



	// $ANTLR start "non_type_ident"
	// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1175:1: non_type_ident returns [ColumnIdentifier id] : (t= IDENT |t= QUOTED_NAME |k= basic_unreserved_keyword |kk= K_KEY );
	public final ColumnIdentifier non_type_ident() throws RecognitionException {
		ColumnIdentifier id = null;


		Token t=null;
		Token kk=null;
		String k =null;

		try {
			// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1176:5: (t= IDENT |t= QUOTED_NAME |k= basic_unreserved_keyword |kk= K_KEY )
			int alt143=4;
			switch ( input.LA(1) ) {
			case IDENT:
				{
				alt143=1;
				}
				break;
			case QUOTED_NAME:
				{
				alt143=2;
				}
				break;
			case K_ALL:
			case K_AS:
			case K_CLUSTERING:
			case K_COMPACT:
			case K_CONTAINS:
			case K_CUSTOM:
			case K_DISTINCT:
			case K_EXISTS:
			case K_FILTERING:
			case K_KEYS:
			case K_KEYSPACES:
			case K_LIST:
			case K_MAP:
			case K_NOSUPERUSER:
			case K_PASSWORD:
			case K_PERMISSION:
			case K_PERMISSIONS:
			case K_STATIC:
			case K_STORAGE:
			case K_SUPERUSER:
			case K_TRIGGER:
			case K_TYPE:
			case K_USER:
			case K_USERS:
			case K_VALUES:
				{
				alt143=3;
				}
				break;
			case K_KEY:
				{
				alt143=4;
				}
				break;
			default:
				NoViableAltException nvae =
					new NoViableAltException("", 143, 0, input);
				throw nvae;
			}
			switch (alt143) {
				case 1 :
					// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1176:7: t= IDENT
					{
					t=(Token)match(input,IDENT,FOLLOW_IDENT_in_non_type_ident7995); 
					 if (reservedTypeNames.contains((t!=null?t.getText():null))) addRecognitionError("Invalid (reserved) user type name " + (t!=null?t.getText():null)); id = new ColumnIdentifier((t!=null?t.getText():null), false); 
					}
					break;
				case 2 :
					// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1177:7: t= QUOTED_NAME
					{
					t=(Token)match(input,QUOTED_NAME,FOLLOW_QUOTED_NAME_in_non_type_ident8026); 
					 id = new ColumnIdentifier((t!=null?t.getText():null), true); 
					}
					break;
				case 3 :
					// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1178:7: k= basic_unreserved_keyword
					{
					pushFollow(FOLLOW_basic_unreserved_keyword_in_non_type_ident8051);
					k=basic_unreserved_keyword();
					state._fsp--;

					 id = new ColumnIdentifier(k, false); 
					}
					break;
				case 4 :
					// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1179:7: kk= K_KEY
					{
					kk=(Token)match(input,K_KEY,FOLLOW_K_KEY_in_non_type_ident8063); 
					 id = new ColumnIdentifier((kk!=null?kk.getText():null), false); 
					}
					break;

			}
		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return id;
	}
	// $ANTLR end "non_type_ident"



	// $ANTLR start "unreserved_keyword"
	// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1182:1: unreserved_keyword returns [String str] : (u= unreserved_function_keyword |k= ( K_TTL | K_COUNT | K_WRITETIME | K_KEY ) );
	public final String unreserved_keyword() throws RecognitionException {
		String str = null;


		Token k=null;
		String u =null;

		try {
			// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1183:5: (u= unreserved_function_keyword |k= ( K_TTL | K_COUNT | K_WRITETIME | K_KEY ) )
			int alt144=2;
			int LA144_0 = input.LA(1);
			if ( (LA144_0==K_ALL||LA144_0==K_AS||LA144_0==K_ASCII||(LA144_0 >= K_BIGINT && LA144_0 <= K_BOOLEAN)||LA144_0==K_CLUSTERING||(LA144_0 >= K_COMPACT && LA144_0 <= K_CONTAINS)||LA144_0==K_COUNTER||(LA144_0 >= K_CUSTOM && LA144_0 <= K_DECIMAL)||(LA144_0 >= K_DISTINCT && LA144_0 <= K_DOUBLE)||(LA144_0 >= K_EXISTS && LA144_0 <= K_FLOAT)||LA144_0==K_INET||LA144_0==K_INT||LA144_0==K_KEYS||LA144_0==K_KEYSPACES||(LA144_0 >= K_LIST && LA144_0 <= K_MAP)||LA144_0==K_NOSUPERUSER||(LA144_0 >= K_PASSWORD && LA144_0 <= K_PERMISSIONS)||(LA144_0 >= K_STATIC && LA144_0 <= K_TIMEUUID)||LA144_0==K_TRIGGER||LA144_0==K_TYPE||(LA144_0 >= K_USER && LA144_0 <= K_USERS)||(LA144_0 >= K_UUID && LA144_0 <= K_VARINT)) ) {
				alt144=1;
			}
			else if ( (LA144_0==K_COUNT||LA144_0==K_KEY||LA144_0==K_TTL||LA144_0==K_WRITETIME) ) {
				alt144=2;
			}

			else {
				NoViableAltException nvae =
					new NoViableAltException("", 144, 0, input);
				throw nvae;
			}

			switch (alt144) {
				case 1 :
					// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1183:7: u= unreserved_function_keyword
					{
					pushFollow(FOLLOW_unreserved_function_keyword_in_unreserved_keyword8106);
					u=unreserved_function_keyword();
					state._fsp--;

					 str = u; 
					}
					break;
				case 2 :
					// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1184:7: k= ( K_TTL | K_COUNT | K_WRITETIME | K_KEY )
					{
					k=input.LT(1);
					if ( input.LA(1)==K_COUNT||input.LA(1)==K_KEY||input.LA(1)==K_TTL||input.LA(1)==K_WRITETIME ) {
						input.consume();
						state.errorRecovery=false;
					}
					else {
						MismatchedSetException mse = new MismatchedSetException(null,input);
						throw mse;
					}
					 str = (k!=null?k.getText():null); 
					}
					break;

			}
		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return str;
	}
	// $ANTLR end "unreserved_keyword"



	// $ANTLR start "unreserved_function_keyword"
	// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1187:1: unreserved_function_keyword returns [String str] : (u= basic_unreserved_keyword |t= native_type );
	public final String unreserved_function_keyword() throws RecognitionException {
		String str = null;


		String u =null;
		CQL3Type t =null;

		try {
			// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1188:5: (u= basic_unreserved_keyword |t= native_type )
			int alt145=2;
			int LA145_0 = input.LA(1);
			if ( (LA145_0==K_ALL||LA145_0==K_AS||LA145_0==K_CLUSTERING||(LA145_0 >= K_COMPACT && LA145_0 <= K_CONTAINS)||LA145_0==K_CUSTOM||LA145_0==K_DISTINCT||(LA145_0 >= K_EXISTS && LA145_0 <= K_FILTERING)||LA145_0==K_KEYS||LA145_0==K_KEYSPACES||(LA145_0 >= K_LIST && LA145_0 <= K_MAP)||LA145_0==K_NOSUPERUSER||(LA145_0 >= K_PASSWORD && LA145_0 <= K_PERMISSIONS)||(LA145_0 >= K_STATIC && LA145_0 <= K_SUPERUSER)||LA145_0==K_TRIGGER||LA145_0==K_TYPE||(LA145_0 >= K_USER && LA145_0 <= K_USERS)||LA145_0==K_VALUES) ) {
				alt145=1;
			}
			else if ( (LA145_0==K_ASCII||(LA145_0 >= K_BIGINT && LA145_0 <= K_BOOLEAN)||LA145_0==K_COUNTER||LA145_0==K_DECIMAL||LA145_0==K_DOUBLE||LA145_0==K_FLOAT||LA145_0==K_INET||LA145_0==K_INT||(LA145_0 >= K_TEXT && LA145_0 <= K_TIMEUUID)||LA145_0==K_UUID||(LA145_0 >= K_VARCHAR && LA145_0 <= K_VARINT)) ) {
				alt145=2;
			}

			else {
				NoViableAltException nvae =
					new NoViableAltException("", 145, 0, input);
				throw nvae;
			}

			switch (alt145) {
				case 1 :
					// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1188:7: u= basic_unreserved_keyword
					{
					pushFollow(FOLLOW_basic_unreserved_keyword_in_unreserved_function_keyword8161);
					u=basic_unreserved_keyword();
					state._fsp--;

					 str = u; 
					}
					break;
				case 2 :
					// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1189:7: t= native_type
					{
					pushFollow(FOLLOW_native_type_in_unreserved_function_keyword8173);
					t=native_type();
					state._fsp--;

					 str = t.toString(); 
					}
					break;

			}
		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return str;
	}
	// $ANTLR end "unreserved_function_keyword"



	// $ANTLR start "basic_unreserved_keyword"
	// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1192:1: basic_unreserved_keyword returns [String str] : k= ( K_KEYS | K_AS | K_CLUSTERING | K_COMPACT | K_STORAGE | K_TYPE | K_VALUES | K_MAP | K_LIST | K_FILTERING | K_PERMISSION | K_PERMISSIONS | K_KEYSPACES | K_ALL | K_USER | K_USERS | K_SUPERUSER | K_NOSUPERUSER | K_PASSWORD | K_EXISTS | K_CUSTOM | K_TRIGGER | K_DISTINCT | K_CONTAINS | K_STATIC ) ;
	public final String basic_unreserved_keyword() throws RecognitionException {
		String str = null;


		Token k=null;

		try {
			// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1193:5: (k= ( K_KEYS | K_AS | K_CLUSTERING | K_COMPACT | K_STORAGE | K_TYPE | K_VALUES | K_MAP | K_LIST | K_FILTERING | K_PERMISSION | K_PERMISSIONS | K_KEYSPACES | K_ALL | K_USER | K_USERS | K_SUPERUSER | K_NOSUPERUSER | K_PASSWORD | K_EXISTS | K_CUSTOM | K_TRIGGER | K_DISTINCT | K_CONTAINS | K_STATIC ) )
			// /tmp/tmp.nibKSZaYH0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1193:7: k= ( K_KEYS | K_AS | K_CLUSTERING | K_COMPACT | K_STORAGE | K_TYPE | K_VALUES | K_MAP | K_LIST | K_FILTERING | K_PERMISSION | K_PERMISSIONS | K_KEYSPACES | K_ALL | K_USER | K_USERS | K_SUPERUSER | K_NOSUPERUSER | K_PASSWORD | K_EXISTS | K_CUSTOM | K_TRIGGER | K_DISTINCT | K_CONTAINS | K_STATIC )
			{
			k=input.LT(1);
			if ( input.LA(1)==K_ALL||input.LA(1)==K_AS||input.LA(1)==K_CLUSTERING||(input.LA(1) >= K_COMPACT && input.LA(1) <= K_CONTAINS)||input.LA(1)==K_CUSTOM||input.LA(1)==K_DISTINCT||(input.LA(1) >= K_EXISTS && input.LA(1) <= K_FILTERING)||input.LA(1)==K_KEYS||input.LA(1)==K_KEYSPACES||(input.LA(1) >= K_LIST && input.LA(1) <= K_MAP)||input.LA(1)==K_NOSUPERUSER||(input.LA(1) >= K_PASSWORD && input.LA(1) <= K_PERMISSIONS)||(input.LA(1) >= K_STATIC && input.LA(1) <= K_SUPERUSER)||input.LA(1)==K_TRIGGER||input.LA(1)==K_TYPE||(input.LA(1) >= K_USER && input.LA(1) <= K_USERS)||input.LA(1)==K_VALUES ) {
				input.consume();
				state.errorRecovery=false;
			}
			else {
				MismatchedSetException mse = new MismatchedSetException(null,input);
				throw mse;
			}
			 str = (k!=null?k.getText():null); 
			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return str;
	}
	// $ANTLR end "basic_unreserved_keyword"

	// Delegated rules



	public static final BitSet FOLLOW_cqlStatement_in_query72 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000100000L});
	public static final BitSet FOLLOW_148_in_query75 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000100000L});
	public static final BitSet FOLLOW_EOF_in_query79 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_selectStatement_in_cqlStatement113 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_insertStatement_in_cqlStatement138 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_updateStatement_in_cqlStatement163 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_batchStatement_in_cqlStatement188 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_deleteStatement_in_cqlStatement214 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_useStatement_in_cqlStatement239 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_truncateStatement_in_cqlStatement267 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_createKeyspaceStatement_in_cqlStatement290 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_createTableStatement_in_cqlStatement307 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_createIndexStatement_in_cqlStatement326 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_dropKeyspaceStatement_in_cqlStatement345 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_dropTableStatement_in_cqlStatement363 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_dropIndexStatement_in_cqlStatement384 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_alterTableStatement_in_cqlStatement405 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_alterKeyspaceStatement_in_cqlStatement425 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_grantStatement_in_cqlStatement442 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_revokeStatement_in_cqlStatement467 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_listPermissionsStatement_in_cqlStatement491 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_createUserStatement_in_cqlStatement506 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_alterUserStatement_in_cqlStatement526 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_dropUserStatement_in_cqlStatement547 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_listUsersStatement_in_cqlStatement569 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_createTriggerStatement_in_cqlStatement590 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_dropTriggerStatement_in_cqlStatement607 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_createTypeStatement_in_cqlStatement626 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_alterTypeStatement_in_cqlStatement646 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_dropTypeStatement_in_cqlStatement667 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_K_USE_in_useStatement702 = new BitSet(new long[]{0x81D9BD7142100000L,0x8027B153F07046B4L});
	public static final BitSet FOLLOW_keyspaceName_in_useStatement706 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_K_SELECT_in_selectStatement740 = new BitSet(new long[]{0x81D9BD7142100000L,0x8027B15BF07046B4L,0x0000000008000000L});
	public static final BitSet FOLLOW_K_DISTINCT_in_selectStatement746 = new BitSet(new long[]{0x81D9BD7142100000L,0x8027B15BF07046B4L,0x0000000008000000L});
	public static final BitSet FOLLOW_selectClause_in_selectStatement755 = new BitSet(new long[]{0x0200000000000000L});
	public static final BitSet FOLLOW_K_COUNT_in_selectStatement775 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000002000L});
	public static final BitSet FOLLOW_141_in_selectStatement777 = new BitSet(new long[]{0x0000000000200000L,0x0000000000000000L,0x0000000008000000L});
	public static final BitSet FOLLOW_selectCountClause_in_selectStatement781 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000004000L});
	public static final BitSet FOLLOW_142_in_selectStatement783 = new BitSet(new long[]{0x0200000040000000L});
	public static final BitSet FOLLOW_K_AS_in_selectStatement788 = new BitSet(new long[]{0x81D9BD7142100000L,0x8027B153F07046B4L});
	public static final BitSet FOLLOW_ident_in_selectStatement792 = new BitSet(new long[]{0x0200000000000000L});
	public static final BitSet FOLLOW_K_FROM_in_selectStatement807 = new BitSet(new long[]{0x81D9BD7142100000L,0x8027B153F07046B4L});
	public static final BitSet FOLLOW_columnFamilyName_in_selectStatement811 = new BitSet(new long[]{0x0000000004000002L,0x0008000000080100L});
	public static final BitSet FOLLOW_K_WHERE_in_selectStatement821 = new BitSet(new long[]{0x81D9BD7142100000L,0x8027B15BF07046B4L,0x0000000000002000L});
	public static final BitSet FOLLOW_whereClause_in_selectStatement825 = new BitSet(new long[]{0x0000000004000002L,0x0000000000080100L});
	public static final BitSet FOLLOW_K_ORDER_in_selectStatement838 = new BitSet(new long[]{0x0000008000000000L});
	public static final BitSet FOLLOW_K_BY_in_selectStatement840 = new BitSet(new long[]{0x81D9BD7142100000L,0x8027B153F07046B4L});
	public static final BitSet FOLLOW_orderByClause_in_selectStatement842 = new BitSet(new long[]{0x0000000004000002L,0x0000000000000100L,0x0000000000010000L});
	public static final BitSet FOLLOW_144_in_selectStatement847 = new BitSet(new long[]{0x81D9BD7142100000L,0x8027B153F07046B4L});
	public static final BitSet FOLLOW_orderByClause_in_selectStatement849 = new BitSet(new long[]{0x0000000004000002L,0x0000000000000100L,0x0000000000010000L});
	public static final BitSet FOLLOW_K_LIMIT_in_selectStatement866 = new BitSet(new long[]{0x0000000004200000L,0x4000000000000000L,0x0000000000080000L});
	public static final BitSet FOLLOW_intValue_in_selectStatement870 = new BitSet(new long[]{0x0000000004000002L});
	public static final BitSet FOLLOW_K_ALLOW_in_selectStatement885 = new BitSet(new long[]{0x0080000000000000L});
	public static final BitSet FOLLOW_K_FILTERING_in_selectStatement887 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_selector_in_selectClause924 = new BitSet(new long[]{0x0000000000000002L,0x0000000000000000L,0x0000000000010000L});
	public static final BitSet FOLLOW_144_in_selectClause929 = new BitSet(new long[]{0x81D9BD7142100000L,0x8027B15BF07046B4L});
	public static final BitSet FOLLOW_selector_in_selectClause933 = new BitSet(new long[]{0x0000000000000002L,0x0000000000000000L,0x0000000000010000L});
	public static final BitSet FOLLOW_155_in_selectClause945 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_unaliasedSelector_in_selector978 = new BitSet(new long[]{0x0000000040000002L});
	public static final BitSet FOLLOW_K_AS_in_selector981 = new BitSet(new long[]{0x81D9BD7142100000L,0x8027B153F07046B4L});
	public static final BitSet FOLLOW_ident_in_selector985 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_cident_in_unaliasedSelector1026 = new BitSet(new long[]{0x0000000000000002L,0x0000000000000000L,0x0000000000040000L});
	public static final BitSet FOLLOW_K_WRITETIME_in_unaliasedSelector1072 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000002000L});
	public static final BitSet FOLLOW_141_in_unaliasedSelector1074 = new BitSet(new long[]{0x81D9BD7142100000L,0x8027B153F07046B4L});
	public static final BitSet FOLLOW_cident_in_unaliasedSelector1078 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000004000L});
	public static final BitSet FOLLOW_142_in_unaliasedSelector1080 = new BitSet(new long[]{0x0000000000000002L,0x0000000000000000L,0x0000000000040000L});
	public static final BitSet FOLLOW_K_TTL_in_unaliasedSelector1106 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000002000L});
	public static final BitSet FOLLOW_141_in_unaliasedSelector1114 = new BitSet(new long[]{0x81D9BD7142100000L,0x8027B153F07046B4L});
	public static final BitSet FOLLOW_cident_in_unaliasedSelector1118 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000004000L});
	public static final BitSet FOLLOW_142_in_unaliasedSelector1120 = new BitSet(new long[]{0x0000000000000002L,0x0000000000000000L,0x0000000000040000L});
	public static final BitSet FOLLOW_functionName_in_unaliasedSelector1148 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000002000L});
	public static final BitSet FOLLOW_selectionFunctionArgs_in_unaliasedSelector1152 = new BitSet(new long[]{0x0000000000000002L,0x0000000000000000L,0x0000000000040000L});
	public static final BitSet FOLLOW_146_in_unaliasedSelector1167 = new BitSet(new long[]{0x81D9BD7142100000L,0x8027B153F07046B4L});
	public static final BitSet FOLLOW_cident_in_unaliasedSelector1171 = new BitSet(new long[]{0x0000000000000002L,0x0000000000000000L,0x0000000000040000L});
	public static final BitSet FOLLOW_141_in_selectionFunctionArgs1199 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000004000L});
	public static final BitSet FOLLOW_142_in_selectionFunctionArgs1201 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_141_in_selectionFunctionArgs1211 = new BitSet(new long[]{0x81D9BD7142100000L,0x8027B15BF07046B4L});
	public static final BitSet FOLLOW_unaliasedSelector_in_selectionFunctionArgs1215 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000014000L});
	public static final BitSet FOLLOW_144_in_selectionFunctionArgs1231 = new BitSet(new long[]{0x81D9BD7142100000L,0x8027B15BF07046B4L});
	public static final BitSet FOLLOW_unaliasedSelector_in_selectionFunctionArgs1235 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000014000L});
	public static final BitSet FOLLOW_142_in_selectionFunctionArgs1248 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_155_in_selectCountClause1271 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_INTEGER_in_selectCountClause1293 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_relation_in_whereClause1329 = new BitSet(new long[]{0x0000000010000002L});
	public static final BitSet FOLLOW_K_AND_in_whereClause1333 = new BitSet(new long[]{0x81D9BD7142100000L,0x8027B15BF07046B4L,0x0000000000002000L});
	public static final BitSet FOLLOW_relation_in_whereClause1335 = new BitSet(new long[]{0x0000000010000002L});
	public static final BitSet FOLLOW_cident_in_orderByClause1366 = new BitSet(new long[]{0x0004000080000002L});
	public static final BitSet FOLLOW_K_ASC_in_orderByClause1371 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_K_DESC_in_orderByClause1375 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_K_INSERT_in_insertStatement1413 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000008L});
	public static final BitSet FOLLOW_K_INTO_in_insertStatement1415 = new BitSet(new long[]{0x81D9BD7142100000L,0x8027B153F07046B4L});
	public static final BitSet FOLLOW_columnFamilyName_in_insertStatement1419 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000002000L});
	public static final BitSet FOLLOW_141_in_insertStatement1431 = new BitSet(new long[]{0x81D9BD7142100000L,0x8027B153F07046B4L});
	public static final BitSet FOLLOW_cident_in_insertStatement1435 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000014000L});
	public static final BitSet FOLLOW_144_in_insertStatement1442 = new BitSet(new long[]{0x81D9BD7142100000L,0x8027B153F07046B4L});
	public static final BitSet FOLLOW_cident_in_insertStatement1446 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000014000L});
	public static final BitSet FOLLOW_142_in_insertStatement1453 = new BitSet(new long[]{0x0000000000000000L,0x0001000000000000L});
	public static final BitSet FOLLOW_K_VALUES_in_insertStatement1463 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000002000L});
	public static final BitSet FOLLOW_141_in_insertStatement1475 = new BitSet(new long[]{0x81D9AD7142344040L,0x4007B11BF07156A5L,0x00000000240A2024L});
	public static final BitSet FOLLOW_term_in_insertStatement1479 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000014000L});
	public static final BitSet FOLLOW_144_in_insertStatement1485 = new BitSet(new long[]{0x81D9AD7142344040L,0x4007B11BF07156A5L,0x00000000240A2024L});
	public static final BitSet FOLLOW_term_in_insertStatement1489 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000014000L});
	public static final BitSet FOLLOW_142_in_insertStatement1496 = new BitSet(new long[]{0x1000000000000002L,0x0000400000000000L});
	public static final BitSet FOLLOW_K_IF_in_insertStatement1509 = new BitSet(new long[]{0x0000000000000000L,0x0000000000008000L});
	public static final BitSet FOLLOW_K_NOT_in_insertStatement1511 = new BitSet(new long[]{0x0040000000000000L});
	public static final BitSet FOLLOW_K_EXISTS_in_insertStatement1513 = new BitSet(new long[]{0x0000000000000002L,0x0000400000000000L});
	public static final BitSet FOLLOW_usingClause_in_insertStatement1530 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_K_USING_in_usingClause1560 = new BitSet(new long[]{0x0000000000000000L,0x0000004100000000L});
	public static final BitSet FOLLOW_usingClauseObjective_in_usingClause1562 = new BitSet(new long[]{0x0000000010000002L});
	public static final BitSet FOLLOW_K_AND_in_usingClause1567 = new BitSet(new long[]{0x0000000000000000L,0x0000004100000000L});
	public static final BitSet FOLLOW_usingClauseObjective_in_usingClause1569 = new BitSet(new long[]{0x0000000010000002L});
	public static final BitSet FOLLOW_K_TIMESTAMP_in_usingClauseObjective1591 = new BitSet(new long[]{0x0000000000200000L,0x4000000000000000L,0x0000000000080000L});
	public static final BitSet FOLLOW_intValue_in_usingClauseObjective1595 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_K_TTL_in_usingClauseObjective1605 = new BitSet(new long[]{0x0000000000200000L,0x4000000000000000L,0x0000000000080000L});
	public static final BitSet FOLLOW_intValue_in_usingClauseObjective1609 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_K_UPDATE_in_updateStatement1643 = new BitSet(new long[]{0x81D9BD7142100000L,0x8027B153F07046B4L});
	public static final BitSet FOLLOW_columnFamilyName_in_updateStatement1647 = new BitSet(new long[]{0x0000000000000000L,0x0000400008000000L});
	public static final BitSet FOLLOW_usingClause_in_updateStatement1657 = new BitSet(new long[]{0x0000000000000000L,0x0000000008000000L});
	public static final BitSet FOLLOW_K_SET_in_updateStatement1669 = new BitSet(new long[]{0x81D9BD7142100000L,0x8027B153F07046B4L});
	public static final BitSet FOLLOW_columnOperation_in_updateStatement1671 = new BitSet(new long[]{0x0000000000000000L,0x0008000000000000L,0x0000000000010000L});
	public static final BitSet FOLLOW_144_in_updateStatement1675 = new BitSet(new long[]{0x81D9BD7142100000L,0x8027B153F07046B4L});
	public static final BitSet FOLLOW_columnOperation_in_updateStatement1677 = new BitSet(new long[]{0x0000000000000000L,0x0008000000000000L,0x0000000000010000L});
	public static final BitSet FOLLOW_K_WHERE_in_updateStatement1688 = new BitSet(new long[]{0x81D9BD7142100000L,0x8027B15BF07046B4L,0x0000000000002000L});
	public static final BitSet FOLLOW_whereClause_in_updateStatement1692 = new BitSet(new long[]{0x1000000000000002L});
	public static final BitSet FOLLOW_K_IF_in_updateStatement1702 = new BitSet(new long[]{0x81D9BD7142100000L,0x8027B153F07046B4L});
	public static final BitSet FOLLOW_updateConditions_in_updateStatement1706 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_columnCondition_in_updateConditions1747 = new BitSet(new long[]{0x0000000010000002L});
	public static final BitSet FOLLOW_K_AND_in_updateConditions1752 = new BitSet(new long[]{0x81D9BD7142100000L,0x8027B153F07046B4L});
	public static final BitSet FOLLOW_columnCondition_in_updateConditions1754 = new BitSet(new long[]{0x0000000010000002L});
	public static final BitSet FOLLOW_K_DELETE_in_deleteStatement1791 = new BitSet(new long[]{0x83D9BD7142100000L,0x8027B153F07046B4L});
	public static final BitSet FOLLOW_deleteSelection_in_deleteStatement1797 = new BitSet(new long[]{0x0200000000000000L});
	public static final BitSet FOLLOW_K_FROM_in_deleteStatement1810 = new BitSet(new long[]{0x81D9BD7142100000L,0x8027B153F07046B4L});
	public static final BitSet FOLLOW_columnFamilyName_in_deleteStatement1814 = new BitSet(new long[]{0x0000000000000000L,0x0008400000000000L});
	public static final BitSet FOLLOW_usingClauseDelete_in_deleteStatement1824 = new BitSet(new long[]{0x0000000000000000L,0x0008000000000000L});
	public static final BitSet FOLLOW_K_WHERE_in_deleteStatement1836 = new BitSet(new long[]{0x81D9BD7142100000L,0x8027B15BF07046B4L,0x0000000000002000L});
	public static final BitSet FOLLOW_whereClause_in_deleteStatement1840 = new BitSet(new long[]{0x1000000000000002L});
	public static final BitSet FOLLOW_K_IF_in_deleteStatement1850 = new BitSet(new long[]{0x81D9BD7142100000L,0x8027B153F07046B4L});
	public static final BitSet FOLLOW_K_EXISTS_in_deleteStatement1854 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_updateConditions_in_deleteStatement1862 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_deleteOp_in_deleteSelection1909 = new BitSet(new long[]{0x0000000000000002L,0x0000000000000000L,0x0000000000010000L});
	public static final BitSet FOLLOW_144_in_deleteSelection1924 = new BitSet(new long[]{0x81D9BD7142100000L,0x8027B153F07046B4L});
	public static final BitSet FOLLOW_deleteOp_in_deleteSelection1928 = new BitSet(new long[]{0x0000000000000002L,0x0000000000000000L,0x0000000000010000L});
	public static final BitSet FOLLOW_cident_in_deleteOp1955 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_cident_in_deleteOp1982 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000004000000L});
	public static final BitSet FOLLOW_154_in_deleteOp1984 = new BitSet(new long[]{0x81D9AD7142344040L,0x4007B11BF07156A5L,0x00000000240A2024L});
	public static final BitSet FOLLOW_term_in_deleteOp1988 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000010000000L});
	public static final BitSet FOLLOW_156_in_deleteOp1990 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_K_USING_in_usingClauseDelete2010 = new BitSet(new long[]{0x0000000000000000L,0x0000000100000000L});
	public static final BitSet FOLLOW_K_TIMESTAMP_in_usingClauseDelete2012 = new BitSet(new long[]{0x0000000000200000L,0x4000000000000000L,0x0000000000080000L});
	public static final BitSet FOLLOW_intValue_in_usingClauseDelete2016 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_K_BEGIN_in_batchStatement2050 = new BitSet(new long[]{0x0000200400000000L,0x0000020000000000L});
	public static final BitSet FOLLOW_K_UNLOGGED_in_batchStatement2060 = new BitSet(new long[]{0x0000000400000000L});
	public static final BitSet FOLLOW_K_COUNTER_in_batchStatement2066 = new BitSet(new long[]{0x0000000400000000L});
	public static final BitSet FOLLOW_K_BATCH_in_batchStatement2079 = new BitSet(new long[]{0x0002000020000000L,0x0000440000000002L});
	public static final BitSet FOLLOW_usingClause_in_batchStatement2083 = new BitSet(new long[]{0x0002000020000000L,0x0000040000000002L});
	public static final BitSet FOLLOW_batchStatementObjective_in_batchStatement2103 = new BitSet(new long[]{0x0002000020000000L,0x0000040000000002L,0x0000000000100000L});
	public static final BitSet FOLLOW_148_in_batchStatement2105 = new BitSet(new long[]{0x0002000020000000L,0x0000040000000002L});
	public static final BitSet FOLLOW_K_APPLY_in_batchStatement2119 = new BitSet(new long[]{0x0000000400000000L});
	public static final BitSet FOLLOW_K_BATCH_in_batchStatement2121 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_insertStatement_in_batchStatementObjective2152 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_updateStatement_in_batchStatementObjective2165 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_deleteStatement_in_batchStatementObjective2178 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_K_CREATE_in_createKeyspaceStatement2213 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000040L});
	public static final BitSet FOLLOW_K_KEYSPACE_in_createKeyspaceStatement2215 = new BitSet(new long[]{0x91D9BD7142100000L,0x8027B153F07046B4L});
	public static final BitSet FOLLOW_K_IF_in_createKeyspaceStatement2218 = new BitSet(new long[]{0x0000000000000000L,0x0000000000008000L});
	public static final BitSet FOLLOW_K_NOT_in_createKeyspaceStatement2220 = new BitSet(new long[]{0x0040000000000000L});
	public static final BitSet FOLLOW_K_EXISTS_in_createKeyspaceStatement2222 = new BitSet(new long[]{0x81D9BD7142100000L,0x8027B153F07046B4L});
	public static final BitSet FOLLOW_keyspaceName_in_createKeyspaceStatement2231 = new BitSet(new long[]{0x0000000000000000L,0x0010000000000000L});
	public static final BitSet FOLLOW_K_WITH_in_createKeyspaceStatement2239 = new BitSet(new long[]{0x81D9BD7142100000L,0x8027B153F07046B4L});
	public static final BitSet FOLLOW_properties_in_createKeyspaceStatement2241 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_K_CREATE_in_createTableStatement2276 = new BitSet(new long[]{0x0000020000000000L});
	public static final BitSet FOLLOW_K_COLUMNFAMILY_in_createTableStatement2278 = new BitSet(new long[]{0x91D9BD7142100000L,0x8027B153F07046B4L});
	public static final BitSet FOLLOW_K_IF_in_createTableStatement2281 = new BitSet(new long[]{0x0000000000000000L,0x0000000000008000L});
	public static final BitSet FOLLOW_K_NOT_in_createTableStatement2283 = new BitSet(new long[]{0x0040000000000000L});
	public static final BitSet FOLLOW_K_EXISTS_in_createTableStatement2285 = new BitSet(new long[]{0x81D9BD7142100000L,0x8027B153F07046B4L});
	public static final BitSet FOLLOW_columnFamilyName_in_createTableStatement2300 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000002000L});
	public static final BitSet FOLLOW_cfamDefinition_in_createTableStatement2310 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_141_in_cfamDefinition2329 = new BitSet(new long[]{0x81D9BD7142100000L,0x8027B153F0F046B4L});
	public static final BitSet FOLLOW_cfamColumns_in_cfamDefinition2331 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000014000L});
	public static final BitSet FOLLOW_144_in_cfamDefinition2336 = new BitSet(new long[]{0x81D9BD7142100000L,0x8027B153F0F046B4L,0x0000000000014000L});
	public static final BitSet FOLLOW_cfamColumns_in_cfamDefinition2338 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000014000L});
	public static final BitSet FOLLOW_142_in_cfamDefinition2345 = new BitSet(new long[]{0x0000000000000002L,0x0010000000000000L});
	public static final BitSet FOLLOW_K_WITH_in_cfamDefinition2355 = new BitSet(new long[]{0x81D9BD7142100000L,0x8027B153F07046B4L});
	public static final BitSet FOLLOW_cfamProperty_in_cfamDefinition2357 = new BitSet(new long[]{0x0000000010000002L});
	public static final BitSet FOLLOW_K_AND_in_cfamDefinition2362 = new BitSet(new long[]{0x81D9BD7142100000L,0x8027B153F07046B4L});
	public static final BitSet FOLLOW_cfamProperty_in_cfamDefinition2364 = new BitSet(new long[]{0x0000000010000002L});
	public static final BitSet FOLLOW_ident_in_cfamColumns2390 = new BitSet(new long[]{0x85D9BD7142100000L,0x8027B1D3F87046B4L,0x0000000000000004L});
	public static final BitSet FOLLOW_comparatorType_in_cfamColumns2394 = new BitSet(new long[]{0x0000000000000002L,0x0000000010800000L});
	public static final BitSet FOLLOW_K_STATIC_in_cfamColumns2399 = new BitSet(new long[]{0x0000000000000002L,0x0000000000800000L});
	public static final BitSet FOLLOW_K_PRIMARY_in_cfamColumns2416 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000010L});
	public static final BitSet FOLLOW_K_KEY_in_cfamColumns2418 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_K_PRIMARY_in_cfamColumns2430 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000010L});
	public static final BitSet FOLLOW_K_KEY_in_cfamColumns2432 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000002000L});
	public static final BitSet FOLLOW_141_in_cfamColumns2434 = new BitSet(new long[]{0x81D9BD7142100000L,0x8027B153F07046B4L,0x0000000000002000L});
	public static final BitSet FOLLOW_pkDef_in_cfamColumns2436 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000014000L});
	public static final BitSet FOLLOW_144_in_cfamColumns2440 = new BitSet(new long[]{0x81D9BD7142100000L,0x8027B153F07046B4L});
	public static final BitSet FOLLOW_ident_in_cfamColumns2444 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000014000L});
	public static final BitSet FOLLOW_142_in_cfamColumns2451 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_ident_in_pkDef2471 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_141_in_pkDef2481 = new BitSet(new long[]{0x81D9BD7142100000L,0x8027B153F07046B4L});
	public static final BitSet FOLLOW_ident_in_pkDef2487 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000014000L});
	public static final BitSet FOLLOW_144_in_pkDef2493 = new BitSet(new long[]{0x81D9BD7142100000L,0x8027B153F07046B4L});
	public static final BitSet FOLLOW_ident_in_pkDef2497 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000014000L});
	public static final BitSet FOLLOW_142_in_pkDef2504 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_property_in_cfamProperty2524 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_K_COMPACT_in_cfamProperty2533 = new BitSet(new long[]{0x0000000000000000L,0x0000000020000000L});
	public static final BitSet FOLLOW_K_STORAGE_in_cfamProperty2535 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_K_CLUSTERING_in_cfamProperty2545 = new BitSet(new long[]{0x0000000000000000L,0x0000000000080000L});
	public static final BitSet FOLLOW_K_ORDER_in_cfamProperty2547 = new BitSet(new long[]{0x0000008000000000L});
	public static final BitSet FOLLOW_K_BY_in_cfamProperty2549 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000002000L});
	public static final BitSet FOLLOW_141_in_cfamProperty2551 = new BitSet(new long[]{0x81D9BD7142100000L,0x8027B153F07046B4L});
	public static final BitSet FOLLOW_cfamOrdering_in_cfamProperty2553 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000014000L});
	public static final BitSet FOLLOW_144_in_cfamProperty2557 = new BitSet(new long[]{0x81D9BD7142100000L,0x8027B153F07046B4L});
	public static final BitSet FOLLOW_cfamOrdering_in_cfamProperty2559 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000014000L});
	public static final BitSet FOLLOW_142_in_cfamProperty2564 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_ident_in_cfamOrdering2592 = new BitSet(new long[]{0x0004000080000000L});
	public static final BitSet FOLLOW_K_ASC_in_cfamOrdering2595 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_K_DESC_in_cfamOrdering2599 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_K_CREATE_in_createTypeStatement2638 = new BitSet(new long[]{0x0000000000000000L,0x0000010000000000L});
	public static final BitSet FOLLOW_K_TYPE_in_createTypeStatement2640 = new BitSet(new long[]{0x91D9BD7142100000L,0x8027B153F07046B4L});
	public static final BitSet FOLLOW_K_IF_in_createTypeStatement2643 = new BitSet(new long[]{0x0000000000000000L,0x0000000000008000L});
	public static final BitSet FOLLOW_K_NOT_in_createTypeStatement2645 = new BitSet(new long[]{0x0040000000000000L});
	public static final BitSet FOLLOW_K_EXISTS_in_createTypeStatement2647 = new BitSet(new long[]{0x81D9BD7142100000L,0x8027B153F07046B4L});
	public static final BitSet FOLLOW_userTypeName_in_createTypeStatement2665 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000002000L});
	public static final BitSet FOLLOW_141_in_createTypeStatement2678 = new BitSet(new long[]{0x81D9BD7142100000L,0x8027B153F07046B4L});
	public static final BitSet FOLLOW_typeColumns_in_createTypeStatement2680 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000014000L});
	public static final BitSet FOLLOW_144_in_createTypeStatement2685 = new BitSet(new long[]{0x81D9BD7142100000L,0x8027B153F07046B4L,0x0000000000014000L});
	public static final BitSet FOLLOW_typeColumns_in_createTypeStatement2687 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000014000L});
	public static final BitSet FOLLOW_142_in_createTypeStatement2694 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_ident_in_typeColumns2714 = new BitSet(new long[]{0x85D9BD7142100000L,0x8027B1D3F87046B4L,0x0000000000000004L});
	public static final BitSet FOLLOW_comparatorType_in_typeColumns2718 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_K_CREATE_in_createIndexStatement2753 = new BitSet(new long[]{0x4000800000000000L});
	public static final BitSet FOLLOW_K_CUSTOM_in_createIndexStatement2756 = new BitSet(new long[]{0x4000000000000000L});
	public static final BitSet FOLLOW_K_INDEX_in_createIndexStatement2762 = new BitSet(new long[]{0x1000000000100000L,0x0000000000040000L});
	public static final BitSet FOLLOW_K_IF_in_createIndexStatement2765 = new BitSet(new long[]{0x0000000000000000L,0x0000000000008000L});
	public static final BitSet FOLLOW_K_NOT_in_createIndexStatement2767 = new BitSet(new long[]{0x0040000000000000L});
	public static final BitSet FOLLOW_K_EXISTS_in_createIndexStatement2769 = new BitSet(new long[]{0x0000000000100000L,0x0000000000040000L});
	public static final BitSet FOLLOW_IDENT_in_createIndexStatement2787 = new BitSet(new long[]{0x0000000000000000L,0x0000000000040000L});
	public static final BitSet FOLLOW_K_ON_in_createIndexStatement2791 = new BitSet(new long[]{0x81D9BD7142100000L,0x8027B153F07046B4L});
	public static final BitSet FOLLOW_columnFamilyName_in_createIndexStatement2795 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000002000L});
	public static final BitSet FOLLOW_141_in_createIndexStatement2797 = new BitSet(new long[]{0x81D9BD7142100000L,0x8027B153F07046B4L});
	public static final BitSet FOLLOW_indexIdent_in_createIndexStatement2801 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000004000L});
	public static final BitSet FOLLOW_142_in_createIndexStatement2803 = new BitSet(new long[]{0x0000000000000002L,0x0010400000000000L});
	public static final BitSet FOLLOW_K_USING_in_createIndexStatement2814 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000000004L});
	public static final BitSet FOLLOW_STRING_LITERAL_in_createIndexStatement2818 = new BitSet(new long[]{0x0000000000000002L,0x0010000000000000L});
	public static final BitSet FOLLOW_K_WITH_in_createIndexStatement2833 = new BitSet(new long[]{0x81D9BD7142100000L,0x8027B153F07046B4L});
	public static final BitSet FOLLOW_properties_in_createIndexStatement2835 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_cident_in_indexIdent2869 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_K_KEYS_in_indexIdent2894 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000002000L});
	public static final BitSet FOLLOW_141_in_indexIdent2896 = new BitSet(new long[]{0x81D9BD7142100000L,0x8027B153F07046B4L});
	public static final BitSet FOLLOW_cident_in_indexIdent2900 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000004000L});
	public static final BitSet FOLLOW_142_in_indexIdent2902 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_K_CREATE_in_createTriggerStatement2937 = new BitSet(new long[]{0x0000000000000000L,0x0000001000000000L});
	public static final BitSet FOLLOW_K_TRIGGER_in_createTriggerStatement2939 = new BitSet(new long[]{0x91D9BD7142100000L,0x8027B153F07046B4L});
	public static final BitSet FOLLOW_K_IF_in_createTriggerStatement2942 = new BitSet(new long[]{0x0000000000000000L,0x0000000000008000L});
	public static final BitSet FOLLOW_K_NOT_in_createTriggerStatement2944 = new BitSet(new long[]{0x0040000000000000L});
	public static final BitSet FOLLOW_K_EXISTS_in_createTriggerStatement2946 = new BitSet(new long[]{0x81D9BD7142100000L,0x8027B153F07046B4L});
	public static final BitSet FOLLOW_cident_in_createTriggerStatement2956 = new BitSet(new long[]{0x0000000000000000L,0x0000000000040000L});
	public static final BitSet FOLLOW_K_ON_in_createTriggerStatement2967 = new BitSet(new long[]{0x81D9BD7142100000L,0x8027B153F07046B4L});
	public static final BitSet FOLLOW_columnFamilyName_in_createTriggerStatement2971 = new BitSet(new long[]{0x0000000000000000L,0x0000400000000000L});
	public static final BitSet FOLLOW_K_USING_in_createTriggerStatement2973 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000000004L});
	public static final BitSet FOLLOW_STRING_LITERAL_in_createTriggerStatement2977 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_K_DROP_in_dropTriggerStatement3018 = new BitSet(new long[]{0x0000000000000000L,0x0000001000000000L});
	public static final BitSet FOLLOW_K_TRIGGER_in_dropTriggerStatement3020 = new BitSet(new long[]{0x91D9BD7142100000L,0x8027B153F07046B4L});
	public static final BitSet FOLLOW_K_IF_in_dropTriggerStatement3023 = new BitSet(new long[]{0x0040000000000000L});
	public static final BitSet FOLLOW_K_EXISTS_in_dropTriggerStatement3025 = new BitSet(new long[]{0x81D9BD7142100000L,0x8027B153F07046B4L});
	public static final BitSet FOLLOW_cident_in_dropTriggerStatement3035 = new BitSet(new long[]{0x0000000000000000L,0x0000000000040000L});
	public static final BitSet FOLLOW_K_ON_in_dropTriggerStatement3038 = new BitSet(new long[]{0x81D9BD7142100000L,0x8027B153F07046B4L});
	public static final BitSet FOLLOW_columnFamilyName_in_dropTriggerStatement3042 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_K_ALTER_in_alterKeyspaceStatement3082 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000040L});
	public static final BitSet FOLLOW_K_KEYSPACE_in_alterKeyspaceStatement3084 = new BitSet(new long[]{0x81D9BD7142100000L,0x8027B153F07046B4L});
	public static final BitSet FOLLOW_keyspaceName_in_alterKeyspaceStatement3088 = new BitSet(new long[]{0x0000000000000000L,0x0010000000000000L});
	public static final BitSet FOLLOW_K_WITH_in_alterKeyspaceStatement3098 = new BitSet(new long[]{0x81D9BD7142100000L,0x8027B153F07046B4L});
	public static final BitSet FOLLOW_properties_in_alterKeyspaceStatement3100 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_K_ALTER_in_alterTableStatement3136 = new BitSet(new long[]{0x0000020000000000L});
	public static final BitSet FOLLOW_K_COLUMNFAMILY_in_alterTableStatement3138 = new BitSet(new long[]{0x81D9BD7142100000L,0x8027B153F07046B4L});
	public static final BitSet FOLLOW_columnFamilyName_in_alterTableStatement3142 = new BitSet(new long[]{0x0020000009000000L,0x0010000001000000L});
	public static final BitSet FOLLOW_K_ALTER_in_alterTableStatement3156 = new BitSet(new long[]{0x81D9BD7142100000L,0x8027B153F07046B4L});
	public static final BitSet FOLLOW_cident_in_alterTableStatement3160 = new BitSet(new long[]{0x0000000000000000L,0x0000010000000000L});
	public static final BitSet FOLLOW_K_TYPE_in_alterTableStatement3162 = new BitSet(new long[]{0x85D9BD7142100000L,0x8027B1D3F87046B4L,0x0000000000000004L});
	public static final BitSet FOLLOW_comparatorType_in_alterTableStatement3166 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_K_ADD_in_alterTableStatement3182 = new BitSet(new long[]{0x81D9BD7142100000L,0x8027B153F07046B4L});
	public static final BitSet FOLLOW_cident_in_alterTableStatement3188 = new BitSet(new long[]{0x85D9BD7142100000L,0x8027B1D3F87046B4L,0x0000000000000004L});
	public static final BitSet FOLLOW_comparatorType_in_alterTableStatement3192 = new BitSet(new long[]{0x0000000000000002L,0x0000000010000000L});
	public static final BitSet FOLLOW_K_STATIC_in_alterTableStatement3197 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_K_DROP_in_alterTableStatement3215 = new BitSet(new long[]{0x81D9BD7142100000L,0x8027B153F07046B4L});
	public static final BitSet FOLLOW_cident_in_alterTableStatement3220 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_K_WITH_in_alterTableStatement3260 = new BitSet(new long[]{0x81D9BD7142100000L,0x8027B153F07046B4L});
	public static final BitSet FOLLOW_properties_in_alterTableStatement3263 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_K_RENAME_in_alterTableStatement3296 = new BitSet(new long[]{0x81D9BD7142100000L,0x8027B153F07046B4L});
	public static final BitSet FOLLOW_cident_in_alterTableStatement3350 = new BitSet(new long[]{0x0000000000000000L,0x0000000400000000L});
	public static final BitSet FOLLOW_K_TO_in_alterTableStatement3352 = new BitSet(new long[]{0x81D9BD7142100000L,0x8027B153F07046B4L});
	public static final BitSet FOLLOW_cident_in_alterTableStatement3356 = new BitSet(new long[]{0x0000000010000002L});
	public static final BitSet FOLLOW_K_AND_in_alterTableStatement3377 = new BitSet(new long[]{0x81D9BD7142100000L,0x8027B153F07046B4L});
	public static final BitSet FOLLOW_cident_in_alterTableStatement3381 = new BitSet(new long[]{0x0000000000000000L,0x0000000400000000L});
	public static final BitSet FOLLOW_K_TO_in_alterTableStatement3383 = new BitSet(new long[]{0x81D9BD7142100000L,0x8027B153F07046B4L});
	public static final BitSet FOLLOW_cident_in_alterTableStatement3387 = new BitSet(new long[]{0x0000000010000002L});
	public static final BitSet FOLLOW_K_ALTER_in_alterTypeStatement3433 = new BitSet(new long[]{0x0000000000000000L,0x0000010000000000L});
	public static final BitSet FOLLOW_K_TYPE_in_alterTypeStatement3435 = new BitSet(new long[]{0x81D9BD7142100000L,0x8027B153F07046B4L});
	public static final BitSet FOLLOW_userTypeName_in_alterTypeStatement3439 = new BitSet(new long[]{0x0000000009000000L,0x0000000001000000L});
	public static final BitSet FOLLOW_K_ALTER_in_alterTypeStatement3453 = new BitSet(new long[]{0x81D9BD7142100000L,0x8027B153F07046B4L});
	public static final BitSet FOLLOW_ident_in_alterTypeStatement3457 = new BitSet(new long[]{0x0000000000000000L,0x0000010000000000L});
	public static final BitSet FOLLOW_K_TYPE_in_alterTypeStatement3459 = new BitSet(new long[]{0x85D9BD7142100000L,0x8027B1D3F87046B4L,0x0000000000000004L});
	public static final BitSet FOLLOW_comparatorType_in_alterTypeStatement3463 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_K_ADD_in_alterTypeStatement3479 = new BitSet(new long[]{0x81D9BD7142100000L,0x8027B153F07046B4L});
	public static final BitSet FOLLOW_ident_in_alterTypeStatement3485 = new BitSet(new long[]{0x85D9BD7142100000L,0x8027B1D3F87046B4L,0x0000000000000004L});
	public static final BitSet FOLLOW_comparatorType_in_alterTypeStatement3489 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_K_RENAME_in_alterTypeStatement3512 = new BitSet(new long[]{0x81D9BD7142100000L,0x8027B153F07046B4L});
	public static final BitSet FOLLOW_ident_in_alterTypeStatement3550 = new BitSet(new long[]{0x0000000000000000L,0x0000000400000000L});
	public static final BitSet FOLLOW_K_TO_in_alterTypeStatement3552 = new BitSet(new long[]{0x81D9BD7142100000L,0x8027B153F07046B4L});
	public static final BitSet FOLLOW_ident_in_alterTypeStatement3556 = new BitSet(new long[]{0x0000000010000002L});
	public static final BitSet FOLLOW_K_AND_in_alterTypeStatement3579 = new BitSet(new long[]{0x81D9BD7142100000L,0x8027B153F07046B4L});
	public static final BitSet FOLLOW_ident_in_alterTypeStatement3583 = new BitSet(new long[]{0x0000000000000000L,0x0000000400000000L});
	public static final BitSet FOLLOW_K_TO_in_alterTypeStatement3585 = new BitSet(new long[]{0x81D9BD7142100000L,0x8027B153F07046B4L});
	public static final BitSet FOLLOW_ident_in_alterTypeStatement3589 = new BitSet(new long[]{0x0000000010000002L});
	public static final BitSet FOLLOW_K_DROP_in_dropKeyspaceStatement3656 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000040L});
	public static final BitSet FOLLOW_K_KEYSPACE_in_dropKeyspaceStatement3658 = new BitSet(new long[]{0x91D9BD7142100000L,0x8027B153F07046B4L});
	public static final BitSet FOLLOW_K_IF_in_dropKeyspaceStatement3661 = new BitSet(new long[]{0x0040000000000000L});
	public static final BitSet FOLLOW_K_EXISTS_in_dropKeyspaceStatement3663 = new BitSet(new long[]{0x81D9BD7142100000L,0x8027B153F07046B4L});
	public static final BitSet FOLLOW_keyspaceName_in_dropKeyspaceStatement3672 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_K_DROP_in_dropTableStatement3706 = new BitSet(new long[]{0x0000020000000000L});
	public static final BitSet FOLLOW_K_COLUMNFAMILY_in_dropTableStatement3708 = new BitSet(new long[]{0x91D9BD7142100000L,0x8027B153F07046B4L});
	public static final BitSet FOLLOW_K_IF_in_dropTableStatement3711 = new BitSet(new long[]{0x0040000000000000L});
	public static final BitSet FOLLOW_K_EXISTS_in_dropTableStatement3713 = new BitSet(new long[]{0x81D9BD7142100000L,0x8027B153F07046B4L});
	public static final BitSet FOLLOW_columnFamilyName_in_dropTableStatement3722 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_K_DROP_in_dropTypeStatement3756 = new BitSet(new long[]{0x0000000000000000L,0x0000010000000000L});
	public static final BitSet FOLLOW_K_TYPE_in_dropTypeStatement3758 = new BitSet(new long[]{0x91D9BD7142100000L,0x8027B153F07046B4L});
	public static final BitSet FOLLOW_K_IF_in_dropTypeStatement3761 = new BitSet(new long[]{0x0040000000000000L});
	public static final BitSet FOLLOW_K_EXISTS_in_dropTypeStatement3763 = new BitSet(new long[]{0x81D9BD7142100000L,0x8027B153F07046B4L});
	public static final BitSet FOLLOW_userTypeName_in_dropTypeStatement3772 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_K_DROP_in_dropIndexStatement3806 = new BitSet(new long[]{0x4000000000000000L});
	public static final BitSet FOLLOW_K_INDEX_in_dropIndexStatement3808 = new BitSet(new long[]{0x91D9BD7142100000L,0x8027B153F07046B4L});
	public static final BitSet FOLLOW_K_IF_in_dropIndexStatement3811 = new BitSet(new long[]{0x0040000000000000L});
	public static final BitSet FOLLOW_K_EXISTS_in_dropIndexStatement3813 = new BitSet(new long[]{0x81D9BD7142100000L,0x8027B153F07046B4L});
	public static final BitSet FOLLOW_indexName_in_dropIndexStatement3822 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_K_TRUNCATE_in_truncateStatement3853 = new BitSet(new long[]{0x81D9BD7142100000L,0x8027B153F07046B4L});
	public static final BitSet FOLLOW_columnFamilyName_in_truncateStatement3857 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_K_GRANT_in_grantStatement3882 = new BitSet(new long[]{0x002040020A000000L,0x0000000004000800L});
	public static final BitSet FOLLOW_permissionOrAll_in_grantStatement3894 = new BitSet(new long[]{0x0000000000000000L,0x0000000000040000L});
	public static final BitSet FOLLOW_K_ON_in_grantStatement3902 = new BitSet(new long[]{0x81D9BF7142100000L,0x8027B153F07046F4L});
	public static final BitSet FOLLOW_resource_in_grantStatement3914 = new BitSet(new long[]{0x0000000000000000L,0x0000000400000000L});
	public static final BitSet FOLLOW_K_TO_in_grantStatement3922 = new BitSet(new long[]{0x0000000000100000L,0x0000000000000000L,0x0000000000000004L});
	public static final BitSet FOLLOW_username_in_grantStatement3934 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_K_REVOKE_in_revokeStatement3965 = new BitSet(new long[]{0x002040020A000000L,0x0000000004000800L});
	public static final BitSet FOLLOW_permissionOrAll_in_revokeStatement3977 = new BitSet(new long[]{0x0000000000000000L,0x0000000000040000L});
	public static final BitSet FOLLOW_K_ON_in_revokeStatement3985 = new BitSet(new long[]{0x81D9BF7142100000L,0x8027B153F07046F4L});
	public static final BitSet FOLLOW_resource_in_revokeStatement3997 = new BitSet(new long[]{0x0200000000000000L});
	public static final BitSet FOLLOW_K_FROM_in_revokeStatement4005 = new BitSet(new long[]{0x0000000000100000L,0x0000000000000000L,0x0000000000000004L});
	public static final BitSet FOLLOW_username_in_revokeStatement4017 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_K_LIST_in_listPermissionsStatement4055 = new BitSet(new long[]{0x002040020A000000L,0x0000000004000800L});
	public static final BitSet FOLLOW_permissionOrAll_in_listPermissionsStatement4067 = new BitSet(new long[]{0x0000000000000002L,0x0000000000062000L});
	public static final BitSet FOLLOW_K_ON_in_listPermissionsStatement4077 = new BitSet(new long[]{0x81D9BF7142100000L,0x8027B153F07046F4L});
	public static final BitSet FOLLOW_resource_in_listPermissionsStatement4079 = new BitSet(new long[]{0x0000000000000002L,0x0000000000022000L});
	public static final BitSet FOLLOW_K_OF_in_listPermissionsStatement4094 = new BitSet(new long[]{0x0000000000100000L,0x0000000000000000L,0x0000000000000004L});
	public static final BitSet FOLLOW_username_in_listPermissionsStatement4096 = new BitSet(new long[]{0x0000000000000002L,0x0000000000002000L});
	public static final BitSet FOLLOW_K_NORECURSIVE_in_listPermissionsStatement4111 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_set_in_permission4147 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_K_ALL_in_permissionOrAll4196 = new BitSet(new long[]{0x0000000000000002L,0x0000000000400000L});
	public static final BitSet FOLLOW_K_PERMISSIONS_in_permissionOrAll4200 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_permission_in_permissionOrAll4221 = new BitSet(new long[]{0x0000000000000002L,0x0000000000200000L});
	public static final BitSet FOLLOW_K_PERMISSION_in_permissionOrAll4225 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_dataResource_in_resource4253 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_K_ALL_in_dataResource4276 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000080L});
	public static final BitSet FOLLOW_K_KEYSPACES_in_dataResource4278 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_K_KEYSPACE_in_dataResource4288 = new BitSet(new long[]{0x81D9BD7142100000L,0x8027B153F07046B4L});
	public static final BitSet FOLLOW_keyspaceName_in_dataResource4294 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_K_COLUMNFAMILY_in_dataResource4306 = new BitSet(new long[]{0x81D9BD7142100000L,0x8027B153F07046B4L});
	public static final BitSet FOLLOW_columnFamilyName_in_dataResource4315 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_K_CREATE_in_createUserStatement4355 = new BitSet(new long[]{0x0000000000000000L,0x0000100000000000L});
	public static final BitSet FOLLOW_K_USER_in_createUserStatement4357 = new BitSet(new long[]{0x1000000000100000L,0x0000000000000000L,0x0000000000000004L});
	public static final BitSet FOLLOW_K_IF_in_createUserStatement4360 = new BitSet(new long[]{0x0000000000000000L,0x0000000000008000L});
	public static final BitSet FOLLOW_K_NOT_in_createUserStatement4362 = new BitSet(new long[]{0x0040000000000000L});
	public static final BitSet FOLLOW_K_EXISTS_in_createUserStatement4364 = new BitSet(new long[]{0x0000000000100000L,0x0000000000000000L,0x0000000000000004L});
	public static final BitSet FOLLOW_username_in_createUserStatement4370 = new BitSet(new long[]{0x0000000000000002L,0x0010000040004000L});
	public static final BitSet FOLLOW_K_WITH_in_createUserStatement4380 = new BitSet(new long[]{0x0000000000000000L,0x0000000000100000L});
	public static final BitSet FOLLOW_userOptions_in_createUserStatement4382 = new BitSet(new long[]{0x0000000000000002L,0x0000000040004000L});
	public static final BitSet FOLLOW_K_SUPERUSER_in_createUserStatement4396 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_K_NOSUPERUSER_in_createUserStatement4402 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_K_ALTER_in_alterUserStatement4447 = new BitSet(new long[]{0x0000000000000000L,0x0000100000000000L});
	public static final BitSet FOLLOW_K_USER_in_alterUserStatement4449 = new BitSet(new long[]{0x0000000000100000L,0x0000000000000000L,0x0000000000000004L});
	public static final BitSet FOLLOW_username_in_alterUserStatement4451 = new BitSet(new long[]{0x0000000000000002L,0x0010000040004000L});
	public static final BitSet FOLLOW_K_WITH_in_alterUserStatement4461 = new BitSet(new long[]{0x0000000000000000L,0x0000000000100000L});
	public static final BitSet FOLLOW_userOptions_in_alterUserStatement4463 = new BitSet(new long[]{0x0000000000000002L,0x0000000040004000L});
	public static final BitSet FOLLOW_K_SUPERUSER_in_alterUserStatement4477 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_K_NOSUPERUSER_in_alterUserStatement4483 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_K_DROP_in_dropUserStatement4528 = new BitSet(new long[]{0x0000000000000000L,0x0000100000000000L});
	public static final BitSet FOLLOW_K_USER_in_dropUserStatement4530 = new BitSet(new long[]{0x1000000000100000L,0x0000000000000000L,0x0000000000000004L});
	public static final BitSet FOLLOW_K_IF_in_dropUserStatement4533 = new BitSet(new long[]{0x0040000000000000L});
	public static final BitSet FOLLOW_K_EXISTS_in_dropUserStatement4535 = new BitSet(new long[]{0x0000000000100000L,0x0000000000000000L,0x0000000000000004L});
	public static final BitSet FOLLOW_username_in_dropUserStatement4541 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_K_LIST_in_listUsersStatement4566 = new BitSet(new long[]{0x0000000000000000L,0x0000200000000000L});
	public static final BitSet FOLLOW_K_USERS_in_listUsersStatement4568 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_userOption_in_userOptions4588 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_K_PASSWORD_in_userOption4609 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000000004L});
	public static final BitSet FOLLOW_STRING_LITERAL_in_userOption4613 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_IDENT_in_cident4644 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_QUOTED_NAME_in_cident4669 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_unreserved_keyword_in_cident4688 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_IDENT_in_ident4714 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_QUOTED_NAME_in_ident4739 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_unreserved_keyword_in_ident4758 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_cfOrKsName_in_keyspaceName4791 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_idxOrKsName_in_indexName4825 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000040000L});
	public static final BitSet FOLLOW_146_in_indexName4828 = new BitSet(new long[]{0x81D9BD7142100000L,0x8027B153F07046B4L});
	public static final BitSet FOLLOW_idxOrKsName_in_indexName4832 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_IDENT_in_idxOrKsName4853 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_QUOTED_NAME_in_idxOrKsName4878 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_unreserved_keyword_in_idxOrKsName4897 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_cfOrKsName_in_columnFamilyName4930 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000040000L});
	public static final BitSet FOLLOW_146_in_columnFamilyName4933 = new BitSet(new long[]{0x81D9BD7142100000L,0x8027B153F07046B4L});
	public static final BitSet FOLLOW_cfOrKsName_in_columnFamilyName4937 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_ident_in_userTypeName4962 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000040000L});
	public static final BitSet FOLLOW_146_in_userTypeName4964 = new BitSet(new long[]{0x00C88D0042100000L,0x80013110707046B0L});
	public static final BitSet FOLLOW_non_type_ident_in_userTypeName4970 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_IDENT_in_cfOrKsName4992 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_QUOTED_NAME_in_cfOrKsName5017 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_unreserved_keyword_in_cfOrKsName5036 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_STRING_LITERAL_in_constant5061 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_INTEGER_in_constant5073 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_FLOAT_in_constant5092 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_BOOLEAN_in_constant5113 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_UUID_in_constant5132 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_HEXNUMBER_in_constant5154 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_145_in_constant5172 = new BitSet(new long[]{0x0000000000000000L,0x0000000000001001L});
	public static final BitSet FOLLOW_set_in_constant5181 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_157_in_mapLiteral5210 = new BitSet(new long[]{0x81D9AD7142344040L,0x4007B11BF07156A5L,0x00000000640A2024L});
	public static final BitSet FOLLOW_term_in_mapLiteral5228 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000080000L});
	public static final BitSet FOLLOW_147_in_mapLiteral5230 = new BitSet(new long[]{0x81D9AD7142344040L,0x4007B11BF07156A5L,0x00000000240A2024L});
	public static final BitSet FOLLOW_term_in_mapLiteral5234 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000040010000L});
	public static final BitSet FOLLOW_144_in_mapLiteral5240 = new BitSet(new long[]{0x81D9AD7142344040L,0x4007B11BF07156A5L,0x00000000240A2024L});
	public static final BitSet FOLLOW_term_in_mapLiteral5244 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000080000L});
	public static final BitSet FOLLOW_147_in_mapLiteral5246 = new BitSet(new long[]{0x81D9AD7142344040L,0x4007B11BF07156A5L,0x00000000240A2024L});
	public static final BitSet FOLLOW_term_in_mapLiteral5250 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000040010000L});
	public static final BitSet FOLLOW_158_in_mapLiteral5266 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_147_in_setOrMapLiteral5290 = new BitSet(new long[]{0x81D9AD7142344040L,0x4007B11BF07156A5L,0x00000000240A2024L});
	public static final BitSet FOLLOW_term_in_setOrMapLiteral5294 = new BitSet(new long[]{0x0000000000000002L,0x0000000000000000L,0x0000000000010000L});
	public static final BitSet FOLLOW_144_in_setOrMapLiteral5310 = new BitSet(new long[]{0x81D9AD7142344040L,0x4007B11BF07156A5L,0x00000000240A2024L});
	public static final BitSet FOLLOW_term_in_setOrMapLiteral5314 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000080000L});
	public static final BitSet FOLLOW_147_in_setOrMapLiteral5316 = new BitSet(new long[]{0x81D9AD7142344040L,0x4007B11BF07156A5L,0x00000000240A2024L});
	public static final BitSet FOLLOW_term_in_setOrMapLiteral5320 = new BitSet(new long[]{0x0000000000000002L,0x0000000000000000L,0x0000000000010000L});
	public static final BitSet FOLLOW_144_in_setOrMapLiteral5355 = new BitSet(new long[]{0x81D9AD7142344040L,0x4007B11BF07156A5L,0x00000000240A2024L});
	public static final BitSet FOLLOW_term_in_setOrMapLiteral5359 = new BitSet(new long[]{0x0000000000000002L,0x0000000000000000L,0x0000000000010000L});
	public static final BitSet FOLLOW_154_in_collectionLiteral5393 = new BitSet(new long[]{0x81D9AD7142344040L,0x4007B11BF07156A5L,0x00000000340A2024L});
	public static final BitSet FOLLOW_term_in_collectionLiteral5411 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000010010000L});
	public static final BitSet FOLLOW_144_in_collectionLiteral5417 = new BitSet(new long[]{0x81D9AD7142344040L,0x4007B11BF07156A5L,0x00000000240A2024L});
	public static final BitSet FOLLOW_term_in_collectionLiteral5421 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000010010000L});
	public static final BitSet FOLLOW_156_in_collectionLiteral5437 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_157_in_collectionLiteral5447 = new BitSet(new long[]{0x81D9AD7142344040L,0x4007B11BF07156A5L,0x00000000240A2024L});
	public static final BitSet FOLLOW_term_in_collectionLiteral5451 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000040090000L});
	public static final BitSet FOLLOW_setOrMapLiteral_in_collectionLiteral5455 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000040000000L});
	public static final BitSet FOLLOW_158_in_collectionLiteral5460 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_157_in_collectionLiteral5478 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000040000000L});
	public static final BitSet FOLLOW_158_in_collectionLiteral5480 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_157_in_usertypeLiteral5524 = new BitSet(new long[]{0x81D9BD7142100000L,0x8027B153F07046B4L});
	public static final BitSet FOLLOW_ident_in_usertypeLiteral5528 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000080000L});
	public static final BitSet FOLLOW_147_in_usertypeLiteral5530 = new BitSet(new long[]{0x81D9AD7142344040L,0x4007B11BF07156A5L,0x00000000240A2024L});
	public static final BitSet FOLLOW_term_in_usertypeLiteral5534 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000040010000L});
	public static final BitSet FOLLOW_144_in_usertypeLiteral5540 = new BitSet(new long[]{0x81D9BD7142100000L,0x8027B153F07046B4L});
	public static final BitSet FOLLOW_ident_in_usertypeLiteral5544 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000080000L});
	public static final BitSet FOLLOW_147_in_usertypeLiteral5546 = new BitSet(new long[]{0x81D9AD7142344040L,0x4007B11BF07156A5L,0x00000000240A2024L});
	public static final BitSet FOLLOW_term_in_usertypeLiteral5550 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000040010000L});
	public static final BitSet FOLLOW_158_in_usertypeLiteral5557 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_141_in_tupleLiteral5594 = new BitSet(new long[]{0x81D9AD7142344040L,0x4007B11BF07156A5L,0x00000000240A2024L});
	public static final BitSet FOLLOW_term_in_tupleLiteral5598 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000014000L});
	public static final BitSet FOLLOW_144_in_tupleLiteral5604 = new BitSet(new long[]{0x81D9AD7142344040L,0x4007B11BF07156A5L,0x00000000240A2024L});
	public static final BitSet FOLLOW_term_in_tupleLiteral5608 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000014000L});
	public static final BitSet FOLLOW_142_in_tupleLiteral5615 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_constant_in_value5638 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_collectionLiteral_in_value5660 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_usertypeLiteral_in_value5673 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_tupleLiteral_in_value5688 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_K_NULL_in_value5704 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_147_in_value5728 = new BitSet(new long[]{0x81D9BD7142100000L,0x8027B153F07046B4L});
	public static final BitSet FOLLOW_ident_in_value5732 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_QMARK_in_value5750 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_INTEGER_in_intValue5796 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_147_in_intValue5810 = new BitSet(new long[]{0x81D9BD7142100000L,0x8027B153F07046B4L});
	public static final BitSet FOLLOW_ident_in_intValue5814 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_QMARK_in_intValue5825 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_IDENT_in_functionName5858 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_unreserved_function_keyword_in_functionName5892 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_K_TOKEN_in_functionName5902 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_141_in_functionArgs5947 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000004000L});
	public static final BitSet FOLLOW_142_in_functionArgs5949 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_141_in_functionArgs5959 = new BitSet(new long[]{0x81D9AD7142344040L,0x4007B11BF07156A5L,0x00000000240A2024L});
	public static final BitSet FOLLOW_term_in_functionArgs5963 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000014000L});
	public static final BitSet FOLLOW_144_in_functionArgs5979 = new BitSet(new long[]{0x81D9AD7142344040L,0x4007B11BF07156A5L,0x00000000240A2024L});
	public static final BitSet FOLLOW_term_in_functionArgs5983 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000014000L});
	public static final BitSet FOLLOW_142_in_functionArgs5997 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_value_in_term6022 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_functionName_in_term6059 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000002000L});
	public static final BitSet FOLLOW_functionArgs_in_term6063 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_141_in_term6073 = new BitSet(new long[]{0x85D9BD7142100000L,0x8027B1D3F87046B4L,0x0000000000000004L});
	public static final BitSet FOLLOW_comparatorType_in_term6077 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000004000L});
	public static final BitSet FOLLOW_142_in_term6079 = new BitSet(new long[]{0x81D9AD7142344040L,0x4007B11BF07156A5L,0x00000000240A2024L});
	public static final BitSet FOLLOW_term_in_term6083 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_cident_in_columnOperation6106 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000004800000L});
	public static final BitSet FOLLOW_columnOperationDifferentiator_in_columnOperation6108 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_151_in_columnOperationDifferentiator6127 = new BitSet(new long[]{0x81D9BD7142344040L,0xC027B15BF07156B5L,0x00000000240A2024L});
	public static final BitSet FOLLOW_normalColumnOperation_in_columnOperationDifferentiator6129 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_154_in_columnOperationDifferentiator6138 = new BitSet(new long[]{0x81D9AD7142344040L,0x4007B11BF07156A5L,0x00000000240A2024L});
	public static final BitSet FOLLOW_term_in_columnOperationDifferentiator6142 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000010000000L});
	public static final BitSet FOLLOW_156_in_columnOperationDifferentiator6144 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000800000L});
	public static final BitSet FOLLOW_specializedColumnOperation_in_columnOperationDifferentiator6146 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_term_in_normalColumnOperation6167 = new BitSet(new long[]{0x0000000000000002L,0x0000000000000000L,0x0000000000008000L});
	public static final BitSet FOLLOW_143_in_normalColumnOperation6170 = new BitSet(new long[]{0x81D9BD7142100000L,0x8027B153F07046B4L});
	public static final BitSet FOLLOW_cident_in_normalColumnOperation6174 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_cident_in_normalColumnOperation6195 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000028000L});
	public static final BitSet FOLLOW_set_in_normalColumnOperation6199 = new BitSet(new long[]{0x81D9AD7142344040L,0x4007B11BF07156A5L,0x00000000240A2024L});
	public static final BitSet FOLLOW_term_in_normalColumnOperation6209 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_cident_in_normalColumnOperation6227 = new BitSet(new long[]{0x0000000000200000L});
	public static final BitSet FOLLOW_INTEGER_in_normalColumnOperation6231 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_151_in_specializedColumnOperation6257 = new BitSet(new long[]{0x81D9AD7142344040L,0x4007B11BF07156A5L,0x00000000240A2024L});
	public static final BitSet FOLLOW_term_in_specializedColumnOperation6261 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_cident_in_columnCondition6294 = new BitSet(new long[]{0x2000000000000000L,0x0000000000000000L,0x0000000007E01000L});
	public static final BitSet FOLLOW_relationType_in_columnCondition6308 = new BitSet(new long[]{0x81D9AD7142344040L,0x4007B11BF07156A5L,0x00000000240A2024L});
	public static final BitSet FOLLOW_term_in_columnCondition6312 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_K_IN_in_columnCondition6326 = new BitSet(new long[]{0x0000000000000000L,0x4000000000000000L,0x0000000000082000L});
	public static final BitSet FOLLOW_singleColumnInValues_in_columnCondition6344 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_inMarker_in_columnCondition6364 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_154_in_columnCondition6392 = new BitSet(new long[]{0x81D9AD7142344040L,0x4007B11BF07156A5L,0x00000000240A2024L});
	public static final BitSet FOLLOW_term_in_columnCondition6396 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000010000000L});
	public static final BitSet FOLLOW_156_in_columnCondition6398 = new BitSet(new long[]{0x2000000000000000L,0x0000000000000000L,0x0000000003E01000L});
	public static final BitSet FOLLOW_relationType_in_columnCondition6416 = new BitSet(new long[]{0x81D9AD7142344040L,0x4007B11BF07156A5L,0x00000000240A2024L});
	public static final BitSet FOLLOW_term_in_columnCondition6420 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_K_IN_in_columnCondition6438 = new BitSet(new long[]{0x0000000000000000L,0x4000000000000000L,0x0000000000082000L});
	public static final BitSet FOLLOW_singleColumnInValues_in_columnCondition6460 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_inMarker_in_columnCondition6484 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_property_in_properties6546 = new BitSet(new long[]{0x0000000010000002L});
	public static final BitSet FOLLOW_K_AND_in_properties6550 = new BitSet(new long[]{0x81D9BD7142100000L,0x8027B153F07046B4L});
	public static final BitSet FOLLOW_property_in_properties6552 = new BitSet(new long[]{0x0000000010000002L});
	public static final BitSet FOLLOW_ident_in_property6575 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000800000L});
	public static final BitSet FOLLOW_151_in_property6577 = new BitSet(new long[]{0x81D9BD7142244040L,0x0027B153F07056B5L,0x0000000020020024L});
	public static final BitSet FOLLOW_propertyValue_in_property6582 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_mapLiteral_in_property6610 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_constant_in_propertyValue6639 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_unreserved_keyword_in_propertyValue6661 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_151_in_relationType6684 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_149_in_relationType6695 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_150_in_relationType6706 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_152_in_relationType6716 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_153_in_relationType6727 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_140_in_relationType6737 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_cident_in_relation6759 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000003E01000L});
	public static final BitSet FOLLOW_relationType_in_relation6763 = new BitSet(new long[]{0x81D9AD7142344040L,0x4007B11BF07156A5L,0x00000000240A2024L});
	public static final BitSet FOLLOW_term_in_relation6767 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_K_TOKEN_in_relation6777 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000002000L});
	public static final BitSet FOLLOW_tupleOfIdentifiers_in_relation6781 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000003E01000L});
	public static final BitSet FOLLOW_relationType_in_relation6785 = new BitSet(new long[]{0x81D9AD7142344040L,0x4007B11BF07156A5L,0x00000000240A2024L});
	public static final BitSet FOLLOW_term_in_relation6789 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_cident_in_relation6809 = new BitSet(new long[]{0x2000000000000000L});
	public static final BitSet FOLLOW_K_IN_in_relation6811 = new BitSet(new long[]{0x0000000000000000L,0x4000000000000000L,0x0000000000080000L});
	public static final BitSet FOLLOW_inMarker_in_relation6815 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_cident_in_relation6835 = new BitSet(new long[]{0x2000000000000000L});
	public static final BitSet FOLLOW_K_IN_in_relation6837 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000002000L});
	public static final BitSet FOLLOW_singleColumnInValues_in_relation6841 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_cident_in_relation6861 = new BitSet(new long[]{0x0000080000000000L});
	public static final BitSet FOLLOW_K_CONTAINS_in_relation6863 = new BitSet(new long[]{0x81D9AD7142344040L,0x4007B11BF07156B5L,0x00000000240A2024L});
	public static final BitSet FOLLOW_K_KEY_in_relation6868 = new BitSet(new long[]{0x81D9AD7142344040L,0x4007B11BF07156A5L,0x00000000240A2024L});
	public static final BitSet FOLLOW_term_in_relation6884 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_tupleOfIdentifiers_in_relation6896 = new BitSet(new long[]{0x2000000000000000L,0x0000000000000000L,0x0000000003E01000L});
	public static final BitSet FOLLOW_K_IN_in_relation6906 = new BitSet(new long[]{0x0000000000000000L,0x4000000000000000L,0x0000000000082000L});
	public static final BitSet FOLLOW_141_in_relation6920 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000004000L});
	public static final BitSet FOLLOW_142_in_relation6922 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_inMarkerForTuple_in_relation6954 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_tupleOfTupleLiterals_in_relation6988 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_tupleOfMarkersForTuples_in_relation7022 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_relationType_in_relation7064 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000002000L});
	public static final BitSet FOLLOW_tupleLiteral_in_relation7068 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_relationType_in_relation7094 = new BitSet(new long[]{0x0000000000000000L,0x4000000000000000L,0x0000000000080000L});
	public static final BitSet FOLLOW_markerForTuple_in_relation7098 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_141_in_relation7128 = new BitSet(new long[]{0x81D9BD7142100000L,0x8027B15BF07046B4L,0x0000000000002000L});
	public static final BitSet FOLLOW_relation_in_relation7130 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000004000L});
	public static final BitSet FOLLOW_142_in_relation7133 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_QMARK_in_inMarker7154 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_147_in_inMarker7164 = new BitSet(new long[]{0x81D9BD7142100000L,0x8027B153F07046B4L});
	public static final BitSet FOLLOW_ident_in_inMarker7168 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_141_in_tupleOfIdentifiers7200 = new BitSet(new long[]{0x81D9BD7142100000L,0x8027B153F07046B4L});
	public static final BitSet FOLLOW_cident_in_tupleOfIdentifiers7204 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000014000L});
	public static final BitSet FOLLOW_144_in_tupleOfIdentifiers7209 = new BitSet(new long[]{0x81D9BD7142100000L,0x8027B153F07046B4L});
	public static final BitSet FOLLOW_cident_in_tupleOfIdentifiers7213 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000014000L});
	public static final BitSet FOLLOW_142_in_tupleOfIdentifiers7219 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_141_in_singleColumnInValues7249 = new BitSet(new long[]{0x81D9AD7142344040L,0x4007B11BF07156A5L,0x00000000240A6024L});
	public static final BitSet FOLLOW_term_in_singleColumnInValues7257 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000014000L});
	public static final BitSet FOLLOW_144_in_singleColumnInValues7262 = new BitSet(new long[]{0x81D9AD7142344040L,0x4007B11BF07156A5L,0x00000000240A2024L});
	public static final BitSet FOLLOW_term_in_singleColumnInValues7266 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000014000L});
	public static final BitSet FOLLOW_142_in_singleColumnInValues7275 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_141_in_tupleOfTupleLiterals7305 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000002000L});
	public static final BitSet FOLLOW_tupleLiteral_in_tupleOfTupleLiterals7309 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000014000L});
	public static final BitSet FOLLOW_144_in_tupleOfTupleLiterals7314 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000002000L});
	public static final BitSet FOLLOW_tupleLiteral_in_tupleOfTupleLiterals7318 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000014000L});
	public static final BitSet FOLLOW_142_in_tupleOfTupleLiterals7324 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_QMARK_in_markerForTuple7345 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_147_in_markerForTuple7355 = new BitSet(new long[]{0x81D9BD7142100000L,0x8027B153F07046B4L});
	public static final BitSet FOLLOW_ident_in_markerForTuple7359 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_141_in_tupleOfMarkersForTuples7391 = new BitSet(new long[]{0x0000000000000000L,0x4000000000000000L,0x0000000000080000L});
	public static final BitSet FOLLOW_markerForTuple_in_tupleOfMarkersForTuples7395 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000014000L});
	public static final BitSet FOLLOW_144_in_tupleOfMarkersForTuples7400 = new BitSet(new long[]{0x0000000000000000L,0x4000000000000000L,0x0000000000080000L});
	public static final BitSet FOLLOW_markerForTuple_in_tupleOfMarkersForTuples7404 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000014000L});
	public static final BitSet FOLLOW_142_in_tupleOfMarkersForTuples7410 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_QMARK_in_inMarkerForTuple7431 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_147_in_inMarkerForTuple7441 = new BitSet(new long[]{0x81D9BD7142100000L,0x8027B153F07046B4L});
	public static final BitSet FOLLOW_ident_in_inMarkerForTuple7445 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_native_type_in_comparatorType7470 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_collection_type_in_comparatorType7486 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_tuple_type_in_comparatorType7498 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_userTypeName_in_comparatorType7514 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_K_FROZEN_in_comparatorType7526 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000200000L});
	public static final BitSet FOLLOW_149_in_comparatorType7528 = new BitSet(new long[]{0x85D9BD7142100000L,0x8027B1D3F87046B4L,0x0000000000000004L});
	public static final BitSet FOLLOW_comparatorType_in_comparatorType7532 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000001000000L});
	public static final BitSet FOLLOW_152_in_comparatorType7534 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_STRING_LITERAL_in_comparatorType7552 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_K_ASCII_in_native_type7581 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_K_BIGINT_in_native_type7595 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_K_BLOB_in_native_type7608 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_K_BOOLEAN_in_native_type7623 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_K_COUNTER_in_native_type7635 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_K_DECIMAL_in_native_type7647 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_K_DOUBLE_in_native_type7659 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_K_FLOAT_in_native_type7672 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_K_INET_in_native_type7686 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_K_INT_in_native_type7701 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_K_TEXT_in_native_type7717 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_K_TIMESTAMP_in_native_type7732 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_K_UUID_in_native_type7742 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_K_VARCHAR_in_native_type7757 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_K_VARINT_in_native_type7769 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_K_TIMEUUID_in_native_type7782 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_K_MAP_in_collection_type7806 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000200000L});
	public static final BitSet FOLLOW_149_in_collection_type7809 = new BitSet(new long[]{0x85D9BD7142100000L,0x8027B1D3F87046B4L,0x0000000000000004L});
	public static final BitSet FOLLOW_comparatorType_in_collection_type7813 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000010000L});
	public static final BitSet FOLLOW_144_in_collection_type7815 = new BitSet(new long[]{0x85D9BD7142100000L,0x8027B1D3F87046B4L,0x0000000000000004L});
	public static final BitSet FOLLOW_comparatorType_in_collection_type7819 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000001000000L});
	public static final BitSet FOLLOW_152_in_collection_type7821 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_K_LIST_in_collection_type7839 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000200000L});
	public static final BitSet FOLLOW_149_in_collection_type7841 = new BitSet(new long[]{0x85D9BD7142100000L,0x8027B1D3F87046B4L,0x0000000000000004L});
	public static final BitSet FOLLOW_comparatorType_in_collection_type7845 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000001000000L});
	public static final BitSet FOLLOW_152_in_collection_type7847 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_K_SET_in_collection_type7865 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000200000L});
	public static final BitSet FOLLOW_149_in_collection_type7868 = new BitSet(new long[]{0x85D9BD7142100000L,0x8027B1D3F87046B4L,0x0000000000000004L});
	public static final BitSet FOLLOW_comparatorType_in_collection_type7872 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000001000000L});
	public static final BitSet FOLLOW_152_in_collection_type7874 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_K_TUPLE_in_tuple_type7905 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000200000L});
	public static final BitSet FOLLOW_149_in_tuple_type7907 = new BitSet(new long[]{0x85D9BD7142100000L,0x8027B1D3F87046B4L,0x0000000000000004L});
	public static final BitSet FOLLOW_comparatorType_in_tuple_type7922 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000001010000L});
	public static final BitSet FOLLOW_144_in_tuple_type7927 = new BitSet(new long[]{0x85D9BD7142100000L,0x8027B1D3F87046B4L,0x0000000000000004L});
	public static final BitSet FOLLOW_comparatorType_in_tuple_type7931 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000001010000L});
	public static final BitSet FOLLOW_152_in_tuple_type7943 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_IDENT_in_non_type_ident7995 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_QUOTED_NAME_in_non_type_ident8026 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_basic_unreserved_keyword_in_non_type_ident8051 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_K_KEY_in_non_type_ident8063 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_unreserved_function_keyword_in_unreserved_keyword8106 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_set_in_unreserved_keyword8122 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_basic_unreserved_keyword_in_unreserved_function_keyword8161 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_native_type_in_unreserved_function_keyword8173 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_set_in_basic_unreserved_keyword8211 = new BitSet(new long[]{0x0000000000000002L});
}
