/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.util;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMContainer;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMNamespace;
import org.apache.axiom.soap.SOAPBody;
import org.apache.axiom.soap.SOAPEnvelope;
import org.apache.axiom.soap.SOAPFactory;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.MessageContext;
import org.apache.ws.commons.schema.XmlSchema;
import org.apache.ws.commons.schema.XmlSchemaComplexType;
import org.apache.ws.commons.schema.XmlSchemaElement;
import org.apache.ws.commons.schema.XmlSchemaImport;
import org.apache.ws.commons.schema.XmlSchemaInclude;
import org.apache.ws.commons.schema.XmlSchemaObjectCollection;
import org.apache.ws.commons.schema.XmlSchemaParticle;
import org.apache.ws.commons.schema.XmlSchemaSequence;
import org.apache.ws.commons.schema.XmlSchemaType;

public class SchemaUtil {
    public static XmlSchema[] getAllSchemas(XmlSchema schema) {
        HashMap map = new HashMap();
        SchemaUtil.traverseSchemas(schema, map);
        return map.values().toArray(new XmlSchema[map.values().size()]);
    }

    private static void traverseSchemas(XmlSchema schema, HashMap map) {
        String key = schema.getTargetNamespace() + ":" + schema.getSourceURI();
        if (map.containsKey(key)) {
            return;
        }
        map.put(key, schema);
        XmlSchemaObjectCollection includes = schema.getIncludes();
        if (includes != null) {
            Iterator tempIterator = includes.getIterator();
            while (tempIterator.hasNext()) {
                XmlSchema schema1;
                Object o = tempIterator.next();
                if (o instanceof XmlSchemaImport && (schema1 = ((XmlSchemaImport)o).getSchema()) != null) {
                    SchemaUtil.traverseSchemas(schema1, map);
                }
                if (!(o instanceof XmlSchemaInclude) || (schema1 = ((XmlSchemaInclude)o).getSchema()) == null) continue;
                SchemaUtil.traverseSchemas(schema1, map);
            }
        }
    }

    public static SOAPEnvelope handleMediaTypeURLEncoded(MessageContext msgCtxt, HttpServletRequest request, XmlSchemaElement xmlSchemaElement, SOAPFactory soapFactory) throws AxisFault {
        Map requestParameterMap = request.getParameterMap();
        SOAPEnvelope soapEnvelope = soapFactory.getDefaultEnvelope();
        SOAPBody body = soapEnvelope.getBody();
        if (xmlSchemaElement == null) {
            OMElement bodyFirstChild = soapFactory.createOMElement(msgCtxt.getAxisOperation().getName(), (OMContainer)body);
            if (requestParameterMap != null) {
                Iterator requestParamMapIter = requestParameterMap.keySet().iterator();
                while (requestParamMapIter.hasNext()) {
                    String key = (String)requestParamMapIter.next();
                    String value = (String)((Object[])requestParameterMap.get(key))[0];
                    soapFactory.createOMElement(key, null, (OMContainer)bodyFirstChild).setText(value);
                }
            }
        } else {
            String targetNamespace = xmlSchemaElement.getQName().getNamespaceURI();
            QName bodyFirstChildQName = targetNamespace != null && !"".equals(targetNamespace) ? new QName(targetNamespace, xmlSchemaElement.getName()) : new QName(xmlSchemaElement.getName());
            OMElement bodyFirstChild = soapFactory.createOMElement(bodyFirstChildQName, (OMContainer)body);
            if ("POST".equals(request.getMethod()) || "GET".equals(request.getMethod())) {
                XmlSchemaComplexType complexType;
                XmlSchemaParticle particle;
                XmlSchemaType schemaType = xmlSchemaElement.getSchemaType();
                if (schemaType instanceof XmlSchemaComplexType && (particle = (complexType = (XmlSchemaComplexType)schemaType).getParticle()) instanceof XmlSchemaSequence) {
                    XmlSchemaSequence xmlSchemaSequence = (XmlSchemaSequence)particle;
                    Iterator iterator = xmlSchemaSequence.getItems().getIterator();
                    Map parameterMap = request.getParameterMap();
                    while (iterator.hasNext()) {
                        XmlSchemaElement innerElement = (XmlSchemaElement)iterator.next();
                        QName qName = innerElement.getQName();
                        String name = qName != null ? qName.getLocalPart() : innerElement.getName();
                        String[] parameterValuesArray = (String[])parameterMap.get(name);
                        if (parameterValuesArray != null && !"".equals(parameterValuesArray[0]) && parameterValuesArray[0] != null) {
                            OMNamespace ns = qName == null || qName.getNamespaceURI() == null || qName.getNamespaceURI().length() == 0 ? null : soapFactory.createOMNamespace(qName.getNamespaceURI(), null);
                            soapFactory.createOMElement(name, ns, (OMContainer)bodyFirstChild).setText(parameterValuesArray[0]);
                            continue;
                        }
                        throw new AxisFault("Required element " + qName + " defined in the schema can not be found in the request");
                    }
                }
            } else {
                throw new AxisFault("According to WSDL 2.0 rules, we support complex types only");
            }
        }
        return soapEnvelope;
    }
}

