/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.transport.http.server;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.axis2.transport.OutTransportInfo;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.io.ByteArrayBuffer;

public class OutputBuffer
implements OutTransportInfo,
HttpEntity {
    private final ByteArrayBuffer buffer;
    private String contentType;
    private boolean chunked;

    public OutputBuffer(int initialCapacity) {
        this.buffer = new ByteArrayBuffer(initialCapacity);
        this.contentType = "text/xml";
    }

    public OutputBuffer() {
        this(1024);
    }

    public OutputStream getOutputStream() {
        return new BufferOutputStream(this.buffer);
    }

    public InputStream getContent() throws IOException, IllegalStateException {
        return new ByteArrayInputStream(this.buffer.toByteArray());
    }

    public void setContentType(String contentType) {
        this.contentType = contentType;
    }

    public Header getContentType() {
        return new Header("Content-Type", this.contentType);
    }

    public void consumeContent() throws IOException {
    }

    public Header getContentEncoding() {
        return null;
    }

    public long getContentLength() {
        return this.buffer.length();
    }

    public boolean isChunked() {
        return this.chunked;
    }

    public void setChunked(boolean b) {
        this.chunked = b;
    }

    public boolean isRepeatable() {
        return true;
    }

    public boolean isStreaming() {
        return false;
    }

    public void writeTo(OutputStream outstream) throws IOException {
        outstream.write(this.buffer.buffer(), 0, this.buffer.length());
    }

    public String toString() {
        return new String(this.buffer.buffer(), 0, this.buffer.length());
    }

    private static class BufferOutputStream
    extends OutputStream {
        private final ByteArrayBuffer buffer;
        private boolean closed = false;

        public BufferOutputStream(ByteArrayBuffer buffer) {
            this.buffer = buffer;
        }

        public void close() throws IOException {
            this.closed = true;
        }

        private void ensureNotClosed() {
            if (this.closed) {
                throw new IllegalStateException("Stream closed");
            }
        }

        public void write(byte[] b, int off, int len) throws IOException {
            this.ensureNotClosed();
            if (b == null) {
                return;
            }
            this.buffer.append(b, off, len);
        }

        public void write(byte[] b) throws IOException {
            this.ensureNotClosed();
            if (b == null) {
                return;
            }
            this.buffer.append(b, 0, b.length);
        }

        public void write(int b) throws IOException {
            this.ensureNotClosed();
            this.buffer.append(b);
        }
    }
}

