/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.engine;

import javax.xml.namespace.QName;
import org.apache.axis2.AxisFault;
import org.apache.axis2.addressing.AddressingConstants;
import org.apache.axis2.addressing.EndpointReference;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.context.OperationContext;
import org.apache.axis2.context.ServiceContext;
import org.apache.axis2.context.ServiceGroupContext;
import org.apache.axis2.description.AxisOperation;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.description.HandlerDescription;
import org.apache.axis2.engine.AbstractDispatcher;
import org.apache.axis2.engine.AxisConfiguration;
import org.apache.axis2.engine.Handler;
import org.apache.axis2.i18n.Messages;
import org.apache.axis2.util.Utils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class AddressingBasedDispatcher
extends AbstractDispatcher
implements AddressingConstants {
    public static final String NAME = "AddressingBasedDispatcher";
    private static final Log log = LogFactory.getLog((Class)AddressingBasedDispatcher.class);

    public AxisOperation findOperation(AxisService service, MessageContext messageContext) throws AxisFault {
        log.debug((Object)Messages.getMessage("checkingoperation", messageContext.getWSAAction()));
        String action = messageContext.getWSAAction();
        if (action != null) {
            return service.getOperationByAction(action);
        }
        return null;
    }

    public AxisService findService(MessageContext messageContext) throws AxisFault {
        EndpointReference toEPR = messageContext.getTo();
        AxisService service = null;
        if (toEPR != null) {
            if (toEPR.hasAnonymousAddress()) {
                return null;
            }
            String address = toEPR.getAddress();
            log.debug((Object)Messages.getMessage("checkingserviceforepr", address));
            String[] values = Utils.parseRequestURLForServiceAndOperation(address, messageContext.getConfigurationContext().getServiceContextPath());
            if (values == null) {
                return null;
            }
            log.debug((Object)Messages.getMessage("checkingserviceforepr", values[0]));
            if (values[0] != null) {
                QName serviceName = new QName(values[0]);
                AxisConfiguration registry = messageContext.getConfigurationContext().getAxisConfiguration();
                return registry.getService(serviceName.getLocalPart());
            }
        }
        return service;
    }

    public void initDispatcher() {
        this.init(new HandlerDescription(NAME));
    }

    public Handler.InvocationResponse invoke(MessageContext msgctx) throws AxisFault {
        if (msgctx.getRelatesTo() != null) {
            OperationContext operationContext;
            String relatesTo = msgctx.getRelatesTo().getValue();
            log.debug((Object)Messages.getMessage("checkingrelatesto", relatesTo));
            if ((relatesTo != null || "".equals(relatesTo)) && (operationContext = msgctx.getConfigurationContext().getOperationContext(msgctx.getRelatesTo().getValue())) != null) {
                operationContext.addMessageContext(msgctx);
                msgctx.setAxisOperation(operationContext.getAxisOperation());
                msgctx.setOperationContext(operationContext);
                msgctx.setServiceContext((ServiceContext)operationContext.getParent());
                msgctx.setAxisService(((ServiceContext)operationContext.getParent()).getAxisService());
                msgctx.setServiceGroupContextId(((ServiceGroupContext)msgctx.getServiceContext().getParent()).getId());
            }
            return Handler.InvocationResponse.CONTINUE;
        }
        return super.invoke(msgctx);
    }
}

