/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.console.command.store.amq.reader;

import java.io.File;
import java.io.IOException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.jms.InvalidSelectorException;
import javax.jms.Message;
import org.apache.activemq.command.DataStructure;
import org.apache.activemq.console.command.store.amq.reader.AMQIterator;
import org.apache.activemq.console.command.store.amq.reader.MessageLocation;
import org.apache.activemq.filter.BooleanExpression;
import org.apache.activemq.kaha.impl.async.AsyncDataManager;
import org.apache.activemq.kaha.impl.async.Location;
import org.apache.activemq.openwire.OpenWireFormat;
import org.apache.activemq.selector.SelectorParser;
import org.apache.activemq.util.ByteSequence;
import org.apache.activemq.wireformat.WireFormat;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AMQReader
implements Iterable<Message> {
    private AsyncDataManager dataManager;
    private WireFormat wireFormat = new OpenWireFormat();
    private File file;
    private BooleanExpression expression;

    public static Set<File> listDataFiles(File directory) throws IOException {
        HashSet<File> result = new HashSet<File>();
        if (directory == null || !directory.exists() || !directory.isDirectory()) {
            throw new IOException("Invalid Directory " + directory);
        }
        AsyncDataManager dataManager = new AsyncDataManager();
        dataManager.setDirectory(directory);
        dataManager.start();
        Set set = dataManager.getFiles();
        if (set != null) {
            result.addAll(set);
        }
        dataManager.close();
        return result;
    }

    public AMQReader(File file) throws InvalidSelectorException, IOException {
        this(file, null);
    }

    public AMQReader(File file, String selector) throws IOException, InvalidSelectorException {
        String str;
        String string = str = selector != null ? selector.trim() : null;
        if (str != null && str.length() > 0) {
            this.expression = SelectorParser.parse((String)str);
        }
        this.dataManager = new AsyncDataManager();
        this.dataManager.setArchiveDataLogs(false);
        if (file.isDirectory()) {
            this.dataManager.setDirectory(file);
        } else {
            this.dataManager.setDirectory(file.getParentFile());
            this.dataManager.setDirectoryArchive(file);
            this.file = file;
        }
        this.dataManager.start();
    }

    @Override
    public Iterator<Message> iterator() {
        return new AMQIterator(this, this.expression);
    }

    protected MessageLocation getNextMessage(MessageLocation lastLocation) throws IllegalStateException, IOException {
        if (this.file != null) {
            return this.getInternalNextMessage(this.file, lastLocation);
        }
        return this.getInternalNextMessage(lastLocation);
    }

    private MessageLocation getInternalNextMessage(MessageLocation lastLocation) throws IllegalStateException, IOException {
        return this.getInternalNextMessage(null, lastLocation);
    }

    private MessageLocation getInternalNextMessage(File file, MessageLocation lastLocation) throws IllegalStateException, IOException {
        Location pos;
        MessageLocation result = lastLocation;
        if (result != null) {
            result.setMessage(null);
        }
        Message message = null;
        Location location = pos = lastLocation != null ? lastLocation.getLocation() : null;
        while ((pos = this.getNextLocation(file, pos)) != null) {
            message = this.getMessage(pos);
            if (message == null) continue;
            if (result == null) {
                result = new MessageLocation();
            }
            result.setMessage(message);
            break;
        }
        result.setLocation(pos);
        if (pos == null && message == null) {
            result = null;
        } else {
            result.setLocation(pos);
        }
        return result;
    }

    private Location getNextLocation(File file, Location last) throws IllegalStateException, IOException {
        if (file != null) {
            return this.dataManager.getNextLocation(file, last, true);
        }
        return this.dataManager.getNextLocation(last);
    }

    private Message getMessage(Location location) throws IOException {
        ByteSequence data = this.dataManager.read(location);
        DataStructure c = (DataStructure)this.wireFormat.unmarshal(data);
        if (c instanceof Message) {
            return (Message)c;
        }
        return null;
    }
}

