/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.transport;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.TimeUnit;
import org.apache.activemq.command.Response;
import org.apache.activemq.transport.RequestTimedOutIOException;
import org.apache.activemq.transport.ResponseCallback;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FutureResponse {
    private static final Logger LOG = LoggerFactory.getLogger(FutureResponse.class);
    private final ResponseCallback responseCallback;
    private final ArrayBlockingQueue<Response> responseSlot = new ArrayBlockingQueue(1);

    public FutureResponse(ResponseCallback responseCallback) {
        this.responseCallback = responseCallback;
    }

    public Response getResult() throws IOException {
        try {
            return this.responseSlot.take();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            if (LOG.isDebugEnabled()) {
                LOG.debug("Operation interupted: " + e, (Throwable)e);
            }
            throw new InterruptedIOException("Interrupted.");
        }
    }

    public Response getResult(int timeout) throws IOException {
        try {
            Response result = this.responseSlot.poll(timeout, TimeUnit.MILLISECONDS);
            if (result == null && timeout > 0) {
                throw new RequestTimedOutIOException();
            }
            return result;
        }
        catch (InterruptedException e) {
            throw new InterruptedIOException("Interrupted.");
        }
    }

    public void set(Response result) {
        if (this.responseSlot.offer(result) && this.responseCallback != null) {
            this.responseCallback.onCompletion(this);
        }
    }
}

