/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.xbean;

import java.beans.PropertyEditorManager;
import java.net.MalformedURLException;
import java.net.URI;
import org.apache.activemq.broker.BrokerFactoryHandler;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.spring.SpringBrokerContext;
import org.apache.activemq.spring.Utils;
import org.apache.activemq.util.IntrospectionSupport;
import org.apache.activemq.util.URISupport;
import org.apache.xbean.spring.context.ResourceXmlApplicationContext;
import org.apache.xbean.spring.context.impl.URIEditor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.FatalBeanException;
import org.springframework.beans.factory.xml.XmlBeanDefinitionReader;
import org.springframework.context.ApplicationContext;
import org.springframework.core.io.Resource;

public class XBeanBrokerFactory
implements BrokerFactoryHandler {
    private static final transient Logger LOG = LoggerFactory.getLogger(XBeanBrokerFactory.class);
    private boolean validate = true;

    public boolean isValidate() {
        return this.validate;
    }

    public void setValidate(boolean validate) {
        this.validate = validate;
    }

    @Override
    public BrokerService createBroker(URI config) throws Exception {
        String uri = config.getSchemeSpecificPart();
        if (uri.lastIndexOf(63) != -1) {
            IntrospectionSupport.setProperties(this, URISupport.parseQuery(uri));
            uri = uri.substring(0, uri.lastIndexOf(63));
        }
        ApplicationContext context = this.createApplicationContext(uri);
        BrokerService broker = null;
        try {
            broker = (BrokerService)context.getBean("broker");
        }
        catch (BeansException beansException) {
            // empty catch block
        }
        if (broker == null) {
            String name;
            String[] names = context.getBeanNamesForType(BrokerService.class);
            for (int i2 = 0; i2 < names.length && (broker = (BrokerService)context.getBean(name = names[i2])) == null; ++i2) {
            }
        }
        if (broker == null) {
            throw new IllegalArgumentException("The configuration has no BrokerService instance for resource: " + config);
        }
        SpringBrokerContext springBrokerContext = new SpringBrokerContext();
        springBrokerContext.setApplicationContext(context);
        springBrokerContext.setConfigurationUrl(uri);
        broker.setBrokerContext(springBrokerContext);
        return broker;
    }

    protected ApplicationContext createApplicationContext(String uri) throws MalformedURLException {
        Resource resource = Utils.resourceFromString(uri);
        LOG.debug("Using " + resource + " from " + uri);
        try {
            return new ResourceXmlApplicationContext(resource){

                @Override
                protected void initBeanDefinitionReader(XmlBeanDefinitionReader reader) {
                    reader.setValidating(XBeanBrokerFactory.this.isValidate());
                }
            };
        }
        catch (FatalBeanException errorToLog) {
            LOG.error("Failed to load: " + resource + ", reason: " + errorToLog.getLocalizedMessage(), errorToLog);
            throw errorToLog;
        }
    }

    static {
        PropertyEditorManager.registerEditor(URI.class, URIEditor.class);
    }
}

