/*
 * Decompiled with CFR 0.152.
 */
package org.andromda.metafacades.emf.uml22;

import java.util.Collection;
import java.util.TreeSet;
import org.andromda.metafacades.emf.uml22.ValueObjectLogic;
import org.andromda.metafacades.uml.GeneralizableElementFacade;
import org.andromda.metafacades.uml.StereotypeFacade;

public class ValueObjectLogicImpl
extends ValueObjectLogic {
    private static final long serialVersionUID = 34L;

    public ValueObjectLogicImpl(Object metaObject, String context) {
        super(metaObject, context);
    }

    @Override
    protected Collection<ValueObjectLogic> handleGetTypeSpecializations() {
        StringBuilder stereotypes = new StringBuilder();
        for (StereotypeFacade stereotype : this.getStereotypes()) {
            stereotypes.append(stereotype.getName()).append(',');
        }
        return this.handleGetTypeSpecializations(stereotypes.toString());
    }

    protected Collection<ValueObjectLogic> handleGetTypeSpecializations(String stereotypes) {
        TreeSet<ValueObjectLogic> specializations = new TreeSet<ValueObjectLogic>();
        String[] stereotypeList = stereotypes.split(",", -1);
        for (GeneralizableElementFacade classifier : this.getAllSpecializations()) {
            if (!(classifier instanceof ValueObjectLogic)) continue;
            for (int i = 0; i < stereotypeList.length; ++i) {
                if (!classifier.hasStereotype(stereotypeList[i]) || specializations.contains(classifier)) continue;
                specializations.add((ValueObjectLogic)classifier);
            }
        }
        return specializations;
    }
}

