/*
 * Decompiled with CFR 0.152.
 */
package org.andromda.metafacades.emf.uml22;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import org.andromda.metafacades.emf.uml22.ServiceOperationLogic;
import org.andromda.metafacades.uml.DependencyFacade;
import org.andromda.metafacades.uml.Destination;
import org.andromda.metafacades.uml.ModelElementFacade;
import org.andromda.metafacades.uml.Role;
import org.andromda.metafacades.uml.Service;
import org.apache.commons.collections.Closure;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.Predicate;
import org.apache.commons.collections.Transformer;

public class ServiceOperationLogicImpl
extends ServiceOperationLogic {
    private static final long serialVersionUID = -6674110092557611089L;

    public ServiceOperationLogicImpl(Object metaObject, String context) {
        super(metaObject, context);
    }

    @Override
    protected Collection<Role> handleGetRoles() {
        LinkedHashSet<DependencyFacade> roles = new LinkedHashSet<DependencyFacade>();
        if (this.getOwner() instanceof Service) {
            roles.addAll(((Service)this.getOwner()).getRoles());
        }
        ArrayList<DependencyFacade> operationRoles = new ArrayList<DependencyFacade>(this.getTargetDependencies());
        CollectionUtils.filter(operationRoles, (Predicate)new Predicate(){

            public boolean evaluate(Object object) {
                DependencyFacade dependency = (DependencyFacade)object;
                return dependency != null && dependency.getSourceElement() != null && Role.class.isAssignableFrom(dependency.getSourceElement().getClass());
            }
        });
        CollectionUtils.transform(operationRoles, (Transformer)new Transformer(){

            public Object transform(Object object) {
                return ((DependencyFacade)object).getSourceElement();
            }
        });
        roles.addAll(operationRoles);
        final LinkedHashSet<Role> allRoles = new LinkedHashSet<Role>(roles);
        CollectionUtils.forAllDo(roles, (Closure)new Closure(){

            public void execute(Object object) {
                if (object instanceof Role) {
                    allRoles.addAll(((Role)object).getAllSpecializations());
                }
            }
        });
        return allRoles;
    }

    protected Service handleGetService() {
        Service owner = null;
        if (this.getOwner() instanceof Service) {
            owner = (Service)this.getOwner();
        }
        return owner;
    }

    @Override
    public boolean handleIsMessageOperation() {
        return this.isIncomingMessageOperation() || this.isOutgoingMessageOperation();
    }

    @Override
    public boolean handleIsIncomingMessageOperation() {
        return this.getIncomingDestination() != null;
    }

    @Override
    public boolean handleIsOutgoingMessageOperation() {
        return this.getOutgoingDestination() != null;
    }

    public ModelElementFacade handleGetIncomingDestination() {
        Collection<DependencyFacade> dependencies = this.getTargetDependencies();
        DependencyFacade dependency = (DependencyFacade)CollectionUtils.find(dependencies, (Predicate)new Predicate(){

            public boolean evaluate(Object object) {
                return ((DependencyFacade)object).getSourceElement() instanceof Destination;
            }
        });
        return dependency == null ? null : dependency.getSourceElement();
    }

    public Destination handleGetOutgoingDestination() {
        Collection<DependencyFacade> dependencies = this.getSourceDependencies();
        DependencyFacade dependency = (DependencyFacade)CollectionUtils.find(dependencies, (Predicate)new Predicate(){

            public boolean evaluate(Object object) {
                return ((DependencyFacade)object).getTargetElement() instanceof Destination;
            }
        });
        return (Destination)(dependency == null ? null : dependency.getTargetElement());
    }
}

