/*
 * Decompiled with CFR 0.152.
 */
package org.andromda.metafacades.emf.uml22;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import org.andromda.core.metafacade.MetafacadeException;
import org.andromda.metafacades.emf.uml22.EntityLogic;
import org.andromda.metafacades.emf.uml22.UmlUtilities;
import org.andromda.metafacades.uml.AssociationEndFacade;
import org.andromda.metafacades.uml.AttributeFacade;
import org.andromda.metafacades.uml.ClassifierFacade;
import org.andromda.metafacades.uml.DependencyFacade;
import org.andromda.metafacades.uml.Entity;
import org.andromda.metafacades.uml.EntityAssociationEnd;
import org.andromda.metafacades.uml.EntityAttribute;
import org.andromda.metafacades.uml.EntityMetafacadeUtils;
import org.andromda.metafacades.uml.EntityQueryOperation;
import org.andromda.metafacades.uml.EnumerationFacade;
import org.andromda.metafacades.uml.FilteredCollection;
import org.andromda.metafacades.uml.MetafacadeUtils;
import org.andromda.metafacades.uml.ModelElementFacade;
import org.andromda.metafacades.uml.NameMasker;
import org.andromda.metafacades.uml.OperationFacade;
import org.andromda.metafacades.uml.UMLProfile;
import org.andromda.utils.StringUtilsHelper;
import org.apache.commons.collections.Closure;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.Predicate;
import org.apache.commons.collections.Transformer;
import org.apache.commons.lang.ObjectUtils;
import org.apache.commons.lang.StringUtils;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.Stereotype;
import org.eclipse.uml2.uml.Type;
import org.eclipse.uml2.uml.VisibilityKind;

public class EntityLogicImpl
extends EntityLogic {
    private static final long serialVersionUID = 9022811369852920861L;
    private static final Collection<String> DYNAMIC_IDENTIFIERS_PRESENT = Collections.synchronizedList(new ArrayList());

    public EntityLogicImpl(Object metaObject, String context) {
        super(metaObject, context);
    }

    public void initialize() {
        super.initialize();
        if (!this.isIdentifiersPresent() && this.isAllowDefaultIdentifiers()) {
            this.createIdentifier();
            DYNAMIC_IDENTIFIERS_PRESENT.add(this.getId());
        }
    }

    @Override
    protected String handleGetName() {
        String nameMask = String.valueOf(this.getConfiguredProperty("entityNameMask"));
        return NameMasker.mask((String)super.handleGetName(), (String)nameMask);
    }

    @Override
    protected Collection<OperationFacade> handleGetQueryOperations() {
        return this.getQueryOperations(false);
    }

    @Override
    protected Collection<OperationFacade> handleGetQueryOperations(boolean follow) {
        ArrayList<OperationFacade> operations = new ArrayList<OperationFacade>(this.getOperations());
        ArrayList<OperationFacade> queryOperations = new ArrayList<OperationFacade>();
        MetafacadeUtils.filterByType(operations, EntityQueryOperation.class);
        for (OperationFacade operation : operations) {
            queryOperations.add((OperationFacade)((EntityQueryOperation)operation));
        }
        for (ClassifierFacade superClass = (ClassifierFacade)this.getGeneralization(); superClass != null && follow; superClass = (ClassifierFacade)superClass.getGeneralization()) {
            if (!Entity.class.isAssignableFrom(superClass.getClass())) continue;
            Entity entity = (Entity)superClass;
            queryOperations.addAll(entity.getQueryOperations());
        }
        return queryOperations;
    }

    @Override
    protected Collection<EntityAttribute> handleGetIdentifiers() {
        return this.getIdentifiers(true);
    }

    @Override
    protected Collection<EntityAttribute> handleGetIdentifiers(boolean follow) {
        return EntityMetafacadeUtils.getIdentifiers((Entity)this, (boolean)follow);
    }

    private void createIdentifier() {
        if (!this.checkForAndAddForeignIdentifiers()) {
            this.createIdentifier(this.getDefaultIdentifier(), this.getDefaultIdentifierType(), this.getDefaultIdentifierVisibility());
        }
    }

    private void createIdentifier(String name, String type, String visibility) {
        Object modelElement;
        Class umlClass = (Class)this.metaObject;
        if (!umlClass.getGeneralizations().isEmpty()) {
            return;
        }
        if (umlClass.getAttribute(name, (Type)umlClass) == null && (modelElement = UmlUtilities.findByFullyQualifiedName(umlClass.eResource().getResourceSet(), type, "::", true)) instanceof Type) {
            Type element = (Type)modelElement;
            Property property = umlClass.createOwnedAttribute(name, element, 0, 1);
            VisibilityKind kind = VisibilityKind.PUBLIC_LITERAL;
            if ("package".equalsIgnoreCase(visibility)) {
                kind = VisibilityKind.PACKAGE_LITERAL;
            }
            if ("private".equalsIgnoreCase(visibility)) {
                kind = VisibilityKind.PRIVATE_LITERAL;
            }
            if ("protected".equalsIgnoreCase(visibility)) {
                kind = VisibilityKind.PROTECTED_LITERAL;
            }
            property.setVisibility(kind);
            Stereotype stereotype = UmlUtilities.findApplicableStereotype((Element)property, UMLProfile.STEREOTYPE_IDENTIFIER);
            if (stereotype == null) {
                throw new MetafacadeException("Could not apply '" + UMLProfile.STEREOTYPE_IDENTIFIER + "' to " + property + ", the stereotype could not be found");
            }
            property.applyStereotype(stereotype);
        }
    }

    @Override
    protected boolean handleIsIdentifiersPresent() {
        Collection identifiers = this.getIdentifiers(true);
        return identifiers != null && !identifiers.isEmpty();
    }

    @Override
    protected boolean handleIsDynamicIdentifiersPresent() {
        return DYNAMIC_IDENTIFIERS_PRESENT.contains(this.getId());
    }

    @Override
    protected String handleGetTableName() {
        String prefixProperty = "tableNamePrefix";
        String tableNamePrefix = this.isConfiguredProperty("tableNamePrefix") ? ObjectUtils.toString((Object)this.getConfiguredProperty("tableNamePrefix")) : null;
        return EntityMetafacadeUtils.getSqlNameFromTaggedValue((String)tableNamePrefix, (ModelElementFacade)this, (String)UMLProfile.TAGGEDVALUE_PERSISTENCE_TABLE, (Short)this.getMaxSqlNameLength(), (Object)this.getConfiguredProperty("sqlNameSeparator"));
    }

    @Override
    protected String handleGetOperationCallFromAttributes(boolean withIdentifiers) {
        return this.getOperationCallFromAttributes(withIdentifiers, false);
    }

    @Override
    protected String handleGetOperationCallFromAttributes(boolean withIdentifiers, boolean follow) {
        StringBuilder buffer = new StringBuilder("(");
        LinkedHashSet<AttributeFacade> attributes = new LinkedHashSet<AttributeFacade>(this.getAttributes());
        for (ClassifierFacade superClass = (ClassifierFacade)this.getGeneralization(); superClass != null && follow; superClass = (ClassifierFacade)superClass.getGeneralization()) {
            if (!(superClass instanceof Entity)) continue;
            Entity entity = (Entity)superClass;
            attributes.addAll(entity.getAttributes());
        }
        if (!attributes.isEmpty()) {
            String separator = "";
            for (AttributeFacade attribute : attributes) {
                EntityAttribute entityAttribute = (EntityAttribute)attribute;
                if (!withIdentifiers && entityAttribute.isIdentifier()) continue;
                buffer.append(separator);
                if (entityAttribute.getType() != null) {
                    buffer.append(entityAttribute.getType().getFullyQualifiedName());
                }
                buffer.append(' ');
                buffer.append(entityAttribute.getName());
                separator = ", ";
            }
        }
        buffer.append(')');
        return buffer.toString();
    }

    @Override
    protected String handleGetAttributeTypeList(boolean follow, boolean withIdentifiers) {
        return this.getTypeList(this.getAttributes(follow, withIdentifiers));
    }

    @Override
    protected String handleGetAttributeNameList(boolean follow, boolean withIdentifiers) {
        return this.getAttributeNameList(follow, withIdentifiers, true);
    }

    @Override
    protected String handleGetAttributeNameList(boolean follow, boolean withIdentifiers, boolean withDerived) {
        return this.getNameList(this.getAttributes(follow, withIdentifiers, withDerived));
    }

    @Override
    protected String handleGetRequiredAttributeTypeList(boolean follow, boolean withIdentifiers) {
        return this.getTypeList(this.getRequiredAttributes(follow, withIdentifiers));
    }

    @Override
    protected String handleGetRequiredAttributeNameList(boolean follow, boolean withIdentifiers) {
        return this.getNameList(this.getRequiredAttributes(follow, withIdentifiers));
    }

    @Override
    protected String handleGetRequiredPropertyTypeList(boolean follow, boolean withIdentifiers) {
        return this.getTypeList(this.getRequiredProperties(follow, withIdentifiers));
    }

    @Override
    protected String handleGetRequiredPropertyNameList(boolean follow, boolean withIdentifiers) {
        return this.getNameList(this.getRequiredProperties(follow, withIdentifiers));
    }

    private String getTypeList(Collection<? extends ModelElementFacade> properties) {
        final StringBuilder list = new StringBuilder();
        String comma = ", ";
        CollectionUtils.forAllDo(properties, (Closure)new Closure(){

            public void execute(Object object) {
                AssociationEndFacade associationEnd;
                AttributeFacade attribute;
                if (object instanceof AttributeFacade && (attribute = (AttributeFacade)object).getType() != null) {
                    list.append(attribute.getType().getFullyQualifiedName());
                    list.append(", ");
                }
                if (object instanceof AssociationEndFacade && (associationEnd = (AssociationEndFacade)object).getType() != null) {
                    list.append(associationEnd.getType().getFullyQualifiedName());
                    list.append(", ");
                }
            }
        });
        if (list.toString().endsWith(", ")) {
            list.delete(list.lastIndexOf(", "), list.length());
        }
        return list.toString();
    }

    private String getNameList(Collection properties) {
        final StringBuilder list = new StringBuilder();
        String comma = ", ";
        CollectionUtils.forAllDo((Collection)properties, (Closure)new Closure(){

            public void execute(Object object) {
                if (object instanceof EntityAttribute) {
                    list.append(((AttributeFacade)object).getName());
                    list.append(", ");
                }
                if (object instanceof EntityAssociationEnd) {
                    list.append(((AssociationEndFacade)object).getName());
                    list.append(", ");
                }
            }
        });
        if (list.toString().endsWith(", ")) {
            list.delete(list.lastIndexOf(", "), list.length());
        }
        return list.toString();
    }

    @Override
    protected boolean handleIsChild() {
        return CollectionUtils.find(this.getAssociationEnds(), (Predicate)new Predicate(){

            public boolean evaluate(Object object) {
                return ((AssociationEndFacade)object).getOtherEnd().isComposition();
            }
        }) != null;
    }

    protected AssociationEndFacade handleGetParentEnd() {
        AssociationEndFacade parentEnd = null;
        AssociationEndFacade end = (AssociationEndFacade)CollectionUtils.find(this.getAssociationEnds(), (Predicate)new Predicate(){

            public boolean evaluate(Object object) {
                return ((AssociationEndFacade)object).getOtherEnd().isComposition();
            }
        });
        if (end != null) {
            parentEnd = end.getOtherEnd();
        }
        return parentEnd;
    }

    @Override
    protected Collection<AssociationEndFacade> handleGetChildEnds() {
        FilteredCollection childEnds = new FilteredCollection(this.getAssociationEnds()){
            private static final long serialVersionUID = -7200489183737785955L;

            public boolean evaluate(Object object) {
                return ((AssociationEndFacade)object).isComposition();
            }
        };
        CollectionUtils.transform((Collection)childEnds, (Transformer)new Transformer(){

            public Object transform(Object object) {
                return ((AssociationEndFacade)object).getOtherEnd();
            }
        });
        return childEnds;
    }

    @Override
    protected Collection<OperationFacade> handleGetBusinessOperations() {
        ArrayList<OperationFacade> businessOperations = new ArrayList<OperationFacade>(this.getImplementationOperations());
        MetafacadeUtils.filterByNotType(businessOperations, EntityQueryOperation.class);
        return businessOperations;
    }

    @Override
    protected Collection<DependencyFacade> handleGetEntityReferences() {
        return new FilteredCollection(this.getSourceDependencies()){
            private static final long serialVersionUID = -302184888689870478L;

            public boolean evaluate(Object object) {
                ModelElementFacade targetElement = ((DependencyFacade)object).getTargetElement();
                return targetElement instanceof Entity;
            }
        };
    }

    @Override
    protected Collection<AttributeFacade> handleGetAttributes(boolean follow, final boolean withIdentifiers) {
        List attributes = this.getAttributes(follow);
        CollectionUtils.filter((Collection)attributes, (Predicate)new Predicate(){

            public boolean evaluate(Object object) {
                boolean valid = true;
                if (!withIdentifiers && object != null && object instanceof EntityAttribute) {
                    valid = !((EntityAttribute)object).isIdentifier();
                }
                return valid;
            }
        });
        return attributes;
    }

    @Override
    protected Collection<AttributeFacade> handleGetAttributes(boolean follow, final boolean withIdentifiers, final boolean withDerived) {
        List attributes = this.getAttributes(follow);
        CollectionUtils.filter((Collection)attributes, (Predicate)new Predicate(){

            public boolean evaluate(Object object) {
                boolean valid = true;
                if (!withIdentifiers && object != null && object instanceof EntityAttribute) {
                    boolean bl = valid = !((EntityAttribute)object).isIdentifier();
                }
                if (valid && !withDerived && object instanceof EntityAttribute) {
                    valid = !((EntityAttribute)object).isDerived();
                }
                return valid;
            }
        });
        return attributes;
    }

    @Override
    protected Collection<ModelElementFacade> handleGetProperties(boolean follow, boolean withIdentifiers) {
        List properties = this.getProperties(follow);
        if (!withIdentifiers) {
            CollectionUtils.filter((Collection)properties, (Predicate)new Predicate(){

                public boolean evaluate(Object object) {
                    return !(object instanceof EntityAttribute) || !((EntityAttribute)object).isIdentifier();
                }
            });
        }
        return properties;
    }

    @Override
    protected Collection<AttributeFacade> handleGetRequiredAttributes(boolean follow, boolean withIdentifiers) {
        Collection attributes = this.getAttributes(follow, withIdentifiers, false);
        if (!withIdentifiers) {
            CollectionUtils.filter((Collection)attributes, (Predicate)new Predicate(){

                public boolean evaluate(Object object) {
                    AttributeFacade attribute = (AttributeFacade)object;
                    return attribute.isRequired() && (!(object instanceof EntityAttribute) || !((EntityAttribute)object).isIdentifier());
                }
            });
        }
        return attributes;
    }

    @Override
    protected Collection<ModelElementFacade> handleGetRequiredProperties(boolean follow, final boolean withIdentifiers) {
        LinkedHashSet properties = new LinkedHashSet(this.getProperties(follow, withIdentifiers));
        CollectionUtils.filter(properties, (Predicate)new Predicate(){

            public boolean evaluate(Object object) {
                boolean valid = false;
                if (object instanceof AttributeFacade) {
                    AttributeFacade attribute = (AttributeFacade)object;
                    boolean bl = valid = attribute.isRequired() && !attribute.isDerived();
                    if (valid && !withIdentifiers && object instanceof EntityAttribute) {
                        valid = !((EntityAttribute)object).isIdentifier();
                    }
                } else if (object instanceof AssociationEndFacade) {
                    AssociationEndFacade assocationEnd = (AssociationEndFacade)object;
                    valid = assocationEnd.isRequired() && !assocationEnd.isDerived();
                }
                return valid;
            }
        });
        ArrayList<ModelElementFacade> sortedProperties = new ArrayList<ModelElementFacade>(properties);
        MetafacadeUtils.sortByFullyQualifiedName(sortedProperties);
        return sortedProperties;
    }

    @Override
    protected short handleGetMaxSqlNameLength() {
        return Short.valueOf((String)this.getConfiguredProperty("maxSqlNameLength"));
    }

    private boolean isAllowDefaultIdentifiers() {
        return Boolean.valueOf((String)this.getConfiguredProperty("allowDefaultIdentifiers"));
    }

    private String getDefaultIdentifier() {
        return ObjectUtils.toString((Object)this.getConfiguredProperty("defaultIdentifierPattern")).replaceAll("\\{0\\}", StringUtilsHelper.lowerCamelCaseName((String)this.handleGetName()));
    }

    private String getDefaultIdentifierType() {
        return (String)this.getConfiguredProperty("defaultIdentifierType");
    }

    private String getDefaultIdentifierVisibility() {
        return (String)this.getConfiguredProperty("defaultIdentifierVisibility");
    }

    private boolean checkForAndAddForeignIdentifiers() {
        boolean identifiersAdded = false;
        EntityAssociationEnd end = this.getForeignIdentifierEnd();
        if (end != null && end.getType() instanceof Entity) {
            Entity foreignEntity = (Entity)end.getOtherEnd().getType();
            Collection identifiers = EntityMetafacadeUtils.getIdentifiers((Entity)foreignEntity, (boolean)true);
            for (EntityAttribute identifier : identifiers) {
                this.createIdentifier(identifier.getName(), identifier.getType().getFullyQualifiedName(true), identifier.getVisibility());
                identifiersAdded = true;
            }
        }
        return identifiersAdded;
    }

    @Override
    public List<AssociationEndFacade> handleGetAssociationEnds() {
        List associationEnds = this.shieldedElements(super.handleGetAssociationEnds());
        CollectionUtils.filter((Collection)associationEnds, (Predicate)new Predicate(){

            public boolean evaluate(Object object) {
                ClassifierFacade type = ((AssociationEndFacade)object).getOtherEnd().getType();
                return type != null && (type instanceof Entity || type instanceof EnumerationFacade);
            }
        });
        return associationEnds;
    }

    @Override
    protected boolean handleIsUsingForeignIdentifier() {
        return this.getForeignIdentifierEnd() != null;
    }

    private EntityAssociationEnd getForeignIdentifierEnd() {
        return (EntityAssociationEnd)CollectionUtils.find(this.getAssociationEnds(), (Predicate)new Predicate(){

            public boolean evaluate(Object object) {
                boolean valid = false;
                if (object != null && EntityAssociationEnd.class.isAssignableFrom(object.getClass())) {
                    EntityAssociationEnd end = (EntityAssociationEnd)object;
                    valid = end.isForeignIdentifier();
                }
                return valid;
            }
        });
    }

    @Override
    protected boolean handleIsUsingAssignedIdentifier() {
        boolean assigned = false;
        Collection<EntityAttribute> identifiers = this.getIdentifiers();
        if (identifiers != null && !identifiers.isEmpty()) {
            EntityAttribute id = identifiers.iterator().next();
            AttributeFacade identifier = (AttributeFacade)id;
            assigned = Boolean.valueOf(ObjectUtils.toString((Object)identifier.findTaggedValue(UMLProfile.TAGGEDVALUE_PERSISTENCE_ASSIGNED_IDENTIFIER)));
        }
        return assigned;
    }

    @Override
    protected String handleGetSchema() {
        String schemaName = ObjectUtils.toString((Object)this.findTaggedValue(UMLProfile.TAGGEDVALUE_PERSISTENCE_SCHEMA));
        if (StringUtils.isBlank((String)schemaName)) {
            schemaName = ObjectUtils.toString((Object)this.getConfiguredProperty("schemaName"));
        }
        return schemaName;
    }

    @Override
    protected Collection<AssociationEndFacade> handleGetIdentifierAssociationEnds() {
        ArrayList<AssociationEndFacade> associationEnds = new ArrayList<AssociationEndFacade>(this.getAssociationEnds());
        MetafacadeUtils.filterByStereotype(associationEnds, (String)UMLProfile.STEREOTYPE_IDENTIFIER);
        return associationEnds;
    }

    @Override
    protected boolean handleIsCompositeIdentifier() {
        int identifiers = this.getIdentifiers().isEmpty() ? 0 : this.getIdentifiers().size();
        return (identifiers += this.getIdentifierAssociationEnds().isEmpty() ? 0 : this.getIdentifierAssociationEnds().size()) >= 2;
    }

    @Override
    protected Collection<DependencyFacade> handleGetAllEntityReferences() {
        final LinkedHashSet<DependencyFacade> result = new LinkedHashSet<DependencyFacade>();
        result.addAll(this.getEntityReferences());
        CollectionUtils.forAllDo(this.getAllGeneralizations(), (Closure)new Closure(){

            public void execute(Object object) {
                if (object instanceof Entity) {
                    Entity entity = (Entity)object;
                    result.addAll(entity.getEntityReferences());
                }
            }
        });
        return result;
    }

    @Override
    protected Collection<AttributeFacade> handleGetEmbeddedValues() {
        ArrayList<AttributeFacade> embeddedValues = new ArrayList<AttributeFacade>();
        for (AttributeFacade attribute : this.getAttributes(true)) {
            ClassifierFacade type = attribute.getType();
            if (type == null || !type.isEmbeddedValue()) continue;
            embeddedValues.add(attribute);
        }
        return embeddedValues;
    }

    @Override
    public String handleGetFullyQualifiedIdentifierTypeName() {
        if (this.isCompositeIdentifier()) {
            return this.getFullyQualifiedName() + (String)this.getConfiguredProperty("compositeIdentifierTypeNameSuffix");
        }
        return this.getIdentifiers().iterator().next().getType().getFullyQualifiedName();
    }

    @Override
    public String handleGetIdentifierName() {
        if (this.isCompositeIdentifier()) {
            return StringUtils.uncapitalize((String)this.getName()) + (String)this.getConfiguredProperty("compositeIdentifierNameSuffix");
        }
        return this.getIdentifiers().iterator().next().getName();
    }

    @Override
    public String handleGetIdentifierTypeName() {
        if (this.isCompositeIdentifier()) {
            return this.getName() + (String)this.getConfiguredProperty("compositeIdentifierTypeNameSuffix");
        }
        return this.getIdentifiers().iterator().next().getType().getName();
    }

    @Override
    public String handleGetIdentifierGetterName() {
        return "get" + StringUtils.capitalize((String)this.getIdentifierName());
    }

    @Override
    public String handleGetIdentifierSetterName() {
        return "set" + StringUtils.capitalize((String)this.getIdentifierName());
    }
}

