/*
 * Decompiled with CFR 0.152.
 */
package org.andromda.metafacades.emf.uml22;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.SequencedCollection;
import java.util.Set;
import org.andromda.metafacades.emf.uml22.ClassifierFacadeLogic;
import org.andromda.metafacades.emf.uml22.UmlUtilities;
import org.andromda.metafacades.uml.AssociationEndFacade;
import org.andromda.metafacades.uml.AttributeFacade;
import org.andromda.metafacades.uml.ClassifierFacade;
import org.andromda.metafacades.uml.DependencyFacade;
import org.andromda.metafacades.uml.FilteredCollection;
import org.andromda.metafacades.uml.GeneralizableElementFacade;
import org.andromda.metafacades.uml.MetafacadeUtils;
import org.andromda.metafacades.uml.ModelElementFacade;
import org.andromda.metafacades.uml.NameMasker;
import org.andromda.metafacades.uml.OperationFacade;
import org.andromda.metafacades.uml.PackageFacade;
import org.andromda.metafacades.uml.TypeMappings;
import org.andromda.metafacades.uml.UMLMetafacadeUtils;
import org.andromda.metafacades.uml.UMLProfile;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.Predicate;
import org.apache.commons.collections.Transformer;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.util.EList;
import org.eclipse.uml2.uml.Abstraction;
import org.eclipse.uml2.uml.AssociationClass;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.ClassifierTemplateParameter;
import org.eclipse.uml2.uml.DataType;
import org.eclipse.uml2.uml.Dependency;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Enumeration;
import org.eclipse.uml2.uml.Interface;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.Operation;
import org.eclipse.uml2.uml.Parameter;
import org.eclipse.uml2.uml.PrimitiveType;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.TemplateParameter;

public class ClassifierFacadeLogicImpl
extends ClassifierFacadeLogic {
    private static final long serialVersionUID = 34L;
    private static final Logger LOGGER = Logger.getLogger(ClassifierFacadeLogicImpl.class);

    public ClassifierFacadeLogicImpl(Classifier metaObject, String context) {
        super(metaObject, context);
    }

    @Override
    protected String handleGetName() {
        String nameMask = null;
        try {
            nameMask = String.valueOf(this.getConfiguredProperty("classifierNameMask"));
        }
        catch (Exception ignore) {
            LOGGER.warn((Object)("classifierNameMask not found in " + this.toString()));
            nameMask = "none";
        }
        return NameMasker.mask((String)super.handleGetName(), (String)nameMask);
    }

    @Override
    protected boolean handleIsPrimitive() {
        return this.getWrapperMappings() != null && this.getWrapperMappings().getMappings().containsFrom(this.handleGetFullyQualifiedName());
    }

    @Override
    protected boolean handleIsWrappedPrimitive() {
        return this.getWrapperMappings() != null && (this.getWrapperMappings().getMappings().containsTo(this.handleGetFullyQualifiedName()) || this.getWrapperMappings().getMappings().containsTo(this.handleGetName()));
    }

    @Override
    protected String handleGetOperationCallFromAttributes() {
        StringBuilder call = new StringBuilder("(");
        String separator = "";
        for (AttributeFacade attribute : this.getAttributes()) {
            call.append(separator);
            String typeName = attribute.getType().getFullyQualifiedName();
            call.append(typeName);
            call.append(' ');
            call.append(attribute.getName());
            separator = ", ";
        }
        call.append(')');
        return call.toString();
    }

    @Override
    protected boolean handleIsAbstract() {
        return this.metaObject.isAbstract();
    }

    @Override
    protected List<ModelElementFacade> handleGetProperties() {
        return this.handleGetProperties(false);
    }

    @Override
    public Collection<ModelElementFacade> handleGetAllProperties() {
        return this.handleGetProperties(true);
    }

    @Override
    public Collection<ModelElementFacade> handleGetAllRequiredConstructorParameters() {
        ArrayList<ModelElementFacade> allRequiredConstructorParameters = new ArrayList<ModelElementFacade>();
        Collection<GeneralizableElementFacade> generalizations = this.getGeneralizations();
        for (GeneralizableElementFacade parent : generalizations) {
            if (!(parent instanceof ClassifierFacade)) continue;
            allRequiredConstructorParameters.addAll(((ClassifierFacade)parent).getAllRequiredConstructorParameters());
        }
        allRequiredConstructorParameters.addAll(this.getRequiredConstructorParameters());
        return allRequiredConstructorParameters;
    }

    @Override
    public Collection<ModelElementFacade> handleGetRequiredConstructorParameters() {
        ArrayList<ModelElementFacade> requiredConstructorParameters = new ArrayList<ModelElementFacade>();
        List properties = this.getProperties();
        for (ModelElementFacade property : properties) {
            AssociationEndFacade associationEnd;
            if (property instanceof AttributeFacade) {
                AttributeFacade attribute = (AttributeFacade)property;
                if (attribute.isDerived() || !attribute.isRequired() && !attribute.isReadOnly()) continue;
                requiredConstructorParameters.add((ModelElementFacade)attribute);
                continue;
            }
            if (!(property instanceof AssociationEndFacade) || (associationEnd = (AssociationEndFacade)property).isDerived() || !associationEnd.isRequired() && !associationEnd.isReadOnly()) continue;
            requiredConstructorParameters.add((ModelElementFacade)associationEnd);
        }
        return requiredConstructorParameters;
    }

    @Override
    protected boolean handleIsDataType() {
        return this.metaObject instanceof DataType;
    }

    @Override
    protected boolean handleIsArrayType() {
        String suffix;
        String name = this.handleGetFullyQualifiedName(true);
        return name.endsWith(suffix = this.getArraySuffix()) || this.handleGetFullyQualifiedName(true).endsWith(suffix);
    }

    @Override
    protected boolean handleIsCollectionType() {
        return UMLMetafacadeUtils.isType((ClassifierFacade)this, (String)UMLProfile.COLLECTION_TYPE_NAME);
    }

    @Override
    protected String handleGetWrapperName() {
        String wrapperName = null;
        if (this.getWrapperMappings() != null && this.getWrapperMappings().getMappings().containsFrom(this.handleGetFullyQualifiedName())) {
            wrapperName = this.getWrapperMappings().getTo(this.handleGetFullyQualifiedName());
        }
        return wrapperName;
    }

    protected TypeMappings getWrapperMappings() {
        String propertyName = "wrapperMappingsUri";
        Object property = this.getConfiguredProperty("wrapperMappingsUri");
        TypeMappings mappings = null;
        if (property instanceof String) {
            String uri = (String)property;
            try {
                mappings = TypeMappings.getInstance((String)uri);
                this.setProperty("wrapperMappingsUri", mappings);
            }
            catch (Exception ex) {
                String errMsg = "Error getting 'wrapperMappingsUri' --> '" + uri + '\'';
                LOGGER.error((Object)errMsg, (Throwable)ex);
            }
        } else {
            mappings = (TypeMappings)property;
        }
        return mappings;
    }

    @Override
    protected boolean handleIsDateType() {
        return UMLMetafacadeUtils.isType((ClassifierFacade)this, (String)UMLProfile.DATE_TYPE_NAME);
    }

    @Override
    protected boolean handleIsInterface() {
        return this.metaObject instanceof Interface;
    }

    @Override
    protected String handleGetJavaNewString() {
        String javaNewString = this.isPrimitive() ? (UMLMetafacadeUtils.isType((ClassifierFacade)this, (String)UMLProfile.BOOLEAN_TYPE_NAME) ? "false" : "0") : (this.isWrappedPrimitive() ? (UMLMetafacadeUtils.isType((ClassifierFacade)this, (String)UMLProfile.BOOLEAN_TYPE_NAME) ? "Boolean.FALSE" : this.handleGetFullyQualifiedName() + ".valueOf(0)") : "new " + this.handleGetFullyQualifiedName() + "()");
        return javaNewString;
    }

    @Override
    protected String handleGetJavaNullString() {
        String javaNullString = this.isPrimitive() ? (UMLMetafacadeUtils.isType((ClassifierFacade)this, (String)UMLProfile.BOOLEAN_TYPE_NAME) ? "false" : "0") : "null";
        return javaNullString;
    }

    @Override
    protected boolean handleIsListType() {
        return UMLMetafacadeUtils.isType((ClassifierFacade)this, (String)UMLProfile.LIST_TYPE_NAME);
    }

    @Override
    protected boolean handleIsSetType() {
        return UMLMetafacadeUtils.isType((ClassifierFacade)this, (String)UMLProfile.SET_TYPE_NAME);
    }

    @Override
    protected boolean handleIsFileType() {
        return UMLMetafacadeUtils.isType((ClassifierFacade)this, (String)UMLProfile.FILE_TYPE_NAME);
    }

    @Override
    public boolean handleIsMapType() {
        return UMLMetafacadeUtils.isType((ClassifierFacade)this, (String)UMLProfile.MAP_TYPE_NAME);
    }

    @Override
    protected boolean handleIsStringType() {
        return "String".equals(this.handleGetFullyQualifiedName()) || "java.lang.String".equals(this.handleGetFullyQualifiedName()) || UMLMetafacadeUtils.isType((ClassifierFacade)this, (String)UMLProfile.STRING_TYPE_NAME);
    }

    @Override
    protected boolean handleIsEnumeration() {
        return this.hasStereotype(UMLProfile.STEREOTYPE_ENUMERATION) || this.metaObject instanceof Enumeration;
    }

    @Override
    protected String handleGetArrayName() {
        return this.handleGetName() + this.getArraySuffix();
    }

    @Override
    protected String handleGetFullyQualifiedArrayName() {
        return this.handleGetFullyQualifiedName() + this.getArraySuffix();
    }

    @Override
    protected long handleGetSerialVersionUID() {
        String serialVersionString;
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"Starting get serial UID");
        }
        long serialVersionUID = (serialVersionString = UmlUtilities.getSerialVersionUID(this)) == null ? MetafacadeUtils.calculateDefaultSUID((ClassifierFacade)this) : Long.parseLong(serialVersionString);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("SerialVersionUID for " + this.metaObject.getQualifiedName() + " is " + serialVersionUID));
        }
        return serialVersionUID;
    }

    @Override
    protected boolean handleIsBlobType() {
        return UMLMetafacadeUtils.isType((ClassifierFacade)this, (String)UMLProfile.BLOB_TYPE_NAME);
    }

    @Override
    protected boolean handleIsClobType() {
        return UMLMetafacadeUtils.isType((ClassifierFacade)this, (String)UMLProfile.CLOB_TYPE_NAME);
    }

    @Override
    protected boolean handleIsBooleanType() {
        return UMLMetafacadeUtils.isType((ClassifierFacade)this, (String)UMLProfile.BOOLEAN_TYPE_NAME);
    }

    @Override
    protected boolean handleIsCharacterType() {
        String characterType = UMLProfile.CHARACTER_TYPE_NAME;
        String charType = characterType.substring(characterType.indexOf(58) + 1).substring(0, 4).toLowerCase();
        return UMLMetafacadeUtils.isType((ClassifierFacade)this, (String)charType) || UMLMetafacadeUtils.isType((ClassifierFacade)this, (String)characterType);
    }

    @Override
    protected boolean handleIsTimeType() {
        return UMLMetafacadeUtils.isType((ClassifierFacade)this, (String)UMLProfile.TIME_TYPE_NAME);
    }

    @Override
    protected boolean handleIsDoubleType() {
        return UMLMetafacadeUtils.isType((ClassifierFacade)this, (String)UMLProfile.DOUBLE_TYPE_NAME);
    }

    @Override
    protected boolean handleIsFloatType() {
        return UMLMetafacadeUtils.isType((ClassifierFacade)this, (String)UMLProfile.FLOAT_TYPE_NAME);
    }

    @Override
    protected boolean handleIsIntegerType() {
        String integerType = UMLProfile.INTEGER_TYPE_NAME;
        String intType = integerType.substring(integerType.indexOf(58) + 1).substring(0, 3).toLowerCase();
        return UMLMetafacadeUtils.isType((ClassifierFacade)this, (String)intType) || UMLMetafacadeUtils.isType((ClassifierFacade)this, (String)integerType);
    }

    @Override
    protected boolean handleIsLongType() {
        return UMLMetafacadeUtils.isType((ClassifierFacade)this, (String)UMLProfile.LONG_TYPE_NAME);
    }

    @Override
    protected List<AttributeFacade> handleGetAttributes(boolean follow) {
        return this.shieldedElements(UmlUtilities.getAttributes(this.metaObject, follow));
    }

    @Override
    protected AttributeFacade handleFindAttribute(final String name) {
        return (AttributeFacade)CollectionUtils.find((Collection)this.getAttributes(true), (Predicate)new Predicate(){

            public boolean evaluate(Object object) {
                AttributeFacade attribute = (AttributeFacade)object;
                return StringUtils.trimToEmpty((String)attribute.getName()).equals(name);
            }
        });
    }

    @Override
    protected List<ModelElementFacade> handleGetProperties(boolean follow) {
        ArrayList<ModelElementFacade> properties = new ArrayList<ModelElementFacade>();
        if (follow && !this.getGeneralizations().isEmpty()) {
            for (GeneralizableElementFacade generalization : this.getGeneralizations()) {
                if (!(generalization instanceof ClassifierFacade)) continue;
                properties.addAll(((ClassifierFacade)generalization).getAllProperties());
            }
        }
        properties.addAll(this.getAttributes(false));
        properties.addAll(this.getNavigableConnectingEnds(false));
        return properties;
    }

    @Override
    protected List<Operation> handleGetOperations() {
        Object operations = this.metaObject instanceof Class ? ((Class)this.metaObject).getOwnedOperations() : (this.metaObject instanceof Interface ? ((Interface)this.metaObject).getOwnedOperations() : Collections.emptyList());
        return operations;
    }

    @Override
    protected Collection<Operation> handleGetImplementationOperations() {
        SequencedCollection<Object> operations;
        if (this.metaObject instanceof Class) {
            operations = new LinkedHashSet(((Class)this.metaObject).getOwnedOperations());
            FilteredCollection dependencies = new FilteredCollection((Collection)this.metaObject.getClientDependencies()){
                private static final long serialVersionUID = 1L;

                public boolean evaluate(Object object) {
                    return object instanceof Abstraction;
                }
            };
            for (Dependency dependency : dependencies) {
                EList suppliers = ((Abstraction)dependency).getSuppliers();
                for (NamedElement supplier : suppliers) {
                    if (!(supplier instanceof Interface)) continue;
                    operations.addAll(ClassifierFacadeLogicImpl.resolveInterfaceOperationsRecursively((Interface)supplier));
                }
            }
        } else {
            operations = this.metaObject instanceof Interface ? new LinkedHashSet(((Interface)this.metaObject).getOwnedOperations()) : Collections.emptyList();
        }
        return operations;
    }

    private static Collection<Operation> resolveInterfaceOperationsRecursively(Interface classifier) {
        LinkedHashSet<Operation> operations = new LinkedHashSet<Operation>((Collection<Operation>)classifier.getOwnedOperations());
        EList generals = classifier.getGenerals();
        for (Classifier generalObject : generals) {
            if (!(generalObject instanceof Interface)) continue;
            operations.addAll(ClassifierFacadeLogicImpl.resolveInterfaceOperationsRecursively((Interface)generalObject));
        }
        return operations;
    }

    @Override
    protected List<Property> handleGetAttributes() {
        return UmlUtilities.getAttributes(this.metaObject, false);
    }

    @Override
    protected List<AssociationEndFacade> handleGetAssociationEnds() {
        return this.shieldedElements(UmlUtilities.getAssociationEnds(this.metaObject, false));
    }

    protected Element getOwner() {
        return this.metaObject.getOwner();
    }

    protected ClassifierFacade handleGetNonArray() {
        ClassifierFacade nonArrayType = (ClassifierFacade)this.THIS();
        String arraySuffix = this.getArraySuffix();
        if (this.handleGetFullyQualifiedName().contains(arraySuffix)) {
            PackageFacade packageFacade = this.getRootPackage();
            String fullQualifiedName = this.handleGetFullyQualifiedName(true);
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)("Looking for non-array type of element " + fullQualifiedName + " with array suffix " + arraySuffix + ", root: " + packageFacade));
                LOGGER.debug((Object)("Metaobject: " + this.metaObject + " its model is : " + this.metaObject.getModel()));
            }
            nonArrayType = (ClassifierFacade)packageFacade.findModelElement(StringUtils.replace((String)fullQualifiedName, (String)arraySuffix, (String)""));
        }
        return nonArrayType;
    }

    protected ClassifierFacade handleGetArray() {
        ClassifierFacade arrayType = (ClassifierFacade)this.THIS();
        if (this.metaObject instanceof PrimitiveType) {
            String name = this.handleGetFullyQualifiedName(true);
            if (!name.contains(this.getArraySuffix())) {
                name = name + this.getArraySuffix();
                PackageFacade pkg = this.getRootPackage();
                if (pkg != null) {
                    arrayType = (ClassifierFacade)this.shieldedElement(this.getRootPackage().findModelElement(name));
                }
            }
        } else {
            arrayType = null;
        }
        return arrayType;
    }

    @Override
    protected Collection<AttributeFacade> handleGetStaticAttributes() {
        List<AttributeFacade> attributes = this.getAttributes();
        CollectionUtils.filter(attributes, (Predicate)new Predicate(){

            public boolean evaluate(Object object) {
                return object != null && ((AttributeFacade)object).isStatic();
            }
        });
        return attributes;
    }

    @Override
    protected Collection<AttributeFacade> handleGetInstanceAttributes() {
        List<AttributeFacade> attributes = this.getAttributes();
        CollectionUtils.filter(attributes, (Predicate)new Predicate(){

            public boolean evaluate(Object object) {
                return object != null && !((AttributeFacade)object).isStatic();
            }
        });
        return attributes;
    }

    @Override
    protected List<OperationFacade> handleGetStaticOperations() {
        ArrayList<OperationFacade> operations = new ArrayList<OperationFacade>();
        for (OperationFacade operation : this.getOperations()) {
            if (!operation.isStatic()) continue;
            operations.add(operation);
        }
        return operations;
    }

    @Override
    protected List<OperationFacade> handleGetInstanceOperations() {
        return this.getStaticOperations();
    }

    @Override
    protected Collection<Abstraction> handleGetAbstractions() {
        ArrayList<Abstraction> abstractions = new ArrayList<Abstraction>();
        for (Dependency dependency : this.metaObject.getClientDependencies()) {
            if (!(dependency instanceof Abstraction)) continue;
            abstractions.add((Abstraction)dependency);
        }
        return abstractions;
    }

    @Override
    protected Collection<AssociationEndFacade> handleGetNavigableConnectingEnds() {
        ArrayList<AssociationEndFacade> connectingEnds = new ArrayList<AssociationEndFacade>(this.getAssociationEnds());
        CollectionUtils.transform(connectingEnds, (Transformer)new Transformer(){

            public Object transform(Object object) {
                if (object == null) {
                    return null;
                }
                return ((AssociationEndFacade)object).getOtherEnd();
            }
        });
        CollectionUtils.filter(connectingEnds, (Predicate)new Predicate(){

            public boolean evaluate(Object object) {
                return object != null && ((AssociationEndFacade)object).isNavigable();
            }
        });
        return connectingEnds;
    }

    @Override
    protected List<AssociationEndFacade> handleGetNavigableConnectingEnds(boolean follow) {
        List connectingEnds = this.shieldedElements(UmlUtilities.getAssociationEnds(this.metaObject, follow));
        CollectionUtils.transform((Collection)connectingEnds, (Transformer)new Transformer(){

            public Object transform(Object object) {
                if (object == null) {
                    return null;
                }
                return ((AssociationEndFacade)object).getOtherEnd();
            }
        });
        CollectionUtils.filter((Collection)connectingEnds, (Predicate)new Predicate(){

            public boolean evaluate(Object object) {
                return object != null && ((AssociationEndFacade)object).isNavigable();
            }
        });
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("handleGetNavigableConnectingEnds " + this.metaObject.getQualifiedName() + ' ' + connectingEnds.size()));
        }
        return connectingEnds;
    }

    @Override
    protected boolean handleIsLeaf() {
        return this.metaObject.isLeaf();
    }

    @Override
    protected Collection<ClassifierFacade> handleGetInterfaceAbstractions() {
        LinkedHashSet<ClassifierFacade> interfaceAbstractions = new LinkedHashSet<ClassifierFacade>();
        if (this.getAbstractions() != null) {
            for (ClassifierFacade obj : this.getAbstractions()) {
                try {
                    ClassifierFacade classifier;
                    DependencyFacade abstraction = (DependencyFacade)obj;
                    ModelElementFacade element = abstraction.getTargetElement();
                    if (!(element instanceof ClassifierFacade) || !(classifier = (ClassifierFacade)element).isInterface()) continue;
                    interfaceAbstractions.add(classifier);
                }
                catch (Exception e) {
                    LOGGER.warn((Object)("ClassifierFacade.handleGetInterfaceAbstractions " + obj + ' ' + e.getMessage()));
                }
            }
        }
        return interfaceAbstractions;
    }

    @Override
    protected String handleGetImplementedInterfaceList() {
        String interfaceList;
        Collection<ClassifierFacade> interfaces = this.getInterfaceAbstractions();
        if (interfaces.isEmpty()) {
            interfaceList = "";
        } else {
            StringBuilder list = new StringBuilder();
            Iterator<ClassifierFacade> iterator = interfaces.iterator();
            while (iterator.hasNext()) {
                ClassifierFacade element = iterator.next();
                list.append(element.getBindedFullyQualifiedName((ModelElementFacade)this));
                if (!iterator.hasNext()) continue;
                list.append(", ");
            }
            interfaceList = list.toString();
        }
        return interfaceList;
    }

    @Override
    protected boolean handleIsTemplateParametersPresent() {
        if (this.metaObject.getOwnedTemplateSignature() == null || this.metaObject.getOwnedTemplateSignature().getOwnedParameters() == null) {
            return false;
        }
        return !this.metaObject.getOwnedTemplateSignature().getOwnedParameters().isEmpty();
    }

    @Override
    protected void handleCopyTaggedValues(ModelElementFacade element) {
    }

    protected DataType handleGetTemplateParameter(String parameterName) {
        if (this.metaObject.getOwnedTemplateSignature() == null || this.metaObject.getOwnedTemplateSignature().getOwnedParameters() == null) {
            return null;
        }
        for (TemplateParameter param : this.metaObject.getOwnedTemplateSignature().getOwnedParameters()) {
            DataType element = (DataType)((ClassifierTemplateParameter)param).getOwnedParameteredElement();
            if (!element.getName().equals(parameterName)) continue;
            return element;
        }
        return null;
    }

    @Override
    protected Collection<TemplateParameter> handleGetTemplateParameters() {
        if (this.metaObject.getOwnedTemplateSignature() == null || this.metaObject.getOwnedTemplateSignature().getOwnedParameters() == null) {
            return new ArrayList<TemplateParameter>();
        }
        return this.metaObject.getOwnedTemplateSignature().getOwnedParameters();
    }

    @Override
    protected boolean handleIsAssociationClass() {
        return AssociationClass.class.isAssignableFrom(this.metaObject.getClass());
    }

    @Override
    protected Collection<ClassifierFacade> handleGetAssociatedClasses() {
        LinkedHashSet<ClassifierFacade> associatedClasses = new LinkedHashSet<ClassifierFacade>();
        List<AssociationEndFacade> associationEnds = this.getAssociationEnds();
        for (AssociationEndFacade associationEndFacade : associationEnds) {
            associatedClasses.add(associationEndFacade.getOtherEnd().getType());
        }
        return associatedClasses;
    }

    @Override
    protected Set<ClassifierFacade> handleGetAllAssociatedClasses() {
        LinkedHashSet<ClassifierFacade> associatedClasses = new LinkedHashSet<ClassifierFacade>();
        associatedClasses.addAll(this.getAssociatedClasses());
        for (GeneralizableElementFacade gen : this.getGeneralizations()) {
            ClassifierFacade parent = (ClassifierFacade)gen;
            associatedClasses.addAll(parent.getAllAssociatedClasses());
        }
        return associatedClasses;
    }

    protected ClassifierFacade handleGetSuperClass() {
        GeneralizableElementFacade superClass = this.getGeneralization();
        return (ClassifierFacade)(superClass instanceof ClassifierFacade ? superClass : null);
    }

    @Override
    protected boolean handleIsEmbeddedValue() {
        return this.hasStereotype(UMLProfile.STEREOTYPE_EMBEDDED_VALUE);
    }

    private static class OperationComparator
    implements Comparator<Operation> {
        private static final long serialVersionUID = 1L;

        private OperationComparator() {
        }

        @Override
        public int compare(Operation operation1, Operation operation2) {
            int rtn = operation1.getName().compareTo(operation2.getName());
            if (rtn == 0 && (rtn = operation1.getOwnedParameters().size() - operation1.getOwnedParameters().size()) == 0) {
                Parameter parameter;
                int index = 0;
                Iterator i$ = operation1.getOwnedParameters().iterator();
                while (i$.hasNext() && (rtn = (parameter = (Parameter)i$.next()).getName().compareTo(((Parameter)operation2.getOwnedParameters().get(index)).getName())) == 0) {
                    ++index;
                }
            }
            return rtn;
        }
    }
}

