/*
 * Decompiled with CFR 0.152.
 */
package org.andromda.maven.plugin.configuration;

import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.andromda.core.common.ResourceUtils;
import org.andromda.core.configuration.Configuration;
import org.andromda.maven.plugin.configuration.BeanProperties;
import org.andromda.maven.plugin.configuration.ConfigurationClassLoader;
import org.apache.commons.lang.ObjectUtils;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.Plugin;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.project.MavenProject;
import org.apache.maven.settings.Settings;
import org.apache.maven.shared.filtering.PropertyUtils;
import org.codehaus.plexus.util.InterpolationFilterReader;

public abstract class AbstractConfigurationMojo
extends AbstractMojo {
    private static final String MAPPINGS_PATH = "META-INF/andromda/mappings";
    private static final String BEGIN_TOKEN = "${";
    private static final String END_TOKEN = "}";
    protected boolean skip;
    protected boolean skipTests;
    protected boolean testFailureIgnore;

    protected Configuration getConfiguration(URL configurationUri) throws IOException {
        String contents = this.replaceProperties(ResourceUtils.getContents((URL)configurationUri));
        Configuration configuration = Configuration.getInstance((String)contents);
        URL mappingsUrl = ResourceUtils.getResource((String)MAPPINGS_PATH);
        if (mappingsUrl != null) {
            configuration.addMappingsSearchLocation(mappingsUrl.toString());
        }
        return configuration;
    }

    protected Properties getProperties() throws IOException {
        Properties properties = new Properties();
        properties.put("settings", this.getSettings());
        properties.putAll((Map<?, ?>)this.getProject().getProperties());
        for (String propertiesFile : this.getPropertyFiles()) {
            Properties projectProperties = PropertyUtils.loadPropertyFile((File)new File(propertiesFile), (boolean)true, (boolean)true);
            properties.putAll((Map<?, ?>)projectProperties);
        }
        for (Object objProperty : properties.keySet()) {
            String property = (String)objProperty;
            String value = this.replaceProperties(properties, ObjectUtils.toString((Object)properties.get(property)));
            properties.put(property, value);
        }
        properties.putAll((Map<?, ?>)System.getProperties());
        return properties;
    }

    protected String replaceProperties(String string) throws IOException {
        return this.replaceProperties(this.getProperties(), string);
    }

    private String replaceProperties(Properties properties, String string) throws IOException {
        StringReader stringReader = new StringReader(string);
        InterpolationFilterReader reader = new InterpolationFilterReader((Reader)stringReader, (Map)properties, BEGIN_TOKEN, END_TOKEN);
        reader.reset();
        reader = new InterpolationFilterReader((Reader)reader, (Map)new BeanProperties(this.getProject()), BEGIN_TOKEN, END_TOKEN);
        reader = new InterpolationFilterReader((Reader)reader, (Map)new BeanProperties(this.getSettings()), BEGIN_TOKEN, END_TOKEN);
        return ResourceUtils.getContents((Reader)reader);
    }

    protected void initializeClasspathFromClassPathElements(List<String> classpathFiles) throws MalformedURLException {
        if (classpathFiles != null && !classpathFiles.isEmpty()) {
            URL[] classpathUrls = new URL[classpathFiles.size()];
            for (int ctr = 0; ctr < classpathFiles.size(); ++ctr) {
                File file = new File(classpathFiles.get(ctr));
                if (this.getLog().isDebugEnabled()) {
                    this.getLog().debug((CharSequence)("adding to classpath '" + file + '\''));
                }
                classpathUrls[ctr] = file.toURI().toURL();
            }
            ConfigurationClassLoader loader = new ConfigurationClassLoader(classpathUrls, Thread.currentThread().getContextClassLoader());
            Thread.currentThread().setContextClassLoader(loader);
        }
    }

    protected void addPluginDependencies(String pluginArtifactId, String scope) {
        List<Plugin> plugins;
        if (pluginArtifactId != null && (plugins = this.getPlugins()) != null) {
            for (Plugin plugin : plugins) {
                List dependencies;
                if (!pluginArtifactId.equals(plugin.getArtifactId()) || (dependencies = plugin.getDependencies()) == null) continue;
                for (Dependency dependency : plugin.getDependencies()) {
                    this.addDependency(dependency, scope);
                }
            }
        }
    }

    private void addDependency(Dependency dependency, String scope) {
        ArtifactRepository localRepository = this.getLocalRepository();
        MavenProject project = this.getProject();
        if (project != null && localRepository != null && dependency != null) {
            Artifact artifact = this.getFactory().createArtifact(dependency.getGroupId(), dependency.getArtifactId(), dependency.getVersion(), scope, dependency.getType());
            File file = new File(localRepository.getBasedir(), localRepository.pathOf(artifact));
            artifact.setFile(file);
            project.getDependencies().add(dependency);
            project.getArtifacts().add(artifact);
        }
    }

    protected abstract MavenProject getProject();

    protected abstract List<String> getPropertyFiles();

    protected abstract Settings getSettings();

    protected abstract ArtifactFactory getFactory();

    protected abstract List<Plugin> getPlugins();

    protected abstract ArtifactRepository getLocalRepository();
}

