/*
 * Decompiled with CFR 0.152.
 */
package org.andromda.cartridges.spring.metafacades;

import org.andromda.cartridges.spring.metafacades.SpringManageableEntityLogic;
import org.andromda.cartridges.spring.metafacades.SpringMetafacadeUtils;
import org.andromda.metafacades.uml.ClassifierFacade;
import org.apache.commons.lang.ObjectUtils;
import org.apache.commons.lang.StringUtils;

public class SpringManageableEntityLogicImpl
extends SpringManageableEntityLogic {
    private static final long serialVersionUID = 34L;

    public SpringManageableEntityLogicImpl(Object metaObject, String context) {
        super(metaObject, context);
    }

    private String getNamespaceProperty() {
        return (String)this.getConfiguredProperty("namespaceSeparator");
    }

    @Override
    protected String handleGetDaoReferenceName() {
        return StringUtils.uncapitalize((String)this.getName()) + "Dao";
    }

    @Override
    protected String handleGetManageableDaoName() {
        return this.getName() + "ManageableDao";
    }

    @Override
    protected String handleGetFullyQualifiedManageableDaoName() {
        return this.getManageablePackageName() + this.getNamespaceProperty() + this.getManageableDaoName();
    }

    @Override
    protected String handleGetManageableDaoFullPath() {
        return StringUtils.replace((String)this.getFullyQualifiedManageableDaoName(), (String)this.getNamespaceProperty(), (String)"/");
    }

    @Override
    protected String handleGetManageableDaoBaseName() {
        return this.getManageableDaoName() + "Base";
    }

    @Override
    protected String handleGetFullyQualifiedManageableDaoBaseName() {
        return this.getManageablePackageName() + this.getNamespaceProperty() + this.getManageableDaoBaseName();
    }

    @Override
    protected String handleGetManageableDaoBaseFullPath() {
        return StringUtils.replace((String)this.getFullyQualifiedManageableDaoBaseName(), (String)this.getNamespaceProperty(), (String)"/");
    }

    @Override
    protected String handleGetManageableServiceBaseName() {
        return this.getManageableServiceName() + "Base";
    }

    @Override
    protected String handleGetFullyQualifiedManageableServiceBaseName() {
        return this.getManageablePackageName() + this.getNamespaceProperty() + this.getManageableServiceBaseName();
    }

    @Override
    protected String handleGetManageableServiceBaseFullPath() {
        return StringUtils.replace((String)this.getFullyQualifiedManageableServiceBaseName(), (String)this.getNamespaceProperty(), (String)"/");
    }

    @Override
    protected String handleGetManageableValueObjectFullPath() {
        return StringUtils.replace((String)this.getFullyQualifiedManageableValueObjectName(), (String)this.getNamespaceProperty(), (String)"/");
    }

    @Override
    protected String handleGetManageableValueObjectClassName() {
        return this.getName() + this.getConfiguredProperty("crudValueObjectSuffix");
    }

    @Override
    protected String handleGetFullyQualifiedManageableValueObjectName() {
        return this.getManageablePackageName() + this.getNamespaceProperty() + this.getManageableValueObjectClassName();
    }

    @Override
    protected boolean handleIsRemotingTypeRmi() {
        return "rmi".equalsIgnoreCase(this.getRemotingType());
    }

    @Override
    protected boolean handleIsRemotingTypeNone() {
        return "none".equalsIgnoreCase(this.getRemotingType());
    }

    @Override
    protected boolean handleIsRemotingTypeHttpInvoker() {
        return "httpinvoker".equalsIgnoreCase(this.getRemotingType());
    }

    @Override
    protected boolean handleIsRemotingTypeHessian() {
        return "hessian".equalsIgnoreCase(this.getRemotingType());
    }

    @Override
    protected boolean handleIsRemotingTypeBurlap() {
        return "burlap".equalsIgnoreCase(this.getRemotingType());
    }

    @Override
    protected String handleGetRemoteUrl() {
        StringBuilder result = new StringBuilder();
        String propertyPrefix = ObjectUtils.toString((Object)this.getConfiguredProperty("configPropertyPrefix"));
        if (!this.isRemotingTypeNone()) {
            if (this.isRemotingTypeHttpInvoker() || this.isRemotingTypeHessian() || this.isRemotingTypeBurlap()) {
                result.append("${").append(propertyPrefix).append("remoteHttpScheme}://${");
                result.append(propertyPrefix);
                result.append("remoteServer}");
                if (this.hasServiceRemotePort()) {
                    result.append(":${");
                    result.append(propertyPrefix);
                    result.append("remotePort}");
                }
                if (this.hasServiceRemoteContext()) {
                    result.append("/${");
                    result.append(propertyPrefix);
                    result.append("remoteContext}");
                }
                result.append("/remote");
                result.append(this.getManageableServiceName());
            } else if (this.isRemotingTypeRmi()) {
                result.append("${").append(propertyPrefix).append("remoteRmiScheme}://${");
                result.append(propertyPrefix);
                result.append("remoteServer}");
                if (this.hasServiceRemotePort()) {
                    result.append(":${");
                    result.append(propertyPrefix);
                    result.append("remotePort}");
                }
                result.append("/remote");
                result.append(this.getManageableServiceName());
            }
        }
        return result.toString();
    }

    @Override
    protected String handleGetRemoteServer() {
        return StringUtils.trimToEmpty((String)String.valueOf(this.getConfiguredProperty("serviceRemoteServer")));
    }

    @Override
    protected String handleGetRemotePort() {
        String serviceRemotePort = StringUtils.trimToEmpty((String)String.valueOf(this.getConfiguredProperty("serviceRemotePort")));
        return SpringMetafacadeUtils.getServiceRemotePort((ClassifierFacade)this, serviceRemotePort);
    }

    @Override
    protected String handleGetRemoteContext() {
        return this.isConfiguredProperty("serviceRemoteContext") ? ObjectUtils.toString((Object)this.getConfiguredProperty("serviceRemoteContext")) : "";
    }

    @Override
    protected boolean handleIsRemotable() {
        return !this.isRemotingTypeNone();
    }

    private String getRemotingType() {
        String serviceRemotingType = StringUtils.trimToEmpty((String)String.valueOf(this.getConfiguredProperty("serviceRemotingType")));
        return SpringMetafacadeUtils.getServiceRemotingType((ClassifierFacade)this, serviceRemotingType);
    }

    private boolean hasServiceRemotePort() {
        return StringUtils.isNotBlank((String)this.getRemotePort());
    }

    private boolean hasServiceRemoteContext() {
        return StringUtils.isNotBlank((String)this.getRemoteContext());
    }
}

