/*
 * Decompiled with CFR 0.152.
 */
package org.andromda.cartridges.spring.metafacades;

import org.andromda.cartridges.spring.SpringProfile;
import org.andromda.cartridges.spring.metafacades.SpringCriteriaAttributeLogic;
import org.apache.commons.lang.BooleanUtils;
import org.apache.commons.lang.ObjectUtils;
import org.apache.commons.lang.StringUtils;

public class SpringCriteriaAttributeLogicImpl
extends SpringCriteriaAttributeLogic {
    private static final long serialVersionUID = 34L;
    private static final String ORDER_UNSET = "ORDER_UNSET";
    private static final int UNSET = -1;
    private static final String HIBERNATE_CRITERIA_QUERY_IGNORE_CASE = "hibernateCriteriaQueryIgnoreCase";

    public SpringCriteriaAttributeLogicImpl(Object metaObject, String context) {
        super(metaObject, context);
    }

    @Override
    protected String handleGetAttributeName() {
        String attributeName = this.getName();
        Object value = this.findTaggedValue(SpringProfile.TAGGEDVALUE_HIBERNATE_CRITERIA_ATTRIBUTE);
        if (value != null) {
            attributeName = String.valueOf(value);
        }
        return StringUtils.trimToEmpty((String)attributeName);
    }

    @Override
    protected String handleGetComparator() {
        String comparator = null;
        Object value = this.findTaggedValue(SpringProfile.TAGGEDVALUE_HIBERNATE_CRITERIA_COMPARATOR);
        if (value != null) {
            comparator = String.valueOf(value);
        }
        return StringUtils.trimToEmpty(comparator);
    }

    @Override
    protected boolean handleIsComparatorPresent() {
        return !StringUtils.isBlank((String)this.getComparator());
    }

    @Override
    protected String handleGetComparatorConstant() {
        String comparator = this.getComparator();
        String comparatorConstant = null;
        if (comparator != null) {
            if (SpringProfile.TAGGEDVALUEVALUE_COMPARATOR_LIKE.equalsIgnoreCase(comparator)) {
                comparatorConstant = "LIKE_COMPARATOR";
            } else if (SpringProfile.TAGGEDVALUEVALUE_INSENSITIVE_LIKE_COMPARATOR.equalsIgnoreCase(comparator)) {
                comparatorConstant = "INSENSITIVE_LIKE_COMPARATOR";
            } else if (SpringProfile.TAGGEDVALUEVALUE_COMPARATOR_EQUAL.equalsIgnoreCase(comparator)) {
                comparatorConstant = "EQUAL_COMPARATOR";
            } else if (SpringProfile.TAGGEDVALUEVALUE_COMPARATOR_GREATER_OR_EQUAL.equalsIgnoreCase(comparator)) {
                comparatorConstant = "GREATER_THAN_OR_EQUAL_COMPARATOR";
            } else if (SpringProfile.TAGGEDVALUEVALUE_COMPARATOR_GREATER.equalsIgnoreCase(comparator)) {
                comparatorConstant = "GREATER_THAN_COMPARATOR";
            } else if (SpringProfile.TAGGEDVALUEVALUE_COMPARATOR_LESS_OR_EQUAL.equalsIgnoreCase(comparator)) {
                comparatorConstant = "LESS_THAN_OR_EQUAL_COMPARATOR";
            } else if (SpringProfile.TAGGEDVALUEVALUE_COMPARATOR_LESS.equalsIgnoreCase(comparator)) {
                comparatorConstant = "LESS_THAN_COMPARATOR";
            } else if (SpringProfile.TAGGEDVALUEVALUE_COMPARATOR_IN.equalsIgnoreCase(comparator)) {
                comparatorConstant = "IN_COMPARATOR";
            } else if (SpringProfile.TAGGEDVALUEVALUE_COMPARATOR_NOT_EQUAL.equalsIgnoreCase(comparator)) {
                comparatorConstant = "NOT_EQUAL_COMPARATOR";
            }
        }
        return comparatorConstant;
    }

    @Override
    protected boolean handleIsNullable() {
        boolean result = false;
        String value = StringUtils.trimToEmpty((String)((String)this.findTaggedValue(SpringProfile.TAGGEDVALUE_HIBERNATE_CRITERIA_NULLABLE)));
        if (!StringUtils.isBlank((String)value)) {
            result = BooleanUtils.toBoolean((String)value);
        }
        return result;
    }

    @Override
    protected String handleGetMatchMode() {
        String matchMode = null;
        Object value = this.findTaggedValue(SpringProfile.TAGGEDVALUE_HIBERNATE_CRITERIA_MATCHMODE);
        if (value != null) {
            matchMode = String.valueOf(value);
        }
        return StringUtils.trimToEmpty(matchMode);
    }

    @Override
    protected String handleGetMatchModeConstant() {
        String matchMode = this.getMatchMode();
        String matchModeConstant = null;
        if (matchMode != null) {
            if (matchMode.equalsIgnoreCase(SpringProfile.TAGGEDVALUEVALUE_MATCHMODE_ANYWHERE)) {
                matchModeConstant = "ANYWHERE";
            } else if (matchMode.equalsIgnoreCase(SpringProfile.TAGGEDVALUEVALUE_MATCHMODE_END)) {
                matchModeConstant = "END";
            } else if (matchMode.equalsIgnoreCase(SpringProfile.TAGGEDVALUEVALUE_MATCHMODE_EXACT)) {
                matchModeConstant = "EXACT";
            } else if (matchMode.equalsIgnoreCase(SpringProfile.TAGGEDVALUEVALUE_MATCHMODE_START)) {
                matchModeConstant = "START";
            }
        }
        return matchModeConstant;
    }

    @Override
    protected boolean handleIsMatchModePresent() {
        return !StringUtils.isBlank((String)this.getMatchMode());
    }

    @Override
    protected boolean handleIsOrderable() {
        return !ORDER_UNSET.equals(this.getOrderDirection());
    }

    @Override
    protected String handleGetOrderDirection() {
        String result = ORDER_UNSET;
        String value = StringUtils.trimToEmpty((String)((String)this.findTaggedValue(SpringProfile.TAGGEDVALUE_HIBERNATE_CRITERIA_ORDER_DIRECTION)));
        if (!StringUtils.isBlank((String)value)) {
            if (value.equals(SpringProfile.TAGGEDVALUEVALUE_ORDER_ASCENDING)) {
                result = "ORDER_ASC";
            } else if (value.equals(SpringProfile.TAGGEDVALUEVALUE_ORDER_DESCENDING)) {
                result = "ORDER_DESC";
            }
        }
        return result;
    }

    @Override
    protected int handleGetOrderRelevance() {
        int result = -1;
        String value = StringUtils.trimToEmpty((String)((String)this.findTaggedValue(SpringProfile.TAGGEDVALUE_HIBERNATE_CRITERIA_ORDER_RELEVANCE)));
        if (!StringUtils.isBlank((String)value)) {
            try {
                result = Integer.parseInt(value);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return result;
    }

    protected boolean handleIsIgnoreCase() {
        Object value = this.findTaggedValue(SpringProfile.TAGGEDVALUE_HIBERNATE_CRITERIA_COMPARATOR_IGNORE_CASE);
        if (value == null) {
            value = this.getConfiguredProperty(HIBERNATE_CRITERIA_QUERY_IGNORE_CASE);
        }
        return Boolean.valueOf(ObjectUtils.toString((Object)value));
    }
}

