/*
 * Decompiled with CFR 0.152.
 */
package org.acegisecurity.vote;

import java.util.Iterator;
import java.util.List;
import org.acegisecurity.AccessDecisionManager;
import org.acegisecurity.AccessDeniedException;
import org.acegisecurity.AcegiMessageSource;
import org.acegisecurity.ConfigAttribute;
import org.acegisecurity.vote.AccessDecisionVoter;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.MessageSource;
import org.springframework.context.MessageSourceAware;
import org.springframework.context.support.MessageSourceAccessor;
import org.springframework.util.Assert;

public abstract class AbstractAccessDecisionManager
implements AccessDecisionManager,
InitializingBean,
MessageSourceAware {
    private List decisionVoters;
    protected MessageSourceAccessor messages = AcegiMessageSource.getAccessor();
    private boolean allowIfAllAbstainDecisions = false;

    public void afterPropertiesSet() throws Exception {
        this.checkIfValidList(this.decisionVoters);
        Assert.notNull((Object)this.messages, (String)"A message source must be set");
    }

    protected final void checkAllowIfAllAbstainDecisions() {
        if (!this.isAllowIfAllAbstainDecisions()) {
            throw new AccessDeniedException(this.messages.getMessage("AbstractAccessDecisionManager.accessDenied", "Access is denied"));
        }
    }

    private void checkIfValidList(List listToCheck) {
        if (listToCheck == null || listToCheck.size() == 0) {
            throw new IllegalArgumentException("A list of AccessDecisionVoters is required");
        }
    }

    public List getDecisionVoters() {
        return this.decisionVoters;
    }

    public boolean isAllowIfAllAbstainDecisions() {
        return this.allowIfAllAbstainDecisions;
    }

    public void setAllowIfAllAbstainDecisions(boolean allowIfAllAbstainDecisions) {
        this.allowIfAllAbstainDecisions = allowIfAllAbstainDecisions;
    }

    public void setDecisionVoters(List newList) {
        this.checkIfValidList(newList);
        Iterator iter = newList.iterator();
        while (iter.hasNext()) {
            Object currentObject = null;
            try {
                currentObject = iter.next();
                AccessDecisionVoter attemptToCast = (AccessDecisionVoter)currentObject;
            }
            catch (ClassCastException cce) {
                throw new IllegalArgumentException("AccessDecisionVoter " + currentObject.getClass().getName() + " must implement AccessDecisionVoter");
            }
        }
        this.decisionVoters = newList;
    }

    public void setMessageSource(MessageSource messageSource) {
        this.messages = new MessageSourceAccessor(messageSource);
    }

    public boolean supports(ConfigAttribute attribute) {
        Iterator iter = this.decisionVoters.iterator();
        while (iter.hasNext()) {
            AccessDecisionVoter voter = (AccessDecisionVoter)iter.next();
            if (!voter.supports(attribute)) continue;
            return true;
        }
        return false;
    }

    public boolean supports(Class clazz) {
        Iterator iter = this.decisionVoters.iterator();
        while (iter.hasNext()) {
            AccessDecisionVoter voter = (AccessDecisionVoter)iter.next();
            if (voter.supports(clazz)) continue;
            return false;
        }
        return true;
    }
}

