/*
 * Decompiled with CFR 0.152.
 */
package org.acegisecurity.userdetails.ldap;

import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import org.acegisecurity.GrantedAuthority;
import org.acegisecurity.GrantedAuthorityImpl;
import org.acegisecurity.ldap.LdapEntryMapper;
import org.acegisecurity.userdetails.ldap.LdapUserDetailsImpl;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.util.Assert;

public class LdapUserDetailsMapper
implements LdapEntryMapper {
    private final Log logger = LogFactory.getLog((Class)(class$org$acegisecurity$userdetails$ldap$LdapUserDetailsMapper == null ? (class$org$acegisecurity$userdetails$ldap$LdapUserDetailsMapper = LdapUserDetailsMapper.class$("org.acegisecurity.userdetails.ldap.LdapUserDetailsMapper")) : class$org$acegisecurity$userdetails$ldap$LdapUserDetailsMapper));
    private String passwordAttributeName = "userPassword";
    private String rolePrefix = "ROLE_";
    private String[] roleAttributes = null;
    private boolean convertToUpperCase = true;
    static /* synthetic */ Class class$org$acegisecurity$userdetails$ldap$LdapUserDetailsMapper;

    public Object mapAttributes(String dn, Attributes attributes) throws NamingException {
        LdapUserDetailsImpl.Essence essence = new LdapUserDetailsImpl.Essence();
        essence.setDn(dn);
        essence.setAttributes(attributes);
        Attribute passwordAttribute = attributes.get(this.passwordAttributeName);
        if (passwordAttribute != null) {
            Object retrievedPassword = passwordAttribute.get();
            if (!(retrievedPassword instanceof String)) {
                retrievedPassword = new String((byte[])retrievedPassword);
            }
            essence.setPassword((String)retrievedPassword);
        }
        for (int i = 0; this.roleAttributes != null && i < this.roleAttributes.length; ++i) {
            Attribute roleAttribute = attributes.get(this.roleAttributes[i]);
            if (roleAttribute == null) {
                this.logger.debug((Object)("Couldn't read role attribute '" + this.roleAttributes[i] + "' for user " + dn));
                continue;
            }
            NamingEnumeration<?> attributeRoles = roleAttribute.getAll();
            while (attributeRoles.hasMore()) {
                GrantedAuthority authority = this.createAuthority(attributeRoles.next());
                if (authority != null) {
                    essence.addAuthority(authority);
                    continue;
                }
                this.logger.debug((Object)("Failed to create an authority value from attribute with Id: " + roleAttribute.getID()));
            }
        }
        return essence;
    }

    protected GrantedAuthority createAuthority(Object role) {
        if (role instanceof String) {
            if (this.convertToUpperCase) {
                role = ((String)role).toUpperCase();
            }
            return new GrantedAuthorityImpl(this.rolePrefix + role);
        }
        return null;
    }

    public void setConvertToUpperCase(boolean convertToUpperCase) {
        this.convertToUpperCase = convertToUpperCase;
    }

    public void setPasswordAttributeName(String passwordAttributeName) {
        this.passwordAttributeName = passwordAttributeName;
    }

    public void setRoleAttributes(String[] roleAttributes) {
        Assert.notNull((Object)roleAttributes, (String)"roleAttributes array cannot be null");
        this.roleAttributes = roleAttributes;
    }

    public void setRolePrefix(String rolePrefix) {
        this.rolePrefix = rolePrefix;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

