/*
 * Decompiled with CFR 0.152.
 */
package org.acegisecurity.ui.rememberme;

import java.util.Date;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.acegisecurity.Authentication;
import org.acegisecurity.providers.rememberme.RememberMeAuthenticationToken;
import org.acegisecurity.ui.AuthenticationDetailsSource;
import org.acegisecurity.ui.AuthenticationDetailsSourceImpl;
import org.acegisecurity.ui.logout.LogoutHandler;
import org.acegisecurity.ui.rememberme.RememberMeServices;
import org.acegisecurity.userdetails.UserDetails;
import org.acegisecurity.userdetails.UserDetailsService;
import org.acegisecurity.userdetails.UsernameNotFoundException;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.RequestUtils;

public class TokenBasedRememberMeServices
implements RememberMeServices,
InitializingBean,
LogoutHandler {
    public static final String ACEGI_SECURITY_HASHED_REMEMBER_ME_COOKIE_KEY = "ACEGI_SECURITY_HASHED_REMEMBER_ME_COOKIE";
    public static final String DEFAULT_PARAMETER = "_acegi_security_remember_me";
    protected static final Log logger = LogFactory.getLog((Class)(class$org$acegisecurity$ui$rememberme$TokenBasedRememberMeServices == null ? (class$org$acegisecurity$ui$rememberme$TokenBasedRememberMeServices = TokenBasedRememberMeServices.class$("org.acegisecurity.ui.rememberme.TokenBasedRememberMeServices")) : class$org$acegisecurity$ui$rememberme$TokenBasedRememberMeServices));
    private AuthenticationDetailsSource authenticationDetailsSource = new AuthenticationDetailsSourceImpl();
    private String key;
    private String parameter = "_acegi_security_remember_me";
    private UserDetailsService userDetailsService;
    private long tokenValiditySeconds = 1209600L;
    static /* synthetic */ Class class$org$acegisecurity$ui$rememberme$TokenBasedRememberMeServices;

    public void afterPropertiesSet() throws Exception {
        Assert.hasLength((String)this.key);
        Assert.hasLength((String)this.parameter);
        Assert.notNull((Object)this.userDetailsService);
    }

    public Authentication autoLogin(HttpServletRequest request, HttpServletResponse response) {
        Cookie[] cookies = request.getCookies();
        if (cookies == null || cookies.length == 0) {
            return null;
        }
        for (int i = 0; i < cookies.length; ++i) {
            if (!ACEGI_SECURITY_HASHED_REMEMBER_ME_COOKIE_KEY.equals(cookies[i].getName())) continue;
            String cookieValue = cookies[i].getValue();
            if (Base64.isArrayByteBase64((byte[])cookieValue.getBytes())) {
                String cookieAsPlainText;
                String[] cookieTokens;
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)"Remember-me cookie detected");
                }
                if ((cookieTokens = StringUtils.delimitedListToStringArray((String)(cookieAsPlainText = new String(Base64.decodeBase64((byte[])cookieValue.getBytes()))), (String)":")).length == 3) {
                    UserDetails userDetails;
                    long tokenExpiryTime;
                    try {
                        tokenExpiryTime = new Long(cookieTokens[1]);
                    }
                    catch (NumberFormatException nfe) {
                        this.cancelCookie(request, response, "Cookie token[1] did not contain a valid number (contained '" + cookieTokens[1] + "')");
                        return null;
                    }
                    if (tokenExpiryTime < System.currentTimeMillis()) {
                        this.cancelCookie(request, response, "Cookie token[1] has expired (expired on '" + new Date(tokenExpiryTime) + "'; current time is '" + new Date() + "')");
                        return null;
                    }
                    try {
                        userDetails = this.userDetailsService.loadUserByUsername(cookieTokens[0]);
                    }
                    catch (UsernameNotFoundException notFound) {
                        this.cancelCookie(request, response, "Cookie token[0] contained username '" + cookieTokens[0] + "' but was not found");
                        return null;
                    }
                    if (!(userDetails.isAccountNonExpired() && userDetails.isCredentialsNonExpired() && userDetails.isEnabled())) {
                        this.cancelCookie(request, response, "Cookie token[0] contained username '" + cookieTokens[0] + "' but account has expired, credentials have expired, or user is disabled");
                        return null;
                    }
                    String expectedTokenSignature = DigestUtils.md5Hex((String)(userDetails.getUsername() + ":" + tokenExpiryTime + ":" + userDetails.getPassword() + ":" + this.key));
                    if (!expectedTokenSignature.equals(cookieTokens[2])) {
                        this.cancelCookie(request, response, "Cookie token[2] contained signature '" + cookieTokens[2] + "' but expected '" + expectedTokenSignature + "'");
                        return null;
                    }
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)"Remember-me cookie accepted");
                    }
                    RememberMeAuthenticationToken auth = new RememberMeAuthenticationToken(this.key, userDetails, userDetails.getAuthorities());
                    auth.setDetails(this.authenticationDetailsSource.buildDetails(request));
                    return auth;
                }
                this.cancelCookie(request, response, "Cookie token did not contain 3 tokens; decoded value was '" + cookieAsPlainText + "'");
                return null;
            }
            this.cancelCookie(request, response, "Cookie token was not Base64 encoded; value was '" + cookieValue + "'");
            return null;
        }
        return null;
    }

    private void cancelCookie(HttpServletRequest request, HttpServletResponse response, String reasonForLog) {
        if (reasonForLog != null && logger.isDebugEnabled()) {
            logger.debug((Object)("Cancelling cookie for reason: " + reasonForLog));
        }
        response.addCookie(this.makeCancelCookie(request));
    }

    public String getKey() {
        return this.key;
    }

    public String getParameter() {
        return this.parameter;
    }

    public long getTokenValiditySeconds() {
        return this.tokenValiditySeconds;
    }

    public UserDetailsService getUserDetailsService() {
        return this.userDetailsService;
    }

    public void loginFail(HttpServletRequest request, HttpServletResponse response) {
        this.cancelCookie(request, response, "Interactive authentication attempt was unsuccessful");
    }

    public void loginSuccess(HttpServletRequest request, HttpServletResponse response, Authentication successfulAuthentication) {
        String password;
        String username;
        if (!RequestUtils.getBooleanParameter((HttpServletRequest)request, (String)this.parameter, (boolean)false)) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Did not send remember-me cookie (principal did not set parameter '" + this.parameter + "')"));
            }
            return;
        }
        Assert.notNull((Object)successfulAuthentication.getPrincipal());
        Assert.notNull((Object)successfulAuthentication.getCredentials());
        if (successfulAuthentication.getPrincipal() instanceof UserDetails) {
            username = ((UserDetails)successfulAuthentication.getPrincipal()).getUsername();
            password = ((UserDetails)successfulAuthentication.getPrincipal()).getPassword();
        } else {
            username = successfulAuthentication.getPrincipal().toString();
            password = successfulAuthentication.getCredentials().toString();
        }
        Assert.hasLength((String)username);
        Assert.hasLength((String)password);
        long expiryTime = System.currentTimeMillis() + this.tokenValiditySeconds * 1000L;
        String signatureValue = new String(DigestUtils.md5Hex((String)(username + ":" + expiryTime + ":" + password + ":" + this.key)));
        String tokenValue = username + ":" + expiryTime + ":" + signatureValue;
        String tokenValueBase64 = new String(Base64.encodeBase64((byte[])tokenValue.getBytes()));
        response.addCookie(this.makeValidCookie(expiryTime, tokenValueBase64, request));
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Added remember-me cookie for user '" + username + "', expiry: '" + new Date(expiryTime) + "'"));
        }
    }

    public void logout(HttpServletRequest request, HttpServletResponse response, Authentication authentication) {
        this.cancelCookie(request, response, "Logout of user " + authentication.getName());
    }

    protected Cookie makeCancelCookie(HttpServletRequest request) {
        Cookie cookie = new Cookie(ACEGI_SECURITY_HASHED_REMEMBER_ME_COOKIE_KEY, null);
        cookie.setMaxAge(0);
        cookie.setPath(request.getContextPath());
        return cookie;
    }

    protected Cookie makeValidCookie(long expiryTime, String tokenValueBase64, HttpServletRequest request) {
        Cookie cookie = new Cookie(ACEGI_SECURITY_HASHED_REMEMBER_ME_COOKIE_KEY, tokenValueBase64);
        cookie.setMaxAge(157680000);
        cookie.setPath(request.getContextPath());
        return cookie;
    }

    public void setAuthenticationDetailsSource(AuthenticationDetailsSource authenticationDetailsSource) {
        Assert.notNull((Object)authenticationDetailsSource, (String)"AuthenticationDetailsSource required");
        this.authenticationDetailsSource = authenticationDetailsSource;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public void setParameter(String parameter) {
        this.parameter = parameter;
    }

    public void setTokenValiditySeconds(long tokenValiditySeconds) {
        this.tokenValiditySeconds = tokenValiditySeconds;
    }

    public void setUserDetailsService(UserDetailsService authenticationDao) {
        this.userDetailsService = authenticationDao;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

