/*
 * Decompiled with CFR 0.152.
 */
package org.acegisecurity.afterinvocation;

import java.util.Collection;
import java.util.Iterator;
import org.acegisecurity.AccessDeniedException;
import org.acegisecurity.Authentication;
import org.acegisecurity.AuthorizationServiceException;
import org.acegisecurity.ConfigAttribute;
import org.acegisecurity.ConfigAttributeDefinition;
import org.acegisecurity.acl.AclEntry;
import org.acegisecurity.acl.AclManager;
import org.acegisecurity.acl.basic.BasicAclEntry;
import org.acegisecurity.acl.basic.SimpleAclEntry;
import org.acegisecurity.afterinvocation.AfterInvocationProvider;
import org.acegisecurity.afterinvocation.ArrayFilterer;
import org.acegisecurity.afterinvocation.CollectionFilterer;
import org.acegisecurity.afterinvocation.Filterer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.util.Assert;

public class BasicAclEntryAfterInvocationCollectionFilteringProvider
implements AfterInvocationProvider,
InitializingBean {
    protected static final Log logger = LogFactory.getLog((Class)(class$org$acegisecurity$afterinvocation$BasicAclEntryAfterInvocationCollectionFilteringProvider == null ? (class$org$acegisecurity$afterinvocation$BasicAclEntryAfterInvocationCollectionFilteringProvider = BasicAclEntryAfterInvocationCollectionFilteringProvider.class$("org.acegisecurity.afterinvocation.BasicAclEntryAfterInvocationCollectionFilteringProvider")) : class$org$acegisecurity$afterinvocation$BasicAclEntryAfterInvocationCollectionFilteringProvider));
    private AclManager aclManager;
    private Class processDomainObjectClass = class$java$lang$Object == null ? (class$java$lang$Object = BasicAclEntryAfterInvocationCollectionFilteringProvider.class$("java.lang.Object")) : class$java$lang$Object;
    private String processConfigAttribute = "AFTER_ACL_COLLECTION_READ";
    private int[] requirePermission = new int[]{SimpleAclEntry.READ};
    static /* synthetic */ Class class$org$acegisecurity$afterinvocation$BasicAclEntryAfterInvocationCollectionFilteringProvider;
    static /* synthetic */ Class class$java$lang$Object;

    public void afterPropertiesSet() throws Exception {
        Assert.notNull((Object)this.processConfigAttribute, (String)"A processConfigAttribute is mandatory");
        Assert.notNull((Object)this.aclManager, (String)"An aclManager is mandatory");
        if (this.requirePermission == null || this.requirePermission.length == 0) {
            throw new IllegalArgumentException("One or more requirePermission entries is mandatory");
        }
    }

    public Object decide(Authentication authentication, Object object, ConfigAttributeDefinition config, Object returnedObject) throws AccessDeniedException {
        Iterator iter = config.getConfigAttributes();
        while (iter.hasNext()) {
            ConfigAttribute attr = (ConfigAttribute)iter.next();
            if (!this.supports(attr)) continue;
            if (returnedObject == null) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)"Return object is null, skipping");
                }
                return null;
            }
            Filterer filterer = null;
            if (returnedObject instanceof Collection) {
                Collection collection = (Collection)returnedObject;
                filterer = new CollectionFilterer(collection);
            } else if (returnedObject.getClass().isArray()) {
                Object[] array = (Object[])returnedObject;
                filterer = new ArrayFilterer(array);
            } else {
                throw new AuthorizationServiceException("A Collection or an array (or null) was required as the returnedObject, but the returnedObject was: " + returnedObject);
            }
            Iterator collectionIter = filterer.iterator();
            while (collectionIter.hasNext()) {
                Object domainObject = collectionIter.next();
                boolean hasPermission = false;
                AclEntry[] acls = null;
                if (domainObject == null) {
                    hasPermission = true;
                } else if (!this.processDomainObjectClass.isAssignableFrom(domainObject.getClass())) {
                    hasPermission = true;
                } else {
                    acls = this.aclManager.getAcls(domainObject, authentication);
                }
                if (acls != null && acls.length != 0) {
                    for (int i = 0; i < acls.length; ++i) {
                        if (!(acls[i] instanceof BasicAclEntry)) continue;
                        BasicAclEntry processableAcl = (BasicAclEntry)acls[i];
                        for (int y = 0; y < this.requirePermission.length; ++y) {
                            if (!processableAcl.isPermitted(this.requirePermission[y])) continue;
                            hasPermission = true;
                            if (!logger.isDebugEnabled()) continue;
                            logger.debug((Object)("Principal is authorised for element: " + domainObject + " due to ACL: " + processableAcl.toString()));
                        }
                    }
                }
                if (hasPermission) continue;
                filterer.remove(domainObject);
                if (!logger.isDebugEnabled()) continue;
                logger.debug((Object)("Principal is NOT authorised for element: " + domainObject));
            }
            return filterer.getFilteredObject();
        }
        return returnedObject;
    }

    public AclManager getAclManager() {
        return this.aclManager;
    }

    public String getProcessConfigAttribute() {
        return this.processConfigAttribute;
    }

    public int[] getRequirePermission() {
        return this.requirePermission;
    }

    public void setAclManager(AclManager aclManager) {
        this.aclManager = aclManager;
    }

    public void setProcessConfigAttribute(String processConfigAttribute) {
        this.processConfigAttribute = processConfigAttribute;
    }

    public void setProcessDomainObjectClass(Class processDomainObjectClass) {
        Assert.notNull((Object)processDomainObjectClass, (String)"processDomainObjectClass cannot be set to null");
        this.processDomainObjectClass = processDomainObjectClass;
    }

    public void setRequirePermission(int[] requirePermission) {
        this.requirePermission = requirePermission;
    }

    public boolean supports(ConfigAttribute attribute) {
        return attribute.getAttribute() != null && attribute.getAttribute().equals(this.getProcessConfigAttribute());
    }

    public boolean supports(Class clazz) {
        return true;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

