/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.lazy.kstar;

import weka.classifiers.lazy.kstar.KStarCache;
import weka.classifiers.lazy.kstar.KStarConstants;
import weka.classifiers.lazy.kstar.KStarWrapper;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.RevisionHandler;
import weka.core.RevisionUtils;

public class KStarNominalAttribute
implements KStarConstants,
RevisionHandler {
    protected Instances m_TrainSet;
    protected Instance m_Test;
    protected Instance m_Train;
    protected int m_AttrIndex;
    protected double m_Stop = 1.0;
    protected double m_MissingProb = 1.0;
    protected double m_AverageProb = 1.0;
    protected double m_SmallestProb = 1.0;
    protected int m_TotalCount;
    protected int[] m_Distribution;
    protected int[][] m_RandClassCols;
    protected KStarCache m_Cache;
    protected int m_NumInstances;
    protected int m_NumClasses;
    protected int m_NumAttributes;
    protected int m_ClassType;
    protected int m_MissingMode = 4;
    protected int m_BlendMethod = 1;
    protected int m_BlendFactor = 20;

    public KStarNominalAttribute(Instance test, Instance train, int attrIndex, Instances trainSet, int[][] randClassCol, KStarCache cache) {
        this.m_Test = test;
        this.m_Train = train;
        this.m_AttrIndex = attrIndex;
        this.m_TrainSet = trainSet;
        this.m_RandClassCols = randClassCol;
        this.m_Cache = cache;
        this.init();
    }

    private void init() {
        try {
            this.m_NumInstances = this.m_TrainSet.numInstances();
            this.m_NumClasses = this.m_TrainSet.numClasses();
            this.m_NumAttributes = this.m_TrainSet.numAttributes();
            this.m_ClassType = this.m_TrainSet.classAttribute().type();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public double transProb() {
        double transProb = 0.0;
        if (this.m_Cache.containsKey(this.m_Test.value(this.m_AttrIndex))) {
            KStarCache.TableEntry te = this.m_Cache.getCacheValues(this.m_Test.value(this.m_AttrIndex));
            this.m_Stop = te.value;
            this.m_MissingProb = te.pmiss;
        } else {
            this.generateAttrDistribution();
            this.m_Stop = this.m_BlendMethod == 2 ? this.stopProbUsingEntropy() : this.stopProbUsingBlend();
            this.m_Cache.store(this.m_Test.value(this.m_AttrIndex), this.m_Stop, this.m_MissingProb);
        }
        if (this.m_Train.isMissing(this.m_AttrIndex)) {
            transProb = this.m_MissingProb;
        } else {
            try {
                transProb = (1.0 - this.m_Stop) / (double)this.m_Test.attribute(this.m_AttrIndex).numValues();
                if ((int)this.m_Test.value(this.m_AttrIndex) == (int)this.m_Train.value(this.m_AttrIndex)) {
                    transProb += this.m_Stop;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return transProb;
    }

    private double stopProbUsingEntropy() {
        String debug = "(KStarNominalAttribute.stopProbUsingEntropy)";
        if (this.m_ClassType != 1) {
            System.err.println("Error: " + debug + " attribute class must be nominal!");
            System.exit(1);
        }
        int itcount = 0;
        double bestminprob = 0.0;
        double bestpsum = 0.0;
        double bestdiff = 0.0;
        double bestpstop = 0.0;
        KStarWrapper botvals = new KStarWrapper();
        KStarWrapper upvals = new KStarWrapper();
        KStarWrapper vals = new KStarWrapper();
        double lower = 0.005;
        double upper = 0.995;
        this.calculateEntropy(upper, upvals);
        this.calculateEntropy(lower, botvals);
        if (upvals.avgProb == 0.0) {
            this.calculateEntropy(lower, vals);
        } else {
            double stepsize;
            double pstop;
            if (upvals.randEntropy - upvals.actEntropy < botvals.randEntropy - botvals.actEntropy && botvals.randEntropy - botvals.actEntropy > 0.0) {
                bestpstop = pstop = lower;
                stepsize = 0.05;
                bestminprob = botvals.minProb;
                bestpsum = botvals.avgProb;
            } else {
                bestpstop = pstop = upper;
                stepsize = -0.05;
                bestminprob = upvals.minProb;
                bestpsum = upvals.avgProb;
            }
            double currentdiff = 0.0;
            bestdiff = 0.0;
            itcount = 0;
            do {
                double delta;
                ++itcount;
                double lastdiff = currentdiff;
                if ((pstop += stepsize) <= lower) {
                    pstop = lower;
                    currentdiff = 0.0;
                    delta = -1.0;
                } else if (pstop >= upper) {
                    pstop = upper;
                    currentdiff = 0.0;
                    delta = -1.0;
                } else {
                    this.calculateEntropy(pstop, vals);
                    currentdiff = vals.randEntropy - vals.actEntropy;
                    if (currentdiff < 0.0) {
                        currentdiff = 0.0;
                        if (Math.abs(stepsize) < 0.05 && bestdiff == 0.0) {
                            bestpstop = lower;
                            bestminprob = botvals.minProb;
                            bestpsum = botvals.avgProb;
                            break;
                        }
                    }
                    delta = currentdiff - lastdiff;
                }
                if (currentdiff > bestdiff) {
                    bestdiff = currentdiff;
                    bestpstop = pstop;
                    bestminprob = vals.minProb;
                    bestpsum = vals.avgProb;
                }
                if (!(delta < 0.0)) continue;
                if (Math.abs(stepsize) < 0.01) break;
                stepsize /= -2.0;
            } while (itcount <= 40);
        }
        this.m_SmallestProb = bestminprob;
        this.m_AverageProb = bestpsum;
        switch (this.m_MissingMode) {
            case 1: {
                this.m_MissingProb = 0.0;
                break;
            }
            case 3: {
                this.m_MissingProb = 1.0;
                break;
            }
            case 2: {
                this.m_MissingProb = this.m_SmallestProb;
                break;
            }
            case 4: {
                this.m_MissingProb = this.m_AverageProb;
            }
        }
        double stopProb = Math.abs(bestpsum - (double)this.m_TotalCount) < 1.0E-5 ? 1.0 : bestpstop;
        return stopProb;
    }

    private void calculateEntropy(double stop, KStarWrapper params) {
        int k;
        int i;
        int j;
        double actent = 0.0;
        double randent = 0.0;
        double psum = 0.0;
        double minprob = 1.0;
        double[][] pseudoClassProb = new double[6][this.m_NumClasses];
        for (j = 0; j <= 5; ++j) {
            for (i = 0; i < this.m_NumClasses; ++i) {
                pseudoClassProb[j][i] = 0.0;
            }
        }
        for (i = 0; i < this.m_NumInstances; ++i) {
            Instance train = this.m_TrainSet.instance(i);
            if (train.isMissing(this.m_AttrIndex)) continue;
            double pstar = this.PStar(this.m_Test, train, this.m_AttrIndex, stop);
            double tprob = pstar / (double)this.m_TotalCount;
            if (pstar < minprob) {
                minprob = pstar;
            }
            psum += tprob;
            for (k = 0; k <= 5; ++k) {
                double[] dArray = pseudoClassProb[k];
                int n = this.m_RandClassCols[k][i];
                dArray[n] = dArray[n] + tprob;
            }
        }
        for (j = this.m_NumClasses - 1; j >= 0; --j) {
            double actClassProb = pseudoClassProb[5][j] / psum;
            if (!(actClassProb > 0.0)) continue;
            actent -= actClassProb * Math.log(actClassProb) / 0.693147181;
        }
        for (k = 0; k < 5; ++k) {
            for (i = this.m_NumClasses - 1; i >= 0; --i) {
                double randClassProb = pseudoClassProb[k][i] / psum;
                if (!(randClassProb > 0.0)) continue;
                randent -= randClassProb * Math.log(randClassProb) / 0.693147181;
            }
        }
        params.actEntropy = actent;
        params.randEntropy = randent /= 5.0;
        params.avgProb = psum;
        params.minProb = minprob;
    }

    private double stopProbUsingBlend() {
        int itcount = 0;
        KStarWrapper botvals = new KStarWrapper();
        KStarWrapper upvals = new KStarWrapper();
        KStarWrapper vals = new KStarWrapper();
        int testvalue = (int)this.m_Test.value(this.m_AttrIndex);
        double aimfor = (double)(this.m_TotalCount - this.m_Distribution[testvalue]) * (double)this.m_BlendFactor / 100.0 + (double)this.m_Distribution[testvalue];
        double tstop = 1.0 - (double)this.m_BlendFactor / 100.0;
        double lower = 0.005;
        double upper = 0.995;
        this.calculateSphereSize(testvalue, lower, botvals);
        botvals.sphere -= aimfor;
        this.calculateSphereSize(testvalue, upper, upvals);
        upvals.sphere -= aimfor;
        if (upvals.avgProb == 0.0) {
            this.calculateSphereSize(testvalue, tstop, vals);
        } else if (upvals.sphere > 0.0) {
            tstop = upper;
            vals.avgProb = upvals.avgProb;
        } else {
            while (true) {
                this.calculateSphereSize(testvalue, tstop, vals);
                vals.sphere -= aimfor;
                if (Math.abs(vals.sphere) <= 0.01 || ++itcount >= 40) break;
                if (vals.sphere > 0.0) {
                    lower = tstop;
                    tstop = (upper + lower) / 2.0;
                    continue;
                }
                upper = tstop;
                tstop = (upper + lower) / 2.0;
            }
        }
        this.m_SmallestProb = vals.minProb;
        this.m_AverageProb = vals.avgProb;
        switch (this.m_MissingMode) {
            case 1: {
                this.m_MissingProb = 0.0;
                break;
            }
            case 3: {
                this.m_MissingProb = 1.0;
                break;
            }
            case 2: {
                this.m_MissingProb = this.m_SmallestProb;
                break;
            }
            case 4: {
                this.m_MissingProb = this.m_AverageProb;
            }
        }
        double stopProb = Math.abs(vals.avgProb - (double)this.m_TotalCount) < 1.0E-5 ? 1.0 : tstop;
        return stopProb;
    }

    private void calculateSphereSize(int testvalue, double stop, KStarWrapper params) {
        double sphere;
        double tval = 0.0;
        double t1 = 0.0;
        double minprob = 1.0;
        double transprob = 0.0;
        for (int i = 0; i < this.m_Distribution.length; ++i) {
            double tprob;
            int thiscount = this.m_Distribution[i];
            if (thiscount == 0) continue;
            if (testvalue == i) {
                tprob = (stop + (1.0 - stop) / (double)this.m_Distribution.length) / (double)this.m_TotalCount;
                tval += tprob * (double)thiscount;
                t1 += tprob * tprob * (double)thiscount;
            } else {
                tprob = (1.0 - stop) / (double)this.m_Distribution.length / (double)this.m_TotalCount;
                tval += tprob * (double)thiscount;
                t1 += tprob * tprob * (double)thiscount;
            }
            if (!(minprob > tprob * (double)this.m_TotalCount)) continue;
            minprob = tprob * (double)this.m_TotalCount;
        }
        transprob = tval;
        params.sphere = sphere = t1 == 0.0 ? 0.0 : tval * tval / t1;
        params.avgProb = transprob;
        params.minProb = minprob;
    }

    private double PStar(Instance test, Instance train, int col, double stop) {
        int numvalues = 0;
        try {
            numvalues = test.attribute(col).numValues();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        double pstar = (int)test.value(col) == (int)train.value(col) ? stop + (1.0 - stop) / (double)numvalues : (1.0 - stop) / (double)numvalues;
        return pstar;
    }

    private void generateAttrDistribution() {
        this.m_Distribution = new int[this.m_TrainSet.attribute(this.m_AttrIndex).numValues()];
        for (int i = 0; i < this.m_NumInstances; ++i) {
            Instance train = this.m_TrainSet.instance(i);
            if (train.isMissing(this.m_AttrIndex)) continue;
            ++this.m_TotalCount;
            int n = (int)train.value(this.m_AttrIndex);
            this.m_Distribution[n] = this.m_Distribution[n] + 1;
        }
    }

    public void setOptions(int missingmode, int blendmethod, int blendfactor) {
        this.m_MissingMode = missingmode;
        this.m_BlendMethod = blendmethod;
        this.m_BlendFactor = blendfactor;
    }

    @Override
    public String getRevision() {
        return RevisionUtils.extract("$Revision: 10153 $");
    }
}

