/*
 * Decompiled with CFR 0.152.
 */
package nu.zoom.catonine.prefs.impl;

import java.io.File;
import java.util.Set;
import nu.zoom.catonine.prefs.Preferences;
import nu.zoom.swing.desktop.common.BackendException;
import nu.zoom.swing.desktop.component.filechooser.FileChooser;
import nu.zoom.swing.desktop.component.filechooser.FileChooserFactory;
import nu.zoom.swing.desktop.preferences.InvalidDataTypeException;

public class PreferencesImpl
implements Preferences {
    private static final String MANAGER_FILECHOOSER_PREFS_KEY = "StyleRuleManager.filechooser";
    private static final String FILE_RECENT_PREFERENCESKEY = "svansprogram-recent";
    private static final String DETACHED_WINDOWS = "svansprogram-detached-default";
    private static final String OPENED_FILES_PREFS_KEY = "StyleRuleManager.openfiles";
    private static final String FILE_CONFIGURATION_PREFS_PREFIX = "StyleRuleManager.file.conf.";
    private static final String FILE_GUTTER_PREFS_PREFIX = "StyleRuleManager.file.gutter.";
    private static final String FILE_WRAP_PREFS_PREFIX = "StyleRuleManager.file.wrap.";
    private static final String SCROLLBACK_SIZE = "svansprogram-scrollback-size";
    private final nu.zoom.swing.desktop.preferences.Preferences preferences;
    private final FileChooserFactory fileChooserFactory;

    public PreferencesImpl(nu.zoom.swing.desktop.preferences.Preferences preferences, FileChooserFactory fileChooserFactory) {
        this.preferences = preferences;
        this.fileChooserFactory = fileChooserFactory;
    }

    @Override
    public String getPreferredUUIDForFile(File file) throws InvalidDataTypeException, BackendException {
        if (file == null) {
            throw new NullPointerException("File may not be null");
        }
        return this.preferences.getString(FILE_CONFIGURATION_PREFS_PREFIX + file.getName());
    }

    @Override
    public void setPreferredUUIDForFile(File file, String uuid) throws InvalidDataTypeException, BackendException {
        this.preferences.setString(FILE_CONFIGURATION_PREFS_PREFIX + file.getName(), uuid);
    }

    @Override
    public void rememeberOpenedFiles(Set<String> filenames) throws InvalidDataTypeException, BackendException {
        this.preferences.setStrings(OPENED_FILES_PREFS_KEY, filenames.size() < 1 ? null : filenames);
    }

    @Override
    public Set<String> getOpenedFiles() throws InvalidDataTypeException, BackendException {
        return this.preferences.getStrings(OPENED_FILES_PREFS_KEY);
    }

    @Override
    public FileChooser getConfiguratonFilechooser() throws InvalidDataTypeException, BackendException {
        return this.fileChooserFactory.getFileChooser(MANAGER_FILECHOOSER_PREFS_KEY);
    }

    @Override
    public FileChooser getFilechooser() throws InvalidDataTypeException, BackendException {
        return this.fileChooserFactory.getFileChooser(FILE_RECENT_PREFERENCESKEY);
    }

    @Override
    public Preferences.WindowOpenMode getWindowOpenMode() throws InvalidDataTypeException, BackendException {
        String stringValue = this.preferences.getString(DETACHED_WINDOWS);
        if (stringValue != null) {
            return Preferences.WindowOpenMode.valueOf(stringValue);
        }
        return Preferences.WindowOpenMode.Rememeber;
    }

    @Override
    public void setWindowOpenMode(Preferences.WindowOpenMode value) throws InvalidDataTypeException, BackendException {
        this.preferences.setString(DETACHED_WINDOWS, value.toString());
    }

    @Override
    public Integer getScrollbackSize() throws InvalidDataTypeException, BackendException {
        return this.preferences.getInteger(SCROLLBACK_SIZE);
    }

    @Override
    public void setScrollbackSize(Integer size) throws InvalidDataTypeException, BackendException {
        this.preferences.setInteger(SCROLLBACK_SIZE, size);
    }

    @Override
    public boolean isGutterForFile(File file) throws InvalidDataTypeException, BackendException {
        if (file == null) {
            throw new NullPointerException("File may not be null");
        }
        String value = this.preferences.getString(FILE_GUTTER_PREFS_PREFIX + file.getName());
        return value != null ? Boolean.parseBoolean(value) : false;
    }

    @Override
    public void setGutterForFile(File file, boolean gutterVisible) throws InvalidDataTypeException, BackendException {
        if (file == null) {
            throw new NullPointerException("File may not be null");
        }
        this.preferences.setString(FILE_GUTTER_PREFS_PREFIX + file.getName(), Boolean.toString(gutterVisible));
    }

    @Override
    public boolean isWrapForFile(File file) throws InvalidDataTypeException, BackendException {
        if (file == null) {
            throw new NullPointerException("File may not be null");
        }
        String value = this.preferences.getString(FILE_WRAP_PREFS_PREFIX + file.getName());
        return value != null ? Boolean.parseBoolean(value) : false;
    }

    @Override
    public void setWrapForFile(File file, boolean wrap) throws InvalidDataTypeException, BackendException {
        if (file == null) {
            throw new NullPointerException("File may not be null");
        }
        this.preferences.setString(FILE_WRAP_PREFS_PREFIX + file.getName(), Boolean.toString(wrap));
    }
}

