/*
 * Decompiled with CFR 0.152.
 */
package nu.zoom.util.dns.impl;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.InitialDirContext;
import nu.zoom.util.dns.Resolver;
import nu.zoom.util.dns.SRVRecord;
import nu.zoom.util.dns.UnknownResponseException;

public class ResolverImpl
implements Resolver {
    private final Hashtable<String, String> env = new Hashtable();

    public ResolverImpl() {
        this.env.put("java.naming.factory.initial", "com.sun.jndi.dns.DnsContextFactory");
    }

    @Override
    public List<SRVRecord> lookupSRV(String domain) throws NamingException, UnknownResponseException {
        Attribute attribute;
        ArrayList<SRVRecord> result = new ArrayList<SRVRecord>();
        InitialDirContext ictx = new InitialDirContext(this.env);
        String[] attrs = new String[]{"SRV"};
        Attributes attributes = ictx.getAttributes(domain, attrs);
        if (attributes != null && (attribute = attributes.get("SRV")) != null) {
            for (int i = 0; i < attribute.size(); ++i) {
                String srvEntry = "" + attribute.get(i);
                String[] srvEntryParts = srvEntry.split(" ");
                if (srvEntryParts.length != 4) {
                    throw new UnknownResponseException("Unable to parse: " + srvEntry);
                }
                int prio = Integer.parseInt(srvEntryParts[0]);
                int weight = Integer.parseInt(srvEntryParts[1]);
                int port = Integer.parseInt(srvEntryParts[2]);
                SRVRecord record = new SRVRecord(srvEntryParts[3], port, prio, weight);
                result.add(record);
            }
        }
        return result;
    }

    @Override
    public List<InetAddress> lookupA(String domain) throws NamingException, UnknownResponseException, UnknownHostException {
        Attribute attribute;
        ArrayList<InetAddress> result = new ArrayList<InetAddress>();
        InitialDirContext ictx = new InitialDirContext(this.env);
        String[] attrs = new String[]{"A"};
        Attributes attributes = ictx.getAttributes(domain, attrs);
        if (attributes != null && (attribute = attributes.get("A")) != null) {
            for (int i = 0; i < attribute.size(); ++i) {
                String srvEntry = "" + attribute.get(i);
                result.add(InetAddress.getByName(srvEntry));
            }
        }
        return result;
    }
}

