/*
 * Decompiled with CFR 0.152.
 */
package nu.zoom.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;

public class Config
extends Properties {
    private static final long serialVersionUID = 1622735858880022226L;
    private static final String RESOURCE_NAME = "zoom.properties";
    private static Config instance = null;
    private String filename;

    private Config() {
    }

    public void store() throws IOException {
        FileOutputStream out = new FileOutputStream(this.filename);
        super.store(out, "Configuration data");
    }

    public static synchronized Config getInstance() {
        if (instance == null) {
            String tmpFilename = null;
            File file = null;
            tmpFilename = System.getProperty("config.properties");
            if (tmpFilename == null && !(file = new File(tmpFilename = System.getProperty("user.home") + File.separator + RESOURCE_NAME)).exists()) {
                tmpFilename = System.getProperty("user.dir") + File.separator + RESOURCE_NAME;
            }
            instance = new Config();
            Config.instance.filename = tmpFilename;
            file = new File(tmpFilename);
            if (file.exists()) {
                try {
                    instance.load(new FileInputStream(file));
                }
                catch (IOException exc) {
                    System.err.println("Unable to load configuration.");
                    exc.printStackTrace();
                    System.exit(-1);
                }
            } else {
                InputStream ins = Config.class.getClassLoader().getResourceAsStream(RESOURCE_NAME);
                if (ins != null) {
                    try {
                        instance.load(ins);
                    }
                    catch (IOException exc) {
                        System.err.println("Unable to load configuration.");
                        exc.printStackTrace();
                        System.exit(-1);
                    }
                } else {
                    System.err.println("Unable to load configuration.");
                    System.exit(-1);
                }
            }
        }
        return instance;
    }
}

