/*
 * Decompiled with CFR 0.152.
 */
package nu.zoom.swing.field;

import java.awt.Color;
import javax.swing.JLabel;
import javax.swing.text.Document;
import nu.zoom.swing.field.ValidatingField;

public abstract class LabeledValidatingField
extends ValidatingField {
    private static final long serialVersionUID = 2797888906243489866L;
    private JLabel fieldLabel;
    private Color okForegroundColor;
    private String defaultToolTipText;

    public LabeledValidatingField(JLabel fieldLabel) {
        if (fieldLabel == null) {
            throw new IllegalArgumentException("Field label may not be null");
        }
        this.fieldLabel = fieldLabel;
        this.okForegroundColor = fieldLabel.getForeground();
    }

    public LabeledValidatingField(JLabel fieldLabel, Document doc, String text, int columns) {
        super(doc, text, columns);
        if (fieldLabel == null) {
            throw new IllegalArgumentException("Field label may not be null");
        }
        this.fieldLabel = fieldLabel;
        this.okForegroundColor = fieldLabel.getForeground();
    }

    public LabeledValidatingField(JLabel fieldLabel, int columns) {
        super(columns);
        if (fieldLabel == null) {
            throw new IllegalArgumentException("Field label may not be null");
        }
        this.fieldLabel = fieldLabel;
        this.okForegroundColor = fieldLabel.getForeground();
    }

    public LabeledValidatingField(JLabel fieldLabel, String text, int columns) {
        super(text, columns);
        if (fieldLabel == null) {
            throw new IllegalArgumentException("Field label may not be null");
        }
        this.fieldLabel = fieldLabel;
        this.okForegroundColor = fieldLabel.getForeground();
    }

    public LabeledValidatingField(JLabel fieldLabel, String text) {
        super(text);
        if (fieldLabel == null) {
            throw new IllegalArgumentException("Field label may not be null");
        }
        this.fieldLabel = fieldLabel;
        this.okForegroundColor = fieldLabel.getForeground();
    }

    @Override
    protected abstract ValidatingField.ValidationResult validateDocument();

    @Override
    protected void validationFailed(String message) {
        if (this.defaultToolTipText == null) {
            this.defaultToolTipText = this.getToolTipText();
        }
        this.setToolTipText(message);
        this.fieldLabel.setToolTipText(message);
        this.fieldLabel.setForeground(Color.RED);
    }

    @Override
    protected void validationPassed() {
        this.setToolTipText(this.defaultToolTipText);
        this.fieldLabel.setToolTipText(this.defaultToolTipText);
        this.defaultToolTipText = null;
        this.fieldLabel.setForeground(this.okForegroundColor);
    }
}

