/*
 * Decompiled with CFR 0.152.
 */
package nu.zoom.swing.dialog;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import nu.zoom.swing.layout.VerticalPanel;

public class SystemPropertiesDialog
extends JDialog {
    public SystemPropertiesDialog() {
        this.init();
        this.pack();
    }

    private void init() {
        this.setTitle("System properties");
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                SystemPropertiesDialog.this.dispose();
            }
        });
        this.getContentPane().setLayout(new BorderLayout());
        VerticalPanel mainPanel = new VerticalPanel();
        this.getContentPane().add((Component)new JScrollPane(mainPanel), "Center");
        mainPanel.addRow("Java vendor", System.getProperty("java.vendor", "?"));
        mainPanel.addRow("Vendor URL", System.getProperty("java.vendor.url", "?"));
        mainPanel.addRow("Java version", System.getProperty("java.version", "?"));
        mainPanel.addRow("Java home directory", System.getProperty("java.home", "?"));
        mainPanel.addRow("Class version", System.getProperty("java.class.version", "?"));
        mainPanel.addRow("Java compiler", System.getProperty("java.compiler", "?"));
        JTextArea classPathArea = new JTextArea(1, 40);
        classPathArea.setEditable(false);
        classPathArea.setText(System.getProperty("java.class.path", "?"));
        mainPanel.addRow("Java classpath", (JComponent)new JScrollPane(classPathArea));
        mainPanel.addRow("Java endorsed dirs.", System.getProperty("java.endorsed.dirs", "?"));
        mainPanel.addRow("Java extension dirs.", System.getProperty("java.ext.dirs", "?"));
        mainPanel.addRow("OS Name", System.getProperty("os.name", "?"));
        mainPanel.addRow("OS Architecture", System.getProperty("os.arch", "?"));
        mainPanel.addRow("OS Version", System.getProperty("os.version", "?"));
        mainPanel.addRow("User name", System.getProperty("user.name", "?"));
        mainPanel.addRow("User language", System.getProperty("user.language", "?"));
        mainPanel.addRow("User region", System.getProperty("user.region", "?"));
        mainPanel.addRow("User timezone", System.getProperty("user.timezone", "?"));
        mainPanel.addRow("User home directory", System.getProperty("user.home", "?"));
        mainPanel.addRow("User current directory", System.getProperty("user.dir", "?"));
        mainPanel.addRow("File separator", System.getProperty("file.separator", "?"));
        mainPanel.addRow("Path separator", System.getProperty("path.separator", "?"));
        String property = System.getProperty("line.separator", null);
        if (property != null) {
            StringBuffer separators = new StringBuffer();
            for (int n = 0; n < property.length(); ++n) {
                char ch = property.charAt(n);
                separators.append("'0x");
                separators.append(Integer.toHexString(ch));
                separators.append("' ");
            }
            mainPanel.addRow("Line separator", separators.toString());
        }
        mainPanel.addRow("Temporary files", System.getProperty("java.io.tmpdir", "?"));
        mainPanel.addRow("Default file encoding", System.getProperty("file.encoding", "?"));
        mainPanel.addRow("Toolkit name", System.getProperty("awt.toolkit", "?"));
        Toolkit tk = Toolkit.getDefaultToolkit();
        Dimension ss = tk.getScreenSize();
        if (ss != null) {
            String screenSize = Integer.toString(ss.width) + "x" + Integer.toString(ss.height);
            mainPanel.addRow("Screen size", screenSize);
        }
        mainPanel.addRow("Screen resolution DPI", Integer.toString(tk.getScreenResolution()));
        JPanel OKButtonPanel = new JPanel();
        OKButtonPanel.setLayout(new FlowLayout());
        OKButtonPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        JButton OKButton = new JButton("OK");
        OKButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SystemPropertiesDialog.this.dispose();
            }
        });
        OKButtonPanel.add(OKButton);
        this.getContentPane().add((Component)OKButtonPanel, "South");
    }
}

