/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.webdriver;

import com.google.common.base.Optional;
import com.google.inject.Inject;
import java.io.File;
import net.thucydides.core.ThucydidesSystemProperty;
import net.thucydides.core.model.TakeScreenshots;
import net.thucydides.core.steps.FilePathParser;
import net.thucydides.core.util.EnvironmentVariables;
import net.thucydides.core.webdriver.Configuration;
import net.thucydides.core.webdriver.SupportedWebDriver;
import net.thucydides.core.webdriver.UnsupportedDriverException;
import org.apache.commons.lang3.StringUtils;

public class SystemPropertiesConfiguration
implements Configuration {
    public static final String WEBDRIVER_DRIVER = ThucydidesSystemProperty.DRIVER.getPropertyName();
    public static final String DEFAULT_WEBDRIVER_DRIVER = "firefox";
    public static final int DEFAULT_ELEMENT_TIMEOUT_SECONDS = 5;
    public static final Integer DEFAULT_ESTIMATED_AVERAGE_STEP_COUNT = 5;
    public static final String OUTPUT_DIRECTORY_PROPERTY = ThucydidesSystemProperty.OUTPUT_DIRECTORY.getPropertyName();
    private static final String MAVEN_BUILD_DIRECTORY = "project.build.directory";
    private static final String MAVEN_REPORTS_DIRECTORY = "project.reporting.OutputDirectory";
    public static final String REFUSE_UNTRUSTED_CERTIFICATES = ThucydidesSystemProperty.REFUSE_UNTRUSTED_CERTIFICATES.getPropertyName();
    public static final String MAX_RETRIES = "max.retries";
    private static final String DEFAULT_OUTPUT_DIRECTORY = "target/site/thucydides";
    private File outputDirectory;
    private String defaultBaseUrl;
    private final EnvironmentVariables environmentVariables;
    private final FilePathParser filePathParser;

    @Inject
    public SystemPropertiesConfiguration(EnvironmentVariables environmentVariables) {
        this.environmentVariables = environmentVariables;
        this.filePathParser = new FilePathParser(environmentVariables);
    }

    @Override
    public Configuration copy() {
        return this.withEnvironmentVariables(this.environmentVariables);
    }

    @Override
    public Configuration withEnvironmentVariables(EnvironmentVariables environmentVariables) {
        SystemPropertiesConfiguration copy = new SystemPropertiesConfiguration(environmentVariables.copy());
        copy.outputDirectory = null;
        copy.defaultBaseUrl = this.defaultBaseUrl;
        return copy;
    }

    @Override
    public EnvironmentVariables getEnvironmentVariables() {
        return this.environmentVariables;
    }

    @Override
    public int maxRetries() {
        int maxRetries = this.getEnvironmentVariables().getPropertyAsInteger(MAX_RETRIES, (Integer)0);
        return maxRetries;
    }

    @Override
    public SupportedWebDriver getDriverType() {
        String driverType = this.environmentVariables.getProperty(WEBDRIVER_DRIVER, DEFAULT_WEBDRIVER_DRIVER);
        return this.lookupSupportedDriverTypeFor(driverType);
    }

    public File loadOutputDirectoryFromSystemProperties() {
        String systemDirectoryProperty = this.environmentVariables.getProperty(OUTPUT_DIRECTORY_PROPERTY, this.getMavenBuildDirectory());
        String instantiatedPath = this.filePathParser.getInstanciatedPath(systemDirectoryProperty);
        String systemDefinedDirectory = instantiatedPath != null ? instantiatedPath : DEFAULT_OUTPUT_DIRECTORY;
        File newOutputDirectory = new File(systemDefinedDirectory);
        newOutputDirectory.mkdirs();
        return newOutputDirectory;
    }

    private String getMavenBuildDirectory() {
        String mavenBuildDirectory = this.getEnvironmentVariables().getProperty(MAVEN_BUILD_DIRECTORY);
        String mavenReportsDirectory = this.getEnvironmentVariables().getProperty(MAVEN_REPORTS_DIRECTORY);
        String defaultMavenRelativeTargetDirectory = null;
        if (StringUtils.isNotEmpty((CharSequence)mavenReportsDirectory)) {
            defaultMavenRelativeTargetDirectory = mavenReportsDirectory + "/thucydides";
        } else if (StringUtils.isNotEmpty((CharSequence)mavenBuildDirectory)) {
            defaultMavenRelativeTargetDirectory = mavenBuildDirectory + "/site/thucydides";
        }
        return defaultMavenRelativeTargetDirectory;
    }

    @Override
    public int getStepDelay() {
        int stepDelay = 0;
        String stepDelayValue = this.getEnvironmentVariables().getProperty(ThucydidesSystemProperty.STEP_DELAY.getPropertyName());
        if (stepDelayValue != null && !stepDelayValue.isEmpty()) {
            stepDelay = Integer.valueOf(stepDelayValue);
        }
        return stepDelay;
    }

    @Override
    public int getElementTimeout() {
        int elementTimeout = 5;
        String stepDelayValue = this.getEnvironmentVariables().getProperty(ThucydidesSystemProperty.ELEMENT_TIMEOUT.getPropertyName());
        if (stepDelayValue != null && !stepDelayValue.isEmpty()) {
            elementTimeout = Integer.valueOf(stepDelayValue);
        }
        return elementTimeout;
    }

    @Override
    public boolean getUseUniqueBrowser() {
        boolean uniqueBrowser = false;
        String uniqueBrowserValue = this.getEnvironmentVariables().getProperty(ThucydidesSystemProperty.UNIQUE_BROWSER.getPropertyName());
        if (uniqueBrowserValue != null) {
            uniqueBrowser = Boolean.valueOf(uniqueBrowserValue);
        }
        return uniqueBrowser;
    }

    @Override
    public void setOutputDirectory(File outputDirectory) {
        this.outputDirectory = outputDirectory;
    }

    @Override
    public File getOutputDirectory() {
        if (this.outputDirectory == null) {
            this.outputDirectory = this.loadOutputDirectoryFromSystemProperties();
        }
        return this.outputDirectory;
    }

    @Override
    public double getEstimatedAverageStepCount() {
        return this.getEnvironmentVariables().getPropertyAsInteger(ThucydidesSystemProperty.ESTIMATED_AVERAGE_STEP_COUNT.getPropertyName(), DEFAULT_ESTIMATED_AVERAGE_STEP_COUNT).intValue();
    }

    @Override
    public boolean onlySaveFailingScreenshots() {
        return this.getEnvironmentVariables().getPropertyAsBoolean(ThucydidesSystemProperty.ONLY_SAVE_FAILING_SCREENSHOTS.getPropertyName(), false);
    }

    @Override
    public boolean takeVerboseScreenshots() {
        return this.getEnvironmentVariables().getPropertyAsBoolean(ThucydidesSystemProperty.VERBOSE_SCREENSHOTS.getPropertyName(), false);
    }

    @Override
    public Optional<TakeScreenshots> getScreenshotLevel() {
        String takeScreenshotsLevel = ThucydidesSystemProperty.THUCYDIDES_TAKE_SCREENSHOTS.from(this.getEnvironmentVariables());
        if (StringUtils.isNotEmpty((CharSequence)takeScreenshotsLevel)) {
            return Optional.of((Object)((Object)TakeScreenshots.valueOf(takeScreenshotsLevel.toUpperCase())));
        }
        return Optional.absent();
    }

    @Override
    public boolean storeHtmlSourceCode() {
        return this.getEnvironmentVariables().getPropertyAsBoolean(ThucydidesSystemProperty.THUCYDIDES_STORE_HTML_SOURCE, false);
    }

    @Override
    public void setIfUndefined(String property, String value) {
        if (this.getEnvironmentVariables().getProperty(property) == null) {
            this.getEnvironmentVariables().setProperty(property, value);
        }
    }

    @Override
    public void setDefaultBaseUrl(String defaultBaseUrl) {
        this.defaultBaseUrl = defaultBaseUrl;
    }

    @Override
    public int getRestartFrequency() {
        return this.environmentVariables.getPropertyAsInteger(ThucydidesSystemProperty.RESTART_BROWSER_FREQUENCY.getPropertyName(), (Integer)0);
    }

    @Override
    public int getCurrentTestCount() {
        return 0;
    }

    @Override
    public String getBaseUrl() {
        return this.environmentVariables.getProperty(ThucydidesSystemProperty.BASE_URL.getPropertyName(), this.defaultBaseUrl);
    }

    private SupportedWebDriver lookupSupportedDriverTypeFor(String driverType) {
        SupportedWebDriver driver = null;
        try {
            driver = SupportedWebDriver.getDriverTypeFor(driverType);
        }
        catch (IllegalArgumentException iae) {
            this.throwUnsupportedDriverExceptionFor(driverType);
        }
        return driver;
    }

    private void throwUnsupportedDriverExceptionFor(String driverType) {
        throw new UnsupportedDriverException(driverType + " is not a supported browser. Supported driver values are: " + SupportedWebDriver.listOfSupportedDrivers());
    }
}

