/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.cs.owlapi.dlsyntax;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.TreeSet;
import org.semanticweb.owlapi.io.OWLObjectRenderer;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLAnnotation;
import org.semanticweb.owlapi.model.OWLAnnotationAssertionAxiom;
import org.semanticweb.owlapi.model.OWLAnnotationProperty;
import org.semanticweb.owlapi.model.OWLAnnotationPropertyDomainAxiom;
import org.semanticweb.owlapi.model.OWLAnnotationPropertyRangeAxiom;
import org.semanticweb.owlapi.model.OWLAnonymousIndividual;
import org.semanticweb.owlapi.model.OWLAsymmetricObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLClassAssertionAxiom;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLDataAllValuesFrom;
import org.semanticweb.owlapi.model.OWLDataCardinalityRestriction;
import org.semanticweb.owlapi.model.OWLDataComplementOf;
import org.semanticweb.owlapi.model.OWLDataExactCardinality;
import org.semanticweb.owlapi.model.OWLDataHasValue;
import org.semanticweb.owlapi.model.OWLDataIntersectionOf;
import org.semanticweb.owlapi.model.OWLDataMaxCardinality;
import org.semanticweb.owlapi.model.OWLDataMinCardinality;
import org.semanticweb.owlapi.model.OWLDataOneOf;
import org.semanticweb.owlapi.model.OWLDataProperty;
import org.semanticweb.owlapi.model.OWLDataPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLDataPropertyDomainAxiom;
import org.semanticweb.owlapi.model.OWLDataPropertyExpression;
import org.semanticweb.owlapi.model.OWLDataPropertyRangeAxiom;
import org.semanticweb.owlapi.model.OWLDataSomeValuesFrom;
import org.semanticweb.owlapi.model.OWLDataUnionOf;
import org.semanticweb.owlapi.model.OWLDatatype;
import org.semanticweb.owlapi.model.OWLDatatypeDefinitionAxiom;
import org.semanticweb.owlapi.model.OWLDatatypeRestriction;
import org.semanticweb.owlapi.model.OWLDeclarationAxiom;
import org.semanticweb.owlapi.model.OWLDifferentIndividualsAxiom;
import org.semanticweb.owlapi.model.OWLDisjointClassesAxiom;
import org.semanticweb.owlapi.model.OWLDisjointDataPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLDisjointObjectPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLDisjointUnionAxiom;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLEquivalentClassesAxiom;
import org.semanticweb.owlapi.model.OWLEquivalentDataPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLEquivalentObjectPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLFacetRestriction;
import org.semanticweb.owlapi.model.OWLFunctionalDataPropertyAxiom;
import org.semanticweb.owlapi.model.OWLFunctionalObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLHasKeyAxiom;
import org.semanticweb.owlapi.model.OWLHasValueRestriction;
import org.semanticweb.owlapi.model.OWLIndividual;
import org.semanticweb.owlapi.model.OWLInverseFunctionalObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLInverseObjectPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLIrreflexiveObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLLiteral;
import org.semanticweb.owlapi.model.OWLNamedIndividual;
import org.semanticweb.owlapi.model.OWLNegativeDataPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLNegativeObjectPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLObject;
import org.semanticweb.owlapi.model.OWLObjectAllValuesFrom;
import org.semanticweb.owlapi.model.OWLObjectCardinalityRestriction;
import org.semanticweb.owlapi.model.OWLObjectComplementOf;
import org.semanticweb.owlapi.model.OWLObjectExactCardinality;
import org.semanticweb.owlapi.model.OWLObjectHasSelf;
import org.semanticweb.owlapi.model.OWLObjectHasValue;
import org.semanticweb.owlapi.model.OWLObjectIntersectionOf;
import org.semanticweb.owlapi.model.OWLObjectInverseOf;
import org.semanticweb.owlapi.model.OWLObjectMaxCardinality;
import org.semanticweb.owlapi.model.OWLObjectMinCardinality;
import org.semanticweb.owlapi.model.OWLObjectOneOf;
import org.semanticweb.owlapi.model.OWLObjectProperty;
import org.semanticweb.owlapi.model.OWLObjectPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLObjectPropertyDomainAxiom;
import org.semanticweb.owlapi.model.OWLObjectPropertyExpression;
import org.semanticweb.owlapi.model.OWLObjectPropertyRangeAxiom;
import org.semanticweb.owlapi.model.OWLObjectSomeValuesFrom;
import org.semanticweb.owlapi.model.OWLObjectUnionOf;
import org.semanticweb.owlapi.model.OWLObjectVisitor;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLPropertyDomainAxiom;
import org.semanticweb.owlapi.model.OWLPropertyExpression;
import org.semanticweb.owlapi.model.OWLPropertyRange;
import org.semanticweb.owlapi.model.OWLPropertyRangeAxiom;
import org.semanticweb.owlapi.model.OWLQuantifiedDataRestriction;
import org.semanticweb.owlapi.model.OWLQuantifiedObjectRestriction;
import org.semanticweb.owlapi.model.OWLReflexiveObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLSameIndividualAxiom;
import org.semanticweb.owlapi.model.OWLSubAnnotationPropertyOfAxiom;
import org.semanticweb.owlapi.model.OWLSubClassOfAxiom;
import org.semanticweb.owlapi.model.OWLSubDataPropertyOfAxiom;
import org.semanticweb.owlapi.model.OWLSubObjectPropertyOfAxiom;
import org.semanticweb.owlapi.model.OWLSubPropertyChainOfAxiom;
import org.semanticweb.owlapi.model.OWLSymmetricObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLTransitiveObjectPropertyAxiom;
import org.semanticweb.owlapi.model.SWRLBuiltInAtom;
import org.semanticweb.owlapi.model.SWRLClassAtom;
import org.semanticweb.owlapi.model.SWRLDArgument;
import org.semanticweb.owlapi.model.SWRLDataPropertyAtom;
import org.semanticweb.owlapi.model.SWRLDataRangeAtom;
import org.semanticweb.owlapi.model.SWRLDifferentIndividualsAtom;
import org.semanticweb.owlapi.model.SWRLIArgument;
import org.semanticweb.owlapi.model.SWRLIndividualArgument;
import org.semanticweb.owlapi.model.SWRLLiteralArgument;
import org.semanticweb.owlapi.model.SWRLObjectPropertyAtom;
import org.semanticweb.owlapi.model.SWRLRule;
import org.semanticweb.owlapi.model.SWRLSameIndividualAtom;
import org.semanticweb.owlapi.model.SWRLVariable;
import org.semanticweb.owlapi.util.IRIShortFormProvider;
import org.semanticweb.owlapi.util.ShortFormProvider;
import org.semanticweb.owlapi.util.SimpleIRIShortFormProvider;
import org.semanticweb.owlapi.util.SimpleShortFormProvider;
import uk.ac.manchester.cs.owlapi.dlsyntax.DLSyntax;

public class DLSyntaxObjectRenderer
implements OWLObjectRenderer,
OWLObjectVisitor {
    private ShortFormProvider shortFormProvider = new SimpleShortFormProvider();
    private IRIShortFormProvider iriShortFormProvider = new SimpleIRIShortFormProvider();
    private StringBuilder buffer = new StringBuilder();
    private OWLObject focusedObject;

    public void setFocusedObject(OWLObject focusedObject) {
        this.focusedObject = focusedObject;
    }

    public boolean isFocusedObject(OWLObject obj) {
        if (this.focusedObject == null) {
            return false;
        }
        return this.focusedObject.equals(obj);
    }

    public void setShortFormProvider(ShortFormProvider shortFormProvider) {
        this.shortFormProvider = shortFormProvider;
    }

    public String render(OWLObject object) {
        this.buffer = new StringBuilder();
        object.accept((OWLObjectVisitor)this);
        return this.buffer.toString();
    }

    public void visit(OWLOntology ontology) {
        for (OWLAxiom ax : new TreeSet(ontology.getLogicalAxioms())) {
            ax.accept((OWLObjectVisitor)this);
            this.write("\n");
        }
    }

    protected void write(String s) {
        this.buffer.append(s);
    }

    protected String renderEntity(OWLEntity entity) {
        return this.shortFormProvider.getShortForm(entity);
    }

    protected void writeEntity(OWLEntity entity) {
        this.write(this.renderEntity(entity));
    }

    protected void write(DLSyntax keyword) {
        this.write(keyword.toString());
    }

    protected void write(int i) {
        this.write(Integer.toString(i));
    }

    protected void writeNested(OWLObject object) {
        if (this.isBracketedIfNested(object)) {
            this.write("(");
        }
        object.accept((OWLObjectVisitor)this);
        if (this.isBracketedIfNested(object)) {
            this.write(")");
        }
    }

    protected boolean isBracketedIfNested(OWLObject object) {
        return !(object instanceof OWLEntity);
    }

    private void writeObject(OWLObject object, boolean nest) {
        if (nest) {
            this.writeNested(object);
        } else {
            object.accept((OWLObjectVisitor)this);
        }
    }

    protected void write(Collection<? extends OWLObject> objects, DLSyntax delim, boolean nest) {
        if (objects.size() == 2) {
            Iterator<? extends OWLObject> it = objects.iterator();
            OWLObject o1 = it.next();
            OWLObject o2 = it.next();
            if (this.isFocusedObject(o1) || !this.isFocusedObject(o2)) {
                this.writeObject(o1, nest);
                this.writeSpace();
                this.write(delim);
                this.writeSpace();
                this.writeObject(o2, nest);
            } else {
                this.writeObject(o2, nest);
                this.writeSpace();
                this.write(delim);
                this.writeSpace();
                this.writeObject(o1, nest);
            }
        } else {
            Iterator<? extends OWLObject> it = objects.iterator();
            while (it.hasNext()) {
                OWLObject o = it.next();
                this.writeObject(o, nest);
                if (!it.hasNext()) continue;
                this.writeSpace();
                this.write(delim);
                this.writeSpace();
            }
        }
    }

    public void visit(OWLSubClassOfAxiom axiom) {
        axiom.getSubClass().accept((OWLObjectVisitor)this);
        this.writeSpace();
        this.write(DLSyntax.SUBCLASS);
        this.writeSpace();
        axiom.getSuperClass().accept((OWLObjectVisitor)this);
    }

    private void writePropertyAssertion(OWLPropertyAssertionAxiom<?, ?> ax) {
        if (ax instanceof OWLNegativeObjectPropertyAssertionAxiom || ax instanceof OWLNegativeDataPropertyAssertionAxiom) {
            this.write(DLSyntax.NOT);
        }
        ax.getProperty().accept((OWLObjectVisitor)this);
        this.write("(");
        ax.getSubject().accept((OWLObjectVisitor)this);
        this.write(", ");
        ax.getObject().accept((OWLObjectVisitor)this);
        this.write(")");
    }

    public void visit(OWLNegativeObjectPropertyAssertionAxiom axiom) {
        this.write(DLSyntax.NOT);
        this.writePropertyAssertion((OWLPropertyAssertionAxiom<?, ?>)axiom);
    }

    public void visit(OWLAsymmetricObjectPropertyAxiom axiom) {
    }

    public void visit(OWLReflexiveObjectPropertyAxiom axiom) {
        this.write(DLSyntax.TOP);
        this.writeSpace();
        this.write(DLSyntax.SUBCLASS);
        this.writeSpace();
        this.write(DLSyntax.EXISTS);
        this.writeSpace();
        ((OWLObjectPropertyExpression)axiom.getProperty()).accept((OWLObjectVisitor)this);
        this.write(" .");
        this.write(DLSyntax.SELF);
    }

    public void visit(OWLDisjointClassesAxiom axiom) {
        ArrayList descs = new ArrayList(axiom.getClassExpressions());
        for (int i = 0; i < descs.size(); ++i) {
            for (int j = i + 1; j < descs.size(); ++j) {
                ((OWLClassExpression)descs.get(i)).accept((OWLObjectVisitor)this);
                this.writeSpace();
                this.write(DLSyntax.DISJOINT_WITH);
                this.writeSpace();
                ((OWLClassExpression)descs.get(j)).accept((OWLObjectVisitor)this);
                if (j >= descs.size() - 1) continue;
                this.write(", ");
            }
        }
    }

    private void writeDomainAxiom(OWLPropertyDomainAxiom<?> axiom) {
        this.write(DLSyntax.EXISTS);
        this.writeSpace();
        axiom.getProperty().accept((OWLObjectVisitor)this);
        this.writeRestrictionSeparator();
        this.write(DLSyntax.TOP);
        this.writeSpace();
        this.write(DLSyntax.SUBCLASS);
        this.writeSpace();
        this.writeNested((OWLObject)axiom.getDomain());
    }

    private void writeRestrictionSeparator() {
        this.write(".");
    }

    public void visit(OWLDataPropertyDomainAxiom axiom) {
        this.writeDomainAxiom((OWLPropertyDomainAxiom<?>)axiom);
    }

    public void visit(OWLObjectPropertyDomainAxiom axiom) {
        this.writeDomainAxiom((OWLPropertyDomainAxiom<?>)axiom);
    }

    public void visit(OWLEquivalentObjectPropertiesAxiom axiom) {
        this.write(axiom.getProperties(), DLSyntax.EQUIVALENT_TO, false);
    }

    public void visit(OWLNegativeDataPropertyAssertionAxiom axiom) {
        this.write(DLSyntax.NOT);
        this.writePropertyAssertion((OWLPropertyAssertionAxiom<?, ?>)axiom);
    }

    public void visit(OWLDifferentIndividualsAxiom axiom) {
        this.write(axiom.getIndividuals(), DLSyntax.NOT_EQUAL, false);
    }

    public void visit(OWLDisjointDataPropertiesAxiom axiom) {
        this.write(axiom.getProperties(), DLSyntax.DISJOINT_WITH, false);
    }

    public void visit(OWLDisjointObjectPropertiesAxiom axiom) {
        this.write(axiom.getProperties(), DLSyntax.DISJOINT_WITH, false);
    }

    private void writeRangeAxiom(OWLPropertyRangeAxiom<?, ?> axiom) {
        this.write(DLSyntax.TOP);
        this.writeSpace();
        this.write(DLSyntax.SUBCLASS);
        this.writeSpace();
        this.write(DLSyntax.FORALL);
        this.writeSpace();
        axiom.getProperty().accept((OWLObjectVisitor)this);
        this.writeRestrictionSeparator();
        this.writeNested((OWLObject)axiom.getRange());
    }

    public void visit(OWLObjectPropertyRangeAxiom axiom) {
        this.writeRangeAxiom((OWLPropertyRangeAxiom<?, ?>)axiom);
    }

    public void visit(OWLObjectPropertyAssertionAxiom axiom) {
        this.writePropertyAssertion((OWLPropertyAssertionAxiom<?, ?>)axiom);
    }

    private void writeFunctionalProperty(OWLPropertyExpression<?, ?> property) {
        this.write(DLSyntax.TOP);
        this.writeSpace();
        this.write(DLSyntax.SUBCLASS);
        this.writeSpace();
        this.write(DLSyntax.MAX);
        this.writeSpace();
        this.write(1);
        this.writeSpace();
        property.accept((OWLObjectVisitor)this);
    }

    public void visit(OWLFunctionalObjectPropertyAxiom axiom) {
        this.writeFunctionalProperty(axiom.getProperty());
    }

    public void visit(OWLSubObjectPropertyOfAxiom axiom) {
        ((OWLObjectPropertyExpression)axiom.getSubProperty()).accept((OWLObjectVisitor)this);
        this.writeSpace();
        this.write(DLSyntax.SUBCLASS);
        this.writeSpace();
        ((OWLObjectPropertyExpression)axiom.getSuperProperty()).accept((OWLObjectVisitor)this);
    }

    public void visit(OWLDisjointUnionAxiom axiom) {
        axiom.getOWLClass().accept((OWLObjectVisitor)this);
        this.write(DLSyntax.EQUAL);
        this.write(axiom.getClassExpressions(), DLSyntax.OR, false);
    }

    public void visit(OWLDeclarationAxiom axiom) {
    }

    public void visit(OWLAnnotationAssertionAxiom axiom) {
    }

    public void visit(OWLSymmetricObjectPropertyAxiom axiom) {
        ((OWLObjectPropertyExpression)axiom.getProperty()).accept((OWLObjectVisitor)this);
        this.writeSpace();
        this.write(DLSyntax.EQUIVALENT_TO);
        this.writeSpace();
        ((OWLObjectPropertyExpression)axiom.getProperty()).accept((OWLObjectVisitor)this);
        this.write(DLSyntax.INVERSE);
    }

    private void writeSpace() {
        this.write(" ");
    }

    public void visit(OWLDataPropertyRangeAxiom axiom) {
        this.writeRangeAxiom((OWLPropertyRangeAxiom<?, ?>)axiom);
    }

    public void visit(OWLFunctionalDataPropertyAxiom axiom) {
        this.writeFunctionalProperty(axiom.getProperty());
    }

    public void visit(OWLEquivalentDataPropertiesAxiom axiom) {
        this.write(axiom.getProperties(), DLSyntax.EQUIVALENT_TO, false);
    }

    public void visit(OWLClassAssertionAxiom axiom) {
        if (axiom.getClassExpression().isAnonymous()) {
            this.write("(");
        }
        axiom.getClassExpression().accept((OWLObjectVisitor)this);
        if (axiom.getClassExpression().isAnonymous()) {
            this.write(")");
        }
        this.write("(");
        axiom.getIndividual().accept((OWLObjectVisitor)this);
        this.write(")");
    }

    public void visit(OWLEquivalentClassesAxiom axiom) {
        this.write(axiom.getClassExpressions(), DLSyntax.EQUIVALENT_TO, false);
    }

    public void visit(OWLDataPropertyAssertionAxiom axiom) {
        this.writePropertyAssertion((OWLPropertyAssertionAxiom<?, ?>)axiom);
    }

    public void visit(OWLTransitiveObjectPropertyAxiom axiom) {
        ((OWLObjectPropertyExpression)axiom.getProperty()).accept((OWLObjectVisitor)this);
        this.writeSpace();
        this.write(DLSyntax.IN);
        this.writeSpace();
        this.write("R");
        this.write("\u207a");
    }

    public void visit(OWLIrreflexiveObjectPropertyAxiom axiom) {
        this.write(DLSyntax.TOP);
        this.writeSpace();
        this.write(DLSyntax.SUBCLASS);
        this.writeSpace();
        this.write(DLSyntax.NOT);
        this.write(DLSyntax.EXISTS);
        this.writeSpace();
        ((OWLObjectPropertyExpression)axiom.getProperty()).accept((OWLObjectVisitor)this);
        this.write(" .");
        this.write(DLSyntax.SELF);
    }

    public void visit(OWLSubDataPropertyOfAxiom axiom) {
        ((OWLDataPropertyExpression)axiom.getSubProperty()).accept((OWLObjectVisitor)this);
        this.write(DLSyntax.SUBCLASS);
        ((OWLDataPropertyExpression)axiom.getSuperProperty()).accept((OWLObjectVisitor)this);
    }

    public void visit(OWLInverseFunctionalObjectPropertyAxiom axiom) {
        this.write(DLSyntax.TOP);
        this.writeSpace();
        this.write(DLSyntax.SUBCLASS);
        this.writeSpace();
        this.write(DLSyntax.MAX);
        this.writeSpace();
        this.write(1);
        this.writeSpace();
        ((OWLObjectPropertyExpression)axiom.getProperty()).accept((OWLObjectVisitor)this);
        this.write(DLSyntax.INVERSE);
    }

    public void visit(OWLSameIndividualAxiom axiom) {
        this.write(axiom.getIndividuals(), DLSyntax.EQUAL, false);
    }

    public void visit(OWLSubPropertyChainOfAxiom axiom) {
        this.write(axiom.getPropertyChain(), DLSyntax.COMP, false);
        this.writeSpace();
        this.write(DLSyntax.SUBCLASS);
        this.writeSpace();
        axiom.getSuperProperty().accept((OWLObjectVisitor)this);
    }

    public void visit(OWLInverseObjectPropertiesAxiom axiom) {
        OWLObjectPropertyExpression second;
        OWLObjectPropertyExpression first;
        OWLObjectPropertyExpression o1 = axiom.getFirstProperty();
        OWLObjectPropertyExpression o2 = axiom.getSecondProperty();
        if (this.isFocusedObject((OWLObject)o1) || !this.isFocusedObject((OWLObject)o2)) {
            first = o1;
            second = o2;
        } else {
            first = o2;
            second = o1;
        }
        first.accept((OWLObjectVisitor)this);
        this.writeSpace();
        this.write(DLSyntax.EQUIVALENT_TO);
        this.writeSpace();
        second.accept((OWLObjectVisitor)this);
        this.write(DLSyntax.INVERSE);
    }

    public void visit(SWRLRule rule) {
        this.write(rule.getHead(), DLSyntax.WEDGE, false);
        this.writeSpace();
        this.write(DLSyntax.IMPLIES);
        this.writeSpace();
        this.write(rule.getBody(), DLSyntax.WEDGE, false);
    }

    public void visit(OWLClass desc) {
        if (desc.isOWLThing()) {
            this.write(DLSyntax.TOP);
        } else if (desc.isOWLNothing()) {
            this.write(DLSyntax.BOTTOM);
        } else {
            this.writeEntity((OWLEntity)desc);
        }
    }

    public void visit(OWLObjectIntersectionOf desc) {
        this.write(desc.getOperands(), DLSyntax.AND, true);
    }

    public void visit(OWLObjectUnionOf desc) {
        this.write(desc.getOperands(), DLSyntax.OR, true);
    }

    public void visit(OWLObjectComplementOf desc) {
        this.write(DLSyntax.NOT);
        this.writeNested((OWLObject)desc.getOperand());
    }

    private void writeCardinalityRestriction(OWLDataCardinalityRestriction restriction, DLSyntax keyword) {
        this.write(keyword);
        this.writeSpace();
        this.write(restriction.getCardinality());
        this.writeSpace();
        ((OWLDataPropertyExpression)restriction.getProperty()).accept((OWLObjectVisitor)this);
        this.writeRestrictionSeparator();
        this.writeNested((OWLObject)restriction.getFiller());
    }

    private void writeCardinalityRestriction(OWLObjectCardinalityRestriction restriction, DLSyntax keyword) {
        this.write(keyword);
        this.writeSpace();
        this.write(restriction.getCardinality());
        this.writeSpace();
        ((OWLObjectPropertyExpression)restriction.getProperty()).accept((OWLObjectVisitor)this);
        this.writeRestrictionSeparator();
        this.writeNested((OWLObject)restriction.getFiller());
    }

    private void writeQuantifiedRestriction(OWLQuantifiedDataRestriction restriction, DLSyntax keyword) {
        this.write(keyword);
        this.writeSpace();
        ((OWLDataPropertyExpression)restriction.getProperty()).accept((OWLObjectVisitor)this);
        this.writeRestrictionSeparator();
        this.writeNested((OWLObject)restriction.getFiller());
    }

    private void writeQuantifiedRestriction(OWLQuantifiedObjectRestriction restriction, DLSyntax keyword) {
        this.write(keyword);
        this.writeSpace();
        ((OWLObjectPropertyExpression)restriction.getProperty()).accept((OWLObjectVisitor)this);
        this.writeRestrictionSeparator();
        this.writeNested((OWLObject)restriction.getFiller());
    }

    public void visit(OWLObjectSomeValuesFrom desc) {
        this.writeQuantifiedRestriction((OWLQuantifiedObjectRestriction)desc, DLSyntax.EXISTS);
    }

    public void visit(OWLObjectAllValuesFrom desc) {
        this.writeQuantifiedRestriction((OWLQuantifiedObjectRestriction)desc, DLSyntax.FORALL);
    }

    private <R extends OWLPropertyRange, P extends OWLPropertyExpression<R, P>, V extends OWLObject> void writeValueRestriction(OWLHasValueRestriction<R, P, V> restriction) {
        this.write(DLSyntax.EXISTS);
        this.writeSpace();
        restriction.getProperty().accept((OWLObjectVisitor)this);
        this.writeRestrictionSeparator();
        this.write("{");
        restriction.getValue().accept((OWLObjectVisitor)this);
        this.write("}");
    }

    public void visit(OWLObjectHasValue desc) {
        this.writeValueRestriction((OWLHasValueRestriction)desc);
    }

    public void visit(OWLObjectMinCardinality desc) {
        this.writeCardinalityRestriction((OWLObjectCardinalityRestriction)desc, DLSyntax.MIN);
    }

    public void visit(OWLObjectExactCardinality desc) {
        this.writeCardinalityRestriction((OWLObjectCardinalityRestriction)desc, DLSyntax.EQUAL);
    }

    public void visit(OWLObjectMaxCardinality desc) {
        this.writeCardinalityRestriction((OWLObjectCardinalityRestriction)desc, DLSyntax.MAX);
    }

    public void visit(OWLObjectHasSelf desc) {
        this.write(DLSyntax.EXISTS);
        this.writeSpace();
        ((OWLObjectPropertyExpression)desc.getProperty()).accept((OWLObjectVisitor)this);
        this.write(" .");
        this.write(DLSyntax.SELF);
    }

    public void visit(OWLObjectOneOf desc) {
        Iterator it = desc.getIndividuals().iterator();
        while (it.hasNext()) {
            this.write("{");
            ((OWLIndividual)it.next()).accept((OWLObjectVisitor)this);
            this.write("}");
            if (!it.hasNext()) continue;
            this.write(" ");
            this.write(DLSyntax.OR);
            this.write(" ");
        }
    }

    public void visit(OWLDataSomeValuesFrom desc) {
        this.writeQuantifiedRestriction((OWLQuantifiedDataRestriction)desc, DLSyntax.EXISTS);
    }

    public void visit(OWLDataAllValuesFrom desc) {
        this.writeQuantifiedRestriction((OWLQuantifiedDataRestriction)desc, DLSyntax.FORALL);
    }

    public void visit(OWLDataHasValue desc) {
        this.writeValueRestriction((OWLHasValueRestriction)desc);
    }

    public void visit(OWLDataMinCardinality desc) {
        this.writeCardinalityRestriction((OWLDataCardinalityRestriction)desc, DLSyntax.MIN);
    }

    public void visit(OWLDataExactCardinality desc) {
        this.writeCardinalityRestriction((OWLDataCardinalityRestriction)desc, DLSyntax.EQUAL);
    }

    public void visit(OWLDataMaxCardinality desc) {
        this.writeCardinalityRestriction((OWLDataCardinalityRestriction)desc, DLSyntax.MAX);
    }

    public void visit(OWLDatatype node) {
        this.write(this.shortFormProvider.getShortForm((OWLEntity)node));
    }

    public void visit(OWLDataComplementOf node) {
        this.write(DLSyntax.NOT);
        node.getDataRange().accept((OWLObjectVisitor)this);
    }

    public void visit(OWLDataOneOf node) {
        Iterator it = node.getValues().iterator();
        while (it.hasNext()) {
            this.write("{");
            ((OWLLiteral)it.next()).accept((OWLObjectVisitor)this);
            this.write("}");
            if (!it.hasNext()) continue;
            this.write(DLSyntax.OR);
        }
    }

    public void visit(OWLDatatypeRestriction node) {
    }

    public void visit(OWLLiteral node) {
        this.write(node.getLiteral());
    }

    public void visit(OWLFacetRestriction node) {
    }

    public void visit(OWLObjectProperty property) {
        this.writeEntity((OWLEntity)property);
    }

    public void visit(OWLObjectInverseOf property) {
        property.getInverse().accept((OWLObjectVisitor)this);
        this.write(DLSyntax.INVERSE);
    }

    public void visit(OWLDataProperty property) {
        this.writeEntity((OWLEntity)property);
    }

    public void visit(OWLNamedIndividual individual) {
        this.writeEntity((OWLEntity)individual);
    }

    public void visit(OWLDatatypeDefinitionAxiom axiom) {
    }

    public void visit(OWLHasKeyAxiom axiom) {
    }

    public void visit(OWLAnnotationPropertyDomainAxiom axiom) {
    }

    public void visit(OWLAnnotationPropertyRangeAxiom axiom) {
    }

    public void visit(OWLSubAnnotationPropertyOfAxiom axiom) {
    }

    public void visit(OWLDataIntersectionOf node) {
    }

    public void visit(OWLDataUnionOf node) {
    }

    public void visit(OWLAnnotationProperty property) {
    }

    public void visit(OWLAnonymousIndividual individual) {
    }

    public void visit(IRI iri) {
    }

    public void visit(OWLAnnotation node) {
    }

    public void visit(SWRLClassAtom node) {
        node.getPredicate().accept((OWLObjectVisitor)this);
        this.write("(");
        ((SWRLIArgument)node.getArgument()).accept((OWLObjectVisitor)this);
        this.write(")");
    }

    public void visit(SWRLDataRangeAtom node) {
        node.getPredicate().accept((OWLObjectVisitor)this);
        this.write("(");
        ((SWRLDArgument)node.getArgument()).accept((OWLObjectVisitor)this);
        this.write(")");
    }

    public void visit(SWRLObjectPropertyAtom node) {
        node.getPredicate().accept((OWLObjectVisitor)this);
        this.write("(");
        ((SWRLIArgument)node.getFirstArgument()).accept((OWLObjectVisitor)this);
        this.write(", ");
        ((SWRLIArgument)node.getSecondArgument()).accept((OWLObjectVisitor)this);
        this.write(")");
    }

    public void visit(SWRLDataPropertyAtom node) {
        node.getPredicate().accept((OWLObjectVisitor)this);
        this.write("(");
        ((SWRLIArgument)node.getFirstArgument()).accept((OWLObjectVisitor)this);
        this.write(", ");
        ((SWRLDArgument)node.getSecondArgument()).accept((OWLObjectVisitor)this);
        this.write(")");
    }

    public void visit(SWRLBuiltInAtom node) {
        this.write(node.getPredicate().toString());
        this.write("(");
        this.write(node.getArguments(), DLSyntax.COMMA, true);
        this.write(")");
    }

    public void visit(SWRLVariable node) {
        this.write("?");
        this.write(this.iriShortFormProvider.getShortForm(node.getIRI()));
    }

    public void visit(SWRLIndividualArgument node) {
        node.getIndividual().accept((OWLObjectVisitor)this);
    }

    public void visit(SWRLLiteralArgument node) {
        node.getLiteral().accept((OWLObjectVisitor)this);
    }

    public void visit(SWRLSameIndividualAtom node) {
        this.write("sameAs(");
        ((SWRLIArgument)node.getFirstArgument()).accept((OWLObjectVisitor)this);
        this.write(", ");
        ((SWRLIArgument)node.getSecondArgument()).accept((OWLObjectVisitor)this);
        this.write(")");
    }

    public void visit(SWRLDifferentIndividualsAtom node) {
        this.write("differentFrom(");
        ((SWRLIArgument)node.getFirstArgument()).accept((OWLObjectVisitor)this);
        this.write(", ");
        ((SWRLIArgument)node.getSecondArgument()).accept((OWLObjectVisitor)this);
        this.write(")");
    }
}

