/*
 * Decompiled with CFR 0.152.
 */
package org.coode.owlapi.rdf.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.semanticweb.owlapi.io.RDFOntologyFormat;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLAnnotation;
import org.semanticweb.owlapi.model.OWLAnnotationAssertionAxiom;
import org.semanticweb.owlapi.model.OWLAnnotationProperty;
import org.semanticweb.owlapi.model.OWLAnnotationPropertyDomainAxiom;
import org.semanticweb.owlapi.model.OWLAnnotationPropertyRangeAxiom;
import org.semanticweb.owlapi.model.OWLAnnotationSubject;
import org.semanticweb.owlapi.model.OWLAnonymousIndividual;
import org.semanticweb.owlapi.model.OWLAsymmetricObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLCardinalityRestriction;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLClassAssertionAxiom;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLDataAllValuesFrom;
import org.semanticweb.owlapi.model.OWLDataComplementOf;
import org.semanticweb.owlapi.model.OWLDataExactCardinality;
import org.semanticweb.owlapi.model.OWLDataHasValue;
import org.semanticweb.owlapi.model.OWLDataIntersectionOf;
import org.semanticweb.owlapi.model.OWLDataMaxCardinality;
import org.semanticweb.owlapi.model.OWLDataMinCardinality;
import org.semanticweb.owlapi.model.OWLDataOneOf;
import org.semanticweb.owlapi.model.OWLDataProperty;
import org.semanticweb.owlapi.model.OWLDataPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLDataPropertyDomainAxiom;
import org.semanticweb.owlapi.model.OWLDataPropertyExpression;
import org.semanticweb.owlapi.model.OWLDataPropertyRangeAxiom;
import org.semanticweb.owlapi.model.OWLDataRange;
import org.semanticweb.owlapi.model.OWLDataSomeValuesFrom;
import org.semanticweb.owlapi.model.OWLDataUnionOf;
import org.semanticweb.owlapi.model.OWLDatatype;
import org.semanticweb.owlapi.model.OWLDatatypeDefinitionAxiom;
import org.semanticweb.owlapi.model.OWLDatatypeRestriction;
import org.semanticweb.owlapi.model.OWLDeclarationAxiom;
import org.semanticweb.owlapi.model.OWLDifferentIndividualsAxiom;
import org.semanticweb.owlapi.model.OWLDisjointClassesAxiom;
import org.semanticweb.owlapi.model.OWLDisjointDataPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLDisjointObjectPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLDisjointUnionAxiom;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLEntityVisitorEx;
import org.semanticweb.owlapi.model.OWLEquivalentClassesAxiom;
import org.semanticweb.owlapi.model.OWLEquivalentDataPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLEquivalentObjectPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLFacetRestriction;
import org.semanticweb.owlapi.model.OWLFunctionalDataPropertyAxiom;
import org.semanticweb.owlapi.model.OWLFunctionalObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLHasKeyAxiom;
import org.semanticweb.owlapi.model.OWLIndividual;
import org.semanticweb.owlapi.model.OWLInverseFunctionalObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLInverseObjectPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLIrreflexiveObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLLiteral;
import org.semanticweb.owlapi.model.OWLNamedIndividual;
import org.semanticweb.owlapi.model.OWLNegativeDataPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLNegativeObjectPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLObject;
import org.semanticweb.owlapi.model.OWLObjectAllValuesFrom;
import org.semanticweb.owlapi.model.OWLObjectComplementOf;
import org.semanticweb.owlapi.model.OWLObjectExactCardinality;
import org.semanticweb.owlapi.model.OWLObjectHasSelf;
import org.semanticweb.owlapi.model.OWLObjectHasValue;
import org.semanticweb.owlapi.model.OWLObjectIntersectionOf;
import org.semanticweb.owlapi.model.OWLObjectInverseOf;
import org.semanticweb.owlapi.model.OWLObjectMaxCardinality;
import org.semanticweb.owlapi.model.OWLObjectMinCardinality;
import org.semanticweb.owlapi.model.OWLObjectOneOf;
import org.semanticweb.owlapi.model.OWLObjectProperty;
import org.semanticweb.owlapi.model.OWLObjectPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLObjectPropertyDomainAxiom;
import org.semanticweb.owlapi.model.OWLObjectPropertyExpression;
import org.semanticweb.owlapi.model.OWLObjectPropertyRangeAxiom;
import org.semanticweb.owlapi.model.OWLObjectSomeValuesFrom;
import org.semanticweb.owlapi.model.OWLObjectUnionOf;
import org.semanticweb.owlapi.model.OWLObjectVisitor;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyManager;
import org.semanticweb.owlapi.model.OWLPropertyExpression;
import org.semanticweb.owlapi.model.OWLPropertyRange;
import org.semanticweb.owlapi.model.OWLReflexiveObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLRestriction;
import org.semanticweb.owlapi.model.OWLRuntimeException;
import org.semanticweb.owlapi.model.OWLSameIndividualAxiom;
import org.semanticweb.owlapi.model.OWLSubAnnotationPropertyOfAxiom;
import org.semanticweb.owlapi.model.OWLSubClassOfAxiom;
import org.semanticweb.owlapi.model.OWLSubDataPropertyOfAxiom;
import org.semanticweb.owlapi.model.OWLSubObjectPropertyOfAxiom;
import org.semanticweb.owlapi.model.OWLSubPropertyChainOfAxiom;
import org.semanticweb.owlapi.model.OWLSymmetricObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLTransitiveObjectPropertyAxiom;
import org.semanticweb.owlapi.model.SWRLBuiltInAtom;
import org.semanticweb.owlapi.model.SWRLClassAtom;
import org.semanticweb.owlapi.model.SWRLDArgument;
import org.semanticweb.owlapi.model.SWRLDataPropertyAtom;
import org.semanticweb.owlapi.model.SWRLDataRangeAtom;
import org.semanticweb.owlapi.model.SWRLDifferentIndividualsAtom;
import org.semanticweb.owlapi.model.SWRLIArgument;
import org.semanticweb.owlapi.model.SWRLIndividualArgument;
import org.semanticweb.owlapi.model.SWRLLiteralArgument;
import org.semanticweb.owlapi.model.SWRLObjectPropertyAtom;
import org.semanticweb.owlapi.model.SWRLObjectVisitor;
import org.semanticweb.owlapi.model.SWRLRule;
import org.semanticweb.owlapi.model.SWRLSameIndividualAtom;
import org.semanticweb.owlapi.model.SWRLVariable;
import org.semanticweb.owlapi.vocab.OWLRDFVocabulary;
import org.semanticweb.owlapi.vocab.SWRLVocabulary;
import org.semanticweb.owlapi.vocab.XSDVocabulary;

public abstract class AbstractTranslator<NODE, RESOURCE extends NODE, PREDICATE extends NODE, LITERAL extends NODE>
implements OWLObjectVisitor,
SWRLObjectVisitor {
    private OWLOntologyManager manager;
    private OWLOntology ontology;
    private boolean useStrongTyping = true;
    private Map<OWLObject, NODE> nodeMap = new IdentityHashMap<OWLObject, NODE>();
    private Set<OWLIndividual> currentIndividuals = new HashSet<OWLIndividual>();

    public AbstractTranslator(OWLOntologyManager manager, OWLOntology ontology, boolean useStrongTyping) {
        this.ontology = ontology;
        this.manager = manager;
        this.useStrongTyping = useStrongTyping;
    }

    public void visit(OWLDeclarationAxiom axiom) {
        this.addSingleTripleAxiom((OWLAxiom)axiom, (OWLObject)axiom.getEntity(), OWLRDFVocabulary.RDF_TYPE.getIRI(), (IRI)axiom.getEntity().accept((OWLEntityVisitorEx)OWLEntityTypeProvider.INSTANCE));
    }

    public void visit(OWLObjectInverseOf property) {
        this.translateAnonymousNode((OWLObject)property);
        this.addTriple((OWLObject)property, OWLRDFVocabulary.OWL_INVERSE_OF.getIRI(), (OWLObject)property.getInverse());
    }

    public void visit(OWLDataIntersectionOf node) {
        this.translateAnonymousNode((OWLObject)node);
        this.addTriple((OWLObject)node, OWLRDFVocabulary.RDF_TYPE.getIRI(), OWLRDFVocabulary.RDFS_DATATYPE.getIRI());
        this.addListTriples((OWLObject)node, OWLRDFVocabulary.OWL_INTERSECTION_OF.getIRI(), node.getOperands());
    }

    public void visit(OWLDataUnionOf node) {
        this.translateAnonymousNode((OWLObject)node);
        this.addTriple((OWLObject)node, OWLRDFVocabulary.RDF_TYPE.getIRI(), OWLRDFVocabulary.RDFS_DATATYPE.getIRI());
        this.addListTriples((OWLObject)node, OWLRDFVocabulary.OWL_UNION_OF.getIRI(), node.getOperands());
    }

    public void visit(OWLDataComplementOf node) {
        this.translateAnonymousNode((OWLObject)node);
        this.addTriple((OWLObject)node, OWLRDFVocabulary.RDF_TYPE.getIRI(), OWLRDFVocabulary.RDFS_DATATYPE.getIRI());
        this.addTriple((OWLObject)node, OWLRDFVocabulary.OWL_DATATYPE_COMPLEMENT_OF.getIRI(), (OWLObject)node.getDataRange());
    }

    public void visit(OWLDataOneOf node) {
        this.translateAnonymousNode((OWLObject)node);
        this.addTriple((OWLObject)node, OWLRDFVocabulary.RDF_TYPE.getIRI(), OWLRDFVocabulary.RDFS_DATATYPE.getIRI());
        this.addListTriples((OWLObject)node, OWLRDFVocabulary.OWL_ONE_OF.getIRI(), node.getValues());
    }

    public void visit(OWLDatatypeRestriction node) {
        this.translateAnonymousNode((OWLObject)node);
        this.addTriple((OWLObject)node, OWLRDFVocabulary.RDF_TYPE.getIRI(), OWLRDFVocabulary.RDFS_DATATYPE.getIRI());
        this.addTriple((OWLObject)node, OWLRDFVocabulary.OWL_ON_DATA_TYPE.getIRI(), (OWLObject)node.getDatatype());
        this.addListTriples((OWLObject)node, OWLRDFVocabulary.OWL_WITH_RESTRICTIONS.getIRI(), node.getFacetRestrictions());
    }

    public void visit(OWLObjectIntersectionOf desc) {
        this.translateAnonymousNode((OWLObject)desc);
        this.addListTriples((OWLObject)desc, OWLRDFVocabulary.OWL_INTERSECTION_OF.getIRI(), desc.getOperands());
        this.addTriple((OWLObject)desc, OWLRDFVocabulary.RDF_TYPE.getIRI(), OWLRDFVocabulary.OWL_CLASS.getIRI());
    }

    public void visit(OWLObjectUnionOf desc) {
        this.translateAnonymousNode((OWLObject)desc);
        this.addTriple((OWLObject)desc, OWLRDFVocabulary.RDF_TYPE.getIRI(), OWLRDFVocabulary.OWL_CLASS.getIRI());
        this.addListTriples((OWLObject)desc, OWLRDFVocabulary.OWL_UNION_OF.getIRI(), desc.getOperands());
    }

    public void visit(OWLObjectComplementOf desc) {
        this.translateAnonymousNode((OWLObject)desc);
        this.addTriple((OWLObject)desc, OWLRDFVocabulary.RDF_TYPE.getIRI(), OWLRDFVocabulary.OWL_CLASS.getIRI());
        this.addTriple((OWLObject)desc, OWLRDFVocabulary.OWL_COMPLEMENT_OF.getIRI(), (OWLObject)desc.getOperand());
    }

    public void visit(OWLObjectOneOf desc) {
        this.translateAnonymousNode((OWLObject)desc);
        this.addTriple((OWLObject)desc, OWLRDFVocabulary.RDF_TYPE.getIRI(), OWLRDFVocabulary.OWL_CLASS.getIRI());
        this.addListTriples((OWLObject)desc, OWLRDFVocabulary.OWL_ONE_OF.getIRI(), desc.getIndividuals());
        this.processIfAnonymous(desc.getIndividuals(), null);
    }

    private <R extends OWLPropertyRange, P extends OWLPropertyExpression<R, P>, F extends OWLPropertyRange> void addRestrictionCommonTriplePropertyRange(OWLRestriction<R, P, F> desc) {
        this.translateAnonymousNode((OWLObject)desc);
        this.addTriple((OWLObject)desc, OWLRDFVocabulary.RDF_TYPE.getIRI(), OWLRDFVocabulary.OWL_RESTRICTION.getIRI());
        this.addTriple((OWLObject)desc, OWLRDFVocabulary.OWL_ON_PROPERTY.getIRI(), (OWLObject)desc.getProperty());
    }

    private <R extends OWLPropertyRange, P extends OWLPropertyExpression<R, P>, F extends OWLPropertyExpression<R, P>> void addRestrictionCommonTriplePropertyExpression(OWLRestriction<R, P, F> desc) {
        this.translateAnonymousNode((OWLObject)desc);
        this.addTriple((OWLObject)desc, OWLRDFVocabulary.RDF_TYPE.getIRI(), OWLRDFVocabulary.OWL_RESTRICTION.getIRI());
        this.addTriple((OWLObject)desc, OWLRDFVocabulary.OWL_ON_PROPERTY.getIRI(), (OWLObject)desc.getProperty());
    }

    private void addObjectCardinalityRestrictionTriples(OWLCardinalityRestriction<OWLClassExpression, OWLObjectPropertyExpression, OWLClassExpression> ce, OWLRDFVocabulary cardiPredicate) {
        this.addRestrictionCommonTriplePropertyRange((OWLRestriction)ce);
        this.addTriple((OWLObject)ce, cardiPredicate.getIRI(), (OWLObject)this.toTypedConstant(ce.getCardinality()));
        if (ce.isQualified()) {
            if (ce.isObjectRestriction()) {
                this.addTriple((OWLObject)ce, OWLRDFVocabulary.OWL_ON_CLASS.getIRI(), (OWLObject)ce.getFiller());
            } else {
                this.addTriple((OWLObject)ce, OWLRDFVocabulary.OWL_ON_DATA_RANGE.getIRI(), (OWLObject)ce.getFiller());
            }
        }
    }

    private void addDataCardinalityRestrictionTriples(OWLCardinalityRestriction<OWLDataRange, OWLDataPropertyExpression, OWLDataRange> ce, OWLRDFVocabulary cardiPredicate) {
        this.addRestrictionCommonTriplePropertyRange((OWLRestriction)ce);
        this.addTriple((OWLObject)ce, cardiPredicate.getIRI(), (OWLObject)this.toTypedConstant(ce.getCardinality()));
        if (ce.isQualified()) {
            if (ce.isObjectRestriction()) {
                this.addTriple((OWLObject)ce, OWLRDFVocabulary.OWL_ON_CLASS.getIRI(), (OWLObject)ce.getFiller());
            } else {
                this.addTriple((OWLObject)ce, OWLRDFVocabulary.OWL_ON_DATA_RANGE.getIRI(), (OWLObject)ce.getFiller());
            }
        }
    }

    public void visit(OWLObjectSomeValuesFrom desc) {
        this.addRestrictionCommonTriplePropertyRange((OWLRestriction)desc);
        this.addTriple((OWLObject)desc, OWLRDFVocabulary.OWL_SOME_VALUES_FROM.getIRI(), (OWLObject)desc.getFiller());
    }

    public void visit(OWLObjectAllValuesFrom desc) {
        this.addRestrictionCommonTriplePropertyRange((OWLRestriction)desc);
        this.addTriple((OWLObject)desc, OWLRDFVocabulary.OWL_ALL_VALUES_FROM.getIRI(), (OWLObject)desc.getFiller());
    }

    public void visit(OWLObjectHasValue desc) {
        this.addRestrictionCommonTriplePropertyExpression((OWLRestriction)desc);
        this.addTriple((OWLObject)desc, OWLRDFVocabulary.OWL_HAS_VALUE.getIRI(), desc.getValue());
        this.processIfAnonymous((OWLIndividual)desc.getValue(), null);
    }

    public void visit(OWLObjectHasSelf desc) {
        this.translateAnonymousNode((OWLObject)desc);
        this.addTriple((OWLObject)desc, OWLRDFVocabulary.RDF_TYPE.getIRI(), OWLRDFVocabulary.OWL_RESTRICTION.getIRI());
        this.addTriple((OWLObject)desc, OWLRDFVocabulary.OWL_ON_PROPERTY.getIRI(), (OWLObject)desc.getProperty());
        this.addTriple((OWLObject)desc, OWLRDFVocabulary.OWL_HAS_SELF.getIRI(), (OWLObject)this.manager.getOWLDataFactory().getOWLLiteral(true));
    }

    public void visit(OWLObjectMinCardinality desc) {
        if (desc.isQualified()) {
            this.addObjectCardinalityRestrictionTriples((OWLCardinalityRestriction<OWLClassExpression, OWLObjectPropertyExpression, OWLClassExpression>)desc, OWLRDFVocabulary.OWL_MIN_QUALIFIED_CARDINALITY);
        } else {
            this.addObjectCardinalityRestrictionTriples((OWLCardinalityRestriction<OWLClassExpression, OWLObjectPropertyExpression, OWLClassExpression>)desc, OWLRDFVocabulary.OWL_MIN_CARDINALITY);
        }
    }

    public void visit(OWLObjectMaxCardinality desc) {
        if (desc.isQualified()) {
            this.addObjectCardinalityRestrictionTriples((OWLCardinalityRestriction<OWLClassExpression, OWLObjectPropertyExpression, OWLClassExpression>)desc, OWLRDFVocabulary.OWL_MAX_QUALIFIED_CARDINALITY);
        } else {
            this.addObjectCardinalityRestrictionTriples((OWLCardinalityRestriction<OWLClassExpression, OWLObjectPropertyExpression, OWLClassExpression>)desc, OWLRDFVocabulary.OWL_MAX_CARDINALITY);
        }
    }

    public void visit(OWLObjectExactCardinality desc) {
        if (desc.isQualified()) {
            this.addObjectCardinalityRestrictionTriples((OWLCardinalityRestriction<OWLClassExpression, OWLObjectPropertyExpression, OWLClassExpression>)desc, OWLRDFVocabulary.OWL_QUALIFIED_CARDINALITY);
        } else {
            this.addObjectCardinalityRestrictionTriples((OWLCardinalityRestriction<OWLClassExpression, OWLObjectPropertyExpression, OWLClassExpression>)desc, OWLRDFVocabulary.OWL_CARDINALITY);
        }
    }

    public void visit(OWLDataSomeValuesFrom desc) {
        this.addRestrictionCommonTriplePropertyRange((OWLRestriction)desc);
        this.addTriple((OWLObject)desc, OWLRDFVocabulary.OWL_SOME_VALUES_FROM.getIRI(), (OWLObject)desc.getFiller());
    }

    public void visit(OWLDataAllValuesFrom desc) {
        this.addRestrictionCommonTriplePropertyRange((OWLRestriction)desc);
        this.addTriple((OWLObject)desc, OWLRDFVocabulary.OWL_ALL_VALUES_FROM.getIRI(), (OWLObject)desc.getFiller());
    }

    public void visit(OWLDataHasValue desc) {
        this.addRestrictionCommonTriplePropertyExpression((OWLRestriction)desc);
        this.addTriple((OWLObject)desc, OWLRDFVocabulary.OWL_HAS_VALUE.getIRI(), desc.getValue());
    }

    public void visit(OWLDataMinCardinality desc) {
        if (desc.isQualified()) {
            this.addDataCardinalityRestrictionTriples((OWLCardinalityRestriction<OWLDataRange, OWLDataPropertyExpression, OWLDataRange>)desc, OWLRDFVocabulary.OWL_MIN_QUALIFIED_CARDINALITY);
        } else {
            this.addDataCardinalityRestrictionTriples((OWLCardinalityRestriction<OWLDataRange, OWLDataPropertyExpression, OWLDataRange>)desc, OWLRDFVocabulary.OWL_MIN_CARDINALITY);
        }
    }

    public void visit(OWLDataMaxCardinality desc) {
        if (desc.isQualified()) {
            this.addDataCardinalityRestrictionTriples((OWLCardinalityRestriction<OWLDataRange, OWLDataPropertyExpression, OWLDataRange>)desc, OWLRDFVocabulary.OWL_MAX_QUALIFIED_CARDINALITY);
        } else {
            this.addDataCardinalityRestrictionTriples((OWLCardinalityRestriction<OWLDataRange, OWLDataPropertyExpression, OWLDataRange>)desc, OWLRDFVocabulary.OWL_MAX_CARDINALITY);
        }
    }

    public void visit(OWLDataExactCardinality desc) {
        if (desc.isQualified()) {
            this.addDataCardinalityRestrictionTriples((OWLCardinalityRestriction<OWLDataRange, OWLDataPropertyExpression, OWLDataRange>)desc, OWLRDFVocabulary.OWL_QUALIFIED_CARDINALITY);
        } else {
            this.addDataCardinalityRestrictionTriples((OWLCardinalityRestriction<OWLDataRange, OWLDataPropertyExpression, OWLDataRange>)desc, OWLRDFVocabulary.OWL_CARDINALITY);
        }
    }

    public void visit(OWLSubClassOfAxiom axiom) {
        this.addSingleTripleAxiom((OWLAxiom)axiom, (OWLObject)axiom.getSubClass(), OWLRDFVocabulary.RDFS_SUBCLASS_OF.getIRI(), (OWLObject)axiom.getSuperClass());
    }

    public void visit(OWLEquivalentClassesAxiom axiom) {
        if (axiom.getClassExpressions().size() == 2) {
            this.addPairwiseClassExpressions((OWLAxiom)axiom, axiom.getClassExpressions(), OWLRDFVocabulary.OWL_EQUIVALENT_CLASS.getIRI());
        } else {
            List list = axiom.getClassExpressionsAsList();
            int count = list.size();
            int i = 0;
            while (i + 1 < count) {
                this.addTriple((OWLObject)list.get(i), OWLRDFVocabulary.OWL_EQUIVALENT_CLASS.getIRI(), (OWLObject)list.get(i + 1));
                ++i;
            }
        }
    }

    public void visit(OWLDisjointClassesAxiom axiom) {
        if (axiom.getClassExpressions().size() == 2) {
            this.addPairwiseClassExpressions((OWLAxiom)axiom, axiom.getClassExpressions(), OWLRDFVocabulary.OWL_DISJOINT_WITH.getIRI());
        } else {
            this.translateAnonymousNode((OWLObject)axiom);
            this.addTriple((OWLObject)axiom, OWLRDFVocabulary.RDF_TYPE.getIRI(), OWLRDFVocabulary.OWL_ALL_DISJOINT_CLASSES.getIRI());
            this.addListTriples((OWLObject)axiom, OWLRDFVocabulary.OWL_MEMBERS.getIRI(), axiom.getClassExpressions());
            this.translateAnnotations((OWLAxiom)axiom);
        }
    }

    public void visit(OWLDisjointUnionAxiom axiom) {
        this.addSingleTripleAxiom((OWLAxiom)axiom, axiom.getOWLClass(), OWLRDFVocabulary.OWL_DISJOINT_UNION_OF.getIRI(), axiom.getClassExpressions());
    }

    public void visit(OWLSubObjectPropertyOfAxiom axiom) {
        this.addSingleTripleAxiom((OWLAxiom)axiom, (OWLObject)axiom.getSubProperty(), OWLRDFVocabulary.RDFS_SUB_PROPERTY_OF.getIRI(), (OWLObject)axiom.getSuperProperty());
    }

    public void visit(OWLSubPropertyChainOfAxiom axiom) {
        this.addSingleTripleAxiom((OWLAxiom)axiom, axiom.getSuperProperty(), OWLRDFVocabulary.OWL_PROPERTY_CHAIN_AXIOM.getIRI(), axiom.getPropertyChain());
    }

    public void visit(OWLEquivalentObjectPropertiesAxiom axiom) {
        this.addPairwise((OWLAxiom)axiom, axiom.getProperties(), OWLRDFVocabulary.OWL_EQUIVALENT_PROPERTY.getIRI());
    }

    public void visit(OWLDisjointObjectPropertiesAxiom axiom) {
        if (axiom.getProperties().size() == 2) {
            this.addPairwise((OWLAxiom)axiom, axiom.getProperties(), OWLRDFVocabulary.OWL_PROPERTY_DISJOINT_WITH.getIRI());
        } else {
            this.translateAnonymousNode((OWLObject)axiom);
            this.translateAnnotations((OWLAxiom)axiom);
            this.addTriple((OWLObject)axiom, OWLRDFVocabulary.RDF_TYPE.getIRI(), OWLRDFVocabulary.OWL_ALL_DISJOINT_PROPERTIES.getIRI());
            this.addListTriples((OWLObject)axiom, OWLRDFVocabulary.OWL_MEMBERS.getIRI(), axiom.getProperties());
        }
    }

    public void visit(OWLObjectPropertyDomainAxiom axiom) {
        this.addSingleTripleAxiom((OWLAxiom)axiom, (OWLObject)axiom.getProperty(), OWLRDFVocabulary.RDFS_DOMAIN.getIRI(), (OWLObject)axiom.getDomain());
    }

    public void visit(OWLObjectPropertyRangeAxiom axiom) {
        this.addSingleTripleAxiom((OWLAxiom)axiom, (OWLObject)axiom.getProperty(), OWLRDFVocabulary.RDFS_RANGE.getIRI(), (OWLObject)axiom.getRange());
    }

    public void visit(OWLInverseObjectPropertiesAxiom axiom) {
        this.addSingleTripleAxiom((OWLAxiom)axiom, (OWLObject)axiom.getFirstProperty(), OWLRDFVocabulary.OWL_INVERSE_OF.getIRI(), (OWLObject)axiom.getSecondProperty());
    }

    public void visit(OWLFunctionalObjectPropertyAxiom axiom) {
        this.addSingleTripleAxiom((OWLAxiom)axiom, (OWLObject)axiom.getProperty(), OWLRDFVocabulary.RDF_TYPE.getIRI(), OWLRDFVocabulary.OWL_FUNCTIONAL_PROPERTY.getIRI());
    }

    public void visit(OWLInverseFunctionalObjectPropertyAxiom axiom) {
        this.addSingleTripleAxiom((OWLAxiom)axiom, (OWLObject)axiom.getProperty(), OWLRDFVocabulary.RDF_TYPE.getIRI(), OWLRDFVocabulary.OWL_INVERSE_FUNCTIONAL_PROPERTY.getIRI());
    }

    public void visit(OWLReflexiveObjectPropertyAxiom axiom) {
        this.addSingleTripleAxiom((OWLAxiom)axiom, (OWLObject)axiom.getProperty(), OWLRDFVocabulary.RDF_TYPE.getIRI(), OWLRDFVocabulary.OWL_REFLEXIVE_PROPERTY.getIRI());
    }

    public void visit(OWLIrreflexiveObjectPropertyAxiom axiom) {
        this.addSingleTripleAxiom((OWLAxiom)axiom, (OWLObject)axiom.getProperty(), OWLRDFVocabulary.RDF_TYPE.getIRI(), OWLRDFVocabulary.OWL_IRREFLEXIVE_PROPERTY.getIRI());
    }

    public void visit(OWLSymmetricObjectPropertyAxiom axiom) {
        this.addSingleTripleAxiom((OWLAxiom)axiom, (OWLObject)axiom.getProperty(), OWLRDFVocabulary.RDF_TYPE.getIRI(), OWLRDFVocabulary.OWL_SYMMETRIC_PROPERTY.getIRI());
    }

    public void visit(OWLAsymmetricObjectPropertyAxiom axiom) {
        this.addSingleTripleAxiom((OWLAxiom)axiom, (OWLObject)axiom.getProperty(), OWLRDFVocabulary.RDF_TYPE.getIRI(), OWLRDFVocabulary.OWL_ASYMMETRIC_PROPERTY.getIRI());
    }

    public void visit(OWLTransitiveObjectPropertyAxiom axiom) {
        this.addSingleTripleAxiom((OWLAxiom)axiom, (OWLObject)axiom.getProperty(), OWLRDFVocabulary.RDF_TYPE.getIRI(), OWLRDFVocabulary.OWL_TRANSITIVE_PROPERTY.getIRI());
    }

    public void visit(OWLSubDataPropertyOfAxiom axiom) {
        this.addSingleTripleAxiom((OWLAxiom)axiom, (OWLObject)axiom.getSubProperty(), OWLRDFVocabulary.RDFS_SUB_PROPERTY_OF.getIRI(), (OWLObject)axiom.getSuperProperty());
    }

    public void visit(OWLEquivalentDataPropertiesAxiom axiom) {
        this.addPairwise((OWLAxiom)axiom, axiom.getProperties(), OWLRDFVocabulary.OWL_EQUIVALENT_PROPERTY.getIRI());
    }

    public void visit(OWLDisjointDataPropertiesAxiom axiom) {
        if (axiom.getProperties().size() == 2) {
            this.addPairwise((OWLAxiom)axiom, axiom.getProperties(), OWLRDFVocabulary.OWL_PROPERTY_DISJOINT_WITH.getIRI());
        } else {
            this.translateAnonymousNode((OWLObject)axiom);
            this.translateAnnotations((OWLAxiom)axiom);
            this.addTriple((OWLObject)axiom, OWLRDFVocabulary.RDF_TYPE.getIRI(), OWLRDFVocabulary.OWL_ALL_DISJOINT_PROPERTIES.getIRI());
            this.addListTriples((OWLObject)axiom, OWLRDFVocabulary.OWL_MEMBERS.getIRI(), axiom.getProperties());
        }
    }

    public void visit(OWLDataPropertyDomainAxiom axiom) {
        this.addSingleTripleAxiom((OWLAxiom)axiom, (OWLObject)axiom.getProperty(), OWLRDFVocabulary.RDFS_DOMAIN.getIRI(), (OWLObject)axiom.getDomain());
    }

    public void visit(OWLDataPropertyRangeAxiom axiom) {
        this.addSingleTripleAxiom((OWLAxiom)axiom, (OWLObject)axiom.getProperty(), OWLRDFVocabulary.RDFS_RANGE.getIRI(), (OWLObject)axiom.getRange());
    }

    public void visit(OWLFunctionalDataPropertyAxiom axiom) {
        this.addSingleTripleAxiom((OWLAxiom)axiom, (OWLObject)axiom.getProperty(), OWLRDFVocabulary.RDF_TYPE.getIRI(), OWLRDFVocabulary.OWL_FUNCTIONAL_PROPERTY.getIRI());
    }

    public void visit(OWLDatatypeDefinitionAxiom axiom) {
        this.addSingleTripleAxiom((OWLAxiom)axiom, (OWLObject)axiom.getDatatype(), OWLRDFVocabulary.OWL_EQUIVALENT_CLASS.getIRI(), (OWLObject)axiom.getDataRange());
    }

    public void visit(OWLHasKeyAxiom axiom) {
        this.addSingleTripleAxiom((OWLAxiom)axiom, axiom.getClassExpression(), OWLRDFVocabulary.OWL_HAS_KEY.getIRI(), axiom.getPropertyExpressions());
    }

    public void visit(OWLSameIndividualAxiom axiom) {
        this.addPairwise((OWLAxiom)axiom, axiom.getIndividuals(), OWLRDFVocabulary.OWL_SAME_AS.getIRI());
        this.processIfAnonymous(axiom.getIndividuals(), (OWLAxiom)axiom);
    }

    public void visit(OWLDifferentIndividualsAxiom axiom) {
        this.translateAnonymousNode((OWLObject)axiom);
        this.addTriple((OWLObject)axiom, OWLRDFVocabulary.RDF_TYPE.getIRI(), OWLRDFVocabulary.OWL_ALL_DIFFERENT.getIRI());
        this.addListTriples((OWLObject)axiom, OWLRDFVocabulary.OWL_DISTINCT_MEMBERS.getIRI(), axiom.getIndividuals());
        this.processIfAnonymous(axiom.getIndividuals(), (OWLAxiom)axiom);
    }

    public void visit(OWLClassAssertionAxiom axiom) {
        axiom.getIndividual().accept((OWLObjectVisitor)this);
        this.addSingleTripleAxiom((OWLAxiom)axiom, (OWLObject)axiom.getIndividual(), OWLRDFVocabulary.RDF_TYPE.getIRI(), (OWLObject)axiom.getClassExpression());
        this.processIfAnonymous(axiom.getIndividual(), (OWLAxiom)axiom);
    }

    public void visit(OWLObjectPropertyAssertionAxiom axiom) {
        OWLObjectPropertyAssertionAxiom simplified = axiom.getSimplified();
        this.addSingleTripleAxiom((OWLAxiom)simplified, (OWLObject)simplified.getSubject(), (OWLObject)simplified.getProperty(), (OWLObject)simplified.getObject());
        this.processIfAnonymous((OWLIndividual)simplified.getObject(), (OWLAxiom)axiom);
        this.processIfAnonymous(simplified.getSubject(), (OWLAxiom)axiom);
    }

    public void visit(OWLNegativeObjectPropertyAssertionAxiom axiom) {
        this.translateAnonymousNode((OWLObject)axiom);
        this.addTriple((OWLObject)axiom, OWLRDFVocabulary.RDF_TYPE.getIRI(), OWLRDFVocabulary.OWL_NEGATIVE_PROPERTY_ASSERTION.getIRI());
        this.addTriple((OWLObject)axiom, OWLRDFVocabulary.OWL_SOURCE_INDIVIDUAL.getIRI(), (OWLObject)axiom.getSubject());
        this.addTriple((OWLObject)axiom, OWLRDFVocabulary.OWL_ASSERTION_PROPERTY.getIRI(), (OWLObject)axiom.getProperty());
        this.addTriple((OWLObject)axiom, OWLRDFVocabulary.OWL_TARGET_INDIVIDUAL.getIRI(), (OWLObject)axiom.getObject());
        this.translateAnnotations((OWLAxiom)axiom);
        this.processIfAnonymous(axiom.getSubject(), (OWLAxiom)axiom);
        this.processIfAnonymous((OWLIndividual)axiom.getObject(), (OWLAxiom)axiom);
    }

    public void visit(OWLDataPropertyAssertionAxiom axiom) {
        this.addSingleTripleAxiom((OWLAxiom)axiom, (OWLObject)axiom.getSubject(), (OWLObject)axiom.getProperty(), (OWLObject)axiom.getObject());
    }

    public void visit(OWLNegativeDataPropertyAssertionAxiom axiom) {
        this.translateAnonymousNode((OWLObject)axiom);
        for (OWLAnnotation anno : axiom.getAnnotations()) {
            this.addTriple((OWLObject)axiom, anno.getProperty().getIRI(), (OWLObject)anno.getValue());
        }
        this.addTriple((OWLObject)axiom, OWLRDFVocabulary.RDF_TYPE.getIRI(), OWLRDFVocabulary.OWL_NEGATIVE_PROPERTY_ASSERTION.getIRI());
        this.addTriple((OWLObject)axiom, OWLRDFVocabulary.OWL_SOURCE_INDIVIDUAL.getIRI(), (OWLObject)axiom.getSubject());
        this.addTriple((OWLObject)axiom, OWLRDFVocabulary.OWL_ASSERTION_PROPERTY.getIRI(), (OWLObject)axiom.getProperty());
        this.addTriple((OWLObject)axiom, OWLRDFVocabulary.OWL_TARGET_VALUE.getIRI(), (OWLObject)axiom.getObject());
        this.processIfAnonymous(axiom.getSubject(), (OWLAxiom)axiom);
    }

    public void visit(OWLAnnotationAssertionAxiom axiom) {
        this.addSingleTripleAxiom((OWLAxiom)axiom, (OWLObject)axiom.getSubject(), (OWLObject)axiom.getProperty(), (OWLObject)axiom.getValue());
        if (axiom.getValue() instanceof OWLAnonymousIndividual) {
            this.processIfAnonymous((OWLIndividual)((OWLAnonymousIndividual)axiom.getValue()), (OWLAxiom)axiom);
        }
    }

    public void visit(OWLSubAnnotationPropertyOfAxiom axiom) {
        this.addSingleTripleAxiom((OWLAxiom)axiom, (OWLObject)axiom.getSubProperty(), OWLRDFVocabulary.RDFS_SUB_PROPERTY_OF.getIRI(), (OWLObject)axiom.getSuperProperty());
    }

    public void visit(OWLAnnotationPropertyDomainAxiom axiom) {
        this.addSingleTripleAxiom((OWLAxiom)axiom, (OWLObject)axiom.getProperty(), OWLRDFVocabulary.RDFS_DOMAIN.getIRI(), axiom.getDomain());
    }

    public void visit(OWLAnnotationPropertyRangeAxiom axiom) {
        this.addSingleTripleAxiom((OWLAxiom)axiom, (OWLObject)axiom.getProperty(), OWLRDFVocabulary.RDFS_RANGE.getIRI(), axiom.getRange());
    }

    public void visit(OWLClass desc) {
        if (!this.nodeMap.containsKey(desc)) {
            this.nodeMap.put((OWLObject)desc, this.getResourceNode(desc.getIRI()));
        }
        this.addStrongTyping((OWLEntity)desc);
    }

    public void visit(OWLDatatype node) {
        if (!this.nodeMap.containsKey(node)) {
            this.nodeMap.put((OWLObject)node, this.getResourceNode(node.getIRI()));
        }
        this.addStrongTyping((OWLEntity)node);
    }

    public void visit(OWLFacetRestriction node) {
        this.translateAnonymousNode((OWLObject)node);
        this.addTriple((OWLObject)node, node.getFacet().getIRI(), (OWLObject)node.getFacetValue());
    }

    public void visit(IRI iri) {
        if (!this.nodeMap.containsKey(iri)) {
            this.nodeMap.put((OWLObject)iri, this.getResourceNode(iri));
        }
    }

    public void visit(OWLLiteral node) {
        this.nodeMap.put((OWLObject)node, this.getLiteralNode(node));
    }

    public void visit(OWLDataProperty property) {
        if (!this.nodeMap.containsKey(property)) {
            this.nodeMap.put((OWLObject)property, this.getPredicateNode(property.getIRI()));
        }
        this.addStrongTyping((OWLEntity)property);
    }

    public void visit(OWLObjectProperty property) {
        if (!this.nodeMap.containsKey(property)) {
            this.nodeMap.put((OWLObject)property, this.getPredicateNode(property.getIRI()));
        }
        this.addStrongTyping((OWLEntity)property);
    }

    public void visit(OWLAnnotationProperty property) {
        if (!this.nodeMap.containsKey(property)) {
            this.nodeMap.put((OWLObject)property, this.getPredicateNode(property.getIRI()));
        }
        this.addStrongTyping((OWLEntity)property);
    }

    public void visit(OWLNamedIndividual individual) {
        if (!this.nodeMap.containsKey(individual)) {
            this.nodeMap.put((OWLObject)individual, this.getResourceNode(individual.getIRI()));
        }
        this.addStrongTyping((OWLEntity)individual);
    }

    public void visit(OWLAnonymousIndividual individual) {
        this.translateAnonymousNode((OWLObject)individual);
    }

    public void visit(OWLOntology ontologyToVisit) {
        if (ontologyToVisit.isAnonymous()) {
            this.translateAnonymousNode((OWLObject)ontologyToVisit);
        } else if (!this.nodeMap.containsKey(ontologyToVisit)) {
            this.nodeMap.put((OWLObject)ontologyToVisit, this.getResourceNode(ontologyToVisit.getOntologyID().getOntologyIRI()));
        }
        this.addTriple((OWLObject)ontologyToVisit, OWLRDFVocabulary.RDF_TYPE.getIRI(), OWLRDFVocabulary.OWL_ONTOLOGY.getIRI());
    }

    public void visit(SWRLRule rule) {
        this.translateAnonymousNode((OWLObject)rule);
        this.translateAnnotations((OWLAxiom)rule);
        this.addTriple((OWLObject)rule, OWLRDFVocabulary.RDF_TYPE.getIRI(), SWRLVocabulary.IMP.getIRI());
        Set antecedent = rule.getBody();
        this.addTriple((OWLObject)rule, SWRLVocabulary.BODY.getIRI(), antecedent, SWRLVocabulary.ATOM_LIST.getIRI());
        Set consequent = rule.getHead();
        this.addTriple((OWLObject)rule, SWRLVocabulary.HEAD.getIRI(), consequent, SWRLVocabulary.ATOM_LIST.getIRI());
    }

    public void visit(SWRLClassAtom node) {
        this.translateAnonymousNode((OWLObject)node);
        this.addTriple((OWLObject)node, OWLRDFVocabulary.RDF_TYPE.getIRI(), SWRLVocabulary.CLASS_ATOM.getIRI());
        node.getPredicate().accept((OWLObjectVisitor)this);
        this.addTriple((OWLObject)node, SWRLVocabulary.CLASS_PREDICATE.getIRI(), (OWLObject)node.getPredicate());
        ((SWRLIArgument)node.getArgument()).accept((SWRLObjectVisitor)this);
        this.addTriple((OWLObject)node, SWRLVocabulary.ARGUMENT_1.getIRI(), (OWLObject)node.getArgument());
    }

    public void visit(SWRLDataRangeAtom node) {
        this.translateAnonymousNode((OWLObject)node);
        this.addTriple((OWLObject)node, OWLRDFVocabulary.RDF_TYPE.getIRI(), SWRLVocabulary.DATA_RANGE_ATOM.getIRI());
        node.getPredicate().accept((OWLObjectVisitor)this);
        this.addTriple((OWLObject)node, SWRLVocabulary.DATA_RANGE.getIRI(), (OWLObject)node.getPredicate());
        ((SWRLDArgument)node.getArgument()).accept((SWRLObjectVisitor)this);
        this.addTriple((OWLObject)node, SWRLVocabulary.ARGUMENT_1.getIRI(), (OWLObject)node.getArgument());
    }

    public void visit(SWRLObjectPropertyAtom node) {
        this.translateAnonymousNode((OWLObject)node);
        this.addTriple((OWLObject)node, OWLRDFVocabulary.RDF_TYPE.getIRI(), SWRLVocabulary.INDIVIDUAL_PROPERTY_ATOM.getIRI());
        node.getPredicate().accept((OWLObjectVisitor)this);
        this.addTriple((OWLObject)node, SWRLVocabulary.PROPERTY_PREDICATE.getIRI(), (OWLObject)node.getPredicate());
        ((SWRLIArgument)node.getFirstArgument()).accept((SWRLObjectVisitor)this);
        this.addTriple((OWLObject)node, SWRLVocabulary.ARGUMENT_1.getIRI(), (OWLObject)node.getFirstArgument());
        ((SWRLIArgument)node.getSecondArgument()).accept((SWRLObjectVisitor)this);
        this.addTriple((OWLObject)node, SWRLVocabulary.ARGUMENT_2.getIRI(), (OWLObject)node.getSecondArgument());
    }

    public void visit(SWRLDataPropertyAtom node) {
        this.translateAnonymousNode((OWLObject)node);
        this.addTriple((OWLObject)node, OWLRDFVocabulary.RDF_TYPE.getIRI(), SWRLVocabulary.DATAVALUED_PROPERTY_ATOM.getIRI());
        node.getPredicate().accept((OWLObjectVisitor)this);
        this.addTriple((OWLObject)node, SWRLVocabulary.PROPERTY_PREDICATE.getIRI(), (OWLObject)node.getPredicate());
        ((SWRLIArgument)node.getFirstArgument()).accept((SWRLObjectVisitor)this);
        this.addTriple((OWLObject)node, SWRLVocabulary.ARGUMENT_1.getIRI(), (OWLObject)node.getFirstArgument());
        ((SWRLDArgument)node.getSecondArgument()).accept((SWRLObjectVisitor)this);
        this.addTriple((OWLObject)node, SWRLVocabulary.ARGUMENT_2.getIRI(), (OWLObject)node.getSecondArgument());
    }

    public void visit(SWRLBuiltInAtom node) {
        this.translateAnonymousNode((OWLObject)node);
        this.addTriple((OWLObject)node, OWLRDFVocabulary.RDF_TYPE.getIRI(), SWRLVocabulary.BUILT_IN_ATOM.getIRI());
        this.addTriple((OWLObject)node, SWRLVocabulary.BUILT_IN.getIRI(), node.getPredicate());
        this.addTriple(this.getResourceNode(node.getPredicate()), this.getPredicateNode(OWLRDFVocabulary.RDF_TYPE.getIRI()), this.getResourceNode(SWRLVocabulary.BUILT_IN_CLASS.getIRI()));
        this.addTriple(this.getResourceNode((OWLObject)node), this.getPredicateNode(SWRLVocabulary.ARGUMENTS.getIRI()), this.translateList(new ArrayList(node.getArguments())));
    }

    public void visit(SWRLDifferentIndividualsAtom node) {
        this.translateAnonymousNode((OWLObject)node);
        this.addTriple((OWLObject)node, OWLRDFVocabulary.RDF_TYPE.getIRI(), SWRLVocabulary.DIFFERENT_INDIVIDUALS_ATOM.getIRI());
        ((SWRLIArgument)node.getFirstArgument()).accept((SWRLObjectVisitor)this);
        this.addTriple((OWLObject)node, SWRLVocabulary.ARGUMENT_1.getIRI(), (OWLObject)node.getFirstArgument());
        ((SWRLIArgument)node.getSecondArgument()).accept((SWRLObjectVisitor)this);
        this.addTriple((OWLObject)node, SWRLVocabulary.ARGUMENT_2.getIRI(), (OWLObject)node.getSecondArgument());
    }

    public void visit(SWRLSameIndividualAtom node) {
        this.translateAnonymousNode((OWLObject)node);
        this.addTriple((OWLObject)node, OWLRDFVocabulary.RDF_TYPE.getIRI(), SWRLVocabulary.SAME_INDIVIDUAL_ATOM.getIRI());
        ((SWRLIArgument)node.getFirstArgument()).accept((SWRLObjectVisitor)this);
        this.addTriple((OWLObject)node, SWRLVocabulary.ARGUMENT_1.getIRI(), (OWLObject)node.getFirstArgument());
        ((SWRLIArgument)node.getSecondArgument()).accept((SWRLObjectVisitor)this);
        this.addTriple((OWLObject)node, SWRLVocabulary.ARGUMENT_2.getIRI(), (OWLObject)node.getSecondArgument());
    }

    public void visit(SWRLVariable node) {
        if (!this.nodeMap.containsKey(node)) {
            this.nodeMap.put((OWLObject)node, this.getResourceNode(node.getIRI()));
        }
        this.addTriple((OWLObject)node, OWLRDFVocabulary.RDF_TYPE.getIRI(), SWRLVocabulary.VARIABLE.getIRI());
    }

    public void visit(SWRLIndividualArgument node) {
        node.getIndividual().accept((OWLObjectVisitor)this);
        this.nodeMap.put((OWLObject)node, this.nodeMap.get(node.getIndividual()));
    }

    public void visit(SWRLLiteralArgument node) {
        node.getLiteral().accept((OWLObjectVisitor)this);
        this.nodeMap.put((OWLObject)node, this.nodeMap.get(node.getLiteral()));
    }

    private void addSingleTripleAxiom(OWLAxiom ax, OWLObject subject, IRI pred, OWLObject obj) {
        this.addSingleTripleAxiom(ax, this.getResourceNode(subject), this.getPredicateNode(pred), this.getNode(obj));
    }

    private void addSingleTripleAxiom(OWLAxiom ax, OWLObject subject, IRI pred, IRI obj) {
        this.addSingleTripleAxiom(ax, this.getResourceNode(subject), this.getPredicateNode(pred), this.getResourceNode(obj));
    }

    private void addSingleTripleAxiom(OWLAxiom ax, OWLObject subj, IRI pred, Collection<? extends OWLObject> obj) {
        this.addSingleTripleAxiom(ax, this.getResourceNode(subj), this.getPredicateNode(pred), this.translateList(new ArrayList<OWLObject>(obj)));
    }

    private void addSingleTripleAxiom(OWLAxiom ax, OWLObject subj, OWLObject pred, OWLObject obj) {
        this.addSingleTripleAxiom(ax, this.getResourceNode(subj), this.getPredicateNode(pred), this.getNode(obj));
    }

    private void addSingleTripleAxiom(OWLAxiom ax, RESOURCE subject, PREDICATE predicate, NODE object) {
        this.addTriple(subject, predicate, object);
        if (ax.getAnnotations().isEmpty()) {
            return;
        }
        this.translateAnonymousNode((OWLObject)ax);
        this.addTriple(this.getResourceNode((OWLObject)ax), this.getPredicateNode(OWLRDFVocabulary.RDF_TYPE.getIRI()), this.getResourceNode(OWLRDFVocabulary.OWL_AXIOM.getIRI()));
        this.addTriple(this.getResourceNode((OWLObject)ax), this.getPredicateNode(OWLRDFVocabulary.OWL_ANNOTATED_SOURCE.getIRI()), subject);
        this.addTriple(this.getResourceNode((OWLObject)ax), this.getPredicateNode(OWLRDFVocabulary.OWL_ANNOTATED_PROPERTY.getIRI()), predicate);
        this.addTriple(this.getResourceNode((OWLObject)ax), this.getPredicateNode(OWLRDFVocabulary.OWL_ANNOTATED_TARGET.getIRI()), object);
        this.translateAnnotations(ax);
    }

    private void translateAnnotations(OWLAxiom ax) {
        this.translateAnonymousNode((OWLObject)ax);
        for (OWLAnnotation anno : ax.getAnnotations()) {
            this.translateAnnotation((OWLObject)ax, anno);
        }
    }

    private void translateAnnotation(OWLObject subject, OWLAnnotation annotation) {
        this.addTriple(subject, annotation.getProperty().getIRI(), (OWLObject)annotation.getValue());
        if (annotation.getValue() instanceof OWLAnonymousIndividual) {
            OWLAnonymousIndividual ind = (OWLAnonymousIndividual)annotation.getValue();
            this.translateAnonymousNode((OWLObject)ind);
            this.processIfAnonymous((OWLIndividual)ind);
        }
        if (annotation.getAnnotations().isEmpty()) {
            return;
        }
        this.translateAnonymousNode((OWLObject)annotation);
        this.addTriple((OWLObject)annotation, OWLRDFVocabulary.RDF_TYPE.getIRI(), OWLRDFVocabulary.OWL_ANNOTATION.getIRI());
        this.addTriple((OWLObject)annotation, OWLRDFVocabulary.OWL_ANNOTATED_SOURCE.getIRI(), subject);
        this.addTriple((OWLObject)annotation, OWLRDFVocabulary.OWL_ANNOTATED_PROPERTY.getIRI(), annotation.getProperty().getIRI());
        this.addTriple((OWLObject)annotation, OWLRDFVocabulary.OWL_ANNOTATED_TARGET.getIRI(), (OWLObject)annotation.getValue());
        for (OWLAnnotation anno : annotation.getAnnotations()) {
            this.translateAnnotation((OWLObject)annotation, anno);
        }
    }

    public void visit(OWLAnnotation node) {
        throw new OWLRuntimeException("The translator should not be used directly on instances of OWLAnnotation because an annotation cannot be translated without a subject.");
    }

    private void translateAnonymousNode(OWLObject object) {
        this.nodeMap.put(object, this.getAnonymousNode(object));
    }

    protected abstract RESOURCE getResourceNode(IRI var1);

    protected abstract PREDICATE getPredicateNode(IRI var1);

    protected abstract RESOURCE getAnonymousNode(Object var1);

    protected abstract LITERAL getLiteralNode(OWLLiteral var1);

    protected abstract void addTriple(RESOURCE var1, PREDICATE var2, NODE var3);

    private RESOURCE getResourceNode(OWLObject object) {
        NODE r = this.nodeMap.get(object);
        if (r == null) {
            object.accept((OWLObjectVisitor)this);
            r = this.nodeMap.get(object);
            if (r == null) {
                throw new IllegalStateException("Node is null!");
            }
        }
        return (RESOURCE)r;
    }

    private PREDICATE getPredicateNode(OWLObject object) {
        NODE p = this.nodeMap.get(object);
        if (p == null) {
            object.accept((OWLObjectVisitor)this);
            p = this.nodeMap.get(object);
            if (p == null) {
                throw new IllegalStateException("Node is null!");
            }
        }
        return (PREDICATE)p;
    }

    private NODE getNode(OWLObject obj) {
        NODE node = this.nodeMap.get(obj);
        if (node == null) {
            obj.accept((OWLObjectVisitor)this);
            node = this.nodeMap.get(obj);
            if (node == null) {
                throw new IllegalStateException("Node is null. Attempting to get node for " + obj);
            }
        }
        return node;
    }

    private RESOURCE translateList(List<? extends OWLObject> list) {
        return this.translateList(list, OWLRDFVocabulary.RDF_LIST.getIRI());
    }

    private RESOURCE translateList(List<? extends OWLObject> list, IRI listType) {
        int listSize;
        if (list.isEmpty()) {
            return this.getResourceNode(OWLRDFVocabulary.RDF_NIL.getIRI());
        }
        RESOURCE main = this.getResourceNode(OWLRDFVocabulary.RDF_NIL.getIRI());
        for (int i = listSize = list.size() - 1; i >= 0; --i) {
            RESOURCE anonNode = this.getAnonymousNode(list.subList(i, listSize));
            this.addTriple(anonNode, this.getPredicateNode(OWLRDFVocabulary.RDF_TYPE.getIRI()), this.getResourceNode(listType));
            this.addTriple(anonNode, this.getPredicateNode(OWLRDFVocabulary.RDF_FIRST.getIRI()), this.getNode(list.get(i)));
            this.addTriple(anonNode, this.getPredicateNode(OWLRDFVocabulary.RDF_REST.getIRI()), main);
            main = anonNode;
        }
        return main;
    }

    private void addTriple(OWLObject subject, IRI pred, IRI object) {
        this.addTriple(this.getResourceNode(subject), this.getPredicateNode(pred), this.getResourceNode(object));
    }

    private void addTriple(OWLObject subject, IRI pred, OWLObject object) {
        this.addTriple(this.getResourceNode(subject), this.getPredicateNode(pred), this.getNode(object));
    }

    private void addListTriples(OWLObject subject, IRI pred, Set<? extends OWLObject> objects) {
        this.addTriple(this.getResourceNode(subject), this.getPredicateNode(pred), this.translateList(new ArrayList<OWLObject>(objects)));
    }

    private void addTriple(OWLObject subject, IRI pred, Set<? extends OWLObject> objects, IRI listType) {
        this.addTriple(this.getResourceNode(subject), this.getPredicateNode(pred), this.translateList(new ArrayList<OWLObject>(objects), listType));
    }

    private OWLLiteral toTypedConstant(int i) {
        return this.manager.getOWLDataFactory().getOWLLiteral(Integer.toString(i), this.manager.getOWLDataFactory().getOWLDatatype(XSDVocabulary.NON_NEGATIVE_INTEGER.getIRI()));
    }

    private void processIfAnonymous(Set<OWLIndividual> inds, OWLAxiom root) {
        for (OWLIndividual ind : inds) {
            this.processIfAnonymous(ind, root);
        }
    }

    private void processIfAnonymous(OWLIndividual ind, OWLAxiom root) {
        if (!this.currentIndividuals.contains(ind)) {
            this.currentIndividuals.add(ind);
            if (ind.isAnonymous()) {
                for (OWLAxiom ax : this.ontology.getAxioms(ind)) {
                    if (root != null && root.equals(ax)) continue;
                    ax.accept((OWLObjectVisitor)this);
                }
                for (OWLAxiom ax : this.ontology.getAnnotationAssertionAxioms((OWLAnnotationSubject)ind.asOWLAnonymousIndividual())) {
                    ax.accept((OWLObjectVisitor)this);
                }
            }
            this.currentIndividuals.remove(ind);
        }
    }

    private void processIfAnonymous(OWLIndividual ind) {
        if (!this.currentIndividuals.contains(ind)) {
            this.currentIndividuals.add(ind);
            if (ind.isAnonymous()) {
                for (OWLAxiom ax : this.ontology.getAxioms(ind)) {
                    ax.accept((OWLObjectVisitor)this);
                }
                for (OWLAxiom ax : this.ontology.getAnnotationAssertionAxioms((OWLAnnotationSubject)ind.asOWLAnonymousIndividual())) {
                    ax.accept((OWLObjectVisitor)this);
                }
            }
            this.currentIndividuals.remove(ind);
        }
    }

    private void addPairwise(OWLAxiom axiom, Collection<? extends OWLObject> objects, IRI IRI2) {
        ArrayList<? extends OWLObject> objectList = new ArrayList<OWLObject>(objects);
        for (int i = 0; i < objectList.size(); ++i) {
            for (int j = i; j < objectList.size(); ++j) {
                if (i == j) continue;
                this.addSingleTripleAxiom(axiom, (OWLObject)objectList.get(i), IRI2, (OWLObject)objectList.get(j));
            }
        }
    }

    private void addPairwiseClassExpressions(OWLAxiom axiom, Set<OWLClassExpression> classExpressions, IRI IRI2) {
        ArrayList<OWLClassExpression> classExpressionList = new ArrayList<OWLClassExpression>(classExpressions);
        this.addPairwise(axiom, classExpressionList, IRI2);
    }

    private void addStrongTyping(OWLEntity entity) {
        if (!this.useStrongTyping) {
            return;
        }
        if (!RDFOntologyFormat.isMissingType((OWLEntity)entity, (OWLOntology)this.ontology)) {
            return;
        }
        this.addTriple((OWLObject)entity, OWLRDFVocabulary.RDF_TYPE.getIRI(), (IRI)entity.accept((OWLEntityVisitorEx)OWLEntityTypeProvider.INSTANCE));
    }

    private static class OWLEntityTypeProvider
    implements OWLEntityVisitorEx<IRI> {
        public static OWLEntityTypeProvider INSTANCE = new OWLEntityTypeProvider();

        private OWLEntityTypeProvider() {
        }

        public IRI visit(OWLClass cls) {
            return OWLRDFVocabulary.OWL_CLASS.getIRI();
        }

        public IRI visit(OWLObjectProperty property) {
            return OWLRDFVocabulary.OWL_OBJECT_PROPERTY.getIRI();
        }

        public IRI visit(OWLDataProperty property) {
            return OWLRDFVocabulary.OWL_DATA_PROPERTY.getIRI();
        }

        public IRI visit(OWLNamedIndividual individual) {
            return OWLRDFVocabulary.OWL_NAMED_INDIVIDUAL.getIRI();
        }

        public IRI visit(OWLDatatype datatype) {
            return OWLRDFVocabulary.RDFS_DATATYPE.getIRI();
        }

        public IRI visit(OWLAnnotationProperty property) {
            return OWLRDFVocabulary.OWL_ANNOTATION_PROPERTY.getIRI();
        }
    }
}

