/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.bytes;

import net.openhft.chronicle.bytes.StopCharTester;

public enum StopCharTesters implements StopCharTester
{
    COMMA_STOP{

        @Override
        public boolean isStopChar(int ch) {
            return ch < 32 || ch == 44;
        }
    }
    ,
    COMMA_SPACE_STOP{

        @Override
        public boolean isStopChar(int ch) {
            return ch <= 32 || ch == 44;
        }
    }
    ,
    CONTROL_STOP{

        @Override
        public boolean isStopChar(int ch) {
            return ch < 32;
        }
    }
    ,
    SPACE_STOP{

        @Override
        public boolean isStopChar(int ch) {
            return Character.isWhitespace(ch) || ch == 0;
        }
    }
    ,
    QUOTES{

        @Override
        public boolean isStopChar(int ch) {
            return ch == 34 || ch <= 0;
        }
    }
    ,
    SINGLE_QUOTES{

        @Override
        public boolean isStopChar(int ch) {
            return ch == 39 || ch <= 0;
        }
    }
    ,
    EQUALS{

        @Override
        public boolean isStopChar(int ch) {
            return ch == 61 || ch <= 0;
        }
    }
    ,
    NUMBER_END{

        @Override
        public boolean isStopChar(int ch) {
            switch (ch) {
                case 43: 
                case 45: 
                case 46: 
                case 48: 
                case 49: 
                case 50: 
                case 51: 
                case 52: 
                case 53: 
                case 54: 
                case 55: 
                case 56: 
                case 57: 
                case 69: 
                case 101: {
                    return false;
                }
            }
            return true;
        }
    }
    ,
    NON_ALPHA_DIGIT{

        @Override
        public boolean isStopChar(int ch) {
            return ch < 48 || !Character.isAlphabetic(ch) && !Character.isDigit(ch);
        }
    }
    ,
    ALL{

        @Override
        public boolean isStopChar(int ch) {
            return ch < 0;
        }
    };

}

