/*
 * Decompiled with CFR 0.152.
 */
package nc.ird.cantharella.service.utils.normalizers.utils;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.Arrays;
import nc.ird.cantharella.service.utils.normalizers.utils.Normalize;
import nc.ird.cantharella.service.utils.normalizers.utils.Normalizer;
import nc.ird.module.utils.LogTools;
import org.apache.commons.logging.Log;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.reflect.MethodSignature;
import org.springframework.stereotype.Component;

@Aspect
@Component
public final class NormalizerAspect {
    private static final Log LOG = LogTools.getLog();

    @Around(value="execution(* nc.ird.cantharella.service.services.*Service.*(..,@Normalize (*),..))")
    public Object normalize(ProceedingJoinPoint proceedingJoinPoint) throws Throwable {
        Method method = ((MethodSignature)proceedingJoinPoint.getSignature()).getMethod();
        Object[] objectArray = proceedingJoinPoint.getArgs();
        Annotation[][] annotationArray = method.getParameterAnnotations();
        for (int i = 0; i < annotationArray.length; ++i) {
            for (Annotation annotation : annotationArray[i]) {
                if (!(annotation instanceof Normalize)) continue;
                objectArray[i] = Normalizer.normalize(((Normalize)annotation).value(), objectArray[i]);
                LOG.debug((Object)("normalize : '" + objectArray[i] + "' in " + method.getDeclaringClass().getSimpleName() + "." + method.getName() + "(" + Arrays.asList(method.getParameterTypes()) + ")"));
            }
        }
        return proceedingJoinPoint.proceed(objectArray);
    }
}

