/*
 * Decompiled with CFR 0.152.
 */
package nc.ird.cantharella.service.utils.normalizers.utils;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import nc.ird.cantharella.data.exceptions.UnexpectedException;
import nc.ird.module.utils.LogTools;
import org.apache.commons.logging.Log;

public abstract class Normalizer<O> {
    private static final Log LOG = LogTools.getLog();
    private static final Map<Class<? extends Normalizer<?>>, Normalizer<?>> NORMALIZERS = Collections.synchronizedMap(new HashMap());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> T normalize(Class<? extends Normalizer<T>> clazz, T t) {
        Normalizer<Object> normalizer;
        Map<Class<? extends Normalizer<?>>, Normalizer<?>> map = NORMALIZERS;
        synchronized (map) {
            normalizer = NORMALIZERS.get(clazz);
            if (normalizer == null) {
                try {
                    normalizer = clazz.newInstance();
                }
                catch (InstantiationException instantiationException) {
                    LOG.error((Object)instantiationException.getMessage(), (Throwable)instantiationException);
                    throw new UnexpectedException((Exception)instantiationException);
                }
                catch (IllegalAccessException illegalAccessException) {
                    LOG.error((Object)illegalAccessException.getMessage(), (Throwable)illegalAccessException);
                    throw new UnexpectedException((Exception)illegalAccessException);
                }
                NORMALIZERS.put(clazz, normalizer);
            }
        }
        return (T)normalizer.normalize(t);
    }

    protected abstract O normalize(O var1);
}

