/*
 * Decompiled with CFR 0.152.
 */
package nc.ird.cantharella.service.utils.normalizers;

import nc.ird.cantharella.data.model.ParamMethoPuriEffectif;
import nc.ird.cantharella.data.model.Purification;
import nc.ird.cantharella.service.utils.normalizers.UniqueFieldNormalizer;
import nc.ird.cantharella.service.utils.normalizers.utils.Normalizer;
import nc.ird.module.utils.AssertTools;
import nc.ird.module.utils.StringTransformer;

public final class PurificationNormalizer
extends Normalizer<Purification> {
    @Override
    protected Purification normalize(Purification purification) {
        AssertTools.assertNotNull((Object)purification);
        purification.setRef(Normalizer.normalize(UniqueFieldNormalizer.class, purification.getRef()));
        for (ParamMethoPuriEffectif paramMethoPuriEffectif : purification.getParamsMetho()) {
            paramMethoPuriEffectif.setValeur(new StringTransformer(paramMethoPuriEffectif.getValeur()).trimToNull().replaceConsecutiveWhitespaces().toString());
        }
        for (ParamMethoPuriEffectif paramMethoPuriEffectif : purification.getFractions()) {
            paramMethoPuriEffectif.setRef(Normalizer.normalize(UniqueFieldNormalizer.class, paramMethoPuriEffectif.getRef()));
        }
        return purification;
    }
}

