/*
 * Decompiled with CFR 0.152.
 */
package nc.ird.cantharella.service.utils.normalizers;

import nc.ird.cantharella.data.model.Personne;
import nc.ird.cantharella.service.utils.normalizers.EmailNormalizer;
import nc.ird.cantharella.service.utils.normalizers.utils.Normalizer;
import nc.ird.module.utils.AssertTools;
import nc.ird.module.utils.StringTransformer;

public final class PersonneNormalizer
extends Normalizer<Personne> {
    @Override
    public Personne normalize(Personne personne) {
        AssertTools.assertNotNull((Object)personne);
        personne.setCourriel(PersonneNormalizer.normalize(EmailNormalizer.class, personne.getCourriel()));
        personne.setNom(new StringTransformer(personne.getNom()).replaceAccents().replaceNonAlpha().replaceConsecutiveWhitespaces().trimToNull().toUpperCase().toString());
        personne.setPrenom(new StringTransformer(personne.getPrenom()).replaceAccents().replaceNonAlpha().replaceConsecutiveWhitespaces().trimToNull().capitalizeFully().toString());
        return personne;
    }
}

