/*
 * Decompiled with CFR 0.152.
 */
package nc.ird.cantharella.service.services.impl;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;
import nc.ird.cantharella.data.dao.GenericDao;
import nc.ird.cantharella.data.dao.impl.StationDao;
import nc.ird.cantharella.data.exceptions.DataConstraintException;
import nc.ird.cantharella.data.exceptions.DataNotFoundException;
import nc.ird.cantharella.data.exceptions.UnexpectedException;
import nc.ird.cantharella.data.model.Lot;
import nc.ird.cantharella.data.model.Station;
import nc.ird.cantharella.data.model.Utilisateur;
import nc.ird.cantharella.data.model.utils.AbstractModel;
import nc.ird.cantharella.service.services.StationService;
import nc.ird.module.utils.AssertTools;
import nc.ird.module.utils.LogTools;
import org.apache.commons.logging.Log;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public final class StationServiceImpl
implements StationService {
    private static final Log LOG = LogTools.getLog();
    @Autowired
    private GenericDao dao;

    @Override
    public long countStations() {
        return this.dao.count(Station.class);
    }

    @Override
    public void createStation(Station station) throws DataConstraintException {
        LOG.info((Object)("createStation " + station.getNom()));
        this.dao.create((AbstractModel)station);
    }

    @Override
    public void deleteStation(Station station) throws DataConstraintException {
        LOG.info((Object)("deleteStation " + station.getIdStation()));
        try {
            this.dao.delete((AbstractModel)station);
        }
        catch (DataNotFoundException dataNotFoundException) {
            LOG.error((Object)dataNotFoundException.getMessage(), (Throwable)dataNotFoundException);
            throw new UnexpectedException((Exception)((Object)dataNotFoundException));
        }
    }

    @Override
    public List<String> listStationLocalites() {
        return this.dao.list(StationDao.CRITERIA_DISTINCT_STATION_LOCALITES);
    }

    @Override
    public List<Station> listStations(Utilisateur utilisateur) {
        AssertTools.assertNotNull((Object)utilisateur);
        if (utilisateur.getTypeDroit() == Utilisateur.TypeDroit.ADMINISTRATEUR) {
            return this.dao.readList(Station.class, new String[]{"nom"});
        }
        SortedSet<Station> sortedSet = this.listStationsForUser(utilisateur);
        return new ArrayList<Station>(sortedSet);
    }

    @Override
    public SortedSet<Station> listStationsForUser(Utilisateur utilisateur) {
        Object object2;
        TreeSet<Station> treeSet = new TreeSet<Station>();
        treeSet.addAll(utilisateur.getStationsCrees());
        ArrayList arrayList = new ArrayList();
        arrayList.addAll(utilisateur.getCampagnesCreees());
        arrayList.addAll(utilisateur.getCampagnesDroits().keySet());
        for (Object object2 : arrayList) {
            treeSet.addAll(object2.getStations());
        }
        ArrayList arrayList2 = new ArrayList();
        arrayList2.addAll(utilisateur.getLotsCrees());
        arrayList2.addAll(utilisateur.getLotsDroits().keySet());
        object2 = arrayList2.iterator();
        while (object2.hasNext()) {
            Lot lot = (Lot)object2.next();
            treeSet.add(lot.getStation());
            if (lot.getSpecimenRef().getStation() == null) continue;
            treeSet.add(lot.getSpecimenRef().getStation());
        }
        return treeSet;
    }

    @Override
    public Station loadStation(Integer n) throws DataNotFoundException {
        AssertTools.assertNotNull((Object)n);
        return (Station)this.dao.read(Station.class, (Serializable)n);
    }

    @Override
    public Station loadStation(String string) throws DataNotFoundException {
        AssertTools.assertNotEmpty((String)string);
        return (Station)this.dao.read(Station.class, "nom", (Serializable)((Object)string));
    }

    @Override
    public boolean updateOrdeleteStationEnabled(Station station, Utilisateur utilisateur) {
        return utilisateur.getTypeDroit() == Utilisateur.TypeDroit.ADMINISTRATEUR || utilisateur.getIdPersonne() == station.getCreateur().getIdPersonne();
    }

    @Override
    public void updateStation(Station station) throws DataConstraintException {
        LOG.info((Object)("updateStation " + station.getNom()));
        try {
            this.dao.update((AbstractModel)station);
        }
        catch (DataNotFoundException dataNotFoundException) {
            LOG.error((Object)dataNotFoundException.getMessage(), (Throwable)dataNotFoundException);
            throw new UnexpectedException((Exception)((Object)dataNotFoundException));
        }
    }
}

