/*
 * Decompiled with CFR 0.152.
 */
package nc.ird.cantharella.service.services.impl;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;
import nc.ird.cantharella.data.dao.GenericDao;
import nc.ird.cantharella.data.dao.impl.ProduitDao;
import nc.ird.cantharella.data.model.Extraction;
import nc.ird.cantharella.data.model.Extrait;
import nc.ird.cantharella.data.model.Fraction;
import nc.ird.cantharella.data.model.Produit;
import nc.ird.cantharella.data.model.Purification;
import nc.ird.cantharella.data.model.Utilisateur;
import nc.ird.cantharella.service.services.ExtractionService;
import nc.ird.cantharella.service.services.ProduitService;
import nc.ird.cantharella.service.services.PurificationService;
import nc.ird.module.utils.AssertTools;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public final class ProduitServiceImpl
implements ProduitService {
    @Autowired
    private GenericDao dao;
    @Autowired
    private ExtractionService extractionService;
    @Autowired
    private PurificationService purificationService;

    @Override
    public List<Produit> listProduits(Utilisateur utilisateur) {
        AssertTools.assertNotNull((Object)utilisateur);
        if (utilisateur.getTypeDroit() == Utilisateur.TypeDroit.ADMINISTRATEUR) {
            TreeSet treeSet = new TreeSet();
            treeSet.addAll(this.dao.readList(Extrait.class, new String[]{"ref"}));
            treeSet.addAll(this.dao.readList(Fraction.class, new String[]{"ref"}));
            return new ArrayList<Produit>(treeSet);
        }
        return new ArrayList<Produit>(this.listProduitsForUser(utilisateur));
    }

    @Override
    public SortedSet<Produit> listProduitsForUser(Utilisateur utilisateur) {
        AssertTools.assertNotNull((Object)utilisateur);
        TreeSet<Produit> treeSet = new TreeSet<Produit>();
        for (Extraction extraction : this.extractionService.listExtractionsForUser(utilisateur)) {
            treeSet.addAll(extraction.getExtraits());
        }
        for (Purification purification : this.purificationService.listPurificationsForUser(utilisateur)) {
            treeSet.addAll(purification.getFractions());
        }
        return treeSet;
    }

    @Override
    public List<Produit> listProduitsWithoutChildrenOfPuri(Utilisateur utilisateur, Purification purification) {
        AssertTools.assertNotNull((Object)utilisateur);
        AssertTools.assertNotNull((Object)purification);
        List<Produit> list = this.listProduits(utilisateur);
        LinkedList linkedList = new LinkedList(purification.getFractions());
        while (!linkedList.isEmpty()) {
            Fraction fraction = (Fraction)linkedList.remove();
            list.remove(fraction);
            for (Purification purification2 : fraction.getPurificationsSuivantes()) {
                linkedList.addAll(purification2.getFractions());
            }
        }
        return list;
    }

    @Override
    public boolean isProduitReferenced(Produit produit) {
        return this.dao.count(ProduitDao.getCriteriaCountPurifFromProduit((String)produit.getRef())) > 0L && this.dao.count(ProduitDao.getCriteriaCountTestBioFromProduit((String)produit.getRef())) > 0L;
    }
}

