/*
 * Decompiled with CFR 0.152.
 */
package nc.ird.cantharella.service.services.impl;

import java.io.Serializable;
import java.util.List;
import javax.annotation.Resource;
import nc.ird.cantharella.data.dao.GenericDao;
import nc.ird.cantharella.data.dao.impl.PersonneDao;
import nc.ird.cantharella.data.exceptions.DataConstraintException;
import nc.ird.cantharella.data.exceptions.DataNotFoundException;
import nc.ird.cantharella.data.exceptions.UnexpectedException;
import nc.ird.cantharella.data.model.Personne;
import nc.ird.cantharella.data.model.Utilisateur;
import nc.ird.cantharella.data.model.utils.AbstractModel;
import nc.ird.cantharella.service.exceptions.EmailException;
import nc.ird.cantharella.service.services.MailService;
import nc.ird.cantharella.service.services.PersonneService;
import nc.ird.cantharella.service.utils.normalizers.EmailNormalizer;
import nc.ird.cantharella.service.utils.normalizers.utils.Normalize;
import nc.ird.module.utils.AssertTools;
import nc.ird.module.utils.LogTools;
import nc.ird.module.utils.PasswordTools;
import org.apache.commons.logging.Log;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.NoSuchMessageException;
import org.springframework.context.support.MessageSourceAccessor;
import org.springframework.dao.DataAccessException;
import org.springframework.dao.DataIntegrityViolationException;
import org.springframework.dao.DataRetrievalFailureException;
import org.springframework.orm.ObjectRetrievalFailureException;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public final class PersonneServiceImpl
implements PersonneService {
    private static final Log LOG = LogTools.getLog();
    @Autowired
    private GenericDao dao;
    @Autowired
    private Utilisateur defaultAdmin;
    @Autowired
    private MailService mailService;
    @Resource(name="serviceMessageSource")
    private MessageSourceAccessor messages;

    @Override
    public void checkOrCreateAdmin() throws DataConstraintException {
        if (this.countAdmins() == 0L) {
            this.defaultAdmin.setTypeDroit(Utilisateur.TypeDroit.ADMINISTRATEUR);
            this.defaultAdmin.setValide(Boolean.TRUE);
            this.plainCreateUtilisateur(this.defaultAdmin);
        }
    }

    private Long countAdmins() {
        return this.dao.count(PersonneDao.CRITERIA_COUNT_ADMINS);
    }

    @Override
    public long countPersonnes() {
        return this.dao.count(Personne.class);
    }

    @Override
    public void createPersonne(Personne personne) throws DataConstraintException {
        LOG.info((Object)("createPersonne " + personne.getCourriel()));
        try {
            this.dao.create((AbstractModel)personne);
        }
        catch (DataIntegrityViolationException dataIntegrityViolationException) {
            throw new DataConstraintException(dataIntegrityViolationException);
        }
    }

    @Override
    public void createUtilisateur(Utilisateur utilisateur) throws DataConstraintException {
        try {
            this.plainCreateUtilisateur(utilisateur);
        }
        catch (DataIntegrityViolationException dataIntegrityViolationException) {
            throw new DataConstraintException(dataIntegrityViolationException);
        }
        this.mailService.sendMailQuietly((Personne)utilisateur, this.messages.getMessage("register.subject"), this.messages.getMessage("register.text"));
        this.mailService.sendMailQuietly(this.listAdmins(), this.messages.getMessage("register.subject.admin"), this.messages.getMessage("register.text.admin", new Object[]{utilisateur.getPrenom(), utilisateur.getNom(), utilisateur.getCourriel()}));
    }

    @Override
    public void deletePersonne(Personne personne) throws DataConstraintException {
        AssertTools.assertNotNull((Object)personne);
        LOG.info((Object)("deletePersonne " + personne.getIdPersonne()));
        AssertTools.assertNotNull((Object)personne.getIdPersonne());
        try {
            this.dao.delete((AbstractModel)personne);
        }
        catch (DataNotFoundException dataNotFoundException) {
            LOG.error((Object)dataNotFoundException.getMessage(), (Throwable)dataNotFoundException);
            throw new UnexpectedException((Exception)((Object)dataNotFoundException));
        }
    }

    @Override
    public void deleteUtilisateur(Utilisateur utilisateur) throws DataConstraintException, EmailException {
        this.deleteUtilisateur(utilisateur, this.messages.getMessage("delete.subject"), this.messages.getMessage("delete.text"));
    }

    @Transactional(rollbackFor={EmailException.class})
    public void deleteUtilisateur(Utilisateur utilisateur, String string, String string2) throws EmailException, DataConstraintException {
        AssertTools.assertNotNull((Object)utilisateur);
        LOG.info((Object)("deleteUtilisateur " + utilisateur.getIdPersonne()));
        AssertTools.assertNotNull((Object)utilisateur.getIdPersonne());
        try {
            this.dao.delete((AbstractModel)utilisateur);
        }
        catch (DataConstraintException dataConstraintException) {
            this.dao.execute(PersonneDao.SQL_DELETE_UTILISATEUR, new Object[]{utilisateur.getIdPersonne()});
        }
        catch (DataNotFoundException dataNotFoundException) {
            LOG.error((Object)dataNotFoundException.getMessage(), (Throwable)dataNotFoundException);
            throw new UnexpectedException((Exception)((Object)dataNotFoundException));
        }
        this.mailService.sendMail((Personne)utilisateur, string, string2);
    }

    @Override
    public String hashPassword(String string) {
        AssertTools.assertNotEmpty((String)string);
        return PasswordTools.sha1((String)string);
    }

    private List<Utilisateur> listAdmins() {
        return this.dao.list(PersonneDao.CRITERIA_LIST_ADMINS);
    }

    @Override
    public List<Personne> listPersonnes() {
        List list = this.dao.readList(Personne.class, new String[]{"nom", "prenom"});
        list.removeAll(this.listUtilisateursInvalid());
        return list;
    }

    @Override
    public List<Personne> listPersonnesWithInvalidUsers() {
        return this.dao.readList(Personne.class, new String[]{"nom", "prenom"});
    }

    @Override
    public List<String> listPersonneOrganismes() {
        return this.dao.list(PersonneDao.CRITERIA_DISTINCT_PERSONNE_ORGANISMES);
    }

    @Override
    public List<Utilisateur> listUtilisateursInvalid() {
        return this.dao.list(PersonneDao.CRITERIA_LIST_UTILISATEURS_INVALID);
    }

    @Override
    public List<Utilisateur> listUtilisateursValid() {
        return this.dao.list(PersonneDao.CRITERIA_LIST_UTILISATEURS_VALID);
    }

    @Override
    public Personne loadPersonne(Integer n) throws DataNotFoundException {
        AssertTools.assertNotNull((Object)n);
        try {
            return (Personne)this.dao.read(Personne.class, (Serializable)n);
        }
        catch (DataRetrievalFailureException dataRetrievalFailureException) {
            throw new DataNotFoundException(dataRetrievalFailureException);
        }
    }

    @Override
    public Personne loadPersonne(String string) throws DataNotFoundException {
        AssertTools.assertNotNull((Object)string);
        return (Personne)this.dao.read(Personne.class, "courriel", (Serializable)((Object)string));
    }

    @Override
    public Utilisateur loadUtilisateur(Integer n) throws DataNotFoundException {
        AssertTools.assertNotNull((Object)n);
        try {
            return (Utilisateur)this.dao.read(Utilisateur.class, (Serializable)n);
        }
        catch (DataRetrievalFailureException dataRetrievalFailureException) {
            throw new DataNotFoundException(dataRetrievalFailureException);
        }
    }

    @Override
    public Utilisateur loadUtilisateur(String string) throws DataNotFoundException {
        AssertTools.assertNotEmpty((String)string);
        Personne personne = this.loadPersonne(string);
        if (!(personne instanceof Utilisateur)) {
            throw new DataNotFoundException((DataRetrievalFailureException)new ObjectRetrievalFailureException(Utilisateur.class, (Object)string));
        }
        return (Utilisateur)personne;
    }

    @Override
    public boolean authenticateUtilisateur(@Normalize(value=EmailNormalizer.class) String string, String string2) {
        AssertTools.assertNotEmpty((String)string);
        AssertTools.assertNotEmpty((String)string2);
        return this.dao.exists(PersonneDao.getCriteriaAuthenticateUser((String)string, (String)string2));
    }

    private void plainCreateUtilisateur(Utilisateur utilisateur) throws DataConstraintException {
        AssertTools.assertNotNull((Object)utilisateur);
        LOG.info((Object)("createUtilisateur " + utilisateur.getCourriel()));
        if (utilisateur.getTypeDroit() == null) {
            utilisateur.setTypeDroit(Utilisateur.TypeDroit.UTILISATEUR);
        }
        if (utilisateur.isValide() == null) {
            utilisateur.setValide(Boolean.FALSE);
        }
        this.dao.create((AbstractModel)utilisateur);
    }

    @Override
    public void refreshPersonne(Personne personne) {
        AssertTools.assertNotNull((Object)personne);
        this.dao.refresh((AbstractModel)personne);
    }

    @Override
    public void rejectUtilisateur(Utilisateur utilisateur) throws NoSuchMessageException {
        try {
            this.deleteUtilisateur(utilisateur, this.messages.getMessage("reject.subject"), this.messages.getMessage("reject.text"));
        }
        catch (EmailException emailException) {
        }
        catch (DataConstraintException dataConstraintException) {
            LOG.error((Object)dataConstraintException.getMessage());
        }
    }

    @Override
    @Transactional(rollbackFor={DataNotFoundException.class, EmailException.class})
    public void resetPasswordUtilisateur(String string) throws DataNotFoundException, EmailException {
        Utilisateur utilisateur;
        LOG.info((Object)("reListPasswordUtilisateur " + string));
        try {
            utilisateur = this.loadUtilisateur(string);
        }
        catch (DataNotFoundException dataNotFoundException) {
            LOG.warn((Object)("Unknown e-mail: " + string));
            throw dataNotFoundException;
        }
        String string2 = PasswordTools.random();
        utilisateur.setPasswordHash(this.hashPassword(string2));
        try {
            this.dao.update((AbstractModel)utilisateur);
        }
        catch (DataConstraintException dataConstraintException) {
            LOG.error((Object)dataConstraintException.getMessage(), (Throwable)dataConstraintException);
            throw new UnexpectedException((Exception)((Object)dataConstraintException));
        }
        this.mailService.sendMail((Personne)utilisateur, this.messages.getMessage("updatePassword.subject"), this.messages.getMessage("updatePassword.text", new Object[]{string2}));
    }

    @Override
    public void sendMailAdmins(String string, String string2, String string3) throws EmailException {
        LOG.info((Object)("sendMailAdmins " + string + " [reply to] " + string3));
        this.mailService.sendMail(this.listAdmins(), this.messages.getMessage("contact.subject", (Object[])new String[]{string}), this.messages.getMessage("contact.body", (Object[])new String[]{string3, string2}), string3);
    }

    @Override
    @Transactional(rollbackFor={EmailException.class, DataAccessException.class, UnexpectedException.class})
    public Utilisateur updateAndCreateUtilisateur(Personne personne) throws EmailException, DataConstraintException {
        Utilisateur utilisateur;
        LOG.info((Object)("updateAndCreateUtilisateur " + personne.getIdPersonne()));
        String string = PasswordTools.random();
        try {
            this.dao.update((AbstractModel)personne);
        }
        catch (DataNotFoundException dataNotFoundException) {
            LOG.error((Object)dataNotFoundException.getMessage(), (Throwable)dataNotFoundException);
            throw new UnexpectedException((Exception)((Object)dataNotFoundException));
        }
        this.dao.execute(PersonneDao.SQL_CREATE_UTILISATEUR_FROM_PERSONNE, new Object[]{Boolean.TRUE, this.hashPassword(string), Utilisateur.TypeDroit.UTILISATEUR.ordinal(), personne.getIdPersonne()});
        try {
            utilisateur = (Utilisateur)this.dao.read(Utilisateur.class, (Serializable)personne.getIdPersonne());
        }
        catch (DataNotFoundException dataNotFoundException) {
            LOG.error((Object)dataNotFoundException.getMessage(), (Throwable)dataNotFoundException);
            throw new UnexpectedException((Exception)((Object)dataNotFoundException));
        }
        this.mailService.sendMail((Personne)utilisateur, this.messages.getMessage("create.subject"), this.messages.getMessage("create.text", new Object[]{string}));
        return utilisateur;
    }

    @Override
    public void updatePersonne(Personne personne) throws DataConstraintException {
        LOG.info((Object)("updatePersonne " + personne.getIdPersonne()));
        try {
            this.dao.update((AbstractModel)personne);
        }
        catch (DataNotFoundException dataNotFoundException) {
            LOG.error((Object)dataNotFoundException.getMessage(), (Throwable)dataNotFoundException);
            throw new UnexpectedException((Exception)((Object)dataNotFoundException));
        }
    }

    private void updateUtilisateur(Utilisateur utilisateur) throws DataConstraintException {
        AssertTools.assertNotNull((Object)utilisateur);
        LOG.info((Object)("updateUtilisateur " + utilisateur.getCourriel()));
        try {
            this.dao.update((AbstractModel)utilisateur);
        }
        catch (DataNotFoundException dataNotFoundException) {
            LOG.error((Object)dataNotFoundException.getMessage(), (Throwable)dataNotFoundException);
            throw new UnexpectedException((Exception)((Object)dataNotFoundException));
        }
    }

    @Override
    public void updateUtilisateur(Utilisateur utilisateur, boolean bl) throws DataConstraintException {
        this.updateUtilisateur(utilisateur);
        if (bl) {
            this.mailService.sendMailQuietly((Personne)utilisateur, this.messages.getMessage("update.subject"), this.messages.getMessage("update.text"));
        }
    }

    @Override
    public void validAndUpdateUtilisateur(Utilisateur utilisateur) throws DataConstraintException {
        utilisateur.setValide(Boolean.valueOf(true));
        this.updateUtilisateur(utilisateur);
        this.mailService.sendMailQuietly((Personne)utilisateur, this.messages.getMessage("valid.subject"), this.messages.getMessage("valid.text"));
    }

    @Override
    public boolean updateOrDeletePersonneEnabled(Personne personne, Utilisateur utilisateur) {
        AssertTools.assertNotNull((Object)personne);
        AssertTools.assertNotNull((Object)utilisateur);
        return !(personne instanceof Utilisateur) || utilisateur.getTypeDroit() == Utilisateur.TypeDroit.ADMINISTRATEUR;
    }
}

