/*
 * Decompiled with CFR 0.152.
 */
package nc.ird.cantharella.service.services.impl;

import java.util.Arrays;
import java.util.Collection;
import nc.ird.cantharella.data.model.Personne;
import nc.ird.cantharella.data.model.Utilisateur;
import nc.ird.cantharella.service.config.ServiceContext;
import nc.ird.cantharella.service.exceptions.EmailException;
import nc.ird.cantharella.service.services.MailService;
import nc.ird.module.utils.AssertTools;
import nc.ird.module.utils.LogTools;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.mail.MailSender;
import org.springframework.mail.SimpleMailMessage;
import org.springframework.stereotype.Service;

@Service
public final class MailServiceImpl
implements MailService {
    private static final Log LOG = LogTools.getLog();
    @Autowired
    private SimpleMailMessage mailMessage;
    @Autowired
    private MailSender mailSender;

    @Override
    public void sendMail(Collection<Utilisateur> collection, String string, String string2) throws EmailException {
        this.sendMail(collection, string, string2, null);
    }

    @Override
    public void sendMail(Collection<Utilisateur> collection, String string, String string2, String string3) throws EmailException {
        AssertTools.assertCollectionNotNull(collection);
        String[] stringArray = new String[collection.size()];
        int n = 0;
        for (Utilisateur utilisateur : collection) {
            stringArray[n++] = utilisateur.getCourriel();
        }
        this.sendMail(string, string2, string3, stringArray);
    }

    @Override
    public void sendMail(Personne personne, String string, String string2) throws EmailException {
        AssertTools.assertNotNull((Object)personne);
        this.sendMail(string, string2, null, personne.getCourriel());
    }

    private void sendMail(String string, String string2, String string3, String ... stringArray) throws EmailException {
        LOG.info((Object)("sendMail " + string + " [to] " + Arrays.toString(stringArray)));
        if (ServiceContext.isMailActivated()) {
            AssertTools.assertNotEmpty((String)string);
            AssertTools.assertNotEmpty((String)string2);
            AssertTools.assertNotEmpty((Object[])stringArray);
            AssertTools.assertArrayNotEmpty((String[])stringArray);
            this.mailMessage.setTo(stringArray);
            this.mailMessage.setSubject(string);
            this.mailMessage.setText(string2);
            if (!StringUtils.isEmpty((String)string3)) {
                this.mailMessage.setReplyTo(string3);
            }
            try {
                this.mailSender.send(this.mailMessage);
            }
            catch (Exception exception) {
                throw new EmailException(exception);
            }
        }
    }

    @Override
    public void sendMailQuietly(Collection<Utilisateur> collection, String string, String string2) {
        try {
            this.sendMail(collection, string, string2);
        }
        catch (EmailException emailException) {
            LOG.warn((Object)emailException.toString());
        }
    }

    @Override
    public void sendMailQuietly(Personne personne, String string, String string2) {
        try {
            this.sendMail(personne, string, string2);
        }
        catch (EmailException emailException) {
            LOG.warn((Object)emailException.toString());
        }
    }
}

