/*
 * Decompiled with CFR 0.152.
 */
package nc.ird.cantharella.service.services.impl;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;
import nc.ird.cantharella.data.dao.GenericDao;
import nc.ird.cantharella.data.exceptions.DataConstraintException;
import nc.ird.cantharella.data.exceptions.DataNotFoundException;
import nc.ird.cantharella.data.exceptions.UnexpectedException;
import nc.ird.cantharella.data.model.Campagne;
import nc.ird.cantharella.data.model.Lot;
import nc.ird.cantharella.data.model.Partie;
import nc.ird.cantharella.data.model.Utilisateur;
import nc.ird.cantharella.data.model.utils.AbstractModel;
import nc.ird.cantharella.service.services.LotService;
import nc.ird.module.utils.AssertTools;
import nc.ird.module.utils.LogTools;
import org.apache.commons.logging.Log;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public final class LotServiceImpl
implements LotService {
    private static final Log LOG = LogTools.getLog();
    @Autowired
    private GenericDao dao;

    @Override
    public long countLots() {
        return this.dao.count(Lot.class);
    }

    @Override
    public void createLot(Lot lot) throws DataConstraintException {
        LOG.info((Object)("createLot " + lot.getRef()));
        this.dao.create((AbstractModel)lot);
    }

    @Override
    public void createPartie(Partie partie) throws DataConstraintException {
        LOG.info((Object)("createPartie: " + partie.getNom()));
        this.dao.create((AbstractModel)partie);
    }

    @Override
    public void deleteLot(Lot lot) throws DataConstraintException {
        AssertTools.assertNotNull((Object)lot);
        LOG.info((Object)("deleteLot " + lot.getRef()));
        try {
            this.dao.delete((AbstractModel)lot);
        }
        catch (DataNotFoundException dataNotFoundException) {
            LOG.error((Object)dataNotFoundException.getMessage(), (Throwable)dataNotFoundException);
            throw new UnexpectedException((Exception)((Object)dataNotFoundException));
        }
    }

    @Override
    public void deletePartie(Partie partie) throws DataConstraintException {
        AssertTools.assertNotNull((Object)partie);
        LOG.info((Object)("deletePartie: " + partie.getNom()));
        try {
            this.dao.delete((AbstractModel)partie);
        }
        catch (DataNotFoundException dataNotFoundException) {
            LOG.error((Object)dataNotFoundException.getMessage(), (Throwable)dataNotFoundException);
            throw new UnexpectedException((Exception)((Object)dataNotFoundException));
        }
    }

    @Override
    public List<Lot> listLots(Utilisateur utilisateur) {
        AssertTools.assertNotNull((Object)utilisateur);
        if (utilisateur.getTypeDroit() == Utilisateur.TypeDroit.ADMINISTRATEUR) {
            return this.dao.readList(Lot.class, new String[]{"ref"});
        }
        return new ArrayList<Lot>(this.listLotsForUser(utilisateur));
    }

    @Override
    public SortedSet<Lot> listLotsForUser(Utilisateur utilisateur) {
        AssertTools.assertNotNull((Object)utilisateur);
        TreeSet<Lot> treeSet = new TreeSet<Lot>();
        for (Campagne campagne : utilisateur.getCampagnesCreees()) {
            treeSet.addAll(campagne.getLots());
        }
        for (Campagne campagne : utilisateur.getCampagnesDroits().keySet()) {
            treeSet.addAll(campagne.getLots());
        }
        treeSet.addAll(utilisateur.getLotsCrees());
        treeSet.addAll(utilisateur.getLotsDroits().keySet());
        return treeSet;
    }

    @Override
    public boolean updateOrdeleteLotEnabled(Lot lot, Utilisateur utilisateur) {
        return utilisateur.getTypeDroit() == Utilisateur.TypeDroit.ADMINISTRATEUR || utilisateur.getIdPersonne() == lot.getCreateur().getIdPersonne();
    }

    @Override
    public boolean isLotAccessibleByUser(Lot lot, Utilisateur utilisateur) {
        if (utilisateur.getTypeDroit() == Utilisateur.TypeDroit.ADMINISTRATEUR || utilisateur.equals(lot.getCreateur())) {
            return true;
        }
        if (utilisateur.getCampagnesCreees().contains(lot.getCampagne())) {
            return true;
        }
        if (utilisateur.getCampagnesDroits().containsKey(lot.getCampagne())) {
            return true;
        }
        return utilisateur.getLotsDroits().containsKey(lot);
    }

    @Override
    public List<Partie> listParties() {
        return this.dao.readList(Partie.class, new String[]{"nom"});
    }

    @Override
    public Lot loadLot(Integer n) throws DataNotFoundException {
        return (Lot)this.dao.read(Lot.class, (Serializable)n);
    }

    @Override
    public Lot loadLot(String string) throws DataNotFoundException {
        AssertTools.assertNotEmpty((String)string);
        return (Lot)this.dao.read(Lot.class, "ref", (Serializable)((Object)string));
    }

    @Override
    public Partie loadPartie(Integer n) throws DataNotFoundException {
        return (Partie)this.dao.read(Partie.class, (Serializable)n);
    }

    @Override
    public Partie loadPartie(String string) throws DataNotFoundException {
        return (Partie)this.dao.read(Partie.class, "nom", (Serializable)((Object)string));
    }

    @Override
    public void updateLot(Lot lot) throws DataConstraintException {
        LOG.info((Object)("updateLot " + lot.getRef()));
        try {
            this.dao.update((AbstractModel)lot);
        }
        catch (DataNotFoundException dataNotFoundException) {
            LOG.error((Object)dataNotFoundException.getMessage(), (Throwable)dataNotFoundException);
            throw new UnexpectedException((Exception)((Object)dataNotFoundException));
        }
    }

    @Override
    public void updatePartie(Partie partie) throws DataConstraintException {
        LOG.info((Object)("updatePartie: " + partie.getNom()));
        try {
            this.dao.update((AbstractModel)partie);
        }
        catch (DataNotFoundException dataNotFoundException) {
            LOG.error((Object)dataNotFoundException.getMessage(), (Throwable)dataNotFoundException);
            throw new UnexpectedException((Exception)((Object)dataNotFoundException));
        }
    }
}

