/*
 * Decompiled with CFR 0.152.
 */
package nc.ird.cantharella.service.services.impl;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;
import nc.ird.cantharella.data.dao.GenericDao;
import nc.ird.cantharella.data.dao.impl.ExtractionDao;
import nc.ird.cantharella.data.exceptions.DataConstraintException;
import nc.ird.cantharella.data.exceptions.DataNotFoundException;
import nc.ird.cantharella.data.exceptions.UnexpectedException;
import nc.ird.cantharella.data.model.Extraction;
import nc.ird.cantharella.data.model.Extrait;
import nc.ird.cantharella.data.model.Lot;
import nc.ird.cantharella.data.model.MethodeExtraction;
import nc.ird.cantharella.data.model.TypeExtrait;
import nc.ird.cantharella.data.model.Utilisateur;
import nc.ird.cantharella.data.model.utils.AbstractModel;
import nc.ird.cantharella.service.services.ExtractionService;
import nc.ird.cantharella.service.services.LotService;
import nc.ird.module.utils.AssertTools;
import nc.ird.module.utils.LogTools;
import org.apache.commons.logging.Log;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public final class ExtractionServiceImpl
implements ExtractionService {
    private static final Log LOG = LogTools.getLog();
    @Autowired
    private GenericDao dao;
    @Autowired
    private LotService lotService;

    @Override
    public long countExtractions() {
        return this.dao.count(Extraction.class);
    }

    @Override
    public void createExtraction(Extraction extraction) throws DataConstraintException {
        LOG.info((Object)("createExtraction: " + extraction.getRef()));
        this.dao.create((AbstractModel)extraction);
    }

    @Override
    public void deleteExtraction(Extraction extraction) throws DataConstraintException {
        AssertTools.assertNotNull((Object)extraction);
        LOG.info((Object)("deleteExtraction: " + extraction.getRef()));
        try {
            this.dao.delete((AbstractModel)extraction);
        }
        catch (DataNotFoundException dataNotFoundException) {
            LOG.error((Object)dataNotFoundException.getMessage(), (Throwable)dataNotFoundException);
            throw new UnexpectedException((Exception)((Object)dataNotFoundException));
        }
    }

    @Override
    public List<Extraction> listExtractions(Utilisateur utilisateur) {
        AssertTools.assertNotNull((Object)utilisateur);
        if (utilisateur.getTypeDroit() == Utilisateur.TypeDroit.ADMINISTRATEUR) {
            TreeSet treeSet = new TreeSet(this.dao.readList(Extraction.class));
            return new ArrayList<Extraction>(treeSet);
        }
        return new ArrayList<Extraction>(this.listExtractionsForUser(utilisateur));
    }

    @Override
    public SortedSet<Extraction> listExtractionsForUser(Utilisateur utilisateur) {
        AssertTools.assertNotNull((Object)utilisateur);
        TreeSet<Extraction> treeSet = new TreeSet<Extraction>();
        treeSet.addAll(utilisateur.getExtractionsCrees());
        SortedSet<Lot> sortedSet = this.lotService.listLotsForUser(utilisateur);
        for (Lot lot : sortedSet) {
            treeSet.addAll(lot.getExtractions());
        }
        return treeSet;
    }

    @Override
    public boolean isExtractionUnique(Extraction extraction) {
        Extraction extraction2;
        AssertTools.assertNotNull((Object)extraction);
        if (!this.dao.exists(Extraction.class, "ref", (Serializable)((Object)extraction.getRef()))) {
            return true;
        }
        try {
            extraction2 = (Extraction)this.dao.read(Extraction.class, "ref", (Serializable)((Object)extraction.getRef()));
            this.dao.evict((AbstractModel)extraction2);
        }
        catch (DataNotFoundException dataNotFoundException) {
            return true;
        }
        return extraction.getIdExtraction() != null && extraction.getIdExtraction().equals(extraction2.getIdExtraction());
    }

    @Override
    public Extraction loadExtraction(Integer n) throws DataNotFoundException {
        LOG.debug((Object)"read Extraction");
        return (Extraction)this.dao.read(Extraction.class, (Serializable)n);
    }

    @Override
    public Extraction loadExtraction(String string) throws DataNotFoundException {
        return (Extraction)this.dao.read(Extraction.class, "ref", (Serializable)((Object)string));
    }

    @Override
    public void updateExtraction(Extraction extraction) throws DataConstraintException {
        LOG.info((Object)("updateExtraction: " + extraction.getRef()));
        try {
            this.dao.update((AbstractModel)extraction);
        }
        catch (DataNotFoundException dataNotFoundException) {
            LOG.error((Object)dataNotFoundException.getMessage(), (Throwable)dataNotFoundException);
            throw new UnexpectedException((Exception)((Object)dataNotFoundException));
        }
    }

    @Override
    public boolean updateOrdeleteExtractionEnabled(Extraction extraction, Utilisateur utilisateur) {
        return utilisateur.getTypeDroit() == Utilisateur.TypeDroit.ADMINISTRATEUR || utilisateur.getIdPersonne() == extraction.getCreateur().getIdPersonne();
    }

    @Override
    public void createMethodeExtraction(MethodeExtraction methodeExtraction) throws DataConstraintException {
        LOG.info((Object)("createMethodeExtraction: " + methodeExtraction.getNom()));
        this.dao.create((AbstractModel)methodeExtraction);
    }

    @Override
    public void deleteMethodeExtraction(MethodeExtraction methodeExtraction) throws DataConstraintException {
        AssertTools.assertNotNull((Object)methodeExtraction);
        LOG.info((Object)("deleteMethodeExtraction: " + methodeExtraction.getNom()));
        try {
            this.dao.delete((AbstractModel)methodeExtraction);
        }
        catch (DataNotFoundException dataNotFoundException) {
            LOG.error((Object)dataNotFoundException.getMessage(), (Throwable)dataNotFoundException);
            throw new UnexpectedException((Exception)((Object)dataNotFoundException));
        }
    }

    @Override
    public List<MethodeExtraction> listMethodesExtraction() {
        return this.dao.readList(MethodeExtraction.class, new String[]{"nom"});
    }

    @Override
    public MethodeExtraction loadMethodeExtraction(Integer n) throws DataNotFoundException {
        return (MethodeExtraction)this.dao.read(MethodeExtraction.class, (Serializable)n);
    }

    @Override
    public MethodeExtraction loadMethodeExtraction(String string) throws DataNotFoundException {
        return (MethodeExtraction)this.dao.read(MethodeExtraction.class, "nom", (Serializable)((Object)string));
    }

    @Override
    public void updateMethodeExtraction(MethodeExtraction methodeExtraction) throws DataConstraintException {
        LOG.info((Object)("updateMethodeExtraction: " + methodeExtraction.getNom()));
        try {
            this.dao.update((AbstractModel)methodeExtraction);
        }
        catch (DataNotFoundException dataNotFoundException) {
            LOG.error((Object)dataNotFoundException.getMessage(), (Throwable)dataNotFoundException);
            throw new UnexpectedException((Exception)((Object)dataNotFoundException));
        }
    }

    @Override
    public void refreshMethodeExtraction(MethodeExtraction methodeExtraction) {
        AssertTools.assertNotNull((Object)methodeExtraction);
        this.dao.refresh((AbstractModel)methodeExtraction);
    }

    @Override
    public boolean isTypeExtraitReferenced(TypeExtrait typeExtrait) {
        AssertTools.assertNotNull((Object)typeExtrait);
        AssertTools.assertNotNull((Object)typeExtrait.getIdTypeExtrait());
        return this.dao.count(ExtractionDao.getCriteriaCountExtraitOfTypeExtrait((Integer)typeExtrait.getIdTypeExtrait())) > 0L;
    }

    @Override
    public boolean isExtraitUnique(Extrait extrait) {
        Extrait extrait2;
        AssertTools.assertNotNull((Object)extrait);
        if (!this.dao.exists(Extrait.class, "ref", (Serializable)((Object)extrait.getRef()))) {
            return true;
        }
        try {
            extrait2 = (Extrait)this.dao.read(Extrait.class, "ref", (Serializable)((Object)extrait.getRef()));
            this.dao.evict((AbstractModel)extrait2);
        }
        catch (DataNotFoundException dataNotFoundException) {
            return true;
        }
        return extrait.getId() != null && extrait.getId().equals(extrait2.getId());
    }
}

