/*
 * Decompiled with CFR 0.152.
 */
package nc.ird.cantharella.service.services;

import java.util.List;
import java.util.SortedSet;
import nc.ird.cantharella.data.exceptions.DataConstraintException;
import nc.ird.cantharella.data.exceptions.DataNotFoundException;
import nc.ird.cantharella.data.model.Lot;
import nc.ird.cantharella.data.model.Partie;
import nc.ird.cantharella.data.model.Utilisateur;
import nc.ird.cantharella.service.utils.normalizers.LotNormalizer;
import nc.ird.cantharella.service.utils.normalizers.PartieNormalizer;
import nc.ird.cantharella.service.utils.normalizers.UniqueFieldNormalizer;
import nc.ird.cantharella.service.utils.normalizers.utils.Normalize;
import org.springframework.transaction.annotation.Transactional;

public interface LotService {
    public long countLots();

    public void createLot(@Normalize(value=LotNormalizer.class) Lot var1) throws DataConstraintException;

    public void deleteLot(Lot var1) throws DataConstraintException;

    @Transactional(readOnly=true)
    public List<Lot> listLots(Utilisateur var1);

    public SortedSet<Lot> listLotsForUser(Utilisateur var1);

    public boolean updateOrdeleteLotEnabled(Lot var1, Utilisateur var2);

    public boolean isLotAccessibleByUser(Lot var1, Utilisateur var2);

    @Transactional(readOnly=true)
    public List<Partie> listParties();

    public Lot loadLot(Integer var1) throws DataNotFoundException;

    public Lot loadLot(@Normalize(value=UniqueFieldNormalizer.class) String var1) throws DataNotFoundException;

    public void updateLot(@Normalize(value=LotNormalizer.class) Lot var1) throws DataConstraintException;

    public void createPartie(@Normalize(value=PartieNormalizer.class) Partie var1) throws DataConstraintException;

    public Partie loadPartie(Integer var1) throws DataNotFoundException;

    public Partie loadPartie(@Normalize(value=UniqueFieldNormalizer.class) String var1) throws DataNotFoundException;

    public void updatePartie(@Normalize(value=PartieNormalizer.class) Partie var1) throws DataConstraintException;

    public void deletePartie(Partie var1) throws DataConstraintException;
}

