/*
 * Decompiled with CFR 0.152.
 */
package nc.ird.cantharella.service.config;

import java.util.Properties;
import nc.ird.cantharella.data.config.DataContext;
import nc.ird.cantharella.data.model.Utilisateur;
import nc.ird.cantharella.service.utils.normalizers.PersonneNormalizer;
import nc.ird.cantharella.service.utils.normalizers.utils.Normalizer;
import nc.ird.module.utils.PasswordTools;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.MessageSource;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.context.annotation.ImportResource;
import org.springframework.context.support.MessageSourceAccessor;
import org.springframework.context.support.ReloadableResourceBundleMessageSource;
import org.springframework.mail.MailSender;
import org.springframework.mail.SimpleMailMessage;
import org.springframework.mail.javamail.JavaMailSenderImpl;

@Import(value={DataContext.class})
@ImportResource(value={"classpath:/serviceContext.xml"})
@ComponentScan(basePackages={"nc.ird.cantharella.service.services", "nc.ird.cantharella.service.utils"})
@Configuration
public abstract class ServiceContext {
    private static final int MAIL_SMTP_PORT = 25;
    private static final int MAIL_SMTP_TIMEOUT = 10000;
    private static boolean mailActivated = true;
    @Value(value="${admin.courriel}")
    protected String adminCourrielProperty;
    @Value(value="${admin.password}")
    protected String adminPasswordProperty;
    @Value(value="${mail.debug}")
    protected boolean mailDebugProperty;
    @Value(value="${mail.from}")
    protected String mailFromProperty;
    @Value(value="${mail.host}")
    protected String mailHostProperty;

    public static final boolean isMailActivated() {
        return mailActivated;
    }

    public static final void setMailActivated(boolean bl) {
        mailActivated = bl;
    }

    @Bean
    public Utilisateur defaultAdmin() {
        Utilisateur utilisateur = new Utilisateur();
        utilisateur.setTypeDroit(Utilisateur.TypeDroit.ADMINISTRATEUR);
        utilisateur.setAdressePostale("BP A5");
        utilisateur.setCodePostal("98848");
        utilisateur.setCourriel(this.adminCourrielProperty);
        utilisateur.setNom("ADMIN");
        utilisateur.setOrganisme("IRD");
        utilisateur.setPasswordHash(PasswordTools.sha1((String)this.adminPasswordProperty));
        utilisateur.setCodePays("FR");
        utilisateur.setPrenom("Admin");
        utilisateur.setVille("Noum\u00e9a");
        Normalizer.normalize(PersonneNormalizer.class, utilisateur);
        return utilisateur;
    }

    @Bean
    public SimpleMailMessage mailMessage() {
        SimpleMailMessage simpleMailMessage = new SimpleMailMessage();
        simpleMailMessage.setFrom(this.mailFromProperty);
        return simpleMailMessage;
    }

    @Bean
    public MailSender mailSender() {
        JavaMailSenderImpl javaMailSenderImpl = new JavaMailSenderImpl();
        Properties properties = new Properties();
        properties.put("mail.debug", (Object)this.mailDebugProperty);
        properties.put("mail.smtp.connectiontimeout", (Object)10000);
        properties.put("mail.smtp.timeout", (Object)10000);
        properties.put("mail.smtp.reportsuccess", Boolean.TRUE);
        javaMailSenderImpl.setJavaMailProperties(properties);
        javaMailSenderImpl.setHost(this.mailHostProperty);
        javaMailSenderImpl.setPort(25);
        javaMailSenderImpl.setDefaultEncoding(DataContext.ENCODING);
        javaMailSenderImpl.setProtocol("smtp");
        return javaMailSenderImpl;
    }

    @Bean
    public MessageSourceAccessor serviceMessageSource() {
        ReloadableResourceBundleMessageSource reloadableResourceBundleMessageSource = new ReloadableResourceBundleMessageSource();
        reloadableResourceBundleMessageSource.setBasename("service");
        reloadableResourceBundleMessageSource.setDefaultEncoding(DataContext.ENCODING);
        reloadableResourceBundleMessageSource.setCacheSeconds(-1);
        return new MessageSourceAccessor((MessageSource)reloadableResourceBundleMessageSource);
    }
}

