/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.util;

import io.undertow.UndertowLogger;
import io.undertow.UndertowMessages;
import io.undertow.server.handlers.Cookie;
import io.undertow.server.handlers.CookieImpl;
import io.undertow.util.DateUtils;
import io.undertow.util.LegacyCookieSupport;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public class Cookies {
    public static final String DOMAIN = "$Domain";
    public static final String VERSION = "$Version";
    public static final String PATH = "$Path";

    public static Cookie parseSetCookieHeader(String headerValue) {
        String key = null;
        CookieImpl cookie = null;
        int state = 0;
        int current = 0;
        block5: for (int i = 0; i < headerValue.length(); ++i) {
            char c = headerValue.charAt(i);
            switch (state) {
                case 0: {
                    if (c == '=') {
                        key = headerValue.substring(current, i);
                        current = i + 1;
                        state = 1;
                        continue block5;
                    }
                    if ((c == ';' || c == ' ') && current == i) {
                        ++current;
                        continue block5;
                    }
                    if (c != ';') continue block5;
                    if (cookie == null) {
                        throw UndertowMessages.MESSAGES.couldNotParseCookie(headerValue);
                    }
                    Cookies.handleValue(cookie, headerValue.substring(current, i), null);
                    current = i + 1;
                    continue block5;
                }
                case 1: {
                    if (c == ';') {
                        if (cookie == null) {
                            cookie = new CookieImpl(key, headerValue.substring(current, i));
                        } else {
                            Cookies.handleValue(cookie, key, headerValue.substring(current, i));
                        }
                        state = 0;
                        current = i + 1;
                        key = null;
                        continue block5;
                    }
                    if (c != '\"' || current != i) continue block5;
                    ++current;
                    state = 2;
                    continue block5;
                }
                case 2: {
                    if (c != '\"') continue block5;
                    if (cookie == null) {
                        cookie = new CookieImpl(key, headerValue.substring(current, i));
                    } else {
                        Cookies.handleValue(cookie, key, headerValue.substring(current, i));
                    }
                    state = 0;
                    current = i + 1;
                    key = null;
                }
            }
        }
        if (key == null) {
            if (current != headerValue.length()) {
                Cookies.handleValue(cookie, headerValue.substring(current, headerValue.length()), null);
            }
        } else if (current != headerValue.length()) {
            if (cookie == null) {
                cookie = new CookieImpl(key, headerValue.substring(current, headerValue.length()));
            } else {
                Cookies.handleValue(cookie, key, headerValue.substring(current, headerValue.length()));
            }
        } else {
            Cookies.handleValue(cookie, key, null);
        }
        return cookie;
    }

    private static void handleValue(CookieImpl cookie, String key, String value) {
        if (key.equalsIgnoreCase("path")) {
            cookie.setPath(value);
        } else if (key.equalsIgnoreCase("domain")) {
            cookie.setDomain(value);
        } else if (key.equalsIgnoreCase("max-age")) {
            cookie.setMaxAge(Integer.parseInt(value));
        } else if (key.equalsIgnoreCase("expires")) {
            cookie.setExpires(DateUtils.parseDate(value));
        } else if (key.equalsIgnoreCase("discard")) {
            cookie.setDiscard(true);
        } else if (key.equalsIgnoreCase("secure")) {
            cookie.setSecure(true);
        } else if (key.equalsIgnoreCase("httpOnly")) {
            cookie.setHttpOnly(true);
        } else if (key.equalsIgnoreCase("version")) {
            cookie.setVersion(Integer.parseInt(value));
        } else if (key.equalsIgnoreCase("comment")) {
            cookie.setComment(value);
        }
    }

    public static Map<String, Cookie> parseRequestCookies(int maxCookies, boolean allowEqualInValue, List<String> cookies) {
        return Cookies.parseRequestCookies(maxCookies, allowEqualInValue, cookies, LegacyCookieSupport.COMMA_IS_SEPARATOR);
    }

    static Map<String, Cookie> parseRequestCookies(int maxCookies, boolean allowEqualInValue, List<String> cookies, boolean commaIsSeperator) {
        if (cookies == null) {
            return new TreeMap<String, Cookie>();
        }
        TreeMap<String, Cookie> parsedCookies = new TreeMap<String, Cookie>();
        for (String cookie : cookies) {
            Cookies.parseCookie(cookie, parsedCookies, maxCookies, allowEqualInValue, commaIsSeperator);
        }
        return parsedCookies;
    }

    private static void parseCookie(String cookie, Map<String, Cookie> parsedCookies, int maxCookies, boolean allowEqualInValue, boolean commaIsSeperator) {
        int state = 0;
        String name = null;
        int start = 0;
        int cookieCount = parsedCookies.size();
        HashMap<String, String> cookies = new HashMap<String, String>();
        HashMap<String, String> additional = new HashMap<String, String>();
        block7: for (int i = 0; i < cookie.length(); ++i) {
            char c = cookie.charAt(i);
            switch (state) {
                case 0: {
                    if (c == ' ' || c == '\t' || c == ';') {
                        start = i + 1;
                        continue block7;
                    }
                    state = 1;
                }
                case 1: {
                    if (c == '=') {
                        name = cookie.substring(start, i);
                        start = i + 1;
                        state = 2;
                        continue block7;
                    }
                    if (c != ';' && (!commaIsSeperator || c != ',')) continue block7;
                    if (name != null) {
                        cookieCount = Cookies.createCookie(name, cookie.substring(start, i), maxCookies, cookieCount, cookies, additional);
                    } else if (UndertowLogger.REQUEST_LOGGER.isTraceEnabled()) {
                        UndertowLogger.REQUEST_LOGGER.trace("Ignoring invalid cookies in header " + cookie);
                    }
                    state = 0;
                    start = i + 1;
                    continue block7;
                }
                case 2: {
                    if (c == ';' || commaIsSeperator && c == ',') {
                        cookieCount = Cookies.createCookie(name, cookie.substring(start, i), maxCookies, cookieCount, cookies, additional);
                        state = 0;
                        start = i + 1;
                        continue block7;
                    }
                    if (c == '\"' && start == i) {
                        state = 3;
                        start = i + 1;
                        continue block7;
                    }
                    if (allowEqualInValue || c != '=') continue block7;
                    cookieCount = Cookies.createCookie(name, cookie.substring(start, i), maxCookies, cookieCount, cookies, additional);
                    state = 4;
                    start = i + 1;
                    continue block7;
                }
                case 3: {
                    if (c != '\"') continue block7;
                    cookieCount = Cookies.createCookie(name, cookie.substring(start, i), maxCookies, cookieCount, cookies, additional);
                    state = 0;
                    start = i + 1;
                    continue block7;
                }
                case 4: {
                    if (c == ';' || commaIsSeperator && c == ',') {
                        state = 0;
                    }
                    start = i + 1;
                }
            }
        }
        if (state == 2) {
            Cookies.createCookie(name, cookie.substring(start), maxCookies, cookieCount, cookies, additional);
        }
        for (Map.Entry entry : cookies.entrySet()) {
            String path;
            String version;
            CookieImpl c = new CookieImpl((String)entry.getKey(), (String)entry.getValue());
            String domain = (String)additional.get(DOMAIN);
            if (domain != null) {
                c.setDomain(domain);
            }
            if ((version = (String)additional.get(VERSION)) != null) {
                c.setVersion(Integer.parseInt(version));
            }
            if ((path = (String)additional.get(PATH)) != null) {
                c.setPath(path);
            }
            parsedCookies.put(c.getName(), c);
        }
    }

    private static int createCookie(String name, String value, int maxCookies, int cookieCount, Map<String, String> cookies, Map<String, String> additional) {
        if (!name.isEmpty() && name.charAt(0) == '$') {
            if (additional.containsKey(name)) {
                return cookieCount;
            }
            additional.put(name, value);
            return cookieCount;
        }
        if (cookieCount == maxCookies) {
            throw UndertowMessages.MESSAGES.tooManyCookies(maxCookies);
        }
        if (cookies.containsKey(name)) {
            return cookieCount;
        }
        cookies.put(name, value);
        return ++cookieCount;
    }

    private Cookies() {
    }
}

