/*
 * Decompiled with CFR 0.152.
 */
package io.ultreia.maven.gitlab.model;

import java.net.MalformedURLException;
import java.net.URL;
import org.apache.commons.lang3.StringUtils;

public class ReleaseArtifactModel {
    private String groupId;
    private String artifactId;
    private String type;
    private String classifier;
    private String name;
    private boolean flatLayout;

    public boolean isFlatLayout() {
        return this.flatLayout;
    }

    public void setFlatLayout(boolean flatLayout) {
        this.flatLayout = flatLayout;
    }

    public String getGroupId() {
        return this.groupId;
    }

    public String getArtifactId() {
        return this.artifactId;
    }

    public String getType() {
        return this.type;
    }

    public String getClassifier() {
        return this.classifier;
    }

    public String getName() {
        return this.name;
    }

    public URL getUrl(String host, String version, boolean flatLayout) {
        try {
            if (flatLayout) {
                return new URL(String.format("%s/%s%s-%s.%s", host, this.artifactId, StringUtils.isEmpty((CharSequence)this.classifier) ? "" : "-" + this.classifier, version, this.type));
            }
            return new URL(String.format("%s/%s/%s/%s/%s%s-%s.%s", host, this.groupId.replaceAll("\\.", "/"), this.artifactId, version, this.artifactId, StringUtils.isEmpty((CharSequence)this.classifier) ? "" : "-" + this.classifier, version, this.type));
        }
        catch (MalformedURLException e) {
            throw new IllegalStateException(e);
        }
    }

    public void setGroupId(String groupId) {
        this.groupId = groupId;
    }

    public void setArtifactId(String artifactId) {
        this.artifactId = artifactId;
    }

    public void setType(String type) {
        this.type = type;
    }

    public void setClassifier(String classifier) {
        this.classifier = classifier;
    }

    public void setName(String name) {
        this.name = name;
    }
}

