/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.maven.polyglot.groovy.builder.factory;

import groovy.util.FactoryBuilderSupport;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.maven.model.Extension;
import org.sonatype.maven.polyglot.groovy.builder.factory.ExtensionFactory;
import org.sonatype.maven.polyglot.groovy.builder.factory.ListFactory;
import org.sonatype.maven.polyglot.groovy.builder.factory.NamedFactory;

public class ExtensionsFactory
extends ListFactory {
    public ExtensionsFactory() {
        super("extensions");
    }

    @Override
    public Object newInstance(FactoryBuilderSupport builder, Object name, Object value, Map attrs) throws InstantiationException, IllegalAccessException {
        ArrayList node;
        if (value != null) {
            node = ExtensionsFactory.parse(value);
            if (node == null) {
                throw new NamedFactory.NodeValueParseException(this, value);
            }
        } else {
            node = new ArrayList();
        }
        return node;
    }

    public static Object parse(Object value) {
        assert (value != null);
        if (value instanceof String && ExtensionsFactory.isBoolean((String)value)) {
            return value;
        }
        if (value instanceof String) {
            Extension child = ExtensionFactory.parse(value);
            if (child != null) {
                ArrayList<Extension> node = new ArrayList<Extension>();
                node.add(child);
                return node;
            }
        } else if (value instanceof List) {
            ArrayList<Extension> node = new ArrayList<Extension>();
            for (Object item : (List)value) {
                Extension child = ExtensionFactory.parse(item);
                if (child == null) {
                    return null;
                }
                node.add(child);
            }
            return node;
        }
        return null;
    }

    private static boolean isBoolean(String value) {
        return value.equalsIgnoreCase("true") || value.equalsIgnoreCase("false");
    }
}

