/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.codegen.v3.generators.util;

import io.swagger.codegen.v3.CodegenProperty;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.media.Schema;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class OpenAPIUtil {
    public static void addPropertiesFromRef(OpenAPI openAPI, Schema refSchema, CodegenProperty codegenProperty) {
        Map allSchemas = openAPI.getComponents().getSchemas();
        if (allSchemas == null || allSchemas.isEmpty()) {
            return;
        }
        Schema schema = (Schema)allSchemas.get(OpenAPIUtil.getSimpleRef(refSchema.get$ref()));
        if (schema == null) {
            return;
        }
        codegenProperty.pattern = schema.getPattern();
        codegenProperty.minLength = schema.getMinLength();
        codegenProperty.maxLength = schema.getMaxLength();
        if (codegenProperty.pattern != null || codegenProperty.minLength != null || codegenProperty.maxLength != null) {
            codegenProperty.getVendorExtensions().put("x-has-validation", Boolean.TRUE);
        }
    }

    public static String getSimpleRef(String ref) {
        if (ref.startsWith("#/components/")) {
            ref = ref.substring(ref.lastIndexOf("/") + 1);
        }
        return ref;
    }

    public static Schema getSchemaFromName(String name, OpenAPI openAPI) {
        if (openAPI.getComponents() == null) {
            return null;
        }
        Map mapSchema = openAPI.getComponents().getSchemas();
        if (mapSchema == null || mapSchema.isEmpty()) {
            return null;
        }
        return (Schema)mapSchema.get(name);
    }

    public static Schema getSchemaFromRefSchema(Schema refSchema, OpenAPI openAPI) {
        if (StringUtils.isBlank((CharSequence)refSchema.get$ref())) {
            return null;
        }
        String name = OpenAPIUtil.getSimpleRef(refSchema.get$ref());
        return OpenAPIUtil.getSchemaFromName(name, openAPI);
    }
}

