/*
 * Decompiled with CFR 0.152.
 */
package io.sundr.model;

import io.sundr.model.AttributeKey;
import io.sundr.model.AttributeSupport;
import io.sundr.model.Modifiers;
import java.util.Map;

public class ModifierSupport
extends AttributeSupport {
    public static final String ABSTRACT = "abstract";
    public static final String PUBLIC = "public";
    public static final String PROTECTED = "protected";
    public static final String PRIVATE = "private";
    public static final String STATIC = "static";
    public static final String FINAL = "final";
    public static final String SYNCHRONIZED = "synchronized";
    protected final Modifiers modifiers;

    public ModifierSupport(Modifiers modifiers, Map<AttributeKey, Object> attributes) {
        super(attributes);
        this.modifiers = modifiers != null ? modifiers : Modifiers.create();
    }

    public boolean isPrivate() {
        return this.modifiers.isPrivate();
    }

    public boolean isProtected() {
        return this.modifiers.isProtected();
    }

    public boolean isPublic() {
        return this.modifiers.isPublic();
    }

    public boolean isFinal() {
        return this.modifiers.isFinal();
    }

    public boolean isStatic() {
        return this.modifiers.isStatic();
    }

    public boolean isAbstract() {
        return this.modifiers.isAbstract();
    }

    public boolean isSynchronized() {
        return this.modifiers.isSynchronized();
    }

    public boolean isTransient() {
        return this.modifiers.isTransient();
    }

    public boolean isNative() {
        return this.modifiers.isTransient();
    }

    public Modifiers getModifiers() {
        return this.modifiers;
    }

    public void renderModifiers(StringBuilder sb) {
        if (this.isPublic()) {
            sb.append(PUBLIC).append(" ");
        } else if (this.isProtected()) {
            sb.append(PROTECTED).append(" ");
        } else if (this.isPrivate()) {
            sb.append(PRIVATE).append(" ");
        }
        if (this.isSynchronized()) {
            sb.append(SYNCHRONIZED).append(" ");
        }
        if (this.isStatic()) {
            sb.append(STATIC).append(" ");
        }
        if (this.isAbstract()) {
            sb.append(ABSTRACT).append(" ");
        }
        if (this.isFinal()) {
            sb.append(FINAL).append(" ");
        }
    }

    public String renderModifiers() {
        StringBuilder sb = new StringBuilder();
        this.renderModifiers(sb);
        return sb.toString();
    }
}

