/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.faulttolerance.config;

import io.smallrye.faulttolerance.config.GenericConfig;
import java.lang.reflect.Method;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.enterprise.inject.spi.AnnotatedMethod;
import org.eclipse.microprofile.faulttolerance.Retry;
import org.eclipse.microprofile.faulttolerance.exceptions.FaultToleranceDefinitionException;

public class RetryConfig
extends GenericConfig<Retry> {
    public static final String MAX_RETRIES = "maxRetries";
    public static final String DELAY = "delay";
    public static final String DELAY_UNIT = "delayUnit";
    public static final String MAX_DURATION = "maxDuration";
    public static final String DURATION_UNIT = "durationUnit";
    public static final String JITTER = "jitter";
    public static final String JITTER_DELAY_UNIT = "jitterDelayUnit";
    public static final String RETRY_ON = "retryOn";
    public static final String ABORT_ON = "abortOn";
    private static final String INVALID_RETRY_ON = "Invalid @Retry on ";
    private static Map<String, Class<?>> keys2Type = RetryConfig.initKeys();

    public RetryConfig(Class<?> beanClass, Method method) {
        super(Retry.class, beanClass, method);
    }

    public RetryConfig(AnnotatedMethod<?> annotatedMethod) {
        super(Retry.class, annotatedMethod);
    }

    @Override
    public void validate() {
        long delay;
        if (this.get(MAX_RETRIES, Integer.class) < -1) {
            throw new FaultToleranceDefinitionException(INVALID_RETRY_ON + this.getMethodInfo() + " : maxRetries shouldn't be lower than -1");
        }
        if (this.get(DELAY, Long.class) < 0L) {
            throw new FaultToleranceDefinitionException(INVALID_RETRY_ON + this.getMethodInfo() + " : delay shouldn't be lower than 0");
        }
        if (this.get(MAX_DURATION, Long.class) < 0L) {
            throw new FaultToleranceDefinitionException(INVALID_RETRY_ON + this.getMethodInfo() + " : maxDuration shouldn't be lower than 0");
        }
        long maxDuration = Duration.of(this.get(MAX_DURATION, Long.class), this.get(DURATION_UNIT, ChronoUnit.class)).toMillis();
        if (maxDuration <= (delay = Duration.of(this.get(DELAY, Long.class), this.get(DELAY_UNIT, ChronoUnit.class)).toMillis())) {
            throw new FaultToleranceDefinitionException(INVALID_RETRY_ON + this.getMethodInfo() + " : maxDuration should be greater than delay");
        }
        if (this.get(JITTER, Long.class) < 0L) {
            throw new FaultToleranceDefinitionException(INVALID_RETRY_ON + this.getMethodInfo() + " : jitter shouldn't be lower than 0");
        }
    }

    @Override
    protected Map<String, Class<?>> getKeysToType() {
        return keys2Type;
    }

    private static Map<String, Class<?>> initKeys() {
        HashMap<String, Class<Class[]>> keys = new HashMap<String, Class<Class[]>>();
        keys.put(MAX_RETRIES, Integer.class);
        keys.put(DELAY, Long.class);
        keys.put(DELAY_UNIT, ChronoUnit.class);
        keys.put(MAX_DURATION, Long.class);
        keys.put(DURATION_UNIT, ChronoUnit.class);
        keys.put(JITTER, Long.class);
        keys.put(JITTER_DELAY_UNIT, ChronoUnit.class);
        keys.put(RETRY_ON, Class[].class);
        keys.put(ABORT_ON, Class[].class);
        return Collections.unmodifiableMap(keys);
    }
}

