package io.vertx.mutiny.ext.web.handler;

import java.util.Map;
import java.util.stream.Collectors;
import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.Uni;
import java.util.function.Consumer;
import io.smallrye.mutiny.vertx.TypeArg;
import io.vertx.codegen.annotations.Fluent;
import io.smallrye.common.annotation.CheckReturnValue;
import io.vertx.core.Handler;

/**
 * HTTP Strict Transport Security (HSTS) <a href="http://tools.ietf.org/html/rfc6797">RFC6797</a>.
 *
 * This handler adds the strict transport security headers, for this domain or subdomains.
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.ext.web.handler.HSTSHandler original} non Mutiny-ified interface using Vert.x codegen.
 */

@io.smallrye.mutiny.vertx.MutinyGen(io.vertx.ext.web.handler.HSTSHandler.class)
public class HSTSHandler implements io.vertx.core.Handler<io.vertx.mutiny.ext.web.RoutingContext>, java.util.function.Consumer<io.vertx.mutiny.ext.web.RoutingContext> {

  public static final io.smallrye.mutiny.vertx.TypeArg<HSTSHandler> __TYPE_ARG = new io.smallrye.mutiny.vertx.TypeArg<>(    obj -> new HSTSHandler((io.vertx.ext.web.handler.HSTSHandler) obj),
    HSTSHandler::getDelegate
  );

  private final io.vertx.ext.web.handler.HSTSHandler delegate;
  
  public HSTSHandler(io.vertx.ext.web.handler.HSTSHandler delegate) {
    this.delegate = delegate;
  }

  public HSTSHandler(Object delegate) {
    this.delegate = (io.vertx.ext.web.handler.HSTSHandler)delegate;
  }

  /**
   * Empty constructor used by CDI, do not use this constructor directly.
   **/
  HSTSHandler() {
    this.delegate = null;
  }

  public io.vertx.ext.web.handler.HSTSHandler getDelegate() {
    return delegate;
  }

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    HSTSHandler that = (HSTSHandler) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public void handle(io.vertx.mutiny.ext.web.RoutingContext arg0) { 
    delegate.handle(arg0.getDelegate());
  }

  /**
   * @param maxAge max age to attribute to the header
   * @param includeSubDomains consider sub domains when adding the header
   * @return an instance.
   */
  public static io.vertx.mutiny.ext.web.handler.HSTSHandler create(long maxAge, boolean includeSubDomains) { 
    io.vertx.mutiny.ext.web.handler.HSTSHandler ret = io.vertx.mutiny.ext.web.handler.HSTSHandler.newInstance((io.vertx.ext.web.handler.HSTSHandler)io.vertx.ext.web.handler.HSTSHandler.create(maxAge, includeSubDomains));
    return ret;
  }

  /**
   * @param includeSubDomains consider sub domains when adding the header
   * @return an instance.
   */
  public static io.vertx.mutiny.ext.web.handler.HSTSHandler create(boolean includeSubDomains) { 
    io.vertx.mutiny.ext.web.handler.HSTSHandler ret = io.vertx.mutiny.ext.web.handler.HSTSHandler.newInstance((io.vertx.ext.web.handler.HSTSHandler)io.vertx.ext.web.handler.HSTSHandler.create(includeSubDomains));
    return ret;
  }

  /**
   * @return an instance.
   */
  public static io.vertx.mutiny.ext.web.handler.HSTSHandler create() { 
    io.vertx.mutiny.ext.web.handler.HSTSHandler ret = io.vertx.mutiny.ext.web.handler.HSTSHandler.newInstance((io.vertx.ext.web.handler.HSTSHandler)io.vertx.ext.web.handler.HSTSHandler.create());
    return ret;
  }

  public static final long DEFAULT_MAX_AGE = io.vertx.ext.web.handler.HSTSHandler.DEFAULT_MAX_AGE;
  public void accept(io.vertx.mutiny.ext.web.RoutingContext item) {
    handle(item);
  }
  public static  HSTSHandler newInstance(io.vertx.ext.web.handler.HSTSHandler arg) {
    return arg != null ? new HSTSHandler(arg) : null;
  }

}
