package io.vertx.mutiny.ext.web.handler;

import java.util.Map;
import java.util.stream.Collectors;
import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.Uni;
import java.util.function.Consumer;
import io.smallrye.mutiny.vertx.TypeArg;
import io.vertx.codegen.annotations.Fluent;
import io.smallrye.common.annotation.CheckReturnValue;
import io.vertx.core.Handler;

/**
 * A handler that serves favicons.
 * <p>
 * If no file system path is specified it will attempt to serve a resource called `favicon.ico` from the classpath.
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.ext.web.handler.FaviconHandler original} non Mutiny-ified interface using Vert.x codegen.
 */

@io.smallrye.mutiny.vertx.MutinyGen(io.vertx.ext.web.handler.FaviconHandler.class)
public class FaviconHandler implements io.vertx.core.Handler<io.vertx.mutiny.ext.web.RoutingContext>, java.util.function.Consumer<io.vertx.mutiny.ext.web.RoutingContext> {

  public static final io.smallrye.mutiny.vertx.TypeArg<FaviconHandler> __TYPE_ARG = new io.smallrye.mutiny.vertx.TypeArg<>(    obj -> new FaviconHandler((io.vertx.ext.web.handler.FaviconHandler) obj),
    FaviconHandler::getDelegate
  );

  private final io.vertx.ext.web.handler.FaviconHandler delegate;
  
  public FaviconHandler(io.vertx.ext.web.handler.FaviconHandler delegate) {
    this.delegate = delegate;
  }

  public FaviconHandler(Object delegate) {
    this.delegate = (io.vertx.ext.web.handler.FaviconHandler)delegate;
  }

  /**
   * Empty constructor used by CDI, do not use this constructor directly.
   **/
  FaviconHandler() {
    this.delegate = null;
  }

  public io.vertx.ext.web.handler.FaviconHandler getDelegate() {
    return delegate;
  }

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    FaviconHandler that = (FaviconHandler) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public void handle(io.vertx.mutiny.ext.web.RoutingContext arg0) { 
    delegate.handle(arg0.getDelegate());
  }

  /**
   * @param vertx 
   * @return the handler
   */
  public static io.vertx.mutiny.ext.web.handler.FaviconHandler create(io.vertx.mutiny.core.Vertx vertx) { 
    io.vertx.mutiny.ext.web.handler.FaviconHandler ret = io.vertx.mutiny.ext.web.handler.FaviconHandler.newInstance((io.vertx.ext.web.handler.FaviconHandler)io.vertx.ext.web.handler.FaviconHandler.create(vertx.getDelegate()));
    return ret;
  }

  /**
   * @param vertx 
   * @param path the path
   * @return the handler
   */
  public static io.vertx.mutiny.ext.web.handler.FaviconHandler create(io.vertx.mutiny.core.Vertx vertx, String path) { 
    io.vertx.mutiny.ext.web.handler.FaviconHandler ret = io.vertx.mutiny.ext.web.handler.FaviconHandler.newInstance((io.vertx.ext.web.handler.FaviconHandler)io.vertx.ext.web.handler.FaviconHandler.create(vertx.getDelegate(), path));
    return ret;
  }

  /**
   * @param vertx 
   * @param path the path
   * @param maxAgeSeconds max how long the file will be cached by browser, in seconds
   * @return the handler
   */
  public static io.vertx.mutiny.ext.web.handler.FaviconHandler create(io.vertx.mutiny.core.Vertx vertx, String path, long maxAgeSeconds) { 
    io.vertx.mutiny.ext.web.handler.FaviconHandler ret = io.vertx.mutiny.ext.web.handler.FaviconHandler.newInstance((io.vertx.ext.web.handler.FaviconHandler)io.vertx.ext.web.handler.FaviconHandler.create(vertx.getDelegate(), path, maxAgeSeconds));
    return ret;
  }

  /**
   * @param vertx 
   * @param maxAgeSeconds max how long the file will be cached by browser, in seconds
   * @return the handler
   */
  public static io.vertx.mutiny.ext.web.handler.FaviconHandler create(io.vertx.mutiny.core.Vertx vertx, long maxAgeSeconds) { 
    io.vertx.mutiny.ext.web.handler.FaviconHandler ret = io.vertx.mutiny.ext.web.handler.FaviconHandler.newInstance((io.vertx.ext.web.handler.FaviconHandler)io.vertx.ext.web.handler.FaviconHandler.create(vertx.getDelegate(), maxAgeSeconds));
    return ret;
  }

  /**
   * The default max age in seconds as set in the cache-control header
   */
  public static final long DEFAULT_MAX_AGE_SECONDS = io.vertx.ext.web.handler.FaviconHandler.DEFAULT_MAX_AGE_SECONDS;
  public void accept(io.vertx.mutiny.ext.web.RoutingContext item) {
    handle(item);
  }
  public static  FaviconHandler newInstance(io.vertx.ext.web.handler.FaviconHandler arg) {
    return arg != null ? new FaviconHandler(arg) : null;
  }

}
